% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roc.R
\name{ROC_table}
\alias{ROC_table}
\title{ROC_table: extract AUC, NRI and IDI information from list of roc object in pROC packages.}
\usage{
ROC_table(ListModel, dec.auc = 3, dec.p = 3)
}
\arguments{
\item{ListModel}{list of roc object}

\item{dec.auc}{digits for AUC, Default: 3}

\item{dec.p}{digits for p value, Default: 3}
}
\value{
table of AUC, NRI and IDI information
}
\description{
extract AUC, NRI and IDI information from list of roc in pROC packages
}
\details{
extract AUC, NRI and IDI information from list of roc object in pROC packages.
}
\examples{
library(pROC)
m1 <- glm(vs ~ am + gear, data = mtcars, family = binomial)
m2 <- glm(vs ~ am + gear + wt, data = mtcars, family = binomial)
m3 <- glm(vs ~ am + gear + wt + mpg, data = mtcars, family = binomial)
roc1 <- roc(m1$y, predict(m1, type = "response"))
roc2 <- roc(m2$y, predict(m2, type = "response"))
roc3 <- roc(m3$y, predict(m3, type = "response"))
list.roc <- list(roc1, roc2, roc3)
ROC_table(list.roc)
}
\seealso{
\code{\link[pROC]{ci.auc}},\code{\link[pROC]{roc.test}}
 \code{\link[data.table]{data.table-package}}
}
