% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_model.R
\name{plot_model}
\alias{plot_model}
\title{Plot the sampling models used by irace}
\usage{
plot_model(irace_results, param_name, filename = NULL)
}
\arguments{
\item{irace_results}{The data generated when loading the \code{.Rdata} file created by \code{irace} (or the filename of that file).}

\item{param_name}{String, parameter to be included in the plot, e.g., \code{param_name = "algorithm"}}

\item{filename}{(\code{character(1)}) File name to save the plot, for example \code{"~/path/example/filename.png"}.}
}
\value{
sampling model plot
}
\description{
Display the sampling models from which irace generated parameter values for
new configurations during the configurations process.

For categorical parameters a stacked bar plot is created. This plot shows
the sampling probabilities of the parameter values for the elite
configurations in the iterations of the configuration process.

For numerical parameters a sampling distributions plot of the
numerical parameters for the elite configurations of an iteration.
This plot shows de density function of the truncated normal distributions
associated to each parameter for each elite configuration on each iteration.
}
\examples{
iraceResults <- read_logfile(system.file(package="irace", "exdata",
                                         "irace-acotsp.Rdata", mustWork = TRUE))
plot_model(iraceResults, param_name="algorithm")
\donttest{ 
plot_model(iraceResults, param_name="alpha")
}
}
