% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hyperoverlap_set.r
\name{hyperoverlap_set}
\alias{hyperoverlap_set}
\title{Pairwise overlap detection in n-dimensional space of multiple entities using support vector machines (SVMs)}
\usage{
hyperoverlap_set(x, y, kernel = "polynomial",kernel.degree = 3, cost = 1000,
stoppage.threshold = 0.2, write.to.file = FALSE,
path = NULL,
sample.dimensionality.omit = "FALSE")
}
\arguments{
\item{x}{A matrix or data.frame containing the variables of interest for both entities.}

\item{y}{A vector of labels.}

\item{kernel}{Character. Either "linear" or "polynomial" (default = "polynomial").}

\item{kernel.degree}{Parameter needed for \code{kernel = polynomial} (default = 3).}

\item{cost}{Specifies the SVM margin 'hardness'. Default value is 1000, but can be increased for improved accuracy (although this increases runtimes and memory usage).}

\item{stoppage.threshold}{Numeric. If the number of points misclassified using a linear hyperplane exceeds this proportion of the number of observations, non-linear separation is not attempted. Must be between 0 and 1 (default = 0.2).}

\item{write.to.file}{Logical. If TRUE, each \code{\link{hyperoverlap-class}} object is saved as a .rds file.}

\item{path}{Character. Path to write .rds files to. Ignored if \code{write.to.file=FALSE}}

\item{sample.dimensionality.omit}{Logical. If TRUE, omits any entity pairs with a combined sample size less than n+1, where n is the number of dimensions (see details).}
}
\value{
A long-form matrix with the following columns:
entity1,
entity2,
shape,
polynomial.order (if \code{kernel="polynomial"}),
result,
number.of.points.misclassified.

If specified, individual \code{Hyperoverlap-class} objects are written to file.
}
\description{
This function is a wrapper for \code{\link{hyperoverlap_detect}} for pairwise overlap detection between multiple entities.
}
\details{
In n dimensions, any set of points up to n+1 points can be separated using a linear hyperplane. This may produce an artefactual non-overlap result.
The \code{sample.dimensionality.omit} parameter gives two options for dealing with these pairs when they form part of a larger analysis.
If \code{sample.dimensionality.omit = "TRUE"}, this pair is removed from the analysis (result = NA).
If \code{sample.dimensionality.omit = "FALSE"}, the pair is included, but a warning is printed.
}
\examples{

data(iris)
hyperoverlap.iris.set = hyperoverlap_set(iris[1:3],iris$Species, kernel="linear")

}
