% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wl.R
\name{wlconv}
\alias{wlconv}
\alias{nm2raman}
\alias{nm2invcm}
\alias{nm2ev}
\alias{nm2freq}
\alias{invcm2raman}
\alias{invcm2nm}
\alias{invcm2ev}
\alias{invcm2freq}
\alias{raman2invcm}
\alias{raman2nm}
\alias{raman2ev}
\alias{raman2freq}
\alias{ev2raman}
\alias{ev2invcm}
\alias{ev2nm}
\alias{ev2freq}
\alias{freq2nm}
\alias{freq2invcm}
\alias{freq2ev}
\alias{freq2raman}
\title{Convert different wavelength units}
\usage{
wlconv(points, src, dst, laser = NULL)

nm2raman(x, laser)

nm2invcm(x, ...)

nm2ev(x, ...)

nm2freq(x, ...)

invcm2raman(x, laser)

invcm2nm(x, ...)

invcm2ev(x, ...)

invcm2freq(x, ...)

raman2invcm(x, laser)

raman2nm(x, laser)

raman2ev(x, laser)

raman2freq(x, laser)

ev2raman(x, laser)

ev2invcm(x, ...)

ev2nm(x, ...)

ev2freq(x, ...)

freq2nm(x, ...)

freq2invcm(x, ...)

freq2ev(x, ...)

freq2raman(x, laser)
}
\arguments{
\item{points}{data for conversion}

\item{src}{source unit}

\item{dst}{destination unit}

\item{laser}{laser wavelength (required for work with Raman shift)}

\item{x}{wavelength points for conversion}

\item{...}{ignored}
}
\description{
The following units can be converted into each other: 
\emph{nm}, \emph{\eqn{cm^{-1}}{inverse cm}}, \emph{eV}, \emph{THz} and 
\emph{Raman shift}
}
\section{Functions}{
\itemize{
\item \code{nm2raman}: conversion \strong{nanometers} -> \strong{Raman shift (relative wavenumber)}

\item \code{nm2invcm}: conversion \strong{nanometers} -> \strong{inverse cm (absolute wavenumber)}

\item \code{nm2ev}: conversion \strong{nanometers} -> \strong{electronvolt}

\item \code{nm2freq}: conversion \strong{nm} -> \strong{frequency in THz}

\item \code{invcm2raman}: conversion \strong{inverse cm (absolute wavenumber)} -> \strong{Raman shift (relative wavenumber)}

\item \code{invcm2nm}: conversion \strong{inverse cm (absolute wavenumber)} -> \strong{nanometers}

\item \code{invcm2ev}: conversion \strong{inverse cm (absolute wavenumber)} -> \strong{electronvolt}

\item \code{invcm2freq}: conversion \strong{inverse cm (absolute wavenumber)} -> \strong{frequency in THz}

\item \code{raman2invcm}: conversion \strong{Raman shift (relative wavenumber)} -> \strong{inverse cm (absolute wavenumber)}

\item \code{raman2nm}: conversion \strong{Raman shift (relative wavenumber)} -> \strong{nanometers}

\item \code{raman2ev}: conversion \strong{Raman shift (relative wavenumber)} -> \strong{electronvolt}

\item \code{raman2freq}: conversion \strong{Raman shift (relative wavenumber)} -> \strong{frequency in THz}

\item \code{ev2raman}: conversion \strong{electronvolt} -> \strong{Raman shift (relative wavenumber)}

\item \code{ev2invcm}: conversion \strong{electronvolt} -> \strong{inverse cm (absolute wavenumber)}

\item \code{ev2nm}: conversion \strong{electronvolt} -> \strong{nanometers}

\item \code{ev2freq}: conversion \strong{electronvolt} -> \strong{frequency in THz}

\item \code{freq2nm}: conversion \strong{frequency in THz} -> \strong{nanometers}

\item \code{freq2invcm}: conversion \strong{frequency in THz} -> \strong{inverse cm (absolute wavenumber)}

\item \code{freq2ev}: conversion \strong{frequency in THz} -> \strong{electronvolt}

\item \code{freq2raman}: conversion \strong{frequency in THz} -> \strong{Raman shift (relative wavenumber)}
}}

\examples{
wlconv (3200, "Raman shift", "nm", laser = 785.04)
wlconv( 785, "nm", "invcm")
}
\author{
R. Kiselev
}
