% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humarray.R
\name{ids.by.pos}
\alias{ids.by.pos}
\title{Order rs-ids or ichip ids by chrosome and position}
\usage{
ids.by.pos(ids)
}
\arguments{
\item{ids}{character, vector of SNP rs-ids or chip-ids, see rs.to.id()}
}
\value{
the same vector 'ids', sorted by genome position
}
\description{
Simple function to sort a character list of SNP ids into genome order.
}
\examples{
\donttest{
snp.ids <- c("rs3842724","imm_11_2147527","rs689","rs9467354","rs61733845")
Chr(snp.ids) # shows each is on a different chromosome
Pos(snp.ids)
ids.by.pos(snp.ids)
Chr(ids.by.pos(snp.ids))
Pos(ids.by.pos(snp.ids))
}
}
\seealso{
\code{\link{rs.to.id}}, \code{\link{id.to.rs}}, \code{\link{Chr}}, \code{\link{Pos}}
}

