% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_solve_x.R
\name{convert_solve_x}
\alias{convert_solve_x}
\title{convert_solve_x}
\usage{
convert_solve_x(
  model.output.mat,
  model = NULL,
  output.units = NULL,
  MW = NULL,
  vol = NULL,
  chem.cas = NULL,
  chem.name = NULL,
  dtxsid = NULL,
  parameters = NULL,
  monitor.vars = NULL,
  suppress.messages = FALSE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{model.output.mat}{Matrix of results from HTTK solve_model function.}

\item{model}{Specified model to use in simulation: "pbtk", "3compartment",
"3compartmentss", "1compartment", "schmitt", ...}

\item{output.units}{Output units of interest for the compiled components.
Defaults to NULL, and will provide values in model units if unspecified.}

\item{MW}{Molecular weight of substance of interest in g/mole}

\item{vol}{Volume for the target tissue of interest in liters (L).
NOTE: Volume should not be in units of per BW, i.e. "kg".}

\item{chem.cas}{Either the chemical name, CAS number, or the parameters must
be specified.}

\item{chem.name}{Either the chemical name, CAS number, or the parameters
must be specified.}

\item{dtxsid}{EPA's DSSTox Structure ID .
(\url{https://comptox.epa.gov/dashboard}) the chemical must be identified by
either CAS, name, or DTXSIDs.}

\item{parameters}{A set of model parameters, especially a set that
includes MW (molecular weight) for our conversions.}

\item{monitor.vars}{A vector of character strings indicating the model
component variables to retain in the conversion factor table
(assuming suppress.messages == FALSE).  It should also be noted this option
does NOT exclude columns from the input matrix provided in the
'model.output.mat' parameter. (Default is NULL, i.e. conversion factors for
all model components are included in the reporting matrix.)}

\item{suppress.messages}{Whether or not the output messages are suppressed.
(Default is FALSE, i.e. show messages.)}

\item{verbose}{Whether or not to display the full conversion factor table.
(Default is FALSE, i.e. only include rows where the conversion factor is 1.)}

\item{...}{Other parameters that can be passed to \code{convert_units}, e.g.
temperature and compound state.  See details in \code{\link{convert_units}}.}
}
\value{
'new.ouput.matrix' A matrix with a column for time (in days), each
compartment, and the area under the curve (AUC) and a row
for each time point. The compartment and AUC columns are
converted from model specified units to user specified units.

'output.units.vector' A vector of character strings providing the
model compartments and their corresponding units after \code{convert_solve_x}.
}
\description{
This function is designed to convert compartment values estimated from one
of the HTTK models (e.g. "1compartment) using the solve_model function.
It takes the HTTK model output matrix, model name, desired output units,
and compound information to perform the conversion default model units to
user specified units.
}
\details{
The function can be used to convert all compartments to a single unit,
only units for a single model compartment, or units for a set of model
compartments.

More details on the unit conversion can be found in the documentation for
\code{\link{convert_units}}.
}
\examples{
output.mat <- solve_1comp(dtxsid = "DTXSID0020573")
new.output.mat <- convert_solve_x(output.units = "mg",
                                  model.output.mat = output.mat,
                                  model = "1compartment",
                                  dtxsid = "DTXSID0020573")

}
\seealso{
convert_units
}
\author{
Sarah E. Davidson
}
