% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{geno_baf_rratio}
\alias{geno_baf_rratio}
\title{Genotype with kmeans using three clusters}
\usage{
geno_baf_rratio(dat, delthresh = 0.7, drop = FALSE, corr = FALSE)
}
\arguments{
\item{dat}{List object, containing at least two matrices "intensity" and "theta".
Or matrix with raw data.}

\item{delthresh}{Numeric between 0 and 1. Intensity threshold for deletions.}

\item{drop}{Logical, if TRUE theta and intensity values are removed to save memory.}

\item{corr}{Logical, if TRUE all sample medians are corrected to 0.}
}
\value{
Genotypes
}
\description{
Genotype with kmeans using three clusters
}
\examples{
if(require(brassicaData)){
data("raw_napus", package = "brassicaData", envir = environment())
\dontshow{
raw_napus <- filt_samp(raw_napus, raw_napus$samples[-(1:10)])
raw_napus <- filt_snps(raw_napus, raw_napus$snps[-(1:10)])
}
dat <- intens_theta(raw_napus)
dat <- remove_suffix(dat, "_Grn")
dat <- geno_baf_rratio(dat, delthresh = 11)
}
}

