% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/repository.r
\docType{methods}
\name{discover_repository}
\alias{discover_repository}
\alias{discover_repository,character-method}
\title{Find path to repository for any file}
\usage{
discover_repository(path)

\S4method{discover_repository}{character}(path)
}
\arguments{
\item{path}{A character vector specifying the path to a file or folder}
}
\value{
Character vector with path to repository or NULL if this cannot be
  established.
}
\description{
libgit's git_discover_repository is used to identify the location of the
  repository. The path will therefore be terminated by a file separator.
}
\examples{
\dontrun{
## Initialize a temporary repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

## Create a user and commit a file
config(repo, user.name="Alice", user.email="alice@example.org")
writeLines("Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do",
           file.path(path, "example-1.txt"))
add(repo, "example-1.txt")
commit(repo, "First commit message")

## Create a second file. The file is not added for version control
## in the repository.
dir.create(file.path(path, "example"))
file_2 <- file.path(path, "example/example-2.txt")
writeLines("Not under version control", file_2)

## Find the path to the repository using the path to the second file
discover_repository(file_2)
}
}
\keyword{methods}

