\name{geom_coxcomb}
\alias{geom_coxcomb}
\title{Coxcomb glyphs}
\usage{
  geom_coxcomb(mapping = NULL, data = NULL, stat = "bin",
    position = "identity", npoints = 10, na.rm = FALSE,
    ...)
}
\arguments{
  \item{mapping}{The aesthetic mapping, usually constructed
  with \code{\link[ggplot2]{aes}}. Only needs to be set at
  the layer level if you are overriding the plot defaults.}

  \item{data}{A layer specific dataset - only needed if you
  want to override the plot defaults}

  \item{stat}{The statistical transformation to use for
  this layer.}

  \item{position}{The position adjustment to use for
  overlapping points in this layer}

  \item{npoints}{the number of points to use when drawing
  the arcs with line segments. Defaults to 10.}

  \item{na.rm}{If FALSE (the default), removes missing
  values with a warning. If TRUE, silently removes missing
  variables.}

  \item{...}{other arguments passed on to
  \code{\link[ggplot2]{layer}}. This can include aesthetics
  whose values you want to set, not map. See
  \code{\link[ggplot2]{layer}} for more details.}
}
\description{
  geom_coxcomb draws the type of glyph commonly called a
  coxcomb plot or polar area plot, popularized by Florence
  Nightingale.
}
\section{Aesthetics
geom_coxcomb understands the following aesthetics}{
  x, y, colour, fill, size, linetype, weight, and alpha.
}
\examples{
\dontrun{## A single coxcomb
ggplot(casualties) +
geom_coxcomb(aes(angle = month, fill = month))

## Coxcombs in an embedded plot
ggplot(casualties) +
map_afghanistan +
geom_subplot2d(aes(lon, lat,
subplot = geom_coxcomb(aes(angle = month, fill = month))),
bins = c(15, 12), ref = NULL) +
coord_map()
}
}

