% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_ggbetweenstats.R
\name{long_to_wide_converter}
\alias{long_to_wide_converter}
\title{Converts long-format dataframe to wide-format dataframe}
\usage{
long_to_wide_converter(data, x, y, paired = TRUE)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or tables will \strong{not} be accepted.}

\item{x}{The grouping variable from the dataframe \code{data}.}

\item{y}{The response (a.k.a. outcome or dependent) variable from the
dataframe \code{data}.}

\item{paired}{A logical that indicates whether the design was repeated
measures (within-subjects) or between-subjects (default: \code{TRUE}).}
}
\description{
This conversion is helpful mostly for repeated measures design.
}
\examples{
ggstatsplot:::long_to_wide_converter(
  data = iris_long,
  x = condition,
  y = value,
  paired = TRUE
)
}
\author{
Indrajeet Patil
}
\keyword{internal}
