% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_ggbetween_anova_subtitles.R
\name{subtitle_anova_bayes}
\alias{subtitle_anova_bayes}
\title{Making text subtitle for the between-subject one-way anova designs.}
\usage{
subtitle_anova_bayes(data, x, y, paired = FALSE, bf.prior = 0.707,
  k = 2, ...)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or tables will \strong{not} be accepted.}

\item{x}{The grouping variable from the dataframe \code{data}.}

\item{y}{The response (a.k.a. outcome or dependent) variable from the
dataframe \code{data}.}

\item{paired}{Logical that decides whether the design is repeated
measures/within-subjects (in which case one-way Friedman Rank Sum Test will
be carried out) or between-subjects (in which case one-way Kruskal–Wallis H
test will be carried out). The default is \code{FALSE}.}

\item{bf.prior}{A number between 0.5 and 2 (default \code{0.707}), the prior width
to use in calculating Bayes factors.}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2}).}

\item{...}{Additional arguments.}
}
\description{
Making text subtitle for the between-subject one-way anova designs.
}
\examples{
\donttest{
set.seed(123)

# between-subjects ---------------------------------------
# with defaults
ggstatsplot::subtitle_anova_bayes(
  data = ggplot2::msleep,
  x = vore,
  y = sleep_rem
)

# modifying the defaults
ggstatsplot::subtitle_anova_bayes(
  data = ggplot2::msleep,
  x = vore,
  y = sleep_rem,
  k = 3,
  bf.prior = 0.8
)

# repeated measures ---------------------------------------
ggstatsplot::subtitle_anova_bayes(
  data = WRS2::WineTasting,
  x = Wine,
  y = Taste,
  paired = TRUE,
  k = 4
)
}
}
\author{
Indrajeet Patil
}
