% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_ggscatterstats_subtitles.R
\name{subtitle_ggscatterstats}
\alias{subtitle_ggscatterstats}
\title{Making text subtitle for the correlation test.}
\usage{
subtitle_ggscatterstats(data, x, y, nboot = 100, beta = 0.1,
  type = "pearson", bf.prior = 0.707, conf.level = 0.95,
  conf.type = "norm", messages = TRUE, k = 2, ...)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or tables will \strong{not} be accepted.}

\item{x}{A vector containing the explanatory variable.}

\item{y}{The response - a vector of length the number of rows of \code{x}.}

\item{nboot}{Number of bootstrap samples for computing confidence interval
for the effect size (Default: \code{100}).}

\item{beta}{bending constant (Default: \code{0.1}). For more, see \code{?WRS2::pbcor}.}

\item{type}{Type of association between paired samples required
("\code{"parametric"}: Pearson's product moment correlation coefficient" or
"\code{"nonparametric"}: Spearman's rho" or "\code{"robust"}: percentage bend
correlation coefficient" or "\code{"bayes"}: Bayes Factor for Pearson's \emph{r}").
Corresponding abbreviations are also accepted: \code{"p"} (for
parametric/pearson's), \code{"np"} (nonparametric/spearman), \code{"r"} (robust),
\code{"bf"} (for bayes factor), resp.}

\item{bf.prior}{A number between 0.5 and 2 (default \code{0.707}), the prior width
to use in calculating Bayes factors.}

\item{conf.level}{Scalar between 0 and 1. If unspecified, the defaults return
\code{95\%} lower and upper confidence intervals (\code{0.95}).}

\item{conf.type}{A vector of character strings representing the type of
intervals required. The value should be any subset of the values \code{"norm"},
\code{"basic"}, \code{"perc"}, \code{"bca"}. For more, see \code{?boot::boot.ci}.}

\item{messages}{Decides whether messages references, notes, and warnings are
to be displayed (Default: \code{TRUE}).}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2}).}

\item{...}{further arguments to be passed to or from methods.}
}
\description{
Making text subtitle for the correlation test.
}
\examples{

# without changing defaults
subtitle_ggscatterstats(
  data = ggplot2::midwest,
  x = area,
  y = percblack
)

# changing defaults
subtitle_ggscatterstats(
  data = ggplot2::midwest,
  x = area,
  y = percblack,
  nboot = 25,
  beta = 0.2,
  type = "r",
  k = 1
)
}
\author{
Indrajeet Patil
}
