% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labels.R
\name{get_alt_text}
\alias{get_alt_text}
\alias{alt_text}
\title{Extract alt text from a plot}
\usage{
get_alt_text(p, ...)
}
\arguments{
\item{p}{a ggplot object}

\item{...}{Currently ignored}
}
\value{
A text string
}
\description{
This function returns a text that can be used as alt-text in webpages etc.
Currently it will use the \code{alt} label, added with \verb{+ labs(alt = <...>)}, or
a return an empty string, but in the future it might try to generate an alt
text from the information stored in the plot.
}
\examples{
p <- ggplot(mpg, aes(displ, hwy)) +
  geom_point()

# Returns an empty string
get_alt_text(p)

# A user provided alt text
p <- p + labs(
  alt = paste("A scatterplot showing the negative correlation between engine",
              "displacement as a function of highway miles per gallon")
)

get_alt_text(p)

}
