% Generated by roxygen2 (4.0.2): do not edit by hand
\name{print.xtree.reg}
\alias{print.xtree.reg}
\title{Print function for the Pathmox Segmentation Trees: linear regression and LAD}
\usage{
\method{print}{xtree.reg}(x, ...)
}
\arguments{
\item{x}{An object of class \code{"xtree.reg"}.}

\item{\dots}{Further arguments are ignored.}
}
\description{
The function \code{print.xtree.reg} print the \code{reg.pathmox} tree
}
\examples{
\dontrun{
#example of LM in alumni satisfaction

data(fibtelereg)

segvar= fibtelereg[,2:11]

data.fib=fibtelereg[,12:18]

segvar$Age 		= factor(segvar$Age, ordered=T)
segvar$Salary 	= factor(segvar$Salary,
		levels=c("<18k","25k","35k","45k",">45k"), ordered=T)
segvar$Accgrade = factor(segvar$Accgrade,
		levels=c("accnote<7","7-8accnote","accnote>8"), ordered=T)
segvar$Grade 	= factor(segvar$Grade,
		levels=c("<6.5note","6.5-7note","7-7.5note",">7.5note"), ordered=T)

fib.reg.pathmox=reg.pathmox(Satisfact~.,data=data.fib,segvar,
		signif=0.05,deep=2,method="lm",size=0.15)

 print(fib.reg.pathmox)

}
}
\author{
Giuseppe Lamberti
}
\references{
Lamberti, G. (2014) \emph{Modeling with Heterogeneity.} PhD Dissertation.


\code{\link{summary.xtree.pls}}.
}

