% Generated by roxygen2 (4.0.2): do not edit by hand
\name{plot.treemodelreg}
\alias{plot.treemodelreg}
\title{Comparative plot between nodes from or the Pathmox Segmentation Trees: linear and LAD regression}
\usage{
\method{plot}{treemodelreg}(x, main.node = FALSE, names.nodes = NULL,
  eti = FALSE, lab.vec = NULL, short.min = NULL, cex.names = 1,
  cex.axis = 1.2, cex.main = 1, lim = c(-0.5, 0.5), short.labs = TRUE,
  ...)
}
\arguments{
\item{x}{An object of class \code{"treemodelreg"} returned by
\code{\link{reg.treemodel}}.}

\item{main.node}{It is string. If iequl to TRUE you have to inidcate the main of each barplot
in \code{"names.nodes"}.}

\item{names.nodes}{Optional vector of names for each the terminal node (must be a
vector of length equal to the number of terminal nodes).}

\item{eti}{is string. If it is TRUE the label of each coefficients for all the terminal nodes
must be  specify in  \code{"lab.vec"}. If it is false the labels are defined by the programe.}

\item{lab.vec}{Optional vector of names for each coefficient of the terminal nodes (must be a
vector of length equal to the number of coefficients).}

\item{short.min}{Integer number indicating the minimum length of the.}

\item{cex.names}{Allows to fix the size of coefficient labels. Equal to 1 to default.}

\item{cex.axis}{Allows to fix the size of axes. Equal to 1.2 to default.}

\item{cex.main}{Allows to fix the size of the main. Equal to 1 to default.}

\item{lim}{Allows to fix the axes interval. Equal to (-0.5,0.5) to default.}

\item{short.labs}{Logical value indicating if the labels of the barplots.}

\item{\dots}{Further arguments passed on to \code{\link{plot.treemodelreg}}.

\code{\link{reg.treemodel}}, \code{\link{reg.pathmox}}}
}
\description{
Plot method for objects of class \code{"treemodelreg"}. Barplots of path
coefficients of terminal nodes with respect to those of the global (root)
model
}
\details{
This function aims to visualize the comparison between coefficients of
the terminal nodes against the coefficients coefficients of the global model in the
root node.
}
\examples{
\dontrun{
#example of LM in alumni satisfaction

data(fibtelereg)

segvar= fibtelereg[,2:11]

data.fib=fibtelereg[,12:18]

segvar$Age 		= factor(segvar$Age, ordered=T)
segvar$Salary 	= factor(segvar$Salary,
	levels=c("<18k","25k","35k","45k",">45k"), ordered=T)
segvar$Accgrade = factor(segvar$Accgrade,
	levels=c("accnote<7","7-8accnote","accnote>8"), ordered=T)
segvar$Grade 	= factor(segvar$Grade,
	levels=c("<6.5note","6.5-7note","7-7.5note",">7.5note"), ordered=T)

fib.reg.pathmox=reg.pathmox(Satisfact~.,data=data.fib,segvar,
	signif=0.05,deep=2,method="lm",size=0.15)

#terminal nodes comparison
fib.node.comp=reg.treemodel(fib.reg.pathmox)

plot(fib.node.comp)


}
}
\author{
Giuseppe Lamberti
}
\references{
Sanchez, G. (2009) \emph{PATHMOX Approach: Segmentation Trees in
Partial Least Squares Path Modeling.} PhD Dissertation.

Lamberti, G. (2014) \emph{Modeling with Heterogeneity.} PhD Dissertation.
}

