% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdTrain.R
\name{gdTrain}
\alias{gdTrain}
\title{Train a generative model for a data source}
\usage{
gdTrain(
  generativeModelFileName,
  generativeDataFileName,
  dataSourceFileName,
  columnIndices,
  trainParameters = gdTrainParameters(numberOfIterations = 10000,
    numberOfHiddenLayerUnits = 1024, learningRate = 7e-05, dropout = 0.05)
)
}
\arguments{
\item{generativeModelFileName}{Name of generative model file}

\item{generativeDataFileName}{Name of generative data file. When name is NULL
or empty string generated data will not be written to a file.}

\item{dataSourceFileName}{Name of data source file}

\item{columnIndices}{Vector of two column indices that are used to plot
two-dimensional projections of normalized generated generative data and data
source for a training step. Indices refer to indices of active columns of
data source. Plotting can be disabled by passing NULL or an empty vector.}

\item{trainParameters}{Generative model training parameters, see
function gdTrainParameters().}
}
\value{
None
}
\description{
Read a data source from a file, train a generative model that generates 
generative data for the data source in iterative training steps, write
trained generative model and generated data in training steps to a file
in binary format. When a higher number of iterations is used the
distribution of generated data will get closer to that of the data source.
When a name of an existing generative model file is passed training will be
continued.
}
\examples{
\dontrun{
trainParameters <- gdTrainParameters(numberOfIterations = 10000)
gdTrain("gm.bin", "gd.bin", "ds.bin", c(1, 2), trainParameters)}
}
