% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defaults.R
\name{set_flextable_defaults}
\alias{set_flextable_defaults}
\alias{init_flextable_defaults}
\title{Modify flextable defaults formatting properties}
\usage{
set_flextable_defaults(
  font.family = NULL,
  font.size = NULL,
  font.color = NULL,
  text.align = NULL,
  padding = NULL,
  padding.bottom = NULL,
  padding.top = NULL,
  padding.left = NULL,
  padding.right = NULL,
  border.color = NULL,
  background.color = NULL,
  line_spacing = NULL,
  table.layout = NULL,
  cs.family = NULL,
  eastasia.family = NULL,
  hansi.family = NULL,
  decimal.mark = NULL,
  big.mark = NULL,
  digits = NULL,
  na_str = NULL,
  nan_str = NULL,
  fmt_date = NULL,
  fmt_datetime = NULL,
  extra_css = NULL,
  fonts_ignore = NULL,
  theme_fun = NULL,
  post_process_pdf = NULL,
  post_process_docx = NULL,
  post_process_html = NULL,
  post_process_pptx = NULL
)

init_flextable_defaults()
}
\arguments{
\item{font.family}{single character value. When format is Word, it specifies the font to
be used to format characters in the Unicode range (U+0000-U+007F).}

\item{font.size}{font size (in point) - 0 or positive integer value.}

\item{font.color}{font color - a single character value specifying
a valid color (e.g. "#000000" or "black").}

\item{text.align}{text alignment - a single character value, expected value
is one of 'left', 'right', 'center', 'justify'.}

\item{padding}{padding (shortcut for top, bottom, left and right padding)}

\item{padding.bottom, padding.top, padding.left, padding.right}{paragraph paddings - 0 or
positive integer value.}

\item{border.color}{border color - single character value
(e.g. "#000000" or "black").}

\item{background.color}{cell background color - a single character value specifying a
valid color (e.g. "#000000" or "black").}

\item{line_spacing}{space between lines of text, 1 is single line spacing, 2 is double line spacing.}

\item{table.layout}{'autofit' or 'fixed' algorithm. Default to 'autofit'.}

\item{cs.family}{optional and only for Word. Font to be used to format
characters in a complex script Unicode range. For example, Arabic
text might be displayed using the "Arial Unicode MS" font.}

\item{eastasia.family}{optional and only for Word. Font to be used to
format characters in an East Asian Unicode range. For example,
Japanese text might be displayed using the "MS Mincho" font.}

\item{hansi.family}{optional and only for Word. Font to be used to format
characters in a Unicode range which does not fall into one of the
other categories.}

\item{decimal.mark, big.mark, digits, na_str, nan_str}{\link{formatC} arguments used by \code{\link[=colformat_num]{colformat_num()}},
\code{\link[=colformat_double]{colformat_double()}}, and \code{\link[=colformat_int]{colformat_int()}}.}

\item{fmt_date, fmt_datetime}{formats for date and datetime columns as
documented in \code{\link[=strptime]{strptime()}}. Default to '\%Y-\%m-\%d' and '\%Y-\%m-\%d \%H:\%M:\%S'.}

\item{extra_css}{css instructions to be integrated with the table.}

\item{fonts_ignore}{if TRUE, pdf-engine pdflatex can be used instead of
xelatex or lualatex. If pdflatex is used, fonts will be ignored because they are
not supported by pdflatex, whereas with the xelatex and lualatex engines they are.}

\item{theme_fun}{a single character value (the name of the theme function
to be applied) or a theme function (input is a flextable, output is a flextable).}

\item{post_process_pdf, post_process_docx, post_process_html, post_process_pptx}{Post-processing functions
that will allow you to customize the display by output type (pdf, html, docx, pptx).
They are executed just before printing the table.}
}
\value{
a list containing previous default values.
}
\description{
The current formatting properties (see \code{\link[=get_flextable_defaults]{get_flextable_defaults()}})
are automatically applied to every flextable you produce.
Use \code{set_flextable_defaults()} to override them. Use \code{init_flextable_defaults()}
to re-init all values with the package defaults.
}
\section{Illustrations}{


\if{html}{\figure{fig_set_flextable_defaults_1.png}{options: width=50\%}}

\if{html}{\figure{fig_set_flextable_defaults_2.png}{options: width=50\%}}
}

\examples{
ft_1 <- qflextable(head(airquality))
ft_1

old <- set_flextable_defaults(
  font.color = "#AA8855",
  border.color = "#8855AA")
ft_2 <- qflextable(head(airquality))
ft_2

do.call(set_flextable_defaults, old)
}
\seealso{
Other functions related to themes: 
\code{\link{get_flextable_defaults}()},
\code{\link{theme_alafoli}()},
\code{\link{theme_booktabs}()},
\code{\link{theme_box}()},
\code{\link{theme_tron_legacy}()},
\code{\link{theme_tron}()},
\code{\link{theme_vader}()},
\code{\link{theme_vanilla}()},
\code{\link{theme_zebra}()}
}
\concept{functions related to themes}
