% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_light_global_surrogate.R
\name{plot.light_global_surrogate}
\alias{plot.light_global_surrogate}
\title{Plot Global Surrogate Trees}
\usage{
\method{plot}{light_global_surrogate}(x, type = 5, auto_main = TRUE, mfrow = NULL, ...)
}
\arguments{
\item{x}{An object of class \code{light_global_surrogate}.}

\item{type}{Plot type, see help of \code{rpart.plot}. Default is 5.}

\item{auto_main}{Automatic plot titles (only if multiple trees are shown in the same figure).}

\item{mfrow}{If multiple trees are shown in the same figure: what value of \code{mfrow} to use in \code{par}?}

\item{...}{Further arguments passed to \code{rpart.plot}.}
}
\value{
An object of class \code{ggplot2}.
}
\description{
Using \code{rpart.plot}, trees fitted by \code{light_global_surrogate} are visualized.
}
\examples{
fit <- lm(Sepal.Length ~ ., data = iris)
x <- flashlight(model = fit, label = "lm", data = iris)
plot(light_global_surrogate(x))
}
\seealso{
\code{\link{light_global_surrogate}}.
}
