% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{llik_pwexp}
\alias{llik_pwexp}
\title{Log likelihood for piecewise exponential regression}
\usage{
llik_pwexp(theta, time, event, J, tcut, q, x)
}
\arguments{
\item{theta}{The parameter vector consisting of gamma for log
piecewise hazards and beta for regression coefficients.}

\item{time}{The survival time.}

\item{event}{The event indicator.}

\item{J}{The number of time intervals.}

\item{tcut}{A vector that specifies the endpoints of time intervals
for the baseline piecewise exponential survival distribution.
Must start with 0, e.g., c(0, 60) breaks the time axis into 2 event
intervals: [0, 60) and [60, Inf). By default, it is set to 0.}

\item{q}{The number of columns of the covariates matrix.}

\item{x}{The covariates matrix (excluding the intercept).}
}
\value{
The log likelihood value for piecewise exponential regression.
}
\description{
Obtains the log likelihood value for piecewise
exponential regression.
}
\keyword{internal}
