% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_fun.R
\name{transl33t}
\alias{transl33t}
\title{transl33t translates text into leet slang.}
\usage{
transl33t(txt, rules = l33t_rul35, in_case = "no", out_case = "no")
}
\arguments{
\item{txt}{The text (character string) to translate.}

\item{rules}{Rules which existing character in \code{txt} 
is to be replaced by which new character (as a named character vector). 
Default: \code{rules = \link{l33t_rul35}}.}

\item{in_case}{Change case of input string \code{txt}. 
Default: \code{in_case = "no"}. 
Set to \code{"lo"} or \code{"up"} for lower or uppercase, respectively.}

\item{out_case}{Change case of output string. 
Default: \code{out_case = "no"}. 
Set to \code{"lo"} or \code{"up"} for lower or uppercase, respectively.}
}
\value{
A character vector.
}
\description{
\code{transl33t} translates text into leet (or l33t) slang 
given a set of rules.
}
\details{
The current version of \code{transl33t} only uses \code{base R} commands, 
rather than the \bold{stringr} package.
}
\examples{
# Use defaults:
transl33t(txt = "hello world")
transl33t(txt = c(letters))
transl33t(txt = c(LETTERS))

# Specify rules:
transl33t(txt = "hello world", 
          rules = c("e" = "3", "l" = "1", "o" = "0"))

# Set input and output case:
transl33t(txt = "hello world", in_case = "up", 
          rules = c("e" = "3", "l" = "1", "o" = "0"))  # e only capitalized
transl33t(txt = "hEllo world", in_case = "lo", out_case = "up", 
          rules = c("e" = "3", "l" = "1", "o" = "0"))  # e transl33ted

}
\seealso{
\code{\link{l33t_rul35}} for default rules used; 
\code{\link{invert_rules}} for inverting rules.

Other text objects and functions: 
\code{\link{Umlaut}},
\code{\link{capitalize}()},
\code{\link{caseflip}()},
\code{\link{cclass}},
\code{\link{chars_to_text}()},
\code{\link{collapse_chars}()},
\code{\link{count_chars_words}()},
\code{\link{count_chars}()},
\code{\link{count_words}()},
\code{\link{invert_rules}()},
\code{\link{l33t_rul35}},
\code{\link{map_text_chars}()},
\code{\link{map_text_coord}()},
\code{\link{map_text_regex}()},
\code{\link{metachar}},
\code{\link{read_ascii}()},
\code{\link{text_to_chars}()},
\code{\link{text_to_sentences}()},
\code{\link{text_to_words}()},
\code{\link{words_to_text}()}
}
\concept{text objects and functions}
