% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deepregression.R
\name{from_preds_to_dist}
\alias{from_preds_to_dist}
\title{Define Predictor of a Deep Distributional Regression Model}
\usage{
from_preds_to_dist(
  list_pred_param,
  family = NULL,
  output_dim = 1L,
  mapping = NULL,
  from_distfun_to_dist = distfun_to_dist,
  add_layer_shared_pred = function(x, units) layer_dense(x, units = units, use_bias =
    FALSE)
)
}
\arguments{
\item{list_pred_param}{list of input-output(-lists) generated from
\code{subnetwork_init}}

\item{family}{see \code{?deepregression}; if NULL, concatenated
\code{list_pred_param} entries are returned (after applying mapping if provided)}

\item{output_dim}{dimension of the output}

\item{mapping}{a list of integers. The i-th list item defines which element
elements of \code{list_pred_param} are used for the i-th parameter.
For example, \code{map = list(1,2,1:2)} means that \code{list_pred_param[[1]]}
is used for the first distribution parameter, \code{list_pred_param[[2]]} for
the second distribution parameter and  \code{list_pred_param[[3]]} for both
distribution parameters (and then added once to \code{list_pred_param[[1]]} and
once to \code{list_pred_param[[2]]})}

\item{from_distfun_to_dist}{function creating a tfp distribution based on the
prediction tensors and \code{dist_fun}. See \code{?distfun_to_dist}}

\item{add_layer_shared_pred}{layer to extend shared layers defined in \code{mapping}}
}
\value{
a list with input tensors and output tensors that can be passed
to, e.g., \code{keras_model}
}
\description{
Define Predictor of a Deep Distributional Regression Model
}
