% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_from_date.R
\name{generate_factor_from_date}
\alias{generate_factor_from_date}
\title{Generate factor from dates}
\usage{
generate_factor_from_date(
  data_set,
  cols = "auto",
  type = "yearmonth",
  drop = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{data_set}{Matrix, data.frame or data.table}

\item{cols}{List of date column(s) name(s) of data_set to transform into factor. To transform all
dates, set it to "auto". (characters, default to "auto")}

\item{type}{"year", "yearquarter", "yearmonth", "quarter" or "month", way to aggregate a date,
(character, default to "yearmonth")}

\item{drop}{Should \code{cols} be dropped after generation (logical, default to FALSE)}

\item{verbose}{Should the function log (logical, default to TRUE)}

\item{...}{Other arguments such as \code{name_separator} to separate words in new columns names
(character, default to ".")}
}
\value{
\code{data_set} with new columns. \code{data_set} is edited by \strong{reference}.
}
\description{
Taking Date or POSIXct colums, and building factor columns from them.
}
\examples{
# Load set, and find dates
data(messy_adult)
messy_adult <- find_and_transform_dates(messy_adult, verbose = FALSE)

# Generate new columns
# Generate year month columns
messy_adult <- generate_factor_from_date(messy_adult, cols = c("date1", "date2", "num1"))
head(messy_adult[, .(date1.yearmonth, date2.yearmonth)])


# Generate quarter columns
messy_adult <- generate_factor_from_date(messy_adult, cols = c("date1", "date2"), type = "quarter")
head(messy_adult[, .(date1.quarter, date2.quarter)])
}
