% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_dm.R
\name{pdfs}
\alias{pdfs}
\alias{pdfs.drift_dm}
\title{Access the Probability Density Functions of a Model}
\usage{
pdfs(object, ...)

\method{pdfs}{drift_dm}(object, ...)
}
\arguments{
\item{object}{an object of type \link{drift_dm}.}

\item{...}{additional arguments passed down to the specific method.}
}
\value{
A list with named elements corresponding to the conditions of a model (see
\code{\link[=conds]{conds()}}). Each of these elements is another list, containing the
entries \code{pdf_u} and \code{pdf_l}, which are numeric vectors for the PDFs of the
upper and lower boundary, respectively.
}
\description{
Functions to obtain the probability density functions (PDFs) of a model.
These PDFs represent the first-passage-time.
}
\details{
If the model has not been evaluated, \code{\link[=re_evaluate_model]{re_evaluate_model()}} is
called before returning the PDFs.
}
\examples{
# get a pre-built model for demonstration purpose
a_model <- dmc_dm(dx = .0025, dt = .0025)
str(pdfs(a_model))

}
\seealso{
\code{\link[=drift_dm]{drift_dm()}}, \code{\link[=re_evaluate_model]{re_evaluate_model()}},
\code{\link[=conds]{conds()}}
}
