% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clock_chart_qlt.R
\name{clock_chart_qlt}
\alias{clock_chart_qlt}
\title{Clock Chart, Hands Colored by a Factor}
\usage{
clock_chart_qlt(data, time, crit)
}
\arguments{
\item{data}{A data frame}

\item{time}{Time in 24 hours. The allowed time formats for these family
of charts are \code{HH:MM:SS}, \code{HH:MM} or even \code{H:M} (such as \verb{12;30:09}
or \code{9:3}).}

\item{crit}{The qualitative vector by which hands will be colored.}
}
\value{
A \code{ggplot} object, which can be further modified
with \code{ggplot2} functions and themes.
}
\description{
This function will plot time of events on a 24 hour clock to show which
events took place at what times. The hands are colored by a
qualitative (factor) vector.
Change the plot's title, subtitle, or caption using \code{ggplot2::labs()}. \cr
For example: \verb{ggplot2::labs(title = "My Plot",} \cr
\verb{subtitle = "My Subtitle")}
You can change the title of the legend by adding \cr
\code{ggplot2::labs(color = "Legend Title")}.
}
\examples{
# A plot showing sms receiving times based on
# criteria (type/sender/invoked)
clock_chart_qlt(smsclock, time = time, crit = sender) +
  ggplot2::labs(color = "Sender", title = "SMS's Received throughout th Day")
}
\seealso{
\code{\link[=clock_chart_col]{clock_chart_col()}} for coloring and \code{\link[=clock_chart_qnt]{clock_chart_qnt()}} for more options.
}
