% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polynomials.R
\name{chebyshev_polynomials}
\alias{chebyshev_polynomials}
\alias{chebyshev_next}
\alias{chebyshev_t}
\alias{chebyshev_u}
\alias{chebyshev_t_prime}
\alias{chebyshev_clenshaw_recurrence}
\alias{chebyshev_clenshaw_recurrence_ab}
\title{Chebyshev Polynomials and Related Functions}
\usage{
chebyshev_next(x, Tn, Tn_1)

chebyshev_t(n, x)

chebyshev_u(n, x)

chebyshev_t_prime(n, x)

chebyshev_clenshaw_recurrence(c, x)

chebyshev_clenshaw_recurrence_ab(c, a, b, x)
}
\arguments{
\item{x}{Argument of the polynomial}

\item{Tn}{Value of the Chebyshev polynomial \eqn{(T_n(x))}}

\item{Tn_1}{Value of the Chebyshev polynomial \eqn{(T_{n-1}(x))}}

\item{n}{Degree of the polynomial}

\item{c}{Coefficients of the Chebyshev polynomial}

\item{a}{Lower bound of the interval}

\item{b}{Upper bound of the interval}
}
\value{
A single numeric value with the computed Chebyshev polynomial, its derivative, or related functions.
}
\description{
Functions to compute Chebyshev polynomials of the first and second kind.
}
\examples{
# Chebyshev polynomial of the first kind T_2(0.5)
chebyshev_t(2, 0.5)
# Chebyshev polynomial of the second kind U_2(0.5)
chebyshev_u(2, 0.5)
# Derivative of the Chebyshev polynomial of the first kind T_2'(0.5)
chebyshev_t_prime(2, 0.5)
# Next Chebyshev polynomial of the first kind T_3(0.5) using T_2(0.5) and T_1(0.5)
chebyshev_next(0.5, chebyshev_t(2, 0.5), chebyshev_t(1, 0.5))
# Chebyshev polynomial of the first kind using Clenshaw's recurrence with coefficients
# c = c(1, 0, -1) at x = 0.5
chebyshev_clenshaw_recurrence(c(1, 0, -1), 0.5)
# Chebyshev polynomial of the first kind using Clenshaw's recurrence with interval [0, 1]
chebyshev_clenshaw_recurrence_ab(c(1, 0, -1), 0, 1, 0.5)
}
\seealso{
\href{https://www.boost.org/doc/libs/latest/libs/math/doc/html/math_toolkit/sf_poly/chebyshev.html}{Boost Documentation} for more details on the mathematical background.
}
