% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quadrature_and_differentiation.R
\name{numerical_differentiation}
\alias{numerical_differentiation}
\alias{finite_difference_derivative}
\alias{complex_step_derivative}
\title{Numerical Differentiation}
\usage{
finite_difference_derivative(f, x, order = 1)

complex_step_derivative(f, x)
}
\arguments{
\item{f}{A function to differentiate. It should accept a single numeric value and return a single numeric value.}

\item{x}{The point at which to evaluate the derivative.}

\item{order}{The order of accuracy of the derivative to compute. Default is 1.}
}
\value{
The approximate value of the derivative at the point \code{x}.
}
\description{
Functions for numerical differentiation using finite difference methods and complex step methods.
}
\examples{
# Finite difference derivative of sin(x) at pi/4
finite_difference_derivative(sin, pi / 4)
# Complex step derivative of exp(x) at 1.7
complex_step_derivative(exp, 1.7)
}
