% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/holtsmark_distribution.R
\name{holtsmark_distribution}
\alias{holtsmark_distribution}
\alias{holtsmark_pdf}
\alias{holtsmark_lpdf}
\alias{holtsmark_cdf}
\alias{holtsmark_lcdf}
\alias{holtsmark_quantile}
\title{Holtsmark Distribution Functions}
\usage{
holtsmark_pdf(x, location = 0, scale = 1)

holtsmark_lpdf(x, location = 0, scale = 1)

holtsmark_cdf(x, location = 0, scale = 1)

holtsmark_lcdf(x, location = 0, scale = 1)

holtsmark_quantile(p, location = 0, scale = 1)
}
\arguments{
\item{x}{quantile}

\item{location}{location parameter (default is 0)}

\item{scale}{scale parameter (default is 1)}

\item{p}{probability (0 <= p <= 1)}
}
\value{
A single numeric value with the computed probability density, log-probability density, cumulative distribution, log-cumulative distribution, or quantile depending on the function called.
}
\description{
Functions to compute the probability density function, cumulative distribution function, and quantile function for the Holtsmark distribution.
}
\examples{
# Distribution only available with Boost version 1.87.0 or later.
\dontrun{
# Holtsmark distribution with location 0 and scale 1
  holtsmark_pdf(3)
  holtsmark_lpdf(3)
  holtsmark_cdf(3)
  holtsmark_lcdf(3)
  holtsmark_quantile(0.5)
}
}
\seealso{
\href{https://www.boost.org/doc/libs/1_87_0/libs/math/doc/html/math_toolkit/dist_ref/dists/holtsmark_dist.html}{Boost Documentation} for more details on the mathematical background.
}
