% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mm.R
\name{mm}
\alias{mm}
\title{Fit Marginalized Transition and/or Latent Variable Models}
\usage{
mm(
  mean.formula,
  lv.formula = NULL,
  t.formula = NULL,
  id,
  data,
  inits = NULL,
  weight = NULL,
  offset = NULL,
  q = 30,
  step.max = 1,
  step.tol = 1e-06,
  hess.eps = 1e-07,
  adapt.quad = FALSE,
  verbose = FALSE,
  iter.lim = 100,
  return_args = FALSE
)
}
\arguments{
\item{mean.formula}{Mean model formula in which a binary variable is regressed on covariates}

\item{lv.formula}{Latent variable model formula (right hand side only)}

\item{t.formula}{Transition model formula (right hand side only)}

\item{id}{a vector of cluster identifiers (it should be the same length of nrow(data)).}

\item{data}{a required data frame}

\item{inits}{an optional list of length 3 containing initial values for marginal mean parameters
and all dependence parameters. The format of the list should be: (1) estimates of the mean
parameters, (2) estimates of the transition parameters (or NULL if only fitting a mLV model)
and (3) estimates of the latent variable parameters (or NULL if only fitting a mT model).
If NULL, initial values will be automatically generated.}

\item{weight}{a vector of sampling weights - if using weighted estimating equations. The vector should be the same length of nrow(data).}

\item{offset}{an optional offset}

\item{q}{a scalar to denote the number of quadrature points used to compute the Gauss-Hermite quadrature rule}

\item{step.max}{a scalar}

\item{step.tol}{a scalar}

\item{hess.eps}{a scalar}

\item{adapt.quad}{an indicator if adaptive quadrature is to be used. NOT CURRENTLY IMPLEMENTED.}

\item{verbose}{an indicator if model output should be printed to the screen during maximization (or minimization of negative log-likelihood)}

\item{iter.lim}{a scalar to denote the maximum iteration limit. Default value is 100.}

\item{return_args}{indicator to denote if attributes of the output should be printed.}
}
\value{
This function returns marginal mean (beta) and dependence parameters (alpha) along with the associated model and empirical covariance matricies
}
\description{
Fit a marginalzed transition and/or latent variable models (mTLV) as described by Schildcrout and Heagerty 2007.
}
\examples{
\donttest{
data(datrand)
fit <- mm(Y~time*binary, t.formula=~1, data=datrand, id=id, step.max=4, verbose=FALSE)}
}
