% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batchLLM.R
\name{scrape_metadata}
\alias{scrape_metadata}
\title{Scrape Metadata}
\usage{
scrape_metadata(df_name = NULL, log_name = "batchLLM-log")
}
\arguments{
\item{df_name}{Optional. A string to match the name of a processed data frame.}

\item{log_name}{A string specifying the name of the log file without the extension. Default is "batchLLM-log".}
}
\value{
A data frame containing metadata.
}
\description{
Scrape metadata from the \code{.rds} log file.
}
\examples{
library(batchLLM)

# Scrape metadata for all data frames in the default log file
all_metadata <- scrape_metadata()
head(all_metadata)

# Scrape metadata for a specific data frame
specific_metadata <- scrape_metadata("beliefs_40a3012b")
head(specific_metadata)

# Use a custom log file name
custom_metadata <- scrape_metadata(log_name = "custom-log")
head(custom_metadata)
}
