% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert-is-current.R, R/is-current.R
\name{assert_is_package_current}
\alias{assert_is_package_current}
\alias{assert_all_are_current_packages}
\alias{assert_any_are_current_packages}
\alias{is_package_current}
\title{Is the installed version of a package current?}
\usage{
assert_is_package_current(...)

assert_all_are_current_packages(
  x,
  lib.loc = .libPaths(),
  repos = getOption("repos"),
  type = getOption("pkgType"),
  severity = getOption("assertive.severity", "stop")
)

assert_any_are_current_packages(
  x,
  lib.loc = .libPaths(),
  repos = getOption("repos"),
  type = getOption("pkgType"),
  severity = getOption("assertive.severity", "stop")
)

is_package_current(
  x = NULL,
  lib.loc = .libPaths(),
  repos = getOption("repos"),
  type = getOption("pkgType"),
  .xname = get_name_in_parent(x)
)
}
\arguments{
\item{...}{Passed to and from deprecated \code{assert_is_current_package}.}

\item{x}{A character vector of package names, or \code{NULL} to check all
installed packages.}

\item{lib.loc}{A character vector of paths to local package libraries.}

\item{repos}{A character vector of URLs to repositories to check for new
package versions.}

\item{type}{Check the repository for source or binary packages?}

\item{severity}{How severe should the consequences of the assertion be?
Either \code{"stop"}, \code{"warning"}, \code{"message"}, or \code{"none"}.}

\item{.xname}{Not intended to be used directly.}
}
\value{
\code{is_package_current}  returns a logical vector that is 
\code{TRUE} whenever the package version matches the one in the repository.
\code{NA} is returned for non-installed packages.
The \code{assert_*} functions throw an error in the event of failure.
}
\description{
Checks to see if the installed version of a package is current.
}
\examples{
\donttest{
# This test is marked "dont-test" since it involves a connection to 
# repositories which is potentially long running.
is_package_current(c("assertive.base", "assertive.reflection", "NONEXISTENTPKG"))
}
}
\seealso{
\code{\link[utils]{old.packages}}, on which this is based, which
has advanced usage features.
}
