% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{model}
\alias{model}
\title{General model}
\usage{
model()
}
\value{
A general pharmacometric model
}
\description{
This function creates the basis for a general pharmacometric model, a flexible but verbose model type.
}
\details{
The function creates the fundament for a general pharmacometric model to which different building blocks can be added. The following building
blocks are relevant for this model type:
\itemize{
\item Parameters: \link{prm_log_normal}, \link{prm_logit_normal}, \link{prm_no_var}, \link{prm_normal}
\item Observations: \link{obs_additive}, \link{obs_combined}, \link{obs_proportional}
\item Algebraic relationships: \link{algebraic}
\item Compartments: \link{compartment}
\item Flows: \link{flow}
\item Input variables: \link{input_variable}, \link{dataset}
}

The more specialized \code{\link[=pk_model]{pk_model()}} is converted to a general model during the rendering process.
}
\examples{
m <- model() +
    input_variable("dose") +
    prm_log_normal("emax") +
    prm_log_normal("ed50") +
    obs_additive(eff~emax*dose/(ed50+dose))
render(m)
}
