/*-------------------------------------------------------------------------
 |                                                                         
 |                    SAS SETUP FILE FOR ICPSR 22400
 |         UNIFORM CRIME REPORTING PROGRAM DATA [UNITED STATES]:
 |             OFFENSES KNOWN AND CLEARANCES BY ARREST, 2006
 |
 |
 | SAS setup sections are provided for the ASCII version of this data
 | collection.  These sections are listed below:
 |
 | PROC FORMAT:  creates user-defined formats for the variables. Formats
 | replace original value codes with value code descriptions. Only
 | variables with user-defined formats are included in this section.
 |
 | DATA:  begins a SAS data step and names an output SAS data set.
 |
 | INFILE:  identifies the input file to be read with the input statement.
 | Users must replace the "data-filename" with a filename specifying the
 | directory on the user's computer system in which the downloaded and
 | unzipped data file is physically located (e.g.,
 | "c:\temp\22400-0001-data.txt").
 |
 | INPUT:  assigns the name, type, decimal specification (if any), and
 | specifies the beginning and ending column locations for each variable
 | in the data file.
 |
 | LABEL:  assigns descriptive labels to all variables. Variable labels
 | and variable names may be identical for some variables.
 |
 | MISSING VALUE RECODES:  sets user-defined numeric missing values to
 | missing as interpreted by the SAS system. Only variables with
 | user-defined missing values are included in this section.
 |
 | If any variables have more than one missing value, they are assigned
 | to the standard missing value of a single period (.) in the statement
 | below. To maintain the original meaning of missing codes, users may want
 | to take advantage of the SAS missing values (the letters A-Z or an
 | underscore preceded by a period).
 |
 | An example of a standard missing value recode:
 |
 |   IF (RELATION = 98 OR RELATION = 99) THEN RELATION = .; 
 |
 | The same example using special missing value recodes:
 |
 |    IF RELATION = 98 THEN RELATION = .A;
 |    IF RELATION = 99 THEN RELATION = .B;
 |
 | FORMAT:  associates the formats created by the PROC FORMAT step with
 | the variables named in the INPUT statement.
 |
 | NOTE:  Users should modify this setup file to suit their specific needs.
 | Sections for PROC FORMAT, FORMAT, and MISSING VALUE RECODES have been
 | commented out (i.e., '/*'). To include these sections in the final SAS
 | setup, users should remove the SAS comment indicators from the desired
 | section(s).
 |
 |------------------------------------------------------------------------*/

* SAS PROC FORMAT;

/*
PROC FORMAT;
  VALUE v1ffffff  1='(1) Offenses known' ;
  VALUE v2ffffff  1='(1) Alabama' 2='(2) Arizona' 3='(3) Arkansas' 4='(4) California'
                  5='(5) Colorado' 6='(6) Connecticut' 7='(7) Delaware'
                  8='(8) District of Columbia' 9='(9) Florida' 10='(10) Georgia'
                  11='(11) Idaho' 12='(12) Illinois' 13='(13) Indiana' 14='(14) Iowa' 15='(15) Kansas'
                  16='(16) Kentucky' 17='(17) Louisiana' 18='(18) Maine' 19='(19) Maryland'
                  20='(20) Massachusetts' 21='(21) Michigan' 22='(22) Minnesota'
                  23='(23) Mississippi' 24='(24) Missouri' 25='(25) Montana' 26='(26) Nebraska'
                  27='(27) Nevada' 28='(28) New Hampshire' 29='(29) New Jersey'
                  30='(30) New Mexico' 31='(31) New York' 32='(32) North Carolina'
                  33='(33) North Dakota' 34='(34) Ohio' 35='(35) Oklahoma' 36='(36) Oregon'
                  37='(37) Pennsylvania' 38='(38) Rhode Island' 39='(39) South Carolina'
                  40='(40) South Dakota' 41='(41) Tennessee' 42='(42) Texas' 43='(43) Utah'
                  44='(44) Vermont' 45='(45) Virginia' 46='(46) Washington'
                  47='(47) West Virginia' 48='(48) Wisconsin' 49='(49) Wyoming' 50='(50) Alaska'
                  51='(51) Hawaii' 52='(52) Canal Zone' 53='(53) Puerto Rico'
                  54='(54) American Samoa' 55='(55) Guam' 62='(62) Virgin Islands' ;
  VALUE $v3fffff  'AK00101'='(AK00101) Anchorage' 'AK00102'='(AK00102) Fairbanks'
                  'AK00103'='(AK00103) Juneau' 'AK00104'='(AK00104) Ketchikan' 'AK00105'='(AK00105) Kodiak'
                  'AK00106'='(AK00106) Nome' 'AK00107'='(AK00107) Petersburg' 'AK00108'='(AK00108) Seward'
                  'AK00109'='(AK00109) Sitka' 'AK00110'='(AK00110) Skagway' 'AK00111'='(AK00111) Wrangell'
                  'AK00112'='(AK00112) Valdez' 'AK00113'='(AK00113) Bethel' 'AK00114'='(AK00114) Cordova'
                  'AK00116'='(AK00116) Kotzebue' 'AK00117'='(AK00117) Palmer'
                  'AK00118'='(AK00118) North Slope Borough' 'AK00119'='(AK00119) Seldovia'
                  'AK00120'='(AK00120) Soldotna' 'AK00121'='(AK00121) Haines' 'AK00122'='(AK00122) Homer'
                  'AK00123'='(AK00123) Kenai' 'AK00124'='(AK00124) Spenard Service District'
                  'AK00126'='(AK00126) Fairbanks Intrnl Airport'
                  'AK00127'='(AK00127) Anchorage Intrntl Airpor' 'AK00128'='(AK00128) Whittier'
                  'AK00130'='(AK00130) Dillingham' 'AK00131'='(AK00131) Hoonah'
                  'AK00132'='(AK00132) North Pole' 'AK00133'='(AK00133) Unalaska'
                  'AK00135'='(AK00135) Klawock' 'AK00142'='(AK00142) Univ Of Ak: Fairbanks'
                  'AK00143'='(AK00143) Univ Of Ak: Anchorage' 'AK00145'='(AK00145) Craig'
                  'AK00146'='(AK00146) Bristol Bay Borough' 'AK00147'='(AK00147) Kake'
                  'AK00149'='(AK00149) Nenana' 'AK00150'='(AK00150) St. Paul'
                  'AK00152'='(AK00152) Sand Point' 'AK00154'='(AK00154) Togiak'
                  'AK00156'='(AK00156) Wasilla' 'AK00163'='(AK00163) Anvik' 'AK00164'='(AK00164) Emmonak'
                  'AK00166'='(AK00166) Houston' 'AK02004'='(AK02004) Alcohol Bev Control Brd'
                  'AKASP00'='(AKASP00) State Troopers' 'AL00100'='(AL00100) Jefferson'
                  'AL00101'='(AL00101) Bessemer' 'AL00102'='(AL00102) Birmingham'
                  'AL00103'='(AL00103) Mountain Brook' 'AL00104'='(AL00104) Fairfield'
                  'AL00105'='(AL00105) Gardendale' 'AL00106'='(AL00106) Leeds'
                  'AL00107'='(AL00107) Midfield' 'AL00108'='(AL00108) Tarrant City'
                  'AL00109'='(AL00109) Vestavia Hills' 'AL00110'='(AL00110) Homewood'
                  'AL00111'='(AL00111) Fultondale' 'AL00112'='(AL00112) Hoover'
                  'AL00113'='(AL00113) Irondale' 'AL00114'='(AL00114) Pleasant Grove'
                  'AL00115'='(AL00115) Roosevelt City' 'AL00116'='(AL00116) Graysville'
                  'AL00117'='(AL00117) Brownsville' 'AL00118'='(AL00118) Brighton'
                  'AL00119'='(AL00119) Hueytown' 'AL00120'='(AL00120) Lipscomb'
                  'AL00121'='(AL00121) Trussville' 'AL00122'='(AL00122) Adamsville'
                  'AL00123'='(AL00123) Warrior' 'AL00124'='(AL00124) Univ Of Al: Birmingham'
                  'AL00125'='(AL00125) Trafford' 'AL00126'='(AL00126) Morris'
                  'AL00127'='(AL00127) Brookside' 'AL00128'='(AL00128) Cardiff'
                  'AL00129'='(AL00129) Kimberly' 'AL00130'='(AL00130) County Line'
                  'AL00200'='(AL00200) Mobile' 'AL00201'='(AL00201) Mobile' 'AL00202'='(AL00202) Prichard'
                  'AL00203'='(AL00203) Chickasaw' 'AL00204'='(AL00204) Citronelle'
                  'AL00205'='(AL00205) Saraland' 'AL00206'='(AL00206) Bayou La Batre'
                  'AL00207'='(AL00207) Satsuma' 'AL00208'='(AL00208) Mount Vernon'
                  'AL00209'='(AL00209) Wilmer' 'AL00212'='(AL00212) Creola'
                  'AL00214'='(AL00214) Univ Of South Alabama'
                  'AL00215'='(AL00215) Dauphin Island' 'AL00300'='(AL00300) Montgomery'
                  'AL00301'='(AL00301) Montgomery' 'AL00303'='(AL00303) Al Conser Dpt Marine Pol'
                  'AL00304'='(AL00304) Al Alc Bev Control Board'
                  'AL00305'='(AL00305) Al Dept Of Mental Health'
                  'AL00306'='(AL00306) Alabama State University'
                  'AL00307'='(AL00307) Auburn Univ, Montgomery'
                  'AL00308'='(AL00308) Al Pub Serv Comm Enf Div'
                  'AL00313'='(AL00313) State Capitol Police'
                  'AL00319'='(AL00319) City Mntgmry Husng Au Iu'
                  'AL00322'='(AL00322) Baptist Medical Center'
                  'AL003FA'='(AL003FA) Faulkner University' 'AL00400'='(AL00400) Autauga'
                  'AL00401'='(AL00401) Prattville' 'AL00402'='(AL00402) Autaugaville'
                  'AL00500'='(AL00500) Baldwin' 'AL00501'='(AL00501) Bay Minette'
                  'AL00502'='(AL00502) Fairhope' 'AL00503'='(AL00503) Foley'
                  'AL00504'='(AL00504) Gulf Shores' 'AL00505'='(AL00505) Robertsdale'
                  'AL00506'='(AL00506) Loxley' 'AL00507'='(AL00507) Silverhill'
                  'AL00508'='(AL00508) Daphne' 'AL00509'='(AL00509) Summerdale'
                  'AL00510'='(AL00510) Elberta' 'AL00512'='(AL00512) Orange Beach'
                  'AL00513'='(AL00513) Spanish Fort' 'AL00600'='(AL00600) Barbour'
                  'AL00601'='(AL00601) Eufaula' 'AL00602'='(AL00602) Clayton' 'AL00603'='(AL00603) Clio'
                  'AL00604'='(AL00604) Louisville' 'AL00607'='(AL00607) Baker Hill'
                  'AL00700'='(AL00700) Bibb' 'AL00701'='(AL00701) Centreville' 'AL00702'='(AL00702) Brent'
                  'AL00703'='(AL00703) West Blocton' 'AL00704'='(AL00704) Woodstock'
                  'AL00800'='(AL00800) Blount' 'AL00801'='(AL00801) Oneonta'
                  'AL00802'='(AL00802) Blountsville' 'AL00803'='(AL00803) Cleveland'
                  'AL00804'='(AL00804) Snead' 'AL00805'='(AL00805) Highland Lake'
                  'AL00900'='(AL00900) Bullock' 'AL00901'='(AL00901) Union Springs'
                  'AL01000'='(AL01000) Butler' 'AL01001'='(AL01001) Greenville'
                  'AL01002'='(AL01002) Georgiana' 'AL01003'='(AL01003) Mckenzie'
                  'AL01100'='(AL01100) Calhoun' 'AL01101'='(AL01101) Anniston'
                  'AL01102'='(AL01102) Jacksonville' 'AL01103'='(AL01103) Piedmont'
                  'AL01104'='(AL01104) Weaver' 'AL01105'='(AL01105) Oxford'
                  'AL01106'='(AL01106) Hobson City' 'AL01107'='(AL01107) Ohatchee'
                  'AL01108'='(AL01108) Jacksonville State Univ' 'AL01200'='(AL01200) Chambers'
                  'AL01201'='(AL01201) Lafayette' 'AL01202'='(AL01202) Lanett' 'AL01204'='(AL01204) Valley'
                  'AL01300'='(AL01300) Cherokee' 'AL01301'='(AL01301) Centre'
                  'AL01302'='(AL01302) Cedar Bluff' 'AL01400'='(AL01400) Chilton'
                  'AL01401'='(AL01401) Clanton' 'AL01402'='(AL01402) Maplesville'
                  'AL01403'='(AL01403) Jemison' 'AL01404'='(AL01404) Thorsby' 'AL01500'='(AL01500) Choctaw'
                  'AL01501'='(AL01501) Butler' 'AL01502'='(AL01502) Gilbertown'
                  'AL01503'='(AL01503) Pennington' 'AL01504'='(AL01504) Silas' 'AL01505'='(AL01505) Toxey'
                  'AL01600'='(AL01600) Clarke' 'AL01601'='(AL01601) Jackson'
                  'AL01602'='(AL01602) Thomasville' 'AL01603'='(AL01603) Grove Hill'
                  'AL01604'='(AL01604) Fulton' 'AL01606'='(AL01606) Coffeeville' 'AL01700'='(AL01700) Clay'
                  'AL01701'='(AL01701) Ashland' 'AL01702'='(AL01702) Lineville'
                  'AL01800'='(AL01800) Cleburne' 'AL01801'='(AL01801) Heflin'
                  'AL01802'='(AL01802) Ranburne' 'AL01900'='(AL01900) Coffee' 'AL01901'='(AL01901) Elba'
                  'AL01902'='(AL01902) Enterprise' 'AL01903'='(AL01903) New Brockton'
                  'AL01904'='(AL01904) Kinston' 'AL01905'='(AL01905) Enterprise St Junior Co'
                  'AL02000'='(AL02000) Colbert' 'AL02001'='(AL02001) Sheffield'
                  'AL02002'='(AL02002) Tuscumbia' 'AL02003'='(AL02003) Muscle Shoals'
                  'AL02004'='(AL02004) Cherokee' 'AL02005'='(AL02005) Leighton'
                  'AL02006'='(AL02006) Littleville' 'AL02100'='(AL02100) Conecuh'
                  'AL02101'='(AL02101) Evergreen' 'AL02102'='(AL02102) Castleberry'
                  'AL02200'='(AL02200) Coosa' 'AL02201'='(AL02201) Goodwater'
                  'AL02202'='(AL02202) Rockford' 'AL02300'='(AL02300) Covington'
                  'AL02301'='(AL02301) Andalusia' 'AL02302'='(AL02302) Opp' 'AL02303'='(AL02303) Florala'
                  'AL02304'='(AL02304) Gantt' 'AL02305'='(AL02305) Red Level'
                  'AL02306'='(AL02306) Lockhart' 'AL02308'='(AL02308) 22nd Jud Circuit Drug Tf'
                  'AL02400'='(AL02400) Crenshaw' 'AL02401'='(AL02401) Luverne'
                  'AL02402'='(AL02402) Brantley' 'AL02403'='(AL02403) Dozier'
                  'AL02404'='(AL02404) Glenwood' 'AL02500'='(AL02500) Cullman'
                  'AL02501'='(AL02501) Cullman' 'AL02502'='(AL02502) Hanceville'
                  'AL02503'='(AL02503) Garden City' 'AL02504'='(AL02504) Good Hope'
                  'AL02600'='(AL02600) Dale' 'AL02601'='(AL02601) Ozark' 'AL02602'='(AL02602) Daleville'
                  'AL02603'='(AL02603) Level Plains' 'AL02604'='(AL02604) Napier Field'
                  'AL02605'='(AL02605) Newton' 'AL02606'='(AL02606) Midland City'
                  'AL02607'='(AL02607) Pinckard' 'AL02608'='(AL02608) Ariton'
                  'AL02609'='(AL02609) Clayhatchee' 'AL02700'='(AL02700) Dallas'
                  'AL02701'='(AL02701) Selma' 'AL02800'='(AL02800) De Kalb'
                  'AL02801'='(AL02801) Fort Payne' 'AL02802'='(AL02802) Collinsville'
                  'AL02803'='(AL02803) Geraldine' 'AL02804'='(AL02804) Henagar'
                  'AL02805'='(AL02805) Powell' 'AL02806'='(AL02806) Mentone'
                  'AL02807'='(AL02807) Rainsville' 'AL02808'='(AL02808) Hammondville'
                  'AL02810'='(AL02810) Crossville' 'AL02811'='(AL02811) Fyffe'
                  'AL02812'='(AL02812) Sylvania' 'AL02813'='(AL02813) Valley Head'
                  'AL02814'='(AL02814) Ider' 'AL02900'='(AL02900) Elmore' 'AL02901'='(AL02901) Wetumpka'
                  'AL02902'='(AL02902) Tallassee' 'AL02903'='(AL02903) Eclectic'
                  'AL02904'='(AL02904) Coosada' 'AL02906'='(AL02906) Millbrook'
                  'AL03000'='(AL03000) Escambia' 'AL03001'='(AL03001) Atmore' 'AL03002'='(AL03002) Brewton'
                  'AL03003'='(AL03003) East Brewton' 'AL03004'='(AL03004) Flomaton'
                  'AL03100'='(AL03100) Etowah' 'AL03101'='(AL03101) Attalla' 'AL03102'='(AL03102) Gadsden'
                  'AL03104'='(AL03104) Glencoe' 'AL03105'='(AL03105) Rainbow City'
                  'AL03106'='(AL03106) Hokes Bluff' 'AL03107'='(AL03107) Southside'
                  'AL03108'='(AL03108) Sardis City' 'AL03109'='(AL03109) Altoona'
                  'AL03200'='(AL03200) Fayette' 'AL03201'='(AL03201) Fayette' 'AL03202'='(AL03202) Berry'
                  'AL03300'='(AL03300) Franklin' 'AL03301'='(AL03301) Russellville'
                  'AL03302'='(AL03302) Phil Campbell' 'AL03303'='(AL03303) Red Bay'
                  'AL03304'='(AL03304) Vina' 'AL03305'='(AL03305) Hodges' 'AL03400'='(AL03400) Geneva'
                  'AL03401'='(AL03401) Geneva' 'AL03402'='(AL03402) Samson' 'AL03403'='(AL03403) Hartford'
                  'AL03404'='(AL03404) Slocomb' 'AL03405'='(AL03405) Coffee Springs'
                  'AL03500'='(AL03500) Greene' 'AL03501'='(AL03501) Eutaw' 'AL03600'='(AL03600) Hale'
                  'AL03601'='(AL03601) Greensboro' 'AL03602'='(AL03602) Moundville'
                  'AL03700'='(AL03700) Henry' 'AL03701'='(AL03701) Abbeville'
                  'AL03702'='(AL03702) Headland' 'AL03703'='(AL03703) Newville'
                  'AL03800'='(AL03800) Houston' 'AL03801'='(AL03801) Dothan' 'AL03802'='(AL03802) Ashford'
                  'AL03803'='(AL03803) Gordon' 'AL03804'='(AL03804) Columbia'
                  'AL03805'='(AL03805) Cottonwood' 'AL03806'='(AL03806) Kinsey'
                  'AL03808'='(AL03808) G c Wallace State Com Co' 'AL03809'='(AL03809) Taylor'
                  'AL03900'='(AL03900) Jackson' 'AL03901'='(AL03901) Scottsboro'
                  'AL03902'='(AL03902) Bridgeport' 'AL03903'='(AL03903) Stevenson'
                  'AL03904'='(AL03904) Hollywood' 'AL03905'='(AL03905) Pisgah' 'AL03906'='(AL03906) Dutton'
                  'AL03907'='(AL03907) Section' 'AL03908'='(AL03908) Woodville'
                  'AL03909'='(AL03909) Skyline' 'AL04000'='(AL04000) Lamar' 'AL04001'='(AL04001) Sulligent'
                  'AL04002'='(AL04002) Vernon' 'AL04003'='(AL04003) Kennedy' 'AL04004'='(AL04004) Millport'
                  'AL04100'='(AL04100) Lauderdale' 'AL04101'='(AL04101) Florence'
                  'AL04102'='(AL04102) Waterloo' 'AL04103'='(AL04103) Anderson'
                  'AL04104'='(AL04104) St. Florian' 'AL04105'='(AL04105) Lexington'
                  'AL04106'='(AL04106) Rogersville' 'AL04107'='(AL04107) Killen'
                  'AL04108'='(AL04108) Univ Of North Alabama' 'AL04200'='(AL04200) Lawrence'
                  'AL04201'='(AL04201) Moulton' 'AL04202'='(AL04202) Town Creek'
                  'AL04203'='(AL04203) Courtland' 'AL04204'='(AL04204) Hillsboro'
                  'AL04205'='(AL04205) North Courtland' 'AL04300'='(AL04300) Lee'
                  'AL04301'='(AL04301) Auburn' 'AL04302'='(AL04302) Opelika'
                  'AL04303'='(AL04303) Auburn Univ: Main Campus' 'AL04400'='(AL04400) Limestone'
                  'AL04401'='(AL04401) Athens' 'AL04402'='(AL04402) Ardmore' 'AL04403'='(AL04403) Elkmont'
                  'AL04500'='(AL04500) Lowndes' 'AL04501'='(AL04501) Fort Deposit'
                  'AL04502'='(AL04502) Hayneville' 'AL04504'='(AL04504) Mosses'
                  'AL04507'='(AL04507) 2nd Jud Circuit Drug T f' 'AL04600'='(AL04600) Macon'
                  'AL04601'='(AL04601) Tuskegee' 'AL04602'='(AL04602) Notasulga'
                  'AL04606'='(AL04606) Shorter' 'AL04700'='(AL04700) Madison'
                  'AL04701'='(AL04701) Huntsville' 'AL04702'='(AL04702) Madison'
                  'AL04703'='(AL04703) Gurley' 'AL04704'='(AL04704) New Hope'
                  'AL04705'='(AL04705) Owens Crossroads' 'AL04706'='(AL04706) Triana'
                  'AL04707'='(AL04707) Univ Of Al: Huntsville'
                  'AL04708'='(AL04708) Alabama A&m University'
                  'AL04709'='(AL04709) Huntsville Intnl Airport'
                  'AL04711'='(AL04711) Madison-Morgan Co S cd T' 'AL04800'='(AL04800) marengo'
                  'AL04801'='(AL04801) Demopolis' 'AL04802'='(AL04802) Linden'
                  'AL04803'='(AL04803) Thomaston' 'AL04804'='(AL04804) Faunsdale'
                  'AL04805'='(AL04805) Myrtlewood' 'AL04900'='(AL04900) Marion'
                  'AL04901'='(AL04901) Hamilton' 'AL04902'='(AL04902) Winfield' 'AL04903'='(AL04903) Guin'
                  'AL04904'='(AL04904) Hackleburg' 'AL04905'='(AL04905) Brilliant'
                  'AL04906'='(AL04906) Weston' 'AL04907'='(AL04907) Bear Creek'
                  'AL05000'='(AL05000) Marshall' 'AL05001'='(AL05001) Albertville'
                  'AL05002'='(AL05002) Guntersville' 'AL05003'='(AL05003) Arab' 'AL05004'='(AL05004) Boaz'
                  'AL05005'='(AL05005) Grant' 'AL05008'='(AL05008) Marshall Cty Drg Enfrc U'
                  'AL05100'='(AL05100) monroe' 'AL05101'='(AL05101) Monroeville'
                  'AL05102'='(AL05102) Frisco City' 'AL05103'='(AL05103) Beatrice'
                  'AL05104'='(AL05104) Excel' 'AL05200'='(AL05200) Morgan' 'AL05201'='(AL05201) Decatur'
                  'AL05202'='(AL05202) Hartselle' 'AL05204'='(AL05204) Falkville'
                  'AL05205'='(AL05205) Flint City' 'AL05206'='(AL05206) Somerville'
                  'AL05207'='(AL05207) Trinity' 'AL05209'='(AL05209) Priceville'
                  'AL05211'='(AL05211) Calhoun Community Colleg' 'AL05300'='(AL05300) Perry'
                  'AL05301'='(AL05301) Marion' 'AL05302'='(AL05302) Uniontown'
                  'AL05400'='(AL05400) Pickens' 'AL05401'='(AL05401) Aliceville'
                  'AL05402'='(AL05402) Gordo' 'AL05403'='(AL05403) Reform' 'AL05404'='(AL05404) Carrollton'
                  'AL05405'='(AL05405) Pickensville'
                  'AL05407'='(AL05407) 24th Jud Cir Drug & Vctf' 'AL05500'='(AL05500) Pike'
                  'AL05501'='(AL05501) Troy' 'AL05502'='(AL05502) Brundidge'
                  'AL05503'='(AL05503) Troy University' 'AL05600'='(AL05600) Randolph'
                  'AL05601'='(AL05601) Roanoke' 'AL05602'='(AL05602) Wadley' 'AL05603'='(AL05603) Wedowee'
                  'AL05700'='(AL05700) Russell' 'AL05701'='(AL05701) Phenix City'
                  'AL05702'='(AL05702) Hurtsboro' 'AL05800'='(AL05800) St. Clair'
                  'AL05801'='(AL05801) Pell City' 'AL05802'='(AL05802) Ashville'
                  'AL05803'='(AL05803) Ragland' 'AL05804'='(AL05804) Springville'
                  'AL05805'='(AL05805) Odenville' 'AL05806'='(AL05806) Moody'
                  'AL05807'='(AL05807) Riverside' 'AL05808'='(AL05808) Margaret'
                  'AL05809'='(AL05809) Steele' 'AL05812'='(AL05812) Argo' 'AL05900'='(AL05900) Shelby'
                  'AL05901'='(AL05901) Calera' 'AL05902'='(AL05902) Columbiana'
                  'AL05903'='(AL05903) Montevallo' 'AL05904'='(AL05904) Alabaster'
                  'AL05905'='(AL05905) Vincent' 'AL05906'='(AL05906) Pelham' 'AL05907'='(AL05907) Helena'
                  'AL05908'='(AL05908) Wilton' 'AL05909'='(AL05909) Harpersville'
                  'AL05910'='(AL05910) Wilsonville'
                  'AL05911'='(AL05911) University Of Montevallo' 'AL06000'='(AL06000) Sumter'
                  'AL06001'='(AL06001) York' 'AL06002'='(AL06002) Livingston' 'AL06003'='(AL06003) Cuba'
                  'AL06004'='(AL06004) Epes' 'AL06005'='(AL06005) University Of West Alaba'
                  'AL06100'='(AL06100) Talladega' 'AL06101'='(AL06101) Sylacauga'
                  'AL06102'='(AL06102) Talladega' 'AL06103'='(AL06103) Childersburg'
                  'AL06104'='(AL06104) Lincoln' 'AL06105'='(AL06105) Waldo'
                  'AL06106'='(AL06106) Talladega College' 'AL06200'='(AL06200) Tallapoosa'
                  'AL06201'='(AL06201) Alexander City' 'AL06202'='(AL06202) Dadeville'
                  'AL06203'='(AL06203) Camp Hill' 'AL06204'='(AL06204) Carrville'
                  'AL06205'='(AL06205) Daviston' 'AL06206'='(AL06206) New Site'
                  'AL06300'='(AL06300) Tuscaloosa' 'AL06301'='(AL06301) Tuscaloosa'
                  'AL06302'='(AL06302) Northport' 'AL06303'='(AL06303) Univ Of Al: Tuscaloosa'
                  'AL06305'='(AL06305) Bryce State Hospital' 'AL06307'='(AL06307) Vance'
                  'AL06311'='(AL06311) Lake View' 'AL06400'='(AL06400) Walker' 'AL06401'='(AL06401) Jasper'
                  'AL06402'='(AL06402) Carbon Hill' 'AL06403'='(AL06403) Cordova'
                  'AL06404'='(AL06404) Dora' 'AL06405'='(AL06405) Sumiton' 'AL06406'='(AL06406) Parrish'
                  'AL06407'='(AL06407) Oakman' 'AL06408'='(AL06408) Nauvoo' 'AL06409'='(AL06409) Sipsey'
                  'AL06500'='(AL06500) Washington' 'AL06501'='(AL06501) Mcintosh'
                  'AL06502'='(AL06502) Millry' 'AL06503'='(AL06503) Chatom' 'AL06600'='(AL06600) Wilcox'
                  'AL06601'='(AL06601) Camden' 'AL06602'='(AL06602) Pine Hill'
                  'AL06700'='(AL06700) Winston' 'AL06701'='(AL06701) Double Springs'
                  'AL06702'='(AL06702) Haleyville' 'AL06703'='(AL06703) Addison'
                  'AL06704'='(AL06704) Arley' 'AL06705'='(AL06705) Lynn'
                  'ALAST00'='(ALAST00) Alabama Highway Patrol' 'AR00100'='(AR00100) Arkansas'
                  'AR00101'='(AR00101) De Witt' 'AR00102'='(AR00102) Stuttgart'
                  'AR00103'='(AR00103) Gillett' 'AR00200'='(AR00200) Ashley' 'AR00201'='(AR00201) Crossett'
                  'AR00202'='(AR00202) Hamburg' 'AR00203'='(AR00203) Wilmot' 'AR00300'='(AR00300) Baxter'
                  'AR00301'='(AR00301) Mountain Home' 'AR00302'='(AR00302) Cotter'
                  'AR00303'='(AR00303) Gassville' 'AR00304'='(AR00304) Lakeview'
                  'AR00400'='(AR00400) Benton' 'AR00401'='(AR00401) Bentonville'
                  'AR00402'='(AR00402) Rogers' 'AR00403'='(AR00403) Siloam Springs'
                  'AR00404'='(AR00404) Pea Ridge' 'AR00405'='(AR00405) Gentry' 'AR00406'='(AR00406) Lowell'
                  'AR00407'='(AR00407) Gravette' 'AR00408'='(AR00408) Decatur'
                  'AR00409'='(AR00409) Cave Springs' 'AR00411'='(AR00411) Sulphur Springs'
                  'AR00413'='(AR00413) Centerton' 'AR00414'='(AR00414) Nw Arkansas Community Co'
                  'AR00416'='(AR00416) Little Flock' 'AR00500'='(AR00500) Boone'
                  'AR00501'='(AR00501) Harrison' 'AR00600'='(AR00600) Bradley' 'AR00601'='(AR00601) Warren'
                  'AR00602'='(AR00602) Hermitage' 'AR00700'='(AR00700) Calhoun'
                  'AR00701'='(AR00701) Hampton' 'AR00800'='(AR00800) Carroll'
                  'AR00801'='(AR00801) Berryville' 'AR00802'='(AR00802) Eureka Springs'
                  'AR00803'='(AR00803) Green Forest' 'AR00900'='(AR00900) Chicot'
                  'AR00901'='(AR00901) Dermott' 'AR00902'='(AR00902) Eudora'
                  'AR00903'='(AR00903) Lake Village' 'AR01000'='(AR01000) Clark'
                  'AR01001'='(AR01001) Arkadelphia' 'AR01002'='(AR01002) Gurdon'
                  'AR01003'='(AR01003) Caddo Valley'
                  'AR01004'='(AR01004) Henderson State Universi' 'AR01100'='(AR01100) Clay'
                  'AR01101'='(AR01101) Corning' 'AR01102'='(AR01102) Piggott'
                  'AR01200'='(AR01200) Cleburne' 'AR01201'='(AR01201) Heber Springs'
                  'AR01202'='(AR01202) Quitman' 'AR01203'='(AR01203) Greers Ferry'
                  'AR01300'='(AR01300) Cleveland' 'AR01301'='(AR01301) Rison'
                  'AR01400'='(AR01400) Columbia' 'AR01401'='(AR01401) Magnolia'
                  'AR01405'='(AR01405) Southern Arkansas Univ' 'AR01500'='(AR01500) Conway'
                  'AR01501'='(AR01501) Morrilton' 'AR01503'='(AR01503) Plummerville'
                  'AR01600'='(AR01600) Craighead' 'AR01601'='(AR01601) Jonesboro'
                  'AR01602'='(AR01602) Caraway' 'AR01603'='(AR01603) Lake City' 'AR01604'='(AR01604) Bay'
                  'AR01605'='(AR01605) Ar State Univ: Jonesboro' 'AR01607'='(AR01607) Bono'
                  'AR01700'='(AR01700) Crawford' 'AR01701'='(AR01701) Van Buren' 'AR01702'='(AR01702) Alma'
                  'AR01703'='(AR01703) Mulberry' 'AR01800'='(AR01800) Crittenden'
                  'AR01801'='(AR01801) West Memphis' 'AR01802'='(AR01802) Earle'
                  'AR01804'='(AR01804) Marion' 'AR01900'='(AR01900) Cross' 'AR01901'='(AR01901) Wynne'
                  'AR02000'='(AR02000) Dallas' 'AR02001'='(AR02001) Fordyce' 'AR02100'='(AR02100) Desha'
                  'AR02101'='(AR02101) Mcgehee' 'AR02102'='(AR02102) Arkansas City'
                  'AR02103'='(AR02103) Dumas' 'AR02200'='(AR02200) Drew' 'AR02201'='(AR02201) Monticello'
                  'AR02203'='(AR02203) Univ Of Ar: Monticello' 'AR02300'='(AR02300) Faulkner'
                  'AR02301'='(AR02301) Conway' 'AR02302'='(AR02302) Greenbrier'
                  'AR02303'='(AR02303) Mayflower' 'AR02304'='(AR02304) Vilonia'
                  'AR02306'='(AR02306) Univ Of Central Arkansas' 'AR02400'='(AR02400) Franklin'
                  'AR02401'='(AR02401) Ozark' 'AR02402'='(AR02402) Charleston' 'AR02500'='(AR02500) Fulton'
                  'AR02501'='(AR02501) Salem' 'AR02502'='(AR02502) Mammoth Spring'
                  'AR02600'='(AR02600) Garland' 'AR02601'='(AR02601) Hot Springs'
                  'AR02603'='(AR02603) Mountain Pine' 'AR02700'='(AR02700) Grant'
                  'AR02701'='(AR02701) Sheridan' 'AR02800'='(AR02800) Greene'
                  'AR02801'='(AR02801) Paragould' 'AR02802'='(AR02802) Marmaduke'
                  'AR02900'='(AR02900) Hempstead' 'AR02901'='(AR02901) Hope'
                  'AR03000'='(AR03000) Hot Spring' 'AR03001'='(AR03001) Malvern'
                  'AR03003'='(AR03003) Rockport' 'AR03100'='(AR03100) Howard'
                  'AR03101'='(AR03101) Nashville' 'AR03102'='(AR03102) Dierks'
                  'AR03104'='(AR03104) Mineral Springs' 'AR03200'='(AR03200) Independence'
                  'AR03201'='(AR03201) Batesville' 'AR03202'='(AR03202) Newark'
                  'AR03203'='(AR03203) Newark' 'AR03300'='(AR03300) Izard'
                  'AR03302'='(AR03302) Horseshoe Bend' 'AR03400'='(AR03400) Jackson'
                  'AR03401'='(AR03401) Newport' 'AR03402'='(AR03402) Tuckerman' 'AR03403'='(AR03403) Diaz'
                  'AR03406'='(AR03406) Swifton' 'AR03500'='(AR03500) Jefferson'
                  'AR03501'='(AR03501) Pine Bluff' 'AR03502'='(AR03502) White Hall'
                  'AR03503'='(AR03503) Redfield' 'AR03504'='(AR03504) Univ Of Ar: Pine Bluff'
                  'AR03506'='(AR03506) Altheimer' 'AR03600'='(AR03600) Johnson'
                  'AR03601'='(AR03601) Clarksville' 'AR03603'='(AR03603) Lamar'
                  'AR03700'='(AR03700) Lafayette' 'AR03702'='(AR03702) Stamps'
                  'AR03703'='(AR03703) Lewisville' 'AR03800'='(AR03800) Lawrence'
                  'AR03801'='(AR03801) Walnut Ridge' 'AR03802'='(AR03802) Hoxie' 'AR03900'='(AR03900) Lee'
                  'AR03901'='(AR03901) Marianna' 'AR04000'='(AR04000) Lincoln' 'AR04001'='(AR04001) Gould'
                  'AR04002'='(AR04002) Star City' 'AR04003'='(AR04003) Grady'
                  'AR04100'='(AR04100) Little River' 'AR04101'='(AR04101) Ashdown'
                  'AR04102'='(AR04102) Foreman' 'AR04200'='(AR04200) Logan'
                  'AR04201'='(AR04201) Booneville' 'AR04202'='(AR04202) Paris' 'AR04300'='(AR04300) Lonoke'
                  'AR04301'='(AR04301) England' 'AR04302'='(AR04302) Cabot' 'AR04303'='(AR04303) Carlisle'
                  'AR04304'='(AR04304) Lonoke' 'AR04305'='(AR04305) Austin' 'AR04306'='(AR04306) Ward'
                  'AR04400'='(AR04400) Madison' 'AR04401'='(AR04401) Huntsville'
                  'AR04500'='(AR04500) Marion' 'AR04501'='(AR04501) Yellville'
                  'AR04502'='(AR04502) Bull Shoals' 'AR04503'='(AR04503) Flippin'
                  'AR04600'='(AR04600) Miller' 'AR04601'='(AR04601) Texarkana'
                  'AR04700'='(AR04700) Mississippi' 'AR04701'='(AR04701) Blytheville'
                  'AR04702'='(AR04702) Osceola' 'AR04703'='(AR04703) Leachville'
                  'AR04705'='(AR04705) Luxora' 'AR04707'='(AR04707) Gosnell' 'AR04708'='(AR04708) Keiser'
                  'AR04709'='(AR04709) Dell' 'AR04710'='(AR04710) Etowah' 'AR04800'='(AR04800) Monroe'
                  'AR04801'='(AR04801) Brinkley' 'AR04802'='(AR04802) Clarendon'
                  'AR04803'='(AR04803) Holly Grove' 'AR04900'='(AR04900) Montgomery'
                  'AR05000'='(AR05000) Nevada' 'AR05001'='(AR05001) Prescott' 'AR05100'='(AR05100) Newton'
                  'AR05200'='(AR05200) Ouachita' 'AR05201'='(AR05201) Camden' 'AR05202'='(AR05202) Bearden'
                  'AR05203'='(AR05203) Stephens' 'AR05300'='(AR05300) Perry'
                  'AR05301'='(AR05301) Perryville' 'AR05400'='(AR05400) Phillips'
                  'AR05401'='(AR05401) Helena' 'AR05402'='(AR05402) Helena-West Helena'
                  'AR05403'='(AR05403) Marvell' 'AR05404'='(AR05404) Elaine' 'AR05500'='(AR05500) Pike'
                  'AR05501'='(AR05501) Murfreesboro' 'AR05502'='(AR05502) Glenwood'
                  'AR05600'='(AR05600) Poinsett' 'AR05601'='(AR05601) Marked Tree'
                  'AR05602'='(AR05602) Trumann' 'AR05603'='(AR05603) Harrisburg'
                  'AR05604'='(AR05604) Lepanto' 'AR05605'='(AR05605) Tyronza' 'AR05607'='(AR05607) Weiner'
                  'AR05700'='(AR05700) Polk' 'AR05701'='(AR05701) Mena' 'AR05800'='(AR05800) Pope'
                  'AR05801'='(AR05801) Russellville' 'AR05802'='(AR05802) Atkins'
                  'AR05804'='(AR05804) Ar Tech University' 'AR05807'='(AR05807) Dover'
                  'AR05809'='(AR05809) Hector' 'AR05810'='(AR05810) Pottsville'
                  'AR05900'='(AR05900) Prairie' 'AR05901'='(AR05901) Hazen' 'AR05902'='(AR05902) Des Arc'
                  'AR05903'='(AR05903) De Valls Bluff' 'AR06000'='(AR06000) Pulaski'
                  'AR06001'='(AR06001) Jacksonville' 'AR06002'='(AR06002) Little Rock'
                  'AR06003'='(AR06003) North Little Rock' 'AR06004'='(AR06004) Sherwood'
                  'AR06005'='(AR06005) Univ Of Ar: Little Rock'
                  'AR06008'='(AR06008) Cammack Village'
                  'AR06009'='(AR06009) Univ Of Ar: Medical Scie'
                  'AR06014'='(AR06014) Camp Robinson' 'AR06016'='(AR06016) Maumelle'
                  'AR06017'='(AR06017) State Capitol Police' 'AR06100'='(AR06100) Randolph'
                  'AR06101'='(AR06101) Pocahontas' 'AR06200'='(AR06200) St. Francis'
                  'AR06201'='(AR06201) Forrest City' 'AR06300'='(AR06300) Saline'
                  'AR06301'='(AR06301) Benton' 'AR06302'='(AR06302) Bryant' 'AR06400'='(AR06400) Scott'
                  'AR06401'='(AR06401) Waldron' 'AR06500'='(AR06500) Searcy'
                  'AR06600'='(AR06600) Sebastian' 'AR06601'='(AR06601) Fort Smith'
                  'AR06602'='(AR06602) Greenwood' 'AR06603'='(AR06603) Barling'
                  'AR06700'='(AR06700) Sevier' 'AR06701'='(AR06701) De Queen' 'AR06800'='(AR06800) Sharp'
                  'AR06801'='(AR06801) Cave City' 'AR06803'='(AR06803) Ash Flat'
                  'AR06804'='(AR06804) Cherokee Village' 'AR06806'='(AR06806) Highland'
                  'AR06900'='(AR06900) Stone' 'AR06901'='(AR06901) Mountain View'
                  'AR07000'='(AR07000) Union' 'AR07001'='(AR07001) El Dorado'
                  'AR07002'='(AR07002) Smackover' 'AR07100'='(AR07100) Van Buren'
                  'AR07101'='(AR07101) Fairfield Bay' 'AR07102'='(AR07102) Clinton'
                  'AR07200'='(AR07200) Washington' 'AR07201'='(AR07201) Fayetteville'
                  'AR07202'='(AR07202) Springdale' 'AR07203'='(AR07203) Prairie Grove'
                  'AR07204'='(AR07204) Univ Of Ar: Fayetteville' 'AR07205'='(AR07205) Farmington'
                  'AR07206'='(AR07206) Lincoln' 'AR07207'='(AR07207) Greenland'
                  'AR07208'='(AR07208) West Fork' 'AR07209'='(AR07209) Johnson'
                  'AR07210'='(AR07210) Elkins' 'AR07300'='(AR07300) White' 'AR07301'='(AR07301) Searcy'
                  'AR07302'='(AR07302) Bald Knob' 'AR07303'='(AR07303) Beebe' 'AR07304'='(AR07304) Kensett'
                  'AR07305'='(AR07305) Pangburn' 'AR07306'='(AR07306) Rose Bud'
                  'AR07307'='(AR07307) Judsonia' 'AR07308'='(AR07308) Bradford'
                  'AR07309'='(AR07309) Higginson' 'AR07310'='(AR07310) Mcrae'
                  'AR07312'='(AR07312) Ar State Univ: Beebe' 'AR07400'='(AR07400) Woodruff'
                  'AR07401'='(AR07401) Augusta' 'AR07402'='(AR07402) Mccrory' 'AR07500'='(AR07500) Yell'
                  'AR07501'='(AR07501) Dardanelle' 'AR07502'='(AR07502) Danville' 'AR07503'='(AR07503) Ola'
                  'AR07504'='(AR07504) Plainview' 'ARASP00'='(ARASP00) Arkansas State Police'
                  'AZ00100'='(AZ00100) Apache' 'AZ00101'='(AZ00101) Eagar' 'AZ00103'='(AZ00103) St. Johns'
                  'AZ00105'='(AZ00105) Springerville' 'AZ00200'='(AZ00200) Cochise'
                  'AZ00201'='(AZ00201) Benson' 'AZ00203'='(AZ00203) Bisbee' 'AZ00205'='(AZ00205) Douglas'
                  'AZ00207'='(AZ00207) Huachuca City' 'AZ00209'='(AZ00209) Sierra Vista'
                  'AZ00211'='(AZ00211) Tombstone' 'AZ00213'='(AZ00213) Willcox'
                  'AZ00300'='(AZ00300) Coconino' 'AZ00301'='(AZ00301) Flagstaff'
                  'AZ00303'='(AZ00303) Fredonia' 'AZ00307'='(AZ00307) Williams' 'AZ00308'='(AZ00308) Page'
                  'AZ00310'='(AZ00310) Sedona' 'AZ00397'='(AZ00397) Northern Arizona Univ'
                  'AZ00400'='(AZ00400) Gila' 'AZ00401'='(AZ00401) Globe' 'AZ00403'='(AZ00403) Hayden'
                  'AZ00405'='(AZ00405) Miami' 'AZ00406'='(AZ00406) Payson' 'AZ00407'='(AZ00407) Winkelman'
                  'AZ00489'='(AZ00489) San Carlos Tribal' 'AZ00500'='(AZ00500) Graham'
                  'AZ00501'='(AZ00501) Pima' 'AZ00503'='(AZ00503) Safford' 'AZ00505'='(AZ00505) Thatcher'
                  'AZ00597'='(AZ00597) Eastern Arizona College' 'AZ00600'='(AZ00600) Greenlee'
                  'AZ00601'='(AZ00601) Clifton' 'AZ00603'='(AZ00603) Duncan' 'AZ00700'='(AZ00700) Maricopa'
                  'AZ00701'='(AZ00701) Avondale' 'AZ00703'='(AZ00703) Buckeye'
                  'AZ00705'='(AZ00705) Chandler' 'AZ00707'='(AZ00707) El Mirage'
                  'AZ00709'='(AZ00709) Gila Bend' 'AZ00711'='(AZ00711) Gilbert'
                  'AZ00713'='(AZ00713) Glendale' 'AZ00715'='(AZ00715) Goodyear' 'AZ00717'='(AZ00717) Mesa'
                  'AZ00719'='(AZ00719) Paradise Valley' 'AZ00721'='(AZ00721) Peoria'
                  'AZ00723'='(AZ00723) Phoenix' 'AZ00725'='(AZ00725) Scottsdale'
                  'AZ00727'='(AZ00727) Surprise' 'AZ00729'='(AZ00729) Tempe' 'AZ00731'='(AZ00731) Tolleson'
                  'AZ00733'='(AZ00733) Wickenburg' 'AZ00735'='(AZ00735) Youngtown'
                  'AZ00739'='(AZ00739) Guadalupe' 'AZ00744'='(AZ00744) Arizona State Capitol'
                  'AZ00757'='(AZ00757) Az State Univ: West'
                  'AZ00788'='(AZ00788) Az State Univ: East'
                  'AZ00797'='(AZ00797) Az State Univ, Main Camp' 'AZ00800'='(AZ00800) Mohave'
                  'AZ00801'='(AZ00801) Kingman' 'AZ00804'='(AZ00804) Lake Havasu City'
                  'AZ00805'='(AZ00805) Bullhead City' 'AZ00806'='(AZ00806) Colorado City'
                  'AZ00900'='(AZ00900) Navajo' 'AZ00901'='(AZ00901) Holbrook'
                  'AZ00903'='(AZ00903) Show Low' 'AZ00905'='(AZ00905) Snowflake-Taylor'
                  'AZ00907'='(AZ00907) Taylor' 'AZ00909'='(AZ00909) Winslow'
                  'AZ00913'='(AZ00913) Pinetop-Lakeside' 'AZ01000'='(AZ01000) Pima'
                  'AZ01001'='(AZ01001) South Tucson' 'AZ01003'='(AZ01003) Tucson'
                  'AZ01004'='(AZ01004) Sahuarita' 'AZ01006'='(AZ01006) Ajo'
                  'AZ01007'='(AZ01007) Oro Valley' 'AZ01009'='(AZ01009) Marana'
                  'AZ01097'='(AZ01097) University Of Arizona'
                  'AZ01098'='(AZ01098) Pima Community College' 'AZ01100'='(AZ01100) Pinal'
                  'AZ01101'='(AZ01101) Casa Grande' 'AZ01103'='(AZ01103) Coolidge'
                  'AZ01105'='(AZ01105) Eloy' 'AZ01107'='(AZ01107) Florence' 'AZ01109'='(AZ01109) Kearny'
                  'AZ01111'='(AZ01111) Mammoth' 'AZ01112'='(AZ01112) Superior'
                  'AZ01113'='(AZ01113) Apache Junction'
                  'AZ01197'='(AZ01197) Central Arizona College' 'AZ01200'='(AZ01200) Santa Cruz'
                  'AZ01201'='(AZ01201) Nogales' 'AZ01203'='(AZ01203) Patagonia'
                  'AZ01300'='(AZ01300) Yavapai' 'AZ01301'='(AZ01301) Clarkdale'
                  'AZ01303'='(AZ01303) Cottonwood' 'AZ01305'='(AZ01305) Jerome'
                  'AZ01307'='(AZ01307) Prescott' 'AZ01308'='(AZ01308) Yavapai College'
                  'AZ01311'='(AZ01311) Prescott Valley' 'AZ01312'='(AZ01312) Chino Valley'
                  'AZ01313'='(AZ01313) Camp Verde' 'AZ01314'='(AZ01314) Sedona' 'AZ01400'='(AZ01400) Yuma'
                  'AZ01403'='(AZ01403) Somerton' 'AZ01405'='(AZ01405) Yuma' 'AZ01408'='(AZ01408) San Luis'
                  'AZ01409'='(AZ01409) Wellton' 'AZ01497'='(AZ01497) Arizona Western College'
                  'AZ01500'='(AZ01500) La Paz' 'AZ01501'='(AZ01501) Parker'
                  'AZ01503'='(AZ01503) Quartzsite' 'AZCCHPX'='(AZCCHPX) Az Dept Of Public Safety'
                  'CA00100'='(CA00100) Alameda' 'CA00101'='(CA00101) Alameda' 'CA00102'='(CA00102) Albany'
                  'CA00103'='(CA00103) Berkeley' 'CA00104'='(CA00104) Emeryville'
                  'CA00105'='(CA00105) Fremont' 'CA00106'='(CA00106) Hayward'
                  'CA00107'='(CA00107) Livermore' 'CA00108'='(CA00108) Newark'
                  'CA00109'='(CA00109) Oakland' 'CA00110'='(CA00110) Piedmont'
                  'CA00111'='(CA00111) Pleasanton' 'CA00112'='(CA00112) San Leandro'
                  'CA00113'='(CA00113) Union City' 'CA00114'='(CA00114) E bay Reg Pks:Alameda Co'
                  'CA00115'='(CA00115) Ca St Un: East Bay'
                  'CA00116'='(CA00116) Uprr: Alameda County'
                  'CA00121'='(CA00121) Sf Bart: Alameda County'
                  'CA00122'='(CA00122) Uc:Lawrence-Livermore La'
                  'CA00127'='(CA00127) Un Ca: Lawrence Berkeley'
                  'CA00128'='(CA00128) Bnsf Rwy: Alameda County'
                  'CA00129'='(CA00129) Spt Alameda' 'CA00130'='(CA00130) Dublin'
                  'CA00131'='(CA00131) E bay Municipal Utility'
                  'CA00132'='(CA00132) Uprr Alameda County'
                  'CA00197'='(CA00197) Un Of Ca: Berkeley'
                  'CA00198'='(CA00198) Alameda State Police'
                  'CA00199'='(CA00199) Hp: Alameda County' 'CA00200'='(CA00200) Alpine'
                  'CA00299'='(CA00299) Hp: Alpine County' 'CA00300'='(CA00300) Amador'
                  'CA00301'='(CA00301) Amador' 'CA00302'='(CA00302) Ione' 'CA00303'='(CA00303) Jackson'
                  'CA00304'='(CA00304) Plymouth' 'CA00305'='(CA00305) Sutter Creek'
                  'CA00306'='(CA00306) Uprr: Amador County'
                  'CA00399'='(CA00399) Hp: Amador County' 'CA00400'='(CA00400) Butte'
                  'CA00401'='(CA00401) Biggs' 'CA00402'='(CA00402) Chico' 'CA00403'='(CA00403) Gridley'
                  'CA00404'='(CA00404) Oroville' 'CA00405'='(CA00405) Paradise'
                  'CA00406'='(CA00406) Uprr: Butte County'
                  'CA00407'='(CA00407) Dpr: Northern Buttes'
                  'CA00409'='(CA00409) Dpr: Upper Valley' 'CA00411'='(CA00411) Uprr Butte County'
                  'CA00497'='(CA00497) Ca St Un: Chico' 'CA00498'='(CA00498) Butte State Police'
                  'CA00499'='(CA00499) Hp: Butte County' 'CA00500'='(CA00500) Calaveras'
                  'CA00501'='(CA00501) City Of Angels'
                  'CA00502'='(CA00502) Uprr: Calaveras County'
                  'CA00503'='(CA00503) Dpr: Calaveras County'
                  'CA00599'='(CA00599) Hp: Calaveras County' 'CA00600'='(CA00600) Colusa'
                  'CA00601'='(CA00601) Colusa' 'CA00602'='(CA00602) Williams'
                  'CA00603'='(CA00603) Uprr: Colusa County'
                  'CA00698'='(CA00698) Colusa State Police'
                  'CA00699'='(CA00699) Hp: Colusa County' 'CA00700'='(CA00700) Contra Costa'
                  'CA00701'='(CA00701) Antioch' 'CA00702'='(CA00702) Brentwood'
                  'CA00703'='(CA00703) Clayton' 'CA00704'='(CA00704) Concord'
                  'CA00705'='(CA00705) El Cerrito' 'CA00706'='(CA00706) Hercules'
                  'CA00707'='(CA00707) Pinole' 'CA00708'='(CA00708) Pittsburg'
                  'CA00709'='(CA00709) Pleasant Hill' 'CA00710'='(CA00710) Richmond'
                  'CA00711'='(CA00711) San Pablo' 'CA00712'='(CA00712) Walnut Creek'
                  'CA00713'='(CA00713) Kensington' 'CA00714'='(CA00714) Martinez'
                  'CA00715'='(CA00715) Lafayette' 'CA00716'='(CA00716) Moraga'
                  'CA00717'='(CA00717) E by Reg Pk:Contra Costa'
                  'CA00718'='(CA00718) Sf Bart:Contra Costa Cty'
                  'CA00719'='(CA00719) Bnsf Rwy:Contra Costa Co'
                  'CA00720'='(CA00720) Spt Contra Costa'
                  'CA00721'='(CA00721) Contra Costa Comm Colleg' 'CA00723'='(CA00723) Danville'
                  'CA00724'='(CA00724) San Ramon' 'CA00725'='(CA00725) Dpr:Contra Costa County'
                  'CA00726'='(CA00726) Orinda' 'CA00733'='(CA00733) Uprr:Contra Costa County'
                  'CA00734'='(CA00734) Oakley' 'CA00798'='(CA00798) Contra Costa State Polic'
                  'CA00799'='(CA00799) Hp: Contra Costa County' 'CA00800'='(CA00800) Del Norte'
                  'CA00801'='(CA00801) Crescent City' 'CA00899'='(CA00899) Hp: Del Norte County'
                  'CA00900'='(CA00900) El Dorado' 'CA00901'='(CA00901) Placerville'
                  'CA00902'='(CA00902) South Lake Tahoe'
                  'CA00903'='(CA00903) Uprr: El Dorado County'
                  'CA00923'='(CA00923) Dpr: El Dorado County'
                  'CA00998'='(CA00998) El Dorado State Police'
                  'CA00999'='(CA00999) Hp: El Dorado County' 'CA01000'='(CA01000) Fresno'
                  'CA01001'='(CA01001) Clovis' 'CA01002'='(CA01002) Coalinga'
                  'CA01003'='(CA01003) Firebaugh' 'CA01004'='(CA01004) Fowler' 'CA01005'='(CA01005) Fresno'
                  'CA01006'='(CA01006) Huron' 'CA01007'='(CA01007) Kerman' 'CA01008'='(CA01008) Kingsburg'
                  'CA01009'='(CA01009) Mendota' 'CA01010'='(CA01010) Orange Cove'
                  'CA01011'='(CA01011) Parlier' 'CA01012'='(CA01012) Reedley' 'CA01013'='(CA01013) Sanger'
                  'CA01014'='(CA01014) San Joaquin' 'CA01015'='(CA01015) Selma'
                  'CA01017'='(CA01017) Fresno Community College'
                  'CA01018'='(CA01018) Bnsf Rwy: Fresno County' 'CA01019'='(CA01019) Spt Fresno'
                  'CA01024'='(CA01024) Uprr: Fresno County'
                  'CA01030'='(CA01030) Dpr: San Joaquin'
                  'CA01031'='(CA01031) Kings River Comm College'
                  'CA01097'='(CA01097) Ca St Un: Fresno'
                  'CA01098'='(CA01098) Fresno State Police'
                  'CA01099'='(CA01099) Hp: Fresno County' 'CA01100'='(CA01100) Glenn'
                  'CA01101'='(CA01101) Orland' 'CA01102'='(CA01102) Willows'
                  'CA01103'='(CA01103) Uprr: Glenn County' 'CA01199'='(CA01199) Hp: Glenn County'
                  'CA01200'='(CA01200) Humboldt' 'CA01201'='(CA01201) Arcata'
                  'CA01202'='(CA01202) Blue Lake' 'CA01203'='(CA01203) Eureka'
                  'CA01204'='(CA01204) Ferndale' 'CA01205'='(CA01205) Fortuna'
                  'CA01206'='(CA01206) Trinidad' 'CA01207'='(CA01207) Rio Dell'
                  'CA01208'='(CA01208) Humboldt State Universit'
                  'CA01209'='(CA01209) Uprr: Humboldt County'
                  'CA01210'='(CA01210) Dpr: Eel River'
                  'CA01211'='(CA01211) Dpr:North Coast Redwoods'
                  'CA01299'='(CA01299) Hp: Humboldt County' 'CA01300'='(CA01300) Imperial'
                  'CA01301'='(CA01301) Brawley' 'CA01302'='(CA01302) Calexico'
                  'CA01303'='(CA01303) Calipatria' 'CA01304'='(CA01304) El Centro'
                  'CA01305'='(CA01305) Holtville' 'CA01306'='(CA01306) Imperial'
                  'CA01307'='(CA01307) Westmorland' 'CA01308'='(CA01308) Uprr: Imperial County'
                  'CA01309'='(CA01309) Dpr: Imperial County'
                  'CA01398'='(CA01398) Imperial State Police'
                  'CA01399'='(CA01399) Hp: Imperial County' 'CA01400'='(CA01400) Inyo'
                  'CA01401'='(CA01401) Bishop' 'CA01403'='(CA01403) Uprr: Inyo County'
                  'CA01499'='(CA01499) Hp: Inyo County' 'CA01500'='(CA01500) Kern'
                  'CA01501'='(CA01501) Arvin' 'CA01502'='(CA01502) Bakersfield'
                  'CA01503'='(CA01503) Delano' 'CA01504'='(CA01504) Maricopa'
                  'CA01505'='(CA01505) Mcfarland' 'CA01506'='(CA01506) Ridgecrest'
                  'CA01507'='(CA01507) Shafter' 'CA01508'='(CA01508) Taft' 'CA01509'='(CA01509) Tehachapi'
                  'CA01510'='(CA01510) Wasco' 'CA01511'='(CA01511) California City'
                  'CA01513'='(CA01513) China Lake' 'CA01514'='(CA01514) Stallion Springs'
                  'CA01515'='(CA01515) Bear Valley' 'CA01516'='(CA01516) Bnsf Rwy: Kern County'
                  'CA01517'='(CA01517) So Pacific Trans Kern'
                  'CA01522'='(CA01522) Uprr: Kern County'
                  'CA01597'='(CA01597) Ca St Un: Bakersfield'
                  'CA01598'='(CA01598) Kern State Police' 'CA01599'='(CA01599) Hp: Kern County'
                  'CA01600'='(CA01600) Kings' 'CA01601'='(CA01601) Corcoran' 'CA01602'='(CA01602) Hanford'
                  'CA01603'='(CA01603) Lemoore' 'CA01604'='(CA01604) Bnsf Rwy: Kings County'
                  'CA01605'='(CA01605) Uprr: Kings County'
                  'CA01606'='(CA01606) Porterville Develop Cent' 'CA01607'='(CA01607) Avenal'
                  'CA01698'='(CA01698) Kings State Police' 'CA01699'='(CA01699) Hp: Kings County'
                  'CA01700'='(CA01700) Lake' 'CA01701'='(CA01701) Lakeport' 'CA01702'='(CA01702) Clearlake'
                  'CA01703'='(CA01703) Dpr: Lake County' 'CA01799'='(CA01799) Hp: Lake County'
                  'CA01800'='(CA01800) Lassen' 'CA01801'='(CA01801) Susanville'
                  'CA01803'='(CA01803) Uprr: Lassen County'
                  'CA01804'='(CA01804) Uprr Lassen County'
                  'CA01898'='(CA01898) Lassen State Police'
                  'CA01899'='(CA01899) Hp: Lassen County' 'CA01900'='(CA01900) Los Angeles'
                  'CA01901'='(CA01901) Alhambra' 'CA01902'='(CA01902) Arcadia'
                  'CA01903'='(CA01903) Artesia' 'CA01904'='(CA01904) Avalon' 'CA01905'='(CA01905) Azusa'
                  'CA01906'='(CA01906) Baldwin Park' 'CA01907'='(CA01907) Bell'
                  'CA01908'='(CA01908) Bellflower' 'CA01909'='(CA01909) Bell Gardens'
                  'CA0190C'='(CA0190C) El Camino College' 'CA0190D'='(CA0190D) La Habra Heights'
                  'CA0190E'='(CA0190E) Bnsf Rwy: Los Angeles Co'
                  'CA0190G'='(CA0190G) La County Housing Auth'
                  'CA0190H'='(CA0190H) Spt Los Angeles'
                  'CA0190I'='(CA0190I) Uprr: Los Angeles County'
                  'CA0190K'='(CA0190K) La Co Mtrp Trnsprtn Auth'
                  'CA0190M'='(CA0190M) Union Pacific Rr-Los Ang'
                  'CA0190P'='(CA0190P) Long Beach City College'
                  'CA0190R'='(CA0190R) Pasadena Community Colle'
                  'CA0190X'='(CA0190X) Westlake Village' 'CA01910'='(CA01910) Beverly Hills'
                  'CA01911'='(CA01911) Bradbury' 'CA01912'='(CA01912) Burbank'
                  'CA01913'='(CA01913) Claremont' 'CA01914'='(CA01914) Commerce'
                  'CA01915'='(CA01915) Compton' 'CA01916'='(CA01916) Covina' 'CA01917'='(CA01917) Cudahy'
                  'CA01918'='(CA01918) Culver City' 'CA01919'='(CA01919) Cerritos'
                  'CA0191B'='(CA0191B) Dpr: Los Angeles County'
                  'CA0191C'='(CA0191C) Dpr: Hungry Valley'
                  'CA0191E'='(CA0191E) Lanterman State Hospital'
                  'CA0191F'='(CA0191F) Agoura Hills' 'CA0191H'='(CA0191H) West Hollywood'
                  'CA0191R'='(CA0191R) Santa Clarita' 'CA0191W'='(CA0191W) Diamond Bar'
                  'CA01920'='(CA01920) Downey' 'CA01921'='(CA01921) Duarte' 'CA01922'='(CA01922) El Monte'
                  'CA01923'='(CA01923) El Segundo' 'CA01924'='(CA01924) Gardena'
                  'CA01925'='(CA01925) Glendale' 'CA01926'='(CA01926) Glendora'
                  'CA01927'='(CA01927) Hawaiian Gardens' 'CA01928'='(CA01928) Hawthorne'
                  'CA01929'='(CA01929) Hermosa Beach' 'CA0192H'='(CA0192H) Calabasas'
                  'CA0192J'='(CA0192J) Malibu' 'CA0192Q'='(CA0192Q) Los Angeles City College'
                  'CA0192R'='(CA0192R) Pomona Unfd School Dist'
                  'CA0192U'='(CA0192U) La Trnsprtn Services Bur'
                  'CA01930'='(CA01930) Hidden Hills' 'CA01931'='(CA01931) Huntington Park'
                  'CA01932'='(CA01932) Industry' 'CA01933'='(CA01933) Inglewood'
                  'CA01934'='(CA01934) Irwindale' 'CA01935'='(CA01935) Lakewood'
                  'CA01936'='(CA01936) La Mirada' 'CA01937'='(CA01937) La Puente'
                  'CA01938'='(CA01938) La Verne' 'CA01939'='(CA01939) Lawndale'
                  'CA01940'='(CA01940) Lomita' 'CA01941'='(CA01941) Long Beach'
                  'CA01942'='(CA01942) Los Angeles' 'CA01943'='(CA01943) Lynwood'
                  'CA01944'='(CA01944) Manhattan Beach' 'CA01945'='(CA01945) Maywood'
                  'CA01946'='(CA01946) Monrovia' 'CA01947'='(CA01947) Montebello'
                  'CA01948'='(CA01948) Monterey Park' 'CA01949'='(CA01949) Norwalk'
                  'CA01950'='(CA01950) Palmdale' 'CA01951'='(CA01951) Palos Verdes Estates'
                  'CA01952'='(CA01952) Paramount' 'CA01953'='(CA01953) Pasadena'
                  'CA01954'='(CA01954) Pico Rivera' 'CA01955'='(CA01955) Pomona'
                  'CA01956'='(CA01956) Redondo Beach' 'CA01957'='(CA01957) Rolling Hills'
                  'CA01958'='(CA01958) Rolling Hills Estates' 'CA01959'='(CA01959) Rosemead'
                  'CA01960'='(CA01960) San Dimas' 'CA01961'='(CA01961) San Fernando'
                  'CA01962'='(CA01962) San Gabriel' 'CA01963'='(CA01963) San Marino'
                  'CA01964'='(CA01964) Santa Fe Springs' 'CA01965'='(CA01965) Santa Monica'
                  'CA01966'='(CA01966) Sierra Madre' 'CA01967'='(CA01967) Signal Hill'
                  'CA01968'='(CA01968) South El Monte' 'CA01969'='(CA01969) South Gate'
                  'CA01970'='(CA01970) South Pasadena' 'CA01971'='(CA01971) Temple City'
                  'CA01972'='(CA01972) Torrance' 'CA01973'='(CA01973) Vernon' 'CA01974'='(CA01974) Walnut'
                  'CA01975'='(CA01975) West Covina' 'CA01976'='(CA01976) Whittier'
                  'CA01977'='(CA01977) Carson' 'CA01978'='(CA01978) Ca St Polytec U: pomona'
                  'CA01980'='(CA01980) Rancho Palos Verdes'
                  'CA01981'='(CA01981) Ca St Un:Dominguez Hills'
                  'CA01982'='(CA01982) Ca St Un: Long Beach'
                  'CA01983'='(CA01983) Ca St Un: Los Angeles'
                  'CA01984'='(CA01984) Ca St Un: Northridge'
                  'CA01990'='(CA01990) La Canada Flintridge' 'CA01996'='(CA01996) Lancaster'
                  'CA01997'='(CA01997) Un Of Ca: Los Angeles'
                  'CA01998'='(CA01998) Los Angeles State Police'
                  'CA01999'='(CA01999) Hp: Los Angeles County' 'CA02000'='(CA02000) Madera'
                  'CA02001'='(CA02001) Chowchilla' 'CA02002'='(CA02002) Madera'
                  'CA02003'='(CA02003) Bnsf Rwy: Madera County'
                  'CA02004'='(CA02004) Uprr: Madera County'
                  'CA02099'='(CA02099) Hp: Madera County' 'CA02100'='(CA02100) Marin'
                  'CA02101'='(CA02101) Belvedere' 'CA02102'='(CA02102) Corte Madera'
                  'CA02103'='(CA02103) Fairfax' 'CA02104'='(CA02104) Twin Cities'
                  'CA02105'='(CA02105) Mill Valley' 'CA02106'='(CA02106) Novato' 'CA02107'='(CA02107) Ross'
                  'CA02108'='(CA02108) San Anselmo' 'CA02109'='(CA02109) San Rafael'
                  'CA02110'='(CA02110) Sausalito' 'CA02111'='(CA02111) Tiburon'
                  'CA02112'='(CA02112) Uprr: Marin County'
                  'CA02113'='(CA02113) Marin Community College'
                  'CA02114'='(CA02114) Dpr: Marin County'
                  'CA02116'='(CA02116) Marin Co Narcotics Tsk F'
                  'CA02199'='(CA02199) hp: Marin County' 'CA02200'='(CA02200) Mariposa'
                  'CA02299'='(CA02299) Hp: Mariposa County' 'CA02300'='(CA02300) Mendocino'
                  'CA02301'='(CA02301) Fort Bragg' 'CA02302'='(CA02302) Point Arena'
                  'CA02303'='(CA02303) Ukiah' 'CA02304'='(CA02304) Willits'
                  'CA02305'='(CA02305) Spt Mendocino'
                  'CA02306'='(CA02306) Dpr: Mendocino Headqtrs'
                  'CA02309'='(CA02309) Uprr: Mendocino County'
                  'CA02399'='(CA02399) Hp: Mendocino County' 'CA02400'='(CA02400) Merced'
                  'CA02401'='(CA02401) Atwater' 'CA02402'='(CA02402) Dos Palos'
                  'CA02403'='(CA02403) Gustine' 'CA02404'='(CA02404) Livingston'
                  'CA02405'='(CA02405) Los Banos' 'CA02406'='(CA02406) Merced'
                  'CA02407'='(CA02407) Bnsf Rwy: Merced County'
                  'CA02408'='(CA02408) Uprr: Merced County' 'CA02409'='(CA02409) Merced College'
                  'CA02410'='(CA02410) Dpr:Four Rivers District'
                  'CA02412'='(CA02412) Un Of Ca: Merced'
                  'CA02498'='(CA02498) Merced State Police'
                  'CA02499'='(CA02499) Hp: Merced County' 'CA02500'='(CA02500) Modoc'
                  'CA02501'='(CA02501) Alturas' 'CA02502'='(CA02502) Uprr: Modoc County'
                  'CA02599'='(CA02599) Hp: Modoc County' 'CA02600'='(CA02600) Mono'
                  'CA02601'='(CA02601) Mammoth Lakes' 'CA02698'='(CA02698) Mono State Police'
                  'CA02699'='(CA02699) Hp: Mono County' 'CA02700'='(CA02700) Monterey'
                  'CA02701'='(CA02701) Carmel' 'CA02702'='(CA02702) Del Rey Oaks'
                  'CA02703'='(CA02703) Gonzales' 'CA02704'='(CA02704) Greenfield'
                  'CA02705'='(CA02705) King City' 'CA02706'='(CA02706) Monterey'
                  'CA02707'='(CA02707) Pacific Grove' 'CA02708'='(CA02708) Salinas'
                  'CA02709'='(CA02709) Sand City' 'CA02710'='(CA02710) Seaside'
                  'CA02711'='(CA02711) Soledad' 'CA02712'='(CA02712) Marina'
                  'CA02714'='(CA02714) Monterey Peninsula Airpo'
                  'CA02715'='(CA02715) Uprr: Monterey County' 'CA02716'='(CA02716) Dpr: Big Sur'
                  'CA02717'='(CA02717) Dpr: Monterey County'
                  'CA02719'='(CA02719) Ca St Un: Monterey Bay'
                  'CA02799'='(CA02799) Hp: Monterey County' 'CA02800'='(CA02800) Napa'
                  'CA02801'='(CA02801) Calistoga' 'CA02802'='(CA02802) Napa'
                  'CA02803'='(CA02803) St. Helena' 'CA02806'='(CA02806) Uprr: Napa County'
                  'CA02807'='(CA02807) Dpr: Napa County'
                  'CA02808'='(CA02808) Napa State Hospital' 'CA02809'='(CA02809) American Canyon'
                  'CA02810'='(CA02810) Yountville' 'CA02899'='(CA02899) Hp: Napa County'
                  'CA02900'='(CA02900) Nevada' 'CA02901'='(CA02901) Grass Valley'
                  'CA02902'='(CA02902) Nevada City' 'CA02903'='(CA02903) Uprr: Nevada County'
                  'CA02904'='(CA02904) Dpr: Gold Mines' 'CA02908'='(CA02908) Truckee'
                  'CA02999'='(CA02999) Hp: Nevada County' 'CA03000'='(CA03000) Orange'
                  'CA03001'='(CA03001) Anaheim' 'CA03002'='(CA03002) Brea' 'CA03003'='(CA03003) Buena Park'
                  'CA03004'='(CA03004) Costa Mesa' 'CA03005'='(CA03005) Cypress'
                  'CA03006'='(CA03006) La Palma' 'CA03007'='(CA03007) Fountain Valley'
                  'CA03008'='(CA03008) Fullerton' 'CA03009'='(CA03009) Garden Grove'
                  'CA03010'='(CA03010) Huntington Beach' 'CA03011'='(CA03011) Laguna Beach'
                  'CA03012'='(CA03012) La Habra' 'CA03013'='(CA03013) Los Alamitos'
                  'CA03014'='(CA03014) Newport Beach' 'CA03015'='(CA03015) Orange'
                  'CA03016'='(CA03016) Placentia' 'CA03017'='(CA03017) San Clemente'
                  'CA03018'='(CA03018) San Juan Capistrano' 'CA03019'='(CA03019) Santa Ana'
                  'CA03020'='(CA03020) Seal Beach' 'CA03021'='(CA03021) Stanton'
                  'CA03022'='(CA03022) Tustin' 'CA03023'='(CA03023) Villa Park'
                  'CA03024'='(CA03024) Westminster' 'CA03025'='(CA03025) Yorba Linda'
                  'CA03026'='(CA03026) Irvine' 'CA03027'='(CA03027) Ca St Un: Fullerton'
                  'CA03028'='(CA03028) Bnsf Rwy: Orange County'
                  'CA03029'='(CA03029) Uprr: Orange County'
                  'CA03030'='(CA03030) Union Pacific Rr-Orange'
                  'CA03032'='(CA03032) Dpr: Orange Coast'
                  'CA03033'='(CA03033) Dpr: Orange County'
                  'CA03034'='(CA03034) Fairview Developmtl Ctr'
                  'CA03035'='(CA03035) Mission Viejo' 'CA03036'='(CA03036) Dana Point'
                  'CA03039'='(CA03039) Laguna Niguel' 'CA03042'='(CA03042) Laguna Hills'
                  'CA03043'='(CA03043) Lake Forest' 'CA03047'='(CA03047) Laguna Woods'
                  'CA03048'='(CA03048) Rancho Santa Margarita' 'CA03049'='(CA03049) Aliso Viejo'
                  'CA03091'='(CA03091) Orange County Marshal'
                  'CA03097'='(CA03097) Un Of Ca: Irvine'
                  'CA03098'='(CA03098) Orange State Police'
                  'CA03099'='(CA03099) Hp: Orange County' 'CA03100'='(CA03100) Placer'
                  'CA03101'='(CA03101) Auburn' 'CA03102'='(CA03102) Colfax' 'CA03103'='(CA03103) Lincoln'
                  'CA03104'='(CA03104) Rocklin' 'CA03105'='(CA03105) Roseville'
                  'CA03106'='(CA03106) So Pacific Trans Placer' 'CA03107'='(CA03107) Dpr: Sierra'
                  'CA03112'='(CA03112) Uprr: Placer County'
                  'CA03199'='(CA03199) Hp: Placer County' 'CA03200'='(CA03200) Plumas'
                  'CA03201'='(CA03201) Portola' 'CA03202'='(CA03202) Dpr: Plumas-Eureka'
                  'CA03203'='(CA03203) Uprr: Plumas County'
                  'CA03299'='(CA03299) Hp: Plumas County' 'CA03300'='(CA03300) Riverside'
                  'CA03301'='(CA03301) Banning' 'CA03302'='(CA03302) Beaumont' 'CA03303'='(CA03303) Blythe'
                  'CA03304'='(CA03304) Cabazon' 'CA03305'='(CA03305) Coachella'
                  'CA03306'='(CA03306) Desert Hot Springs' 'CA03307'='(CA03307) Elsinore'
                  'CA03308'='(CA03308) Hemet' 'CA03309'='(CA03309) Indio' 'CA03310'='(CA03310) Norco'
                  'CA03311'='(CA03311) Palm Springs' 'CA03312'='(CA03312) Perris'
                  'CA03313'='(CA03313) Riverside' 'CA03314'='(CA03314) San Jacinto'
                  'CA03315'='(CA03315) Corona' 'CA03316'='(CA03316) Indian Wells'
                  'CA03317'='(CA03317) Rancho Mirage' 'CA03318'='(CA03318) Palm Desert'
                  'CA03320'='(CA03320) Bnsf Rwy: Riverside Cnty'
                  'CA03321'='(CA03321) Uprr: Riverside County'
                  'CA03322'='(CA03322) Union Pacific Rr-Riversi'
                  'CA03324'='(CA03324) Dpr: Inland Empire' 'CA03325'='(CA03325) Cathedral City'
                  'CA03326'='(CA03326) Dpr: Mt San Jacinto' 'CA03327'='(CA03327) Dpr: Salton Sea'
                  'CA03328'='(CA03328) Dpr: Riverside County' 'CA03330'='(CA03330) Lake Elsinore'
                  'CA03331'='(CA03331) La Quinta' 'CA03332'='(CA03332) Moreno Valley'
                  'CA03337'='(CA03337) Dpr: Chino Hills' 'CA03338'='(CA03338) Temecula'
                  'CA03340'='(CA03340) Calimesa' 'CA03341'='(CA03341) Canyon Lake'
                  'CA03342'='(CA03342) Murrieta' 'CA03344'='(CA03344) Riverside Comm College'
                  'CA03397'='(CA03397) Un Of Ca: Riverside'
                  'CA03398'='(CA03398) Riverside State Police'
                  'CA03399'='(CA03399) Hp: Riverside County' 'CA03400'='(CA03400) Sacramento'
                  'CA03401'='(CA03401) Folsom' 'CA03402'='(CA03402) Galt' 'CA03403'='(CA03403) Isleton'
                  'CA03404'='(CA03404) Sacramento' 'CA03408'='(CA03408) Ca St Un: Sacramento'
                  'CA0340H'='(CA0340H) Elk Grove' 'CA03412'='(CA03412) Dpr: Gold Fields Distric'
                  'CA03414'='(CA03414) Grant Joint Union H sch'
                  'CA03415'='(CA03415) Spt Sacramento'
                  'CA03420'='(CA03420) California State Fair' 'CA03422'='(CA03422) Dpr: Capital'
                  'CA03423'='(CA03423) Upr Sec Dp Sacramento Co'
                  'CA03433'='(CA03433) Dpr: Twin Cities'
                  'CA03448'='(CA03448) Uprr: Sacramento County'
                  'CA03497'='(CA03497) Un Ca Med Ctr, Sacrament'
                  'CA03498'='(CA03498) Calif St Pol Sacramento'
                  'CA03499'='(CA03499) Hp: Sacramento County' 'CA03500'='(CA03500) San Benito'
                  'CA03501'='(CA03501) Hollister' 'CA03502'='(CA03502) San Juan Bautista'
                  'CA03503'='(CA03503) Uprr: San Benito County'
                  'CA03504'='(CA03504) Dpr: Hollister Hills' 'CA03505'='(CA03505) Dpr: Gabilan'
                  'CA03599'='(CA03599) Hp: San Benito County'
                  'CA03600'='(CA03600) San Bernardino' 'CA03601'='(CA03601) Barstow'
                  'CA03602'='(CA03602) Chino' 'CA03603'='(CA03603) Colton' 'CA03604'='(CA03604) Fontana'
                  'CA03605'='(CA03605) Montclair' 'CA03606'='(CA03606) Needles'
                  'CA03607'='(CA03607) Ontario' 'CA03608'='(CA03608) Redlands' 'CA03609'='(CA03609) Rialto'
                  'CA03610'='(CA03610) San Bernardino' 'CA03611'='(CA03611) Upland'
                  'CA03612'='(CA03612) Victorville' 'CA03613'='(CA03613) Adelanto'
                  'CA03614'='(CA03614) Ca St Un: San Bernardino'
                  'CA03616'='(CA03616) Rancho Cucamonga'
                  'CA03617'='(CA03617) Bnsf Rwy:San Bernardino'
                  'CA03618'='(CA03618) Spt San Bernardino'
                  'CA03619'='(CA03619) San Bernardino Co Welfar'
                  'CA03620'='(CA03620) Big Bear Lake' 'CA03621'='(CA03621) Grand Terrace'
                  'CA03622'='(CA03622) Loma Linda' 'CA03623'='(CA03623) San Bernardino Usd'
                  'CA03625'='(CA03625) Dpr: San Bernardino Cnty'
                  'CA03629'='(CA03629) Dpr: Chino Hills' 'CA03630'='(CA03630) Highland'
                  'CA03631'='(CA03631) Twentynine Palms' 'CA03632'='(CA03632) Hesperia'
                  'CA03633'='(CA03633) Apple Valley' 'CA03635'='(CA03635) Yucaipa'
                  'CA03639'='(CA03639) San Bernardino Comm Coll'
                  'CA03640'='(CA03640) Chino Hills' 'CA03641'='(CA03641) Yucca Valley'
                  'CA03650'='(CA03650) Fontana Unified Sch Dist'
                  'CA03654'='(CA03654) Uprr: San Bernardino Cty'
                  'CA03698'='(CA03698) San Bernardino State Pol'
                  'CA03699'='(CA03699) Hp: San Bernardino Cnty' 'CA03700'='(CA03700) San Diego'
                  'CA03701'='(CA03701) Carlsbad' 'CA03702'='(CA03702) Chula Vista'
                  'CA03703'='(CA03703) Coronado' 'CA03704'='(CA03704) Del Mar'
                  'CA03705'='(CA03705) El Cajon' 'CA03706'='(CA03706) Escondido'
                  'CA03707'='(CA03707) Imperial Beach' 'CA03708'='(CA03708) La Mesa'
                  'CA03709'='(CA03709) National City' 'CA03710'='(CA03710) Oceanside'
                  'CA03711'='(CA03711) San Diego' 'CA03712'='(CA03712) San Marcos'
                  'CA03713'='(CA03713) Vista' 'CA03714'='(CA03714) San Diego St University'
                  'CA03715'='(CA03715) Port Of San Diego Harbor'
                  'CA03717'='(CA03717) Bnsf Rwy: San Diego Cnty'
                  'CA03718'='(CA03718) Spt: San Diego County' 'CA03722'='(CA03722) Dpr: Colorado'
                  'CA03723'='(CA03723) Dpr: San Diego County'
                  'CA03724'='(CA03724) Dpr: Ocotillo Wells'
                  'CA03725'='(CA03725) Dpr: San Diego Coast'
                  'CA03727'='(CA03727) Dpr: Montane District'
                  'CA03732'='(CA03732) Ca St Un: San Marcos'
                  'CA03797'='(CA03797) Un Of Ca: San Diego'
                  'CA03798'='(CA03798) San Diego State Police'
                  'CA03799'='(CA03799) Hp: San Diego County' 'CA037A1'='(CA037A1) Lemon Grove'
                  'CA037A2'='(CA037A2) Santee' 'CA037A3'='(CA037A3) Poway' 'CA037A4'='(CA037A4) Encinitas'
                  'CA037A5'='(CA037A5) Solana Beach' 'CA03800'='(CA03800) San Francisco'
                  'CA03801'='(CA03801) San Francisco' 'CA03802'='(CA03802) Harbor Police'
                  'CA03803'='(CA03803) San Francisco St Univ'
                  'CA03805'='(CA03805) Sf Bart:San Francisco Co'
                  'CA03807'='(CA03807) Bnsf Rwy:San Francisco C'
                  'CA03808'='(CA03808) spt San Francisco'
                  'CA03810'='(CA03810) Dpr: San Francisco Count'
                  'CA03816'='(CA03816) Un Of Ca:Hastings C of L'
                  'CA03819'='(CA03819) uprr: San Francisco Cty'
                  'CA03897'='(CA03897) Un Of Ca: San Francisco'
                  'CA03898'='(CA03898) San Francisco State Poli'
                  'CA03899'='(CA03899) Hp: San Francisco County'
                  'CA03900'='(CA03900) San Joaquin' 'CA03901'='(CA03901) Escalon'
                  'CA03902'='(CA03902) Lodi' 'CA03903'='(CA03903) Manteca' 'CA03904'='(CA03904) Ripon'
                  'CA03905'='(CA03905) Stockton' 'CA03906'='(CA03906) Tracy'
                  'CA03909'='(CA03909) Bnsf Rwy: San Joaquin Co'
                  'CA03910'='(CA03910) Spt San Joaquin'
                  'CA03912'='(CA03912) Upr San Joaquin County'
                  'CA03914'='(CA03914) Stockton Developmental C'
                  'CA03915'='(CA03915) stockton Unified Sch Dis'
                  'CA03921'='(CA03921) Uprr: San Joaquin County'
                  'CA03923'='(CA03923) Ca St Un: Stockton'
                  'CA03998'='(CA03998) San Joaquin State Police'
                  'CA03999'='(CA03999) Hp: San Joaquin County'
                  'CA04000'='(CA04000) San Luis Obispo' 'CA04001'='(CA04001) Arroyo Grande'
                  'CA04002'='(CA04002) Grover Beach' 'CA04003'='(CA04003) Morro Bay'
                  'CA04004'='(CA04004) Paso Robles' 'CA04005'='(CA04005) Pismo Beach'
                  'CA04006'='(CA04006) San Luis Obispo'
                  'CA04007'='(CA04007) Ca St Polyt U:san Luis O' 'CA04008'='(CA04008) atascadero'
                  'CA04009'='(CA04009) Spt San Luis Obispo' 'CA04012'='(CA04012) Dpr: San Simeon'
                  'CA04013'='(CA04013) Dpr: San Luis Obispo Cst'
                  'CA04014'='(CA04014) Dpr: Oceano Dunes'
                  'CA04016'='(CA04016) Atascadero State Hosp'
                  'CA04018'='(CA04018) Uprr:San Luis Obispo Cty'
                  'CA04019'='(CA04019) Cuesta College'
                  'CA04099'='(CA04099) Hp: San Luis Obispo Cnty' 'CA04100'='(CA04100) San Mateo'
                  'CA04101'='(CA04101) Atherton' 'CA04102'='(CA04102) Belmont'
                  'CA04103'='(CA04103) Brisbane' 'CA04104'='(CA04104) Burlingame'
                  'CA04105'='(CA04105) Colma' 'CA04106'='(CA04106) Daly City'
                  'CA04107'='(CA04107) Half Moon Bay' 'CA04108'='(CA04108) Hillsborough'
                  'CA04109'='(CA04109) Menlo Park' 'CA04110'='(CA04110) Millbrae'
                  'CA04111'='(CA04111) Pacifica' 'CA04112'='(CA04112) Portola Valley'
                  'CA04113'='(CA04113) Redwood City' 'CA04114'='(CA04114) San Bruno'
                  'CA04115'='(CA04115) San Carlos' 'CA04116'='(CA04116) San Mateo'
                  'CA04117'='(CA04117) South San Francisco' 'CA04118'='(CA04118) Woodside'
                  'CA04119'='(CA04119) Broadmoor' 'CA04120'='(CA04120) Foster City'
                  'CA04121'='(CA04121) Emerald Lake'
                  'CA04123'='(CA04123) Sf Bart:San Mateo County'
                  'CA04124'='(CA04124) Uprr: San Mateo County'
                  'CA04126'='(CA04126) Dpr: Bay Area' 'CA04127'='(CA04127) East Palo Alto'
                  'CA04198'='(CA04198) San Mateo State Police'
                  'CA04199'='(CA04199) Hp: San Mateo County' 'CA04200'='(CA04200) Santa Barbara'
                  'CA04201'='(CA04201) Guadalupe' 'CA04202'='(CA04202) Lompoc'
                  'CA04203'='(CA04203) Santa Barbara' 'CA04204'='(CA04204) Santa Maria'
                  'CA04205'='(CA04205) Carpinteria'
                  'CA04207'='(CA04207) Uprr: Santa Barbara Coun'
                  'CA04208'='(CA04208) Dpr: Gaviota'
                  'CA04209'='(CA04209) Dpr: Santa Barbara Cnty' 'CA04210'='(CA04210) Solvang'
                  'CA04211'='(CA04211) Allan Hancock College' 'CA04212'='(CA04212) Buellton'
                  'CA04214'='(CA04214) Goleta' 'CA04297'='(CA04297) Un Of Ca: Santa Barbara'
                  'CA04298'='(CA04298) Santa Barbara State Poli'
                  'CA04299'='(CA04299) Hp: Santa Barbara County'
                  'CA04300'='(CA04300) Santa Clara' 'CA04301'='(CA04301) Alviso'
                  'CA04302'='(CA04302) Campbell' 'CA04303'='(CA04303) Cupertino'
                  'CA04304'='(CA04304) Gilroy' 'CA04305'='(CA04305) Los Altos'
                  'CA04306'='(CA04306) Los Altos Hills' 'CA04307'='(CA04307) Los Gatos'
                  'CA04308'='(CA04308) Milpitas' 'CA04309'='(CA04309) Monte Sereno'
                  'CA04310'='(CA04310) Morgan Hill' 'CA04311'='(CA04311) Mountain View'
                  'CA04312'='(CA04312) Palo Alto' 'CA04313'='(CA04313) San Jose'
                  'CA04314'='(CA04314) Santa Clara' 'CA04315'='(CA04315) Saratoga'
                  'CA04316'='(CA04316) Sunnyvale' 'CA04317'='(CA04317) Ca St Un: San Jose'
                  'CA04319'='(CA04319) Spt Santa Clara'
                  'CA04320'='(CA04320) San Jose/Evergreen Com C'
                  'CA04321'='(CA04321) west Valley-Mission Coll'
                  'CA04324'='(CA04324) Agnews Developmental Ctr'
                  'CA04325'='(CA04325) U p R r Santa Clara Co.'
                  'CA04327'='(CA04327) Foothill-De Anza College'
                  'CA04336'='(CA04336) Uprr: Santa Clara County'
                  'CA04395'='(CA04395) Santa Clara Transit Dist'
                  'CA04398'='(CA04398) Santa Clara State Police'
                  'CA04399'='(CA04399) Hp: Santa Clara County' 'CA04400'='(CA04400) Santa Cruz'
                  'CA04401'='(CA04401) Capitola' 'CA04402'='(CA04402) Santa Cruz'
                  'CA04403'='(CA04403) Watsonville' 'CA04404'='(CA04404) Scotts Valley'
                  'CA04405'='(CA04405) Cabrillo College'
                  'CA04406'='(CA04406) Uprr: Santa Cruz County'
                  'CA04407'='(CA04407) Dpr: Santa Cruz County'
                  'CA04408'='(CA04408) Dpr:Santa Cruz Mountains'
                  'CA04497'='(CA04497) Un Of Ca: Santa Cruz'
                  'CA04499'='(CA04499) Hp: Santa Cruz County' 'CA04500'='(CA04500) Shasta'
                  'CA04501'='(CA04501) Anderson' 'CA04502'='(CA04502) Redding'
                  'CA04503'='(CA04503) Uprr: Shasta County'
                  'CA04505'='(CA04505) Dpr: Shasta County'
                  'CA04598'='(CA04598) Shasta State Police'
                  'CA04599'='(CA04599) Hp: Shasta County' 'CA04600'='(CA04600) Sierra'
                  'CA04601'='(CA04601) Loyalton' 'CA04602'='(CA04602) Uprr: Sierra County'
                  'CA04699'='(CA04699) Hp: Sierra County' 'CA04700'='(CA04700) Siskiyou'
                  'CA04701'='(CA04701) Dorris' 'CA04702'='(CA04702) Dunsmuir' 'CA04703'='(CA04703) Etna'
                  'CA04704'='(CA04704) Fort Jones' 'CA04705'='(CA04705) Montague'
                  'CA04706'='(CA04706) Mount Shasta' 'CA04707'='(CA04707) Tulelake'
                  'CA04708'='(CA04708) Weed' 'CA04709'='(CA04709) Yreka'
                  'CA04710'='(CA04710) Lake Shastina'
                  'CA04711'='(CA04711) S pacific Trans Siskiyou'
                  'CA04713'='(CA04713) Upr-Siskiyou County'
                  'CA04716'='(CA04716) Uprr: Siskiyou County'
                  'CA04799'='(CA04799) Hp: Siskiyou County' 'CA04800'='(CA04800) Solano'
                  'CA04801'='(CA04801) Benicia' 'CA04802'='(CA04802) Dixon' 'CA04803'='(CA04803) Fairfield'
                  'CA04804'='(CA04804) Rio Vista' 'CA04805'='(CA04805) Suisun City'
                  'CA04806'='(CA04806) Vacaville' 'CA04807'='(CA04807) Vallejo'
                  'CA04808'='(CA04808) Uprr: Solano County'
                  'CA04809'='(CA04809) Dpr: Solano County'
                  'CA04813'='(CA04813) Solano Community College'
                  'CA04898'='(CA04898) Solano County State Poli'
                  'CA04899'='(CA04899) Hp: Solano County' 'CA04900'='(CA04900) Sonoma'
                  'CA04901'='(CA04901) Cloverdale' 'CA04902'='(CA04902) Cotati'
                  'CA04903'='(CA04903) Healdsburg' 'CA04904'='(CA04904) Rohnert Park'
                  'CA04905'='(CA04905) Santa Rosa' 'CA04906'='(CA04906) Sebastopol'
                  'CA04907'='(CA04907) Sonoma' 'CA04908'='(CA04908) Petaluma'
                  'CA04909'='(CA04909) Sonoma State University'
                  'CA04910'='(CA04910) Uprr: Sonoma County' 'CA04911'='(CA04911) Dpr: Silverado'
                  'CA04912'='(CA04912) Dpr: Russian River'
                  'CA04913'='(CA04913) Sonoma Developmental Ctr'
                  'CA04914'='(CA04914) Santa Rosa Jr. College' 'CA04915'='(CA04915) Windsor'
                  'CA04998'='(CA04998) Sonoma State Police'
                  'CA04999'='(CA04999) Hp: Sonoma County' 'CA05000'='(CA05000) Stanislaus'
                  'CA05001'='(CA05001) Ceres' 'CA05002'='(CA05002) Modesto' 'CA05003'='(CA05003) Newman'
                  'CA05004'='(CA05004) Oakdale' 'CA05005'='(CA05005) Patterson'
                  'CA05006'='(CA05006) Riverbank' 'CA05007'='(CA05007) Turlock'
                  'CA05008'='(CA05008) Waterford' 'CA05009'='(CA05009) Hughson'
                  'CA05010'='(CA05010) Ca St Un: Stanislaus'
                  'CA05011'='(CA05011) Bnsf Rwy: Stanislaus Co'
                  'CA05012'='(CA05012) Uprr: Stanislaus County'
                  'CA05014'='(CA05014) Upr Sec Dpt Stainlaus Co'
                  'CA05015'='(CA05015) Modesto J c Yosemite Cc'
                  'CA05098'='(CA05098) Stanislaus State Police'
                  'CA05099'='(CA05099) Hp: Stanislaus County' 'CA05100'='(CA05100) Sutter'
                  'CA05101'='(CA05101) Live Oak' 'CA05102'='(CA05102) Yuba City'
                  'CA05104'='(CA05104) Uprr: Sutter County'
                  'CA05199'='(CA05199) Hp: Sutter County' 'CA05200'='(CA05200) Tehama'
                  'CA05201'='(CA05201) Corning' 'CA05202'='(CA05202) Red Bluff'
                  'CA05203'='(CA05203) Tehama' 'CA05204'='(CA05204) Uprr: Tehama County'
                  'CA05299'='(CA05299) Hp: Tehama County' 'CA05300'='(CA05300) Trinity'
                  'CA05301'='(CA05301) Uprr: Trinity County'
                  'CA05399'='(CA05399) Hp: Trinity County' 'CA05400'='(CA05400) Tulare'
                  'CA05401'='(CA05401) Dinuba' 'CA05402'='(CA05402) Exeter'
                  'CA05403'='(CA05403) Farmersville' 'CA05404'='(CA05404) Lindsay'
                  'CA05405'='(CA05405) Porterville' 'CA05406'='(CA05406) Tulare'
                  'CA05407'='(CA05407) Visalia' 'CA05408'='(CA05408) Woodlake'
                  'CA05409'='(CA05409) Bnsf Rwy: Tulare County'
                  'CA05410'='(CA05410) Uprr: Tulare County'
                  'CA05411'='(CA05411) College Of The Sequoias'
                  'CA05498'='(CA05498) Tulare State Police'
                  'CA05499'='(CA05499) Hp: Tulare County' 'CA05500'='(CA05500) Tuolumne'
                  'CA05501'='(CA05501) Sonora' 'CA05502'='(CA05502) Columbia St Historic Pk'
                  'CA05599'='(CA05599) Hp: Tuolumne County' 'CA05600'='(CA05600) Ventura'
                  'CA05601'='(CA05601) Camarillo' 'CA05602'='(CA05602) Fillmore' 'CA05603'='(CA05603) Ojai'
                  'CA05604'='(CA05604) Oxnard' 'CA05605'='(CA05605) Port Hueneme'
                  'CA05606'='(CA05606) Santa Paula' 'CA05607'='(CA05607) Thousand Oaks'
                  'CA05608'='(CA05608) Ventura' 'CA05609'='(CA05609) Simi Valley'
                  'CA05610'='(CA05610) Spt Ventura' 'CA05613'='(CA05613) Dpr: Angeles'
                  'CA05614'='(CA05614) Moorpark' 'CA05615'='(CA05615) Dpr: Channel Coast'
                  'CA05616'='(CA05616) Camarillo State Hospital'
                  'CA05617'='(CA05617) Dpr: Hungry Valley'
                  'CA05621'='(CA05621) Uprr: Ventura County'
                  'CA05622'='(CA05622) Ca St Un:Channel Islands'
                  'CA05680'='(CA05680) Ventura Cnty Com Col Dst'
                  'CA05698'='(CA05698) Ventura State Police'
                  'CA05699'='(CA05699) Hp: Ventura County' 'CA05700'='(CA05700) Yolo'
                  'CA05701'='(CA05701) Davis' 'CA05702'='(CA05702) Winters' 'CA05703'='(CA05703) Woodland'
                  'CA05704'='(CA05704) West Sacramento' 'CA05705'='(CA05705) Uprr: Yolo County'
                  'CA05706'='(CA05706) Uprr Yolo County' 'CA05797'='(CA05797) Un Of Ca: Davis'
                  'CA05798'='(CA05798) Yolo State Police' 'CA05799'='(CA05799) Hp: Yolo County'
                  'CA05800'='(CA05800) Yuba' 'CA05801'='(CA05801) Marysville'
                  'CA05802'='(CA05802) Wheatland' 'CA05803'='(CA05803) Uprr: Yuba County'
                  'CA05804'='(CA05804) U p Railroad Sec Co Dept'
                  'CA05899'='(CA05899) Hp: Yuba County' 'CO00100'='(CO00100) Adams'
                  'CO00101'='(CO00101) Aurora' 'CO00102'='(CO00102) Brighton'
                  'CO00103'='(CO00103) Commerce City' 'CO00104'='(CO00104) Thornton'
                  'CO00105'='(CO00105) Westminster' 'CO00106'='(CO00106) Northglenn'
                  'CO00107'='(CO00107) Derby' 'CO00108'='(CO00108) Federal Heights'
                  'CO00111'='(CO00111) U of Co:Hsc, Fitzsimons' 'CO00200'='(CO00200) Alamosa'
                  'CO00201'='(CO00201) Alamosa' 'CO00202'='(CO00202) Adams State College'
                  'CO00300'='(CO00300) Arapahoe' 'CO00301'='(CO00301) Englewood'
                  'CO00302'='(CO00302) Littleton' 'CO00303'='(CO00303) Sheridan'
                  'CO00304'='(CO00304) Glendale' 'CO00305'='(CO00305) Cherry Hills Village'
                  'CO00306'='(CO00306) Bow Mar' 'CO00307'='(CO00307) Greenwood Village'
                  'CO00308'='(CO00308) Columbine Valley'
                  'CO00309'='(CO00309) Arapahoe Comm College' 'CO00311'='(CO00311) Centennial'
                  'CO00312'='(CO00312) Chatfield State Park'
                  'CO00313'='(CO00313) Cherry Creek State Park' 'CO00400'='(CO00400) Archuleta'
                  'CO00401'='(CO00401) Pagosa Springs' 'CO00402'='(CO00402) Navajo State Park'
                  'CO00500'='(CO00500) Baca' 'CO00501'='(CO00501) Springfield'
                  'CO00502'='(CO00502) Pritchett' 'CO00503'='(CO00503) Campo' 'CO00507'='(CO00507) Walsh'
                  'CO00600'='(CO00600) Bent' 'CO00601'='(CO00601) Las Animas' 'CO00700'='(CO00700) Boulder'
                  'CO00701'='(CO00701) Boulder' 'CO00702'='(CO00702) Broomfield'
                  'CO00703'='(CO00703) Lafayette' 'CO00704'='(CO00704) Longmont'
                  'CO00705'='(CO00705) Univ Of Co: Boulder' 'CO00706'='(CO00706) Louisville'
                  'CO00707'='(CO00707) Lyons' 'CO00708'='(CO00708) Nederland' 'CO00800'='(CO00800) Chaffee'
                  'CO00801'='(CO00801) Buena Vista' 'CO00802'='(CO00802) Salida'
                  'CO00900'='(CO00900) Cheyenne' 'CO00901'='(CO00901) Cheyenne Wells'
                  'CO01000'='(CO01000) Clear Creek' 'CO01001'='(CO01001) Idaho Springs'
                  'CO01002'='(CO01002) Georgetown' 'CO01003'='(CO01003) Empire'
                  'CO01100'='(CO01100) Conejos' 'CO01101'='(CO01101) Antonito' 'CO01102'='(CO01102) Romeo'
                  'CO01103'='(CO01103) La Jara' 'CO01104'='(CO01104) Manassa' 'CO01105'='(CO01105) Sanford'
                  'CO01200'='(CO01200) Costilla' 'CO01201'='(CO01201) San Luis'
                  'CO01300'='(CO01300) Crowley' 'CO01301'='(CO01301) Ordway' 'CO01400'='(CO01400) Custer'
                  'CO01401'='(CO01401) Westcliffe' 'CO01500'='(CO01500) Delta' 'CO01501'='(CO01501) Delta'
                  'CO01502'='(CO01502) Paonia' 'CO01503'='(CO01503) Hotchkiss'
                  'CO01504'='(CO01504) Cedaredge' 'CO01600'='(CO01600) Denver'
                  'CO01601'='(CO01601) University Of Denver'
                  'CO01602'='(CO01602) Auraria Higher Educ Cntr'
                  'CO01604'='(CO01604) Un Of Co:Hlth Sciences C'
                  'CO01605'='(CO01605) division Of Wildlife' 'CO01700'='(CO01700) Dolores'
                  'CO01701'='(CO01701) Dove Creek' 'CO01800'='(CO01800) Douglas'
                  'CO01801'='(CO01801) Castle Rock' 'CO01805'='(CO01805) Parker'
                  'CO01806'='(CO01806) Co Dpr Law Enforcement' 'CO01807'='(CO01807) Lone Tree'
                  'CO01900'='(CO01900) Eagle' 'CO01901'='(CO01901) Vail' 'CO01902'='(CO01902) Eagle'
                  'CO01903'='(CO01903) Minturn' 'CO01904'='(CO01904) Basalt' 'CO01906'='(CO01906) Avon'
                  'CO02000'='(CO02000) Elbert' 'CO02001'='(CO02001) Elizabeth' 'CO02002'='(CO02002) Simla'
                  'CO02003'='(CO02003) Kiowa' 'CO02100'='(CO02100) El Paso'
                  'CO02101'='(CO02101) Colorado Springs' 'CO02102'='(CO02102) Fountain'
                  'CO02103'='(CO02103) Manitou Springs'
                  'CO02104'='(CO02104) U of Co:Colorado Springs'
                  'CO02105'='(CO02105) Pikes Peak Community Col'
                  'CO02106'='(CO02106) Palmer Lake' 'CO02107'='(CO02107) Monument'
                  'CO02109'='(CO02109) Green Mountain Falls' 'CO02110'='(CO02110) Calhan'
                  'CO02200'='(CO02200) Fremont' 'CO02201'='(CO02201) Canon City'
                  'CO02202'='(CO02202) Florence' 'CO02300'='(CO02300) Garfield'
                  'CO02301'='(CO02301) Glenwood Springs' 'CO02302'='(CO02302) Parachute'
                  'CO02303'='(CO02303) Rifle' 'CO02304'='(CO02304) Carbondale' 'CO02305'='(CO02305) Silt'
                  'CO02306'='(CO02306) New Castle' 'CO02308'='(CO02308) Two Rivers Drg Enfcmnt T'
                  'CO02400'='(CO02400) gilpin' 'CO02401'='(CO02401) Central City'
                  'CO02402'='(CO02402) Black Hawk' 'CO02403'='(CO02403) Golden Gate Rangers'
                  'CO02500'='(CO02500) Grand' 'CO02501'='(CO02501) Granby' 'CO02502'='(CO02502) Grand Lake'
                  'CO02503'='(CO02503) Kremmling' 'CO02504'='(CO02504) Fraser/Winter Park'
                  'CO02600'='(CO02600) Gunnison' 'CO02601'='(CO02601) Gunnison'
                  'CO02602'='(CO02602) Mount Crested Butte' 'CO02603'='(CO02603) Crested Butte'
                  'CO02700'='(CO02700) Hinsdale' 'CO02800'='(CO02800) Huerfano'
                  'CO02801'='(CO02801) Walsenburg' 'CO02802'='(CO02802) La Veta'
                  'CO02900'='(CO02900) Jackson' 'CO03000'='(CO03000) Jefferson'
                  'CO03001'='(CO03001) Arvada' 'CO03002'='(CO03002) Golden' 'CO03003'='(CO03003) Edgewater'
                  'CO03004'='(CO03004) Lakewood' 'CO03005'='(CO03005) Wheat Ridge'
                  'CO03006'='(CO03006) Lakeside' 'CO03007'='(CO03007) Morrison'
                  'CO03008'='(CO03008) Co School Of Mines' 'CO03009'='(CO03009) Mountain View'
                  'CO03010'='(CO03010) Red Rocks Community Coll' 'CO03100'='(CO03100) Kiowa'
                  'CO03101'='(CO03101) Eads' 'CO03200'='(CO03200) Kit Carson'
                  'CO03201'='(CO03201) Burlington' 'CO03202'='(CO03202) Stratton'
                  'CO03203'='(CO03203) Flagler' 'CO03300'='(CO03300) Lake' 'CO03301'='(CO03301) Leadville'
                  'CO03400'='(CO03400) La Plata' 'CO03401'='(CO03401) Durango'
                  'CO03403'='(CO03403) Ignacio' 'CO03404'='(CO03404) Bayfield'
                  'CO03405'='(CO03405) Fort Lewis College' 'CO03500'='(CO03500) Larimer'
                  'CO03501'='(CO03501) Berthoud' 'CO03502'='(CO03502) Estes Park'
                  'CO03503'='(CO03503) Fort Collins' 'CO03504'='(CO03504) Loveland'
                  'CO03505'='(CO03505) Co St Univ: Fort Collins' 'CO03506'='(CO03506) Wellington'
                  'CO03600'='(CO03600) Las Animas' 'CO03601'='(CO03601) Trinidad'
                  'CO03700'='(CO03700) Lincoln' 'CO03701'='(CO03701) Limon' 'CO03702'='(CO03702) Hugo'
                  'CO03800'='(CO03800) Logan' 'CO03801'='(CO03801) Sterling' 'CO03802'='(CO03802) Fleming'
                  'CO03900'='(CO03900) Mesa' 'CO03901'='(CO03901) Grand Junction'
                  'CO03902'='(CO03902) Fruita' 'CO03903'='(CO03903) Palisade'
                  'CO03904'='(CO03904) De Beque' 'CO03908'='(CO03908) Mesa State College'
                  'CO03909'='(CO03909) Collbran' 'CO04000'='(CO04000) Mineral' 'CO04001'='(CO04001) Creede'
                  'CO04100'='(CO04100) Moffat' 'CO04101'='(CO04101) Craig' 'CO04102'='(CO04102) Dinosaur'
                  'CO04200'='(CO04200) Montezuma' 'CO04201'='(CO04201) Cortez' 'CO04202'='(CO04202) Mancos'
                  'CO04205'='(CO04205) Dolores' 'CO04300'='(CO04300) Montrose'
                  'CO04301'='(CO04301) Montrose' 'CO04303'='(CO04303) Nucla' 'CO04304'='(CO04304) Olathe'
                  'CO04305'='(CO04305) Naturita' 'CO04400'='(CO04400) Morgan' 'CO04401'='(CO04401) Brush'
                  'CO04402'='(CO04402) Fort Morgan' 'CO04403'='(CO04403) Wiggins'
                  'CO04404'='(CO04404) Log Lane Village'
                  'CO04405'='(CO04405) Jackson St Lake Rec Area' 'CO04500'='(CO04500) Otero'
                  'CO04501'='(CO04501) La Junta' 'CO04502'='(CO04502) Rocky Ford'
                  'CO04503'='(CO04503) Manzanola' 'CO04504'='(CO04504) Fowler' 'CO04600'='(CO04600) Ouray'
                  'CO04601'='(CO04601) Ouray' 'CO04602'='(CO04602) Ridgway' 'CO04700'='(CO04700) Park'
                  'CO04701'='(CO04701) Fairplay' 'CO04702'='(CO04702) Alma' 'CO04800'='(CO04800) Phillips'
                  'CO04801'='(CO04801) Holyoke' 'CO04802'='(CO04802) Haxtun' 'CO04900'='(CO04900) Pitkin'
                  'CO04901'='(CO04901) Aspen' 'CO04902'='(CO04902) Snowmass Village'
                  'CO05000'='(CO05000) Prowers' 'CO05001'='(CO05001) Lamar' 'CO05002'='(CO05002) Holly'
                  'CO05004'='(CO05004) Granada' 'CO05100'='(CO05100) Pueblo' 'CO05101'='(CO05101) Pueblo'
                  'CO05102'='(CO05102) Co Mental Health Institu'
                  'CO05103'='(CO05103) Co State Univ: Pueblo' 'CO05200'='(CO05200) Rio Blanco'
                  'CO05201'='(CO05201) Meeker' 'CO05202'='(CO05202) Rangely'
                  'CO05300'='(CO05300) Rio Grande' 'CO05301'='(CO05301) Monte Vista'
                  'CO05302'='(CO05302) Del Norte' 'CO05303'='(CO05303) South Fork'
                  'CO05400'='(CO05400) Routt' 'CO05401'='(CO05401) Steamboat Springs'
                  'CO05402'='(CO05402) Hayden' 'CO05403'='(CO05403) Oak Creek' 'CO05404'='(CO05404) Yampa'
                  'CO05405'='(CO05405) Steamboat Lake State Par' 'CO05500'='(CO05500) Saguache'
                  'CO05501'='(CO05501) Center' 'CO05502'='(CO05502) Saguache'
                  'CO05600'='(CO05600) San Juan' 'CO05601'='(CO05601) Silverton'
                  'CO05700'='(CO05700) San Miguel' 'CO05701'='(CO05701) Telluride'
                  'CO05702'='(CO05702) Norwood' 'CO05800'='(CO05800) Sedgwick'
                  'CO05801'='(CO05801) Julesburg' 'CO05900'='(CO05900) Summit'
                  'CO05901'='(CO05901) Breckenridge' 'CO05902'='(CO05902) Dillon'
                  'CO05903'='(CO05903) Silverthorne' 'CO05904'='(CO05904) Frisco'
                  'CO05905'='(CO05905) Blue River' 'CO06000'='(CO06000) Teller'
                  'CO06001'='(CO06001) Woodland Park' 'CO06002'='(CO06002) Cripple Creek'
                  'CO06003'='(CO06003) Victor' 'CO06100'='(CO06100) Washington' 'CO06101'='(CO06101) Akron'
                  'CO06102'='(CO06102) Otis' 'CO06200'='(CO06200) Weld' 'CO06201'='(CO06201) Fort Lupton'
                  'CO06202'='(CO06202) Greeley' 'CO06203'='(CO06203) Eaton' 'CO06204'='(CO06204) Evans'
                  'CO06205'='(CO06205) La Salle' 'CO06206'='(CO06206) Windsor' 'CO06207'='(CO06207) Erie'
                  'CO06208'='(CO06208) Dacono' 'CO06209'='(CO06209) Kersey' 'CO06210'='(CO06210) Johnstown'
                  'CO06211'='(CO06211) Milliken' 'CO06212'='(CO06212) Ault'
                  'CO06213'='(CO06213) Platteville' 'CO06214'='(CO06214) Pierce'
                  'CO06215'='(CO06215) Gilcrest' 'CO06216'='(CO06216) Univ Northern Colorado'
                  'CO06217'='(CO06217) Frederick' 'CO06218'='(CO06218) Firestone'
                  'CO06220'='(CO06220) Lochbuie' 'CO06300'='(CO06300) Yuma' 'CO06301'='(CO06301) Wray'
                  'CO06302'='(CO06302) Yuma' 'CO06401'='(CO06401) Broomfield'
                  'COCSP00'='(COCSP00) Colorado State Patrol'
                  'COCSP17'='(COCSP17) Colo State Patrol Cortez'
                  'COCSPNO'='(COCSPNO) Colorado Sp Cattle-Theft' 'CODPD00'='(CODPD00) Denver'
                  'CT00002'='(CT00002) Ansonia' 'CT00004'='(CT00004) Avon'
                  'CT00005'='(CT00005) Beacon Falls' 'CT00007'='(CT00007) Berlin'
                  'CT00009'='(CT00009) Bethel' 'CT00011'='(CT00011) Bloomfield'
                  'CT00014'='(CT00014) Branford' 'CT00015'='(CT00015) Bridgeport'
                  'CT00017'='(CT00017) Bristol' 'CT00018'='(CT00018) Brookfield'
                  'CT00023'='(CT00023) Canton' 'CT00025'='(CT00025) Cheshire' 'CT00027'='(CT00027) Clinton'
                  'CT00032'='(CT00032) Coventry' 'CT00033'='(CT00033) Cromwell'
                  'CT00034'='(CT00034) Danbury' 'CT00035'='(CT00035) Darien' 'CT00037'='(CT00037) Derby'
                  'CT00042'='(CT00042) East Hampton' 'CT00043'='(CT00043) East Hartford'
                  'CT00044'='(CT00044) East Haven' 'CT00045'='(CT00045) East Lyme'
                  'CT00046'='(CT00046) Easton' 'CT00047'='(CT00047) East Windsor'
                  'CT00049'='(CT00049) Enfield' 'CT00051'='(CT00051) Fairfield'
                  'CT00052'='(CT00052) Farmington' 'CT00054'='(CT00054) Glastonbury'
                  'CT00056'='(CT00056) Granby' 'CT00057'='(CT00057) Greenwich'
                  'CT00058'='(CT00058) Jewett City' 'CT00059'='(CT00059) Groton'
                  'CT00060'='(CT00060) Guilford' 'CT00062'='(CT00062) Hamden'
                  'CT00064'='(CT00064) Hartford' 'CT00069'='(CT00069) Danielson'
                  'CT00070'='(CT00070) Ledyard' 'CT00076'='(CT00076) Madison'
                  'CT00077'='(CT00077) Manchester' 'CT00080'='(CT00080) Meriden'
                  'CT00081'='(CT00081) Middlebury' 'CT00083'='(CT00083) Middletown'
                  'CT00084'='(CT00084) Milford' 'CT00085'='(CT00085) Monroe'
                  'CT00086'='(CT00086) Montville' 'CT00088'='(CT00088) Naugatuck'
                  'CT00089'='(CT00089) New Britain' 'CT00090'='(CT00090) New Canaan'
                  'CT00093'='(CT00093) New Haven' 'CT00094'='(CT00094) Newington'
                  'CT00095'='(CT00095) New London' 'CT00096'='(CT00096) New Milford'
                  'CT00097'='(CT00097) Newtown' 'CT00099'='(CT00099) North Branford'
                  'CT00101'='(CT00101) North Haven' 'CT00103'='(CT00103) Norwalk'
                  'CT00104'='(CT00104) Norwich' 'CT00106'='(CT00106) Old Saybrook'
                  'CT00107'='(CT00107) Orange' 'CT00109'='(CT00109) Plainfield'
                  'CT00110'='(CT00110) Plainville' 'CT00111'='(CT00111) Plymouth'
                  'CT00113'='(CT00113) Portland' 'CT00115'='(CT00115) Prospect'
                  'CT00116'='(CT00116) Putnam' 'CT00117'='(CT00117) Redding'
                  'CT00118'='(CT00118) Ridgefield' 'CT00119'='(CT00119) Rocky Hill'
                  'CT00124'='(CT00124) Seymour' 'CT00126'='(CT00126) Shelton'
                  'CT00128'='(CT00128) Simsbury' 'CT00131'='(CT00131) Southington'
                  'CT00132'='(CT00132) South Windsor' 'CT00133'='(CT00133) Sprague Town'
                  'CT00134'='(CT00134) Stafford Springs' 'CT00135'='(CT00135) Stamford'
                  'CT00137'='(CT00137) Stonington' 'CT00138'='(CT00138) Stratford'
                  'CT00139'='(CT00139) Suffield' 'CT00140'='(CT00140) Thomaston'
                  'CT00143'='(CT00143) Torrington' 'CT00144'='(CT00144) Trumbull'
                  'CT00146'='(CT00146) Vernon' 'CT00148'='(CT00148) Wallingford'
                  'CT00151'='(CT00151) Waterbury' 'CT00152'='(CT00152) Waterford'
                  'CT00153'='(CT00153) Watertown' 'CT00155'='(CT00155) West Hartford'
                  'CT00156'='(CT00156) West Haven' 'CT00157'='(CT00157) Weston'
                  'CT00158'='(CT00158) Westport' 'CT00159'='(CT00159) Wethersfield'
                  'CT00161'='(CT00161) Wilton' 'CT00162'='(CT00162) Winchester'
                  'CT00163'='(CT00163) Willimantic' 'CT00164'='(CT00164) Windsor'
                  'CT00165'='(CT00165) Windsor Locks' 'CT00166'='(CT00166) Wolcott'
                  'CT00167'='(CT00167) Woodbridge' 'CT00169'='(CT00169) Yale University'
                  'CT00170'='(CT00170) Univ Of Ct: Storrs'
                  'CT00171'='(CT00171) Univ Of Ct: Avery Point'
                  'CT00190'='(CT00190) Central Connecticut St U'
                  'CT00191'='(CT00191) eastern Connecticut St U'
                  'CT00192'='(CT00192) univ Of Ct:Health Center'
                  'CT00193'='(CT00193) Western Connecticut St U'
                  'CT00194'='(CT00194) so Conn State University' 'CT001SP'='(CT001SP) Fairfield'
                  'CT00200'='(CT00200) State Capitol Police' 'CT002SP'='(CT002SP) Hartford'
                  'CT003SP'='(CT003SP) Litchfield' 'CT004SP'='(CT004SP) Middlesex'
                  'CT005SP'='(CT005SP) New Haven' 'CT006SP'='(CT006SP) New London'
                  'CT007SP'='(CT007SP) Tolland' 'CT008SP'='(CT008SP) Windham'
                  'CT00A59'='(CT00A59) Groton Town' 'CT00B59'='(CT00B59) Groton Long Point'
                  'CTCSP00'='(CTCSP00) Connecticut State Police' 'CZ00005'='(CZ00005) Canal Zone'
                  'DCMPD00'='(DCMPD00) Washington' 'DCMTP00'='(DCMTP00) Metro Transit Police'
                  'DCPPD00'='(DCPPD00) United States Park Polic'
                  'DCZPP00'='(DCZPP00) National Zoological Park' 'DE00101'='(DE00101) Dover'
                  'DE00102'='(DE00102) Harrington' 'DE00103'='(DE00103) Smyrna'
                  'DE00104'='(DE00104) Camden' 'DE00105'='(DE00105) Little Creek'
                  'DE00106'='(DE00106) Clayton' 'DE00107'='(DE00107) Felton'
                  'DE00108'='(DE00108) Frederica' 'DE00110'='(DE00110) Magnolia'
                  'DE00111'='(DE00111) Off Of Narc & Dngrs Drug'
                  'DE00112'='(DE00112) Div Alcohol & Tobacco En'
                  'DE00115'='(DE00115) Bowers Beach' 'DE00116'='(DE00116) Houston'
                  'DE00117'='(DE00117) Environmental Control'
                  'DE00118'='(DE00118) State Capitol Police'
                  'DE00120'='(DE00120) State Fire Marshal'
                  'DE00121'='(DE00121) Fish And Wildlife' 'DE00123'='(DE00123) Park Rangers'
                  'DE00126'='(DE00126) Cheswold' 'DE00130'='(DE00130) Ag: Kent County'
                  'DE00131'='(DE00131) Wyoming' 'DE00132'='(DE00132) Delaware State Universit'
                  'DE001SP'='(DE001SP) Kent' 'DE00201'='(DE00201) River And Bay Authority'
                  'DE00202'='(DE00202) Middletown' 'DE00203'='(DE00203) New Castle County P dept'
                  'DE00204'='(DE00204) New Castle' 'DE00205'='(DE00205) Newark'
                  'DE00206'='(DE00206) Wilmington' 'DE00207'='(DE00207) Elsmere'
                  'DE00208'='(DE00208) Newport' 'DE00209'='(DE00209) Delaware City'
                  'DE00210'='(DE00210) Brookside' 'DE00213'='(DE00213) Narc & Drugs New Castle'
                  'DE00214'='(DE00214) Envir Prot Marine N c' 'DE00215'='(DE00215) Amtrak Police'
                  'DE00217'='(DE00217) University Of Delaware'
                  'DE00226'='(DE00226) Wilmington Fire Dept'
                  'DE00292'='(DE00292) Ag: New Castle County' 'DE00301'='(DE00301) Bridgeville'
                  'DE00302'='(DE00302) Delmar' 'DE00303'='(DE00303) Laurel' 'DE00304'='(DE00304) Lewes'
                  'DE00305'='(DE00305) Milford' 'DE00306'='(DE00306) Milton'
                  'DE00307'='(DE00307) Rehoboth Beach' 'DE00308'='(DE00308) Seaford'
                  'DE00309'='(DE00309) Blades' 'DE00310'='(DE00310) Bethany Beach'
                  'DE00311'='(DE00311) Dagsboro' 'DE00312'='(DE00312) Fenwick Island'
                  'DE00313'='(DE00313) Georgetown' 'DE00314'='(DE00314) Greenwood'
                  'DE00315'='(DE00315) Millsboro' 'DE00316'='(DE00316) Selbyville'
                  'DE00317'='(DE00317) Ocean View' 'DE00318'='(DE00318) South Bethany'
                  'DE00319'='(DE00319) Frankford' 'DE00322'='(DE00322) Envir Prot Marine Sussex'
                  'DE00323'='(DE00323) Narc & Drugs Sussex' 'DE00324'='(DE00324) Dewey Beach'
                  'DE00325'='(DE00325) De Riv-Bay Auth Lewes Fe' 'DE00330'='(DE00330) Ellendale'
                  'DE00331'='(DE00331) Bethel' 'DE00335'='(DE00335) Ag: Sussex County'
                  'DE003SP'='(DE003SP) Sussex' 'DE301SP'='(DE301SP) Sp: Kent County'
                  'DE302SP'='(DE302SP) Sp: New Castle County'
                  'DE303SP'='(DE303SP) Sp: Sussex County'
                  'DEDEA01'='(DEDEA01) Dea, Wilmington Res Offc'
                  'DEDSP00'='(DEDSP00) State Police' 'FL00100'='(FL00100) Alachua'
                  'FL00101'='(FL00101) Gainesville' 'FL00102'='(FL00102) Archer'
                  'FL00103'='(FL00103) Hawthorne' 'FL00104'='(FL00104) High Springs'
                  'FL00105'='(FL00105) Newberry' 'FL00106'='(FL00106) University Of Florida'
                  'FL00107'='(FL00107) La Crosse' 'FL00108'='(FL00108) Alachua'
                  'FL00109'='(FL00109) Alachua Co Dle-Gainesvil' 'FL00119'='(FL00119) Micanopy'
                  'FL00125'='(FL00125) Waldo' 'FL00127'='(FL00127) Santa Fe Commun College'
                  'FL00140'='(FL00140) Dep Dle: Alachua County'
                  'FL00150'='(FL00150) Alachua Co Bev-Gainesvil'
                  'FL00180'='(FL00180) Fgc: Alachua County'
                  'FL00190'='(FL00190) Hp: Alachua County'
                  'FL001DB'='(FL001DB) Alachua Co Div Beverage'
                  'FL001DL'='(FL001DL) Alachua Co Crim Law Enf'
                  'FL001GM'='(FL001GM) Alachua Co Game Fwf Comm'
                  'FL001HP'='(FL001HP) Alachua Highway Patrol'
                  'FL001MP'='(FL001MP) Alachua Co Marine Patrol' 'FL00200'='(FL00200) Baker'
                  'FL00201'='(FL00201) Macclenny' 'FL00240'='(FL00240) Dep Dle: Baker County'
                  'FL00280'='(FL00280) Fgc: Baker County' 'FL00290'='(FL00290) Hp: Baker County'
                  'FL002DB'='(FL002DB) Baker Co Div Beverage'
                  'FL002DL'='(FL002DL) Baker Co Crim Law Enf'
                  'FL002GM'='(FL002GM) Baker Co Game Fwf Comm'
                  'FL002HP'='(FL002HP) Baker Highway Patrol'
                  'FL002MP'='(FL002MP) Baker Co Marine Patrol' 'FL00300'='(FL00300) Bay'
                  'FL00301'='(FL00301) Panama City' 'FL00302'='(FL00302) Callaway'
                  'FL00303'='(FL00303) Cedar Grove' 'FL00304'='(FL00304) Mexico Beach'
                  'FL00305'='(FL00305) Springfield' 'FL00306'='(FL00306) Panama City Beach'
                  'FL00307'='(FL00307) Lynn Haven' 'FL00309'='(FL00309) Bay Co Fwf Com- Panama C'
                  'FL00310'='(FL00310) bay Co Dle-Panama City'
                  'FL00311'='(FL00311) Fl St Univ: Panama City' 'FL00326'='(FL00326) Parker'
                  'FL00340'='(FL00340) Dep Dle: Bay County'
                  'FL00350'='(FL00350) Bay Co Bev Enf-Panama Ci'
                  'FL00380'='(FL00380) Fgc: Bay County' 'FL00390'='(FL00390) Hp: Bay County'
                  'FL003DB'='(FL003DB) Bay Co Div Beverage'
                  'FL003DL'='(FL003DL) Bay Co Criminal Law Enf'
                  'FL003GM'='(FL003GM) Bay Co Game Fwf Comm'
                  'FL003HP'='(FL003HP) Bay Highway Patrol'
                  'FL003MP'='(FL003MP) Bay County Marine Patrol' 'FL00400'='(FL00400) Bradford'
                  'FL00401'='(FL00401) Starke' 'FL00402'='(FL00402) Hampton' 'FL00403'='(FL00403) Lawtey'
                  'FL00440'='(FL00440) Dep Dle: Bradford County'
                  'FL00480'='(FL00480) Fgc: Bradford County'
                  'FL00490'='(FL00490) Hp: Bradford County'
                  'FL004DB'='(FL004DB) Bradford Co Div Beverage'
                  'FL004DL'='(FL004DL) Bradford Co Crim Law Enf'
                  'FL004GM'='(FL004GM) Bradford Co Game Fwf Com'
                  'FL004HP'='(FL004HP) Bradford Highway Patrol'
                  'FL004MP'='(FL004MP) Bradford Co Marine Ptl' 'FL00500'='(FL00500) Brevard'
                  'FL00501'='(FL00501) Cape Canaveral' 'FL00502'='(FL00502) Cocoa'
                  'FL00503'='(FL00503) Cocoa Beach' 'FL00504'='(FL00504) Eau Gallie'
                  'FL00505'='(FL00505) Indialantic' 'FL00506'='(FL00506) Indian Harbour Beach'
                  'FL00507'='(FL00507) Melbourne' 'FL00508'='(FL00508) Melbourne Beach'
                  'FL00509'='(FL00509) Rockledge' 'FL00510'='(FL00510) Satellite Beach'
                  'FL00511'='(FL00511) Titusville' 'FL00512'='(FL00512) Palm Bay'
                  'FL00513'='(FL00513) Palm Shores' 'FL00514'='(FL00514) Merritt Island'
                  'FL00515'='(FL00515) Melbourne Village' 'FL00516'='(FL00516) West Melbourne'
                  'FL00517'='(FL00517) Brevard Co Dle-Melbourne'
                  'FL00518'='(FL00518) Melbourne Intrnl Airport'
                  'FL00519'='(FL00519) Brevard Co Ofc Pub Safet'
                  'FL00540'='(FL00540) Dep Dle: Brevard County'
                  'FL00550'='(FL00550) Brevard Co Bevereage Enf'
                  'FL00580'='(FL00580) Fgc: Brevard County'
                  'FL00590'='(FL00590) Hp: Brevard County'
                  'FL00591'='(FL00591) Brevard Co Shp-Cocoa'
                  'FL005DB'='(FL005DB) Brevard Co Div Beverage'
                  'FL005DL'='(FL005DL) Brevard Co Crim Law Enf'
                  'FL005GM'='(FL005GM) Brevard Co Game Fwf Comm'
                  'FL005HP'='(FL005HP) Brevard Highway Patrol'
                  'FL005MP'='(FL005MP) Brevard Co Marine Patrol' 'FL00600'='(FL00600) Broward'
                  'FL00601'='(FL00601) Dania' 'FL00602'='(FL00602) Deerfield Beach'
                  'FL00603'='(FL00603) Fort Lauderdale' 'FL00604'='(FL00604) Hallandale'
                  'FL00605'='(FL00605) Hollywood' 'FL00606'='(FL00606) Plantation'
                  'FL00607'='(FL00607) Pompano Beach' 'FL00608'='(FL00608) Pembroke Pines'
                  'FL00609'='(FL00609) Wilton Manors' 'FL00610'='(FL00610) Cooper City'
                  'FL00611'='(FL00611) Coconut Creek' 'FL00612'='(FL00612) Davie'
                  'FL00613'='(FL00613) Hacienda Village' 'FL00614'='(FL00614) Hillsboro Beach'
                  'FL00615'='(FL00615) Hollywood Ridge Farms'
                  'FL00616'='(FL00616) Lauderdale-By-The-Sea'
                  'FL00617'='(FL00617) Lauderdale Lakes' 'FL00618'='(FL00618) Lauderhill'
                  'FL00620'='(FL00620) Lighthouse Point' 'FL00621'='(FL00621) Margate'
                  'FL00622'='(FL00622) Miramar' 'FL00623'='(FL00623) North Lauderdale'
                  'FL00624'='(FL00624) Oakland Park' 'FL00626'='(FL00626) Sea Ranch Lakes'
                  'FL00627'='(FL00627) Sunrise' 'FL00628'='(FL00628) Coral Springs'
                  'FL00630'='(FL00630) Pembroke Park' 'FL00631'='(FL00631) Tamarac'
                  'FL00632'='(FL00632) Fort Lauderdale Airport' 'FL00633'='(FL00633) Parkland'
                  'FL00634'='(FL00634) Seminole Tribal' 'FL00638'='(FL00638) Southwest Ranches'
                  'FL00640'='(FL00640) Dep Dle: Broward County'
                  'FL00641'='(FL00641) Dept Of Agriculture'
                  'FL00650'='(FL00650) Broward Co Bev-Lauderhil'
                  'FL00670'='(FL00670) Dept Of Ins: Broward Cty'
                  'FL00680'='(FL00680) Fgc: Broward County' 'FL00688'='(FL00688) Weston'
                  'FL00690'='(FL00690) Hp: Broward County' 'FL00699'='(FL00699) Port Everglades'
                  'FL006DB'='(FL006DB) Broward Co Div Beverage'
                  'FL006DL'='(FL006DL) Broward Co Crim Law Enf'
                  'FL006GM'='(FL006GM) Broward Co Game Fwf Comm'
                  'FL006HP'='(FL006HP) Broward Highway Patrol'
                  'FL006MP'='(FL006MP) Broward Co Marine Patrol' 'FL00700'='(FL00700) Calhoun'
                  'FL00701'='(FL00701) Altha' 'FL00702'='(FL00702) Blountstown'
                  'FL00740'='(FL00740) Dep Dle: Calhoun County'
                  'FL00780'='(FL00780) Fgc: Calhoun County'
                  'FL00790'='(FL00790) Hp: Calhoun County'
                  'FL007DB'='(FL007DB) Calhoun Co Div Beverage'
                  'FL007DL'='(FL007DL) Calhoun Co Crim Law Enf'
                  'FL007GM'='(FL007GM) Calhoun Co Game Fwf Comm'
                  'FL007HP'='(FL007HP) Calhoun Highway Patrol'
                  'FL007MP'='(FL007MP) Calhoun Co Marine Patrol' 'FL00800'='(FL00800) Charlotte'
                  'FL00802'='(FL00802) Punta Gorda'
                  'FL00840'='(FL00840) Dep Dle:Charlotte County'
                  'FL00880'='(FL00880) Fgc: Charlotte County'
                  'FL00890'='(FL00890) Hp: Charlotte County'
                  'FL008DB'='(FL008DB) Charlotte Co Div Beverag'
                  'FL008DL'='(FL008DL) Charlotte Co Crim Law En'
                  'FL008GM'='(FL008GM) Charlotte Co Game Fwf Co'
                  'FL008HP'='(FL008HP) Charlotte Highway Patrol'
                  'FL008MP'='(FL008MP) Charlotte Co Marine Ptl' 'FL00900'='(FL00900) Citrus'
                  'FL00901'='(FL00901) Crystal River' 'FL00902'='(FL00902) Inverness'
                  'FL00940'='(FL00940) Dep Dle: Citrus County'
                  'FL00980'='(FL00980) Fgc: Citrus County'
                  'FL00990'='(FL00990) Hp: Citrus County'
                  'FL009DB'='(FL009DB) Citrus Co Div Beverage'
                  'FL009DL'='(FL009DL) Citrus Co Crim Law Enf'
                  'FL009GM'='(FL009GM) Citrus Co Game Fwf Comm'
                  'FL009HP'='(FL009HP) Citrus Highway Patrol'
                  'FL009MP'='(FL009MP) Citrus Co Marine Patrol' 'FL01000'='(FL01000) Clay'
                  'FL01001'='(FL01001) Green Cove Springs' 'FL01002'='(FL01002) Orange Park'
                  'FL01003'='(FL01003) Keystone Heights'
                  'FL01040'='(FL01040) Dep Dle: Clay County'
                  'FL01080'='(FL01080) Fgc: Clay County' 'FL01090'='(FL01090) Hp: Clay County'
                  'FL010DB'='(FL010DB) Clay Co Div Beverage'
                  'FL010DL'='(FL010DL) Clay Co Crim Law Enf'
                  'FL010GM'='(FL010GM) Clay Co Game Fwf Comm'
                  'FL010HP'='(FL010HP) Clay Highway Patrol'
                  'FL010MP'='(FL010MP) Clay Co Marine Patrol' 'FL01100'='(FL01100) Collier'
                  'FL01101'='(FL01101) Naples' 'FL01102'='(FL01102) Everglades City'
                  'FL01103'='(FL01103) Marco Island'
                  'FL01140'='(FL01140) Dep Dle: Collier County'
                  'FL01180'='(FL01180) Fgc: Collier County'
                  'FL01190'='(FL01190) Hp: Collier County'
                  'FL011DB'='(FL011DB) Collier Co Div Beverage'
                  'FL011DL'='(FL011DL) Collier Co Crim Law Enf'
                  'FL011GM'='(FL011GM) Collier Co Game Fwf Comm'
                  'FL011HP'='(FL011HP) Collier Highway Patrol'
                  'FL011MP'='(FL011MP) Collier Co Marine Patrol' 'FL01200'='(FL01200) Columbia'
                  'FL01201'='(FL01201) Lake City' 'FL01202'='(FL01202) Fort White'
                  'FL01203'='(FL01203) Columbia Co Fwf Lake Cty'
                  'FL01240'='(FL01240) Dep Dle: Columbia County'
                  'FL01280'='(FL01280) Fgc: Columbia County'
                  'FL01290'='(FL01290) Hp: Columbia County'
                  'FL012DB'='(FL012DB) Columbia Co Div Beverage'
                  'FL012DL'='(FL012DL) Columbia Co Crim Law Enf'
                  'FL012GM'='(FL012GM) Columbia Co Game Fwf Com'
                  'FL012HP'='(FL012HP) Columbia Highway Patrol'
                  'FL012MP'='(FL012MP) Columbia Co Marine Ptl' 'FL01300'='(FL01300) Miami-Dade'
                  'FL01301'='(FL01301) Bal Harbour Village' 'FL01302'='(FL01302) Coral Gables'
                  'FL01303'='(FL01303) Florida City' 'FL01304'='(FL01304) Hialeah'
                  'FL01305'='(FL01305) Homestead' 'FL01306'='(FL01306) Miami'
                  'FL01307'='(FL01307) Miami Beach' 'FL01308'='(FL01308) Miami Shores'
                  'FL01309'='(FL01309) Miami Springs' 'FL01310'='(FL01310) North Miami Beach'
                  'FL01312'='(FL01312) Opa Locka' 'FL01313'='(FL01313) Surfside'
                  'FL01314'='(FL01314) Biscayne Park' 'FL01315'='(FL01315) El Portal'
                  'FL01316'='(FL01316) Hialeah Gardens' 'FL01317'='(FL01317) North Bay Village'
                  'FL01318'='(FL01318) North Miami' 'FL01319'='(FL01319) South Miami'
                  'FL01320'='(FL01320) Virginia Gardens' 'FL01321'='(FL01321) West Miami'
                  'FL01322'='(FL01322) Bay Harbor Island' 'FL01324'='(FL01324) Golden Beach'
                  'FL01325'='(FL01325) Indian Creek Village' 'FL01327'='(FL01327) Medley'
                  'FL01329'='(FL01329) Sweetwater' 'FL01330'='(FL01330) Dle: Miami-Dade Co,Miami'
                  'FL01331'='(FL01331) Florida International Un'
                  'FL01337'='(FL01337) Miami-Dade Cnty Pub Schl'
                  'FL01338'='(FL01338) Dade Co Treas Ins Fraud'
                  'FL01339'='(FL01339) Miccosukee Tribal'
                  'FL01340'='(FL01340) Dep Dle: Miami-Dade Cnty'
                  'FL01343'='(FL01343) Key Biscayne' 'FL01350'='(FL01350) Dade Co Beverage Enf'
                  'FL01351'='(FL01351) Sunny Isles Beach'
                  'FL01370'='(FL01370) Dept Of Ins:Miami-Dade C'
                  'FL01380'='(FL01380) us Cust Serv Sect Comm'
                  'FL01381'='(FL01381) Fgc: Miami-Dade County'
                  'FL01390'='(FL01390) Hp: Miami-Dade County' 'FL01391'='(FL01391) Aventura'
                  'FL01392'='(FL01392) Village Of Pinecrest' 'FL01393'='(FL01393) Miami Lakes'
                  'FL01394'='(FL01394) Miami Gardens' 'FL01395'='(FL01395) Palmetto Bay'
                  'FL01396'='(FL01396) Doral' 'FL013DB'='(FL013DB) Dade Co Div Beverage'
                  'FL013DL'='(FL013DL) Dade Co Crim Law Enf'
                  'FL013GM'='(FL013GM) Dade Co Game Fwf Comm'
                  'FL013HP'='(FL013HP) Dade Highway Patrol'
                  'FL013MP'='(FL013MP) Dade Co Marine Patrol' 'FL01400'='(FL01400) Desoto'
                  'FL01401'='(FL01401) Arcadia' 'FL01440'='(FL01440) Dep Dle: Desoto County'
                  'FL01480'='(FL01480) Fgc: Desoto County'
                  'FL01490'='(FL01490) Hp: Desoto County'
                  'FL014DB'='(FL014DB) De Soto Co Div Beverage'
                  'FL014DL'='(FL014DL) De Soto Co Crim Law Enf'
                  'FL014GM'='(FL014GM) De Soto Co Game Fwf Comm'
                  'FL014HP'='(FL014HP) De Soto Highway Patrol'
                  'FL014MP'='(FL014MP) De Soto Co Marine Patrol' 'FL01500'='(FL01500) Dixie'
                  'FL01501'='(FL01501) Cross City' 'FL01502'='(FL01502) Horseshoe Beach'
                  'FL01540'='(FL01540) Dep Dle: Dixie County'
                  'FL01580'='(FL01580) Fgc: Dixie County' 'FL01590'='(FL01590) Hp: Dixie County'
                  'FL015DB'='(FL015DB) Dixie Co Div Beverage'
                  'FL015DL'='(FL015DL) Dixie Co Crim Law Enf'
                  'FL015GM'='(FL015GM) Dixie Co Game Fwf Comm'
                  'FL015HP'='(FL015HP) Dixie Highway Patrol'
                  'FL015MP'='(FL015MP) Dixie Co Marine Patrol' 'FL01600'='(FL01600) Duval'
                  'FL01601'='(FL01601) Atlantic Beach' 'FL01602'='(FL01602) Jacksonville'
                  'FL01603'='(FL01603) Jacksonville Beach' 'FL01604'='(FL01604) Neptune Beach'
                  'FL01605'='(FL01605) Dle:Duval Co, Jacksonvil'
                  'FL01606'='(FL01606) University Of North Flor'
                  'FL01607'='(FL01607) Jacksonville Airport Aut'
                  'FL01611'='(FL01611) Duval County Schools' 'FL01625'='(FL01625) Baldwin'
                  'FL01640'='(FL01640) Dep Dle: Duval County'
                  'FL01650'='(FL01650) Duval Co Bev Enforcement'
                  'FL01670'='(FL01670) Dept Of Ins: Duval Cnty'
                  'FL01680'='(FL01680) Fgc: Duval County' 'FL01690'='(FL01690) Hp: Duval County'
                  'FL016DB'='(FL016DB) Duval Co Div Beverage'
                  'FL016DL'='(FL016DL) Duval Co Crim Law Enf'
                  'FL016GM'='(FL016GM) Duval Co Game Fwf Comm'
                  'FL016HP'='(FL016HP) Duval Highway Patrol'
                  'FL016MP'='(FL016MP) Duval Co Marine Patrol' 'FL01700'='(FL01700) Escambia'
                  'FL01701'='(FL01701) Pensacola' 'FL01702'='(FL01702) Century'
                  'FL01703'='(FL01703) Dle:Escambia Co, Pensaco'
                  'FL01704'='(FL01704) University Of West Flori'
                  'FL01740'='(FL01740) Dep Dle: Escambia County'
                  'FL01750'='(FL01750) Escambia Co Beverage Enf'
                  'FL01770'='(FL01770) Dept Of Ins:Escambia Cty'
                  'FL01780'='(FL01780) Fgc: Escambia County'
                  'FL01790'='(FL01790) Hp: Escambia County'
                  'FL01791'='(FL01791) Pensacola Junior College'
                  'FL017DB'='(FL017DB) Escambia Co Div Beverage'
                  'FL017DL'='(FL017DL) Escambia Co Crim Law Enf'
                  'FL017GM'='(FL017GM) Escambia Co Game Fwf Com'
                  'FL017HP'='(FL017HP) Escambia Highway Patrol'
                  'FL017MP'='(FL017MP) Escambia Co Marine Ptl' 'FL01800'='(FL01800) Flagler'
                  'FL01801'='(FL01801) Bunnell' 'FL01802'='(FL01802) Flagler Beach'
                  'FL01840'='(FL01840) Dep Dle: Flagler County'
                  'FL01880'='(FL01880) Fgc: Flagler County'
                  'FL01890'='(FL01890) Hp: Flagler County'
                  'FL018DB'='(FL018DB) Flagler Co Div Beverage'
                  'FL018DL'='(FL018DL) Flagler Co Crim Law Enf'
                  'FL018GM'='(FL018GM) Flagler Co Game Fwf Comm'
                  'FL018HP'='(FL018HP) Flagler Highway Patrol'
                  'FL018MP'='(FL018MP) Flagler Co Marine Patrol' 'FL01900'='(FL01900) Franklin'
                  'FL01901'='(FL01901) Apalachicola' 'FL01902'='(FL01902) Carrabelle'
                  'FL01940'='(FL01940) Dep Dle: Franklin County'
                  'FL01980'='(FL01980) Fgc: Franklin County'
                  'FL01990'='(FL01990) Hp: Franklin County'
                  'FL019DB'='(FL019DB) Franklin Co Div Beverage'
                  'FL019DL'='(FL019DL) Franklin Co Crim Law Enf'
                  'FL019GM'='(FL019GM) Franklin Co Game Fwf Com'
                  'FL019HP'='(FL019HP) Franklin Highway Patrol'
                  'FL019MP'='(FL019MP) Franklin Co Marine Ptl' 'FL02000'='(FL02000) Gadsden'
                  'FL02001'='(FL02001) Quincy' 'FL02002'='(FL02002) Chattahoochee'
                  'FL02003'='(FL02003) Havana' 'FL02004'='(FL02004) Gretna' 'FL02005'='(FL02005) Midway'
                  'FL02006'='(FL02006) Greensboro' 'FL02040'='(FL02040) Dep Dle: Gadsden County'
                  'FL02080'='(FL02080) Fgc: Gadsden County'
                  'FL02090'='(FL02090) Hp: Gadsden County'
                  'FL020DB'='(FL020DB) Gadsden Co Div Beverage'
                  'FL020DL'='(FL020DL) Gadsden Co Crim Law Enf'
                  'FL020GM'='(FL020GM) Gadsden Co Game Fwf Comm'
                  'FL020HP'='(FL020HP) Gadsden Highway Patrol'
                  'FL020MP'='(FL020MP) Gadsden Co Marine Patrol' 'FL02100'='(FL02100) Gilchrist'
                  'FL02102'='(FL02102) Trenton' 'FL02140'='(FL02140) Dep Dle:Gilchrist County'
                  'FL02180'='(FL02180) Fgc: Gilchrist County'
                  'FL02190'='(FL02190) Hp: Gilchrist County'
                  'FL021DB'='(FL021DB) Gilchrist Co Div Beverag'
                  'FL021DL'='(FL021DL) Gilchrist Co Crim Law En'
                  'FL021GM'='(FL021GM) Gilchrist Co Game Fwf Co'
                  'FL021HP'='(FL021HP) Gilchrist Highway Patrol'
                  'FL021MP'='(FL021MP) Gilchrist Co Marine Ptl' 'FL02200'='(FL02200) Glades'
                  'FL02201'='(FL02201) Moore Haven' 'FL02240'='(FL02240) Dep Dle: Glades County'
                  'FL02280'='(FL02280) Fgc: Glades County'
                  'FL02290'='(FL02290) Hp: Glades County'
                  'FL022DB'='(FL022DB) Glades Co Div Beverage'
                  'FL022DL'='(FL022DL) Glades Co Crim Law Enf'
                  'FL022GM'='(FL022GM) Glades Co Game Fwf Comm'
                  'FL022HP'='(FL022HP) Glades Highway Patrol'
                  'FL022MP'='(FL022MP) Glades Co Marine Patrol' 'FL02300'='(FL02300) Gulf'
                  'FL02301'='(FL02301) Port St. Joe' 'FL02302'='(FL02302) Wewahitchka'
                  'FL02340'='(FL02340) Dep Dle: Gulf County'
                  'FL02380'='(FL02380) Fgc: Gulf County' 'FL02390'='(FL02390) Hp: Gulf County'
                  'FL023DB'='(FL023DB) Gulf Co Div Beverage'
                  'FL023DL'='(FL023DL) Gulf Co Crim Law Enf'
                  'FL023GM'='(FL023GM) Gulf Co Game Fwf Comm'
                  'FL023HP'='(FL023HP) Gulf Highway Patrol'
                  'FL023MP'='(FL023MP) Gulf Co Marine Patrol' 'FL02400'='(FL02400) Hamilton'
                  'FL02401'='(FL02401) Jasper' 'FL02402'='(FL02402) Jennings'
                  'FL02403'='(FL02403) White Springs' 'FL02404'='(FL02404) Hamilton Co Ag Bureau'
                  'FL02440'='(FL02440) Dep Dle: Hamilton County'
                  'FL02480'='(FL02480) Fgc: Hamilton County'
                  'FL02490'='(FL02490) Hp: Hamilton County'
                  'FL024DB'='(FL024DB) Hamilton Co Div Beverage'
                  'FL024DL'='(FL024DL) Hamilton Co Crim Law Enf'
                  'FL024GM'='(FL024GM) Hamilton Co Game Fwf Com'
                  'FL024HP'='(FL024HP) Hamilton Highway Patrol'
                  'FL024MP'='(FL024MP) Hamilton Co Marine Patro' 'FL02500'='(FL02500) Hardee'
                  'FL02501'='(FL02501) Bowling Green' 'FL02502'='(FL02502) Wauchula'
                  'FL02503'='(FL02503) Zolfo Springs'
                  'FL02540'='(FL02540) Dep Dle: Hardee County'
                  'FL02580'='(FL02580) Fgc: Hardee County'
                  'FL02590'='(FL02590) Hp: Hardee County'
                  'FL025DB'='(FL025DB) Hardee Co Div Beverage'
                  'FL025DL'='(FL025DL) Hardee Co Crim Law Enf'
                  'FL025GM'='(FL025GM) Hardee Co Game Fwf Comm'
                  'FL025HP'='(FL025HP) Hardee Highway Patrol'
                  'FL025MP'='(FL025MP) Hardee Co Marine Patrol' 'FL02600'='(FL02600) Hendry'
                  'FL02601'='(FL02601) Clewiston' 'FL02603'='(FL02603) Seminole Indian Pd'
                  'FL02640'='(FL02640) Dep Dle: Hendry County'
                  'FL02680'='(FL02680) Fgc: Hendry County'
                  'FL02690'='(FL02690) Hp: Hendry County'
                  'FL026DB'='(FL026DB) Hendry Co Div Beverage'
                  'FL026DL'='(FL026DL) Hendry Co Crim Law Enf'
                  'FL026GM'='(FL026GM) Hendry Co Game Fwf Comm'
                  'FL026HP'='(FL026HP) Hendry Highway Patrol'
                  'FL026MP'='(FL026MP) Hendry Co Marine Patrol' 'FL02700'='(FL02700) Hernando'
                  'FL02701'='(FL02701) Brooksville'
                  'FL02740'='(FL02740) Dep Dle: Hernando County'
                  'FL02780'='(FL02780) Fgc: Hernando County'
                  'FL02790'='(FL02790) Hp: Hernando County'
                  'FL027DB'='(FL027DB) Hernando Co Div Beverage'
                  'FL027DL'='(FL027DL) Hernando Co Crim Law Enf'
                  'FL027GM'='(FL027GM) Hernando Co Game Fwf Com'
                  'FL027HP'='(FL027HP) Hernando Highway Patrol'
                  'FL027MP'='(FL027MP) Hernando Co Marine Ptl' 'FL02800'='(FL02800) Highlands'
                  'FL02801'='(FL02801) Avon Park' 'FL02802'='(FL02802) Lake Placid'
                  'FL02803'='(FL02803) Sebring' 'FL02804'='(FL02804) Sebring Airport Authorit'
                  'FL02805'='(FL02805) Highlands Co Dle Sebring'
                  'FL02840'='(FL02840) Dep Dle:Highlands County'
                  'FL02880'='(FL02880) Fgc: Highlands County'
                  'FL02890'='(FL02890) Hp: Highlands County'
                  'FL028DB'='(FL028DB) Highlands Co Div Beverag'
                  'FL028DL'='(FL028DL) Highlands Co Crim Law En'
                  'FL028GM'='(FL028GM) Highlands Co Game Fwf Co'
                  'FL028HP'='(FL028HP) Highlands Highway Patrol'
                  'FL028MP'='(FL028MP) Highlands Co Marine Ptl'
                  'FL02900'='(FL02900) Hillsborough' 'FL02901'='(FL02901) Plant City'
                  'FL02902'='(FL02902) Tampa' 'FL02903'='(FL02903) Temple Terrace'
                  'FL02905'='(FL02905) Dle:Hillsborough, Tampa'
                  'FL02906'='(FL02906) Tampa International Airp'
                  'FL02907'='(FL02907) Univ Of S fl: Tampa'
                  'FL02940'='(FL02940) Dep Dle:Hillsborough Cty'
                  'FL02950'='(FL02950) Hillsborough Co Bev Tamp'
                  'FL02970'='(FL02970) Dept Of Ins:Hillsborough'
                  'FL02980'='(FL02980) Fgc: Hillsborough County'
                  'FL02990'='(FL02990) Hp: Hillsborough County'
                  'FL029DB'='(FL029DB) Hillsborough Co Div Bev'
                  'FL029DL'='(FL029DL) Hillsborough Co Crim Law'
                  'FL029GM'='(FL029GM) Hillsborough Co Game Fwf'
                  'FL029HP'='(FL029HP) Hillsborough Highway Pat'
                  'FL029MP'='(FL029MP) Hillsborough Co Marine P'
                  'FL029UT'='(FL029UT) university Of Tampa' 'FL03000'='(FL03000) Holmes'
                  'FL03001'='(FL03001) Bonifay' 'FL03040'='(FL03040) Dep Dle: Holmes County'
                  'FL03080'='(FL03080) Fgc: Holmes County'
                  'FL03090'='(FL03090) Hp: Holmes County'
                  'FL030DB'='(FL030DB) Holmes Co Div Beverage'
                  'FL030DL'='(FL030DL) Holmes Co Crim Law Enf'
                  'FL030GM'='(FL030GM) Holmes Co Game Fwf Comm'
                  'FL030HP'='(FL030HP) Holmes Highway Patrol'
                  'FL030MP'='(FL030MP) Holmes Co Marine Patrol'
                  'FL03100'='(FL03100) indian River' 'FL03101'='(FL03101) Fellsmere'
                  'FL03102'='(FL03102) Sebastian' 'FL03103'='(FL03103) Vero Beach'
                  'FL03104'='(FL03104) Indian River Shores'
                  'FL03140'='(FL03140) Dep Dle:Indian River Cty'
                  'FL03180'='(FL03180) Fgc: Indian River County'
                  'FL03190'='(FL03190) Hp: Indian River County'
                  'FL031DB'='(FL031DB) Indian River Co Div Bev'
                  'FL031DL'='(FL031DL) Indian River Co Crim Law'
                  'FL031GM'='(FL031GM) Indian River Co Game Fwf'
                  'FL031HP'='(FL031HP) Indian River Highway Pat'
                  'FL031MP'='(FL031MP) Indian River Co Marine P' 'FL03200'='(FL03200) Jackson'
                  'FL03201'='(FL03201) Marianna' 'FL03202'='(FL03202) Cottondale'
                  'FL03203'='(FL03203) Graceville' 'FL03204'='(FL03204) Malone'
                  'FL03205'='(FL03205) Sneads' 'FL03206'='(FL03206) Grand Ridge'
                  'FL03207'='(FL03207) Alford' 'FL03240'='(FL03240) Dep Dle: Jackson County'
                  'FL03250'='(FL03250) Jackson Co. Bev. Enf. Bu'
                  'FL03280'='(FL03280) Fgc: Jackson County'
                  'FL03290'='(FL03290) Hp: Jackson County'
                  'FL032DB'='(FL032DB) Jackson Co Div Beverage'
                  'FL032DL'='(FL032DL) Jackson Co Crim Law Enf'
                  'FL032GM'='(FL032GM) Jackson Co Game Fwf Comm'
                  'FL032HP'='(FL032HP) Jackson Highway Patrol'
                  'FL032MP'='(FL032MP) Jackson Co Marine Patrol' 'FL03300'='(FL03300) Jefferson'
                  'FL03301'='(FL03301) Monticello' 'FL03340'='(FL03340) Dep Dle:Jefferson County'
                  'FL03380'='(FL03380) Fgc: Jefferson County'
                  'FL03390'='(FL03390) Hp: Jefferson County'
                  'FL033DB'='(FL033DB) Jefferson Co Div Beverag'
                  'FL033DL'='(FL033DL) Jefferson Co Crim Law En'
                  'FL033GM'='(FL033GM) Jefferson Co Game Fwf Co'
                  'FL033HP'='(FL033HP) Jefferson Highway Patrol'
                  'FL033MP'='(FL033MP) Jefferson Co Marine Ptl' 'FL03400'='(FL03400) Lafayette'
                  'FL03401'='(FL03401) Mayo' 'FL03440'='(FL03440) Dep Dle:Lafayette County'
                  'FL03480'='(FL03480) Fgc: Lafayette County'
                  'FL03490'='(FL03490) Hp: Lafayette County'
                  'FL034DB'='(FL034DB) Lafayette Co Div Beverag'
                  'FL034DL'='(FL034DL) Lafayette Co Crim Law En'
                  'FL034GM'='(FL034GM) Lafayette Co Game Fwf Co'
                  'FL034HP'='(FL034HP) Lafayette Highway Patrol'
                  'FL034MP'='(FL034MP) Lafayette Co Marine Ptl' 'FL03500'='(FL03500) Lake'
                  'FL03501'='(FL03501) Eustis' 'FL03502'='(FL03502) Leesburg'
                  'FL03503'='(FL03503) Clermont' 'FL03504'='(FL03504) Fruitland Park'
                  'FL03505'='(FL03505) Groveland' 'FL03506'='(FL03506) Howey-In-The-Hills'
                  'FL03507'='(FL03507) Mascotte' 'FL03508'='(FL03508) Minneola'
                  'FL03509'='(FL03509) Montverde' 'FL03510'='(FL03510) Mount Dora'
                  'FL03511'='(FL03511) Tavares' 'FL03512'='(FL03512) Umatilla'
                  'FL03513'='(FL03513) Lady Lake' 'FL03514'='(FL03514) Astatula'
                  'FL03540'='(FL03540) Dep Dle: Lake County'
                  'FL03580'='(FL03580) Fgc: Lake County' 'FL03590'='(FL03590) Hp: Lake County'
                  'FL035DB'='(FL035DB) Lake Co Div Beverage'
                  'FL035DL'='(FL035DL) Lake Co Crim Law Enf'
                  'FL035GM'='(FL035GM) Lake Co Game Fwf Comm'
                  'FL035HP'='(FL035HP) Lake Highway Patrol'
                  'FL035MP'='(FL035MP) Lake Co Marine Patrol' 'FL03600'='(FL03600) Lee'
                  'FL03601'='(FL03601) Fort Myers' 'FL03602'='(FL03602) Cape Coral'
                  'FL03603'='(FL03603) Sanibel' 'FL03604'='(FL03604) Lee County Port Authorit'
                  'FL03605'='(FL03605) Dle:Lee Co, Fort Myers'
                  'FL03607'='(FL03607) Fl Gulf Coast University'
                  'FL03640'='(FL03640) Dep Dle: Lee County'
                  'FL03650'='(FL03650) Lee Co Bev Enf-Fort Myer'
                  'FL03670'='(FL03670) Dept Of Ins: Lee County'
                  'FL03680'='(FL03680) Fgc: Lee County' 'FL03690'='(FL03690) Hp: Lee County'
                  'FL036DB'='(FL036DB) Lee Co Div Beverage'
                  'FL036DL'='(FL036DL) Lee Co Crim Law Enf'
                  'FL036GM'='(FL036GM) Lee Co Game Fwf Comm'
                  'FL036HP'='(FL036HP) Lee Highway Patrol'
                  'FL036MP'='(FL036MP) Lee Co Marine Patrol' 'FL03700'='(FL03700) Leon'
                  'FL03701'='(FL03701) Fla Dept Of Law Enforce'
                  'FL03702'='(FL03702) Fla Division Of Beverage'
                  'FL03703'='(FL03703) Tallahassee'
                  'FL03704'='(FL03704) Dle:Leon Co, Tallahassee'
                  'FL03705'='(FL03705) Dep Dle: Leon County'
                  'FL03706'='(FL03706) Fl St Univ: Tallahassee'
                  'FL03707'='(FL03707) Florida A&m University'
                  'FL03708'='(FL03708) Fgc: Leon County' 'FL03709'='(FL03709) Capitol Police'
                  'FL03710'='(FL03710) Leon Co Dle Park Patrol'
                  'FL03711'='(FL03711) Leon Co. Dot Tallahasee'
                  'FL03712'='(FL03712) Leon Co. Marks & Brands'
                  'FL03713'='(FL03713) State Fire Marshal'
                  'FL03714'='(FL03714) Leon Co. Agr & Con Talla'
                  'FL03715'='(FL03715) Leon Co. Ag Rd Gd Tallah'
                  'FL03716'='(FL03716) Leon Co. Lottery Sec Tal'
                  'FL03717'='(FL03717) St Treasurers Off Div I'
                  'FL03722'='(FL03722) tallahassee Comm College'
                  'FL03750'='(FL03750) Leon Co Bev Enf Tallahas'
                  'FL03790'='(FL03790) Hp: Leon County'
                  'FL03791'='(FL03791) Leon Co Fhp Hq Tallahass'
                  'FL037DB'='(FL037DB) Leon Co Div Beverage'
                  'FL037DL'='(FL037DL) Leon Co Crim Law Enf'
                  'FL037GM'='(FL037GM) Leon Co Game Fwf Comm'
                  'FL037HP'='(FL037HP) Leon Highway Patrol'
                  'FL037MP'='(FL037MP) Leon Co Marine Patrol' 'FL03800'='(FL03800) Levy'
                  'FL03801'='(FL03801) Cedar Key' 'FL03802'='(FL03802) Chiefland'
                  'FL03803'='(FL03803) Inglis' 'FL03804'='(FL03804) Williston'
                  'FL03840'='(FL03840) Dep Dle: Levy County'
                  'FL03880'='(FL03880) Fgc: Levy County' 'FL03890'='(FL03890) Hp: Levy County'
                  'FL038DB'='(FL038DB) Levy Co Div Beverage'
                  'FL038DL'='(FL038DL) Levy Co Crim Law Enf'
                  'FL038GM'='(FL038GM) Levy Co Game Fwf Comm'
                  'FL038HP'='(FL038HP) Levy Highway Patrol'
                  'FL038MP'='(FL038MP) Levy Co Marine Patrol' 'FL03900'='(FL03900) Liberty'
                  'FL03940'='(FL03940) Dep Dle: Liberty County'
                  'FL03980'='(FL03980) Fgc: Liberty County'
                  'FL03990'='(FL03990) Hp: Liberty County'
                  'FL039DB'='(FL039DB) Liberty Co Div Beverage'
                  'FL039DL'='(FL039DL) Liberty Co Crim Law Enf'
                  'FL039GM'='(FL039GM) Liberty Co Game Fwf Comm'
                  'FL039HP'='(FL039HP) Liberty Highway Patrol'
                  'FL039MP'='(FL039MP) Liberty Co Marine Patrol' 'FL04000'='(FL04000) Madison'
                  'FL04001'='(FL04001) Madison' 'FL04002'='(FL04002) Greenville' 'FL04003'='(FL04003) Lee'
                  'FL04040'='(FL04040) Dep Dle: Madison County'
                  'FL04080'='(FL04080) Fgc: Madison County'
                  'FL04090'='(FL04090) Hp: Madison County'
                  'FL040DB'='(FL040DB) Madison Co Div Beverage'
                  'FL040DL'='(FL040DL) Madison Co Crim Law Enf'
                  'FL040GM'='(FL040GM) Madison Co Game Fwf Comm'
                  'FL040HP'='(FL040HP) Madison Highway Patrol'
                  'FL040MP'='(FL040MP) Madison Co Marine Patrol' 'FL04100'='(FL04100) Manatee'
                  'FL04101'='(FL04101) Anna Maria' 'FL04102'='(FL04102) Bradenton'
                  'FL04103'='(FL04103) Bradenton Beach' 'FL04104'='(FL04104) Holmes Beach'
                  'FL04105'='(FL04105) Longboat Key' 'FL04106'='(FL04106) Palmetto'
                  'FL04140'='(FL04140) Dep Dle: Manatee County'
                  'FL04180'='(FL04180) Fgc: Manatee County'
                  'FL04190'='(FL04190) Hp: Manatee County'
                  'FL041DB'='(FL041DB) Manatee Co Div Beverage'
                  'FL041DL'='(FL041DL) Manatee Co Crim Law Enf'
                  'FL041GM'='(FL041GM) Manatee Co Game Fwf Comm'
                  'FL041HP'='(FL041HP) Manatee Highway Patrol'
                  'FL041MP'='(FL041MP) Manatee Co Marine Patrol' 'FL04200'='(FL04200) Marion'
                  'FL04201'='(FL04201) Ocala' 'FL04202'='(FL04202) Belleview'
                  'FL04203'='(FL04203) Dunnellon' 'FL04204'='(FL04204) Marion Co Fwf Com Ocalia'
                  'FL04240'='(FL04240) Dep Dle: Marion County'
                  'FL04250'='(FL04250) Marion Co Bev Enf Ocalia'
                  'FL04280'='(FL04280) Fgc: Marion County'
                  'FL04290'='(FL04290) Hp: Marion County'
                  'FL042DB'='(FL042DB) Marion Co Div Beverage'
                  'FL042DL'='(FL042DL) Marion Co Crim Law Enf'
                  'FL042GM'='(FL042GM) Marion Co Game Fwf Comm'
                  'FL042HP'='(FL042HP) Marion Highway Patrol'
                  'FL042MP'='(FL042MP) Marion Co Marine Patrol' 'FL04300'='(FL04300) Martin'
                  'FL04301'='(FL04301) Stuart' 'FL04302'='(FL04302) Jupiter Island'
                  'FL04303'='(FL04303) Sewalls Point'
                  'FL04340'='(FL04340) Dep Dle: Martin County'
                  'FL04380'='(FL04380) Fgc: Martin County'
                  'FL04390'='(FL04390) Hp: Martin County'
                  'FL043DB'='(FL043DB) Martin Co Div Beverage'
                  'FL043DL'='(FL043DL) Martin Co Crim Law Enf'
                  'FL043GM'='(FL043GM) Martin Co Game Fwf Comm'
                  'FL043HP'='(FL043HP) Martin Highway Patrol'
                  'FL043MP'='(FL043MP) Martin Co Marine Patrol' 'FL04400'='(FL04400) Monroe'
                  'FL04401'='(FL04401) Key West' 'FL04402'='(FL04402) Key Colony Beach'
                  'FL04403'='(FL04403) Layton' 'FL04404'='(FL04404) Munson Island'
                  'FL04405'='(FL04405) Monroe Co Dle Key West'
                  'FL04440'='(FL04440) Dep Dle: Monroe County'
                  'FL04450'='(FL04450) Monroe Co Bev En Key Wes'
                  'FL04480'='(FL04480) Fgc: Monroe County'
                  'FL04490'='(FL04490) Hp: Monroe County'
                  'FL04491'='(FL04491) Monroe Co Shp Key West'
                  'FL044DB'='(FL044DB) Monroe Co Div Beverage'
                  'FL044DL'='(FL044DL) Monroe Co Crim Law Enf'
                  'FL044GM'='(FL044GM) Monroe Co Game Fwf Comm'
                  'FL044HP'='(FL044HP) Monroe Highway Patrol'
                  'FL044MP'='(FL044MP) Monroe Co Marine Patrol' 'FL04500'='(FL04500) Nassau'
                  'FL04501'='(FL04501) Fernandina Beach' 'FL04502'='(FL04502) Callahan'
                  'FL04503'='(FL04503) Hilliard' 'FL04540'='(FL04540) Dep Dle: Nassau County'
                  'FL04580'='(FL04580) Fgc: Nassau County'
                  'FL04590'='(FL04590) Hp: Nassau County'
                  'FL045DB'='(FL045DB) Nassau Co Div Beverage'
                  'FL045DL'='(FL045DL) Nassau Co Crim Law Enf'
                  'FL045GM'='(FL045GM) Nassau Co Game Fwf Comm'
                  'FL045HP'='(FL045HP) Nassau Highway Patrol'
                  'FL045MP'='(FL045MP) Nassau Co Marine Patrol' 'FL04600'='(FL04600) Okaloosa'
                  'FL04601'='(FL04601) Crestview' 'FL04602'='(FL04602) Fort Walton Beach'
                  'FL04603'='(FL04603) Niceville' 'FL04604'='(FL04604) Valparaiso'
                  'FL04605'='(FL04605) Shalimar' 'FL04606'='(FL04606) Cinco Bayou'
                  'FL04607'='(FL04607) Okaloosa County Air Term'
                  'FL04608'='(FL04608) Laurel Hill' 'FL04609'='(FL04609) Mary Esther'
                  'FL04610'='(FL04610) Okaloosa Co Dle Ft Wtn B'
                  'FL04640'='(FL04640) dep Dle: Okaloosa County'
                  'FL04680'='(FL04680) Fgc: Okaloosa County'
                  'FL04690'='(FL04690) Hp: Okaloosa County'
                  'FL046DB'='(FL046DB) Okaloosa Co Div Beverage'
                  'FL046DL'='(FL046DL) Okaloosa Co Crim Law Enf'
                  'FL046GM'='(FL046GM) Okaloosa Co Game Fwf Com'
                  'FL046HP'='(FL046HP) Okaloosa Highway Patrol'
                  'FL046MP'='(FL046MP) Okaloosa Co Marine Patro' 'FL04700'='(FL04700) Okeechobee'
                  'FL04701'='(FL04701) Okeechobee' 'FL04740'='(FL04740) Dep Dle: Okeechobee Cnty'
                  'FL04780'='(FL04780) Fgc: Okeechobee County'
                  'FL04790'='(FL04790) Hp: Okeechobee County'
                  'FL047DB'='(FL047DB) Okeechobee Co Div Bev'
                  'FL047DL'='(FL047DL) Okeechobee Co Crim Law'
                  'FL047GM'='(FL047GM) Okeechobee Co Game Fwf'
                  'FL047HP'='(FL047HP) Okeechobee Highway Patro'
                  'FL047MP'='(FL047MP) Okeechobee Co Marine Ptl' 'FL04800'='(FL04800) Orange'
                  'FL04801'='(FL04801) Apopka' 'FL04802'='(FL04802) Maitland' 'FL04803'='(FL04803) Ocoee'
                  'FL04804'='(FL04804) Orlando' 'FL04805'='(FL04805) Winter Garden'
                  'FL04806'='(FL04806) Winter Park' 'FL04807'='(FL04807) Eatonville'
                  'FL04808'='(FL04808) Oakland' 'FL04809'='(FL04809) Windermere'
                  'FL04810'='(FL04810) Edgewood' 'FL04811'='(FL04811) Dle: Orange Co, Orlando'
                  'FL04812'='(FL04812) Orange Co Constable Di 1'
                  'FL04813'='(FL04813) orange Co Const Dis 11 A'
                  'FL04814'='(FL04814) university Of Central Fl'
                  'FL04840'='(FL04840) Dep Dle: Orange County'
                  'FL04850'='(FL04850) Orange Co Bev Enf Orland'
                  'FL04870'='(FL04870) Dept Of Ins: Orange Cnty'
                  'FL04880'='(FL04880) Fgc: Orange County'
                  'FL04890'='(FL04890) Hp: Orange County'
                  'FL04891'='(FL04891) Orange Co Shp Tnpk Orlan'
                  'FL048DB'='(FL048DB) Orange Co Div Beverage'
                  'FL048DL'='(FL048DL) Orange Co Crim Law Enf'
                  'FL048GM'='(FL048GM) Orange Co Game Fwf Comm'
                  'FL048HP'='(FL048HP) Orange Highway Patrol'
                  'FL048MP'='(FL048MP) Orange Co Marine Patrol' 'FL04900'='(FL04900) Osceola'
                  'FL04901'='(FL04901) St. Cloud' 'FL04902'='(FL04902) Kissimmee'
                  'FL04940'='(FL04940) Dep Dle: Osceola County'
                  'FL04980'='(FL04980) Fgc: Osceola County'
                  'FL04990'='(FL04990) Hp: Osceola County'
                  'FL049DB'='(FL049DB) Osceola Co Div Beverage'
                  'FL049DL'='(FL049DL) Osceola Co Crim Law Enf'
                  'FL049GM'='(FL049GM) Osceola Co Game Fsf Comm'
                  'FL049HP'='(FL049HP) Osceola Highway Patrol'
                  'FL049MP'='(FL049MP) Osceola Co Marine Patrol' 'FL05000'='(FL05000) Palm Beach'
                  'FL05001'='(FL05001) Belle Glade' 'FL05002'='(FL05002) Boca Raton'
                  'FL05003'='(FL05003) Boynton Beach' 'FL05004'='(FL05004) Delray Beach'
                  'FL05005'='(FL05005) Lake Worth' 'FL05006'='(FL05006) Palm Beach'
                  'FL05007'='(FL05007) Riviera Beach' 'FL05008'='(FL05008) West Palm Beach'
                  'FL05009'='(FL05009) Atlantis' 'FL05010'='(FL05010) Briny Breezes'
                  'FL05011'='(FL05011) Glen Ridge' 'FL05012'='(FL05012) Greenacres City'
                  'FL05013'='(FL05013) Gulf Stream' 'FL05015'='(FL05015) Hypoluxo'
                  'FL05016'='(FL05016) Juno Beach' 'FL05017'='(FL05017) Jupiter'
                  'FL05018'='(FL05018) Jupiter Inlet Colony' 'FL05019'='(FL05019) Lake Park'
                  'FL05020'='(FL05020) Lantana' 'FL05021'='(FL05021) Manalapan'
                  'FL05022'='(FL05022) Mangonia Park' 'FL05023'='(FL05023) North Palm Beach'
                  'FL05024'='(FL05024) Ocean Ridge' 'FL05025'='(FL05025) Pahokee'
                  'FL05026'='(FL05026) Palm Beach Gardens' 'FL05027'='(FL05027) Palm Springs'
                  'FL05028'='(FL05028) Royal Palm Beach' 'FL05029'='(FL05029) South Bay'
                  'FL05030'='(FL05030) South Palm Beach' 'FL05031'='(FL05031) Tequesta'
                  'FL05032'='(FL05032) Cloud Lake' 'FL05033'='(FL05033) Palm Beach Shores'
                  'FL05035'='(FL05035) Palm Beach Co Dle Fld Of'
                  'FL05037'='(FL05037) Florida Atlantic Univers'
                  'FL05038'='(FL05038) Highland Beach'
                  'FL05040'='(FL05040) Dep Dle: Palm Beach Cnty'
                  'FL05041'='(FL05041) Palm Beach Co Dnr Jupite'
                  'FL05042'='(FL05042) Palm Beach Cnty Sch Dist'
                  'FL05050'='(FL05050) Lake Clarke Shores'
                  'FL05051'='(FL05051) Palm Beach Bev Enf Bur'
                  'FL05070'='(FL05070) Dept Of Ins:Palm Bch Cty'
                  'FL05080'='(FL05080) Fgc: Palm Beach County'
                  'FL05090'='(FL05090) Hp: Palm Beach Cnty Tp S'
                  'FL05091'='(FL05091) palm Beach Shp Pahokee'
                  'FL05092'='(FL05092) Hp:Palm Beach Co Lantana' 'FL05095'='(FL05095) Wellington'
                  'FL050DB'='(FL050DB) Palm Beach Co Div Bev'
                  'FL050DL'='(FL050DL) Palm Beach Co Crim Law'
                  'FL050GM'='(FL050GM) Palm Beach Co Game & Fwf'
                  'FL050HP'='(FL050HP) Palm Beach Highway Patro'
                  'FL050MP'='(FL050MP) Palm Beach Co Marine Ptl' 'FL05100'='(FL05100) Pasco'
                  'FL05101'='(FL05101) Dade City' 'FL05102'='(FL05102) New Port Richey'
                  'FL05103'='(FL05103) Zephyrhills' 'FL05104'='(FL05104) Port Richey'
                  'FL05105'='(FL05105) San Antonio' 'FL05106'='(FL05106) St. Leo'
                  'FL05140'='(FL05140) Dep Dle: Pasco County'
                  'FL05180'='(FL05180) Fgc: Pasco County' 'FL05190'='(FL05190) Hp: Pasco County'
                  'FL051DB'='(FL051DB) Pasco Co Div Beverage'
                  'FL051DL'='(FL051DL) Pasco Co Crim Law Enf'
                  'FL051GM'='(FL051GM) Pasco Co Game Fwf Comm'
                  'FL051HP'='(FL051HP) Pasco Highway Patrol'
                  'FL051MP'='(FL051MP) Pasco Co Marine Patrol' 'FL05200'='(FL05200) Pinellas'
                  'FL05201'='(FL05201) Belleair' 'FL05202'='(FL05202) Belleair Bluffs'
                  'FL05203'='(FL05203) Clearwater' 'FL05204'='(FL05204) Dunedin'
                  'FL05205'='(FL05205) Gulfport' 'FL05206'='(FL05206) Indian Rocks Beach'
                  'FL05207'='(FL05207) Kenneth City' 'FL05208'='(FL05208) Largo'
                  'FL05209'='(FL05209) Madeira Beach' 'FL0520S'='(FL0520S) Seminole'
                  'FL05210'='(FL05210) Oldsmar' 'FL05211'='(FL05211) Pinellas Park'
                  'FL05212'='(FL05212) Redington Beaches' 'FL05213'='(FL05213) Safety Harbor'
                  'FL05214'='(FL05214) St. Petersburg' 'FL05215'='(FL05215) St. Pete Beach'
                  'FL05216'='(FL05216) South Pasadena' 'FL05217'='(FL05217) Indian Shores'
                  'FL05218'='(FL05218) Tarpon Springs' 'FL05219'='(FL05219) Treasure Island'
                  'FL05220'='(FL05220) Belleair Beach'
                  'FL05221'='(FL05221) Pinellas Co Dle Clearwat'
                  'FL05225'='(FL05225) Redington Shores'
                  'FL05226'='(FL05226) North Redington Beach'
                  'FL05227'='(FL05227) Pinellas County Schools'
                  'FL05228'='(FL05228) St Pete-Clearwater Int A'
                  'FL05229'='(FL05229) univ Of S fl:St Petersbg'
                  'FL05240'='(FL05240) Dep Dle: Pinellas County'
                  'FL05250'='(FL05250) Pinellas Co Bev Enf Bure'
                  'FL05280'='(FL05280) Fgc: Pinellas County'
                  'FL05290'='(FL05290) Hp: Pinellas County' 'FL05299'='(FL05299) Seminole'
                  'FL052DB'='(FL052DB) Pinellas Co Div Beverage'
                  'FL052DL'='(FL052DL) Pinellas Co Crim Law Enf'
                  'FL052GM'='(FL052GM) Pinellas Co Game Fwf Com'
                  'FL052HP'='(FL052HP) Pinellas Highway Patrol'
                  'FL052MP'='(FL052MP) Pinellas Co Marine Ptl' 'FL05300'='(FL05300) Polk'
                  'FL05301'='(FL05301) Auburndale' 'FL05302'='(FL05302) Bartow'
                  'FL05303'='(FL05303) Davenport' 'FL05304'='(FL05304) Dundee'
                  'FL05305'='(FL05305) Eagle Lake' 'FL05307'='(FL05307) Fort Meade'
                  'FL05308'='(FL05308) Frostproof' 'FL05309'='(FL05309) Haines City'
                  'FL05310'='(FL05310) Lake Alfred' 'FL05311'='(FL05311) Lake Hamilton'
                  'FL05312'='(FL05312) Lakeland' 'FL05313'='(FL05313) Lake Wales'
                  'FL05314'='(FL05314) Mulberry' 'FL05315'='(FL05315) Polk City'
                  'FL05316'='(FL05316) Winter Haven'
                  'FL05317'='(FL05317) Polk Co Fwf Comm Lakelan'
                  'FL05318'='(FL05318) Polk Co Dle Lakeland'
                  'FL05340'='(FL05340) Dep Dle: Polk County'
                  'FL05350'='(FL05350) Polk Co Bev Enf Bureau'
                  'FL05380'='(FL05380) Fgc: Polk County' 'FL05390'='(FL05390) Hp: Polk County'
                  'FL053DB'='(FL053DB) Polk Co Div Beverage'
                  'FL053DL'='(FL053DL) Polk Co Crim Law Enf'
                  'FL053GM'='(FL053GM) Polk Co Game Fwf Comm'
                  'FL053HP'='(FL053HP) Polk Highway Patrol'
                  'FL053MP'='(FL053MP) Polk Co Marine Patrol' 'FL05400'='(FL05400) Putnam'
                  'FL05401'='(FL05401) Palatka' 'FL05402'='(FL05402) Crescent City'
                  'FL05403'='(FL05403) Interlachen' 'FL05404'='(FL05404) Welaka'
                  'FL05405'='(FL05405) Pomona Park' 'FL05440'='(FL05440) Dep Dle: Putnam County'
                  'FL05480'='(FL05480) Fgc: Putnam County'
                  'FL05490'='(FL05490) Hp: Putnam County'
                  'FL054DB'='(FL054DB) Putnam Co Div Beverage'
                  'FL054DL'='(FL054DL) Putnam Co Crim Law Enf'
                  'FL054GM'='(FL054GM) Putnam Co Game Fwf Comm'
                  'FL054HP'='(FL054HP) Putnam Highway Patrol'
                  'FL054MP'='(FL054MP) Putnam Co Marine Patrol' 'FL05500'='(FL05500) St. Johns'
                  'FL05501'='(FL05501) St. Augustine' 'FL05502'='(FL05502) St. Augustine Beach'
                  'FL05503'='(FL05503) Castillo De San Marcos' 'FL05504'='(FL05504) Hastings'
                  'FL05505'='(FL05505) Ponte Vedra Beach'
                  'FL05507'='(FL05507) Fl Sch For Deaf & Blind'
                  'FL05540'='(FL05540) Dep Dle:St. Johns County'
                  'FL05580'='(FL05580) Fgc: St. Johns County'
                  'FL05590'='(FL05590) Hp: St. Johns County'
                  'FL055DB'='(FL055DB) St. Johns Co Div Beverag'
                  'FL055DL'='(FL055DL) St. Johns Co Crim Law En'
                  'FL055GM'='(FL055GM) St. Johns Co Game Fwf Cm'
                  'FL055HP'='(FL055HP) St. Johns Highway Patrol'
                  'FL055MP'='(FL055MP) St. Johns Co Marine Ptrl' 'FL05600'='(FL05600) St. Lucie'
                  'FL05601'='(FL05601) Fort Pierce' 'FL05602'='(FL05602) Port St. Lucie'
                  'FL05640'='(FL05640) Dep Dle:St. Lucie County'
                  'FL05650'='(FL05650) St. Lucie Co Bev Enf Bur'
                  'FL05680'='(FL05680) Fgc: St. Lucie County'
                  'FL05690'='(FL05690) Hp: St. Lucie County'
                  'FL056DB'='(FL056DB) St. Lucie Co Div Beverag'
                  'FL056DL'='(FL056DL) St. Lucie Co Crim Law En'
                  'FL056GM'='(FL056GM) St. Lucie Co Game Fwf Cm'
                  'FL056HP'='(FL056HP) St. Lucie Highway Ptrl'
                  'FL056MP'='(FL056MP) St. Lucie Co Marine Ptrl' 'FL05700'='(FL05700) Santa Rosa'
                  'FL05701'='(FL05701) Milton' 'FL05702'='(FL05702) Gulf Breeze' 'FL05703'='(FL05703) Jay'
                  'FL05740'='(FL05740) Dep Dle: Santa Rosa Cnty'
                  'FL05780'='(FL05780) Fgc: Santa Rosa County'
                  'FL05790'='(FL05790) Hp: Santa Rosa County'
                  'FL057DB'='(FL057DB) Santa Rosa Co Div Bev'
                  'FL057DL'='(FL057DL) Santa Rosa Co Crim Law'
                  'FL057GM'='(FL057GM) Santa Rosa Co Game Fwf'
                  'FL057HP'='(FL057HP) Santa Rosa Highway Patro'
                  'FL057MP'='(FL057MP) Santa Rosa Co Marine Ptl' 'FL05800'='(FL05800) Sarasota'
                  'FL05801'='(FL05801) Sarasota' 'FL05802'='(FL05802) Venice'
                  'FL05803'='(FL05803) North Port' 'FL05804'='(FL05804) Sarasota Co Dle Sarasota'
                  'FL05806'='(FL05806) Sarasota-Bradenton I air'
                  'FL05807'='(FL05807) New College Of Florida'
                  'FL05840'='(FL05840) Dep Dle: Sarasota County'
                  'FL05850'='(FL05850) Sarasota Co Bev Enf Bure'
                  'FL05880'='(FL05880) Fgc: Sarasota County'
                  'FL05890'='(FL05890) Hp: Sarasota County'
                  'FL058DB'='(FL058DB) Sarasota Co Div Beverage'
                  'FL058DL'='(FL058DL) Sarasota Co Crim Law Enf'
                  'FL058GM'='(FL058GM) Sarasota Co Game Fwf Com'
                  'FL058HP'='(FL058HP) Sarasota Highway Patrol'
                  'FL058MP'='(FL058MP) Sarasota Co Marine Ptl' 'FL05900'='(FL05900) Seminole'
                  'FL05901'='(FL05901) Altamonte Springs' 'FL05902'='(FL05902) Casselberry'
                  'FL05903'='(FL05903) Longwood' 'FL05904'='(FL05904) Oviedo' 'FL05905'='(FL05905) Sanford'
                  'FL05906'='(FL05906) Winter Springs' 'FL05907'='(FL05907) Lake Mary'
                  'FL05940'='(FL05940) Dep Dle: Seminole County'
                  'FL05980'='(FL05980) Fgc: Seminole County'
                  'FL05990'='(FL05990) Hp: Seminole County'
                  'FL059DB'='(FL059DB) Seminole Co Div Beverage'
                  'FL059DL'='(FL059DL) Seminole Co Crim Law Enf'
                  'FL059GM'='(FL059GM) Seminole Co Game Fwf Com'
                  'FL059HP'='(FL059HP) Seminole Highway Patrol'
                  'FL059MP'='(FL059MP) Seminole Co Marine Ptl' 'FL06000'='(FL06000) Sumter'
                  'FL06001'='(FL06001) Bushnell' 'FL06002'='(FL06002) Center Hill'
                  'FL06003'='(FL06003) Coleman' 'FL06004'='(FL06004) Webster'
                  'FL06005'='(FL06005) Wildwood' 'FL06040'='(FL06040) Dep Dle: Sumter County'
                  'FL06080'='(FL06080) Fgc: Sumter County'
                  'FL06090'='(FL06090) Hp: Sumter County'
                  'FL060DB'='(FL060DB) Sumter Co Div Beverage'
                  'FL060DL'='(FL060DL) Sumter Co Crim Law Enf'
                  'FL060GM'='(FL060GM) Sumter Co Game Fwf Comm'
                  'FL060HP'='(FL060HP) Sumter Highway Patrol'
                  'FL060MP'='(FL060MP) Sumter Co Marine Patrol' 'FL06100'='(FL06100) Suwannee'
                  'FL06101'='(FL06101) Branford' 'FL06102'='(FL06102) Live Oak'
                  'FL06103'='(FL06103) Suwanee Co Fdle Live Oak'
                  'FL06140'='(FL06140) Dep Dle: Suwannee County'
                  'FL06150'='(FL06150) Suwanne Co Bev Enf Live'
                  'FL06180'='(FL06180) Fgc: Suwannee County'
                  'FL06190'='(FL06190) Hp: Suwannee County'
                  'FL061DB'='(FL061DB) Suwannee Co Div Beverage'
                  'FL061DL'='(FL061DL) Suwannee Co Crim Law Enf'
                  'FL061GM'='(FL061GM) Suwannee Co Game Fwf Com'
                  'FL061HP'='(FL061HP) Suwannee Highway Patrol'
                  'FL061MP'='(FL061MP) Suwannee Co Marine Patro' 'FL06200'='(FL06200) Taylor'
                  'FL06201'='(FL06201) Perry' 'FL06240'='(FL06240) Dep Dle: Taylor County'
                  'FL06280'='(FL06280) Fgc: Taylor County'
                  'FL06290'='(FL06290) Hp: Taylor County'
                  'FL062DB'='(FL062DB) Taylor Co Div Beverage'
                  'FL062DL'='(FL062DL) Taylor Co Crim Law Enf'
                  'FL062GM'='(FL062GM) Taylor Co Game Fwf Comm'
                  'FL062HP'='(FL062HP) Taylor Highway Patrol'
                  'FL062MP'='(FL062MP) Taylor Co Marine Patrol' 'FL06300'='(FL06300) Union'
                  'FL06340'='(FL06340) Dep Dle: Union County'
                  'FL06380'='(FL06380) Fgc: Union County' 'FL06390'='(FL06390) Hp: Union County'
                  'FL063DB'='(FL063DB) Union Co Div Beverage'
                  'FL063DL'='(FL063DL) Union Co Crim Law Enf'
                  'FL063GM'='(FL063GM) Union Co Game Fwf Comm'
                  'FL063HP'='(FL063HP) Union Highway Patrol' 'FL06400'='(FL06400) Volusia'
                  'FL06401'='(FL06401) Daytona Beach' 'FL06402'='(FL06402) Deland'
                  'FL06403'='(FL06403) New Smyrna Beach' 'FL06404'='(FL06404) Ormond Beach'
                  'FL06405'='(FL06405) Daytona Beach Shores' 'FL06406'='(FL06406) Edgewater'
                  'FL06407'='(FL06407) Holly Hill' 'FL06408'='(FL06408) Lake Helen'
                  'FL06409'='(FL06409) Oak Hill' 'FL06410'='(FL06410) Orange City'
                  'FL06411'='(FL06411) Pierson' 'FL06412'='(FL06412) Port Orange'
                  'FL06413'='(FL06413) South Daytona' 'FL06414'='(FL06414) Ponce Inlet'
                  'FL06415'='(FL06415) Daytona Beach Int Airpor'
                  'FL06416'='(FL06416) Volusia Co Dle S daytona'
                  'FL06417'='(FL06417) Volusia Cnty Beach Mgmt'
                  'FL06440'='(FL06440) Dep Dle: Volusia County'
                  'FL06450'='(FL06450) Volusia Co Beve Daytona'
                  'FL06480'='(FL06480) Fgc: Volusia County'
                  'FL06490'='(FL06490) Hp: Volusia County'
                  'FL06491'='(FL06491) Volusia Co Fhp Daytona B'
                  'FL064DB'='(FL064DB) Volusia Co Div Beverage'
                  'FL064DL'='(FL064DL) Volusia Co Crim Law Enf'
                  'FL064GM'='(FL064GM) Volusia Co Game Fwf Comm'
                  'FL064HP'='(FL064HP) Volusia Highway Patrol'
                  'FL064MP'='(FL064MP) Volusia Co Marine Patrol' 'FL06500'='(FL06500) Wakulla'
                  'FL06502'='(FL06502) Sopchoppy' 'FL06540'='(FL06540) Dep Dle: Wakulla County'
                  'FL06580'='(FL06580) Fgc: Wakulla County'
                  'FL06590'='(FL06590) Hp: Wakulla County'
                  'FL065DB'='(FL065DB) wakulla Co Div Beverage'
                  'FL065DL'='(FL065DL) Wakulla Co Crim Law Enf'
                  'FL065GM'='(FL065GM) Wakulla Co Game Fwf Comm'
                  'FL065HP'='(FL065HP) Wakulla Highway Patrol'
                  'FL065MP'='(FL065MP) Wakulla Co Marine Patrol' 'FL06600'='(FL06600) Walton'
                  'FL06601'='(FL06601) De Funiak Springs' 'FL06602'='(FL06602) Paxton'
                  'FL06640'='(FL06640) Dep Dle: Walton County'
                  'FL06680'='(FL06680) Fgc: Walton County'
                  'FL06690'='(FL06690) Hp: Walton County'
                  'FL066DB'='(FL066DB) Walton Co Div Beverage'
                  'FL066DL'='(FL066DL) Walton Co Crim Law Enf'
                  'FL066GM'='(FL066GM) Walton Co Game Fwf Comm'
                  'FL066HP'='(FL066HP) Walton Highway Patrol'
                  'FL066MP'='(FL066MP) Walton Co Marine Patrol' 'FL06700'='(FL06700) Washington'
                  'FL06701'='(FL06701) Chipley' 'FL06702'='(FL06702) Vernon'
                  'FL06740'='(FL06740) Dep Dle: Washington Cnty'
                  'FL06780'='(FL06780) Fgc: Washington County'
                  'FL06790'='(FL06790) Hp: Washington County'
                  'FL067DB'='(FL067DB) Washington Co Div Bev'
                  'FL067DL'='(FL067DL) Washington Co Crim Law'
                  'FL067GM'='(FL067GM) Washington Co Game Fwf'
                  'FL067HP'='(FL067HP) Washington Highway Patro'
                  'FL067MP'='(FL067MP) Washington Co Marine Ptl'
                  'FLFHP00'='(FLFHP00) Florida Hp, Headquarters' 'GA00100'='(GA00100) Appling'
                  'GA00101'='(GA00101) Baxley' 'GA00102'='(GA00102) Surrency'
                  'GA00200'='(GA00200) Atkinson' 'GA00201'='(GA00201) Pearson'
                  'GA00202'='(GA00202) Willacoochee' 'GA00300'='(GA00300) Bacon' 'GA00301'='(GA00301) Alma'
                  'GA00400'='(GA00400) Baker' 'GA00401'='(GA00401) Newton' 'GA00500'='(GA00500) Baldwin'
                  'GA00501'='(GA00501) Milledgeville'
                  'GA00502'='(GA00502) Central State Hospital'
                  'GA00503'='(GA00503) Ga College & State Unive' 'GA00600'='(GA00600) Banks'
                  'GA00700'='(GA00700) Barrow' 'GA00701'='(GA00701) Winder' 'GA00702'='(GA00702) Auburn'
                  'GA00703'='(GA00703) Statham' 'GA00800'='(GA00800) Bartow'
                  'GA00801'='(GA00801) Cartersville' 'GA00802'='(GA00802) Adairsville'
                  'GA00803'='(GA00803) Kingston' 'GA00805'='(GA00805) White' 'GA00806'='(GA00806) Emerson'
                  'GA00807'='(GA00807) Euharlee' 'GA00900'='(GA00900) Ben Hill'
                  'GA00901'='(GA00901) Fitzgerald' 'GA01000'='(GA01000) Berrien'
                  'GA01001'='(GA01001) Nashville' 'GA01002'='(GA01002) Alapaha'
                  'GA01003'='(GA01003) Ray City' 'GA01004'='(GA01004) Enigma' 'GA01100'='(GA01100) Bibb'
                  'GA01101'='(GA01101) Macon' 'GA01102'='(GA01102) Ga Forestry Commission'
                  'GA01103'='(GA01103) Payne City' 'GA01104'='(GA01104) Bibb Co Board Of Educat'
                  'GA01109'='(GA01109) Mercer University' 'GA01111'='(GA01111) Wesleyan College'
                  'GA01200'='(GA01200) Bleckley' 'GA01201'='(GA01201) Cochran'
                  'GA01202'='(GA01202) Middle Georgia College' 'GA01300'='(GA01300) Brantley'
                  'GA01301'='(GA01301) Nahunta' 'GA01302'='(GA01302) Hoboken' 'GA01400'='(GA01400) Brooks'
                  'GA01401'='(GA01401) Quitman' 'GA01402'='(GA01402) Morven' 'GA01500'='(GA01500) Bryan'
                  'GA01501'='(GA01501) Pembroke' 'GA01502'='(GA01502) Richmond Hill'
                  'GA01600'='(GA01600) Bulloch' 'GA01601'='(GA01601) Statesboro'
                  'GA01602'='(GA01602) Brooklet' 'GA01603'='(GA01603) Portal'
                  'GA01604'='(GA01604) Ga Southern University' 'GA01605'='(GA01605) Register'
                  'GA01700'='(GA01700) Burke' 'GA01701'='(GA01701) Waynesboro'
                  'GA01702'='(GA01702) Midville' 'GA01703'='(GA01703) Sardis' 'GA01800'='(GA01800) Butts'
                  'GA01801'='(GA01801) Jackson' 'GA01802'='(GA01802) Jenkinsburg'
                  'GA01803'='(GA01803) Flovilla' 'GA01900'='(GA01900) Calhoun'
                  'GA01901'='(GA01901) Arlington' 'GA01902'='(GA01902) Edison' 'GA01903'='(GA01903) Leary'
                  'GA02000'='(GA02000) Camden' 'GA02001'='(GA02001) Kingsland'
                  'GA02002'='(GA02002) St. Marys' 'GA02004'='(GA02004) Woodbine'
                  'GA02100'='(GA02100) Candler' 'GA02101'='(GA02101) Metter'
                  'GA02102'='(GA02102) Dnr: Metter' 'GA02200'='(GA02200) Carroll'
                  'GA02201'='(GA02201) Carrollton' 'GA02202'='(GA02202) Villa Rica'
                  'GA02203'='(GA02203) Bowdon' 'GA02204'='(GA02204) Temple'
                  'GA02205'='(GA02205) Whitesburg' 'GA02206'='(GA02206) Univ Of West Georgia'
                  'GA02207'='(GA02207) Mount Zion' 'GA02300'='(GA02300) Catoosa'
                  'GA02301'='(GA02301) Fort Oglethorpe' 'GA02302'='(GA02302) Ringgold'
                  'GA02400'='(GA02400) Charlton' 'GA02401'='(GA02401) Folkston'
                  'GA02402'='(GA02402) Homeland' 'GA02500'='(GA02500) Chatham'
                  'GA02501'='(GA02501) Chatham County Pol Dept' 'GA02502'='(GA02502) Garden City'
                  'GA02503'='(GA02503) Savannah-Chatham Metro' 'GA02504'='(GA02504) Pooler'
                  'GA02505'='(GA02505) Port Wentworth' 'GA02506'='(GA02506) Tybee Island'
                  'GA02507'='(GA02507) Thunderbolt'
                  'GA02508'='(GA02508) Ports Authority Savannah'
                  'GA02509'='(GA02509) Bloomingdale'
                  'GA02510'='(GA02510) Savannah State Universit'
                  'GA02511'='(GA02511) Armstrong Atlantic St Un'
                  'GA02512'='(GA02512) Ga Port Auth,Spec Inv Un'
                  'GA02516'='(GA02516) Chatham Cty Board Of Ed'
                  'GA02518'='(GA02518) Chatham-Savannah Narc Tm'
                  'GA02519'='(GA02519) Ga Regional Hosp Facilit'
                  'GA02600'='(GA02600) Chattahoochee' 'GA02601'='(GA02601) Cusseta'
                  'GA02700'='(GA02700) Chattooga' 'GA02701'='(GA02701) Summerville'
                  'GA02702'='(GA02702) Trion' 'GA02703'='(GA02703) Lyerly' 'GA02704'='(GA02704) Menlo'
                  'GA02800'='(GA02800) Cherokee' 'GA02801'='(GA02801) Canton'
                  'GA02802'='(GA02802) Ball Ground' 'GA02803'='(GA02803) Holly Springs'
                  'GA02804'='(GA02804) Waleska' 'GA02805'='(GA02805) Woodstock'
                  'GA02806'='(GA02806) Nelson' 'GA02807'='(GA02807) Cherokee Cty Board Of Ed'
                  'GA02808'='(GA02808) Reinhardt College'
                  'GA02809'='(GA02809) Cherokee County Marshal'
                  'GA02811'='(GA02811) Reinhardt College' 'GA02900'='(GA02900) Clarke'
                  'GA02901'='(GA02901) Athens-Clarke County'
                  'GA02902'='(GA02902) University Of Georgia'
                  'GA02903'='(GA02903) Clarke Police Department'
                  'GA02904'='(GA02904) Winterville' 'GA03000'='(GA03000) Clay'
                  'GA03001'='(GA03001) Fort Gaines' 'GA03100'='(GA03100) Clayton'
                  'GA03101'='(GA03101) Clayton County Pol Dept' 'GA03102'='(GA03102) Forest Park'
                  'GA03103'='(GA03103) Morrow' 'GA03104'='(GA03104) Jonesboro'
                  'GA03105'='(GA03105) Riverdale' 'GA03106'='(GA03106) Lake City'
                  'GA03107'='(GA03107) Mountain View'
                  'GA03108'='(GA03108) Clayton College & St Uni'
                  'GA03109'='(GA03109) Clayton Cty Narcotics Un' 'GA03200'='(GA03200) Clinch'
                  'GA03201'='(GA03201) Homerville' 'GA03300'='(GA03300) Cobb' 'GA03301'='(GA03301) Austell'
                  'GA03302'='(GA03302) Cobb County Police Dept' 'GA03303'='(GA03303) Marietta'
                  'GA03304'='(GA03304) Smyrna' 'GA03305'='(GA03305) Acworth' 'GA03306'='(GA03306) Kennesaw'
                  'GA03308'='(GA03308) Powder Springs'
                  'GA03310'='(GA03310) Div Of Youth Services'
                  'GA03311'='(GA03311) Southern Polytechnic S u'
                  'GA03312'='(GA03312) Kennesaw State Universit'
                  'GA03313'='(GA03313) Cobb Cnty Board Of Educ'
                  'GA03314'='(GA03314) Cobb County Park Rangers' 'GA03400'='(GA03400) Coffee'
                  'GA03401'='(GA03401) Douglas' 'GA03403'='(GA03403) Broxton'
                  'GA03404'='(GA03404) Nicholls' 'GA03405'='(GA03405) South Georgia College'
                  'GA03500'='(GA03500) Colquitt' 'GA03501'='(GA03501) Moultrie'
                  'GA03502'='(GA03502) Berlin' 'GA03503'='(GA03503) Doerun'
                  'GA03504'='(GA03504) Norman Park' 'GA03505'='(GA03505) Ellenton'
                  'GA03600'='(GA03600) Columbia' 'GA03601'='(GA03601) Grovetown'
                  'GA03602'='(GA03602) Harlem' 'GA03700'='(GA03700) Cook' 'GA03701'='(GA03701) Adel'
                  'GA03702'='(GA03702) Lenox' 'GA03703'='(GA03703) Sparks' 'GA03800'='(GA03800) Coweta'
                  'GA03801'='(GA03801) Newnan' 'GA03802'='(GA03802) Grantville'
                  'GA03803'='(GA03803) Senoia' 'GA03900'='(GA03900) Crawford' 'GA03901'='(GA03901) Roberta'
                  'GA04000'='(GA04000) Crisp' 'GA04001'='(GA04001) Cordele' 'GA04002'='(GA04002) Arabi'
                  'GA04100'='(GA04100) Dade' 'GA04101'='(GA04101) Trenton' 'GA04200'='(GA04200) Dawson'
                  'GA04201'='(GA04201) Dawsonville' 'GA04300'='(GA04300) Decatur'
                  'GA04301'='(GA04301) Bainbridge' 'GA04302'='(GA04302) Attapulgus'
                  'GA04303'='(GA04303) Climax' 'GA04304'='(GA04304) Decatur County Schools'
                  'GA04400'='(GA04400) Dekalb' 'GA04401'='(GA04401) Decatur'
                  'GA04402'='(GA04402) Dekalb County Police Dep'
                  'GA04403'='(GA04403) Avondale Estates' 'GA04404'='(GA04404) Chamblee'
                  'GA04405'='(GA04405) Clarkston' 'GA04406'='(GA04406) Doraville'
                  'GA04407'='(GA04407) Lithonia' 'GA04408'='(GA04408) Pine Lake'
                  'GA04409'='(GA04409) Stone Mountain' 'GA04410'='(GA04410) North Atlanta'
                  'GA04411'='(GA04411) Stone Mountain Park'
                  'GA04413'='(GA04413) Agnes Scott College'
                  'GA04414'='(GA04414) Emory University'
                  'GA04416'='(GA04416) Georgia Perimeter Colleg'
                  'GA04451'='(GA04451) Dekalb Co School System' 'GA04500'='(GA04500) Dodge'
                  'GA04501'='(GA04501) Eastman' 'GA04502'='(GA04502) Chauncey'
                  'GA04503'='(GA04503) Chester' 'GA04504'='(GA04504) Rhine' 'GA04600'='(GA04600) Dooly'
                  'GA04601'='(GA04601) Vienna' 'GA04602'='(GA04602) Unadilla'
                  'GA04603'='(GA04603) Pinehurst' 'GA04604'='(GA04604) Byromville'
                  'GA04700'='(GA04700) Dougherty' 'GA04701'='(GA04701) Albany'
                  'GA04702'='(GA04702) Dougherty County Pol Dpt'
                  'GA04703'='(GA04703) Albany State University' 'GA04704'='(GA04704) Dnr: Albany'
                  'GA04705'='(GA04705) Dougherty Co Board Of Ed'
                  'GA04706'='(GA04706) Albany-Dougherty Met D s' 'GA04800'='(GA04800) Douglas'
                  'GA04801'='(GA04801) Douglasville' 'GA04900'='(GA04900) Early'
                  'GA04901'='(GA04901) Blakely' 'GA04902'='(GA04902) Damascus' 'GA05000'='(GA05000) Echols'
                  'GA05100'='(GA05100) Effingham' 'GA05102'='(GA05102) Rincon'
                  'GA05103'='(GA05103) Springfield' 'GA05200'='(GA05200) Elbert'
                  'GA05201'='(GA05201) Elberton' 'GA05202'='(GA05202) Bowman' 'GA05300'='(GA05300) Emanuel'
                  'GA05301'='(GA05301) Swainsboro' 'GA05303'='(GA05303) Twin City'
                  'GA05304'='(GA05304) Garfield' 'GA05305'='(GA05305) Stillmore'
                  'GA05400'='(GA05400) Evans' 'GA05401'='(GA05401) Claxton' 'GA05402'='(GA05402) Hagan'
                  'GA05500'='(GA05500) Fannin' 'GA05501'='(GA05501) Mccaysville'
                  'GA05502'='(GA05502) Blue Ridge' 'GA05503'='(GA05503) Morganton'
                  'GA05600'='(GA05600) Fayette' 'GA05601'='(GA05601) Fayetteville'
                  'GA05602'='(GA05602) Peachtree City' 'GA05603'='(GA05603) Tyrone'
                  'GA05604'='(GA05604) Fayette County Marshal' 'GA05700'='(GA05700) Floyd'
                  'GA05701'='(GA05701) Floyd County Police Dept' 'GA05702'='(GA05702) Rome'
                  'GA05703'='(GA05703) Cave Spring' 'GA05705'='(GA05705) Berry College'
                  'GA05706'='(GA05706) Berry College' 'GA05800'='(GA05800) Forsyth'
                  'GA05801'='(GA05801) Cumming' 'GA05802'='(GA05802) Marshalls Off Forsythe'
                  'GA05803'='(GA05803) Forsyth Co Fire Inves Un' 'GA05900'='(GA05900) Franklin'
                  'GA05901'='(GA05901) Carnesville' 'GA05902'='(GA05902) Lavonia'
                  'GA05903'='(GA05903) Royston' 'GA05904'='(GA05904) Canon'
                  'GA05905'='(GA05905) Franklin Springs' 'GA06000'='(GA06000) Fulton'
                  'GA06001'='(GA06001) College Park' 'GA06002'='(GA06002) East Point'
                  'GA06003'='(GA06003) Hapeville' 'GA06004'='(GA06004) Alpharetta'
                  'GA06005'='(GA06005) Roswell' 'GA06006'='(GA06006) Union City'
                  'GA06007'='(GA06007) Fairburn' 'GA06008'='(GA06008) Palmetto'
                  'GA06009'='(GA06009) Georgia State University'
                  'GA06010'='(GA06010) Georgia Institute Of Tec'
                  'GA06013'='(GA06013) Fulton County Police Dpt'
                  'GA06016'='(GA06016) Georgia Drugs And Narcot'
                  'GA06018'='(GA06018) Ga Dp Of Revenue Atlanta'
                  'GA06019'='(GA06019) Capitol Police'
                  'GA06020'='(GA06020) Ga Dept Trans Off Invest'
                  'GA06021'='(GA06021) Metro Atlanta Rapid Tr A'
                  'GA06024'='(GA06024) hrtsfld-Jcksn Atl Int Ap'
                  'GA06026'='(GA06026) Ga Pub Ser Com Hapeville'
                  'GA06027'='(GA06027) Fulton County Marshal'
                  'GA06028'='(GA06028) Dnr: Headquarters'
                  'GA06030'='(GA06030) Clark Atlanta University'
                  'GA06031'='(GA06031) Dp Pub Sa Dui Taskforce'
                  'GA06032'='(GA06032) Dept Of Corrctns,Int Aff'
                  'GA06033'='(GA06033) Dept Of Agriculture' 'GA06036'='(GA06036) Spelman College'
                  'GA06037'='(GA06037) Fulton County Sch System'
                  'GA06038'='(GA06038) Georgia World Congress'
                  'GA06041'='(GA06041) Ga Dpt Rev Al Tob Tax Un'
                  'GA06044'='(GA06044) Morehouse College'
                  'GA06045'='(GA06045) Morris-Brown College' 'GA06100'='(GA06100) Gilmer'
                  'GA06101'='(GA06101) Ellijay' 'GA06102'='(GA06102) Gilmer County Police Dpt'
                  'GA06103'='(GA06103) East Ellijay' 'GA06200'='(GA06200) Glascock'
                  'GA06201'='(GA06201) Gibson' 'GA06300'='(GA06300) Glynn' 'GA06301'='(GA06301) Brunswick'
                  'GA06302'='(GA06302) Glynn County Police Dept'
                  'GA06303'='(GA06303) Coastal Georgia Comm Col'
                  'GA06304'='(GA06304) Dnr: Le Dis Off Brunswic' 'GA06400'='(GA06400) Gordon'
                  'GA06401'='(GA06401) Calhoun' 'GA06402'='(GA06402) Fairmount'
                  'GA06403'='(GA06403) Dnr: Calhoun' 'GA06500'='(GA06500) Grady'
                  'GA06501'='(GA06501) Cairo' 'GA06502'='(GA06502) Whigham'
                  'GA06503'='(GA06503) Grady County Drug Squad' 'GA06600'='(GA06600) Greene'
                  'GA06601'='(GA06601) Greensboro' 'GA06602'='(GA06602) Union Point'
                  'GA06603'='(GA06603) Greene County Police Dpt' 'GA06604'='(GA06604) Siloam'
                  'GA06605'='(GA06605) White Plains' 'GA06700'='(GA06700) Gwinnett'
                  'GA06701'='(GA06701) Buford' 'GA06702'='(GA06702) Gwinnett County Pol Dept'
                  'GA06703'='(GA06703) Lawrenceville' 'GA06704'='(GA06704) Dacula'
                  'GA06705'='(GA06705) Duluth' 'GA06706'='(GA06706) Lilburn' 'GA06707'='(GA06707) Norcross'
                  'GA06708'='(GA06708) Snellville' 'GA06709'='(GA06709) Suwanee'
                  'GA06710'='(GA06710) Gwinnett Co Pub Schools'
                  'GA06712'='(GA06712) Gwinnett County Marshal' 'GA06800'='(GA06800) Habersham'
                  'GA06801'='(GA06801) Cornelia' 'GA06802'='(GA06802) Clarkesville'
                  'GA06803'='(GA06803) Demorest' 'GA06804'='(GA06804) Mount Airy'
                  'GA06805'='(GA06805) Baldwin' 'GA06808'='(GA06808) Piedmont College'
                  'GA06900'='(GA06900) Hall' 'GA06901'='(GA06901) Gainesville'
                  'GA06903'='(GA06903) Flowery Branch' 'GA06904'='(GA06904) Oakwood'
                  'GA06905'='(GA06905) Lake Lanier Islands'
                  'GA06906'='(GA06906) Hall County Marshal'
                  'GA06907'='(GA06907) Dnr: Gainesville' 'GA07000'='(GA07000) Hancock'
                  'GA07001'='(GA07001) Sparta' 'GA07002'='(GA07002) Hancock Cnty Police Dept'
                  'GA07100'='(GA07100) Haralson' 'GA07101'='(GA07101) Bremen'
                  'GA07102'='(GA07102) Tallapoosa' 'GA07103'='(GA07103) Buchanan'
                  'GA07200'='(GA07200) Harris' 'GA07201'='(GA07201) Pine Mountain'
                  'GA07202'='(GA07202) Waverly Hall' 'GA07203'='(GA07203) Shiloh'
                  'GA07204'='(GA07204) Hamilton' 'GA07300'='(GA07300) Hart' 'GA07301'='(GA07301) Hartwell'
                  'GA07400'='(GA07400) Heard' 'GA07401'='(GA07401) Franklin' 'GA07402'='(GA07402) Ephesus'
                  'GA07500'='(GA07500) Henry' 'GA07501'='(GA07501) Mcdonough'
                  'GA07502'='(GA07502) Stockbridge' 'GA07503'='(GA07503) Hampton'
                  'GA07504'='(GA07504) Locust Grove'
                  'GA07505'='(GA07505) Henry County Police Dept' 'GA07600'='(GA07600) Houston'
                  'GA07601'='(GA07601) Perry' 'GA07602'='(GA07602) Warner Robins'
                  'GA07603'='(GA07603) Centerville' 'GA07700'='(GA07700) Irwin'
                  'GA07701'='(GA07701) Ocilla' 'GA07800'='(GA07800) Jackson' 'GA07801'='(GA07801) Commerce'
                  'GA07802'='(GA07802) Jefferson' 'GA07803'='(GA07803) Maysville'
                  'GA07804'='(GA07804) Arcade' 'GA07805'='(GA07805) Hoschton'
                  'GA07806'='(GA07806) Braselton' 'GA07809'='(GA07809) Pendergrass'
                  'GA07900'='(GA07900) Jasper' 'GA07901'='(GA07901) Monticello'
                  'GA08000'='(GA08000) Jeff Davis' 'GA08001'='(GA08001) Hazlehurst'
                  'GA08100'='(GA08100) Jefferson' 'GA08101'='(GA08101) Louisville'
                  'GA08102'='(GA08102) Wadley' 'GA08103'='(GA08103) Wrens' 'GA08104'='(GA08104) Bartow'
                  'GA08105'='(GA08105) Stapleton' 'GA08200'='(GA08200) Jenkins'
                  'GA08201'='(GA08201) Millen' 'GA08300'='(GA08300) Johnson'
                  'GA08301'='(GA08301) Wrightsville' 'GA08302'='(GA08302) Adrian'
                  'GA08303'='(GA08303) Kite' 'GA08400'='(GA08400) Jones' 'GA08401'='(GA08401) Gray'
                  'GA08500'='(GA08500) Lamar' 'GA08501'='(GA08501) Barnesville'
                  'GA08502'='(GA08502) Milner' 'GA08503'='(GA08503) Gordon College'
                  'GA08600'='(GA08600) Lanier' 'GA08601'='(GA08601) Lakeland' 'GA08700'='(GA08700) Laurens'
                  'GA08701'='(GA08701) Dublin' 'GA08702'='(GA08702) East Dublin' 'GA08800'='(GA08800) Lee'
                  'GA08801'='(GA08801) Leesburg' 'GA08802'='(GA08802) Smithville'
                  'GA08900'='(GA08900) Liberty' 'GA08901'='(GA08901) Hinesville'
                  'GA08902'='(GA08902) Midway' 'GA09000'='(GA09000) Lincoln'
                  'GA09001'='(GA09001) Lincolnton' 'GA09100'='(GA09100) Long'
                  'GA09101'='(GA09101) Ludowici' 'GA09200'='(GA09200) Lowndes'
                  'GA09201'='(GA09201) Valdosta' 'GA09202'='(GA09202) Hahira'
                  'GA09203'='(GA09203) Lake Park' 'GA09204'='(GA09204) Remerton'
                  'GA09205'='(GA09205) Valdosta State Universit' 'GA09300'='(GA09300) Lumpkin'
                  'GA09301'='(GA09301) Dahlonega' 'GA09302'='(GA09302) North Georgia College'
                  'GA09400'='(GA09400) Mcduffie' 'GA09401'='(GA09401) Thomson'
                  'GA09402'='(GA09402) Dnr: Thomson' 'GA09500'='(GA09500) Mcintosh'
                  'GA09501'='(GA09501) Darien' 'GA09600'='(GA09600) Macon' 'GA09601'='(GA09601) Montezuma'
                  'GA09602'='(GA09602) Ideal' 'GA09603'='(GA09603) Marshallville'
                  'GA09604'='(GA09604) Oglethorpe' 'GA09605'='(GA09605) Macon County Schools'
                  'GA09700'='(GA09700) Madison' 'GA09701'='(GA09701) Colbert' 'GA09702'='(GA09702) Comer'
                  'GA09703'='(GA09703) Danielsville' 'GA09704'='(GA09704) Ila' 'GA09800'='(GA09800) Marion'
                  'GA09801'='(GA09801) Buena Vista' 'GA09900'='(GA09900) Meriwether'
                  'GA09901'='(GA09901) Manchester' 'GA09902'='(GA09902) Greenville'
                  'GA09903'='(GA09903) Luthersville' 'GA09904'='(GA09904) Woodbury'
                  'GA09905'='(GA09905) Warm Springs'
                  'GA09907'='(GA09907) Dnr: Le Dis Off Manchest' 'GA10000'='(GA10000) Miller'
                  'GA10001'='(GA10001) Colquitt' 'GA10100'='(GA10100) Mitchell'
                  'GA10101'='(GA10101) Camilla' 'GA10103'='(GA10103) Pelham'
                  'GA10104'='(GA10104) Sale City' 'GA10105'='(GA10105) Mitchell County Drug Uni'
                  'GA10200'='(GA10200) Monroe' 'GA10201'='(GA10201) Forsyth' 'GA10202'='(GA10202) Culloden'
                  'GA10203'='(GA10203) Ga Pub Safety Train Ctr'
                  'GA10204'='(GA10204) Dnr: Forsyth' 'GA10205'='(GA10205) Dnr: Social Circle'
                  'GA10300'='(GA10300) Montgomery' 'GA10301'='(GA10301) Mount Vernon'
                  'GA10302'='(GA10302) Uvalda' 'GA10303'='(GA10303) Ailey' 'GA10400'='(GA10400) Morgan'
                  'GA10401'='(GA10401) Madison' 'GA10402'='(GA10402) Rutledge' 'GA10500'='(GA10500) Murray'
                  'GA10501'='(GA10501) Chatsworth' 'GA10502'='(GA10502) Eton'
                  'GA10600'='(GA10600) Muscogee' 'GA10601'='(GA10601) Columbus'
                  'GA10603'='(GA10603) Bibb City' 'GA10604'='(GA10604) Columbus State Universit'
                  'GA10605'='(GA10605) Muscogee City Marshal' 'GA10700'='(GA10700) Newton'
                  'GA10701'='(GA10701) Covington' 'GA10702'='(GA10702) Oxford'
                  'GA10703'='(GA10703) Porterdale' 'GA10704'='(GA10704) Mansfield'
                  'GA10800'='(GA10800) Oconee' 'GA10801'='(GA10801) Watkinsville'
                  'GA10802'='(GA10802) Bogart' 'GA10900'='(GA10900) Oglethorpe'
                  'GA11000'='(GA11000) Paulding' 'GA11001'='(GA11001) Dallas' 'GA11002'='(GA11002) Hiram'
                  'GA11004'='(GA11004) Braswell' 'GA11100'='(GA11100) Peach'
                  'GA11101'='(GA11101) Fort Valley' 'GA11102'='(GA11102) Byron'
                  'GA11103'='(GA11103) Fort Valley State Univer' 'GA11200'='(GA11200) Pickens'
                  'GA11201'='(GA11201) Jasper' 'GA11202'='(GA11202) Pickens County Pol Dept'
                  'GA11203'='(GA11203) Pickens Co Board Of Educ' 'GA11300'='(GA11300) Pierce'
                  'GA11301'='(GA11301) Blackshear' 'GA11302'='(GA11302) Patterson'
                  'GA11400'='(GA11400) Pike' 'GA11401'='(GA11401) Zebulon' 'GA11402'='(GA11402) Concord'
                  'GA11403'='(GA11403) Molena' 'GA11500'='(GA11500) Polk' 'GA11501'='(GA11501) Cedartown'
                  'GA11502'='(GA11502) Rockmart' 'GA11503'='(GA11503) Polk County Police Dept'
                  'GA11504'='(GA11504) Aragon' 'GA11600'='(GA11600) Pulaski'
                  'GA11601'='(GA11601) Hawkinsville' 'GA11700'='(GA11700) Putnam'
                  'GA11701'='(GA11701) Eatonton' 'GA11800'='(GA11800) Quitman'
                  'GA11801'='(GA11801) Georgetown' 'GA11900'='(GA11900) Rabun'
                  'GA11901'='(GA11901) Clayton' 'GA11902'='(GA11902) Mountain City'
                  'GA11903'='(GA11903) Tallulah Falls' 'GA11904'='(GA11904) Dillard'
                  'GA11905'='(GA11905) Sky Valley' 'GA12000'='(GA12000) Randolph'
                  'GA12001'='(GA12001) Cuthbert' 'GA12002'='(GA12002) Shellman'
                  'GA12100'='(GA12100) Augusta-Richmond' 'GA12101'='(GA12101) Augusta'
                  'GA12102'='(GA12102) Richmond Co. Police Dept' 'GA12103'='(GA12103) Hephzibah'
                  'GA12104'='(GA12104) Medical College Of Georg'
                  'GA12105'='(GA12105) Augusta State University'
                  'GA12106'='(GA12106) Augusta Board Of Educat'
                  'GA12107'='(GA12107) Richmond County Marshal' 'GA12108'='(GA12108) Blythe'
                  'GA12200'='(GA12200) Rockdale' 'GA12201'='(GA12201) Conyers' 'GA12300'='(GA12300) Schley'
                  'GA12301'='(GA12301) Ellaville' 'GA12400'='(GA12400) Screven'
                  'GA12401'='(GA12401) Sylvania' 'GA12402'='(GA12402) Hilltonia'
                  'GA12403'='(GA12403) Newington' 'GA12404'='(GA12404) Oliver'
                  'GA12500'='(GA12500) Seminole' 'GA12501'='(GA12501) Donalsonville'
                  'GA12600'='(GA12600) Spalding' 'GA12601'='(GA12601) Griffin'
                  'GA12700'='(GA12700) Stephens' 'GA12701'='(GA12701) Toccoa' 'GA12800'='(GA12800) Stewart'
                  'GA12801'='(GA12801) Lumpkin' 'GA12802'='(GA12802) Richland' 'GA12803'='(GA12803) Omaha'
                  'GA12900'='(GA12900) Sumter' 'GA12901'='(GA12901) Americus' 'GA12902'='(GA12902) Leslie'
                  'GA12903'='(GA12903) Plains' 'GA12904'='(GA12904) Ga Southwestern State Un'
                  'GA13000'='(GA13000) Talbot' 'GA13001'='(GA13001) Talbotton'
                  'GA13002'='(GA13002) Woodland' 'GA13100'='(GA13100) Taliaferro'
                  'GA13101'='(GA13101) Crawfordville'
                  'GA13102'='(GA13102) Taliaferro County P dept' 'GA13200'='(GA13200) Tattnall'
                  'GA13201'='(GA13201) Glennville' 'GA13202'='(GA13202) Reidsville'
                  'GA13203'='(GA13203) Cobbtown' 'GA13204'='(GA13204) Collins' 'GA13300'='(GA13300) Taylor'
                  'GA13301'='(GA13301) Butler' 'GA13302'='(GA13302) Reynolds' 'GA13400'='(GA13400) Telfair'
                  'GA13401'='(GA13401) Mcrae' 'GA13402'='(GA13402) Helena'
                  'GA13403'='(GA13403) Lumber City' 'GA13404'='(GA13404) Milan'
                  'GA13406'='(GA13406) Jacksonville' 'GA13500'='(GA13500) Terrell'
                  'GA13501'='(GA13501) Dawson' 'GA13502'='(GA13502) Bronwood' 'GA13600'='(GA13600) Thomas'
                  'GA13601'='(GA13601) Thomasville' 'GA13602'='(GA13602) Boston'
                  'GA13603'='(GA13603) Coolidge' 'GA13604'='(GA13604) Meigs'
                  'GA13605'='(GA13605) Ochlocknee' 'GA13606'='(GA13606) Pavo' 'GA13607'='(GA13607) Barwick'
                  'GA13700'='(GA13700) Tift' 'GA13701'='(GA13701) Tifton' 'GA13702'='(GA13702) Omega'
                  'GA13703'='(GA13703) Ty Ty' 'GA13704'='(GA13704) Abraham Baldwin Agric Co'
                  'GA13800'='(GA13800) Toombs' 'GA13801'='(GA13801) Lyons' 'GA13802'='(GA13802) Vidalia'
                  'GA13900'='(GA13900) Towns' 'GA13901'='(GA13901) Hiawassee'
                  'GA13902'='(GA13902) Young Harris' 'GA13903'='(GA13903) Young Harris College'
                  'GA14000'='(GA14000) Treutlen' 'GA14001'='(GA14001) Soperton' 'GA14100'='(GA14100) Troup'
                  'GA14101'='(GA14101) Hogansville' 'GA14102'='(GA14102) Lagrange'
                  'GA14103'='(GA14103) West Point' 'GA14104'='(GA14104) Troup County Marshal'
                  'GA14200'='(GA14200) Turner' 'GA14201'='(GA14201) Ashburn' 'GA14202'='(GA14202) Sycamore'
                  'GA14300'='(GA14300) Twiggs' 'GA14301'='(GA14301) Jeffersonville'
                  'GA14302'='(GA14302) Danville' 'GA14303'='(GA14303) Dnr: Macon'
                  'GA14304'='(GA14304) Twiggs Cnty Board Of Ed' 'GA14400'='(GA14400) Union'
                  'GA14401'='(GA14401) Blairsville' 'GA14500'='(GA14500) Upson'
                  'GA14501'='(GA14501) Thomaston' 'GA14600'='(GA14600) Walker'
                  'GA14601'='(GA14601) Lafayette' 'GA14602'='(GA14602) Rossville'
                  'GA14603'='(GA14603) Lookout Mountain' 'GA14604'='(GA14604) Chickamauga'
                  'GA14605'='(GA14605) Linwood' 'GA14606'='(GA14606) Walker County Police Dpt'
                  'GA14700'='(GA14700) Walton' 'GA14701'='(GA14701) Monroe'
                  'GA14702'='(GA14702) Loganville' 'GA14703'='(GA14703) Social Circle'
                  'GA14800'='(GA14800) Ware' 'GA14801'='(GA14801) Waycross'
                  'GA14802'='(GA14802) Ware County Police Dept'
                  'GA14804'='(GA14804) Se Ga Drug Task Force' 'GA14900'='(GA14900) Warren'
                  'GA14901'='(GA14901) Warrenton' 'GA14902'='(GA14902) Warren County Police Dpt'
                  'GA15000'='(GA15000) Washington' 'GA15001'='(GA15001) Sandersville'
                  'GA15002'='(GA15002) Tennille' 'GA15003'='(GA15003) Davisboro'
                  'GA15004'='(GA15004) Harrison' 'GA15005'='(GA15005) Oconee'
                  'GA15006'='(GA15006) Washington Co Bd Of Educ' 'GA15100'='(GA15100) Wayne'
                  'GA15101'='(GA15101) Jesup' 'GA15102'='(GA15102) Screven' 'GA15103'='(GA15103) Odum'
                  'GA15200'='(GA15200) Webster' 'GA15201'='(GA15201) Preston' 'GA15300'='(GA15300) Wheeler'
                  'GA15301'='(GA15301) Alamo' 'GA15302'='(GA15302) Glenwood' 'GA15400'='(GA15400) White'
                  'GA15401'='(GA15401) Cleveland' 'GA15402'='(GA15402) Helen'
                  'GA15500'='(GA15500) Whitfield' 'GA15501'='(GA15501) Dalton'
                  'GA15502'='(GA15502) Tunnel Hill' 'GA15503'='(GA15503) Cohutta'
                  'GA15505'='(GA15505) Dalton State College' 'GA15506'='(GA15506) Varnell'
                  'GA15507'='(GA15507) Dalton-Whitfield Hosp' 'GA15600'='(GA15600) Wilcox'
                  'GA15601'='(GA15601) Abbeville' 'GA15602'='(GA15602) Rochelle'
                  'GA15603'='(GA15603) Pineview' 'GA15700'='(GA15700) Wilkes'
                  'GA15701'='(GA15701) Washington' 'GA15702'='(GA15702) Tignall'
                  'GA15800'='(GA15800) Wilkinson' 'GA15801'='(GA15801) Gordon'
                  'GA15802'='(GA15802) Irwinton' 'GA15803'='(GA15803) Mcintyre'
                  'GA15804'='(GA15804) Toomsboro' 'GA15805'='(GA15805) Ivey'
                  'GA15806'='(GA15806) Wilkinson Co Bd Of Educ' 'GA15900'='(GA15900) Worth'
                  'GA15901'='(GA15901) Sylvester' 'GA15902'='(GA15902) Poulan'
                  'GA15903'='(GA15903) Warwick' 'GA15904'='(GA15904) Sumner' 'GAAPD00'='(GAAPD00) Atlanta'
                  'GAGBI00'='(GAGBI00) Gbi: Headquarters' 'GAGBI01'='(GAGBI01) Gbi: Americus'
                  'GAGBI02'='(GAGBI02) Gbi: Calhoun' 'GAGBI03'='(GAGBI03) Gbi: Douglas'
                  'GAGBI04'='(GAGBI04) Gbi: Gainesville' 'GAGBI05'='(GAGBI05) Gbi: Milledgeville'
                  'GAGBI06'='(GAGBI06) Gbi: Statesboro' 'GAGBI07'='(GAGBI07) Gbi: Greenville'
                  'GAGBI08'='(GAGBI08) Gbi: Thomson' 'GAGBI11'='(GAGBI11) Gbi: Thomasville'
                  'GAGBI12'='(GAGBI12) Gbi: Dublin' 'GAGBI13'='(GAGBI13) Gbi: Perry'
                  'GAGBI14'='(GAGBI14) Gbi: Athens' 'GAGBI15'='(GAGBI15) Gbi: Savannah'
                  'GAGBI16'='(GAGBI16) Gbi: Albany' 'GAGBI17'='(GAGBI17) Gbi: Conyers'
                  'GAGBI18'='(GAGBI18) Gbi: Rdeo, Gainesville'
                  'GAGBI20'='(GAGBI20) Gbi: Kingsland'
                  'GAGSP00'='(GAGSP00) Ga Dept Of Public Safety'
                  'GAGSP01'='(GAGSP01) Sp: Griffin' 'GAGSP02'='(GAGSP02) Sp: La Grange'
                  'GAGSP03'='(GAGSP03) Sp: Cartersville' 'GAGSP04'='(GAGSP04) Sp: Villa Rica'
                  'GAGSP05'='(GAGSP05) Sp: Dalton' 'GAGSP06'='(GAGSP06) Sp: Gainesville'
                  'GAGSP07'='(GAGSP07) Sp: Toccoa' 'GAGSP08'='(GAGSP08) Sp: Madison'
                  'GAGSP09'='(GAGSP09) Sp: Marietta' 'GAGSP10'='(GAGSP10) Sp: Americus'
                  'GAGSP11'='(GAGSP11) Sp: Hinesville' 'GAGSP12'='(GAGSP12) Sp: Thomasville'
                  'GAGSP13'='(GAGSP13) Sp: Tifton' 'GAGSP14'='(GAGSP14) Sp: Donalsonville'
                  'GAGSP15'='(GAGSP15) Sp: Perry' 'GAGSP16'='(GAGSP16) Sp: Helena'
                  'GAGSP17'='(GAGSP17) Sp: Washington' 'GAGSP18'='(GAGSP18) Sp: Reidsville'
                  'GAGSP19'='(GAGSP19) Sp: Swainsboro' 'GAGSP20'='(GAGSP20) Sp: Dublin'
                  'GAGSP21'='(GAGSP21) Sp: Sylvania' 'GAGSP22'='(GAGSP22) Sp: Waycross'
                  'GAGSP23'='(GAGSP23) Sp: Brunswick' 'GAGSP24'='(GAGSP24) Sp: Newnan'
                  'GAGSP25'='(GAGSP25) Sp: Thomson' 'GAGSP26'='(GAGSP26) Sp: Thomaston'
                  'GAGSP27'='(GAGSP27) Sp: Blue Ridge' 'GAGSP28'='(GAGSP28) Sp: Canton'
                  'GAGSP29'='(GAGSP29) Sp: Cedartown' 'GAGSP30'='(GAGSP30) Sp: Cordele'
                  'GAGSP31'='(GAGSP31) Sp: Valdosta' 'GAGSP32'='(GAGSP32) Sp: Athens'
                  'GAGSP33'='(GAGSP33) Sp: Milledgeville' 'GAGSP34'='(GAGSP34) Sp: Manchester'
                  'GAGSP35'='(GAGSP35) Sp: Jekyll Island' 'GAGSP36'='(GAGSP36) Sp: Douglas'
                  'GAGSP37'='(GAGSP37) Sp: Lawrenceville' 'GAGSP38'='(GAGSP38) Sp: Rome'
                  'GAGSP39'='(GAGSP39) Sp: Cuthbert' 'GAGSP40'='(GAGSP40) Sp: Albany'
                  'GAGSP41'='(GAGSP41) Sp: Lafayette' 'GAGSP42'='(GAGSP42) Sp: Savannah'
                  'GAGSP43'='(GAGSP43) Sp: Calhoun' 'GAGSP44'='(GAGSP44) Sp: Forsyth'
                  'GAGSP45'='(GAGSP45) Sp: Statesboro' 'GAGSP46'='(GAGSP46) Sp: Conyers'
                  'GAGSP47'='(GAGSP47) Sp: Hapeville'
                  'GAGSP48'='(GAGSP48) Sp:Metro Traff U atlanta'
                  'GAGSPH3'='(GAGSPH3) Sp: Hsd Thomaston'
                  'GAUSMO4'='(GAUSMO4) U s Marshals S augusta' 'GMTGM00'='(GMTGM00) Guam'
                  'HI00100'='(HI00100) Hawaii Police Department' 'HI00101'='(HI00101) Hilo'
                  'HI00200'='(HI00200) Honolulu' 'HI0020A'='(HI0020A) Honolulu County Rural'
                  'HI00400'='(HI00400) Kauai Police Department' 'HI00401'='(HI00401) Kapaa'
                  'HI00402'='(HI00402) Lihue' 'HI00500'='(HI00500) Maui Police Department'
                  'HI00501'='(HI00501) Kahului' 'HI00502'='(HI00502) Lahaina'
                  'HI00503'='(HI00503) Lanai City' 'HI00504'='(HI00504) Paia' 'HI00505'='(HI00505) Wailuku'
                  'HI00506'='(HI00506) Puunene' 'IA00100'='(IA00100) Adair' 'IA00200'='(IA00200) Adams'
                  'IA00300'='(IA00300) Allamakee' 'IA00301'='(IA00301) Waukon'
                  'IA00400'='(IA00400) Appanoose' 'IA00401'='(IA00401) Centerville'
                  'IA00500'='(IA00500) Audubon' 'IA00501'='(IA00501) Audubon' 'IA00600'='(IA00600) Benton'
                  'IA00601'='(IA00601) Belle Plaine' 'IA00602'='(IA00602) Vinton'
                  'IA00700'='(IA00700) Black Hawk' 'IA00701'='(IA00701) Cedar Falls'
                  'IA00702'='(IA00702) Evansdale' 'IA00703'='(IA00703) Waterloo'
                  'IA00707'='(IA00707) Univ Of Northern Iowa' 'IA00800'='(IA00800) Boone'
                  'IA00801'='(IA00801) Boone' 'IA00802'='(IA00802) Ogden' 'IA00803'='(IA00803) Madrid'
                  'IA00900'='(IA00900) Bremer' 'IA00902'='(IA00902) Waverly' 'IA01000'='(IA01000) Buchanan'
                  'IA01001'='(IA01001) Independence' 'IA01100'='(IA01100) Buena Vista'
                  'IA01101'='(IA01101) Storm Lake' 'IA01200'='(IA01200) Butler'
                  'IA01300'='(IA01300) Calhoun' 'IA01400'='(IA01400) Carroll' 'IA01401'='(IA01401) Carroll'
                  'IA01500'='(IA01500) Cass' 'IA01501'='(IA01501) Atlantic' 'IA01600'='(IA01600) Cedar'
                  'IA01601'='(IA01601) Tipton' 'IA01700'='(IA01700) Cerro Gordo'
                  'IA01701'='(IA01701) Clear Lake' 'IA01702'='(IA01702) Mason City'
                  'IA01800'='(IA01800) Cherokee' 'IA01801'='(IA01801) Cherokee'
                  'IA01802'='(IA01802) Marcus' 'IA01900'='(IA01900) Chickasaw'
                  'IA01901'='(IA01901) New Hampton' 'IA02000'='(IA02000) Clarke'
                  'IA02001'='(IA02001) Osceola' 'IA02100'='(IA02100) Clay' 'IA02101'='(IA02101) Spencer'
                  'IA02200'='(IA02200) Clayton' 'IA02201'='(IA02201) Guttenberg'
                  'IA02300'='(IA02300) Clinton' 'IA02301'='(IA02301) Clinton'
                  'IA02302'='(IA02302) Camanche' 'IA02303'='(IA02303) De Witt'
                  'IA02400'='(IA02400) Crawford' 'IA02401'='(IA02401) Denison' 'IA02500'='(IA02500) Dallas'
                  'IA02501'='(IA02501) Perry' 'IA02502'='(IA02502) Adel' 'IA02504'='(IA02504) Waukee'
                  'IA02600'='(IA02600) Davis' 'IA02601'='(IA02601) Bloomfield'
                  'IA02700'='(IA02700) Decatur' 'IA02701'='(IA02701) Leon' 'IA02702'='(IA02702) Lamoni'
                  'IA02800'='(IA02800) Delaware' 'IA02801'='(IA02801) Manchester'
                  'IA02900'='(IA02900) Des Moines' 'IA02901'='(IA02901) Burlington'
                  'IA02902'='(IA02902) West Burlington' 'IA03000'='(IA03000) Dickinson'
                  'IA03001'='(IA03001) Spirit Lake' 'IA03100'='(IA03100) Dubuque'
                  'IA03101'='(IA03101) Dubuque' 'IA03103'='(IA03103) Dyersville'
                  'IA03200'='(IA03200) Emmet' 'IA03201'='(IA03201) Estherville'
                  'IA03300'='(IA03300) Fayette' 'IA03301'='(IA03301) Oelwein'
                  'IA03302'='(IA03302) West Union' 'IA03303'='(IA03303) Fayette'
                  'IA03400'='(IA03400) Floyd' 'IA03401'='(IA03401) Charles City'
                  'IA03500'='(IA03500) Franklin' 'IA03501'='(IA03501) Hampton'
                  'IA03600'='(IA03600) Fremont' 'IA03700'='(IA03700) Greene'
                  'IA03701'='(IA03701) Jefferson' 'IA03800'='(IA03800) Grundy'
                  'IA03801'='(IA03801) Grundy Center' 'IA03900'='(IA03900) Guthrie'
                  'IA04000'='(IA04000) Hamilton' 'IA04001'='(IA04001) Webster City'
                  'IA04100'='(IA04100) Hancock' 'IA04101'='(IA04101) Garner' 'IA04200'='(IA04200) Hardin'
                  'IA04201'='(IA04201) Iowa Falls' 'IA04203'='(IA04203) Eldora'
                  'IA04300'='(IA04300) Harrison' 'IA04301'='(IA04301) Missouri Valley'
                  'IA04400'='(IA04400) Henry' 'IA04401'='(IA04401) Mount Pleasant'
                  'IA04500'='(IA04500) Howard' 'IA04501'='(IA04501) Cresco' 'IA04600'='(IA04600) Humboldt'
                  'IA04601'='(IA04601) Humboldt' 'IA04700'='(IA04700) Ida' 'IA04800'='(IA04800) Iowa'
                  'IA04803'='(IA04803) Williamsburg' 'IA04900'='(IA04900) Jackson'
                  'IA04901'='(IA04901) Maquoketa' 'IA05000'='(IA05000) Jasper' 'IA05001'='(IA05001) Newton'
                  'IA05002'='(IA05002) Colfax' 'IA05100'='(IA05100) Jefferson'
                  'IA05101'='(IA05101) Fairfield' 'IA05200'='(IA05200) Johnson'
                  'IA05201'='(IA05201) Coralville' 'IA05202'='(IA05202) Iowa City'
                  'IA05204'='(IA05204) University Of Iowa' 'IA05205'='(IA05205) North Liberty'
                  'IA05300'='(IA05300) Jones' 'IA05301'='(IA05301) Anamosa'
                  'IA05302'='(IA05302) Monticello' 'IA05400'='(IA05400) Keokuk'
                  'IA05500'='(IA05500) Kossuth' 'IA05501'='(IA05501) Algona' 'IA05600'='(IA05600) Lee'
                  'IA05601'='(IA05601) Fort Madison' 'IA05602'='(IA05602) Keokuk'
                  'IA0560A'='(IA0560A) Lee County-South' 'IA05700'='(IA05700) Linn'
                  'IA05701'='(IA05701) Cedar Rapids' 'IA05702'='(IA05702) Marion'
                  'IA05703'='(IA05703) Hiawatha' 'IA05704'='(IA05704) Lisbon'
                  'IA05706'='(IA05706) Mount Vernon' 'IA05708'='(IA05708) Palo'
                  'IA05709'='(IA05709) Robins' 'IA05710'='(IA05710) Coggon' 'IA05800'='(IA05800) Louisa'
                  'IA05900'='(IA05900) Lucas' 'IA05901'='(IA05901) Chariton' 'IA06000'='(IA06000) Lyon'
                  'IA06001'='(IA06001) Rock Rapids' 'IA06100'='(IA06100) Madison'
                  'IA06101'='(IA06101) Winterset' 'IA06200'='(IA06200) Mahaska'
                  'IA06201'='(IA06201) Oskaloosa' 'IA06300'='(IA06300) Marion'
                  'IA06301'='(IA06301) Knoxville' 'IA06302'='(IA06302) Pella'
                  'IA06400'='(IA06400) Marshall' 'IA06401'='(IA06401) Marshalltown'
                  'IA06402'='(IA06402) State Center' 'IA06500'='(IA06500) Mills'
                  'IA06501'='(IA06501) Glenwood' 'IA06600'='(IA06600) Mitchell' 'IA06601'='(IA06601) Osage'
                  'IA06602'='(IA06602) St. Ansgar' 'IA06700'='(IA06700) Monona' 'IA06701'='(IA06701) Onawa'
                  'IA06800'='(IA06800) Monroe' 'IA06801'='(IA06801) Albia' 'IA06900'='(IA06900) Montgomery'
                  'IA06901'='(IA06901) Red Oak' 'IA07000'='(IA07000) Muscatine'
                  'IA07001'='(IA07001) Muscatine' 'IA07002'='(IA07002) West Liberty'
                  'IA07004'='(IA07004) Wilton' 'IA07100'='(IA07100) Obrien' 'IA07103'='(IA07103) Sheldon'
                  'IA07200'='(IA07200) Osceola' 'IA07201'='(IA07201) Sibley' 'IA07300'='(IA07300) Page'
                  'IA07301'='(IA07301) Clarinda' 'IA07302'='(IA07302) Shenandoah'
                  'IA07400'='(IA07400) Palo Alto' 'IA07401'='(IA07401) Emmetsburg'
                  'IA07500'='(IA07500) Plymouth' 'IA07501'='(IA07501) Le Mars'
                  'IA07600'='(IA07600) Pocahontas' 'IA07700'='(IA07700) Polk' 'IA07701'='(IA07701) Ankeny'
                  'IA07702'='(IA07702) Clive' 'IA07703'='(IA07703) Des Moines'
                  'IA07704'='(IA07704) Urbandale' 'IA07705'='(IA07705) West Des Moines'
                  'IA07706'='(IA07706) Windsor Heights' 'IA07707'='(IA07707) Johnston'
                  'IA07708'='(IA07708) Altoona' 'IA07714'='(IA07714) Pleasant Hill'
                  'IA07718'='(IA07718) Polk City' 'IA07800'='(IA07800) Pottawattamie'
                  'IA07801'='(IA07801) Council Bluffs' 'IA07804'='(IA07804) Carter Lake'
                  'IA07900'='(IA07900) Poweshiek' 'IA07901'='(IA07901) Grinnell'
                  'IA08000'='(IA08000) Ringgold' 'IA08100'='(IA08100) Sac' 'IA08101'='(IA08101) Sac City'
                  'IA08200'='(IA08200) Scott' 'IA08201'='(IA08201) Bettendorf'
                  'IA08202'='(IA08202) Davenport' 'IA08206'='(IA08206) Eldridge'
                  'IA08207'='(IA08207) Le Claire' 'IA08300'='(IA08300) Shelby' 'IA08301'='(IA08301) Harlan'
                  'IA08400'='(IA08400) Sioux' 'IA08401'='(IA08401) Orange City'
                  'IA08402'='(IA08402) Hawarden' 'IA08404'='(IA08404) Rock Valley'
                  'IA08405'='(IA08405) Sioux Center' 'IA08500'='(IA08500) Story' 'IA08501'='(IA08501) Ames'
                  'IA08502'='(IA08502) Nevada' 'IA08503'='(IA08503) Story City'
                  'IA08504'='(IA08504) Iowa State University' 'IA08600'='(IA08600) Tama'
                  'IA08601'='(IA08601) Toledo' 'IA08602'='(IA08602) Tama' 'IA08700'='(IA08700) Taylor'
                  'IA08701'='(IA08701) Bedford' 'IA08702'='(IA08702) Lenox' 'IA08800'='(IA08800) Union'
                  'IA08801'='(IA08801) Creston' 'IA08900'='(IA08900) Van Buren'
                  'IA09000'='(IA09000) Wapello' 'IA09001'='(IA09001) Ottumwa' 'IA09100'='(IA09100) Warren'
                  'IA09101'='(IA09101) Indianola' 'IA09102'='(IA09102) Norwalk'
                  'IA09103'='(IA09103) Carlisle' 'IA09200'='(IA09200) Washington'
                  'IA09201'='(IA09201) Washington' 'IA09300'='(IA09300) Wayne'
                  'IA09400'='(IA09400) Webster' 'IA09401'='(IA09401) Fort Dodge'
                  'IA09500'='(IA09500) Winnebago' 'IA09501'='(IA09501) Forest City'
                  'IA09502'='(IA09502) Lake Mills' 'IA09600'='(IA09600) Winneshiek'
                  'IA09601'='(IA09601) Decorah' 'IA09700'='(IA09700) Woodbury'
                  'IA09701'='(IA09701) Sioux City' 'IA09702'='(IA09702) Sergeant Bluff'
                  'IA09800'='(IA09800) Worth' 'IA09900'='(IA09900) Wright'
                  'IA09901'='(IA09901) Eagle Grove' 'IA09902'='(IA09902) Belmond'
                  'IA09903'='(IA09903) Clarion' 'IADPS00'='(IADPS00) Iowa Highway Patrol'
                  'IADPS10'='(IADPS10) Cap Pol Div Des Moines' 'ID00100'='(ID00100) Ada'
                  'ID00101'='(ID00101) Boise' 'ID00102'='(ID00102) Garden City'
                  'ID00103'='(ID00103) Meridian' 'ID00107'='(ID00107) Kuna' 'ID00200'='(ID00200) Adams'
                  'ID00201'='(ID00201) Council' 'ID00300'='(ID00300) Bannock'
                  'ID00301'='(ID00301) Chubbuck' 'ID00302'='(ID00302) Pocatello'
                  'ID00304'='(ID00304) Lava Hot Springs' 'ID00400'='(ID00400) Bear Lake'
                  'ID00401'='(ID00401) Montpelier' 'ID00500'='(ID00500) Benewah'
                  'ID00501'='(ID00501) St. Maries' 'ID00600'='(ID00600) Bingham'
                  'ID00601'='(ID00601) Aberdeen' 'ID00602'='(ID00602) Blackfoot'
                  'ID00603'='(ID00603) Firth' 'ID00604'='(ID00604) Shelley' 'ID00700'='(ID00700) Blaine'
                  'ID00701'='(ID00701) Ketchum' 'ID00702'='(ID00702) Sun Valley'
                  'ID00703'='(ID00703) Hailey' 'ID00704'='(ID00704) Bellevue' 'ID00800'='(ID00800) Boise'
                  'ID00801'='(ID00801) Idaho City' 'ID00900'='(ID00900) Bonner'
                  'ID00901'='(ID00901) Priest River' 'ID00902'='(ID00902) Sandpoint'
                  'ID00903'='(ID00903) Ponderay' 'ID01000'='(ID01000) Bonneville'
                  'ID01001'='(ID01001) Ammon' 'ID01002'='(ID01002) Idaho Falls' 'ID01004'='(ID01004) Ucon'
                  'ID01100'='(ID01100) Boundary' 'ID01101'='(ID01101) Bonners Ferry'
                  'ID01200'='(ID01200) Butte' 'ID01201'='(ID01201) Arco' 'ID01300'='(ID01300) Camas'
                  'ID01400'='(ID01400) Canyon' 'ID01401'='(ID01401) Caldwell' 'ID01402'='(ID01402) Nampa'
                  'ID01403'='(ID01403) Parma' 'ID01404'='(ID01404) Wilder' 'ID01500'='(ID01500) Caribou'
                  'ID01501'='(ID01501) Soda Springs' 'ID01502'='(ID01502) Grace'
                  'ID01600'='(ID01600) Cassia' 'ID01601'='(ID01601) Burley' 'ID01700'='(ID01700) Clark'
                  'ID01800'='(ID01800) Clearwater' 'ID01801'='(ID01801) Orofino'
                  'ID01802'='(ID01802) Pierce' 'ID01900'='(ID01900) Custer' 'ID01902'='(ID01902) Challis'
                  'ID01903'='(ID01903) Challis' 'ID02000'='(ID02000) Elmore'
                  'ID02001'='(ID02001) Glenns Ferry' 'ID02002'='(ID02002) Mountain Home'
                  'ID02100'='(ID02100) Franklin' 'ID02101'='(ID02101) Preston'
                  'ID02200'='(ID02200) Fremont' 'ID02202'='(ID02202) St. Anthony' 'ID02300'='(ID02300) Gem'
                  'ID02301'='(ID02301) Emmett' 'ID02400'='(ID02400) Gooding' 'ID02401'='(ID02401) Gooding'
                  'ID02402'='(ID02402) Wendell' 'ID02403'='(ID02403) Hagerman' 'ID02500'='(ID02500) Idaho'
                  'ID02501'='(ID02501) Cottonwood' 'ID02502'='(ID02502) Grangeville'
                  'ID02600'='(ID02600) Jefferson' 'ID02601'='(ID02601) Rigby' 'ID02700'='(ID02700) Jerome'
                  'ID02701'='(ID02701) Jerome' 'ID02800'='(ID02800) Kootenai'
                  'ID02801'='(ID02801) Coeur Dalene' 'ID02802'='(ID02802) Post Falls'
                  'ID02803'='(ID02803) Worley' 'ID02804'='(ID02804) Spirit Lake'
                  'ID02805'='(ID02805) Rathdrum' 'ID02900'='(ID02900) Latah' 'ID02905'='(ID02905) Moscow'
                  'ID02906'='(ID02906) Potlatch' 'ID03000'='(ID03000) Lemhi' 'ID03002'='(ID03002) Salmon'
                  'ID03100'='(ID03100) Lewis' 'ID03102'='(ID03102) Kamiah' 'ID03200'='(ID03200) Lincoln'
                  'ID03201'='(ID03201) Shoshone' 'ID03300'='(ID03300) Madison'
                  'ID03301'='(ID03301) Rexburg' 'ID03400'='(ID03400) Minidoka' 'ID03401'='(ID03401) Rupert'
                  'ID03402'='(ID03402) Heyburn' 'ID03500'='(ID03500) Nez Perce'
                  'ID03501'='(ID03501) Lapwai' 'ID03502'='(ID03502) Lewiston' 'ID03600'='(ID03600) Oneida'
                  'ID03601'='(ID03601) Malad City' 'ID03700'='(ID03700) Owyhee'
                  'ID03701'='(ID03701) Homedale' 'ID03800'='(ID03800) Payette'
                  'ID03801'='(ID03801) Fruitland' 'ID03802'='(ID03802) New Plymouth'
                  'ID03803'='(ID03803) Payette' 'ID03900'='(ID03900) Power'
                  'ID03901'='(ID03901) American Falls' 'ID04000'='(ID04000) Shoshone'
                  'ID04001'='(ID04001) Kellogg' 'ID04002'='(ID04002) Wallace' 'ID04003'='(ID04003) Osburn'
                  'ID04004'='(ID04004) Pinehurst' 'ID04005'='(ID04005) Smelterville'
                  'ID04100'='(ID04100) Teton' 'ID04101'='(ID04101) Driggs' 'ID04200'='(ID04200) Twin Falls'
                  'ID04201'='(ID04201) Buhl' 'ID04202'='(ID04202) Twin Falls'
                  'ID04203'='(ID04203) Kimberly' 'ID04204'='(ID04204) Filer' 'ID04300'='(ID04300) Valley'
                  'ID04301'='(ID04301) Mccall' 'ID04302'='(ID04302) Cascade'
                  'ID04400'='(ID04400) Washington' 'ID04401'='(ID04401) Weiser'
                  'IDDLE04'='(IDDLE04) Sp, Alcohol Bvrg Control'
                  'IDIBN01'='(IDIBN01) Sp, Bureau Of Narc:Reg 1'
                  'IDIBN02'='(IDIBN02) sp, Bureau Of Narc:Reg 2'
                  'IDIBN03'='(IDIBN03) sp, Bureau Of Narc:Reg 3'
                  'IDIBN04'='(IDIBN04) sp, Bureau Of Narc:Reg 4'
                  'IDIBN05'='(IDIBN05) sp, Bureau Of Narc:Reg 5'
                  'IDIBN06'='(IDIBN06) sp, Bureau Of Narc:Reg 6'
                  'IDISP00'='(IDISP00) idaho State Police'
                  'IDISP01'='(IDISP01) Sp: Coeur D alene' 'IDISP02'='(IDISP02) Sp: Lewiston'
                  'IDISP03'='(IDISP03) Sp: Boise' 'IDISP04'='(IDISP04) Sp: Twin Falls'
                  'IDISP05'='(IDISP05) Sp: Pocatello' 'IDISP06'='(IDISP06) Sp: Idaho Falls'
                  'IL00100'='(IL00100) Adams' 'IL00101'='(IL00101) Camp Point' 'IL00103'='(IL00103) Quincy'
                  'IL00106'='(IL00106) Sp: Inv District 20' 'IL00200'='(IL00200) Alexander'
                  'IL00201'='(IL00201) Cairo' 'IL00300'='(IL00300) Bond' 'IL00301'='(IL00301) Greenville'
                  'IL00400'='(IL00400) Boone' 'IL00401'='(IL00401) Belvidere' 'IL00500'='(IL00500) Brown'
                  'IL00501'='(IL00501) Mount Sterling' 'IL00600'='(IL00600) Bureau'
                  'IL00601'='(IL00601) Buda' 'IL00602'='(IL00602) De Pue' 'IL00604'='(IL00604) Princeton'
                  'IL00606'='(IL00606) Spring Valley' 'IL00610'='(IL00610) La Moille'
                  'IL00614'='(IL00614) Bureau' 'IL00615'='(IL00615) Neponset' 'IL00700'='(IL00700) Calhoun'
                  'IL00800'='(IL00800) Carroll' 'IL00801'='(IL00801) Chadwick' 'IL00802'='(IL00802) Lanark'
                  'IL00803'='(IL00803) Milledgeville' 'IL00804'='(IL00804) Mount Carroll'
                  'IL00805'='(IL00805) Savanna' 'IL00806'='(IL00806) Shannon' 'IL00807'='(IL00807) Thomson'
                  'IL00900'='(IL00900) Cass' 'IL00901'='(IL00901) Ashland' 'IL00902'='(IL00902) Beardstown'
                  'IL00903'='(IL00903) Virginia' 'IL01000'='(IL01000) Champaign'
                  'IL01001'='(IL01001) Champaign' 'IL01002'='(IL01002) Homer' 'IL01003'='(IL01003) Mahomet'
                  'IL01004'='(IL01004) Rantoul' 'IL01005'='(IL01005) Tolono' 'IL01006'='(IL01006) Urbana'
                  'IL01007'='(IL01007) Univ Of Illinois: Urbana' 'IL01008'='(IL01008) Fisher'
                  'IL01009'='(IL01009) Sp: Inv District 10' 'IL01010'='(IL01010) Thomasboro'
                  'IL01011'='(IL01011) Gifford' 'IL01012'='(IL01012) Ogden' 'IL01013'='(IL01013) Ludlow'
                  'IL01015'='(IL01015) Parkland College' 'IL01099'='(IL01099) Sp: District 10'
                  'IL01100'='(IL01100) Christian' 'IL01101'='(IL01101) Pana'
                  'IL01102'='(IL01102) Taylorville' 'IL01103'='(IL01103) Kincaid'
                  'IL01104'='(IL01104) Stonington' 'IL01105'='(IL01105) Assumption'
                  'IL01200'='(IL01200) Clark' 'IL01201'='(IL01201) Casey' 'IL01202'='(IL01202) Marshall'
                  'IL01203'='(IL01203) Martinsville' 'IL01300'='(IL01300) Clay' 'IL01302'='(IL01302) Flora'
                  'IL01400'='(IL01400) Clinton' 'IL01401'='(IL01401) Beckemeyer'
                  'IL01402'='(IL01402) Breese' 'IL01403'='(IL01403) Carlyle'
                  'IL01404'='(IL01404) New Baden' 'IL01405'='(IL01405) Trenton'
                  'IL01406'='(IL01406) Albers' 'IL01407'='(IL01407) Aviston'
                  'IL01413'='(IL01413) Germantown' 'IL01500'='(IL01500) Coles'
                  'IL01502'='(IL01502) Charleston' 'IL01503'='(IL01503) Mattoon'
                  'IL01506'='(IL01506) Eastern Illinois Univers'
                  'IL01507'='(IL01507) Charleston Arson Invest'
                  'IL01508'='(IL01508) East Central Ill Tasd Fo' 'IL01600'='(IL01600) Cook'
                  'IL01601'='(IL01601) Alsip' 'IL01602'='(IL01602) Arlington Heights'
                  'IL01603'='(IL01603) Barrington-Inverness'
                  'IL01604'='(IL01604) Barrington Hills' 'IL01605'='(IL01605) Bartlett'
                  'IL01606'='(IL01606) Bedford Park' 'IL01607'='(IL01607) Bellwood'
                  'IL01608'='(IL01608) Berkeley' 'IL01609'='(IL01609) Berwyn'
                  'IL01610'='(IL01610) Blue Island' 'IL01611'='(IL01611) Bridgeview'
                  'IL01612'='(IL01612) Broadview' 'IL01613'='(IL01613) Brookfield'
                  'IL01614'='(IL01614) Buffalo Grove' 'IL01615'='(IL01615) Burnham'
                  'IL01617'='(IL01617) Calumet City' 'IL01618'='(IL01618) Calumet Park'
                  'IL01619'='(IL01619) Chicago Heights' 'IL0161A'='(IL0161A) Sauk Village'
                  'IL0161B'='(IL0161B) Stone Park' 'IL0161C'='(IL0161C) Willow Springs'
                  'IL0161G'='(IL0161G) S sp: District 1'
                  'IL0161L'='(IL0161L) chicago Fire Dpt Arson I'
                  'IL0161Q'='(IL0161Q) meg Of Cook County'
                  'IL0161T'='(IL0161T) Central Mgmt Services' 'IL01620'='(IL01620) Chicago Ridge'
                  'IL01621'='(IL01621) Cicero' 'IL01622'='(IL01622) Country Club Hills'
                  'IL01623'='(IL01623) Countryside' 'IL01624'='(IL01624) Crestwood'
                  'IL01625'='(IL01625) Des Plaines' 'IL01626'='(IL01626) Dixmoor'
                  'IL01627'='(IL01627) Dolton' 'IL01628'='(IL01628) Ford Heights'
                  'IL01629'='(IL01629) East Hazel Crest' 'IL0162A'='(IL0162A) Schaumburg'
                  'IL0162B'='(IL0162B) Streamwood' 'IL0162C'='(IL0162C) Wilmette'
                  'IL0162J'='(IL0162J) Chicago & Northwesternrp'
                  'IL0162W'='(IL0162W) Northwestern Univ:Evanst'
                  'IL01630'='(IL01630) Elk Grove Village' 'IL01631'='(IL01631) Elmwood Park'
                  'IL01632'='(IL01632) Evanston' 'IL01633'='(IL01633) Evergreen Park'
                  'IL01634'='(IL01634) Flossmoor' 'IL01635'='(IL01635) Forest Park'
                  'IL01636'='(IL01636) Forest View' 'IL01637'='(IL01637) Franklin Park'
                  'IL01638'='(IL01638) Glencoe' 'IL01639'='(IL01639) Glenview'
                  'IL0163A'='(IL0163A) Schiller Park' 'IL0163B'='(IL0163B) Summit'
                  'IL0163C'='(IL0163C) Winnetka' 'IL01640'='(IL01640) Glenwood' 'IL01641'='(IL01641) Golf'
                  'IL01642'='(IL01642) Hanover Park' 'IL01643'='(IL01643) Harvey'
                  'IL01644'='(IL01644) Harwood Heights' 'IL01645'='(IL01645) Hazel Crest'
                  'IL01646'='(IL01646) Hickory Hills' 'IL01647'='(IL01647) Hillside'
                  'IL01649'='(IL01649) Hodgkins' 'IL0164A'='(IL0164A) Skokie'
                  'IL0164B'='(IL0164B) Thornton' 'IL0164C'='(IL0164C) Worth'
                  'IL0164K'='(IL0164K) John H. stroger Hospital'
                  'IL0164M'='(IL0164M) Burlington Nthrn S fe Rr'
                  'IL0164Y'='(IL0164Y) Indiana Harbor Belt Rr'
                  'IL0164Z'='(IL0164Z) Norfolk Southern Railway'
                  'IL01650'='(IL01650) Hoffman Estates' 'IL01651'='(IL01651) Hometown'
                  'IL01652'='(IL01652) Homewood' 'IL01653'='(IL01653) Indian Head Park'
                  'IL01654'='(IL01654) Inverness' 'IL01655'='(IL01655) Justice'
                  'IL01656'='(IL01656) Kenilworth' 'IL01657'='(IL01657) La Grange'
                  'IL01658'='(IL01658) La Grange Park' 'IL01659'='(IL01659) Lansing'
                  'IL0165A'='(IL0165A) South Barrington' 'IL0165H'='(IL0165H) Csx Transportation'
                  'IL0165K'='(IL0165K) Cook Co Forest Preserve' 'IL0165M'='(IL0165M) Tinley Park'
                  'IL01660'='(IL01660) Lemont' 'IL01661'='(IL01661) Lincolnwood'
                  'IL01662'='(IL01662) Lynwood' 'IL01663'='(IL01663) Lyons' 'IL01664'='(IL01664) Mccook'
                  'IL01665'='(IL01665) Markham' 'IL01666'='(IL01666) Matteson'
                  'IL01667'='(IL01667) Maywood' 'IL01668'='(IL01668) Melrose Park'
                  'IL01669'='(IL01669) Merrionette Park'
                  'IL0166A'='(IL0166A) South Chicago Heights' 'IL0166B'='(IL0166B) Westchester'
                  'IL0166C'='(IL0166C) Univ Of Illinois:Chicago'
                  'IL0166D'='(IL0166D) Kennedy-King College'
                  'IL0166E'='(IL0166E) Harold Washington Colleg'
                  'IL0166F'='(IL0166F) Malcolm X college' 'IL0166G'='(IL0166G) Truman College'
                  'IL0166H'='(IL0166H) Olive-Harvey College'
                  'IL0166J'='(IL0166J) Southwest College' 'IL0166K'='(IL0166K) Wright College'
                  'IL0166L'='(IL0166L) Chicago State University'
                  'IL0166M'='(IL0166M) Northeastern Illinois Un'
                  'IL0166N'='(IL0166N) Loyola Univ Of Chicago'
                  'IL0166P'='(IL0166P) Chicago Transit Authorit' 'IL01670'='(IL01670) Midlothian'
                  'IL01671'='(IL01671) Morton Grove' 'IL01672'='(IL01672) Mount Prospect'
                  'IL01673'='(IL01673) Niles' 'IL01674'='(IL01674) Norridge'
                  'IL01675'='(IL01675) Northbrook' 'IL01676'='(IL01676) Northfield'
                  'IL01677'='(IL01677) Northlake' 'IL01678'='(IL01678) North Riverside'
                  'IL01679'='(IL01679) Oak Forest' 'IL0167A'='(IL0167A) South Holland'
                  'IL0167B'='(IL0167B) Western Springs'
                  'IL0167D'='(IL0167D) Northwestern University'
                  'IL0167E'='(IL0167E) Oakton Community College' 'IL01680'='(IL01680) Oak Lawn'
                  'IL01681'='(IL01681) Oak Park' 'IL01682'='(IL01682) Olympia Fields'
                  'IL01683'='(IL01683) Orland Park' 'IL01684'='(IL01684) Palatine'
                  'IL01685'='(IL01685) Palos Heights' 'IL01686'='(IL01686) Palos Hills'
                  'IL01687'='(IL01687) Palos Park' 'IL01688'='(IL01688) Park Forest'
                  'IL01689'='(IL01689) Park Ridge' 'IL0168A'='(IL0168A) Steger'
                  'IL0168B'='(IL0168B) Orland Hills' 'IL0168C'='(IL0168C) Burbank'
                  'IL01690'='(IL01690) phoenix' 'IL01691'='(IL01691) Posen'
                  'IL01692'='(IL01692) Richton Park' 'IL01693'='(IL01693) Riverdale'
                  'IL01694'='(IL01694) River Forest' 'IL01695'='(IL01695) River Grove'
                  'IL01696'='(IL01696) Riverside' 'IL01697'='(IL01697) Robbins'
                  'IL01698'='(IL01698) Rolling Meadows' 'IL01699'='(IL01699) Rosemont'
                  'IL0169A'='(IL0169A) Stickney' 'IL0169B'='(IL0169B) Wheeling'
                  'IL0169C'='(IL0169C) South Suburban College'
                  'IL0169D'='(IL0169D) William Rainey Harper Co'
                  'IL0169E'='(IL0169E) Triton College' 'IL0169F'='(IL0169F) Morton College'
                  'IL0169G'='(IL0169G) Prospect Heights'
                  'IL0169K'='(IL0169K) Moraine Valley Comm Coll'
                  'IL0169L'='(IL0169L) Sp: Inv District 3'
                  'IL0169M'='(IL0169M) sp: Inv District 4'
                  'IL0169N'='(IL0169N) sp: Medicaid Fraud U a 1'
                  'IL016AB'='(IL016AB) Loyola University'
                  'IL016AC'='(IL016AC) Northwestern Univ:Chicag'
                  'IL016XX'='(IL016XX) Sp: District Chicago'
                  'IL016XY'='(IL016XY) Sp: District Chicago' 'IL01700'='(IL01700) Crawford'
                  'IL01701'='(IL01701) Oblong' 'IL01702'='(IL01702) Palestine'
                  'IL01703'='(IL01703) Robinson' 'IL01704'='(IL01704) Hutsonville'
                  'IL01800'='(IL01800) Cumberland' 'IL01801'='(IL01801) Greenup'
                  'IL01802'='(IL01802) Neoga' 'IL01900'='(IL01900) De Kalb' 'IL01901'='(IL01901) Genoa'
                  'IL01902'='(IL01902) Hinckley' 'IL01903'='(IL01903) Sandwich'
                  'IL01904'='(IL01904) Somonauk' 'IL01905'='(IL01905) Sycamore'
                  'IL01906'='(IL01906) Waterman' 'IL01907'='(IL01907) Cortland'
                  'IL01908'='(IL01908) De Kalb' 'IL01909'='(IL01909) Kirkland'
                  'IL01911'='(IL01911) Northern Illinois Univ' 'IL02000'='(IL02000) De Witt'
                  'IL02001'='(IL02001) Clinton' 'IL02002'='(IL02002) Farmer City'
                  'IL02100'='(IL02100) Douglas' 'IL02101'='(IL02101) Arcola' 'IL02102'='(IL02102) Arthur'
                  'IL02103'='(IL02103) Atwood' 'IL02104'='(IL02104) Newman' 'IL02105'='(IL02105) Tuscola'
                  'IL02106'='(IL02106) Villa Grove' 'IL02200'='(IL02200) Du Page'
                  'IL02201'='(IL02201) Addison' 'IL02202'='(IL02202) Bensenville'
                  'IL02203'='(IL02203) Bloomingdale' 'IL02204'='(IL02204) Carol Stream'
                  'IL02205'='(IL02205) Clarendon Hills' 'IL02206'='(IL02206) Downers Grove'
                  'IL02207'='(IL02207) Elmhurst' 'IL02208'='(IL02208) Glendale Heights'
                  'IL02209'='(IL02209) Glen Ellyn' 'IL02210'='(IL02210) Hinsdale'
                  'IL02211'='(IL02211) Itasca' 'IL02212'='(IL02212) Lisle' 'IL02213'='(IL02213) Lombard'
                  'IL02214'='(IL02214) Naperville' 'IL02215'='(IL02215) Oak Brook'
                  'IL02216'='(IL02216) Roselle' 'IL02217'='(IL02217) Villa Park'
                  'IL02218'='(IL02218) Wayne' 'IL02219'='(IL02219) West Chicago'
                  'IL02220'='(IL02220) Westmont' 'IL02221'='(IL02221) Wheaton'
                  'IL02222'='(IL02222) Winfield' 'IL02223'='(IL02223) Wood Dale'
                  'IL02224'='(IL02224) Woodridge' 'IL02225'='(IL02225) Warrenville'
                  'IL02227'='(IL02227) Darien' 'IL02229'='(IL02229) Oakbrook Terrace'
                  'IL02230'='(IL02230) Willowbrook' 'IL02231'='(IL02231) Burr Ridge'
                  'IL02232'='(IL02232) Elmhurst Park District'
                  'IL02233'='(IL02233) Du Page Co Forest Preser'
                  'IL02237'='(IL02237) College Of Dupage'
                  'IL02242'='(IL02242) Du Page Metro Enfrc Grp'
                  'IL02299'='(IL02299) Sp: District 15' 'IL02300'='(IL02300) Edgar'
                  'IL02301'='(IL02301) Chrisman' 'IL02303'='(IL02303) Paris' 'IL02400'='(IL02400) Edwards'
                  'IL02401'='(IL02401) Albion' 'IL02404'='(IL02404) West Salem'
                  'IL02500'='(IL02500) Effingham' 'IL02501'='(IL02501) Altamont'
                  'IL02502'='(IL02502) Effingham' 'IL02509'='(IL02509) Sp: Inv District 12'
                  'IL02599'='(IL02599) Sp: District 12' 'IL02600'='(IL02600) Fayette'
                  'IL02601'='(IL02601) Ramsey' 'IL02603'='(IL02603) St. Peter'
                  'IL02604'='(IL02604) Vandalia' 'IL02605'='(IL02605) Farina' 'IL02700'='(IL02700) Ford'
                  'IL02701'='(IL02701) Gibson City' 'IL02702'='(IL02702) Paxton'
                  'IL02703'='(IL02703) Piper City' 'IL02800'='(IL02800) Franklin'
                  'IL02801'='(IL02801) Benton' 'IL02802'='(IL02802) Christopher'
                  'IL02803'='(IL02803) Royalton' 'IL02804'='(IL02804) Sesser'
                  'IL02805'='(IL02805) West Frankfort' 'IL02806'='(IL02806) Zeigler'
                  'IL02809'='(IL02809) West City' 'IL02810'='(IL02810) Buckner'
                  'IL02811'='(IL02811) Valier' 'IL02900'='(IL02900) Fulton' 'IL02901'='(IL02901) Astoria'
                  'IL02902'='(IL02902) Canton' 'IL02903'='(IL02903) Cuba' 'IL02904'='(IL02904) Farmington'
                  'IL02905'='(IL02905) Lewistown' 'IL02906'='(IL02906) Avon' 'IL02910'='(IL02910) Vermont'
                  'IL02911'='(IL02911) Fairview' 'IL02915'='(IL02915) London Mills'
                  'IL02916'='(IL02916) Dunfermline' 'IL03000'='(IL03000) Gallatin'
                  'IL03001'='(IL03001) Ridgway' 'IL03002'='(IL03002) Shawneetown'
                  'IL03003'='(IL03003) Old Shawneetown' 'IL03004'='(IL03004) Equality'
                  'IL03100'='(IL03100) Greene' 'IL03101'='(IL03101) Carrollton'
                  'IL03102'='(IL03102) Greenfield' 'IL03103'='(IL03103) Roodhouse'
                  'IL03104'='(IL03104) White Hall' 'IL03200'='(IL03200) Grundy'
                  'IL03201'='(IL03201) Coal City' 'IL03202'='(IL03202) Gardner'
                  'IL03204'='(IL03204) Morris' 'IL03206'='(IL03206) Minooka' 'IL03300'='(IL03300) Hamilton'
                  'IL03301'='(IL03301) Mcleansboro' 'IL03400'='(IL03400) Hancock'
                  'IL03401'='(IL03401) Carthage' 'IL03403'='(IL03403) Dallas City'
                  'IL03404'='(IL03404) Hamilton' 'IL03407'='(IL03407) Nauvoo'
                  'IL03408'='(IL03408) Plymouth' 'IL03409'='(IL03409) Warsaw' 'IL03410'='(IL03410) Augusta'
                  'IL03500'='(IL03500) Hardin' 'IL03503'='(IL03503) Rosiclare'
                  'IL03600'='(IL03600) Henderson' 'IL03700'='(IL03700) Henry' 'IL03702'='(IL03702) Annawan'
                  'IL03703'='(IL03703) Atkinson' 'IL03704'='(IL03704) Cambridge'
                  'IL03705'='(IL03705) Colona' 'IL03706'='(IL03706) Galva' 'IL03707'='(IL03707) Geneseo'
                  'IL03708'='(IL03708) Green Rock' 'IL03709'='(IL03709) Kewanee'
                  'IL03710'='(IL03710) Orion' 'IL03711'='(IL03711) Woodhull' 'IL03800'='(IL03800) Iroquois'
                  'IL03801'='(IL03801) Watseka' 'IL03802'='(IL03802) Gilman' 'IL03803'='(IL03803) Milford'
                  'IL03805'='(IL03805) Sheldon' 'IL03807'='(IL03807) Cissna Park'
                  'IL03808'='(IL03808) Loda' 'IL03899'='(IL03899) Sp: District 21'
                  'IL03900'='(IL03900) Jackson' 'IL03901'='(IL03901) Carbondale'
                  'IL03902'='(IL03902) Murphysboro'
                  'IL03903'='(IL03903) Southern Il U:carbondale' 'IL03904'='(IL03904) De Soto'
                  'IL03907'='(IL03907) Southern Il Enf Group' 'IL04000'='(IL04000) Jasper'
                  'IL04001'='(IL04001) Newton' 'IL04100'='(IL04100) Jefferson'
                  'IL04101'='(IL04101) Mount Vernon' 'IL04102'='(IL04102) S sp: District 4'
                  'IL04200'='(IL04200) jersey' 'IL04201'='(IL04201) Grafton'
                  'IL04202'='(IL04202) Jerseyville' 'IL04300'='(IL04300) Jo Daviess'
                  'IL04301'='(IL04301) East Dubuque' 'IL04302'='(IL04302) Elizabeth'
                  'IL04303'='(IL04303) Galena' 'IL04304'='(IL04304) Hanover' 'IL04305'='(IL04305) Stockton'
                  'IL04306'='(IL04306) Warren' 'IL04307'='(IL04307) Apple River'
                  'IL04400'='(IL04400) Johnson' 'IL04401'='(IL04401) Vienna' 'IL04500'='(IL04500) Kane'
                  'IL04501'='(IL04501) Aurora' 'IL04502'='(IL04502) Batavia'
                  'IL04503'='(IL04503) Carpentersville' 'IL04504'='(IL04504) East Dundee'
                  'IL04505'='(IL04505) Elburn' 'IL04506'='(IL04506) Elgin' 'IL04507'='(IL04507) Geneva'
                  'IL04508'='(IL04508) Hampshire' 'IL04509'='(IL04509) Montgomery'
                  'IL04510'='(IL04510) North Aurora' 'IL04512'='(IL04512) Sleepy Hollow'
                  'IL04513'='(IL04513) South Elgin' 'IL04514'='(IL04514) St. Charles'
                  'IL04515'='(IL04515) Sugar Grove' 'IL04516'='(IL04516) Valley View'
                  'IL04517'='(IL04517) West Dundee' 'IL04518'='(IL04518) Maple Park'
                  'IL04519'='(IL04519) Waubonsee College' 'IL04520'='(IL04520) Burlington'
                  'IL04521'='(IL04521) Gilberts' 'IL04523'='(IL04523) Sp: Inv District 2'
                  'IL04599'='(IL04599) sp: District 2' 'IL04600'='(IL04600) kankakee'
                  'IL04601'='(IL04601) Bradley' 'IL04602'='(IL04602) Kankakee'
                  'IL04603'='(IL04603) Bourbonnais' 'IL04604'='(IL04604) Momence'
                  'IL04605'='(IL04605) Manteno' 'IL04606'='(IL04606) St. Anne' 'IL04609'='(IL04609) Essex'
                  'IL04610'='(IL04610) Herscher' 'IL04611'='(IL04611) Grant Park'
                  'IL04615'='(IL04615) Hopkins Park' 'IL04617'='(IL04617) Kankakee Area Meg'
                  'IL04700'='(IL04700) Kendall' 'IL04701'='(IL04701) Plano' 'IL04702'='(IL04702) Yorkville'
                  'IL04703'='(IL04703) Oswego' 'IL04800'='(IL04800) Knox' 'IL04801'='(IL04801) Abingdon'
                  'IL04803'='(IL04803) East Galesburg' 'IL04804'='(IL04804) Galesburg'
                  'IL04805'='(IL04805) Knoxville' 'IL04807'='(IL04807) Yates City'
                  'IL04808'='(IL04808) Williamsfield' 'IL04809'='(IL04809) London Mills'
                  'IL04900'='(IL04900) Lake' 'IL04901'='(IL04901) Antioch' 'IL04903'='(IL04903) Deerfield'
                  'IL04904'='(IL04904) Fox Lake' 'IL04905'='(IL04905) Grayslake'
                  'IL04906'='(IL04906) Gurnee' 'IL04907'='(IL04907) Highland Park'
                  'IL04908'='(IL04908) Highwood' 'IL04909'='(IL04909) Lake Bluff'
                  'IL04910'='(IL04910) Lake Forest' 'IL04911'='(IL04911) Lake Villa'
                  'IL04912'='(IL04912) Lake Zurich' 'IL04913'='(IL04913) Libertyville'
                  'IL04914'='(IL04914) Mundelein' 'IL04915'='(IL04915) North Chicago'
                  'IL04916'='(IL04916) Round Lake' 'IL04917'='(IL04917) Round Lake Beach'
                  'IL04918'='(IL04918) Round Lake Heights' 'IL04919'='(IL04919) Round Lake Park'
                  'IL04920'='(IL04920) Wauconda' 'IL04921'='(IL04921) Waukegan'
                  'IL04922'='(IL04922) Winthrop Harbor' 'IL04923'='(IL04923) Zion'
                  'IL04924'='(IL04924) Island Lake' 'IL04925'='(IL04925) Park City'
                  'IL04926'='(IL04926) Vernon Hills' 'IL04927'='(IL04927) Bannockburn'
                  'IL04928'='(IL04928) Hainesville' 'IL04929'='(IL04929) Lincolnshire'
                  'IL04930'='(IL04930) Lindenhurst' 'IL04931'='(IL04931) North Barrington'
                  'IL04932'='(IL04932) College Of Lake County' 'IL04933'='(IL04933) Tower Lakes'
                  'IL04936'='(IL04936) Kildeer' 'IL04937'='(IL04937) Mundelein Park District'
                  'IL04938'='(IL04938) Hawthorn Woods' 'IL04939'='(IL04939) Riverwoods'
                  'IL04940'='(IL04940) Meg Of Lake County'
                  'IL04941'='(IL04941) Lake Co Forest Preserve' 'IL05000'='(IL05000) La Salle'
                  'IL05001'='(IL05001) La Salle' 'IL05002'='(IL05002) Leland'
                  'IL05003'='(IL05003) Marseilles' 'IL05004'='(IL05004) Mendota'
                  'IL05006'='(IL05006) Oglesby' 'IL05007'='(IL05007) Ottawa' 'IL05008'='(IL05008) Peru'
                  'IL05009'='(IL05009) Seneca' 'IL05010'='(IL05010) Streator'
                  'IL05011'='(IL05011) Earlville' 'IL05013'='(IL05013) Grand Ridge'
                  'IL05015'='(IL05015) Sheridan' 'IL05016'='(IL05016) Tonica'
                  'IL05099'='(IL05099) Sp: District 17' 'IL05100'='(IL05100) Lawrence'
                  'IL05101'='(IL05101) Bridgeport' 'IL05102'='(IL05102) Lawrenceville'
                  'IL05103'='(IL05103) Sumner' 'IL05104'='(IL05104) St. Francisville'
                  'IL05200'='(IL05200) Lee' 'IL05202'='(IL05202) Amboy' 'IL05203'='(IL05203) Dixon'
                  'IL05300'='(IL05300) Livingston' 'IL05301'='(IL05301) Dwight'
                  'IL05302'='(IL05302) Pontiac' 'IL05303'='(IL05303) Fairbury'
                  'IL05399'='(IL05399) Sp: District 6' 'IL05400'='(IL05400) logan'
                  'IL05401'='(IL05401) Atlanta' 'IL05402'='(IL05402) Lincoln'
                  'IL05403'='(IL05403) Mount Pulaski' 'IL05500'='(IL05500) Mcdonough'
                  'IL05502'='(IL05502) Bushnell' 'IL05504'='(IL05504) Macomb'
                  'IL05505'='(IL05505) Western Illinois Univers'
                  'IL05507'='(IL05507) Sp: Inv District 14' 'IL05599'='(IL05599) Sp: District 14'
                  'IL05600'='(IL05600) Mchenry' 'IL05601'='(IL05601) Algonquin' 'IL05602'='(IL05602) Cary'
                  'IL05603'='(IL05603) Crystal Lake' 'IL05604'='(IL05604) Fox River Grove'
                  'IL05605'='(IL05605) Harvard' 'IL05606'='(IL05606) Hebron' 'IL05607'='(IL05607) Huntley'
                  'IL05609'='(IL05609) Lake In The Hills' 'IL05610'='(IL05610) Marengo'
                  'IL05611'='(IL05611) Mccullom Lake' 'IL05612'='(IL05612) Mchenry'
                  'IL05613'='(IL05613) Richmond' 'IL05614'='(IL05614) Johnsburg'
                  'IL05615'='(IL05615) Woodstock' 'IL05616'='(IL05616) Lakemoor'
                  'IL05617'='(IL05617) Lakewood' 'IL05618'='(IL05618) Oakwood Hills'
                  'IL05619'='(IL05619) Spring Grove' 'IL05620'='(IL05620) Port Barrington'
                  'IL05621'='(IL05621) Holiday Hills' 'IL05622'='(IL05622) Wonder Lake'
                  'IL05623'='(IL05623) Mchenry Shores' 'IL05625'='(IL05625) Bull Valley'
                  'IL05627'='(IL05627) Crystal Lake Park Distri' 'IL05700'='(IL05700) Mclean'
                  'IL05701'='(IL05701) Bloomington' 'IL05702'='(IL05702) Normal'
                  'IL05703'='(IL05703) Chenoa' 'IL05705'='(IL05705) Le Roy' 'IL05706'='(IL05706) Lexington'
                  'IL05707'='(IL05707) Danvers' 'IL05708'='(IL05708) Colfax' 'IL05710'='(IL05710) Gridley'
                  'IL05712'='(IL05712) Mclean' 'IL05713'='(IL05713) Saybrook'
                  'IL05714'='(IL05714) Stanford' 'IL05715'='(IL05715) Illinois State Universit'
                  'IL05716'='(IL05716) Sp: Inv District 6' 'IL05800'='(IL05800) macon'
                  'IL05801'='(IL05801) Blue Mound' 'IL05802'='(IL05802) Decatur'
                  'IL05803'='(IL05803) Maroa' 'IL05804'='(IL05804) Mount Zion' 'IL05805'='(IL05805) Macon'
                  'IL05806'='(IL05806) Argenta' 'IL05807'='(IL05807) Decatur Park District'
                  'IL05809'='(IL05809) Warrensburg' 'IL05810'='(IL05810) Oreana'
                  'IL05900'='(IL05900) Macoupin' 'IL05901'='(IL05901) Benld' 'IL05902'='(IL05902) Brighton'
                  'IL05903'='(IL05903) Bunker Hill' 'IL05904'='(IL05904) Carlinville'
                  'IL05905'='(IL05905) Gillespie' 'IL05906'='(IL05906) Girard'
                  'IL05907'='(IL05907) Mount Olive' 'IL05909'='(IL05909) Staunton'
                  'IL05910'='(IL05910) Virden' 'IL05912'='(IL05912) Palmyra' 'IL06000'='(IL06000) Madison'
                  'IL06001'='(IL06001) Alton' 'IL06002'='(IL06002) Bethalto'
                  'IL06003'='(IL06003) Collinsville' 'IL06004'='(IL06004) East Alton'
                  'IL06005'='(IL06005) Edwardsville' 'IL06007'='(IL06007) Granite City'
                  'IL06008'='(IL06008) Hartford' 'IL06009'='(IL06009) Highland'
                  'IL06010'='(IL06010) Livingston' 'IL06011'='(IL06011) Madison'
                  'IL06012'='(IL06012) Maryville' 'IL06013'='(IL06013) Roxana' 'IL06014'='(IL06014) Troy'
                  'IL06015'='(IL06015) Venice' 'IL06016'='(IL06016) Wood River'
                  'IL06017'='(IL06017) Southern Il U:edwardsvil'
                  'IL06019'='(IL06019) South Roxana'
                  'IL06020'='(IL06020) Lewis And Clark College'
                  'IL06021'='(IL06021) Pontoon Beach' 'IL06023'='(IL06023) Glen Carbon'
                  'IL06026'='(IL06026) Worden' 'IL06028'='(IL06028) Hamel'
                  'IL06029'='(IL06029) Southwestern Il Enfrc Gr'
                  'IL06031'='(IL06031) Sp: Inv District 11' 'IL06099'='(IL06099) Sp: District 11'
                  'IL06100'='(IL06100) Marion' 'IL06101'='(IL06101) Central City'
                  'IL06102'='(IL06102) Centralia' 'IL06104'='(IL06104) Salem' 'IL06106'='(IL06106) Wamac'
                  'IL06200'='(IL06200) Marshall' 'IL06201'='(IL06201) Henry' 'IL06202'='(IL06202) Lacon'
                  'IL06203'='(IL06203) Toluca' 'IL06300'='(IL06300) Mason' 'IL06301'='(IL06301) Havana'
                  'IL06302'='(IL06302) Mason City' 'IL06303'='(IL06303) Manito'
                  'IL06306'='(IL06306) Easton' 'IL06307'='(IL06307) Kilbourne' 'IL06400'='(IL06400) Massac'
                  'IL06403'='(IL06403) Metropolis' 'IL06500'='(IL06500) Menard'
                  'IL06501'='(IL06501) Petersburg' 'IL06502'='(IL06502) Athens'
                  'IL06503'='(IL06503) Greenview' 'IL06600'='(IL06600) Mercer' 'IL06601'='(IL06601) Aledo'
                  'IL06700'='(IL06700) Monroe' 'IL06701'='(IL06701) Columbia'
                  'IL06702'='(IL06702) Waterloo' 'IL06703'='(IL06703) Valmeyer'
                  'IL06704'='(IL06704) Hecker' 'IL06800'='(IL06800) Montgomery'
                  'IL06801'='(IL06801) Hillsboro' 'IL06802'='(IL06802) Litchfield'
                  'IL06803'='(IL06803) Nokomis' 'IL06804'='(IL06804) Raymond' 'IL06805'='(IL06805) Witt'
                  'IL06806'='(IL06806) Schram City' 'IL06807'='(IL06807) Irving'
                  'IL06899'='(IL06899) Sp: District 18' 'IL06900'='(IL06900) Morgan'
                  'IL06901'='(IL06901) Jacksonville' 'IL06902'='(IL06902) Meredosia'
                  'IL06904'='(IL06904) South Jacksonville' 'IL07000'='(IL07000) Moultrie'
                  'IL07003'='(IL07003) Sullivan' 'IL07100'='(IL07100) Ogle' 'IL07101'='(IL07101) Forreston'
                  'IL07102'='(IL07102) Mount Morris' 'IL07103'='(IL07103) Oregon'
                  'IL07104'='(IL07104) Polo' 'IL07105'='(IL07105) Rochelle' 'IL07106'='(IL07106) Byron'
                  'IL07107'='(IL07107) Hillcrest' 'IL07108'='(IL07108) Stillman Valley'
                  'IL07200'='(IL07200) Peoria' 'IL07201'='(IL07201) Bartonville'
                  'IL07202'='(IL07202) Bellevue' 'IL07203'='(IL07203) Chillicothe'
                  'IL07204'='(IL07204) Elmwood' 'IL07205'='(IL07205) Hanna City'
                  'IL07206'='(IL07206) North Chillicothe' 'IL07207'='(IL07207) Peoria'
                  'IL07209'='(IL07209) Peoria Heights' 'IL07212'='(IL07212) Glasford'
                  'IL07213'='(IL07213) Norwood' 'IL07214'='(IL07214) Peoria Park District'
                  'IL07217'='(IL07217) Sp: Inv District 8'
                  'IL07219'='(IL07219) multi-Cnty Narc Enf Grp' 'IL07300'='(IL07300) Perry'
                  'IL07301'='(IL07301) Du Quoin' 'IL07302'='(IL07302) Pinckneyville'
                  'IL07303'='(IL07303) Cutler' 'IL07304'='(IL07304) Tamaroa'
                  'IL07399'='(IL07399) Sp: District 13' 'IL07400'='(IL07400) Piatt'
                  'IL07401'='(IL07401) Bement' 'IL07402'='(IL07402) Cerro Gordo'
                  'IL07403'='(IL07403) Monticello' 'IL07500'='(IL07500) Pike' 'IL07501'='(IL07501) Barry'
                  'IL07503'='(IL07503) Pittsfield' 'IL07599'='(IL07599) Sp: District 20'
                  'IL07600'='(IL07600) Pope' 'IL07601'='(IL07601) Golconda' 'IL07700'='(IL07700) Pulaski'
                  'IL07702'='(IL07702) Mound City' 'IL07799'='(IL07799) Sp: District 22'
                  'IL07800'='(IL07800) Putnam' 'IL07801'='(IL07801) Granville'
                  'IL07900'='(IL07900) Randolph' 'IL07901'='(IL07901) Chester'
                  'IL07902'='(IL07902) Red Bud' 'IL07903'='(IL07903) Sparta' 'IL07905'='(IL07905) Tilden'
                  'IL07906'='(IL07906) Coulterville' 'IL07909'='(IL07909) Ruma'
                  'IL08000'='(IL08000) Richland' 'IL08001'='(IL08001) Olney'
                  'IL08100'='(IL08100) Rock Island' 'IL08101'='(IL08101) Andalusia'
                  'IL08102'='(IL08102) Carbon Cliff' 'IL08103'='(IL08103) Coal Valley'
                  'IL08104'='(IL08104) East Moline' 'IL08105'='(IL08105) Milan'
                  'IL08106'='(IL08106) Moline' 'IL08107'='(IL08107) Port Byron'
                  'IL08108'='(IL08108) Rock Island' 'IL08109'='(IL08109) Silvis'
                  'IL08110'='(IL08110) Cordova' 'IL08111'='(IL08111) Hampton'
                  'IL08113'='(IL08113) Black Hawk College' 'IL08114'='(IL08114) Hillsdale'
                  'IL08117'='(IL08117) Sp: Inv District 7'
                  'IL08118'='(IL08118) quad-City Metro Enfc Grp'
                  'IL08199'='(IL08199) Sp: District 7' 'IL08200'='(IL08200) st. Clair'
                  'IL08201'='(IL08201) Alorton' 'IL08202'='(IL08202) Belleville'
                  'IL08203'='(IL08203) Cahokia' 'IL08204'='(IL08204) Caseyville'
                  'IL08205'='(IL08205) Centreville' 'IL08206'='(IL08206) Dupo'
                  'IL08207'='(IL08207) East St. Louis' 'IL08208'='(IL08208) Freeburg'
                  'IL08209'='(IL08209) Lebanon' 'IL08210'='(IL08210) Marissa'
                  'IL08211'='(IL08211) Mascoutah' 'IL08212'='(IL08212) Millstadt'
                  'IL08214'='(IL08214) National City' 'IL08215'='(IL08215) New Athens'
                  'IL08216'='(IL08216) Ofallon' 'IL08217'='(IL08217) Washington Park'
                  'IL08219'='(IL08219) Brooklyn' 'IL08220'='(IL08220) Fairmont City'
                  'IL08221'='(IL08221) Fayetteville' 'IL08222'='(IL08222) Sauget'
                  'IL08223'='(IL08223) Swansea' 'IL08224'='(IL08224) Fairview Heights'
                  'IL08225'='(IL08225) Shiloh' 'IL08226'='(IL08226) Summerfield'
                  'IL08227'='(IL08227) State Community College' 'IL08228'='(IL08228) Smithton'
                  'IL08230'='(IL08230) Lenzburg' 'IL08235'='(IL08235) St. Louis S. western Rr'
                  'IL08240'='(IL08240) East Carondelet' 'IL08300'='(IL08300) Saline'
                  'IL08301'='(IL08301) Carrier Mills' 'IL08302'='(IL08302) Eldorado'
                  'IL08303'='(IL08303) Harrisburg' 'IL08400'='(IL08400) Sangamon'
                  'IL08402'='(IL08402) Springfield' 'IL08403'='(IL08403) Auburn'
                  'IL08404'='(IL08404) Chatham' 'IL08406'='(IL08406) Pawnee'
                  'IL08408'='(IL08408) Williamsville' 'IL08409'='(IL08409) Rochester'
                  'IL08411'='(IL08411) Divernon' 'IL08412'='(IL08412) Illiopolis'
                  'IL08413'='(IL08413) Leland Grove' 'IL08414'='(IL08414) Sherman'
                  'IL08415'='(IL08415) Southern View'
                  'IL08416'='(IL08416) Univ Of Il: Springfield' 'IL08417'='(IL08417) Jerome'
                  'IL08418'='(IL08418) Springfield Park Distric' 'IL08423'='(IL08423) Loami'
                  'IL08424'='(IL08424) Pleasant Plains' 'IL08426'='(IL08426) Sp: Inv District 9'
                  'IL08427'='(IL08427) capitol Airport Auth'
                  'IL08435'='(IL08435) S sp: Hq Command Center'
                  'IL08442'='(IL08442) Ill Commerce Commission'
                  'IL08446'='(IL08446) Southern Il U:sch Of Med'
                  'IL08489'='(IL08489) S sp: District 3'
                  'IL08490'='(IL08490) s Sp: Auto Thft S dist 5'
                  'IL08493'='(IL08493) il Dept Of Natural Resou'
                  'IL08497'='(IL08497) Illinois State Police'
                  'IL08499'='(IL08499) Sp: District 9' 'IL08500'='(IL08500) schuyler'
                  'IL08501'='(IL08501) Rushville' 'IL08600'='(IL08600) Scott'
                  'IL08602'='(IL08602) Winchester' 'IL08700'='(IL08700) Shelby'
                  'IL08701'='(IL08701) Moweaqua' 'IL08702'='(IL08702) Shelbyville'
                  'IL08800'='(IL08800) Stark' 'IL08801'='(IL08801) Toulon' 'IL08802'='(IL08802) Wyoming'
                  'IL08803'='(IL08803) Bradford' 'IL08900'='(IL08900) Stephenson'
                  'IL08901'='(IL08901) Freeport' 'IL08907'='(IL08907) Ridott'
                  'IL09000'='(IL09000) Tazewell' 'IL09001'='(IL09001) Creve Coeur'
                  'IL09002'='(IL09002) Delavan' 'IL09003'='(IL09003) East Peoria'
                  'IL09004'='(IL09004) Hopedale' 'IL09005'='(IL09005) Marquette Heights'
                  'IL09006'='(IL09006) Minier' 'IL09007'='(IL09007) Morton'
                  'IL09008'='(IL09008) North Pekin' 'IL09009'='(IL09009) Pekin'
                  'IL09010'='(IL09010) Washington' 'IL09011'='(IL09011) Mackinaw'
                  'IL09012'='(IL09012) South Pekin' 'IL09013'='(IL09013) Tremont'
                  'IL09014'='(IL09014) Green Valley'
                  'IL09015'='(IL09015) Illinois Central College'
                  'IL09016'='(IL09016) Pekin Park District' 'IL09019'='(IL09019) Deer Creek'
                  'IL09100'='(IL09100) Union' 'IL09101'='(IL09101) Anna' 'IL09102'='(IL09102) Cobden'
                  'IL09103'='(IL09103) Jonesboro' 'IL09104'='(IL09104) Dongola'
                  'IL09200'='(IL09200) Vermilion' 'IL09201'='(IL09201) Belgium'
                  'IL09202'='(IL09202) Catlin' 'IL09203'='(IL09203) Danville'
                  'IL09204'='(IL09204) Fairmount' 'IL09205'='(IL09205) Georgetown'
                  'IL09206'='(IL09206) Hoopeston' 'IL09207'='(IL09207) Potomac'
                  'IL09208'='(IL09208) Rankin' 'IL09209'='(IL09209) Ridge Farm'
                  'IL09210'='(IL09210) Rossville' 'IL09211'='(IL09211) Tilton'
                  'IL09212'='(IL09212) Westville' 'IL09213'='(IL09213) Oakwood'
                  'IL09216'='(IL09216) Sidell' 'IL09218'='(IL09218) Fithian' 'IL09219'='(IL09219) Henning'
                  'IL09220'='(IL09220) Indianola' 'IL09300'='(IL09300) Wabash'
                  'IL09301'='(IL09301) Mount Carmel' 'IL09400'='(IL09400) Warren'
                  'IL09401'='(IL09401) Alexis' 'IL09403'='(IL09403) Monmouth'
                  'IL09500'='(IL09500) Washington' 'IL09502'='(IL09502) Nashville'
                  'IL09503'='(IL09503) Okawville' 'IL09504'='(IL09504) Ashley' 'IL09600'='(IL09600) Wayne'
                  'IL09601'='(IL09601) Fairfield' 'IL09602'='(IL09602) Wayne City'
                  'IL09700'='(IL09700) White' 'IL09701'='(IL09701) Carmi' 'IL09702'='(IL09702) Grayville'
                  'IL09704'='(IL09704) Sp: Inv District 19' 'IL09706'='(IL09706) Enfield'
                  'IL09799'='(IL09799) Sp: District 19' 'IL09800'='(IL09800) Whiteside'
                  'IL09801'='(IL09801) Albany' 'IL09802'='(IL09802) Fulton' 'IL09803'='(IL09803) Lyndon'
                  'IL09804'='(IL09804) Morrison' 'IL09805'='(IL09805) Prophetstown'
                  'IL09806'='(IL09806) Rock Falls' 'IL09807'='(IL09807) Sterling'
                  'IL09808'='(IL09808) Tampico' 'IL09809'='(IL09809) Erie'
                  'IL09811'='(IL09811) Sp: Inv District 1' 'IL09899'='(IL09899) sp: District 1'
                  'IL09900'='(IL09900) will' 'IL09901'='(IL09901) Beecher'
                  'IL09902'='(IL09902) Bolingbrook' 'IL09903'='(IL09903) Braidwood'
                  'IL09904'='(IL09904) Crest Hill' 'IL09905'='(IL09905) Crete'
                  'IL09906'='(IL09906) Frankfort' 'IL09907'='(IL09907) Joliet'
                  'IL09908'='(IL09908) Lockport' 'IL09909'='(IL09909) Monee' 'IL09910'='(IL09910) Peotone'
                  'IL09911'='(IL09911) Plainfield' 'IL09912'='(IL09912) Rockdale'
                  'IL09913'='(IL09913) Romeoville' 'IL09914'='(IL09914) Wilmington'
                  'IL09915'='(IL09915) New Lenox' 'IL09916'='(IL09916) Manhattan'
                  'IL09917'='(IL09917) Elwood' 'IL09918'='(IL09918) Channahon'
                  'IL09920'='(IL09920) University Park' 'IL09921'='(IL09921) Shorewood'
                  'IL09922'='(IL09922) Mokena' 'IL09924'='(IL09924) Governors State Universi'
                  'IL09926'='(IL09926) Elgin Joliet Eastern Rwy'
                  'IL09927'='(IL09927) Sp: Inv District 5'
                  'IL09928'='(IL09928) metro Area Narcotics' 'IL09929'='(IL09929) Godley'
                  'IL09930'='(IL09930) Will Co Forest Preserve'
                  'IL09931'='(IL09931) Joilet Junior College'
                  'IL09999'='(IL09999) Sp: District 5' 'IL10000'='(IL10000) williamson'
                  'IL10001'='(IL10001) Carterville' 'IL10002'='(IL10002) Herrin'
                  'IL10003'='(IL10003) Johnston City' 'IL10004'='(IL10004) Marion'
                  'IL10008'='(IL10008) Energy' 'IL10011'='(IL10011) John A. logan College'
                  'IL10012'='(IL10012) Sp: Inv District 13' 'IL10100'='(IL10100) Winnebago'
                  'IL10101'='(IL10101) Cherry Valley' 'IL10102'='(IL10102) Loves Park'
                  'IL10103'='(IL10103) Pecatonica' 'IL10104'='(IL10104) Rockford'
                  'IL10105'='(IL10105) Rockton' 'IL10106'='(IL10106) Roscoe'
                  'IL10107'='(IL10107) South Beloit' 'IL10109'='(IL10109) Winnebago'
                  'IL10110'='(IL10110) Durand' 'IL10111'='(IL10111) Morristown'
                  'IL10112'='(IL10112) Rock Valley College'
                  'IL10113'='(IL10113) Rockford Park District'
                  'IL10114'='(IL10114) Greater Rockford Airport'
                  'IL10115'='(IL10115) Sp: Inv District 16'
                  'IL10116'='(IL10116) S sp: District 2' 'IL10117'='(IL10117) machesney Park'
                  'IL10119'='(IL10119) S sp: Auto Theft Dist 5'
                  'IL10199'='(IL10199) sp: District 16' 'IL10200'='(IL10200) Woodford'
                  'IL10201'='(IL10201) El Paso' 'IL10202'='(IL10202) Eureka' 'IL10203'='(IL10203) Metamora'
                  'IL10204'='(IL10204) Minonk' 'IL10205'='(IL10205) Roanoke' 'IL10206'='(IL10206) Washburn'
                  'IL10209'='(IL10209) Secor' 'IL10299'='(IL10299) Sp: District 8'
                  'ILCPD00'='(ILCPD00) Chicago' 'IN00100'='(IN00100) Adams' 'IN00101'='(IN00101) Berne'
                  'IN00102'='(IN00102) Decatur' 'IN00200'='(IN00200) Allen'
                  'IN00201'='(IN00201) Fort Wayne' 'IN00202'='(IN00202) New Haven'
                  'IN00300'='(IN00300) Bartholomew' 'IN00301'='(IN00301) Columbus'
                  'IN00400'='(IN00400) Benton' 'IN00401'='(IN00401) Fowler' 'IN00500'='(IN00500) Blackford'
                  'IN00501'='(IN00501) Hartford City' 'IN00600'='(IN00600) Boone'
                  'IN00601'='(IN00601) Lebanon' 'IN00605'='(IN00605) Whitestown'
                  'IN00700'='(IN00700) Brown' 'IN00800'='(IN00800) Carroll' 'IN00801'='(IN00801) Delphi'
                  'IN00900'='(IN00900) Cass' 'IN00901'='(IN00901) Logansport' 'IN01000'='(IN01000) Clark'
                  'IN01001'='(IN01001) Charlestown' 'IN01002'='(IN01002) Clarksville'
                  'IN01003'='(IN01003) Jeffersonville' 'IN01004'='(IN01004) Sellersburg'
                  'IN01100'='(IN01100) Clay' 'IN01101'='(IN01101) Brazil' 'IN01200'='(IN01200) Clinton'
                  'IN01201'='(IN01201) Frankfort' 'IN01300'='(IN01300) Crawford'
                  'IN01400'='(IN01400) Daviess' 'IN01401'='(IN01401) Washington'
                  'IN01500'='(IN01500) Dearborn' 'IN01501'='(IN01501) Aurora'
                  'IN01502'='(IN01502) Lawrenceburg' 'IN01503'='(IN01503) Greendale'
                  'IN01600'='(IN01600) Decatur' 'IN01601'='(IN01601) Greensburg'
                  'IN01700'='(IN01700) De Kalb' 'IN01701'='(IN01701) Auburn' 'IN01703'='(IN01703) Garrett'
                  'IN01704'='(IN01704) Waterloo' 'IN01800'='(IN01800) Delaware'
                  'IN01801'='(IN01801) Muncie' 'IN01805'='(IN01805) Ball State University'
                  'IN01900'='(IN01900) Dubois' 'IN01901'='(IN01901) Huntingburg'
                  'IN01902'='(IN01902) Jasper' 'IN02000'='(IN02000) Elkhart' 'IN02001'='(IN02001) Elkhart'
                  'IN02002'='(IN02002) Goshen' 'IN02003'='(IN02003) Nappanee' 'IN02100'='(IN02100) Fayette'
                  'IN02101'='(IN02101) Connersville' 'IN02200'='(IN02200) Floyd'
                  'IN02201'='(IN02201) New Albany' 'IN02202'='(IN02202) Indiana Univ: New Albany'
                  'IN02203'='(IN02203) Georgetown' 'IN02300'='(IN02300) Fountain'
                  'IN02301'='(IN02301) Attica' 'IN02302'='(IN02302) Covington'
                  'IN02400'='(IN02400) Franklin' 'IN02401'='(IN02401) Brookville'
                  'IN02500'='(IN02500) Fulton' 'IN02501'='(IN02501) Rochester' 'IN02600'='(IN02600) Gibson'
                  'IN02601'='(IN02601) Princeton' 'IN02602'='(IN02602) Oakland City'
                  'IN02700'='(IN02700) Grant' 'IN02701'='(IN02701) Gas City' 'IN02702'='(IN02702) Marion'
                  'IN02703'='(IN02703) Fairmount' 'IN02800'='(IN02800) Greene'
                  'IN02802'='(IN02802) Jasonville' 'IN02803'='(IN02803) Linton'
                  'IN02900'='(IN02900) Hamilton' 'IN02901'='(IN02901) Carmel'
                  'IN02902'='(IN02902) Noblesville' 'IN02904'='(IN02904) Westfield'
                  'IN02907'='(IN02907) Fishers' 'IN03000'='(IN03000) Hancock'
                  'IN03001'='(IN03001) Greenfield' 'IN03100'='(IN03100) Harrison'
                  'IN03101'='(IN03101) Corydon' 'IN03200'='(IN03200) Hendricks'
                  'IN03201'='(IN03201) Brownsburg' 'IN03202'='(IN03202) Danville'
                  'IN03203'='(IN03203) Plainfield' 'IN03300'='(IN03300) Henry'
                  'IN03302'='(IN03302) New Castle' 'IN03400'='(IN03400) Howard'
                  'IN03401'='(IN03401) Kokomo' 'IN03500'='(IN03500) Huntington'
                  'IN03501'='(IN03501) Huntington' 'IN03600'='(IN03600) Jackson'
                  'IN03602'='(IN03602) Seymour' 'IN03700'='(IN03700) Jasper'
                  'IN03701'='(IN03701) Rensselaer' 'IN03800'='(IN03800) Jay' 'IN03801'='(IN03801) Dunkirk'
                  'IN03802'='(IN03802) Portland' 'IN03900'='(IN03900) Jefferson'
                  'IN03901'='(IN03901) Madison' 'IN04000'='(IN04000) Jennings'
                  'IN04001'='(IN04001) North Vernon' 'IN04100'='(IN04100) Johnson'
                  'IN04101'='(IN04101) Edinburgh' 'IN04102'='(IN04102) Franklin'
                  'IN04103'='(IN04103) Greenwood' 'IN04104'='(IN04104) New Whiteland'
                  'IN04105'='(IN04105) Princes Lakes' 'IN04108'='(IN04108) Bargersville'
                  'IN04200'='(IN04200) Knox' 'IN04201'='(IN04201) Bicknell' 'IN04202'='(IN04202) Vincennes'
                  'IN04300'='(IN04300) Kosciusko' 'IN04301'='(IN04301) Warsaw'
                  'IN04302'='(IN04302) Winona Lake' 'IN04400'='(IN04400) Lagrange'
                  'IN04500'='(IN04500) Lake' 'IN04501'='(IN04501) Cedar Lake'
                  'IN04502'='(IN04502) Crown Point' 'IN04503'='(IN04503) East Chicago'
                  'IN04504'='(IN04504) Lake Station' 'IN04505'='(IN04505) Gary'
                  'IN04506'='(IN04506) Griffith' 'IN04507'='(IN04507) Hammond'
                  'IN04508'='(IN04508) Highland' 'IN04509'='(IN04509) Hobart' 'IN04510'='(IN04510) Munster'
                  'IN04511'='(IN04511) Whiting' 'IN04512'='(IN04512) Lowell' 'IN04513'='(IN04513) Dyer'
                  'IN04514'='(IN04514) Merrillville' 'IN04515'='(IN04515) St. John'
                  'IN04516'='(IN04516) Schererville' 'IN04517'='(IN04517) New Chicago'
                  'IN04518'='(IN04518) Indiana Univ: Gary' 'IN04600'='(IN04600) La Porte'
                  'IN04601'='(IN04601) La Porte' 'IN04602'='(IN04602) Michigan City'
                  'IN04603'='(IN04603) Long Beach' 'IN04604'='(IN04604) Kingsford Heights'
                  'IN04605'='(IN04605) Trail Creek' 'IN04607'='(IN04607) Westville'
                  'IN04613'='(IN04613) Northern In Commuter Tra' 'IN04700'='(IN04700) Lawrence'
                  'IN04701'='(IN04701) Bedford' 'IN04702'='(IN04702) Mitchell'
                  'IN04800'='(IN04800) Madison' 'IN04801'='(IN04801) Alexandria'
                  'IN04802'='(IN04802) Anderson' 'IN04803'='(IN04803) Elwood'
                  'IN04807'='(IN04807) Chesterfield' 'IN04900'='(IN04900) Marion'
                  'IN04901'='(IN04901) Beech Grove' 'IN04902'='(IN04902) Lawrence'
                  'IN04903'='(IN04903) Speedway' 'IN04904'='(IN04904) Indiana Un:Indianapolis'
                  'IN04935'='(IN04935) Marian College' 'IN05000'='(IN05000) Marshall'
                  'IN05001'='(IN05001) Bremen' 'IN05002'='(IN05002) Plymouth' 'IN05005'='(IN05005) Culver'
                  'IN05100'='(IN05100) Martin' 'IN05101'='(IN05101) Loogootee' 'IN05200'='(IN05200) Miami'
                  'IN05201'='(IN05201) Peru' 'IN05300'='(IN05300) Monroe' 'IN05301'='(IN05301) Bloomington'
                  'IN05302'='(IN05302) Indiana Univ:Bloomington' 'IN05400'='(IN05400) Montgomery'
                  'IN05401'='(IN05401) Crawfordsville' 'IN05500'='(IN05500) Morgan'
                  'IN05501'='(IN05501) Martinsville' 'IN05502'='(IN05502) Mooresville'
                  'IN05600'='(IN05600) Newton' 'IN05700'='(IN05700) Noble'
                  'IN05701'='(IN05701) Kendallville' 'IN05702'='(IN05702) Ligonier'
                  'IN05703'='(IN05703) Albion' 'IN05800'='(IN05800) Ohio' 'IN05900'='(IN05900) Orange'
                  'IN05901'='(IN05901) Paoli' 'IN06000'='(IN06000) Owen' 'IN06001'='(IN06001) Spencer'
                  'IN06100'='(IN06100) Parke' 'IN06101'='(IN06101) Rockville' 'IN06200'='(IN06200) Perry'
                  'IN06201'='(IN06201) Tell City' 'IN06300'='(IN06300) Pike'
                  'IN06301'='(IN06301) Petersburg' 'IN06400'='(IN06400) Porter'
                  'IN06401'='(IN06401) Chesterton' 'IN06402'='(IN06402) Portage'
                  'IN06403'='(IN06403) Valparaiso' 'IN06404'='(IN06404) Burns Harbor'
                  'IN06410'='(IN06410) Hebron' 'IN06411'='(IN06411) Kouts' 'IN06500'='(IN06500) Posey'
                  'IN06501'='(IN06501) Mount Vernon' 'IN06600'='(IN06600) Pulaski'
                  'IN06700'='(IN06700) Putnam' 'IN06701'='(IN06701) Greencastle'
                  'IN06707'='(IN06707) Depauw University' 'IN06800'='(IN06800) Randolph'
                  'IN06801'='(IN06801) Union City' 'IN06802'='(IN06802) Winchester'
                  'IN06804'='(IN06804) Lynn' 'IN06900'='(IN06900) Ripley' 'IN06901'='(IN06901) Batesville'
                  'IN07000'='(IN07000) Rush' 'IN07001'='(IN07001) Rushville'
                  'IN07100'='(IN07100) St. Joseph' 'IN07101'='(IN07101) Mishawaka'
                  'IN07102'='(IN07102) South Bend' 'IN07103'='(IN07103) Walkerton'
                  'IN07106'='(IN07106) North Liberty' 'IN07107'='(IN07107) Roseland'
                  'IN07108'='(IN07108) Indiana Univ: South Bend'
                  'IN07111'='(IN07111) St. Joseph Co Airport Au' 'IN07200'='(IN07200) Scott'
                  'IN07201'='(IN07201) Scottsburg' 'IN07202'='(IN07202) Austin'
                  'IN07300'='(IN07300) Shelby' 'IN07301'='(IN07301) Shelbyville'
                  'IN07400'='(IN07400) Spencer' 'IN07500'='(IN07500) Starke' 'IN07501'='(IN07501) Knox'
                  'IN07600'='(IN07600) Steuben' 'IN07601'='(IN07601) Angola' 'IN07700'='(IN07700) Sullivan'
                  'IN07701'='(IN07701) Sullivan' 'IN07800'='(IN07800) Switzerland'
                  'IN07900'='(IN07900) Tippecanoe' 'IN07901'='(IN07901) Lafayette'
                  'IN07902'='(IN07902) West Lafayette' 'IN07903'='(IN07903) Purdue University'
                  'IN07906'='(IN07906) Clarks Hill' 'IN08000'='(IN08000) Tipton'
                  'IN08001'='(IN08001) Tipton' 'IN08100'='(IN08100) Union'
                  'IN08200'='(IN08200) Vanderburgh' 'IN08201'='(IN08201) Evansville'
                  'IN08300'='(IN08300) Vermillion' 'IN08301'='(IN08301) Clinton' 'IN08400'='(IN08400) Vigo'
                  'IN08401'='(IN08401) Terre Haute' 'IN08402'='(IN08402) West Terre Haute'
                  'IN08403'='(IN08403) Indiana State University' 'IN08500'='(IN08500) Wabash'
                  'IN08501'='(IN08501) North Manchester' 'IN08502'='(IN08502) Wabash'
                  'IN08600'='(IN08600) Warren' 'IN08700'='(IN08700) Warrick'
                  'IN08701'='(IN08701) Boonville' 'IN08800'='(IN08800) Washington'
                  'IN08801'='(IN08801) Salem' 'IN08900'='(IN08900) Wayne' 'IN08901'='(IN08901) Richmond'
                  'IN08902'='(IN08902) Cambridge City' 'IN08904'='(IN08904) Hagerstown'
                  'IN09000'='(IN09000) Wells' 'IN09001'='(IN09001) Bluffton' 'IN09100'='(IN09100) White'
                  'IN09101'='(IN09101) Monticello' 'IN09200'='(IN09200) Whitley'
                  'IN09201'='(IN09201) Columbia City' 'IN09203'='(IN09203) South Whitley'
                  'IN301SP'='(IN301SP) Sp: Adams County' 'IN302SP'='(IN302SP) Sp: Allen County'
                  'IN303SP'='(IN303SP) Sp: Bartholomew County'
                  'IN304SP'='(IN304SP) Sp: Benton County'
                  'IN305SP'='(IN305SP) Sp: Blackford County'
                  'IN306SP'='(IN306SP) Sp: Boone County' 'IN307SP'='(IN307SP) Sp: Brown County'
                  'IN308SP'='(IN308SP) Sp: Carroll County' 'IN309SP'='(IN309SP) Sp: Cass County'
                  'IN310SP'='(IN310SP) Sp: Clark County' 'IN311SP'='(IN311SP) Sp: Clay County'
                  'IN312SP'='(IN312SP) Sp: Clinton County'
                  'IN313SP'='(IN313SP) Sp: Crawford County'
                  'IN314SP'='(IN314SP) Sp: Daviess County'
                  'IN315SP'='(IN315SP) Sp: Dearborn County'
                  'IN316SP'='(IN316SP) Sp: Decatur County'
                  'IN317SP'='(IN317SP) Sp: De Kalb County'
                  'IN318SP'='(IN318SP) Sp: Delaware County'
                  'IN319SP'='(IN319SP) Sp: Dubois County'
                  'IN320SP'='(IN320SP) Sp: Elkhart County'
                  'IN321SP'='(IN321SP) Sp: Fayette County' 'IN322SP'='(IN322SP) Sp: Floyd County'
                  'IN323SP'='(IN323SP) Sp: Fountain County'
                  'IN324SP'='(IN324SP) Sp: Franklin County'
                  'IN325SP'='(IN325SP) Sp: Fulton County' 'IN326SP'='(IN326SP) Sp: Gibson County'
                  'IN327SP'='(IN327SP) Sp: Grant County' 'IN328SP'='(IN328SP) Sp: Greene County'
                  'IN329SP'='(IN329SP) Sp: Hamilton County'
                  'IN330SP'='(IN330SP) Sp: Hancock County'
                  'IN331SP'='(IN331SP) Sp: Harrison County'
                  'IN332SP'='(IN332SP) Sp: Hendricks County'
                  'IN333SP'='(IN333SP) Sp: Henry County' 'IN334SP'='(IN334SP) Sp: Howard County'
                  'IN335SP'='(IN335SP) Sp: Huntington County'
                  'IN336SP'='(IN336SP) Sp: Jackson County'
                  'IN337SP'='(IN337SP) Sp: Jasper County' 'IN338SP'='(IN338SP) Sp: Jay County'
                  'IN339SP'='(IN339SP) Sp: Jefferson County'
                  'IN340SP'='(IN340SP) Sp: Jennings County'
                  'IN341SP'='(IN341SP) Sp: Johnson County' 'IN342SP'='(IN342SP) Sp: Knox County'
                  'IN343SP'='(IN343SP) Sp: Kosciusko County'
                  'IN344SP'='(IN344SP) Sp: Lagrange County' 'IN345SP'='(IN345SP) Sp: Lake County'
                  'IN346SP'='(IN346SP) Sp: La Porte County'
                  'IN347SP'='(IN347SP) Sp: Lawrence County'
                  'IN348SP'='(IN348SP) Sp: Madison County'
                  'IN349SP'='(IN349SP) Sp: Marion County'
                  'IN350SP'='(IN350SP) Sp: Marshall County'
                  'IN351SP'='(IN351SP) Sp: Martin County' 'IN352SP'='(IN352SP) Sp: Miami County'
                  'IN353SP'='(IN353SP) Sp: Monroe County'
                  'IN354SP'='(IN354SP) Sp: Montgomery County'
                  'IN355SP'='(IN355SP) Sp: Morgan County' 'IN356SP'='(IN356SP) Sp: Newton County'
                  'IN357SP'='(IN357SP) Sp: Noble County' 'IN358SP'='(IN358SP) Sp: Ohio County'
                  'IN359SP'='(IN359SP) Sp: Orange County' 'IN360SP'='(IN360SP) Sp: Owen County'
                  'IN361SP'='(IN361SP) Sp: Parke County' 'IN362SP'='(IN362SP) Sp: Perry County'
                  'IN363SP'='(IN363SP) Sp: Pike County' 'IN364SP'='(IN364SP) Sp: Porter County'
                  'IN365SP'='(IN365SP) Sp: Posey County' 'IN366SP'='(IN366SP) Sp: Pulaski County'
                  'IN367SP'='(IN367SP) Sp: Putnam County'
                  'IN368SP'='(IN368SP) Sp: Randolph County'
                  'IN369SP'='(IN369SP) Sp: Ripley County' 'IN370SP'='(IN370SP) Sp: Rush County'
                  'IN371SP'='(IN371SP) Sp: St. Joseph County'
                  'IN372SP'='(IN372SP) Sp: Scott County' 'IN373SP'='(IN373SP) Sp: Shelby County'
                  'IN374SP'='(IN374SP) Sp: Spencer County'
                  'IN375SP'='(IN375SP) Sp: Starke County'
                  'IN376SP'='(IN376SP) Sp: Steuben County'
                  'IN377SP'='(IN377SP) Sp: Sullivan County'
                  'IN378SP'='(IN378SP) Sp: Switzerland County'
                  'IN379SP'='(IN379SP) Sp: Tippecanoe County'
                  'IN380SP'='(IN380SP) Sp: Tipton County' 'IN381SP'='(IN381SP) Sp: Union County'
                  'IN382SP'='(IN382SP) Sp: Vanderburgh County'
                  'IN383SP'='(IN383SP) Sp: Vermillion County'
                  'IN384SP'='(IN384SP) Sp: Vigo County' 'IN385SP'='(IN385SP) Sp: Wabash County'
                  'IN386SP'='(IN386SP) Sp: Warren County'
                  'IN387SP'='(IN387SP) Sp: Warrick County'
                  'IN388SP'='(IN388SP) Sp: Washington County'
                  'IN389SP'='(IN389SP) Sp: Wayne County' 'IN390SP'='(IN390SP) Sp: Wells County'
                  'IN391SP'='(IN391SP) Sp: White County' 'IN392SP'='(IN392SP) Sp: Whitley County'
                  'INIPD00'='(INIPD00) indianapolis' 'INISP00'='(INISP00) Indiana State Police'
                  'KS00100'='(KS00100) Allen' 'KS00101'='(KS00101) Humboldt' 'KS00102'='(KS00102) Iola'
                  'KS00103'='(KS00103) Moran' 'KS00104'='(KS00104) La Harpe' 'KS00200'='(KS00200) Anderson'
                  'KS00201'='(KS00201) Garnett' 'KS00202'='(KS00202) Colony' 'KS00203'='(KS00203) Greeley'
                  'KS00204'='(KS00204) Kincaid' 'KS00300'='(KS00300) Atchison'
                  'KS00301'='(KS00301) Atchison' 'KS00400'='(KS00400) Barber' 'KS00401'='(KS00401) Kiowa'
                  'KS00402'='(KS00402) Medicine Lodge' 'KS00500'='(KS00500) Barton'
                  'KS00501'='(KS00501) Ellinwood' 'KS00502'='(KS00502) Great Bend'
                  'KS00503'='(KS00503) Hoisington' 'KS00504'='(KS00504) Claflin'
                  'KS00505'='(KS00505) Pawnee Rock' 'KS00600'='(KS00600) Bourbon'
                  'KS00601'='(KS00601) Fort Scott' 'KS00700'='(KS00700) Brown'
                  'KS00701'='(KS00701) Hiawatha' 'KS00702'='(KS00702) Horton' 'KS00800'='(KS00800) Butler'
                  'KS00801'='(KS00801) Augusta' 'KS00802'='(KS00802) El Dorado'
                  'KS00803'='(KS00803) Douglass' 'KS00804'='(KS00804) Towanda'
                  'KS00805'='(KS00805) Andover' 'KS00806'='(KS00806) Rose Hill' 'KS00807'='(KS00807) Leon'
                  'KS00808'='(KS00808) Benton' 'KS00810'='(KS00810) Usd: Bluestem'
                  'KS00900'='(KS00900) Chase' 'KS01000'='(KS01000) Chautauqua' 'KS01001'='(KS01001) Sedan'
                  'KS01002'='(KS01002) Cedar Vale' 'KS01100'='(KS01100) Cherokee'
                  'KS01101'='(KS01101) Columbus' 'KS01102'='(KS01102) Galena'
                  'KS01103'='(KS01103) Baxter Springs' 'KS01104'='(KS01104) Weir'
                  'KS01107'='(KS01107) West Mineral' 'KS01200'='(KS01200) Cheyenne'
                  'KS01201'='(KS01201) St. Francis' 'KS01202'='(KS01202) Bird City'
                  'KS01300'='(KS01300) Clark' 'KS01400'='(KS01400) Clay' 'KS01401'='(KS01401) Clay Center'
                  'KS01402'='(KS01402) Wakefield' 'KS01403'='(KS01403) Clifton' 'KS01500'='(KS01500) Cloud'
                  'KS01501'='(KS01501) Concordia' 'KS01502'='(KS01502) Clyde'
                  'KS01506'='(KS01506) Miltonvale' 'KS01600'='(KS01600) Coffey'
                  'KS01601'='(KS01601) Burlington' 'KS01603'='(KS01603) Lebo' 'KS01604'='(KS01604) Waverly'
                  'KS01605'='(KS01605) Le Roy' 'KS01700'='(KS01700) Comanche'
                  'KS01701'='(KS01701) Coldwater' 'KS01702'='(KS01702) Protection'
                  'KS01800'='(KS01800) Cowley' 'KS01801'='(KS01801) Arkansas City'
                  'KS01802'='(KS01802) Winfield' 'KS01803'='(KS01803) Burden' 'KS01804'='(KS01804) Udall'
                  'KS01900'='(KS01900) Crawford' 'KS01901'='(KS01901) Pittsburg' 'KS01902'='(KS01902) Arma'
                  'KS01903'='(KS01903) Girard' 'KS01904'='(KS01904) Frontenac'
                  'KS01905'='(KS01905) Cherokee' 'KS01906'='(KS01906) Mccune'
                  'KS01907'='(KS01907) Pittsburg State Univ' 'KS01908'='(KS01908) Arcadia'
                  'KS01909'='(KS01909) Mulberry' 'KS02000'='(KS02000) Decatur'
                  'KS02001'='(KS02001) Oberlin' 'KS02100'='(KS02100) Dickinson'
                  'KS02101'='(KS02101) Abilene' 'KS02102'='(KS02102) Herington'
                  'KS02103'='(KS02103) Chapman' 'KS02104'='(KS02104) Enterprise'
                  'KS02105'='(KS02105) Solomon' 'KS02106'='(KS02106) Hope' 'KS02200'='(KS02200) Doniphan'
                  'KS02201'='(KS02201) Elwood' 'KS02202'='(KS02202) Troy' 'KS02203'='(KS02203) Wathena'
                  'KS02204'='(KS02204) Highland' 'KS02300'='(KS02300) Douglas'
                  'KS02301'='(KS02301) Lawrence' 'KS02302'='(KS02302) Univ Of Ks: Main Campus'
                  'KS02303'='(KS02303) Baldwin City' 'KS02304'='(KS02304) Eudora'
                  'KS02400'='(KS02400) Edwards' 'KS02401'='(KS02401) Kinsley' 'KS02402'='(KS02402) Lewis'
                  'KS02500'='(KS02500) Elk' 'KS02600'='(KS02600) Ellis' 'KS02601'='(KS02601) Hays'
                  'KS02602'='(KS02602) Ellis' 'KS02603'='(KS02603) Victoria'
                  'KS02604'='(KS02604) Fort Hays State Universi' 'KS02700'='(KS02700) Ellsworth'
                  'KS02701'='(KS02701) Ellsworth' 'KS02702'='(KS02702) Wilson'
                  'KS02703'='(KS02703) Kanopolis' 'KS02704'='(KS02704) Holyrood'
                  'KS02800'='(KS02800) Finney' 'KS02801'='(KS02801) Garden City'
                  'KS02802'='(KS02802) Holcomb' 'KS02803'='(KS02803) Garden City Comm College'
                  'KS02900'='(KS02900) Ford' 'KS02901'='(KS02901) Dodge City' 'KS02902'='(KS02902) Bucklin'
                  'KS02903'='(KS02903) Spearville' 'KS03000'='(KS03000) Franklin'
                  'KS03001'='(KS03001) Ottawa' 'KS03002'='(KS03002) Wellsville'
                  'KS03004'='(KS03004) Pomona' 'KS03006'='(KS03006) Richmond'
                  'KS03007'='(KS03007) Franklin Cnty Drug Enfor' 'KS03100'='(KS03100) Geary'
                  'KS03101'='(KS03101) Junction City' 'KS03102'='(KS03102) Grandview Plaza'
                  'KS03200'='(KS03200) Gove' 'KS03201'='(KS03201) Quinter' 'KS03300'='(KS03300) Graham'
                  'KS03301'='(KS03301) Hill City' 'KS03400'='(KS03400) Grant' 'KS03401'='(KS03401) Ulysses'
                  'KS03500'='(KS03500) Gray' 'KS03501'='(KS03501) Cimarron' 'KS03502'='(KS03502) Ensign'
                  'KS03600'='(KS03600) Greeley' 'KS03601'='(KS03601) Tribune'
                  'KS03700'='(KS03700) Greenwood' 'KS03701'='(KS03701) Eureka'
                  'KS03702'='(KS03702) Madison' 'KS03800'='(KS03800) Hamilton' 'KS03900'='(KS03900) Harper'
                  'KS03901'='(KS03901) Anthony' 'KS03902'='(KS03902) Attica' 'KS03903'='(KS03903) Harper'
                  'KS04000'='(KS04000) Harvey' 'KS04001'='(KS04001) Newton' 'KS04002'='(KS04002) Hesston'
                  'KS04003'='(KS04003) Halstead' 'KS04004'='(KS04004) Sedgwick'
                  'KS04005'='(KS04005) Burrton' 'KS04006'='(KS04006) North Newton'
                  'KS04007'='(KS04007) Walton' 'KS04100'='(KS04100) Haskell' 'KS04101'='(KS04101) Sublette'
                  'KS04102'='(KS04102) Satanta' 'KS04200'='(KS04200) Hodgeman'
                  'KS04300'='(KS04300) Jackson' 'KS04301'='(KS04301) Holton' 'KS04302'='(KS04302) Hoyt'
                  'KS04303'='(KS04303) Denison' 'KS04304'='(KS04304) Mayetta'
                  'KS04400'='(KS04400) Jefferson' 'KS04401'='(KS04401) Perry State Park'
                  'KS04402'='(KS04402) Valley Falls' 'KS04403'='(KS04403) Meriden'
                  'KS04404'='(KS04404) Mclouth' 'KS04405'='(KS04405) Nortonville'
                  'KS04406'='(KS04406) Oskaloosa' 'KS04407'='(KS04407) Winchester'
                  'KS04408'='(KS04408) Perry' 'KS04409'='(KS04409) Ozawkie' 'KS04500'='(KS04500) Jewell'
                  'KS04600'='(KS04600) Johnson' 'KS04601'='(KS04601) Fairway' 'KS04602'='(KS04602) Leawood'
                  'KS04603'='(KS04603) Merriam' 'KS04604'='(KS04604) Mission' 'KS04605'='(KS04605) Olathe'
                  'KS04606'='(KS04606) Overland Park' 'KS04607'='(KS04607) Prairie Village'
                  'KS04608'='(KS04608) Roeland Park' 'KS04609'='(KS04609) Shawnee'
                  'KS04610'='(KS04610) Lenexa' 'KS04611'='(KS04611) Westwood' 'KS04612'='(KS04612) Gardner'
                  'KS04613'='(KS04613) Mission Hills' 'KS04617'='(KS04617) Spring Hill'
                  'KS04619'='(KS04619) Edgerton' 'KS04620'='(KS04620) Johnson County Park'
                  'KS04622'='(KS04622) Mission Woods' 'KS04623'='(KS04623) Westwood Hills'
                  'KS04624'='(KS04624) Lake Quivira'
                  'KS04625'='(KS04625) Shawnee Mission Pub Schs'
                  'KS04626'='(KS04626) Blue Valley School Dist' 'KS04700'='(KS04700) Kearny'
                  'KS04800'='(KS04800) Kingman' 'KS04801'='(KS04801) Kingman' 'KS04803'='(KS04803) Norwich'
                  'KS04900'='(KS04900) Kiowa' 'KS05000'='(KS05000) Labette' 'KS05001'='(KS05001) Parsons'
                  'KS05002'='(KS05002) Oswego' 'KS05003'='(KS05003) Chetopa' 'KS05004'='(KS05004) Altamont'
                  'KS05005'='(KS05005) Edna' 'KS05006'='(KS05006) Mound Valley' 'KS05100'='(KS05100) Lane'
                  'KS05200'='(KS05200) Leavenworth' 'KS05201'='(KS05201) Leavenworth'
                  'KS05202'='(KS05202) Tonganoxie' 'KS05203'='(KS05203) Lansing'
                  'KS05205'='(KS05205) Basehor' 'KS05300'='(KS05300) Lincoln' 'KS05400'='(KS05400) Linn'
                  'KS05401'='(KS05401) Mound City' 'KS05402'='(KS05402) Pleasanton'
                  'KS05403'='(KS05403) La Cygne' 'KS05404'='(KS05404) Parker'
                  'KS05405'='(KS05405) Linn Valley' 'KS05500'='(KS05500) Logan'
                  'KS05501'='(KS05501) Oakley' 'KS05600'='(KS05600) Lyon' 'KS05601'='(KS05601) Emporia'
                  'KS05602'='(KS05602) Emporia State University' 'KS05603'='(KS05603) Americus'
                  'KS05700'='(KS05700) Mcpherson' 'KS05701'='(KS05701) Mcpherson'
                  'KS05702'='(KS05702) Lindsborg' 'KS05703'='(KS05703) Galva'
                  'KS05704'='(KS05704) Moundridge' 'KS05706'='(KS05706) Marquette'
                  'KS05708'='(KS05708) Inman' 'KS05709'='(KS05709) Canton' 'KS05800'='(KS05800) Marion'
                  'KS05801'='(KS05801) Hillsboro' 'KS05802'='(KS05802) Marion'
                  'KS05803'='(KS05803) Peabody' 'KS05804'='(KS05804) Florence'
                  'KS05805'='(KS05805) Goessel' 'KS05806'='(KS05806) Burns' 'KS05900'='(KS05900) Marshall'
                  'KS05901'='(KS05901) Marysville' 'KS05902'='(KS05902) Blue Rapids'
                  'KS05903'='(KS05903) Frankfort' 'KS05904'='(KS05904) Waterville'
                  'KS06000'='(KS06000) Meade' 'KS06001'='(KS06001) Meade' 'KS06100'='(KS06100) Miami'
                  'KS06101'='(KS06101) Paola' 'KS06102'='(KS06102) Osawatomie'
                  'KS06103'='(KS06103) Louisburg' 'KS06200'='(KS06200) Mitchell'
                  'KS06201'='(KS06201) Beloit' 'KS06203'='(KS06203) Cawker City'
                  'KS06300'='(KS06300) Montgomery' 'KS06301'='(KS06301) Coffeyville'
                  'KS06302'='(KS06302) Independence' 'KS06303'='(KS06303) Cherryvale'
                  'KS06304'='(KS06304) Caney' 'KS06400'='(KS06400) Morris'
                  'KS06401'='(KS06401) Council Grove' 'KS06402'='(KS06402) White City'
                  'KS06500'='(KS06500) Morton' 'KS06501'='(KS06501) Elkhart' 'KS06502'='(KS06502) Rolla'
                  'KS06600'='(KS06600) Nemaha' 'KS06601'='(KS06601) Sabetha' 'KS06602'='(KS06602) Seneca'
                  'KS06700'='(KS06700) Neosho' 'KS06701'='(KS06701) Chanute' 'KS06702'='(KS06702) Erie'
                  'KS06800'='(KS06800) Ness' 'KS06801'='(KS06801) Ness City' 'KS06900'='(KS06900) Norton'
                  'KS06901'='(KS06901) Norton' 'KS07000'='(KS07000) Osage' 'KS07001'='(KS07001) Osage City'
                  'KS07002'='(KS07002) Burlingame' 'KS07003'='(KS07003) Carbondale'
                  'KS07004'='(KS07004) Lyndon' 'KS07005'='(KS07005) Overbrook'
                  'KS07006'='(KS07006) Scranton' 'KS07007'='(KS07007) Quenemo'
                  'KS07008'='(KS07008) Melvern' 'KS07100'='(KS07100) Osborne' 'KS07101'='(KS07101) Osborne'
                  'KS07102'='(KS07102) Downs' 'KS07200'='(KS07200) Ottawa' 'KS07201'='(KS07201) Delphos'
                  'KS07202'='(KS07202) Minneapolis' 'KS07300'='(KS07300) Pawnee'
                  'KS07301'='(KS07301) Larned' 'KS07400'='(KS07400) Phillips'
                  'KS07401'='(KS07401) Phillipsburg' 'KS07402'='(KS07402) Logan'
                  'KS07500'='(KS07500) Pottawatomie' 'KS07501'='(KS07501) St. Marys'
                  'KS07502'='(KS07502) Wamego' 'KS07504'='(KS07504) St. George' 'KS07600'='(KS07600) Pratt'
                  'KS07601'='(KS07601) Pratt' 'KS07602'='(KS07602) Ks Dpt Of Wi & Pks'
                  'KS07700'='(KS07700) Rawlins' 'KS07701'='(KS07701) Atwood' 'KS07800'='(KS07800) Reno'
                  'KS07801'='(KS07801) Hutchinson' 'KS07802'='(KS07802) South Hutchinson'
                  'KS07803'='(KS07803) Haven' 'KS07804'='(KS07804) Nickerson' 'KS07806'='(KS07806) Buhler'
                  'KS07808'='(KS07808) Pretty Prairie' 'KS07900'='(KS07900) Republic'
                  'KS07901'='(KS07901) Belleville' 'KS08000'='(KS08000) Rice' 'KS08001'='(KS08001) Lyons'
                  'KS08002'='(KS08002) Sterling' 'KS08003'='(KS08003) Bushton'
                  'KS08004'='(KS08004) Geneseo' 'KS08005'='(KS08005) Little River'
                  'KS08006'='(KS08006) Chase' 'KS08100'='(KS08100) Riley County Police Dept'
                  'KS08101'='(KS08101) Manhattan' 'KS08102'='(KS08102) Kansas State University'
                  'KS08200'='(KS08200) Rooks' 'KS08201'='(KS08201) Plainville'
                  'KS08202'='(KS08202) Stockton' 'KS08300'='(KS08300) Rush' 'KS08301'='(KS08301) La Crosse'
                  'KS08400'='(KS08400) Russell' 'KS08401'='(KS08401) Russell' 'KS08500'='(KS08500) Saline'
                  'KS08501'='(KS08501) Salina' 'KS08502'='(KS08502) Assaria' 'KS08600'='(KS08600) Scott'
                  'KS08601'='(KS08601) Scott City' 'KS08700'='(KS08700) Sedgwick'
                  'KS08701'='(KS08701) Derby' 'KS08702'='(KS08702) Haysville' 'KS08703'='(KS08703) Wichita'
                  'KS08705'='(KS08705) Valley Center'
                  'KS08706'='(KS08706) Wichita State University' 'KS08707'='(KS08707) Colwich'
                  'KS08708'='(KS08708) Eastborough' 'KS08709'='(KS08709) Cheney'
                  'KS08710'='(KS08710) Clearwater' 'KS08711'='(KS08711) Goddard'
                  'KS08713'='(KS08713) Garden Plain' 'KS08714'='(KS08714) Mount Hope'
                  'KS08715'='(KS08715) Maize' 'KS08716'='(KS08716) Park City'
                  'KS08718'='(KS08718) Bel Aire' 'KS08720'='(KS08720) Andale' 'KS08721'='(KS08721) Kechi'
                  'KS08723'='(KS08723) Usd: Maize' 'KS08724'='(KS08724) Usd: Goddard'
                  'KS08800'='(KS08800) Seward' 'KS08801'='(KS08801) Liberal' 'KS08900'='(KS08900) Shawnee'
                  'KS08901'='(KS08901) Topeka' 'KS08902'='(KS08902) Rossville'
                  'KS08903'='(KS08903) Silver Lake' 'KS08905'='(KS08905) Kansas Abc'
                  'KS08906'='(KS08906) Metro Topeka Airport Aut' 'KS08907'='(KS08907) Auburn'
                  'KS08908'='(KS08908) Usd: Topeka'
                  'KS08909'='(KS08909) Topeka Fire Dept Arson I'
                  'KS08910'='(KS08910) securities Off Inv Sec'
                  'KS08912'='(KS08912) Ks Lottery Security Div'
                  'KS08913'='(KS08913) Ks Racing Comm Sec Div'
                  'KS08918'='(KS08918) Washburn University'
                  'KS08920'='(KS08920) Usd: Auburn-Washburn' 'KS09000'='(KS09000) Sheridan'
                  'KS09001'='(KS09001) Hoxie' 'KS09100'='(KS09100) Sherman' 'KS09101'='(KS09101) Goodland'
                  'KS09200'='(KS09200) Smith' 'KS09201'='(KS09201) Smith Center'
                  'KS09300'='(KS09300) Stafford' 'KS09301'='(KS09301) Stafford'
                  'KS09302'='(KS09302) St. John' 'KS09303'='(KS09303) Macksville'
                  'KS09400'='(KS09400) Stanton' 'KS09500'='(KS09500) Stevens' 'KS09501'='(KS09501) Hugoton'
                  'KS09600'='(KS09600) Sumner' 'KS09601'='(KS09601) Wellington'
                  'KS09602'='(KS09602) Belle Plaine' 'KS09603'='(KS09603) Mulvane'
                  'KS09604'='(KS09604) Caldwell' 'KS09605'='(KS09605) Conway Springs'
                  'KS09606'='(KS09606) Oxford' 'KS09607'='(KS09607) Argonia'
                  'KS09608'='(KS09608) South Haven' 'KS09700'='(KS09700) Thomas'
                  'KS09701'='(KS09701) Colby' 'KS09800'='(KS09800) Trego' 'KS09801'='(KS09801) Wa Keeney'
                  'KS09900'='(KS09900) Wabaunsee' 'KS09901'='(KS09901) Alma' 'KS09902'='(KS09902) Eskridge'
                  'KS09903'='(KS09903) Alta Vista' 'KS09905'='(KS09905) Maple Hill'
                  'KS10000'='(KS10000) Wallace' 'KS10001'='(KS10001) Sharon Springs'
                  'KS10100'='(KS10100) Washington' 'KS10101'='(KS10101) Washington'
                  'KS10200'='(KS10200) Wichita' 'KS10300'='(KS10300) Wilson' 'KS10301'='(KS10301) Fredonia'
                  'KS10302'='(KS10302) Neodesha' 'KS10400'='(KS10400) Woodson'
                  'KS10401'='(KS10401) Yates Center' 'KS10500'='(KS10500) Wyandotte'
                  'KS10501'='(KS10501) Bonner Springs' 'KS10502'='(KS10502) Kansas City'
                  'KS10503'='(KS10503) Edwardsville'
                  'KS10504'='(KS10504) Univ Of Ks:Medical Cente'
                  'KS10505'='(KS10505) Wyandotte Co Pks & Rec'
                  'KS10507'='(KS10507) Kansas City Comm College'
                  'KSDI002'='(KSDI002) Potawatomi Tribal' 'KSDI050'='(KSDI050) Kickapoo Tribal'
                  'KSDI051'='(KSDI051) Iowa Tribal' 'KSDI052'='(KSDI052) Sac And Fox Tribal'
                  'KSKBI00'='(KSKBI00) Ks Bur Of Investigation'
                  'KSKHP00'='(KSKHP00) Kansas Highway Patrol'
                  'KSKPAQ0'='(KSKPAQ0) Ks Dpt Of W & pks-Topeka' 'KY00100'='(KY00100) Adair'
                  'KY00101'='(KY00101) Columbia' 'KY001SP'='(KY001SP) Sp: Adair County'
                  'KY00200'='(KY00200) Allen' 'KY00201'='(KY00201) Scottsville'
                  'KY002SP'='(KY002SP) Sp: Allen County' 'KY00300'='(KY00300) Anderson'
                  'KY00301'='(KY00301) Lawrenceburg' 'KY00302'='(KY00302) Anderson County Pd'
                  'KY003SP'='(KY003SP) Sp: Anderson County' 'KY00400'='(KY00400) Ballard'
                  'KY00401'='(KY00401) Wickliffe' 'KY00402'='(KY00402) Barlow'
                  'KY00403'='(KY00403) La Center' 'KY004SP'='(KY004SP) Sp: Ballard County'
                  'KY00500'='(KY00500) Barren' 'KY00501'='(KY00501) Glasgow'
                  'KY00502'='(KY00502) Cave City' 'KY00503'='(KY00503) Park City'
                  'KY00511'='(KY00511) Barren Co Drug Task Forc'
                  'KY005SP'='(KY005SP) Sp: Barren County' 'KY00600'='(KY00600) Bath'
                  'KY00601'='(KY00601) Owingsville' 'KY006SP'='(KY006SP) Sp: Bath County'
                  'KY00700'='(KY00700) Bell' 'KY00701'='(KY00701) Middlesboro'
                  'KY00702'='(KY00702) Pineville' 'KY007SP'='(KY007SP) Sp: Bell County'
                  'KY00800'='(KY00800) Boone' 'KY00801'='(KY00801) Boone County Police Dept'
                  'KY00802'='(KY00802) Florence' 'KY00803'='(KY00803) Walton'
                  'KY00805'='(KY00805) Cin-North Ky Inter Arpt'
                  'KY008SP'='(KY008SP) Sp: Boone County' 'KY00900'='(KY00900) Bourbon'
                  'KY00901'='(KY00901) Paris' 'KY00902'='(KY00902) Millersburg'
                  'KY00903'='(KY00903) North Middletown' 'KY009SP'='(KY009SP) Sp: Bourbon County'
                  'KY01000'='(KY01000) Boyd' 'KY01001'='(KY01001) Ashland'
                  'KY01002'='(KY01002) Catlettsburg'
                  'KY01003'='(KY01003) Boyd County Police Dept'
                  'KY01004'='(KY01004) Fivco Area Drug Task For'
                  'KY01007'='(KY01007) Boyd Cnty Cnstbl Dist 2'
                  'KY010SP'='(KY010SP) Sp: Boyd County' 'KY01100'='(KY01100) Boyle'
                  'KY01101'='(KY01101) Danville' 'KY01102'='(KY01102) Junction City'
                  'KY01103'='(KY01103) Perryville' 'KY011SP'='(KY011SP) sp: Boyle County'
                  'KY01200'='(KY01200) Bracken' 'KY01201'='(KY01201) Augusta'
                  'KY01202'='(KY01202) Brooksville' 'KY012SP'='(KY012SP) Sp: Bracken County'
                  'KY01300'='(KY01300) Breathitt' 'KY01301'='(KY01301) Jackson'
                  'KY013SP'='(KY013SP) Sp: Breathitt County' 'KY01400'='(KY01400) Breckinridge'
                  'KY01401'='(KY01401) Hardinsburg' 'KY01402'='(KY01402) Cloverport'
                  'KY01403'='(KY01403) Irvington' 'KY014SP'='(KY014SP) Sp: Breckinridge County'
                  'KY01500'='(KY01500) Bullitt' 'KY01501'='(KY01501) Shepherdsville'
                  'KY01502'='(KY01502) Lebanon Junction' 'KY01503'='(KY01503) Mount Washington'
                  'KY01504'='(KY01504) Bullitt Police Dept' 'KY01505'='(KY01505) Hillview'
                  'KY01506'='(KY01506) Pioneer Village' 'KY01507'='(KY01507) Hunters Hollow'
                  'KY01510'='(KY01510) Bullitt Cnty Cnstbl D 3'
                  'KY015SP'='(KY015SP) Sp: Bullitt County' 'KY01600'='(KY01600) Butler'
                  'KY01601'='(KY01601) Morgantown' 'KY016SP'='(KY016SP) Sp: Butler County'
                  'KY01700'='(KY01700) Caldwell' 'KY01701'='(KY01701) Princeton'
                  'KY017SP'='(KY017SP) Sp: Caldwell County' 'KY01800'='(KY01800) Calloway'
                  'KY01801'='(KY01801) Murray' 'KY01802'='(KY01802) Murray State University'
                  'KY018SP'='(KY018SP) Sp: Calloway County' 'KY01900'='(KY01900) Campbell'
                  'KY01901'='(KY01901) Bellevue' 'KY01902'='(KY01902) Campbell County Pol Dept'
                  'KY01903'='(KY01903) Dayton' 'KY01904'='(KY01904) Fort Thomas'
                  'KY01905'='(KY01905) Highland Heights' 'KY01906'='(KY01906) Newport'
                  'KY01907'='(KY01907) Alexandria' 'KY01908'='(KY01908) Southgate'
                  'KY01909'='(KY01909) Cold Spring' 'KY01910'='(KY01910) Silver Grove'
                  'KY01912'='(KY01912) Wilder' 'KY01913'='(KY01913) Melbourne' 'KY01914'='(KY01914) Mentor'
                  'KY01915'='(KY01915) Northern Kentucky Univ' 'KY01916'='(KY01916) Crestview'
                  'KY019SP'='(KY019SP) Sp: Campbell County' 'KY02000'='(KY02000) Carlisle'
                  'KY02001'='(KY02001) Bardwell' 'KY020SP'='(KY020SP) Sp: Carlisle County'
                  'KY02100'='(KY02100) Carroll' 'KY02101'='(KY02101) Carrollton'
                  'KY021SP'='(KY021SP) Sp: Carroll County' 'KY02200'='(KY02200) Carter'
                  'KY02201'='(KY02201) Grayson' 'KY02202'='(KY02202) Olive Hill'
                  'KY02203'='(KY02203) Carter County Police Dep'
                  'KY022SP'='(KY022SP) Sp: Carter County' 'KY02300'='(KY02300) Casey'
                  'KY02301'='(KY02301) Liberty' 'KY023SP'='(KY023SP) Sp: Casey County'
                  'KY02400'='(KY02400) Christian' 'KY02401'='(KY02401) Hopkinsville'
                  'KY02402'='(KY02402) Crofton' 'KY02403'='(KY02403) Pembroke'
                  'KY02404'='(KY02404) Christian County Pol Dpt' 'KY02405'='(KY02405) Oak Grove'
                  'KY02406'='(KY02406) Pennyrile Narcotics T f'
                  'KY024SP'='(KY024SP) Sp: Christian County' 'KY02500'='(KY02500) Clark'
                  'KY02501'='(KY02501) Winchester' 'KY02504'='(KY02504) Clark County School Syst'
                  'KY025SP'='(KY025SP) Sp: Clark County' 'KY02600'='(KY02600) Clay'
                  'KY02601'='(KY02601) Manchester' 'KY02602'='(KY02602) Clay County Schools'
                  'KY026SP'='(KY026SP) Sp: Clay County' 'KY02700'='(KY02700) Clinton'
                  'KY02701'='(KY02701) Albany' 'KY027SP'='(KY027SP) Sp: Clinton County'
                  'KY02800'='(KY02800) Crittenden' 'KY02801'='(KY02801) Marion'
                  'KY028SP'='(KY028SP) Sp: Crittenden County' 'KY02900'='(KY02900) Cumberland'
                  'KY02901'='(KY02901) Burkesville' 'KY029SP'='(KY029SP) Sp: Cumberland County'
                  'KY03000'='(KY03000) Daviess' 'KY03001'='(KY03001) Owensboro'
                  'KY030SP'='(KY030SP) Sp: Daviess County' 'KY03100'='(KY03100) Edmonson'
                  'KY03101'='(KY03101) Brownsville' 'KY031SP'='(KY031SP) Sp: Edmonson County'
                  'KY03200'='(KY03200) Elliott' 'KY03202'='(KY03202) Elliott County Pd'
                  'KY032SP'='(KY032SP) Sp: Elliott County' 'KY03300'='(KY03300) Estill'
                  'KY03301'='(KY03301) Irvine' 'KY03302'='(KY03302) Ravenna'
                  'KY033SP'='(KY033SP) Sp: Estill County' 'KY03400'='(KY03400) Fayette'
                  'KY03402'='(KY03402) Lexington' 'KY03403'='(KY03403) University Of Kentucky'
                  'KY03404'='(KY03404) Fayette County Schools'
                  'KY03405'='(KY03405) Lex Bluegrass Airport'
                  'KY03408'='(KY03408) Kentucky Horse Park'
                  'KY034SP'='(KY034SP) Sp: Fayette County' 'KY03500'='(KY03500) Fleming'
                  'KY03501'='(KY03501) Flemingsburg' 'KY035SP'='(KY035SP) Sp: Fleming County'
                  'KY03600'='(KY03600) Floyd' 'KY03601'='(KY03601) Prestonsburg'
                  'KY03602'='(KY03602) Wheelwright' 'KY03603'='(KY03603) Martin'
                  'KY03604'='(KY03604) Wayland' 'KY03605'='(KY03605) Allen'
                  'KY03606'='(KY03606) Floyd Cnty Cnstbl Dist 1'
                  'KY036SP'='(KY036SP) Sp: Floyd County' 'KY03700'='(KY03700) Franklin'
                  'KY03701'='(KY03701) Frankfort' 'KY03702'='(KY03702) Motor Veh Enforcement'
                  'KY03703'='(KY03703) Park Security'
                  'KY03705'='(KY03705) Kentucky State Universit'
                  'KY03708'='(KY03708) Forestry Enforcement' 'KY03711'='(KY03711) Water Patrol'
                  'KY03712'='(KY03712) Fish & Wildlife Enforce'
                  'KY03714'='(KY03714) Alcohol Beverage Control'
                  'KY03715'='(KY03715) Franklin Cnty Cnstbl D 3'
                  'KY037SP'='(KY037SP) sp: Franklin County' 'KY03800'='(KY03800) Fulton'
                  'KY03801'='(KY03801) Fulton' 'KY03802'='(KY03802) Hickman'
                  'KY038SP'='(KY038SP) Sp: Fulton County' 'KY03900'='(KY03900) Gallatin'
                  'KY03901'='(KY03901) Warsaw' 'KY03903'='(KY03903) Gallatin County Pd'
                  'KY03907'='(KY03907) Glencoe' 'KY039SP'='(KY039SP) Sp: Gallatin County'
                  'KY04000'='(KY04000) Garrard' 'KY04001'='(KY04001) Lancaster'
                  'KY040SP'='(KY040SP) Sp: Garrard County' 'KY04100'='(KY04100) Grant'
                  'KY04101'='(KY04101) Williamstown' 'KY04102'='(KY04102) Dry Ridge'
                  'KY04103'='(KY04103) Corinth' 'KY04104'='(KY04104) Crittenden'
                  'KY041SP'='(KY041SP) Sp: Grant County' 'KY04200'='(KY04200) Graves'
                  'KY04201'='(KY04201) Mayfield' 'KY04202'='(KY04202) Wingo'
                  'KY042SP'='(KY042SP) Sp: Graves County' 'KY04300'='(KY04300) Grayson'
                  'KY04301'='(KY04301) Leitchfield' 'KY04302'='(KY04302) Caneyville'
                  'KY04303'='(KY04303) Clarkson' 'KY043SP'='(KY043SP) Sp: Grayson County'
                  'KY04400'='(KY04400) Green' 'KY04401'='(KY04401) Greensburg'
                  'KY044SP'='(KY044SP) Sp: Green County' 'KY04500'='(KY04500) Greenup'
                  'KY04501'='(KY04501) Flatwoods' 'KY04502'='(KY04502) Greenup'
                  'KY04503'='(KY04503) Raceland' 'KY04504'='(KY04504) South Shore'
                  'KY04505'='(KY04505) Russell' 'KY04506'='(KY04506) Worthington'
                  'KY04507'='(KY04507) Wurtland' 'KY04510'='(KY04510) Bellefonte'
                  'KY045SP'='(KY045SP) Sp: Greenup County' 'KY04600'='(KY04600) Hancock'
                  'KY04601'='(KY04601) Hawesville' 'KY04602'='(KY04602) Lewisport'
                  'KY046SP'='(KY046SP) Sp: Hancock County' 'KY04700'='(KY04700) Hardin'
                  'KY04701'='(KY04701) Elizabethtown' 'KY04702'='(KY04702) Radcliff'
                  'KY04703'='(KY04703) Vine Grove' 'KY04704'='(KY04704) West Point'
                  'KY04707'='(KY04707) Hardin Cnty Cnstbl Dist4'
                  'KY04708'='(KY04708) Hardin Cnty Cnstbl Dist5'
                  'KY04715'='(KY04715) Greater Hardin Co Nar Tf'
                  'KY047SP'='(KY047SP) Sp: Hardin County' 'KY04800'='(KY04800) Harlan'
                  'KY04801'='(KY04801) Cumberland' 'KY04802'='(KY04802) Harlan'
                  'KY04803'='(KY04803) Loyall' 'KY04804'='(KY04804) Lynch' 'KY04805'='(KY04805) Evarts'
                  'KY04806'='(KY04806) Benham' 'KY04807'='(KY04807) Wallins'
                  'KY048SP'='(KY048SP) Sp: Harlan County' 'KY04900'='(KY04900) Harrison'
                  'KY04901'='(KY04901) Cynthiana' 'KY049SP'='(KY049SP) Sp: Harrison County'
                  'KY05000'='(KY05000) Hart' 'KY05001'='(KY05001) Horse Cave'
                  'KY05002'='(KY05002) Munfordville' 'KY050SP'='(KY050SP) Sp: Hart County'
                  'KY05100'='(KY05100) Henderson' 'KY05101'='(KY05101) Henderson'
                  'KY05102'='(KY05102) Corydon' 'KY051SP'='(KY051SP) Sp: Henderson County'
                  'KY05200'='(KY05200) Henry' 'KY05201'='(KY05201) New Castle'
                  'KY05202'='(KY05202) Eminence' 'KY05203'='(KY05203) Pleasureville'
                  'KY05204'='(KY05204) Campbellsburg' 'KY052SP'='(KY052SP) Sp: Henry County'
                  'KY05300'='(KY05300) Hickman' 'KY05301'='(KY05301) Clinton'
                  'KY053SP'='(KY053SP) Sp: Hickman County' 'KY05400'='(KY05400) Hopkins'
                  'KY05401'='(KY05401) Madisonville' 'KY05402'='(KY05402) Dawson Springs'
                  'KY05403'='(KY05403) Earlington' 'KY05404'='(KY05404) Mortons Gap'
                  'KY05405'='(KY05405) Nortonville' 'KY054SP'='(KY054SP) Sp: Hopkins County'
                  'KY05500'='(KY05500) Jackson' 'KY05501'='(KY05501) Mckee'
                  'KY05502'='(KY05502) Jackson County Pol Dept'
                  'KY055SP'='(KY055SP) Sp: Jackson County' 'KY05600'='(KY05600) Jefferson'
                  'KY05601'='(KY05601) Jefferson County Pol Dep' 'KY05602'='(KY05602) Louisville'
                  'KY05603'='(KY05603) St. Matthews' 'KY05604'='(KY05604) Shively'
                  'KY05605'='(KY05605) Anchorage' 'KY05606'='(KY05606) West Buechel'
                  'KY05610'='(KY05610) Jeffersontown' 'KY05612'='(KY05612) Lynnview'
                  'KY05613'='(KY05613) St. Regis Park'
                  'KY05615'='(KY05615) University Of Louisville'
                  'KY05617'='(KY05617) Ky Fairgrounds Security'
                  'KY05618'='(KY05618) Heritage Creek' 'KY05619'='(KY05619) Audubon Park'
                  'KY05620'='(KY05620) Plantation' 'KY05626'='(KY05626) Forest Hills'
                  'KY05638'='(KY05638) Northfield' 'KY05644'='(KY05644) Indian Hills'
                  'KY05645'='(KY05645) Prospect' 'KY05646'='(KY05646) Douglass Hills'
                  'KY05647'='(KY05647) Jefferson Community Coll'
                  'KY05650'='(KY05650) Graymoor-Devondale'
                  'KY05652'='(KY05652) Jefferson Cty Board Of E'
                  'KY05655'='(KY05655) green Spring'
                  'KY05669'='(KY05669) Louisville Reg Arpt Auth'
                  'KY05680'='(KY05680) Louisville Metro'
                  'KY056SP'='(KY056SP) Sp: Jefferson County' 'KY05700'='(KY05700) Jessamine'
                  'KY05701'='(KY05701) Nicholasville' 'KY05702'='(KY05702) Wilmore'
                  'KY05703'='(KY05703) Jessamine Cnty Cnstbl D2'
                  'KY057SP'='(KY057SP) Sp: Jessamine County' 'KY05800'='(KY05800) Johnson'
                  'KY05801'='(KY05801) Paintsville' 'KY058SP'='(KY058SP) Sp: Johnson County'
                  'KY05900'='(KY05900) Kenton' 'KY05901'='(KY05901) Covington'
                  'KY05902'='(KY05902) Elsmere' 'KY05903'='(KY05903) Erlanger'
                  'KY05904'='(KY05904) Fort Wright'
                  'KY05905'='(KY05905) Kenton County Police Dep' 'KY05906'='(KY05906) Park Hills'
                  'KY05907'='(KY05907) Ludlow' 'KY05908'='(KY05908) South Fort Mitchell'
                  'KY05909'='(KY05909) Crescent Springs'
                  'KY05910'='(KY05910) Lakeside Park-Crstvw Hls'
                  'KY05911'='(KY05911) Taylor Mill' 'KY05912'='(KY05912) Villa Hills'
                  'KY05913'='(KY05913) Fort Mitchell' 'KY05915'='(KY05915) Bromley'
                  'KY05917'='(KY05917) Edgewood' 'KY05918'='(KY05918) Fairview'
                  'KY05919'='(KY05919) Independence' 'KY05920'='(KY05920) Lakeview'
                  'KY05922'='(KY05922) Crescent Park' 'KY05923'='(KY05923) Latonia Lakes'
                  'KY05926'='(KY05926) Northern Ky Narc Enforce'
                  'KY05928'='(KY05928) Dixie Police Authority'
                  'KY059SP'='(KY059SP) Sp: Kenton County' 'KY06000'='(KY06000) Knott'
                  'KY06001'='(KY06001) Hindman' 'KY06002'='(KY06002) Pippa Passes'
                  'KY060SP'='(KY060SP) Sp: Knott County' 'KY06100'='(KY06100) Knox'
                  'KY06101'='(KY06101) Barbourville' 'KY061SP'='(KY061SP) Sp: Knox County'
                  'KY06200'='(KY06200) Larue' 'KY06201'='(KY06201) Hodgenville'
                  'KY062SP'='(KY062SP) Sp: Larue County' 'KY06300'='(KY06300) Laurel'
                  'KY06301'='(KY06301) London' 'KY063SP'='(KY063SP) Sp: Laurel County'
                  'KY06400'='(KY06400) Lawrence' 'KY06401'='(KY06401) Louisa'
                  'KY064SP'='(KY064SP) Sp: Lawrence County' 'KY06500'='(KY06500) Lee'
                  'KY06501'='(KY06501) Beattyville' 'KY065SP'='(KY065SP) Sp: Lee County'
                  'KY06600'='(KY06600) Leslie' 'KY06601'='(KY06601) Hyden'
                  'KY066SP'='(KY066SP) Sp: Leslie County' 'KY06700'='(KY06700) Letcher'
                  'KY06701'='(KY06701) Whitesburg' 'KY06702'='(KY06702) Jenkins'
                  'KY06703'='(KY06703) Fleming-Neon' 'KY06704'='(KY06704) Fleming'
                  'KY067SP'='(KY067SP) Sp: Letcher County' 'KY06800'='(KY06800) Lewis'
                  'KY06801'='(KY06801) Vanceburg' 'KY068SP'='(KY068SP) Sp: Lewis County'
                  'KY06900'='(KY06900) Lincoln' 'KY06901'='(KY06901) Stanford'
                  'KY06902'='(KY06902) Hustonville' 'KY06903'='(KY06903) Crab Orchard'
                  'KY069SP'='(KY069SP) Sp: Lincoln County' 'KY07000'='(KY07000) Livingston'
                  'KY070SP'='(KY070SP) Sp: Livingston County' 'KY07100'='(KY07100) Logan'
                  'KY07101'='(KY07101) Russellville' 'KY07102'='(KY07102) Auburn'
                  'KY07103'='(KY07103) Adairville' 'KY07104'='(KY07104) Lewisburg'
                  'KY07109'='(KY07109) South Central Ky Drug Tf'
                  'KY071SP'='(KY071SP) Sp: Logan County' 'KY07200'='(KY07200) Lyon'
                  'KY07202'='(KY07202) Eddyville' 'KY07203'='(KY07203) Lyon County Police Dept'
                  'KY072SP'='(KY072SP) Sp: Lyon County' 'KY07300'='(KY07300) Mccracken'
                  'KY07301'='(KY07301) Paducah' 'KY07302'='(KY07302) Mccracken County Pol Dep'
                  'KY07303'='(KY07303) Lone Oak' 'KY07307'='(KY07307) Mccracken Co Pub Schools'
                  'KY073SP'='(KY073SP) Sp: Mccracken County' 'KY07400'='(KY07400) Mccreary'
                  'KY07401'='(KY07401) Whitley City'
                  'KY07402'='(KY07402) Mccreary County Pol Dept'
                  'KY07403'='(KY07403) Mccreary Cnty Cnstbl D 1'
                  'KY074SP'='(KY074SP) Sp: Mccreary County' 'KY07500'='(KY07500) Mclean'
                  'KY07501'='(KY07501) Calhoun' 'KY07502'='(KY07502) Livermore'
                  'KY07503'='(KY07503) Mclean County Police Dpt'
                  'KY075SP'='(KY075SP) Sp: Mclean County' 'KY07600'='(KY07600) Madison'
                  'KY07601'='(KY07601) Berea' 'KY07602'='(KY07602) Richmond'
                  'KY07603'='(KY07603) Eastern Kentucky Univ'
                  'KY076SP'='(KY076SP) Sp: Madison County' 'KY07700'='(KY07700) Magoffin'
                  'KY07701'='(KY07701) Salyersville' 'KY077SP'='(KY077SP) Sp: Magoffin County'
                  'KY07800'='(KY07800) Marion' 'KY07801'='(KY07801) Lebanon' 'KY07802'='(KY07802) Loretto'
                  'KY078SP'='(KY078SP) Sp: Marion County' 'KY07900'='(KY07900) Marshall'
                  'KY07901'='(KY07901) Benton' 'KY07902'='(KY07902) Calvert City'
                  'KY07903'='(KY07903) Hardin' 'KY079SP'='(KY079SP) Sp: Marshall County'
                  'KY08000'='(KY08000) Martin' 'KY08001'='(KY08001) Inez'
                  'KY080SP'='(KY080SP) Sp: Martin County' 'KY08100'='(KY08100) Mason'
                  'KY08101'='(KY08101) Maysville' 'KY08102'='(KY08102) Washington'
                  'KY08103'='(KY08103) Buffalo Trace-Gtwy Nar T'
                  'KY081SP'='(KY081SP) Sp: Mason County' 'KY08200'='(KY08200) Meade'
                  'KY08201'='(KY08201) Brandenburg' 'KY08202'='(KY08202) Muldraugh'
                  'KY082SP'='(KY082SP) sp: Meade County' 'KY08300'='(KY08300) Menifee'
                  'KY083SP'='(KY083SP) Sp: Menifee County' 'KY08400'='(KY08400) Mercer'
                  'KY08401'='(KY08401) Harrodsburg' 'KY08402'='(KY08402) Burgin'
                  'KY084SP'='(KY084SP) Sp: Mercer County' 'KY08500'='(KY08500) Metcalfe'
                  'KY08501'='(KY08501) Edmonton' 'KY085SP'='(KY085SP) Sp: Metcalfe County'
                  'KY08600'='(KY08600) Monroe' 'KY08601'='(KY08601) Tompkinsville'
                  'KY08602'='(KY08602) Gamaliel' 'KY086SP'='(KY086SP) Sp: Monroe County'
                  'KY08700'='(KY08700) Montgomery' 'KY08701'='(KY08701) Mount Sterling'
                  'KY087SP'='(KY087SP) Sp: Montgomery County' 'KY08800'='(KY08800) Morgan'
                  'KY08801'='(KY08801) West Liberty' 'KY088SP'='(KY088SP) Sp: Morgan County'
                  'KY08900'='(KY08900) Muhlenberg' 'KY08901'='(KY08901) Greenville'
                  'KY08902'='(KY08902) Central City' 'KY08904'='(KY08904) Powderly'
                  'KY089SP'='(KY089SP) Sp: Muhlenberg County' 'KY09000'='(KY09000) Nelson'
                  'KY09001'='(KY09001) Bardstown' 'KY09002'='(KY09002) Bloomfield'
                  'KY09004'='(KY09004) New Haven' 'KY09005'='(KY09005) Nelson County Pol Dept'
                  'KY090SP'='(KY090SP) Sp: Nelson County' 'KY09100'='(KY09100) Nicholas'
                  'KY09101'='(KY09101) Carlisle' 'KY09103'='(KY09103) Nicholas County Schools'
                  'KY091SP'='(KY091SP) Sp: Nicholas County' 'KY09200'='(KY09200) Ohio'
                  'KY09201'='(KY09201) Hartford' 'KY09202'='(KY09202) Beaver Dam'
                  'KY09204'='(KY09204) Centertown' 'KY092SP'='(KY092SP) Sp: Ohio County'
                  'KY09300'='(KY09300) Oldham' 'KY09301'='(KY09301) La Grange'
                  'KY09303'='(KY09303) Pewee Valley'
                  'KY09304'='(KY09304) Oldham County Police Dep'
                  'KY093SP'='(KY093SP) Sp: Oldham County' 'KY09400'='(KY09400) Owen'
                  'KY09401'='(KY09401) Owenton' 'KY094SP'='(KY094SP) Sp: Owen County'
                  'KY09500'='(KY09500) Owsley' 'KY09501'='(KY09501) Booneville'
                  'KY095SP'='(KY095SP) Sp: Owsley County' 'KY09600'='(KY09600) Pendleton'
                  'KY09601'='(KY09601) Falmouth' 'KY09602'='(KY09602) Butler'
                  'KY096SP'='(KY096SP) Sp: Pendleton County' 'KY09700'='(KY09700) Perry'
                  'KY09701'='(KY09701) Hazard' 'KY09702'='(KY09702) Vicco'
                  'KY097SP'='(KY097SP) Sp: Perry County' 'KY09800'='(KY09800) Pike'
                  'KY09801'='(KY09801) Pikeville' 'KY09802'='(KY09802) Elkhorn City'
                  'KY09803'='(KY09803) Pike County Police Dept'
                  'KY098SP'='(KY098SP) Sp: Pike County' 'KY09900'='(KY09900) Powell'
                  'KY09901'='(KY09901) Stanton' 'KY09902'='(KY09902) Clay City'
                  'KY099SP'='(KY099SP) Sp: Powell County' 'KY10000'='(KY10000) Pulaski'
                  'KY10001'='(KY10001) Somerset' 'KY10002'='(KY10002) Burnside'
                  'KY10003'='(KY10003) Eubank' 'KY10004'='(KY10004) Science Hill'
                  'KY10006'='(KY10006) Lake Cumbrlnd Area De Tf'
                  'KY10012'='(KY10012) Unlawful Narc Invst, T&e'
                  'KY100SP'='(KY100SP) Sp: Pulaski County' 'KY10100'='(KY10100) Robertson'
                  'KY10101'='(KY10101) Mount Olivet' 'KY101SP'='(KY101SP) Sp: Robertson County'
                  'KY10200'='(KY10200) Rockcastle' 'KY10201'='(KY10201) Livingston'
                  'KY10202'='(KY10202) Mount Vernon' 'KY10203'='(KY10203) Brodhead'
                  'KY102SP'='(KY102SP) Sp: Rockcastle County' 'KY10300'='(KY10300) Rowan'
                  'KY10301'='(KY10301) Morehead' 'KY10302'='(KY10302) Morehead State Universit'
                  'KY103SP'='(KY103SP) Sp: Rowan County' 'KY10400'='(KY10400) Russell'
                  'KY10401'='(KY10401) Jamestown' 'KY10402'='(KY10402) Russell Springs'
                  'KY104SP'='(KY104SP) Sp: Russell County' 'KY10500'='(KY10500) Scott'
                  'KY10501'='(KY10501) Georgetown' 'KY10502'='(KY10502) Stamping Ground'
                  'KY10503'='(KY10503) Sadieville' 'KY10504'='(KY10504) Scott County Police Dept'
                  'KY10505'='(KY10505) Scott Cnty Cnstbl Dist 6'
                  'KY10506'='(KY10506) scott Cnty Cnstbl Dist 7'
                  'KY10510'='(KY10510) scott Cnty Cnstbl Dist 5'
                  'KY105SP'='(KY105SP) Sp: Scott County' 'KY10600'='(KY10600) Shelby'
                  'KY10601'='(KY10601) Shelbyville' 'KY10604'='(KY10604) Shelby Cnty Cnstbl D 3'
                  'KY106SP'='(KY106SP) sp: Shelby County' 'KY10700'='(KY10700) Simpson'
                  'KY10701'='(KY10701) Franklin' 'KY107SP'='(KY107SP) Sp: Simpson County'
                  'KY10800'='(KY10800) Spencer' 'KY10801'='(KY10801) Taylorsville'
                  'KY108SP'='(KY108SP) Sp: Spencer County' 'KY10900'='(KY10900) Taylor'
                  'KY10901'='(KY10901) Campbellsville'
                  'KY10902'='(KY10902) Taylor County Police Dep'
                  'KY109SP'='(KY109SP) Sp: Taylor County' 'KY11000'='(KY11000) Todd'
                  'KY11001'='(KY11001) Elkton' 'KY11003'='(KY11003) Guthrie' 'KY11004'='(KY11004) Trenton'
                  'KY110SP'='(KY110SP) Sp: Todd County' 'KY11100'='(KY11100) Trigg'
                  'KY11101'='(KY11101) Cadiz' 'KY11102'='(KY11102) Land Between The Lakes'
                  'KY111SP'='(KY111SP) Sp: Trigg County' 'KY11200'='(KY11200) Trimble'
                  'KY112SP'='(KY112SP) Sp: Trimble County' 'KY11300'='(KY11300) Union'
                  'KY11301'='(KY11301) Morganfield' 'KY11302'='(KY11302) Sturgis'
                  'KY11303'='(KY11303) Uniontown' 'KY113SP'='(KY113SP) Sp: Union County'
                  'KY11400'='(KY11400) Warren' 'KY11401'='(KY11401) Bowling Green'
                  'KY11402'='(KY11402) Western Kentucky Univ' 'KY11403'='(KY11403) Smiths Grove'
                  'KY114SP'='(KY114SP) Sp: Warren County' 'KY11500'='(KY11500) Washington'
                  'KY11501'='(KY11501) Springfield' 'KY115SP'='(KY115SP) Sp: Washington County'
                  'KY11600'='(KY11600) Wayne' 'KY11601'='(KY11601) Monticello'
                  'KY116SP'='(KY116SP) Sp: Wayne County' 'KY11700'='(KY11700) Webster'
                  'KY11702'='(KY11702) Providence' 'KY11703'='(KY11703) Clay' 'KY11704'='(KY11704) Sebree'
                  'KY117SP'='(KY117SP) Sp: Webster County' 'KY11800'='(KY11800) Whitley'
                  'KY11801'='(KY11801) Corbin' 'KY11802'='(KY11802) Williamsburg'
                  'KY118SP'='(KY118SP) Sp: Whitley County' 'KY11900'='(KY11900) Wolfe'
                  'KY11901'='(KY11901) Campton' 'KY119SP'='(KY119SP) Sp: Wolfe County'
                  'KY12000'='(KY12000) Woodford' 'KY12001'='(KY12001) Versailles'
                  'KY12002'='(KY12002) Midway' 'KY12003'='(KY12003) Woodford County Pol Dept'
                  'KY120SP'='(KY120SP) Sp: Woodford County' 'KYKSP00'='(KYKSP00) State Police'
                  'LA00100'='(LA00100) Acadia' 'LA00101'='(LA00101) Crowley' 'LA00102'='(LA00102) Rayne'
                  'LA00103'='(LA00103) Church Point' 'LA00104'='(LA00104) Iota'
                  'LA00108'='(LA00108) La State Univ: Eunice' 'LA00200'='(LA00200) Allen'
                  'LA00201'='(LA00201) Kinder' 'LA00202'='(LA00202) Oakdale' 'LA00203'='(LA00203) Oberlin'
                  'LA00300'='(LA00300) Ascension' 'LA00301'='(LA00301) Donaldsonville'
                  'LA00302'='(LA00302) Gonzales' 'LA00303'='(LA00303) Sorrento'
                  'LA00400'='(LA00400) Assumption' 'LA00401'='(LA00401) Napoleonville'
                  'LA00500'='(LA00500) Avoyelles' 'LA00501'='(LA00501) Bunkie'
                  'LA00502'='(LA00502) Marksville' 'LA00503'='(LA00503) Simmesport'
                  'LA00504'='(LA00504) Cottonport' 'LA00506'='(LA00506) Moreauville'
                  'LA00600'='(LA00600) Beauregard' 'LA00601'='(LA00601) De Ridder'
                  'LA00602'='(LA00602) Merryville' 'LA00700'='(LA00700) Bienville'
                  'LA00701'='(LA00701) Arcadia' 'LA00702'='(LA00702) Gibsland'
                  'LA00708'='(LA00708) Bienville' 'LA00800'='(LA00800) Bossier'
                  'LA00801'='(LA00801) Bossier City' 'LA00804'='(LA00804) Haughton'
                  'LA00805'='(LA00805) La St U: hsc, Shreveport'
                  'LA00806'='(LA00806) La State Univ:Shreveport'
                  'LA00807'='(LA00807) Southern U &a&M c: Shrev' 'LA00900'='(LA00900) Caddo'
                  'LA00901'='(LA00901) Shreveport' 'LA00902'='(LA00902) Vivian'
                  'LA00904'='(LA00904) Blanchard' 'LA01000'='(LA01000) Calcasieu'
                  'LA01001'='(LA01001) De Quincy' 'LA01002'='(LA01002) Lake Charles'
                  'LA01003'='(LA01003) Sulphur' 'LA01004'='(LA01004) Vinton' 'LA01005'='(LA01005) Westlake'
                  'LA01006'='(LA01006) Maplewood' 'LA01007'='(LA01007) Iowa'
                  'LA01008'='(LA01008) Mcneese State University' 'LA01100'='(LA01100) Caldwell'
                  'LA01200'='(LA01200) Cameron' 'LA01300'='(LA01300) Catahoula'
                  'LA01301'='(LA01301) Jonesville' 'LA01302'='(LA01302) Sicily Island'
                  'LA01303'='(LA01303) Harrisonburg' 'LA01400'='(LA01400) Claiborne'
                  'LA01401'='(LA01401) Haynesville' 'LA01402'='(LA01402) Homer'
                  'LA01500'='(LA01500) Concordia' 'LA01501'='(LA01501) Ferriday'
                  'LA01502'='(LA01502) Vidalia' 'LA01503'='(LA01503) Clayton' 'LA01600'='(LA01600) De Soto'
                  'LA01601'='(LA01601) Mansfield' 'LA01608'='(LA01608) Stonewall'
                  'LA01700'='(LA01700) East Baton Rouge' 'LA01701'='(LA01701) Baker'
                  'LA01702'='(LA01702) Baton Rouge' 'LA01703'='(LA01703) Zachary'
                  'LA01704'='(LA01704) La State Univ:Baton Roug'
                  'LA01706'='(LA01706) Southern U &a&M c:Bat Ro'
                  'LA01711'='(LA01711) Dept Pub Sfty St Cap Dtl'
                  'LA01800'='(LA01800) East Carroll' 'LA01801'='(LA01801) Lake Providence'
                  'LA01900'='(LA01900) East Feliciana' 'LA01901'='(LA01901) Clinton'
                  'LA01902'='(LA01902) Jackson' 'LA01905'='(LA01905) Norwood'
                  'LA02000'='(LA02000) Evangeline' 'LA02001'='(LA02001) Basile' 'LA02002'='(LA02002) Mamou'
                  'LA02003'='(LA02003) Ville Platte' 'LA02100'='(LA02100) Franklin'
                  'LA02101'='(LA02101) Winnsboro' 'LA02104'='(LA02104) Baskin' 'LA02200'='(LA02200) Grant'
                  'LA02205'='(LA02205) Pollock' 'LA02300'='(LA02300) Iberia'
                  'LA02302'='(LA02302) Jeanerette' 'LA02303'='(LA02303) New Iberia'
                  'LA02304'='(LA02304) Loreauville' 'LA02400'='(LA02400) Iberville'
                  'LA02401'='(LA02401) Maringouin' 'LA02402'='(LA02402) Plaquemine'
                  'LA02403'='(LA02403) White Castle' 'LA02404'='(LA02404) Grosse Tete'
                  'LA02405'='(LA02405) Rosedale' 'LA02406'='(LA02406) St. Gabriel'
                  'LA02500'='(LA02500) Jackson' 'LA02501'='(LA02501) Jonesboro'
                  'LA02600'='(LA02600) Jefferson' 'LA02601'='(LA02601) Gretna'
                  'LA02602'='(LA02602) Harahan' 'LA02603'='(LA02603) Kenner' 'LA02604'='(LA02604) Westwego'
                  'LA02605'='(LA02605) Grand Isle' 'LA02700'='(LA02700) Jefferson Davis'
                  'LA02701'='(LA02701) Elton' 'LA02702'='(LA02702) Jennings'
                  'LA02703'='(LA02703) Lake Arthur' 'LA02704'='(LA02704) Welsh'
                  'LA02800'='(LA02800) Lafayette' 'LA02801'='(LA02801) Broussard'
                  'LA02803'='(LA02803) Lafayette' 'LA02804'='(LA02804) Duson'
                  'LA02805'='(LA02805) Youngsville' 'LA02806'='(LA02806) Scott'
                  'LA02807'='(LA02807) Univ Of La: Lafayette' 'LA02900'='(LA02900) Lafourche'
                  'LA02901'='(LA02901) Golden Meadow' 'LA02903'='(LA02903) Lockport'
                  'LA02905'='(LA02905) Thibodaux' 'LA02906'='(LA02906) Nicholls State Universit'
                  'LA03000'='(LA03000) La Salle' 'LA03001'='(LA03001) Jena' 'LA03002'='(LA03002) Olla'
                  'LA03100'='(LA03100) Lincoln' 'LA03101'='(LA03101) Dubach' 'LA03102'='(LA03102) Ruston'
                  'LA03103'='(LA03103) Grambling' 'LA03106'='(LA03106) Grambling State Univ'
                  'LA03107'='(LA03107) Louisiana Tech Universit' 'LA03200'='(LA03200) Livingston'
                  'LA03201'='(LA03201) Denham Springs' 'LA03206'='(LA03206) Port Vincent'
                  'LA03207'='(LA03207) French Settlement' 'LA03300'='(LA03300) Madison'
                  'LA03301'='(LA03301) Tallulah' 'LA03400'='(LA03400) Morehouse'
                  'LA03401'='(LA03401) Bastrop' 'LA03403'='(LA03403) Bonita'
                  'LA03404'='(LA03404) Collinston' 'LA03405'='(LA03405) Oak Ridge'
                  'LA03500'='(LA03500) Natchitoches' 'LA03501'='(LA03501) Natchitoches'
                  'LA03510'='(LA03510) Northwestern State Univ' 'LA03600'='(LA03600) Orleans'
                  'LA03602'='(LA03602) Delgado Community Colleg'
                  'LA03603'='(LA03603) Univ Of New Orleans'
                  'LA03612'='(LA03612) Southern U &a&M c: New O'
                  'LA03617'='(LA03617) la St U:hsc, New Orleans'
                  'LA03620'='(LA03620) Tulane University' 'LA03700'='(LA03700) Ouachita'
                  'LA03701'='(LA03701) Monroe' 'LA03702'='(LA03702) West Monroe'
                  'LA03703'='(LA03703) Sterlington' 'LA03704'='(LA03704) Univ Of La: Monroe'
                  'LA03705'='(LA03705) Richwood' 'LA03709'='(LA03709) Tensas Basin Levee Dist'
                  'LA03800'='(LA03800) Plaquemines' 'LA03900'='(LA03900) Pointe Coupee'
                  'LA03901'='(LA03901) New Roads' 'LA04000'='(LA04000) Rapides'
                  'LA04001'='(LA04001) Alexandria' 'LA04002'='(LA04002) Pineville'
                  'LA04004'='(LA04004) Lecompte' 'LA04005'='(LA04005) Cheneyville'
                  'LA04006'='(LA04006) Glenmora' 'LA04007'='(LA04007) Woodworth' 'LA04010'='(LA04010) Ball'
                  'LA04013'='(LA04013) Mcnary' 'LA04100'='(LA04100) Red River'
                  'LA04101'='(LA04101) Coushatta' 'LA04200'='(LA04200) Richland'
                  'LA04201'='(LA04201) Delhi' 'LA04202'='(LA04202) Rayville' 'LA04203'='(LA04203) Mangham'
                  'LA04300'='(LA04300) Sabine' 'LA04301'='(LA04301) Many' 'LA04302'='(LA04302) Zwolle'
                  'LA04400'='(LA04400) St. Bernard' 'LA04500'='(LA04500) St. Charles'
                  'LA04600'='(LA04600) St. Helena' 'LA04700'='(LA04700) St. James'
                  'LA04701'='(LA04701) Lutcher' 'LA04702'='(LA04702) Gramercy'
                  'LA04800'='(LA04800) St. John The Baptist' 'LA04900'='(LA04900) St. Landry'
                  'LA04901'='(LA04901) Eunice' 'LA04902'='(LA04902) Opelousas'
                  'LA04903'='(LA04903) Arnaudville' 'LA04904'='(LA04904) Sunset'
                  'LA04905'='(LA04905) Washington' 'LA04906'='(LA04906) Port Barre'
                  'LA04908'='(LA04908) Krotz Springs' 'LA04913'='(LA04913) La State Univ: Eunice'
                  'LA05000'='(LA05000) St. Martin' 'LA05001'='(LA05001) Breaux Bridge'
                  'LA05002'='(LA05002) St. Martinville' 'LA05003'='(LA05003) Parks'
                  'LA05100'='(LA05100) St. Mary' 'LA05101'='(LA05101) Berwick'
                  'LA05102'='(LA05102) Franklin' 'LA05103'='(LA05103) Morgan City'
                  'LA05104'='(LA05104) Patterson' 'LA05105'='(LA05105) Baldwin'
                  'LA05200'='(LA05200) St. Tammany' 'LA05201'='(LA05201) Covington'
                  'LA05202'='(LA05202) Slidell' 'LA05203'='(LA05203) Mandeville'
                  'LA05205'='(LA05205) Pearl River' 'LA05206'='(LA05206) Abita Springs'
                  'LA05207'='(LA05207) Folsom' 'LA05300'='(LA05300) Tangipahoa'
                  'LA05301'='(LA05301) Hammond' 'LA05302'='(LA05302) Kentwood'
                  'LA05303'='(LA05303) Ponchatoula' 'LA05304'='(LA05304) Amite'
                  'LA05305'='(LA05305) Independence' 'LA05308'='(LA05308) Tickfaw'
                  'LA05309'='(LA05309) Southeastern Louisiana U' 'LA05400'='(LA05400) tensas'
                  'LA05401'='(LA05401) Newellton' 'LA05402'='(LA05402) Waterproof'
                  'LA05403'='(LA05403) St. Joseph' 'LA05500'='(LA05500) Terrebonne'
                  'LA05501'='(LA05501) Houma' 'LA05600'='(LA05600) Union' 'LA05601'='(LA05601) Farmerville'
                  'LA05602'='(LA05602) Bernice' 'LA05700'='(LA05700) Vermilion'
                  'LA05701'='(LA05701) Abbeville' 'LA05702'='(LA05702) Kaplan'
                  'LA05703'='(LA05703) Delcambre' 'LA05704'='(LA05704) Erath' 'LA05705'='(LA05705) Gueydan'
                  'LA05800'='(LA05800) Vernon' 'LA05801'='(LA05801) Leesville'
                  'LA05802'='(LA05802) Newllano' 'LA05900'='(LA05900) Washington'
                  'LA05901'='(LA05901) Bogalusa' 'LA05902'='(LA05902) Franklinton'
                  'LA06000'='(LA06000) Webster' 'LA06001'='(LA06001) Minden'
                  'LA06002'='(LA06002) Springhill' 'LA06004'='(LA06004) Cullen'
                  'LA06008'='(LA06008) Dixie Inn' 'LA06100'='(LA06100) West Baton Rouge'
                  'LA06101'='(LA06101) Port Allen' 'LA06102'='(LA06102) Brusly' 'LA06103'='(LA06103) Addis'
                  'LA06200'='(LA06200) West Carroll' 'LA06201'='(LA06201) Oak Grove'
                  'LA06300'='(LA06300) West Feliciana' 'LA06301'='(LA06301) St. Francisville'
                  'LA06400'='(LA06400) Winn' 'LA06401'='(LA06401) Winnfield'
                  'LALSP00'='(LALSP00) State Police' 'LANPD00'='(LANPD00) New Orleans'
                  'MA00100'='(MA00100) barnstable' 'MA00101'='(MA00101) Barnstable'
                  'MA00102'='(MA00102) Bourne' 'MA00103'='(MA00103) Brewster' 'MA00104'='(MA00104) Chatham'
                  'MA00105'='(MA00105) Dennis' 'MA00106'='(MA00106) Eastham' 'MA00107'='(MA00107) Falmouth'
                  'MA00108'='(MA00108) Harwich' 'MA00109'='(MA00109) Mashpee' 'MA00110'='(MA00110) Orleans'
                  'MA00111'='(MA00111) Provincetown' 'MA00112'='(MA00112) Sandwich'
                  'MA00113'='(MA00113) Truro' 'MA00114'='(MA00114) Wellfleet'
                  'MA00115'='(MA00115) Yarmouth' 'MA001BA'='(MA001BA) Mbta: Barnstable County'
                  'MA001MD'='(MA001MD) Barnstable Met Dist Comm'
                  'MA001MV'='(MA001MV) Reg Of Mv: Barnstable C' 'MA00200'='(MA00200) Berkshire'
                  'MA00201'='(MA00201) Adams' 'MA00203'='(MA00203) Becket' 'MA00204'='(MA00204) Cheshire'
                  'MA00205'='(MA00205) Clarksburg' 'MA00206'='(MA00206) Dalton'
                  'MA00207'='(MA00207) Egremont' 'MA00209'='(MA00209) Great Barrington'
                  'MA00211'='(MA00211) Hinsdale' 'MA00212'='(MA00212) Lanesboro' 'MA00213'='(MA00213) Lee'
                  'MA00214'='(MA00214) Lenox' 'MA00215'='(MA00215) Monterey'
                  'MA00219'='(MA00219) North Adams' 'MA00220'='(MA00220) Otis' 'MA00221'='(MA00221) Peru'
                  'MA00222'='(MA00222) Pittsfield' 'MA00223'='(MA00223) Richmond'
                  'MA00225'='(MA00225) Savoy' 'MA00226'='(MA00226) Sheffield'
                  'MA00227'='(MA00227) Stockbridge' 'MA00229'='(MA00229) Washington'
                  'MA00231'='(MA00231) Williamstown'
                  'MA00235'='(MA00235) Ma Collg Of Liberal Arts'
                  'MA002BA'='(MA002BA) Mbta: Berkshire County'
                  'MA002MD'='(MA002MD) Berkshire Met Dist Comm'
                  'MA002MV'='(MA002MV) Reg Of Mv: Berkshire Cty'
                  'MA002SC'='(MA002SC) Ma College Of Liberal Ar' 'MA00300'='(MA00300) Bristol'
                  'MA00301'='(MA00301) Acushnet' 'MA00302'='(MA00302) Attleboro'
                  'MA00303'='(MA00303) Berkley' 'MA00304'='(MA00304) Dartmouth'
                  'MA00305'='(MA00305) Dighton' 'MA00306'='(MA00306) Easton'
                  'MA00307'='(MA00307) Fairhaven' 'MA00308'='(MA00308) Fall River'
                  'MA00309'='(MA00309) Freetown' 'MA00310'='(MA00310) Mansfield'
                  'MA00311'='(MA00311) New Bedford' 'MA00312'='(MA00312) North Attleboro'
                  'MA00313'='(MA00313) Norton' 'MA00314'='(MA00314) Raynham' 'MA00315'='(MA00315) Rehoboth'
                  'MA00316'='(MA00316) Seekonk' 'MA00317'='(MA00317) Somerset'
                  'MA00318'='(MA00318) Swansea' 'MA00319'='(MA00319) Taunton'
                  'MA00320'='(MA00320) Westport' 'MA00321'='(MA00321) Un Of Ma: Dartmouth'
                  'MA00323'='(MA00323) Bristol Comm College'
                  'MA003BA'='(MA003BA) Mbta: Bristol County'
                  'MA003MD'='(MA003MD) Bristol Met Dist Comm'
                  'MA003MV'='(MA003MV) Reg Of Mv: Bristol Cnty' 'MA00400'='(MA00400) Dukes'
                  'MA00402'='(MA00402) Edgartown' 'MA00403'='(MA00403) Aquinnah'
                  'MA00405'='(MA00405) Oak Bluffs' 'MA00406'='(MA00406) Tisbury'
                  'MA00407'='(MA00407) West Tisbury' 'MA004BA'='(MA004BA) Mbta: Dukes County'
                  'MA004MD'='(MA004MD) Dukes Met Dist Comm'
                  'MA004MV'='(MA004MV) Reg Of Mv: Dukes County' 'MA00500'='(MA00500) Essex'
                  'MA00501'='(MA00501) Amesbury' 'MA00502'='(MA00502) Andover'
                  'MA00503'='(MA00503) Beverly' 'MA00504'='(MA00504) Boxford' 'MA00505'='(MA00505) Danvers'
                  'MA00506'='(MA00506) Essex' 'MA00507'='(MA00507) Georgetown'
                  'MA00508'='(MA00508) Gloucester' 'MA00509'='(MA00509) Groveland'
                  'MA0050E'='(MA0050E) North Shore Comm College' 'MA00510'='(MA00510) Hamilton'
                  'MA00511'='(MA00511) Haverhill' 'MA00512'='(MA00512) Ipswich'
                  'MA00513'='(MA00513) Lawrence' 'MA00514'='(MA00514) Lynn' 'MA00515'='(MA00515) Lynnfield'
                  'MA00516'='(MA00516) Manchester-By-The-Sea' 'MA00517'='(MA00517) Marblehead'
                  'MA00518'='(MA00518) Merrimac' 'MA00519'='(MA00519) Methuen'
                  'MA00520'='(MA00520) Middleton' 'MA00521'='(MA00521) Nahant'
                  'MA00522'='(MA00522) Newbury' 'MA00523'='(MA00523) Newburyport'
                  'MA00524'='(MA00524) North Andover' 'MA00525'='(MA00525) Peabody'
                  'MA00526'='(MA00526) Rockport' 'MA00527'='(MA00527) Rowley' 'MA00528'='(MA00528) Salem'
                  'MA00529'='(MA00529) Salisbury' 'MA00530'='(MA00530) Saugus'
                  'MA00531'='(MA00531) Swampscott' 'MA00532'='(MA00532) Topsfield'
                  'MA00533'='(MA00533) Wenham' 'MA00534'='(MA00534) West Newbury'
                  'MA00535'='(MA00535) Essex Met Dist Comm'
                  'MA00536'='(MA00536) Salem State College'
                  'MA00538'='(MA00538) Merrimack College'
                  'MA00598'='(MA00598) North Shore Comm College'
                  'MA005BA'='(MA005BA) Mbta: Essex County'
                  'MA005MV'='(MA005MV) Reg Of Mv: Essex County' 'MA00600'='(MA00600) Franklin'
                  'MA00601'='(MA00601) Ashfield' 'MA00602'='(MA00602) Bernardston'
                  'MA00603'='(MA00603) Buckland' 'MA00604'='(MA00604) Charlemont'
                  'MA00606'='(MA00606) Conway' 'MA00607'='(MA00607) Deerfield' 'MA00608'='(MA00608) Erving'
                  'MA00609'='(MA00609) Gill' 'MA00610'='(MA00610) Greenfield' 'MA00612'='(MA00612) Heath'
                  'MA00613'='(MA00613) Leverett' 'MA00614'='(MA00614) Leyden' 'MA00615'='(MA00615) Monroe'
                  'MA00616'='(MA00616) Montague' 'MA00617'='(MA00617) New Salem'
                  'MA00618'='(MA00618) Northfield' 'MA00619'='(MA00619) Orange' 'MA00620'='(MA00620) Rowe'
                  'MA00621'='(MA00621) Shelburne' 'MA00622'='(MA00622) Shutesbury'
                  'MA00623'='(MA00623) Sunderland' 'MA00624'='(MA00624) Warwick'
                  'MA00626'='(MA00626) Whately' 'MA006BA'='(MA006BA) Mbta: Franklin County'
                  'MA006MD'='(MA006MD) Franklin Met Dist Comm'
                  'MA006MV'='(MA006MV) Reg Of Mv: Franklin Cnty' 'MA00700'='(MA00700) Hampden'
                  'MA00701'='(MA00701) Agawam' 'MA00702'='(MA00702) Blandford'
                  'MA00703'='(MA00703) Brimfield' 'MA00704'='(MA00704) Chester'
                  'MA00705'='(MA00705) Chicopee' 'MA00706'='(MA00706) East Longmeadow'
                  'MA00707'='(MA00707) Granville' 'MA00708'='(MA00708) Hampden'
                  'MA00709'='(MA00709) Holland' 'MA00710'='(MA00710) Holyoke'
                  'MA00711'='(MA00711) Longmeadow' 'MA00712'='(MA00712) Ludlow'
                  'MA00713'='(MA00713) Monson' 'MA00715'='(MA00715) Palmer' 'MA00716'='(MA00716) Russell'
                  'MA00717'='(MA00717) Southwick' 'MA00718'='(MA00718) Springfield'
                  'MA00719'='(MA00719) Tolland' 'MA00720'='(MA00720) Wales'
                  'MA00721'='(MA00721) West Springfield' 'MA00722'='(MA00722) Westfield'
                  'MA00723'='(MA00723) Wilbraham' 'MA00724'='(MA00724) Westfield State College'
                  'MA00726'='(MA00726) Holyoke Community Colleg'
                  'MA00798'='(MA00798) Western New England Coll'
                  'MA0079E'='(MA0079E) Western New England Col'
                  'MA007BA'='(MA007BA) Mbta: Hampden County'
                  'MA007CC'='(MA007CC) Springfield Technical Cc'
                  'MA007CL'='(MA007CL) Springfield College'
                  'MA007MD'='(MA007MD) Hampden Met Dist Comm'
                  'MA007MV'='(MA007MV) Reg Of Mv: Hampden Cnty'
                  'MA007SC'='(MA007SC) Westfield State College' 'MA00800'='(MA00800) Hampshire'
                  'MA00801'='(MA00801) Amherst' 'MA00802'='(MA00802) Belchertown'
                  'MA00804'='(MA00804) Cummington' 'MA00805'='(MA00805) Easthampton'
                  'MA00806'='(MA00806) Goshen' 'MA00807'='(MA00807) Granby' 'MA00808'='(MA00808) Hadley'
                  'MA00809'='(MA00809) Hatfield' 'MA00810'='(MA00810) Huntington'
                  'MA00812'='(MA00812) Northampton' 'MA00813'='(MA00813) Pelham'
                  'MA00815'='(MA00815) South Hadley' 'MA00816'='(MA00816) Southampton'
                  'MA00817'='(MA00817) Ware' 'MA00818'='(MA00818) Westhampton'
                  'MA00819'='(MA00819) Williamsburg' 'MA00820'='(MA00820) Worthington'
                  'MA00821'='(MA00821) Hampshire Met Dist Comm'
                  'MA00822'='(MA00822) Univ Of Ma: Amherst'
                  'MA00823'='(MA00823) Mount Holyoke College'
                  'MA008BA'='(MA008BA) Mbta: Hampshire County'
                  'MA008MV'='(MA008MV) Reg Of Mv: Hampshire Cty' 'MA00900'='(MA00900) Middlesex'
                  'MA00901'='(MA00901) Acton' 'MA00902'='(MA00902) Arlington' 'MA00903'='(MA00903) Ashby'
                  'MA00904'='(MA00904) Ashland' 'MA00905'='(MA00905) Ayer' 'MA00906'='(MA00906) Bedford'
                  'MA00907'='(MA00907) Belmont' 'MA00908'='(MA00908) Billerica'
                  'MA00909'='(MA00909) Boxborough' 'MA00910'='(MA00910) Burlington'
                  'MA00911'='(MA00911) Cambridge' 'MA00912'='(MA00912) Carlisle'
                  'MA00913'='(MA00913) Chelmsford' 'MA00914'='(MA00914) Concord'
                  'MA00915'='(MA00915) Dracut' 'MA00916'='(MA00916) Dunstable'
                  'MA00917'='(MA00917) Everett' 'MA00918'='(MA00918) Framingham'
                  'MA00919'='(MA00919) Groton' 'MA00920'='(MA00920) Holliston'
                  'MA00921'='(MA00921) Hopkinton' 'MA00922'='(MA00922) Hudson'
                  'MA00923'='(MA00923) Lexington' 'MA00924'='(MA00924) Lincoln'
                  'MA00925'='(MA00925) Littleton' 'MA00926'='(MA00926) Lowell' 'MA00927'='(MA00927) Malden'
                  'MA00928'='(MA00928) Marlborough' 'MA00929'='(MA00929) Maynard'
                  'MA00930'='(MA00930) Medford' 'MA00931'='(MA00931) Melrose' 'MA00932'='(MA00932) Natick'
                  'MA00933'='(MA00933) Newton' 'MA00934'='(MA00934) North Reading'
                  'MA00935'='(MA00935) Pepperell' 'MA00936'='(MA00936) Reading'
                  'MA00937'='(MA00937) Sherborn' 'MA00938'='(MA00938) Shirley'
                  'MA00939'='(MA00939) Somerville' 'MA00940'='(MA00940) Stoneham'
                  'MA00941'='(MA00941) Stow' 'MA00942'='(MA00942) Sudbury' 'MA00943'='(MA00943) Tewksbury'
                  'MA00944'='(MA00944) Townsend' 'MA00945'='(MA00945) Tyngsboro'
                  'MA00946'='(MA00946) Wakefield' 'MA00947'='(MA00947) Waltham'
                  'MA00948'='(MA00948) Watertown' 'MA00949'='(MA00949) Wayland'
                  'MA00950'='(MA00950) Westford' 'MA00951'='(MA00951) Weston'
                  'MA00952'='(MA00952) Wilmington' 'MA00953'='(MA00953) Winchester'
                  'MA00954'='(MA00954) Woburn' 'MA00955'='(MA00955) Middlesex Met Dist Comm'
                  'MA00957'='(MA00957) Brandeis University' 'MA00958'='(MA00958) Bentley College'
                  'MA00959'='(MA00959) Framingham State College'
                  'MA00962'='(MA00962) Harvard University'
                  'MA00964'='(MA00964) Tufts University:Medford'
                  'MA00967'='(MA00967) Lasell College'
                  'MA009BA'='(MA009BA) Mbta: Middlesex County'
                  'MA009BC'='(MA009BC) Boston College' 'MA009CL'='(MA009CL) Bentley College'
                  'MA009IT'='(MA009IT) Mass Inst Of Technology'
                  'MA009MV'='(MA009MV) Reg Of Mv: Middlesex Cty'
                  'MA009SC'='(MA009SC) Framingham State College'
                  'MA009TU'='(MA009TU) Tufts University:Medford'
                  'MA009UN'='(MA009UN) Harvard University'
                  'MA009WU'='(MA009WU) Brandeis University' 'MA01000'='(MA01000) Nantucket'
                  'MA01001'='(MA01001) Nantucket' 'MA010BA'='(MA010BA) Mbta: Nantucket County'
                  'MA010MD'='(MA010MD) Nantucket Met Dist Comm'
                  'MA010MV'='(MA010MV) Reg Of Mv: Nantucket Cty' 'MA01100'='(MA01100) Norfolk'
                  'MA01101'='(MA01101) Avon' 'MA01102'='(MA01102) Bellingham'
                  'MA01103'='(MA01103) Braintree' 'MA01104'='(MA01104) Brookline'
                  'MA01105'='(MA01105) Canton' 'MA01106'='(MA01106) Cohasset' 'MA01107'='(MA01107) Dedham'
                  'MA01108'='(MA01108) Dover' 'MA01109'='(MA01109) Foxborough'
                  'MA01110'='(MA01110) Franklin' 'MA01111'='(MA01111) Holbrook'
                  'MA01112'='(MA01112) Medfield' 'MA01113'='(MA01113) Medway' 'MA01114'='(MA01114) Millis'
                  'MA01115'='(MA01115) Milton' 'MA01116'='(MA01116) Needham' 'MA01117'='(MA01117) Norfolk'
                  'MA01118'='(MA01118) Norwood' 'MA01119'='(MA01119) Plainville'
                  'MA01120'='(MA01120) Quincy' 'MA01121'='(MA01121) Randolph' 'MA01122'='(MA01122) Sharon'
                  'MA01123'='(MA01123) Stoughton' 'MA01124'='(MA01124) Walpole'
                  'MA01125'='(MA01125) Wellesley' 'MA01126'='(MA01126) Westwood'
                  'MA01127'='(MA01127) Weymouth' 'MA01128'='(MA01128) Wrentham'
                  'MA01129'='(MA01129) Norfolk Met Dist Comm' 'MA01131'='(MA01131) Dean College'
                  'MA011BA'='(MA011BA) Mbta: Norfolk County'
                  'MA011CL'='(MA011CL) Wellesley College'
                  'MA011MV'='(MA011MV) Reg Of Mv: Norfolk Cnty' 'MA01200'='(MA01200) Plymouth'
                  'MA01201'='(MA01201) Abington' 'MA01202'='(MA01202) Bridgewater'
                  'MA01203'='(MA01203) Brockton' 'MA01204'='(MA01204) Carver' 'MA01205'='(MA01205) Duxbury'
                  'MA01206'='(MA01206) East Bridgewater' 'MA01207'='(MA01207) Halifax'
                  'MA01208'='(MA01208) Hanover' 'MA01209'='(MA01209) Hanson' 'MA01210'='(MA01210) Hingham'
                  'MA01211'='(MA01211) Hull' 'MA01212'='(MA01212) Kingston' 'MA01213'='(MA01213) Lakeville'
                  'MA01214'='(MA01214) Marion' 'MA01215'='(MA01215) Marshfield'
                  'MA01216'='(MA01216) Mattapoisett' 'MA01217'='(MA01217) Middleboro'
                  'MA01218'='(MA01218) Norwell' 'MA01219'='(MA01219) Pembroke'
                  'MA01220'='(MA01220) Plymouth' 'MA01221'='(MA01221) Plympton'
                  'MA01222'='(MA01222) Rochester' 'MA01223'='(MA01223) Rockland'
                  'MA01224'='(MA01224) Scituate' 'MA01225'='(MA01225) Wareham'
                  'MA01226'='(MA01226) West Bridgewater' 'MA01227'='(MA01227) Whitman'
                  'MA01229'='(MA01229) Bridgewater State Colleg'
                  'MA01231'='(MA01231) Massasoit Community Coll'
                  'MA012BA'='(MA012BA) Mbta: Plymouth County'
                  'MA012MD'='(MA012MD) Plymouth Met Dist Comm'
                  'MA012MV'='(MA012MV) Reg Of Mv: Plymouth Cnty' 'MA01300'='(MA01300) Suffolk'
                  'MA01301'='(MA01301) Boston' 'MA01302'='(MA01302) Capitol Police'
                  'MA01303'='(MA01303) Chelsea' 'MA01304'='(MA01304) Revere' 'MA01305'='(MA01305) Winthrop'
                  'MA01306'='(MA01306) Suffolk Met Dist Comm'
                  'MA01309'='(MA01309) Bta: Suffolk County'
                  'MA01315'='(MA01315) Mass. Attorney General'
                  'MA01320'='(MA01320) Un Of Ma:Harbor Cam,Bost'
                  'MA01330'='(MA01330) Boston University'
                  'MA01333'='(MA01333) Northeastern University'
                  'MA01336'='(MA01336) Emerson College' 'MA01338'='(MA01338) Mass College Of Art'
                  'MA01339'='(MA01339) Tufts University:Suffolk'
                  'MA01355'='(MA01355) Wentworth Inst Of Tech'
                  'MA01398'='(MA01398) Emerson College'
                  'MA013BA'='(MA013BA) Mbta: Suffolk County'
                  'MA013BU'='(MA013BU) Boston University'
                  'MA013MV'='(MA013MV) Reg Of Mv: Suffolk Cnty'
                  'MA013NU'='(MA013NU) Northeastern University'
                  'MA013WI'='(MA013WI) Wentworth Inst Of Tech' 'MA01400'='(MA01400) Worcester'
                  'MA01401'='(MA01401) Ashburnham' 'MA01402'='(MA01402) Athol' 'MA01403'='(MA01403) Auburn'
                  'MA01404'='(MA01404) Barre' 'MA01405'='(MA01405) Berlin' 'MA01406'='(MA01406) Blackstone'
                  'MA01407'='(MA01407) Bolton' 'MA01408'='(MA01408) Boylston'
                  'MA01409'='(MA01409) Brookfield' 'MA01410'='(MA01410) Charlton'
                  'MA01411'='(MA01411) Clinton' 'MA01412'='(MA01412) Douglas' 'MA01413'='(MA01413) Dudley'
                  'MA01414'='(MA01414) East Brookfield' 'MA01415'='(MA01415) Fitchburg'
                  'MA01416'='(MA01416) Gardner' 'MA01417'='(MA01417) Grafton'
                  'MA01418'='(MA01418) Hardwick' 'MA01419'='(MA01419) Harvard' 'MA01420'='(MA01420) Holden'
                  'MA01421'='(MA01421) Hopedale' 'MA01422'='(MA01422) Hubbardston'
                  'MA01423'='(MA01423) Lancaster' 'MA01424'='(MA01424) Leicester'
                  'MA01425'='(MA01425) Leominster' 'MA01426'='(MA01426) Lunenburg'
                  'MA01427'='(MA01427) Mendon' 'MA01428'='(MA01428) Milford' 'MA01429'='(MA01429) Millbury'
                  'MA01430'='(MA01430) Millville' 'MA01431'='(MA01431) New Braintree'
                  'MA01432'='(MA01432) North Brookfield' 'MA01433'='(MA01433) Northborough'
                  'MA01434'='(MA01434) Northbridge' 'MA01435'='(MA01435) Oakham'
                  'MA01436'='(MA01436) Oxford' 'MA01437'='(MA01437) Paxton' 'MA01438'='(MA01438) Petersham'
                  'MA01439'='(MA01439) Phillipston' 'MA01440'='(MA01440) Princeton'
                  'MA01441'='(MA01441) Royalston' 'MA01442'='(MA01442) Rutland'
                  'MA01443'='(MA01443) Shrewsbury' 'MA01444'='(MA01444) Southborough'
                  'MA01445'='(MA01445) Southbridge' 'MA01446'='(MA01446) Spencer'
                  'MA01447'='(MA01447) Sterling' 'MA01448'='(MA01448) Sturbridge'
                  'MA01449'='(MA01449) Sutton' 'MA01450'='(MA01450) Templeton' 'MA01451'='(MA01451) Upton'
                  'MA01452'='(MA01452) Uxbridge' 'MA01453'='(MA01453) Warren' 'MA01454'='(MA01454) Webster'
                  'MA01455'='(MA01455) West Boylston' 'MA01456'='(MA01456) West Brookfield'
                  'MA01457'='(MA01457) Westborough' 'MA01458'='(MA01458) Westminster'
                  'MA01459'='(MA01459) Winchendon' 'MA01460'='(MA01460) Worcester'
                  'MA01461'='(MA01461) Un Of Ma: Med Ctr, Worc'
                  'MA01462'='(MA01462) Fitchburg State College'
                  'MA01464'='(MA01464) Tufts University:Worcest'
                  'MA01468'='(MA01468) Clark University' 'MA01470'='(MA01470) Assumption College'
                  'MA01472'='(MA01472) Quinsigamond Comm Colleg'
                  'MA0149E'='(MA0149E) Quinsigamond Comm Colleg'
                  'MA014BA'='(MA014BA) Mbta: Worcester County'
                  'MA014MD'='(MA014MD) Worcester Met Dist Comm'
                  'MA014MV'='(MA014MV) Reg Of Mv: Worcester Cty'
                  'MA014SC'='(MA014SC) Fitchburg State College'
                  'MA014UM'='(MA014UM) Un Of Ma:Med Ctr,Worcest'
                  'MA014UN'='(MA014UN) Clark University'
                  'MA014WS'='(MA014WS) Worcester State College'
                  'MA301SP'='(MA301SP) Sp: Barnstable County'
                  'MA302SP'='(MA302SP) Sp: Berkshire County'
                  'MA303SP'='(MA303SP) Sp: Bristol County' 'MA304SP'='(MA304SP) Sp: Dukes County'
                  'MA305SP'='(MA305SP) Sp: Essex County'
                  'MA306SP'='(MA306SP) Sp: Franklin County'
                  'MA307SP'='(MA307SP) Sp: Hampden County'
                  'MA308SP'='(MA308SP) Sp: Hampshire County'
                  'MA309SP'='(MA309SP) Sp: Middlesex County'
                  'MA310SP'='(MA310SP) Sp: Nantucket County'
                  'MA311SP'='(MA311SP) Sp: Norfolk County'
                  'MA312SP'='(MA312SP) Sp: Plymouth County'
                  'MA313SP'='(MA313SP) Sp: Suffolk County'
                  'MA314SP'='(MA314SP) Sp: Worcester County' 'MAMSP00'='(MAMSP00) State Police'
                  'MD00100'='(MD00100) Allegany' 'MD00102'='(MD00102) Cumberland'
                  'MD00103'='(MD00103) Frostburg' 'MD00104'='(MD00104) Lonaconing'
                  'MD00105'='(MD00105) Luke' 'MD00106'='(MD00106) Midland'
                  'MD00107'='(MD00107) Westernport'
                  'MD00108'='(MD00108) Frostburg State Universi'
                  'MD0013A'='(MD0013A) Allegany Co Investigator'
                  'MD00200'='(MD00200) Anne Arundel' 'MD00201'='(MD00201) Annapolis'
                  'MD00202'='(MD00202) Anne Arundel County Pd'
                  'MD00203'='(MD00203) Balt Wash Intl Airport'
                  'MD00204'='(MD00204) Investigative Servs Unit'
                  'MD00205'='(MD00205) Natural Resources Police'
                  'MD00206'='(MD00206) Md Forrest Park-Wildlife'
                  'MD00207'='(MD00207) Gen Srvcs:Annap, A ar Co'
                  'MD00210'='(MD00210) Comp Of Treasury, Fed'
                  'MD0023C'='(MD0023C) Dpscs Internal Invest Un'
                  'MD00300'='(MD00300) Baltimore County'
                  'MD00301'='(MD00301) Baltimore County Pol Dep'
                  'MD00302'='(MD00302) Sparrows Point'
                  'MD00303'='(MD00303) Md Port Auth Balt County'
                  'MD00304'='(MD00304) Univ Of Md:Balti County'
                  'MD00305'='(MD00305) Towson University' 'MD0035M'='(MD0035M) Rosewood'
                  'MD00401'='(MD00401) Transportation Authority'
                  'MD00402'='(MD00402) Univ Of Md:Baltimore Cit'
                  'MD00403'='(MD00403) Md Port Auth Balt City'
                  'MD00404'='(MD00404) Morgan State University'
                  'MD00406'='(MD00406) Baltimore City Sheriff'
                  'MD00407'='(MD00407) University Of Baltimore'
                  'MD00408'='(MD00408) State Fire Marshal'
                  'MD00409'='(MD00409) Gen Services:Balt City'
                  'MD00410'='(MD00410) Coppin State University'
                  'MD00412'='(MD00412) Transit Administration' 'MD00500'='(MD00500) Calvert'
                  'MD00501'='(MD00501) Chesapeake Beach' 'MD00502'='(MD00502) North Beach'
                  'MD00600'='(MD00600) Caroline' 'MD00601'='(MD00601) Denton'
                  'MD00602'='(MD00602) Federalsburg' 'MD00603'='(MD00603) Greensboro'
                  'MD00604'='(MD00604) Preston' 'MD00605'='(MD00605) Ridgely'
                  'MD00606'='(MD00606) Goldsboro' 'MD00607'='(MD00607) Marydel'
                  'MD00700'='(MD00700) Carroll' 'MD00701'='(MD00701) Hampstead'
                  'MD00702'='(MD00702) Manchester' 'MD00704'='(MD00704) New Windsor'
                  'MD00705'='(MD00705) Sykesville' 'MD00706'='(MD00706) Taneytown'
                  'MD00707'='(MD00707) Union Bridge' 'MD00708'='(MD00708) Westminster'
                  'MD00709'='(MD00709) Carrollton' 'MD00710'='(MD00710) Springfield Hospital'
                  'MD00800'='(MD00800) Cecil' 'MD00801'='(MD00801) Cecilton'
                  'MD00802'='(MD00802) Charlestown' 'MD00803'='(MD00803) Chesapeake City'
                  'MD00804'='(MD00804) Elkton' 'MD00805'='(MD00805) North East'
                  'MD00806'='(MD00806) Port Deposit' 'MD00807'='(MD00807) Rising Sun'
                  'MD00815'='(MD00815) Perryville' 'MD00900'='(MD00900) Charles'
                  'MD00901'='(MD00901) La Plata' 'MD01000'='(MD01000) Dorchester'
                  'MD01001'='(MD01001) Cambridge' 'MD01003'='(MD01003) Hurlock'
                  'MD01100'='(MD01100) Frederick' 'MD01101'='(MD01101) Brunswick'
                  'MD01102'='(MD01102) Emmitsburg' 'MD01103'='(MD01103) Frederick'
                  'MD01104'='(MD01104) Thurmont' 'MD01105'='(MD01105) Burkittsville'
                  'MD01200'='(MD01200) Garrett' 'MD01202'='(MD01202) Oakland'
                  'MD01203'='(MD01203) Grantsville' 'MD01300'='(MD01300) Harford'
                  'MD01301'='(MD01301) Aberdeen' 'MD01302'='(MD01302) Bel Air'
                  'MD01303'='(MD01303) Havre De Grace' 'MD01400'='(MD01400) Howard'
                  'MD01401'='(MD01401) Howard County Police Dep' 'MD01500'='(MD01500) Kent'
                  'MD01502'='(MD01502) Chestertown' 'MD01504'='(MD01504) Rock Hall'
                  'MD01600'='(MD01600) Montgomery' 'MD01601'='(MD01601) Chevy Chase Village'
                  'MD01602'='(MD01602) Gaithersburg'
                  'MD01603'='(MD01603) Nat Cap Park P:montgomer'
                  'MD01604'='(MD01604) Montgomery County Pd' 'MD01605'='(MD01605) Rockville'
                  'MD01606'='(MD01606) Takoma Park' 'MD01609'='(MD01609) Great Oaks'
                  'MD01700'='(MD01700) Prince Georges' 'MD01701'='(MD01701) Berwyn Heights'
                  'MD01702'='(MD01702) Bladensburg' 'MD01703'='(MD01703) Brentwood'
                  'MD01704'='(MD01704) Capitol Heights' 'MD01705'='(MD01705) Cheverly'
                  'MD01706'='(MD01706) College Park' 'MD01707'='(MD01707) Colmar Manor'
                  'MD01708'='(MD01708) Cottage City' 'MD01709'='(MD01709) District Heights'
                  'MD01710'='(MD01710) Edmonston' 'MD01711'='(MD01711) Fairmount Heights'
                  'MD01712'='(MD01712) Forest Heights' 'MD01713'='(MD01713) Glenarden'
                  'MD01714'='(MD01714) Greenbelt' 'MD01715'='(MD01715) Hyattsville'
                  'MD01716'='(MD01716) Landover Hills' 'MD01717'='(MD01717) Laurel'
                  'MD01718'='(MD01718) Morningside' 'MD01719'='(MD01719) Mount Rainier'
                  'MD01720'='(MD01720) North Brentwood'
                  'MD01721'='(MD01721) Prince Georges Cnty Pd'
                  'MD01722'='(MD01722) Riverdale Park' 'MD01723'='(MD01723) Seat Pleasant'
                  'MD01724'='(MD01724) Upper Marlboro'
                  'MD01725'='(MD01725) Univ Of Md:College Park'
                  'MD01726'='(MD01726) University Park'
                  'MD01727'='(MD01727) Nat Cap Park P:prince Ge'
                  'MD01728'='(MD01728) Bowie State University'
                  'MD01729'='(MD01729) Takoma Park Prince Geo'
                  'MD01739'='(MD01739) New Carrollton' 'MD01800'='(MD01800) Queen Annes'
                  'MD01801'='(MD01801) Centreville' 'MD01900'='(MD01900) St. Marys'
                  'MD01901'='(MD01901) Leonardtown' 'MD01902'='(MD01902) St. Marys College'
                  'MD02000'='(MD02000) Somerset' 'MD02001'='(MD02001) Crisfield'
                  'MD02002'='(MD02002) Princess Anne'
                  'MD02003'='(MD02003) Univ Of Md:Eastern Shore' 'MD02100'='(MD02100) Talbot'
                  'MD02101'='(MD02101) Easton' 'MD02102'='(MD02102) Oxford'
                  'MD02103'='(MD02103) St. Michaels' 'MD02104'='(MD02104) Trappe'
                  'MD02200'='(MD02200) Washington' 'MD02201'='(MD02201) Boonsboro'
                  'MD02203'='(MD02203) Hagerstown' 'MD02204'='(MD02204) Hancock'
                  'MD02205'='(MD02205) Smithsburg' 'MD02206'='(MD02206) Antietam'
                  'MD02208'='(MD02208) Williamsport' 'MD02300'='(MD02300) Wicomico'
                  'MD02301'='(MD02301) Delmar' 'MD02302'='(MD02302) Fruitland'
                  'MD02303'='(MD02303) Salisbury' 'MD02304'='(MD02304) Salisbury University'
                  'MD02400'='(MD02400) Worcester' 'MD02401'='(MD02401) Berlin'
                  'MD02402'='(MD02402) Ocean City' 'MD02403'='(MD02403) Pocomoke City'
                  'MD02404'='(MD02404) Snow Hill' 'MD02405'='(MD02405) Ocean Pines'
                  'MD300SP'='(MD300SP) Sp: Baltimore City'
                  'MD301SP'='(MD301SP) Sp: Allegany County'
                  'MD302SP'='(MD302SP) Sp: Anne Arundel County'
                  'MD303SP'='(MD303SP) Sp: Baltimore County'
                  'MD304SP'='(MD304SP) Sp: Calvert County'
                  'MD305SP'='(MD305SP) Sp: Caroline County'
                  'MD306SP'='(MD306SP) Sp: Carroll County' 'MD307SP'='(MD307SP) Sp: Cecil County'
                  'MD308SP'='(MD308SP) Sp: Charles County'
                  'MD309SP'='(MD309SP) Sp: Dorchester County'
                  'MD310SP'='(MD310SP) Sp: Frederick County'
                  'MD311SP'='(MD311SP) Sp: Garrett County'
                  'MD312SP'='(MD312SP) Sp: Harford County'
                  'MD313SP'='(MD313SP) Sp: Howard County' 'MD314SP'='(MD314SP) Sp: Kent County'
                  'MD315SP'='(MD315SP) Sp: Montgomery County'
                  'MD316SP'='(MD316SP) Sp: Prince Georges Cnty'
                  'MD317SP'='(MD317SP) Sp: Queen Annes County'
                  'MD318SP'='(MD318SP) Sp: St. Marys County'
                  'MD319SP'='(MD319SP) Sp: Somerset County'
                  'MD320SP'='(MD320SP) Sp: Talbot County'
                  'MD321SP'='(MD321SP) Sp: Washington County'
                  'MD322SP'='(MD322SP) Sp: Wicomico County'
                  'MD323SP'='(MD323SP) Sp: Worcester County' 'MD324SP'='(MD324SP) Msp Statewide'
                  'MDBPD00'='(MDBPD00) Baltimore' 'MDMSP00'='(MDMSP00) Maryland State Police'
                  'MDPPD00'='(MDPPD00) U s Park Police' 'ME00100'='(ME00100) Androscoggin'
                  'ME00101'='(ME00101) Auburn' 'ME00102'='(ME00102) Lewiston'
                  'ME00103'='(ME00103) Livermore Falls' 'ME00105'='(ME00105) Lisbon'
                  'ME00106'='(ME00106) Mechanic Falls' 'ME00107'='(ME00107) Sabattus'
                  'ME001BI'='(ME001BI) Dea: Androscoggin County'
                  'ME001LE'='(ME001LE) Ble: Androscoggin County'
                  'ME001SP'='(ME001SP) Sp: Androscoggin County' 'ME00200'='(ME00200) Aroostook'
                  'ME00201'='(ME00201) Caribou' 'ME00202'='(ME00202) Fort Fairfield'
                  'ME00203'='(ME00203) Fort Kent' 'ME00204'='(ME00204) Houlton'
                  'ME00205'='(ME00205) Madawaska' 'ME00206'='(ME00206) Presque Isle'
                  'ME00207'='(ME00207) Van Buren' 'ME00208'='(ME00208) Ashland'
                  'ME00210'='(ME00210) Limestone' 'ME00216'='(ME00216) Washburn'
                  'ME00221'='(ME00221) Univ Of Me: Presque Isle'
                  'ME002BI'='(ME002BI) Dea: Aroostook County'
                  'ME002LE'='(ME002LE) Ble: Aroostook County'
                  'ME002SP'='(ME002SP) Sp: Aroostook County' 'ME00300'='(ME00300) Cumberland'
                  'ME00301'='(ME00301) Brunswick' 'ME00302'='(ME00302) Cape Elizabeth'
                  'ME00303'='(ME00303) Falmouth' 'ME00304'='(ME00304) Gorham'
                  'ME00305'='(ME00305) Portland' 'ME00306'='(ME00306) South Portland'
                  'ME00307'='(ME00307) Scarborough' 'ME00308'='(ME00308) Westbrook'
                  'ME00309'='(ME00309) Bridgton' 'ME00310'='(ME00310) Cumberland'
                  'ME00311'='(ME00311) Freeport' 'ME00313'='(ME00313) New Gloucester'
                  'ME00314'='(ME00314) Yarmouth' 'ME00315'='(ME00315) Windham'
                  'ME00318'='(ME00318) Univ Of Southern Maine' 'ME00319'='(ME00319) Standish'
                  'ME003BI'='(ME003BI) Dea: Cumberland County'
                  'ME003LE'='(ME003LE) Ble: Cumberland County'
                  'ME003SP'='(ME003SP) Sp: Cumberland County' 'ME00400'='(ME00400) Franklin'
                  'ME00401'='(ME00401) Farmington' 'ME00402'='(ME00402) Jay' 'ME00403'='(ME00403) Wilton'
                  'ME00404'='(ME00404) Rangeley' 'ME00406'='(ME00406) Univ Of Me: Farmington'
                  'ME00407'='(ME00407) Carrabassett Valley'
                  'ME004BI'='(ME004BI) Dea: Franklin County'
                  'ME004LE'='(ME004LE) Ble: Franklin County'
                  'ME004SP'='(ME004SP) Sp: Franklin County' 'ME00500'='(ME00500) Hancock'
                  'ME00501'='(ME00501) Bar Harbor' 'ME00502'='(ME00502) Ellsworth'
                  'ME00503'='(ME00503) Bucksport' 'ME00504'='(ME00504) Mount Desert'
                  'ME00506'='(ME00506) Stonington' 'ME00508'='(ME00508) Southwest Harbor'
                  'ME00513'='(ME00513) Gouldsboro' 'ME00514'='(ME00514) Swans Island'
                  'ME00515'='(ME00515) Winter Harbor' 'ME005BI'='(ME005BI) Dea: Hancock County'
                  'ME005LE'='(ME005LE) Ble: Hancock County'
                  'ME005SP'='(ME005SP) Sp: Hancock County' 'ME00600'='(ME00600) Kennebec'
                  'ME00601'='(ME00601) Augusta' 'ME00602'='(ME00602) Gardiner'
                  'ME00603'='(ME00603) Hallowell' 'ME00604'='(ME00604) Waterville'
                  'ME00605'='(ME00605) Oakland' 'ME00606'='(ME00606) Monmouth'
                  'ME00607'='(ME00607) Winslow' 'ME00608'='(ME00608) Winthrop'
                  'ME00616'='(ME00616) Litchfield' 'ME00621'='(ME00621) Clinton'
                  'ME006BI'='(ME006BI) Dea: Kennebec County'
                  'ME006LE'='(ME006LE) Ble: Kennebec County'
                  'ME006SP'='(ME006SP) Sp: Kennebec County' 'ME00700'='(ME00700) Knox'
                  'ME00701'='(ME00701) Camden' 'ME00702'='(ME00702) Rockland'
                  'ME00703'='(ME00703) Thomaston' 'ME00704'='(ME00704) Rockport'
                  'ME00705'='(ME00705) Vinalhaven' 'ME007BI'='(ME007BI) Dea: Knox County'
                  'ME007LE'='(ME007LE) Ble: Knox County' 'ME007SP'='(ME007SP) Sp: Knox County'
                  'ME00800'='(ME00800) Lincoln' 'ME00801'='(ME00801) Boothbay Harbor'
                  'ME00802'='(ME00802) Damariscotta' 'ME00803'='(ME00803) Waldoboro'
                  'ME00804'='(ME00804) Wiscasset' 'ME008BI'='(ME008BI) Dea: Lincoln County'
                  'ME008LE'='(ME008LE) Ble: Lincoln County'
                  'ME008SP'='(ME008SP) Sp: Lincoln County' 'ME00900'='(ME00900) Oxford'
                  'ME00901'='(ME00901) Rumford' 'ME00902'='(ME00902) Dixfield' 'ME00903'='(ME00903) Mexico'
                  'ME00904'='(ME00904) Norway' 'ME00905'='(ME00905) Paris' 'ME00906'='(ME00906) Bethel'
                  'ME00907'='(ME00907) Fryeburg' 'ME00910'='(ME00910) Oxford'
                  'ME009BI'='(ME009BI) Dea: Oxford County'
                  'ME009LE'='(ME009LE) Ble: Oxford County'
                  'ME009SP'='(ME009SP) Sp: Oxford County' 'ME01000'='(ME01000) Penobscot'
                  'ME01001'='(ME01001) Bangor' 'ME01002'='(ME01002) Brewer' 'ME01003'='(ME01003) Dexter'
                  'ME01004'='(ME01004) Lincoln' 'ME01005'='(ME01005) Old Town' 'ME01006'='(ME01006) Orono'
                  'ME01007'='(ME01007) Hampden' 'ME01008'='(ME01008) Mattawamkeag'
                  'ME01009'='(ME01009) Millinocket' 'ME01010'='(ME01010) East Millinocket'
                  'ME01011'='(ME01011) Newport' 'ME01012'='(ME01012) Eddington'
                  'ME01013'='(ME01013) Veazie' 'ME01014'='(ME01014) Medway' 'ME01015'='(ME01015) Howland'
                  'ME01018'='(ME01018) Univ Of Me: Orono'
                  'ME01020'='(ME01020) Penobscot Indian Island' 'ME01027'='(ME01027) Holden'
                  'ME010BI'='(ME010BI) Dea: Penobscot County'
                  'ME010LE'='(ME010LE) Ble: Penobscot County'
                  'ME010SP'='(ME010SP) Sp: Penobscot County' 'ME01100'='(ME01100) Piscataquis'
                  'ME01101'='(ME01101) Dover-Foxcroft' 'ME01102'='(ME01102) Milo'
                  'ME01104'='(ME01104) Brownville' 'ME01105'='(ME01105) Greenville'
                  'ME011BI'='(ME011BI) Dea: Piscataquis County'
                  'ME011LE'='(ME011LE) Ble: Piscataquis County'
                  'ME011SP'='(ME011SP) Sp: Piscataquis County' 'ME01200'='(ME01200) Sagadahoc'
                  'ME01201'='(ME01201) Bath' 'ME01202'='(ME01202) Topsham' 'ME01203'='(ME01203) Richmond'
                  'ME01205'='(ME01205) Phippsburg' 'ME012BI'='(ME012BI) Dea: Sagadahoc County'
                  'ME012LE'='(ME012LE) Ble: Sagadahoc County'
                  'ME012SP'='(ME012SP) Sp: Sagadahoc County' 'ME01300'='(ME01300) Somerset'
                  'ME01301'='(ME01301) Fairfield' 'ME01302'='(ME01302) Skowhegan'
                  'ME01303'='(ME01303) Madison' 'ME01304'='(ME01304) Pittsfield'
                  'ME01308'='(ME01308) Norridgewock' 'ME013BI'='(ME013BI) Dea: Somerset County'
                  'ME013LE'='(ME013LE) Ble: Somerset County'
                  'ME013SP'='(ME013SP) Sp: Somerset County' 'ME01400'='(ME01400) Waldo'
                  'ME01401'='(ME01401) Belfast' 'ME01402'='(ME01402) Searsport'
                  'ME014BI'='(ME014BI) Dea: Waldo County' 'ME014LE'='(ME014LE) Ble: Waldo County'
                  'ME014SP'='(ME014SP) Sp: Waldo County' 'ME01500'='(ME01500) Washington'
                  'ME01501'='(ME01501) Calais' 'ME01502'='(ME01502) Eastport' 'ME01503'='(ME01503) Machias'
                  'ME01504'='(ME01504) Princeton' 'ME01506'='(ME01506) Lubec'
                  'ME01507'='(ME01507) Jonesport' 'ME01509'='(ME01509) Baileyville'
                  'ME01511'='(ME01511) Passamaquoddy Pleasant P'
                  'ME01512'='(ME01512) passamaquoddy Indian Twn'
                  'ME01514'='(ME01514) Swans Island' 'ME01517'='(ME01517) Milbridge'
                  'ME015BI'='(ME015BI) Dea: Washington County'
                  'ME015LE'='(ME015LE) Ble: Washington County'
                  'ME015SP'='(ME015SP) Sp: Washington County' 'ME01600'='(ME01600) York'
                  'ME01601'='(ME01601) Biddeford' 'ME01602'='(ME01602) Kittery'
                  'ME01603'='(ME01603) Old Orchard Beach' 'ME01604'='(ME01604) Saco'
                  'ME01605'='(ME01605) Sanford' 'ME01606'='(ME01606) Berwick' 'ME01607'='(ME01607) Eliot'
                  'ME01608'='(ME01608) Kennebunk' 'ME01609'='(ME01609) Kennebunkport'
                  'ME01610'='(ME01610) Lebanon' 'ME01611'='(ME01611) North Berwick'
                  'ME01612'='(ME01612) Ogunquit' 'ME01613'='(ME01613) South Berwick'
                  'ME01614'='(ME01614) Wells' 'ME01615'='(ME01615) York Beach' 'ME01616'='(ME01616) York'
                  'ME01618'='(ME01618) Buxton' 'ME016BI'='(ME016BI) Dea: York County'
                  'ME016LE'='(ME016LE) Ble: York County' 'ME016SP'='(ME016SP) Sp: York County'
                  'MEMSP00'='(MEMSP00) State Police' 'MI01001'='(MI01001) Sp: Alcona County'
                  'MI01101'='(MI01101) Alcona' 'MI01461'='(MI01461) Harrisville'
                  'MI01533'='(MI01533) Lincoln' 'MI02002'='(MI02002) Sp: Alger County'
                  'MI02102'='(MI02102) Alger' 'MI02602'='(MI02602) Munising'
                  'MI03003'='(MI03003) Sp: Allegan County' 'MI03103'='(MI03103) Allegan'
                  'MI03210'='(MI03210) Allegan' 'MI03353'='(MI03353) Douglas'
                  'MI03392'='(MI03392) Fennville' 'MI03478'='(MI03478) Hopkins'
                  'MI03561'='(MI03561) Martin Township' 'MI03641'='(MI03641) Otsego'
                  'MI03670'='(MI03670) Plainwell' 'MI03733'='(MI03733) Saugatuck'
                  'MI03811'='(MI03811) Wayland' 'MI03936'='(MI03936) Martin'
                  'MI04004'='(MI04004) Sp: Alpena County' 'MI04104'='(MI04104) Alpena'
                  'MI04215'='(MI04215) Alpena' 'MI05005'='(MI05005) Sp: Antrim County'
                  'MI05105'='(MI05105) Antrim' 'MI05245'='(MI05245) Bellaire'
                  'MI05304'='(MI05304) Central Lake' 'MI05375'='(MI05375) Elk Rapids'
                  'MI05377'='(MI05377) Ellsworth' 'MI05548'='(MI05548) Mancelona'
                  'MI06006'='(MI06006) Sp: Arenac County' 'MI06106'='(MI06106) Arenac'
                  'MI06760'='(MI06760) Standish' 'MI07007'='(MI07007) Sp: Baraga County'
                  'MI07107'='(MI07107) Baraga' 'MI07232'='(MI07232) Baraga' 'MI07518'='(MI07518) Lanse'
                  'MI08008'='(MI08008) Sp: Barry County' 'MI08108'='(MI08108) Barry'
                  'MI08234'='(MI08234) Barry Township' 'MI08410'='(MI08410) Freeport'
                  'MI08464'='(MI08464) Hastings' 'MI08582'='(MI08582) Middleville'
                  'MI08607'='(MI08607) Nashville' 'MI08685'='(MI08685) Prairieville Township'
                  'MI08832'='(MI08832) Woodland Township' 'MI09009'='(MI09009) Sp: Bay County'
                  'MI09109'='(MI09109) Bay' 'MI09223'='(MI09223) Auburn' 'MI09239'='(MI09239) Bay City'
                  'MI09383'='(MI09383) Essexville' 'MI09668'='(MI09668) Pinconning'
                  'MI09882'='(MI09882) Delta College' 'MI09915'='(MI09915) Hampton Township'
                  'MI10010'='(MI10010) Sp: Benzie County' 'MI10110'='(MI10110) Benzie'
                  'MI10254'='(MI10254) Beulah' 'MI10374'='(MI10374) Elberta'
                  'MI10407'='(MI10407) Frankfort' 'MI10477'='(MI10477) Honor'
                  'MI11011'='(MI11011) Sp: Berrien County' 'MI11111'='(MI11111) Berrien'
                  'MI11248'='(MI11248) Benton Harbor' 'MI11249'='(MI11249) Benton Township'
                  'MI11252'='(MI11252) Berrien Springs-Oronoko' 'MI11268'='(MI11268) Bridgman'
                  'MI11276'='(MI11276) Buchanan' 'MI11324'='(MI11324) Coloma City'
                  'MI11368'='(MI11368) Eau Claire' 'MI11418'='(MI11418) Galien'
                  'MI11430'='(MI11430) Grand Beach' 'MI11579'='(MI11579) Michiana'
                  'MI11611'='(MI11611) New Buffalo' 'MI11619'='(MI11619) Niles'
                  'MI11726'='(MI11726) St. Joseph' 'MI11766'='(MI11766) Lincoln Township'
                  'MI11779'='(MI11779) Three Oaks' 'MI11810'='(MI11810) Watervliet'
                  'MI11846'='(MI11846) Niles Township' 'MI11853'='(MI11853) Coloma Township'
                  'MI11871'='(MI11871) Chikaming Township'
                  'MI11877'='(MI11877) St. Joseph Township'
                  'MI12012'='(MI12012) Sp: Branch County' 'MI12112'='(MI12112) Branch'
                  'MI12272'='(MI12272) Bronson' 'MI12322'='(MI12322) Coldwater'
                  'MI12688'='(MI12688) Quincy' 'MI12743'='(MI12743) Sherwood Township'
                  'MI12790'='(MI12790) Union City' 'MI13013'='(MI13013) Sp: Calhoun County'
                  'MI13113'='(MI13113) Calhoun' 'MI13207'='(MI13207) Albion'
                  'MI13237'='(MI13237) Battle Creek' 'MI13238'='(MI13238) Battle Creek Township'
                  'MI13243'='(MI13243) Bedford Township' 'MI13379'='(MI13379) Emmett Township'
                  'MI13476'='(MI13476) Homer' 'MI13560'='(MI13560) Marshall'
                  'MI13655'='(MI13655) Pennfield Township' 'MI13757'='(MI13757) Springfield'
                  'MI14014'='(MI14014) Sp: Cass County' 'MI14114'='(MI14114) Cass'
                  'MI14297'='(MI14297) Cassopolis' 'MI14354'='(MI14354) Dowagiac'
                  'MI14372'='(MI14372) Ontwa Twp-Edwardsburg' 'MI14554'='(MI14554) Marcellus'
                  'MI14793'='(MI14793) Vandalia' 'MI14858'='(MI14858) Howard Township'
                  'MI15015'='(MI15015) Sp: Charlevoix County' 'MI15115'='(MI15115) Charlevoix'
                  'MI15264'='(MI15264) Boyne City' 'MI15265'='(MI15265) Boyne Falls'
                  'MI15306'='(MI15306) Charlevoix' 'MI15362'='(MI15362) East Jordan'
                  'MI16016'='(MI16016) Sp: Cheboygan County' 'MI16116'='(MI16116) Cheboygan'
                  'MI16309'='(MI16309) Cheboygan' 'MI16546'='(MI16546) Mackinaw City'
                  'MI16847'='(MI16847) Tuscarora Township'
                  'MI17017'='(MI17017) Sp: Chippewa County' 'MI17117'='(MI17117) Chippewa'
                  'MI17348'='(MI17348) Detour Village' 'MI17508'='(MI17508) Kinross Township'
                  'MI17734'='(MI17734) Sault Ste. Marie' 'MI18018'='(MI18018) Sp: Clare County'
                  'MI18118'='(MI18118) Clare' 'MI18313'='(MI18313) Clare' 'MI18390'='(MI18390) Farwell'
                  'MI18411'='(MI18411) Frost Township' 'MI18460'='(MI18460) Harrison'
                  'MI19019'='(MI19019) Sp: Clinton County' 'MI19119'='(MI19119) Clinton'
                  'MI19236'='(MI19236) Bath Township' 'MI19350'='(MI19350) Dewitt'
                  'MI19378'='(MI19378) Elsie' 'MI19404'='(MI19404) Fowler'
                  'MI19553'='(MI19553) Maple Rapids' 'MI19643'='(MI19643) Ovid'
                  'MI19725'='(MI19725) St. Johns' 'MI19857'='(MI19857) Dewitt Township'
                  'MI19891'='(MI19891) Capitol Region Airport A'
                  'MI20020'='(MI20020) sp: Crawford County' 'MI20120'='(MI20120) Crawford'
                  'MI20440'='(MI20440) Grayling' 'MI20956'='(MI20956) Camp Grayling'
                  'MI21021'='(MI21021) Sp: Delta County' 'MI21121'='(MI21121) Delta'
                  'MI21382'='(MI21382) Escanaba' 'MI21419'='(MI21419) Garden'
                  'MI21424'='(MI21424) Gladstone' 'MI22022'='(MI22022) Sp: Dickinson County'
                  'MI22122'='(MI22122) Dickinson' 'MI22492'='(MI22492) Iron Mountain'
                  'MI22507'='(MI22507) Kingsford' 'MI22626'='(MI22626) Norway'
                  'MI23023'='(MI23023) Sp: Eaton County' 'MI23123'='(MI23123) Eaton'
                  'MI23247'='(MI23247) Bellevue' 'MI23307'='(MI23307) Charlotte'
                  'MI23352'='(MI23352) Dimondale' 'MI23367'='(MI23367) Eaton Rapids'
                  'MI23435'='(MI23435) Grand Ledge' 'MI23601'='(MI23601) Mulliken'
                  'MI23630'='(MI23630) Olivet' 'MI23681'='(MI23681) Potterville'
                  'MI23771'='(MI23771) Sunfield' 'MI23796'='(MI23796) Vermontville Township'
                  'MI24024'='(MI24024) Sp: Emmet County' 'MI24124'='(MI24124) Emmet'
                  'MI24457'='(MI24457) Harbor Springs' 'MI24654'='(MI24654) Pellston'
                  'MI24662'='(MI24662) Petoskey' 'MI25025'='(MI25025) Sp: Genesee County'
                  'MI25125'='(MI25125) Genesee' 'MI25219'='(MI25219) Argentine Township'
                  'MI25221'='(MI25221) Atlas Township'
                  'MI25257'='(MI25257) Bishop International Air'
                  'MI25314'='(MI25314) Clayton Township' 'MI25321'='(MI25321) Clio'
                  'MI25342'='(MI25342) Davison' 'MI25393'='(MI25393) Fenton' 'MI25398'='(MI25398) Flint'
                  'MI25399'='(MI25399) Flint Township' 'MI25400'='(MI25400) Flushing'
                  'MI25401'='(MI25401) Flushing Township' 'MI25416'='(MI25416) Gaines'
                  'MI25422'='(MI25422) Genesee Township' 'MI25429'='(MI25429) Goodrich'
                  'MI25431'='(MI25431) Grand Blanc' 'MI25535'='(MI25535) Linden'
                  'MI25593'='(MI25593) Montrose' 'MI25598'='(MI25598) Mount Morris'
                  'MI25601'='(MI25601) Mundy Township' 'MI25640'='(MI25640) Otisville'
                  'MI25772'='(MI25772) Swartz Creek' 'MI25839'='(MI25839) Burton'
                  'MI25845'='(MI25845) Mount Morris Township'
                  'MI25852'='(MI25852) Grand Blanc Township'
                  'MI25859'='(MI25859) Vienna Township' 'MI25860'='(MI25860) Davison Township'
                  'MI25869'='(MI25869) Richfield Township'
                  'MI25899'='(MI25899) Montrose Township' 'MI25904'='(MI25904) Univ Of Mi: Flint'
                  'MI25950'='(MI25950) Mott Community College'
                  'MI26026'='(MI26026) Sp: Gladwin County' 'MI26126'='(MI26126) Gladwin'
                  'MI26242'='(MI26242) Beaverton' 'MI26425'='(MI26425) Gladwin'
                  'MI27027'='(MI27027) Sp: Gogebic County' 'MI27127'='(MI27127) Gogebic'
                  'MI27253'='(MI27253) Bessemer' 'MI27494'='(MI27494) Ironwood'
                  'MI27555'='(MI27555) Marenisco Township' 'MI27800'='(MI27800) Wakefield'
                  'MI27809'='(MI27809) Watersmeet Township'
                  'MI28028'='(MI28028) Sp: Grand Traverse Cnty'
                  'MI28128'='(MI28128) Grand Traverse' 'MI28781'='(MI28781) Traverse City'
                  'MI29029'='(MI29029) Sp: Gratiot County' 'MI29129'='(MI29129) Gratiot'
                  'MI29213'='(MI29213) Alma' 'MI29266'='(MI29266) Breckenridge'
                  'MI29496'='(MI29496) Ithaca' 'MI29727'='(MI29727) St. Louis'
                  'MI30030'='(MI30030) Sp: Hillsdale County' 'MI30130'='(MI30130) Hillsdale'
                  'MI30473'='(MI30473) Hillsdale' 'MI30498'='(MI30498) Jonesville'
                  'MI30536'='(MI30536) Litchfield' 'MI30692'='(MI30692) Reading'
                  'MI30745'='(MI30745) Somerset Township' 'MI30801'='(MI30801) Waldron'
                  'MI30910'='(MI30910) Camden' 'MI31031'='(MI31031) Sp: Houghton County'
                  'MI31131'='(MI31131) Houghton' 'MI31200'='(MI31200) Adams Township'
                  'MI31284'='(MI31284) Calumet' 'MI31332'='(MI31332) Copper City'
                  'MI31454'='(MI31454) Hancock' 'MI31480'='(MI31480) Houghton'
                  'MI31514'='(MI31514) Lake Linden' 'MI31522'='(MI31522) Laurium'
                  'MI31749'='(MI31749) South Range'
                  'MI31885'='(MI31885) Mich Technological Unive'
                  'MI32032'='(MI32032) Sp: Huron County' 'MI32132'='(MI32132) Huron'
                  'MI32228'='(MI32228) Bad Axe' 'MI32293'='(MI32293) Caseville'
                  'MI32294'='(MI32294) Caseville Township' 'MI32376'='(MI32376) Elkton'
                  'MI32387'='(MI32387) Fair Haven Township' 'MI32456'='(MI32456) Harbor Beach'
                  'MI32506'='(MI32506) Kinde' 'MI32644'='(MI32644) Owendale' 'MI32666'='(MI32666) Pigeon'
                  'MI32674'='(MI32674) Port Austin' 'MI32738'='(MI32738) Sebewaing'
                  'MI32789'='(MI32789) Ubly' 'MI33001'='(MI33001) Michigan State Police'
                  'MI33033'='(MI33033) Sp: Ingham County' 'MI33133'='(MI33133) Ingham'
                  'MI33364'='(MI33364) East Lansing' 'MI33519'='(MI33519) Lansing'
                  'MI33528'='(MI33528) Leslie' 'MI33563'='(MI33563) Mason'
                  'MI33581'='(MI33581) Michigan State Universit'
                  'MI33767'='(MI33767) Stockbridge' 'MI33813'='(MI33813) Webberville'
                  'MI33826'='(MI33826) Williamston' 'MI33843'='(MI33843) Lansing Township'
                  'MI33848'='(MI33848) Delhi Township'
                  'MI33886'='(MI33886) Lansing Community Colleg'
                  'MI33926'='(MI33926) Meridian Township' 'MI34034'='(MI34034) Sp: Ionia County'
                  'MI34134'='(MI34134) Ionia' 'MI34244'='(MI34244) Belding' 'MI34491'='(MI34491) Ionia'
                  'MI34515'='(MI34515) Lake Odessa' 'MI34679'='(MI34679) Portland'
                  'MI35035'='(MI35035) Sp: Iosco County' 'MI35135'='(MI35135) Iosco'
                  'MI35365'='(MI35365) East Tawas' 'MI35639'='(MI35639) Oscoda Township'
                  'MI35774'='(MI35774) Tawas City' 'MI36036'='(MI36036) Sp: Iron County'
                  'MI36136'='(MI36136) Iron' 'MI36216'='(MI36216) Alpha' 'MI36295'='(MI36295) Caspian'
                  'MI36338'='(MI36338) Crystal Falls' 'MI36414'='(MI36414) Gaastra'
                  'MI36493'='(MI36493) Iron River' 'MI36759'='(MI36759) Stambaugh'
                  'MI37037'='(MI37037) Sp: Isabella County' 'MI37137'='(MI37137) Isabella'
                  'MI37599'='(MI37599) Mount Pleasant' 'MI37741'='(MI37741) Shepherd'
                  'MI37870'='(MI37870) Central Michigan Univ'
                  'MI38038'='(MI38038) Sp: Jackson County' 'MI38138'='(MI38138) Jackson'
                  'MI38273'='(MI38273) Brooklyn' 'MI38326'='(MI38326) Columbia Township'
                  'MI38327'='(MI38327) Concord' 'MI38439'='(MI38439) Grass Lake'
                  'MI38455'='(MI38455) Hanover' 'MI38468'='(MI38468) Henrietta Township'
                  'MI38497'='(MI38497) Jackson' 'MI38527'='(MI38527) Leoni Township'
                  'MI38606'='(MI38606) Napoleon Township' 'MI38649'='(MI38649) Parma-Sandstone'
                  'MI38755'='(MI38755) Spring Arbor Township'
                  'MI38758'='(MI38758) Springport Township' 'MI38769'='(MI38769) Summit Township'
                  'MI38890'='(MI38890) Blackman Township' 'MI38911'='(MI38911) Hanover Township'
                  'MI38922'='(MI38922) Norvell Township' 'MI38932'='(MI38932) Waterloo Township'
                  'MI39039'='(MI39039) Sp: Kalamazoo County' 'MI39139'='(MI39139) Kalamazoo'
                  'MI39226'='(MI39226) Augusta' 'MI39319'='(MI39319) Climax'
                  'MI39417'='(MI39417) Galesburg' 'MI39499'='(MI39499) Kalamazoo'
                  'MI39500'='(MI39500) Kalamazoo Township' 'MI39647'='(MI39647) Parchment'
                  'MI39678'='(MI39678) Portage' 'MI39698'='(MI39698) Richland'
                  'MI39736'='(MI39736) Schoolcraft' 'MI39799'='(MI39799) Vicksburg'
                  'MI39878'='(MI39878) Ross Township'
                  'MI39881'='(MI39881) Western Michigan Univers'
                  'MI39924'='(MI39924) Kalamazoo Airport'
                  'MI39963'='(MI39963) Charleston Township'
                  'MI40040'='(MI40040) Sp: Kalkaska County' 'MI40140'='(MI40140) Kalkaska'
                  'MI40502'='(MI40502) Kalkaska' 'MI41041'='(MI41041) Sp: Kent County'
                  'MI41141'='(MI41141) Kent' 'MI41300'='(MI41300) Cedar Springs'
                  'MI41361'='(MI41361) East Grand Rapids'
                  'MI41429'='(MI41429) Grand Rapids Community C'
                  'MI41436'='(MI41436) grand Rapids' 'MI41437'='(MI41437) Grandville'
                  'MI41539'='(MI41539) Lowell' 'MI41704'='(MI41704) Rockford'
                  'MI41729'='(MI41729) Sand Lake' 'MI41754'='(MI41754) Sparta' 'MI41802'='(MI41802) Walker'
                  'MI41834'='(MI41834) Wyoming' 'MI41850'='(MI41850) Kentwood'
                  'MI42042'='(MI42042) Sp: Keweenaw County' 'MI42142'='(MI42142) Keweenaw'
                  'MI42203'='(MI42203) Ahmeek' 'MI43043'='(MI43043) Sp: Lake County'
                  'MI43143'='(MI43143) Lake' 'MI43489'='(MI43489) Yates Township'
                  'MI43543'='(MI43543) Luther' 'MI44044'='(MI44044) Sp: Lapeer County'
                  'MI44144'='(MI44144) Lapeer' 'MI44214'='(MI44214) Almont' 'MI44318'='(MI44318) Clifford'
                  'MI44326'='(MI44326) Columbiaville' 'MI44356'='(MI44356) Dryden Township'
                  'MI44488'='(MI44488) Imlay City' 'MI44520'='(MI44520) Lapeer'
                  'MI44578'='(MI44578) Metamora Township' 'MI44621'='(MI44621) North Branch'
                  'MI44642'='(MI44642) Otter Lake' 'MI44876'='(MI44876) Lapeer Township'
                  'MI44945'='(MI44945) Dryden' 'MI45045'='(MI45045) Sp: Leelanau County'
                  'MI45145'='(MI45145) Leelanau' 'MI45380'='(MI45380) Empire'
                  'MI45746'='(MI45746) Suttons Bay' 'MI45855'='(MI45855) Northport'
                  'MI46046'='(MI46046) Sp: Lenawee County' 'MI46146'='(MI46146) Lenawee'
                  'MI46202'='(MI46202) Adrian' 'MI46203'='(MI46203) Adrian Township'
                  'MI46260'='(MI46260) Blissfield' 'MI46271'='(MI46271) Britton'
                  'MI46302'='(MI46302) Woodstock Township' 'MI46317'='(MI46317) Clayton'
                  'MI46320'='(MI46320) Clinton' 'MI46485'='(MI46485) Hudson' 'MI46594'='(MI46594) Morenci'
                  'MI46689'='(MI46689) Raisin Township' 'MI46707'='(MI46707) Rollin Township'
                  'MI46776'='(MI46776) Tecumseh' 'MI46931'='(MI46931) Cambridge Township'
                  'MI46935'='(MI46935) Madison Township'
                  'MI47047'='(MI47047) Sp: Livingston County' 'MI47147'='(MI47147) Livingston'
                  'MI47269'='(MI47269) Brighton' 'MI47405'='(MI47405) Fowlerville'
                  'MI47451'='(MI47451) Hamburg Township' 'MI47482'='(MI47482) Howell'
                  'MI47667'='(MI47667) Pinckney' 'MI47669'='(MI47669) Green Oak'
                  'MI47865'='(MI47865) Green Oak Township'
                  'MI47941'='(MI47941) Unadilla Township' 'MI48048'='(MI48048) Sp: Luce County'
                  'MI48148'='(MI48148) Luce' 'MI48617'='(MI48617) Newberry'
                  'MI49049'='(MI49049) Sp: Mackinac County' 'MI49149'='(MI49149) Mackinac'
                  'MI49545'='(MI49545) Mackinac Island' 'MI49724'='(MI49724) St. Ignace'
                  'MI50050'='(MI50050) Sp: Macomb County' 'MI50150'='(MI50150) Macomb'
                  'MI50220'='(MI50220) Armada' 'MI50303'='(MI50303) Center Line'
                  'MI50360'='(MI50360) Eastpointe' 'MI50409'='(MI50409) Fraser'
                  'MI50577'='(MI50577) Metro Beach Metropark' 'MI50597'='(MI50597) Mount Clemens'
                  'MI50610'='(MI50610) New Baltimore' 'MI50613'='(MI50613) New Haven'
                  'MI50699'='(MI50699) Richmond' 'MI50708'='(MI50708) Romeo'
                  'MI50713'='(MI50713) Roseville' 'MI50722'='(MI50722) St. Clair Shores'
                  'MI50740'='(MI50740) Shelby Township' 'MI50765'='(MI50765) Sterling Heights'
                  'MI50792'='(MI50792) Utica' 'MI50806'='(MI50806) Warren'
                  'MI50849'='(MI50849) Clinton Township'
                  'MI50902'='(MI50902) Chesterfield Township'
                  'MI50912'='(MI50912) Macomb Community College'
                  'MI50918'='(MI50918) Hcma: Stony Creek Mtrprk'
                  'MI51051'='(MI51051) Sp: Manistee County' 'MI51151'='(MI51151) Manistee'
                  'MI51333'='(MI51333) Copemish Cleon' 'MI51550'='(MI51550) Manistee'
                  'MI52052'='(MI52052) Sp: Marquette County' 'MI52152'='(MI52152) Marquette'
                  'MI52312'='(MI52312) Chocolay Township' 'MI52495'='(MI52495) Ishpeming'
                  'MI52559'='(MI52559) Marquette' 'MI52609'='(MI52609) Negaunee'
                  'MI52623'='(MI52623) Northern Michigan Univer'
                  'MI52697'='(MI52697) Republic Township' 'MI52841'='(MI52841) Forsyth Township'
                  'MI52861'='(MI52861) Marquette Township'
                  'MI52889'='(MI52889) Richmond Township'
                  'MI52905'='(MI52905) Ishpeming Township' 'MI52907'='(MI52907) Tilden Township'
                  'MI52914'='(MI52914) Negaunee Township'
                  'MI52921'='(MI52921) Marquette County Airport'
                  'MI53053'='(MI53053) Sp: Mason County' 'MI53153'='(MI53153) Mason'
                  'MI53540'='(MI53540) Ludington' 'MI53737'='(MI53737) Scottville'
                  'MI54054'='(MI54054) Sp: Mecosta County' 'MI54154'='(MI54154) Mecosta'
                  'MI54256'='(MI54256) Big Rapids' 'MI54864'='(MI54864) Ferris State University'
                  'MI55055'='(MI55055) Sp: Menominee County' 'MI55155'='(MI55155) Menominee'
                  'MI55575'='(MI55575) Menominee' 'MI56056'='(MI56056) Sp: Midland County'
                  'MI56156'='(MI56156) Midland' 'MI56323'='(MI56323) Coleman' 'MI56583'='(MI56583) Midland'
                  'MI56731'='(MI56731) Sanford' 'MI56909'='(MI56909) Midland Township'
                  'MI57057'='(MI57057) Sp: Missaukee County' 'MI57157'='(MI57157) Missaukee'
                  'MI57513'='(MI57513) Lake City' 'MI57568'='(MI57568) Richland Township'
                  'MI58058'='(MI58058) Sp: Monroe County' 'MI58158'='(MI58158) Monroe'
                  'MI58287'='(MI58287) Carleton' 'MI58357'='(MI58357) Dundee'
                  'MI58381'='(MI58381) Erie Township' 'MI58384'='(MI58384) Estral Beach'
                  'MI58541'='(MI58541) Luna Pier' 'MI58590'='(MI58590) Monroe'
                  'MI58661'='(MI58661) Petersburg' 'MI58750'='(MI58750) South Rockwood'
                  'MI59059'='(MI59059) Sp: Montcalm County' 'MI59159'='(MI59159) Montcalm'
                  'MI59291'='(MI59291) Carson City' 'MI59337'='(MI59337) Crystal Township'
                  'MI59371'='(MI59371) Home Township' 'MI59373'='(MI59373) Edmore'
                  'MI59442'='(MI59442) Greenville' 'MI59481'='(MI59481) Howard City'
                  'MI59517'='(MI59517) Lakeview' 'MI59664'='(MI59664) Pierson Township'
                  'MI59665'='(MI59665) Pierson' 'MI59742'='(MI59742) Sheridan'
                  'MI59761'='(MI59761) Stanton' 'MI60060'='(MI60060) Sp: Montmorency County'
                  'MI60160'='(MI60160) Montmorency' 'MI60206'='(MI60206) Albert Township'
                  'MI60472'='(MI60472) Hillman' 'MI61061'='(MI61061) Sp: Muskegon County'
                  'MI61161'='(MI61161) Muskegon' 'MI61294'='(MI61294) Casnovia'
                  'MI61340'='(MI61340) Dalton Township' 'MI61373'='(MI61373) Egelston Township'
                  'MI61412'='(MI61412) Fruitport' 'MI61591'='(MI61591) Montague'
                  'MI61603'='(MI61603) Muskegon' 'MI61604'='(MI61604) Muskegon Heights'
                  'MI61605'='(MI61605) Muskegon Township' 'MI61622'='(MI61622) North Muskegon'
                  'MI61625'='(MI61625) Norton Shores' 'MI61710'='(MI61710) Roosevelt Park'
                  'MI61824'='(MI61824) Whitehall' 'MI61854'='(MI61854) Lakewood Club'
                  'MI61923'='(MI61923) Muskegon County Airport'
                  'MI62062'='(MI62062) Sp: Newaygo County' 'MI62162'='(MI62162) Newaygo'
                  'MI62438'='(MI62438) Grant' 'MI62616'='(MI62616) Newaygo'
                  'MI62820'='(MI62820) White Cloud' 'MI62842'='(MI62842) Fremont'
                  'MI63063'='(MI63063) Sp: Oakland County' 'MI63163'='(MI63163) Oakland'
                  'MI63251'='(MI63251) Berkley' 'MI63255'='(MI63255) Beverly Hills'
                  'MI63259'='(MI63259) Birmingham' 'MI63261'='(MI63261) Bloomfield Hills'
                  'MI63262'='(MI63262) Bloomfield Township' 'MI63285'='(MI63285) Camp Dearborn'
                  'MI63314'='(MI63314) Independence Township' 'MI63315'='(MI63315) Clarkston'
                  'MI63316'='(MI63316) Clawson' 'MI63388'='(MI63388) Farmington'
                  'MI63389'='(MI63389) Farmington Hills' 'MI63394'='(MI63394) Ferndale'
                  'MI63408'='(MI63408) Franklin' 'MI63465'='(MI63465) Hazel Park'
                  'MI63475'='(MI63475) Holly' 'MI63487'='(MI63487) Huntington Woods'
                  'MI63503'='(MI63503) Keego Harbor'
                  'MI63504'='(MI63504) Hcma: Kensington Mtrprk'
                  'MI63511'='(MI63511) Lake Angelus' 'MI63516'='(MI63516) Lake Orion'
                  'MI63521'='(MI63521) Lathrup Village'
                  'MI63525'='(MI63525) Leonard-Addison Township'
                  'MI63547'='(MI63547) Madison Heights' 'MI63585'='(MI63585) Milford'
                  'MI63627'='(MI63627) Novi' 'MI63628'='(MI63628) Oak Park'
                  'MI63636'='(MI63636) Orchard Lake' 'MI63638'='(MI63638) Brandon Township'
                  'MI63646'='(MI63646) Oxford' 'MI63671'='(MI63671) Pleasant Ridge'
                  'MI63673'='(MI63673) Pontiac' 'MI63702'='(MI63702) Rochester'
                  'MI63714'='(MI63714) Royal Oak' 'MI63715'='(MI63715) Royal Oak Township'
                  'MI63748'='(MI63748) South Lyon' 'MI63751'='(MI63751) Southfield'
                  'MI63773'='(MI63773) Sylvan Lake' 'MI63784'='(MI63784) Troy'
                  'MI63804'='(MI63804) Walled Lake' 'MI63808'='(MI63808) Waterford Township'
                  'MI63815'='(MI63815) West Bloomfield Township'
                  'MI63821'='(MI63821) White Lake Township' 'MI63827'='(MI63827) Wixom'
                  'MI63829'='(MI63829) Wolverine Lake' 'MI63851'='(MI63851) Auburn Hills'
                  'MI63888'='(MI63888) Oakland University'
                  'MI63920'='(MI63920) Oakland Co. Safety Pol.'
                  'MI63927'='(MI63927) Oakland Community Coll'
                  'MI64064'='(MI64064) Sp: Oceana County' 'MI64164'='(MI64164) Oceana'
                  'MI64250'='(MI64250) Benona Township' 'MI64462'='(MI64462) Hart'
                  'MI64469'='(MI64469) Hesperia' 'MI64612'='(MI64612) New Era'
                  'MI64656'='(MI64656) Pentwater' 'MI64739'='(MI64739) Shelby'
                  'MI64896'='(MI64896) Rothbury' 'MI65065'='(MI65065) Sp: Ogemaw County'
                  'MI65165'='(MI65165) Ogemaw' 'MI65472'='(MI65472) Hill Township'
                  'MI65586'='(MI65586) Mills Township' 'MI65712'='(MI65712) Rose City'
                  'MI65816'='(MI65816) West Branch' 'MI66066'='(MI66066) Sp: Ontonagon County'
                  'MI66166'='(MI66166) Ontonagon' 'MI66635'='(MI66635) Ontonagon'
                  'MI67067'='(MI67067) Sp: Osceola County' 'MI67167'='(MI67167) Osceola'
                  'MI67385'='(MI67385) Evart' 'MI67527'='(MI67527) Le Roy' 'MI67557'='(MI67557) Marion'
                  'MI67694'='(MI67694) Reed City' 'MI68068'='(MI68068) Sp: Oscoda County'
                  'MI68168'='(MI68168) Oscoda' 'MI69069'='(MI69069) Sp: Otsego County'
                  'MI69169'='(MI69169) Otsego' 'MI69421'='(MI69421) Gaylord'
                  'MI69794'='(MI69794) Vanderbilt' 'MI70070'='(MI70070) Sp: Ottawa County'
                  'MI70170'='(MI70170) Ottawa' 'MI70330'='(MI70330) Coopersville'
                  'MI70395'='(MI70395) Ferrysburg' 'MI70432'='(MI70432) Grand Haven'
                  'MI70474'='(MI70474) Holland' 'MI70486'='(MI70486) Hudsonville'
                  'MI70756'='(MI70756) Spring Lake-Ferrysburg' 'MI70837'='(MI70837) Zeeland'
                  'MI70883'='(MI70883) Grand Valley State Univ'
                  'MI70949'='(MI70949) Hope College'
                  'MI71071'='(MI71071) Sp: Presque Isle County'
                  'MI71171'='(MI71171) Presque Isle' 'MI71586'='(MI71586) Millersburg'
                  'MI71632'='(MI71632) Onaway' 'MI71680'='(MI71680) Posen'
                  'MI71706'='(MI71706) Rogers City' 'MI72072'='(MI72072) Sp: Roscommon County'
                  'MI72172'='(MI72172) Roscommon' 'MI72355'='(MI72355) Denton Township'
                  'MI72542'='(MI72542) Lyon Township' 'MI72711'='(MI72711) Roscommon'
                  'MI72901'='(MI72901) Richfield Township'
                  'MI72925'='(MI72925) Roscommon Township' 'MI72946'='(MI72946) Gerrish Township'
                  'MI73073'='(MI73073) Sp: Saginaw County' 'MI73173'='(MI73173) Saginaw'
                  'MI73258'='(MI73258) Birch Run' 'MI73288'='(MI73288) Carrollton Township'
                  'MI73311'='(MI73311) Chesaning' 'MI73406'='(MI73406) Frankenmuth'
                  'MI73466'='(MI73466) Richland Township' 'MI73552'='(MI73552) Albee-Maple Grove'
                  'MI73576'='(MI73576) Merrill' 'MI73629'='(MI73629) Oakley' 'MI73717'='(MI73717) Saginaw'
                  'MI73718'='(MI73718) Saginaw Township'
                  'MI73719'='(MI73719) Saginaw Valley State Un' 'MI73720'='(MI73720) St. Charles'
                  'MI73778'='(MI73778) Tittabawassee Township' 'MI73838'='(MI73838) Zilwaukee'
                  'MI73840'='(MI73840) Tri-City Airport'
                  'MI73856'='(MI73856) Buena Vista Township'
                  'MI73863'='(MI73863) Bridgeport Township'
                  'MI73872'='(MI73872) Chesaning Township'
                  'MI73879'='(MI73879) Taymouth Township'
                  'MI73887'='(MI73887) Spaulding Township' 'MI73894'='(MI73894) Thomas Township'
                  'MI73913'='(MI73913) Oakley-Brady' 'MI73929'='(MI73929) Albee Township'
                  'MI74074'='(MI74074) Sp: St. Clair County' 'MI74174'='(MI74174) St. Clair'
                  'MI74209'='(MI74209) Algonac' 'MI74286'='(MI74286) Capac'
                  'MI74556'='(MI74556) Marine City' 'MI74562'='(MI74562) Marysville'
                  'MI74573'='(MI74573) Memphis' 'MI74676'='(MI74676) Port Huron'
                  'MI74721'='(MI74721) St. Clair' 'MI74835'='(MI74835) Yale'
                  'MI74867'='(MI74867) Clay Township' 'MI74874'='(MI74874) China Township'
                  'MI74875'='(MI74875) Ira Township' 'MI75075'='(MI75075) Sp: St. Joseph County'
                  'MI75175'='(MI75175) St. Joseph' 'MI75279'='(MI75279) Burr Oak'
                  'MI75305'='(MI75305) Centreville' 'MI75325'='(MI75325) Colon'
                  'MI75329'='(MI75329) Constantine' 'MI75768'='(MI75768) Sturgis'
                  'MI75780'='(MI75780) Three Rivers' 'MI75822'='(MI75822) White Pigeon'
                  'MI75919'='(MI75919) Mendon' 'MI76076'='(MI76076) Sp: Sanilac County'
                  'MI76176'='(MI76176) Sanilac' 'MI76274'='(MI76274) Brown City'
                  'MI76292'='(MI76292) Carsonville' 'MI76336'='(MI76336) Croswell'
                  'MI76346'='(MI76346) Deckerville' 'MI76530'='(MI76530) Lexington'
                  'MI76558'='(MI76558) Marlette' 'MI76571'='(MI76571) Melvin'
                  'MI76588'='(MI76588) Minden City' 'MI76653'='(MI76653) Peck'
                  'MI76677'='(MI76677) Port Sanilac' 'MI76730'='(MI76730) Sandusky'
                  'MI77077'='(MI77077) Sp: Schoolcraft County' 'MI77177'='(MI77177) Schoolcraft'
                  'MI77551'='(MI77551) Manistique' 'MI78078'='(MI78078) Sp: Shiawassee County'
                  'MI78178'='(MI78178) Shiawassee' 'MI78230'='(MI78230) Bancroft'
                  'MI78280'='(MI78280) Byron' 'MI78283'='(MI78283) Caledonia Township'
                  'MI78335'='(MI78335) Corunna' 'MI78358'='(MI78358) Durand'
                  'MI78510'='(MI78510) Laingsburg' 'MI78526'='(MI78526) Lennon'
                  'MI78596'='(MI78596) Morrice' 'MI78614'='(MI78614) New Lothrop'
                  'MI78645'='(MI78645) Owosso' 'MI78660'='(MI78660) Perry' 'MI78797'='(MI78797) Vernon'
                  'MI79079'='(MI79079) Sp: Tuscola County' 'MI79179'='(MI79179) Tuscola'
                  'MI79204'='(MI79204) Akron' 'MI79222'='(MI79222) Arbela Township'
                  'MI79290'='(MI79290) Caro' 'MI79296'='(MI79296) Cass City'
                  'MI79386'='(MI79386) Fairgrove' 'MI79415'='(MI79415) Gagetown'
                  'MI79509'='(MI79509) Kingston' 'MI79566'='(MI79566) Mayville'
                  'MI79587'='(MI79587) Millington' 'MI79695'='(MI79695) Reese'
                  'MI79791'='(MI79791) Unionville' 'MI79795'='(MI79795) Vassar'
                  'MI79807'='(MI79807) Watertown Township' 'MI79928'='(MI79928) Denmark Township'
                  'MI80080'='(MI80080) Sp: Van Buren County' 'MI80180'='(MI80180) Van Buren'
                  'MI80231'='(MI80231) Bangor' 'MI80263'='(MI80263) Bloomingdale'
                  'MI80267'='(MI80267) Breedsville' 'MI80345'='(MI80345) Decatur'
                  'MI80428'='(MI80428) Gobles' 'MI80463'='(MI80463) Hartford'
                  'MI80523'='(MI80523) Lawrence' 'MI80524'='(MI80524) Lawton'
                  'MI80564'='(MI80564) Mattawan' 'MI80651'='(MI80651) Paw Paw'
                  'MI80747'='(MI80747) South Haven' 'MI80873'='(MI80873) Covert Township'
                  'MI80937'='(MI80937) Keeler Township'
                  'MI81081'='(MI81081) Sp: Washtenaw County' 'MI81181'='(MI81181) Washtenaw'
                  'MI81218'='(MI81218) Ann Arbor' 'MI81310'='(MI81310) Chelsea'
                  'MI81351'='(MI81351) Dexter' 'MI81366'='(MI81366) Eastern Michigan Univers'
                  'MI81549'='(MI81549) Manchester' 'MI81565'='(MI81565) Manchester Township'
                  'MI81584'='(MI81584) Milan' 'MI81728'='(MI81728) Saline' 'MI81836'='(MI81836) Ypsilanti'
                  'MI81866'='(MI81866) Hcma: Hudson Mlls Mtrprk'
                  'MI81903'='(MI81903) Univ Of Mi: Ann Arbor'
                  'MI81906'='(MI81906) Pittsfield Township'
                  'MI81964'='(MI81964) Northfield Township'
                  'MI82082'='(MI82082) Sp: Wayne County' 'MI82182'='(MI82182) Wayne'
                  'MI82212'='(MI82212) Allen Park' 'MI82246'='(MI82246) Belleville'
                  'MI82343'='(MI82343) Dearborn' 'MI82344'='(MI82344) Dearborn Heights'
                  'MI82349'='(MI82349) Detroit' 'MI82370'='(MI82370) Ecorse'
                  'MI82397'='(MI82397) Flat Rock' 'MI82420'='(MI82420) Garden City'
                  'MI82423'='(MI82423) Gibraltar' 'MI82445'='(MI82445) Grosse Ile Township'
                  'MI82446'='(MI82446) Grosse Pointe' 'MI82447'='(MI82447) Grosse Pointe Farms'
                  'MI82448'='(MI82448) Grosse Pointe Park'
                  'MI82449'='(MI82449) Grosse Pointe Shores'
                  'MI82450'='(MI82450) Grosse Pointe Woods' 'MI82453'='(MI82453) Hamtramck'
                  'MI82458'='(MI82458) Harper Woods' 'MI82471'='(MI82471) Highland Park'
                  'MI82490'='(MI82490) Inkster' 'MI82534'='(MI82534) Lincoln Park'
                  'MI82538'='(MI82538) Livonia' 'MI82572'='(MI82572) Melvindale'
                  'MI82624'='(MI82624) Northville' 'MI82672'='(MI82672) Plymouth'
                  'MI82693'='(MI82693) Redford Township' 'MI82700'='(MI82700) River Rouge'
                  'MI82701'='(MI82701) Riverview' 'MI82705'='(MI82705) Rockwood'
                  'MI82709'='(MI82709) Romulus' 'MI82752'='(MI82752) Southgate'
                  'MI82770'='(MI82770) Sumpter Township' 'MI82775'='(MI82775) Taylor'
                  'MI82783'='(MI82783) Trenton' 'MI82793'='(MI82793) Van Buren Township'
                  'MI82812'='(MI82812) Wayne' 'MI82817'='(MI82817) Westland'
                  'MI82831'='(MI82831) Woodhaven' 'MI82833'='(MI82833) Wyandotte'
                  'MI82844'='(MI82844) Hcma: Huron Metropark'
                  'MI82862'='(MI82862) Huron Township' 'MI82868'='(MI82868) Northville Township'
                  'MI82907'='(MI82907) Univ Of Mi: Dearborn'
                  'MI82908'='(MI82908) Canton Township'
                  'MI82939'='(MI82939) Wayne County Airport'
                  'MI82947'='(MI82947) Brownstown Township'
                  'MI82965'='(MI82965) Plymouth Township'
                  'MI83083'='(MI83083) Sp: Wexford County' 'MI83183'='(MI83183) Wexford'
                  'MI83277'='(MI83277) Buckley' 'MI83281'='(MI83281) Cadillac' 'MI83569'='(MI83569) Manton'
                  'MI83574'='(MI83574) Mesick' 'MN00100'='(MN00100) Aitkin' 'MN00200'='(MN00200) Anoka'
                  'MN00201'='(MN00201) Anoka' 'MN00202'='(MN00202) Blaine'
                  'MN00203'='(MN00203) Centennial Lakes' 'MN00204'='(MN00204) Columbia Heights'
                  'MN00205'='(MN00205) Coon Rapids' 'MN00206'='(MN00206) Fridley'
                  'MN00207'='(MN00207) Lino Lakes' 'MN00208'='(MN00208) Spring Lake Park'
                  'MN00209'='(MN00209) East Bethel' 'MN00210'='(MN00210) Ham Lake'
                  'MN00211'='(MN00211) Lexington' 'MN00212'='(MN00212) Andover'
                  'MN00213'='(MN00213) Ramsey' 'MN00214'='(MN00214) Hilltop'
                  'MN00215'='(MN00215) St. Francis' 'MN00300'='(MN00300) Becker'
                  'MN00301'='(MN00301) Detroit Lakes' 'MN00400'='(MN00400) Beltrami'
                  'MN00401'='(MN00401) Bemidji' 'MN00402'='(MN00402) Blackduck'
                  'MN00500'='(MN00500) Benton' 'MN00502'='(MN00502) Sauk Rapids'
                  'MN00600'='(MN00600) Big Stone' 'MN00601'='(MN00601) Ortonville'
                  'MN00700'='(MN00700) Blue Earth' 'MN00701'='(MN00701) Mankato'
                  'MN00704'='(MN00704) Eagle Lake' 'MN00705'='(MN00705) Lake Crystal'
                  'MN00800'='(MN00800) Brown' 'MN00801'='(MN00801) New Ulm'
                  'MN00802'='(MN00802) Sleepy Eye' 'MN00803'='(MN00803) Springfield'
                  'MN00900'='(MN00900) Carlton' 'MN00901'='(MN00901) Cloquet'
                  'MN00902'='(MN00902) Moose Lake' 'MN00904'='(MN00904) Scanlon'
                  'MN00907'='(MN00907) Thomson Township' 'MN01000'='(MN01000) Carver'
                  'MN01001'='(MN01001) Chanhassen' 'MN01002'='(MN01002) Chaska'
                  'MN01003'='(MN01003) Waconia' 'MN01100'='(MN01100) Cass' 'MN01200'='(MN01200) Chippewa'
                  'MN01201'='(MN01201) Clara City' 'MN01202'='(MN01202) Montevideo'
                  'MN01300'='(MN01300) Chisago' 'MN01303'='(MN01303) Chisago City'
                  'MN01304'='(MN01304) Lindstrom' 'MN01305'='(MN01305) North Branch'
                  'MN01307'='(MN01307) Taylors Falls' 'MN01308'='(MN01308) Wyoming'
                  'MN01309'='(MN01309) Lakes Area' 'MN01400'='(MN01400) Clay'
                  'MN01402'='(MN01402) Dilworth' 'MN01404'='(MN01404) Moorhead'
                  'MN01500'='(MN01500) Clearwater' 'MN01600'='(MN01600) Cook'
                  'MN01601'='(MN01601) Grand Marais' 'MN01700'='(MN01700) Cottonwood'
                  'MN01701'='(MN01701) Mountain Lake' 'MN01702'='(MN01702) Windom'
                  'MN01800'='(MN01800) Crow Wing' 'MN01801'='(MN01801) Brainerd'
                  'MN01802'='(MN01802) Crosby' 'MN01805'='(MN01805) Baxter' 'MN01900'='(MN01900) Dakota'
                  'MN01901'='(MN01901) Burnsville' 'MN01902'='(MN01902) Farmington'
                  'MN01903'='(MN01903) Hastings' 'MN01904'='(MN01904) Mendota Heights'
                  'MN01905'='(MN01905) Rosemount' 'MN01906'='(MN01906) South St. Paul'
                  'MN01907'='(MN01907) West St. Paul' 'MN01908'='(MN01908) Eagan'
                  'MN01909'='(MN01909) Inver Grove Heights' 'MN01910'='(MN01910) Apple Valley'
                  'MN01911'='(MN01911) Lakeville' 'MN02000'='(MN02000) Dodge' 'MN02002'='(MN02002) Kasson'
                  'MN02100'='(MN02100) Douglas' 'MN02101'='(MN02101) Alexandria'
                  'MN02102'='(MN02102) Osakis' 'MN02200'='(MN02200) Faribault'
                  'MN02201'='(MN02201) Blue Earth' 'MN02202'='(MN02202) Elmore' 'MN02204'='(MN02204) Wells'
                  'MN02205'='(MN02205) Winnebago' 'MN02206'='(MN02206) South Estrn Faribault Co'
                  'MN02209'='(MN02209) Frost' 'MN02300'='(MN02300) Fillmore'
                  'MN02306'='(MN02306) Spring Valley' 'MN02400'='(MN02400) Freeborn'
                  'MN02401'='(MN02401) Albert Lea' 'MN02500'='(MN02500) Goodhue'
                  'MN02501'='(MN02501) Cannon Falls' 'MN02503'='(MN02503) Red Wing'
                  'MN02504'='(MN02504) Kenyon' 'MN02508'='(MN02508) Zumbrota' 'MN02600'='(MN02600) Grant'
                  'MN02700'='(MN02700) Hennepin' 'MN02701'='(MN02701) Bloomington'
                  'MN02702'='(MN02702) Brooklyn Center' 'MN02703'='(MN02703) Brooklyn Park'
                  'MN02704'='(MN02704) Crystal' 'MN02705'='(MN02705) Deephaven-Woodland'
                  'MN02706'='(MN02706) Edina' 'MN02707'='(MN02707) South Lake Minnetonka'
                  'MN02708'='(MN02708) Golden Valley' 'MN02709'='(MN02709) Hopkins'
                  'MN02711'='(MN02711) Minneapolis' 'MN02712'='(MN02712) Minnetonka'
                  'MN02713'='(MN02713) Mound' 'MN02714'='(MN02714) New Hope' 'MN02715'='(MN02715) Orono'
                  'MN02716'='(MN02716) Osseo' 'MN02717'='(MN02717) Plymouth'
                  'MN02718'='(MN02718) Richfield' 'MN02719'='(MN02719) Robbinsdale'
                  'MN02720'='(MN02720) St. Anthony' 'MN02721'='(MN02721) St. Louis Park'
                  'MN02723'='(MN02723) Wayzata' 'MN02724'='(MN02724) Univ Of Mn: Twin Cities'
                  'MN02725'='(MN02725) Minneapolis-St. Paul I a'
                  'MN02726'='(MN02726) Eden Prairie' 'MN02727'='(MN02727) Maple Grove'
                  'MN02728'='(MN02728) Minnetrista' 'MN02729'='(MN02729) Champlin'
                  'MN02730'='(MN02730) Medina' 'MN02731'='(MN02731) Corcoran' 'MN02732'='(MN02732) Dayton'
                  'MN02734'='(MN02734) Rogers' 'MN02736'='(MN02736) Minnetonka Beach'
                  'MN02737'='(MN02737) West Hennepin' 'MN02738'='(MN02738) Long Lake'
                  'MN02739'='(MN02739) Maple Plain' 'MN02740'='(MN02740) Three Rivers Park Dist'
                  'MN02741'='(MN02741) Spring Park' 'MN02800'='(MN02800) Houston'
                  'MN02801'='(MN02801) Caledonia' 'MN02802'='(MN02802) Houston'
                  'MN02803'='(MN02803) La Crescent' 'MN02804'='(MN02804) Spring Grove'
                  'MN02805'='(MN02805) Hokah' 'MN02900'='(MN02900) Hubbard'
                  'MN02901'='(MN02901) Park Rapids' 'MN03000'='(MN03000) Isanti'
                  'MN03001'='(MN03001) Cambridge' 'MN03100'='(MN03100) Itasca'
                  'MN03103'='(MN03103) Grand Rapids' 'MN03105'='(MN03105) Nashwauk'
                  'MN03200'='(MN03200) Jackson' 'MN03201'='(MN03201) Jackson'
                  'MN03202'='(MN03202) Lakefield' 'MN03300'='(MN03300) Kanabec' 'MN03301'='(MN03301) Mora'
                  'MN03400'='(MN03400) Kandiyohi' 'MN03401'='(MN03401) Willmar'
                  'MN03500'='(MN03500) Kittson' 'MN03501'='(MN03501) Hallock'
                  'MN03600'='(MN03600) Koochiching' 'MN03601'='(MN03601) International Falls'
                  'MN03604'='(MN03604) So International Falls'
                  'MN03700'='(MN03700) Lac Qui Parle' 'MN03701'='(MN03701) Dawson'
                  'MN03702'='(MN03702) Madison' 'MN03800'='(MN03800) Lake' 'MN03801'='(MN03801) Silver Bay'
                  'MN03802'='(MN03802) Two Harbors' 'MN03900'='(MN03900) Lake Of The Woods'
                  'MN04000'='(MN04000) Le Sueur' 'MN04002'='(MN04002) Le Sueur'
                  'MN04003'='(MN04003) Montgomery' 'MN04100'='(MN04100) Lincoln' 'MN04200'='(MN04200) Lyon'
                  'MN04201'='(MN04201) Marshall' 'MN04202'='(MN04202) Tracy' 'MN04300'='(MN04300) Mcleod'
                  'MN04301'='(MN04301) Glencoe' 'MN04302'='(MN04302) Hutchinson'
                  'MN04303'='(MN04303) Brownton' 'MN04304'='(MN04304) Lester Prairie'
                  'MN04305'='(MN04305) Silver Lake' 'MN04306'='(MN04306) Stewart'
                  'MN04307'='(MN04307) Winsted' 'MN04400'='(MN04400) Mahnomen'
                  'MN04500'='(MN04500) Marshall' 'MN04600'='(MN04600) Martin'
                  'MN04601'='(MN04601) Fairmont' 'MN04700'='(MN04700) Meeker'
                  'MN04701'='(MN04701) Litchfield' 'MN04800'='(MN04800) Mille Lacs'
                  'MN04801'='(MN04801) Milaca' 'MN04802'='(MN04802) Princeton'
                  'MN04900'='(MN04900) Morrison' 'MN04901'='(MN04901) Little Falls'
                  'MN05000'='(MN05000) Mower' 'MN05001'='(MN05001) Austin' 'MN05100'='(MN05100) Murray'
                  'MN05102'='(MN05102) Slayton' 'MN05200'='(MN05200) Nicollet'
                  'MN05201'='(MN05201) North Mankato' 'MN05202'='(MN05202) St. Peter'
                  'MN05300'='(MN05300) Nobles' 'MN05301'='(MN05301) Worthington'
                  'MN05400'='(MN05400) Norman' 'MN05500'='(MN05500) Olmsted'
                  'MN05501'='(MN05501) Rochester' 'MN05502'='(MN05502) Stewartville'
                  'MN05600'='(MN05600) Otter Tail' 'MN05601'='(MN05601) Fergus Falls'
                  'MN05700'='(MN05700) Pennington' 'MN05701'='(MN05701) Thief River Falls'
                  'MN05800'='(MN05800) Pine' 'MN05900'='(MN05900) Pipestone'
                  'MN05901'='(MN05901) Pipestone' 'MN06000'='(MN06000) Polk'
                  'MN06001'='(MN06001) Crookston' 'MN06002'='(MN06002) East Grand Forks'
                  'MN06100'='(MN06100) Pope' 'MN06101'='(MN06101) Glenwood' 'MN06200'='(MN06200) Ramsey'
                  'MN06201'='(MN06201) Arden Hills' 'MN06202'='(MN06202) Falcon Heights'
                  'MN06203'='(MN06203) Lauderdale' 'MN06204'='(MN06204) Maplewood'
                  'MN06205'='(MN06205) Mounds View' 'MN06206'='(MN06206) New Brighton'
                  'MN06207'='(MN06207) North St. Paul' 'MN06208'='(MN06208) Roseville'
                  'MN06209'='(MN06209) St. Paul' 'MN06210'='(MN06210) White Bear Lake'
                  'MN06211'='(MN06211) Little Canada' 'MN06212'='(MN06212) Shoreview'
                  'MN06213'='(MN06213) Vadnais Heights' 'MN06215'='(MN06215) North Oaks'
                  'MN06300'='(MN06300) Red Lake' 'MN06400'='(MN06400) Redwood'
                  'MN06402'='(MN06402) Redwood Falls' 'MN06500'='(MN06500) Renville'
                  'MN06503'='(MN06503) Olivia' 'MN06600'='(MN06600) Rice' 'MN06601'='(MN06601) Faribault'
                  'MN06602'='(MN06602) Northfield' 'MN06700'='(MN06700) Rock' 'MN06701'='(MN06701) Luverne'
                  'MN06800'='(MN06800) Roseau' 'MN06801'='(MN06801) Roseau' 'MN06802'='(MN06802) Warroad'
                  'MN06900'='(MN06900) St. Louis' 'MN06901'='(MN06901) Aurora'
                  'MN06902'='(MN06902) Babbitt' 'MN06903'='(MN06903) Biwabik'
                  'MN06905'='(MN06905) Chisholm' 'MN06906'='(MN06906) Duluth' 'MN06907'='(MN06907) Ely'
                  'MN06908'='(MN06908) Eveleth' 'MN06909'='(MN06909) Gilbert' 'MN06910'='(MN06910) Hibbing'
                  'MN06911'='(MN06911) Hoyt Lakes' 'MN06912'='(MN06912) Mountain Iron'
                  'MN06913'='(MN06913) Proctor' 'MN06914'='(MN06914) Virginia'
                  'MN06915'='(MN06915) Floodwood' 'MN06917'='(MN06917) Hermantown'
                  'MN06918'='(MN06918) Univ Of Mn: Duluth' 'MN07000'='(MN07000) Scott'
                  'MN07001'='(MN07001) Belle Plaine' 'MN07002'='(MN07002) Jordan'
                  'MN07003'='(MN07003) New Prague' 'MN07004'='(MN07004) Shakopee'
                  'MN07006'='(MN07006) Savage' 'MN07009'='(MN07009) Prior Lake'
                  'MN07100'='(MN07100) Sherburne' 'MN07101'='(MN07101) Big Lake'
                  'MN07102'='(MN07102) Elk River' 'MN07104'='(MN07104) Becker' 'MN07200'='(MN07200) Sibley'
                  'MN07300'='(MN07300) Stearns' 'MN07301'='(MN07301) Cold Spring'
                  'MN07302'='(MN07302) Melrose' 'MN07303'='(MN07303) Paynesville'
                  'MN07304'='(MN07304) St. Cloud' 'MN07305'='(MN07305) Sauk Centre'
                  'MN07306'='(MN07306) Waite Park' 'MN07307'='(MN07307) Richmond'
                  'MN07308'='(MN07308) Belgrade' 'MN07310'='(MN07310) Kimball'
                  'MN07311'='(MN07311) St. Joseph' 'MN07312'='(MN07312) Sartell'
                  'MN07314'='(MN07314) Albany' 'MN07316'='(MN07316) Avon' 'MN07400'='(MN07400) Steele'
                  'MN07401'='(MN07401) Owatonna' 'MN07402'='(MN07402) Blooming Prairie'
                  'MN07500'='(MN07500) Stevens' 'MN07501'='(MN07501) Morris'
                  'MN07506'='(MN07506) Univ Of Mn: Morris' 'MN07600'='(MN07600) Swift'
                  'MN07601'='(MN07601) Appleton' 'MN07602'='(MN07602) Benson' 'MN07700'='(MN07700) Todd'
                  'MN07701'='(MN07701) Long Prairie' 'MN07702'='(MN07702) Staples'
                  'MN07800'='(MN07800) Traverse' 'MN07801'='(MN07801) Browns Valley'
                  'MN07802'='(MN07802) Wheaton' 'MN07900'='(MN07900) Wabasha'
                  'MN07901'='(MN07901) Lake City' 'MN07902'='(MN07902) Plainview'
                  'MN07903'='(MN07903) Wabasha' 'MN07904'='(MN07904) Elgin' 'MN08000'='(MN08000) Wadena'
                  'MN08001'='(MN08001) Wadena' 'MN08100'='(MN08100) Waseca'
                  'MN08101'='(MN08101) Janesville' 'MN08102'='(MN08102) New Richland'
                  'MN08103'='(MN08103) Waseca' 'MN08200'='(MN08200) Washington'
                  'MN08201'='(MN08201) Bayport' 'MN08202'='(MN08202) Forest Lake'
                  'MN08203'='(MN08203) Mahtomedi' 'MN08204'='(MN08204) Newport'
                  'MN08205'='(MN08205) St. Paul Park' 'MN08206'='(MN08206) Stillwater'
                  'MN08207'='(MN08207) Cottage Grove' 'MN08208'='(MN08208) Oakdale'
                  'MN08209'='(MN08209) Woodbury Township' 'MN08210'='(MN08210) Lake Elmo'
                  'MN08211'='(MN08211) Woodbury' 'MN08212'='(MN08212) Hugo'
                  'MN08214'='(MN08214) Oak Park Heights' 'MN08219'='(MN08219) Afton'
                  'MN08300'='(MN08300) Watonwan' 'MN08302'='(MN08302) St. James'
                  'MN08400'='(MN08400) Wilkin' 'MN08401'='(MN08401) Breckenridge'
                  'MN08500'='(MN08500) Winona' 'MN08501'='(MN08501) St. Charles'
                  'MN08502'='(MN08502) Winona' 'MN08503'='(MN08503) Goodview'
                  'MN08504'='(MN08504) Lewiston' 'MN08600'='(MN08600) Wright' 'MN08601'='(MN08601) Buffalo'
                  'MN08603'='(MN08603) Delano' 'MN08605'='(MN08605) Monticello'
                  'MN08606'='(MN08606) Annandale' 'MN08612'='(MN08612) Rockford'
                  'MN08700'='(MN08700) Yellow Medicine' 'MN08701'='(MN08701) Canby'
                  'MN08702'='(MN08702) Granite Falls'
                  'MNMHP00'='(MNMHP00) Minnesota State Patrol'
                  'MNMHP01'='(MNMHP01) State Patrol: Oakdale'
                  'MNMHP02'='(MNMHP02) State Patrol: Rochester'
                  'MNMHP03'='(MNMHP03) State Patrol: Marshall'
                  'MNMHP04'='(MNMHP04) State Patrol:Golden Vlly'
                  'MNMHP06'='(MNMHP06) State Patrol: St. Cloud'
                  'MNMHP07'='(MNMHP07) State Patrol: Brainerd'
                  'MNMHP08'='(MNMHP08) State Patrol:Detroit Lks'
                  'MNMHP09'='(MNMHP09) St Ptrl:Thief River Fls'
                  'MNMHP10'='(MNMHP10) State Patrol: Virginia'
                  'MNMHP11'='(MNMHP11) State Patrol: Duluth'
                  'MNMHP12'='(MNMHP12) State Patrol: Mankato'
                  'MNMHP13'='(MNMHP13) Capitol Security,St Paul' 'MO00100'='(MO00100) Adair'
                  'MO00101'='(MO00101) Kirksville' 'MO00106'='(MO00106) Truman State University'
                  'MO00200'='(MO00200) Andrew' 'MO00201'='(MO00201) Savannah'
                  'MO00205'='(MO00205) Country Club Village' 'MO00300'='(MO00300) Atchison'
                  'MO00302'='(MO00302) Rock Port' 'MO00303'='(MO00303) Tarkio'
                  'MO00400'='(MO00400) Audrain' 'MO00401'='(MO00401) Farber'
                  'MO00403'='(MO00403) Martinsburg' 'MO00404'='(MO00404) Mexico'
                  'MO00405'='(MO00405) Vandalia' 'MO00500'='(MO00500) Barry'
                  'MO00501'='(MO00501) Cassville' 'MO00502'='(MO00502) Monett' 'MO00503'='(MO00503) Exeter'
                  'MO00504'='(MO00504) Purdy' 'MO00505'='(MO00505) Seligman' 'MO00507'='(MO00507) Washburn'
                  'MO00508'='(MO00508) Wheaton' 'MO00510'='(MO00510) Butterfield Village'
                  'MO00600'='(MO00600) Barton' 'MO00601'='(MO00601) Lamar'
                  'MO00608'='(MO00608) Golden City' 'MO00609'='(MO00609) Liberal'
                  'MO00700'='(MO00700) Bates' 'MO00701'='(MO00701) Adrian' 'MO00702'='(MO00702) Butler'
                  'MO00704'='(MO00704) Rich Hill' 'MO00800'='(MO00800) Benton'
                  'MO00801'='(MO00801) Cole Camp' 'MO00802'='(MO00802) Lincoln'
                  'MO00803'='(MO00803) Warsaw' 'MO00900'='(MO00900) Bollinger'
                  'MO00902'='(MO00902) Marble Hill' 'MO01000'='(MO01000) Boone'
                  'MO01001'='(MO01001) Centralia' 'MO01002'='(MO01002) Columbia'
                  'MO01003'='(MO01003) Sturgeon' 'MO01004'='(MO01004) Univ Of Mo: Columbia'
                  'MO01005'='(MO01005) Ashland' 'MO01006'='(MO01006) Hallsville'
                  'MO01100'='(MO01100) Buchanan' 'MO01101'='(MO01101) St. Joseph'
                  'MO01104'='(MO01104) Easton' 'MO01111'='(MO01111) Mo Western State Univers'
                  'MO01200'='(MO01200) Butler' 'MO01202'='(MO01202) Poplar Bluff'
                  'MO01300'='(MO01300) Caldwell' 'MO01301'='(MO01301) Braymer'
                  'MO01303'='(MO01303) Hamilton' 'MO01307'='(MO01307) Polo' 'MO01400'='(MO01400) Callaway'
                  'MO01401'='(MO01401) Auxvasse' 'MO01403'='(MO01403) Fulton'
                  'MO01404'='(MO01404) New Bloomfield' 'MO01405'='(MO01405) Holts Summit'
                  'MO01407'='(MO01407) Mokane' 'MO01500'='(MO01500) Camden' 'MO01501'='(MO01501) Camdenton'
                  'MO01502'='(MO01502) Osage Beach' 'MO01506'='(MO01506) Linn Creek'
                  'MO01509'='(MO01509) Sunrise Beach' 'MO01600'='(MO01600) Cape Girardeau'
                  'MO01601'='(MO01601) Cape Girardeau' 'MO01602'='(MO01602) Jackson'
                  'MO01603'='(MO01603) Delta' 'MO01609'='(MO01609) Southeast Mo State Unive'
                  'MO01700'='(MO01700) Carroll' 'MO01701'='(MO01701) Carrollton'
                  'MO01703'='(MO01703) Norborne' 'MO01800'='(MO01800) Carter'
                  'MO01801'='(MO01801) Van Buren' 'MO01802'='(MO01802) Ellsinore'
                  'MO01803'='(MO01803) Grandin' 'MO01900'='(MO01900) Cass' 'MO01901'='(MO01901) Archie'
                  'MO01902'='(MO01902) Belton' 'MO01903'='(MO01903) Drexel'
                  'MO01904'='(MO01904) Harrisonville' 'MO01905'='(MO01905) Pleasant Hill'
                  'MO01906'='(MO01906) Peculiar' 'MO01907'='(MO01907) Raymore'
                  'MO01908'='(MO01908) Garden City' 'MO01909'='(MO01909) Creighton'
                  'MO01910'='(MO01910) Lake Winnebago' 'MO01911'='(MO01911) Cleveland'
                  'MO01912'='(MO01912) East Lynne' 'MO01913'='(MO01913) Freeman'
                  'MO01915'='(MO01915) Lake Annette' 'MO02000'='(MO02000) Cedar'
                  'MO02001'='(MO02001) El Dorado Springs' 'MO02002'='(MO02002) Stockton'
                  'MO02100'='(MO02100) Chariton' 'MO02101'='(MO02101) Brunswick'
                  'MO02102'='(MO02102) Keytesville' 'MO02104'='(MO02104) Salisbury'
                  'MO02200'='(MO02200) Christian' 'MO02201'='(MO02201) Billings' 'MO02202'='(MO02202) Nixa'
                  'MO02203'='(MO02203) Ozark' 'MO02204'='(MO02204) Clever' 'MO02205'='(MO02205) Sparta'
                  'MO02208'='(MO02208) Highlandville' 'MO02300'='(MO02300) Clark'
                  'MO02301'='(MO02301) Kahoka' 'MO02304'='(MO02304) Revere' 'MO02400'='(MO02400) Clay'
                  'MO02402'='(MO02402) Claycomo' 'MO02403'='(MO02403) Excelsior Springs'
                  'MO02404'='(MO02404) Gladstone' 'MO02405'='(MO02405) Kearney'
                  'MO02406'='(MO02406) Liberty' 'MO02407'='(MO02407) North Kansas City'
                  'MO02408'='(MO02408) Smithville' 'MO02409'='(MO02409) Pleasant Valley'
                  'MO02410'='(MO02410) Oakview Village' 'MO02415'='(MO02415) Mosby'
                  'MO02416'='(MO02416) Clay County Park Authori' 'MO02417'='(MO02417) Randolph'
                  'MO02419'='(MO02419) Birmingham' 'MO02500'='(MO02500) Clinton'
                  'MO02501'='(MO02501) Cameron' 'MO02502'='(MO02502) Gower' 'MO02503'='(MO02503) Holt'
                  'MO02504'='(MO02504) Lathrop' 'MO02505'='(MO02505) Plattsburg'
                  'MO02507'='(MO02507) Trimble' 'MO02600'='(MO02600) Cole'
                  'MO02601'='(MO02601) Jefferson City' 'MO02617'='(MO02617) Capitol Police'
                  'MO02618'='(MO02618) Lincoln University' 'MO02700'='(MO02700) Cooper'
                  'MO02701'='(MO02701) Boonville' 'MO02703'='(MO02703) Otterville'
                  'MO02705'='(MO02705) Pilot Grove' 'MO02800'='(MO02800) Crawford'
                  'MO02801'='(MO02801) Bourbon' 'MO02802'='(MO02802) Cuba' 'MO02803'='(MO02803) Steelville'
                  'MO02810'='(MO02810) Sullivan' 'MO02900'='(MO02900) Dade'
                  'MO02901'='(MO02901) Greenfield' 'MO02902'='(MO02902) Lockwood'
                  'MO02906'='(MO02906) Everton' 'MO03000'='(MO03000) Dallas' 'MO03001'='(MO03001) Buffalo'
                  'MO03002'='(MO03002) Urbana' 'MO03100'='(MO03100) Daviess' 'MO03101'='(MO03101) Gallatin'
                  'MO03200'='(MO03200) De Kalb' 'MO03201'='(MO03201) Maysville' 'MO03300'='(MO03300) Dent'
                  'MO03301'='(MO03301) Salem' 'MO03400'='(MO03400) Douglas' 'MO03401'='(MO03401) Ava'
                  'MO03500'='(MO03500) Dunklin' 'MO03501'='(MO03501) Campbell'
                  'MO03502'='(MO03502) Cardwell' 'MO03503'='(MO03503) Clarkton'
                  'MO03504'='(MO03504) Hornersville' 'MO03505'='(MO03505) Kennett'
                  'MO03506'='(MO03506) Malden' 'MO03507'='(MO03507) Senath' 'MO03508'='(MO03508) Holcomb'
                  'MO03509'='(MO03509) Arbyrd' 'MO03600'='(MO03600) Franklin' 'MO03602'='(MO03602) Gerald'
                  'MO03603'='(MO03603) New Haven' 'MO03604'='(MO03604) Pacific'
                  'MO03605'='(MO03605) St. Clair' 'MO03606'='(MO03606) Sullivan'
                  'MO03607'='(MO03607) Union' 'MO03608'='(MO03608) Washington'
                  'MO03700'='(MO03700) Gasconade' 'MO03701'='(MO03701) Bland' 'MO03702'='(MO03702) Hermann'
                  'MO03703'='(MO03703) Owensville' 'MO03800'='(MO03800) Gentry'
                  'MO03802'='(MO03802) King City' 'MO03803'='(MO03803) Stanberry'
                  'MO03900'='(MO03900) Greene' 'MO03901'='(MO03901) Ash Grove'
                  'MO03902'='(MO03902) Republic' 'MO03903'='(MO03903) Springfield'
                  'MO03904'='(MO03904) Walnut Grove' 'MO03905'='(MO03905) Battlefield'
                  'MO03907'='(MO03907) Fair Grove' 'MO03908'='(MO03908) Strafford'
                  'MO03909'='(MO03909) Willard' 'MO04000'='(MO04000) Grundy' 'MO04001'='(MO04001) Trenton'
                  'MO04100'='(MO04100) Harrison' 'MO04101'='(MO04101) Bethany'
                  'MO04105'='(MO04105) Gilman City' 'MO04200'='(MO04200) Henry'
                  'MO04201'='(MO04201) Clinton' 'MO04203'='(MO04203) Windsor'
                  'MO04204'='(MO04204) Montrose' 'MO04208'='(MO04208) Urich' 'MO04300'='(MO04300) Hickory'
                  'MO04400'='(MO04400) Holt' 'MO04404'='(MO04404) Mound City' 'MO04500'='(MO04500) Howard'
                  'MO04501'='(MO04501) Fayette' 'MO04502'='(MO04502) Glasgow'
                  'MO04503'='(MO04503) New Franklin' 'MO04600'='(MO04600) Howell'
                  'MO04601'='(MO04601) Mountain View' 'MO04602'='(MO04602) West Plains'
                  'MO04603'='(MO04603) Willow Springs' 'MO04700'='(MO04700) Iron'
                  'MO04701'='(MO04701) Ironton' 'MO04702'='(MO04702) Pilot Knob'
                  'MO04703'='(MO04703) Annapolis' 'MO04705'='(MO04705) Viburnum'
                  'MO04800'='(MO04800) Jackson' 'MO04801'='(MO04801) Blue Springs'
                  'MO04802'='(MO04802) Buckner' 'MO04803'='(MO04803) Grain Valley'
                  'MO04804'='(MO04804) Grandview' 'MO04805'='(MO04805) Greenwood'
                  'MO04806'='(MO04806) Independence' 'MO04807'='(MO04807) Lake Lotawana'
                  'MO04808'='(MO04808) Lees Summit' 'MO04809'='(MO04809) Oak Grove'
                  'MO04810'='(MO04810) Raytown' 'MO04811'='(MO04811) Sugar Creek'
                  'MO04812'='(MO04812) Lone Jack' 'MO04813'='(MO04813) Lake Tapawingo'
                  'MO04820'='(MO04820) Univ Of Mo: Kansas City'
                  'MO04823'='(MO04823) Jackson County Park Rgrs' 'MO04900'='(MO04900) Jasper'
                  'MO04901'='(MO04901) Carl Junction' 'MO04902'='(MO04902) Carterville'
                  'MO04903'='(MO04903) Carthage' 'MO04904'='(MO04904) Jasper'
                  'MO04905'='(MO04905) Sarcoxie' 'MO04906'='(MO04906) Webb City'
                  'MO04907'='(MO04907) Joplin' 'MO04914'='(MO04914) Duenweg' 'MO04915'='(MO04915) Duquesne'
                  'MO04926'='(MO04926) Jasco Metropolitan' 'MO05000'='(MO05000) Jefferson'
                  'MO05001'='(MO05001) Crystal City' 'MO05002'='(MO05002) De Soto'
                  'MO05003'='(MO05003) Festus' 'MO05004'='(MO05004) Hillsboro'
                  'MO05005'='(MO05005) Kimmswick' 'MO05006'='(MO05006) Pevely' 'MO05007'='(MO05007) Arnold'
                  'MO05008'='(MO05008) Herculaneum' 'MO05009'='(MO05009) Olympian Village'
                  'MO05015'='(MO05015) Byrnes Mill' 'MO05100'='(MO05100) Johnson'
                  'MO05101'='(MO05101) Holden' 'MO05102'='(MO05102) Knob Noster'
                  'MO05103'='(MO05103) Warrensburg'
                  'MO05104'='(MO05104) Central Mo State Univers' 'MO05105'='(MO05105) Centerview'
                  'MO05107'='(MO05107) Kingsville' 'MO05108'='(MO05108) La Tour Village'
                  'MO05109'='(MO05109) Leeton' 'MO05200'='(MO05200) Knox' 'MO05202'='(MO05202) Edina'
                  'MO05300'='(MO05300) Laclede' 'MO05301'='(MO05301) Conway' 'MO05302'='(MO05302) Lebanon'
                  'MO05400'='(MO05400) Lafayette' 'MO05401'='(MO05401) Alma'
                  'MO05402'='(MO05402) Concordia' 'MO05403'='(MO05403) Corder'
                  'MO05404'='(MO05404) Higginsville' 'MO05405'='(MO05405) Lexington'
                  'MO05406'='(MO05406) Odessa' 'MO05407'='(MO05407) Waverly'
                  'MO05408'='(MO05408) Wellington' 'MO05409'='(MO05409) Napoleon'
                  'MO05411'='(MO05411) Bates City' 'MO05413'='(MO05413) Mayview'
                  'MO05416'='(MO05416) Lake Lafayette' 'MO05500'='(MO05500) Lawrence'
                  'MO05501'='(MO05501) Aurora' 'MO05502'='(MO05502) Marionville'
                  'MO05503'='(MO05503) Miller' 'MO05504'='(MO05504) Mount Vernon'
                  'MO05505'='(MO05505) Pierce City' 'MO05510'='(MO05510) Verona'
                  'MO05600'='(MO05600) Lewis' 'MO05601'='(MO05601) Canton' 'MO05602'='(MO05602) La Belle'
                  'MO05603'='(MO05603) La Grange' 'MO05700'='(MO05700) Lincoln'
                  'MO05701'='(MO05701) Elsberry' 'MO05702'='(MO05702) Old Monroe'
                  'MO05703'='(MO05703) Silex' 'MO05704'='(MO05704) Troy' 'MO05705'='(MO05705) Winfield'
                  'MO05706'='(MO05706) Foley' 'MO05707'='(MO05707) Hawk Point'
                  'MO05708'='(MO05708) Moscow Mills' 'MO05800'='(MO05800) Linn'
                  'MO05801'='(MO05801) Brookfield' 'MO05802'='(MO05802) Bucklin'
                  'MO05803'='(MO05803) Marceline' 'MO05900'='(MO05900) Livingston'
                  'MO05901'='(MO05901) Chillicothe' 'MO06000'='(MO06000) Mcdonald'
                  'MO06001'='(MO06001) Anderson' 'MO06002'='(MO06002) Noel' 'MO06003'='(MO06003) Pineville'
                  'MO06004'='(MO06004) Southwest City' 'MO06005'='(MO06005) Goodman'
                  'MO06006'='(MO06006) Lanagan' 'MO06100'='(MO06100) Macon' 'MO06102'='(MO06102) La Plata'
                  'MO06103'='(MO06103) Macon' 'MO06200'='(MO06200) Madison'
                  'MO06201'='(MO06201) Fredericktown' 'MO06203'='(MO06203) Marquand'
                  'MO06300'='(MO06300) Maries' 'MO06301'='(MO06301) Belle' 'MO06304'='(MO06304) Vienna'
                  'MO06400'='(MO06400) Marion' 'MO06401'='(MO06401) Hannibal' 'MO06402'='(MO06402) Palmyra'
                  'MO06500'='(MO06500) Mercer' 'MO06600'='(MO06600) Miller' 'MO06601'='(MO06601) Eldon'
                  'MO06602'='(MO06602) Iberia' 'MO06603'='(MO06603) Lake Ozark'
                  'MO06700'='(MO06700) Mississippi' 'MO06701'='(MO06701) Charleston'
                  'MO06702'='(MO06702) East Prairie' 'MO06800'='(MO06800) Moniteau'
                  'MO06801'='(MO06801) California' 'MO06802'='(MO06802) Tipton'
                  'MO06900'='(MO06900) Monroe' 'MO06902'='(MO06902) Monroe City'
                  'MO07000'='(MO07000) Montgomery' 'MO07001'='(MO07001) Jonesburg'
                  'MO07002'='(MO07002) Montgomery City' 'MO07003'='(MO07003) Wellsville'
                  'MO07004'='(MO07004) Bellflower' 'MO07006'='(MO07006) High Hill'
                  'MO07008'='(MO07008) New Florence' 'MO07100'='(MO07100) Morgan'
                  'MO07101'='(MO07101) Stover' 'MO07102'='(MO07102) Versailles'
                  'MO07106'='(MO07106) Gravois Mills' 'MO07107'='(MO07107) Laurie'
                  'MO07200'='(MO07200) New Madrid' 'MO07201'='(MO07201) Gideon'
                  'MO07202'='(MO07202) Lilbourn' 'MO07203'='(MO07203) Morehouse'
                  'MO07204'='(MO07204) New Madrid' 'MO07205'='(MO07205) Parma'
                  'MO07206'='(MO07206) Portageville' 'MO07207'='(MO07207) Canalou'
                  'MO07209'='(MO07209) Howardville' 'MO07210'='(MO07210) Marston'
                  'MO07211'='(MO07211) Matthews' 'MO07214'='(MO07214) Risco' 'MO07300'='(MO07300) Newton'
                  'MO07301'='(MO07301) Diamond' 'MO07302'='(MO07302) Granby' 'MO07303'='(MO07303) Neosho'
                  'MO07304'='(MO07304) Seneca' 'MO07400'='(MO07400) Nodaway'
                  'MO07401'='(MO07401) Northwest Mo State Univ' 'MO07402'='(MO07402) Maryville'
                  'MO07500'='(MO07500) Oregon' 'MO07501'='(MO07501) Alton' 'MO07502'='(MO07502) Thayer'
                  'MO07600'='(MO07600) Osage' 'MO07603'='(MO07603) Linn' 'MO07700'='(MO07700) Ozark'
                  'MO07701'='(MO07701) Gainesville' 'MO07702'='(MO07702) Theodosia'
                  'MO07800'='(MO07800) Pemiscot' 'MO07801'='(MO07801) Caruthersville'
                  'MO07802'='(MO07802) Cooter' 'MO07803'='(MO07803) Hayti' 'MO07805'='(MO07805) Steele'
                  'MO07806'='(MO07806) Wardell' 'MO07812'='(MO07812) Hayti Heights'
                  'MO07813'='(MO07813) Homestown' 'MO07900'='(MO07900) Perry'
                  'MO07901'='(MO07901) Perryville' 'MO08000'='(MO08000) Pettis'
                  'MO08002'='(MO08002) La Monte' 'MO08003'='(MO08003) Sedalia'
                  'MO08006'='(MO08006) Smithton' 'MO08100'='(MO08100) Phelps' 'MO08101'='(MO08101) Rolla'
                  'MO08102'='(MO08102) St. James' 'MO08104'='(MO08104) Newburg'
                  'MO08107'='(MO08107) Univ Of Mo: Rolla' 'MO08200'='(MO08200) Pike'
                  'MO08201'='(MO08201) Bowling Green' 'MO08203'='(MO08203) Louisiana'
                  'MO08300'='(MO08300) Platte' 'MO08301'='(MO08301) Parkville'
                  'MO08302'='(MO08302) Platte City' 'MO08303'='(MO08303) Platte Woods'
                  'MO08304'='(MO08304) Weston' 'MO08305'='(MO08305) Riverside'
                  'MO08306'='(MO08306) Lake Waukomis' 'MO08307'='(MO08307) Northmoor'
                  'MO08308'='(MO08308) Houston Lake' 'MO08309'='(MO08309) Camden Point'
                  'MO08311'='(MO08311) Edgerton' 'MO08313'='(MO08313) Ferrelview'
                  'MO08314'='(MO08314) Tracy' 'MO08315'='(MO08315) Weatherby Lake'
                  'MO08400'='(MO08400) Polk' 'MO08401'='(MO08401) Bolivar'
                  'MO08402'='(MO08402) Humansville' 'MO08409'='(MO08409) Fair Play'
                  'MO08414'='(MO08414) Pleasant Hope' 'MO08500'='(MO08500) Pulaski'
                  'MO08501'='(MO08501) Crocker' 'MO08502'='(MO08502) Dixon' 'MO08503'='(MO08503) Richland'
                  'MO08504'='(MO08504) St. Robert' 'MO08505'='(MO08505) Waynesville'
                  'MO08600'='(MO08600) Putnam' 'MO08601'='(MO08601) Unionville' 'MO08700'='(MO08700) Ralls'
                  'MO08701'='(MO08701) Center' 'MO08702'='(MO08702) New London' 'MO08703'='(MO08703) Perry'
                  'MO08800'='(MO08800) Randolph' 'MO08801'='(MO08801) Higbee'
                  'MO08802'='(MO08802) Huntsville' 'MO08803'='(MO08803) Moberly' 'MO08900'='(MO08900) Ray'
                  'MO08901'='(MO08901) Hardin' 'MO08902'='(MO08902) Richmond' 'MO08903'='(MO08903) Lawson'
                  'MO08908'='(MO08908) Henrietta' 'MO08909'='(MO08909) Orrick'
                  'MO08911'='(MO08911) Wood Heights' 'MO09000'='(MO09000) Reynolds'
                  'MO09001'='(MO09001) Ellington' 'MO09002'='(MO09002) Bunker' 'MO09100'='(MO09100) Ripley'
                  'MO09101'='(MO09101) Doniphan' 'MO09102'='(MO09102) Naylor'
                  'MO09200'='(MO09200) St. Charles' 'MO09201'='(MO09201) Ofallon'
                  'MO09203'='(MO09203) St. Charles' 'MO09204'='(MO09204) St. Peters'
                  'MO09205'='(MO09205) Wentzville' 'MO09206'='(MO09206) Augusta'
                  'MO09207'='(MO09207) Cottleville' 'MO09209'='(MO09209) Lake St. Louis'
                  'MO09212'='(MO09212) Foristell' 'MO09213'='(MO09213) St. Charles Parks & Rec'
                  'MO09215'='(MO09215) St. Peters Ranger Div' 'MO09216'='(MO09216) New Melle'
                  'MO09220'='(MO09220) St Charles Cnty Prk Rgrs' 'MO09300'='(MO09300) St. Clair'
                  'MO09301'='(MO09301) Appleton City' 'MO09302'='(MO09302) Osceola'
                  'MO09305'='(MO09305) Lowry City' 'MO09400'='(MO09400) St. Francois'
                  'MO09401'='(MO09401) Bismarck' 'MO09402'='(MO09402) Bonne Terre'
                  'MO09403'='(MO09403) Desloge' 'MO09406'='(MO09406) Farmington'
                  'MO09407'='(MO09407) Flat River' 'MO09408'='(MO09408) Leadwood'
                  'MO09416'='(MO09416) Leadington' 'MO09421'='(MO09421) Iron Mountain Lake'
                  'MO09422'='(MO09422) Park Hills' 'MO09424'='(MO09424) Mineral Area College'
                  'MO09500'='(MO09500) St. Louis County Pol Dep'
                  'MO09501'='(MO09501) Washington University' 'MO09502'='(MO09502) Ballwin'
                  'MO09503'='(MO09503) Bella Villa' 'MO09504'='(MO09504) Bellefontaine Neighbors'
                  'MO09505'='(MO09505) Bel-Nor' 'MO09506'='(MO09506) Bel-Ridge'
                  'MO09507'='(MO09507) Berkeley' 'MO09508'='(MO09508) Breckenridge Hills'
                  'MO09509'='(MO09509) Brentwood' 'MO0950B'='(MO0950B) Univ Of Mo: St. Louis'
                  'MO0950C'='(MO0950C) St Louis Com Col,Meramec'
                  'MO0950D'='(MO0950D) Lambert-St Louis Int Air'
                  'MO0950E'='(MO0950E) Washington University'
                  'MO0950H'='(MO0950H) Maryland Heights' 'MO09510'='(MO09510) Bridgeton'
                  'MO09511'='(MO09511) Calverton Park' 'MO09512'='(MO09512) Charlack'
                  'MO09513'='(MO09513) Clarkson Valley' 'MO09514'='(MO09514) Clayton'
                  'MO09515'='(MO09515) Cool Valley' 'MO09516'='(MO09516) Country Club Hills'
                  'MO09518'='(MO09518) Crestwood' 'MO09519'='(MO09519) Creve Coeur'
                  'MO09521'='(MO09521) Dellwood' 'MO09522'='(MO09522) Des Peres'
                  'MO09523'='(MO09523) Edmundson' 'MO09525'='(MO09525) Ellisville'
                  'MO09526'='(MO09526) Eureka' 'MO09527'='(MO09527) Fenton' 'MO09528'='(MO09528) Ferguson'
                  'MO09529'='(MO09529) Flordell Hills' 'MO09530'='(MO09530) Florissant'
                  'MO09531'='(MO09531) Frontenac' 'MO09532'='(MO09532) Glendale'
                  'MO09533'='(MO09533) Glen Echo Park' 'MO09536'='(MO09536) Greendale'
                  'MO09537'='(MO09537) Hanley Hills' 'MO09538'='(MO09538) Hazelwood'
                  'MO09539'='(MO09539) Hillsdale' 'MO09541'='(MO09541) Jennings'
                  'MO09542'='(MO09542) Kinloch' 'MO09543'='(MO09543) Kirkwood' 'MO09544'='(MO09544) Ladue'
                  'MO09545'='(MO09545) Lakeshire' 'MO09547'='(MO09547) Manchester'
                  'MO09548'='(MO09548) Maplewood' 'MO09550'='(MO09550) Marlborough'
                  'MO09551'='(MO09551) Moline Acres' 'MO09552'='(MO09552) Normandy'
                  'MO09553'='(MO09553) Northwoods' 'MO09555'='(MO09555) Olivette'
                  'MO09556'='(MO09556) Overland' 'MO09557'='(MO09557) Pagedale'
                  'MO09558'='(MO09558) Pasadena Hills' 'MO09559'='(MO09559) Pasadena Park'
                  'MO09560'='(MO09560) Peerless Park' 'MO09561'='(MO09561) Pine Lawn'
                  'MO09562'='(MO09562) Richmond Heights' 'MO09563'='(MO09563) Riverview'
                  'MO09564'='(MO09564) Rock Hill' 'MO09565'='(MO09565) St. Ann'
                  'MO09566'='(MO09566) St. George' 'MO09567'='(MO09567) St. John'
                  'MO09568'='(MO09568) St. Louis' 'MO09569'='(MO09569) Shrewsbury'
                  'MO09570'='(MO09570) Sunset Hills' 'MO09571'='(MO09571) Times Beach'
                  'MO09572'='(MO09572) Town And Country' 'MO09573'='(MO09573) University City'
                  'MO09574'='(MO09574) Valley Park' 'MO09575'='(MO09575) Velda City'
                  'MO09576'='(MO09576) Velda Village Hills' 'MO09577'='(MO09577) Vinita Park'
                  'MO09579'='(MO09579) Warson Woods' 'MO09580'='(MO09580) Webster Groves'
                  'MO09581'='(MO09581) Wellston' 'MO09583'='(MO09583) Winchester'
                  'MO09584'='(MO09584) Woodson Terrace' 'MO09585'='(MO09585) Beverly Hills'
                  'MO09590'='(MO09590) Westwood' 'MO09591'='(MO09591) Uplands Park'
                  'MO09592'='(MO09592) Bellerive' 'MO09597'='(MO09597) Oakland'
                  'MO0959A'='(MO0959A) Chesterfield' 'MO09700'='(MO09700) Ste. Genevieve'
                  'MO09701'='(MO09701) Ste. Genevieve' 'MO09702'='(MO09702) St. Marys'
                  'MO09800'='(MO09800) Saline' 'MO09801'='(MO09801) Marshall' 'MO09802'='(MO09802) Slater'
                  'MO09803'='(MO09803) Sweet Springs' 'MO09805'='(MO09805) Blackburn'
                  'MO09806'='(MO09806) Emma' 'MO09900'='(MO09900) Schuyler' 'MO10000'='(MO10000) Scotland'
                  'MO10001'='(MO10001) Memphis' 'MO10100'='(MO10100) Scott' 'MO10101'='(MO10101) Chaffee'
                  'MO10104'='(MO10104) Oran' 'MO10105'='(MO10105) Scott City'
                  'MO10106'='(MO10106) Sikeston' 'MO10109'='(MO10109) Miner' 'MO10200'='(MO10200) Shannon'
                  'MO10201'='(MO10201) Birch Tree' 'MO10202'='(MO10202) Winona'
                  'MO10203'='(MO10203) Eminence' 'MO10300'='(MO10300) Shelby'
                  'MO10302'='(MO10302) Clarence' 'MO10304'='(MO10304) Shelbina'
                  'MO10305'='(MO10305) Shelbyville' 'MO10400'='(MO10400) Stoddard'
                  'MO10401'='(MO10401) Advance' 'MO10402'='(MO10402) Bernie'
                  'MO10403'='(MO10403) Bloomfield' 'MO10404'='(MO10404) Dexter'
                  'MO10405'='(MO10405) Puxico' 'MO10500'='(MO10500) Stone' 'MO10501'='(MO10501) Crane'
                  'MO10502'='(MO10502) Galena' 'MO10503'='(MO10503) Reeds Spring'
                  'MO10504'='(MO10504) Hurley' 'MO10505'='(MO10505) Kimberling City'
                  'MO10506'='(MO10506) Branson West' 'MO10507'='(MO10507) Indian Point'
                  'MO10600'='(MO10600) Sullivan' 'MO10601'='(MO10601) Milan' 'MO10700'='(MO10700) Taney'
                  'MO10701'='(MO10701) Branson' 'MO10702'='(MO10702) Forsyth'
                  'MO10703'='(MO10703) Hollister' 'MO10704'='(MO10704) Rockaway Beach'
                  'MO10706'='(MO10706) Merriam Woods' 'MO10800'='(MO10800) Texas'
                  'MO10801'='(MO10801) Cabool' 'MO10802'='(MO10802) Houston' 'MO10803'='(MO10803) Licking'
                  'MO10805'='(MO10805) Summersville' 'MO10900'='(MO10900) Vernon'
                  'MO10901'='(MO10901) Nevada' 'MO10902'='(MO10902) Sheldon' 'MO11000'='(MO11000) Warren'
                  'MO11001'='(MO11001) Marthasville' 'MO11002'='(MO11002) Truesdale'
                  'MO11003'='(MO11003) Warrenton' 'MO11004'='(MO11004) Wright City'
                  'MO11100'='(MO11100) Washington' 'MO11102'='(MO11102) Irondale'
                  'MO11103'='(MO11103) Potosi' 'MO11200'='(MO11200) Wayne' 'MO11201'='(MO11201) Piedmont'
                  'MO11300'='(MO11300) Webster' 'MO11301'='(MO11301) Marshfield'
                  'MO11302'='(MO11302) Seymour' 'MO11304'='(MO11304) Fordland'
                  'MO11305'='(MO11305) Niangua' 'MO11306'='(MO11306) Rogersville'
                  'MO11400'='(MO11400) Worth' 'MO11500'='(MO11500) Wright' 'MO11501'='(MO11501) Hartville'
                  'MO11502'='(MO11502) Mansfield' 'MO11503'='(MO11503) Mountain Grove'
                  'MO11504'='(MO11504) Norwood' 'MOKPD00'='(MOKPD00) Kansas City'
                  'MOMHP00'='(MOMHP00) Mo State Highway Patrol' 'MOSPD00'='(MOSPD00) St. Louis'
                  'MS00100'='(MS00100) Adams' 'MS00101'='(MS00101) Natchez' 'MS00200'='(MS00200) Alcorn'
                  'MS00201'='(MS00201) Corinth' 'MS00300'='(MS00300) Amite' 'MS00301'='(MS00301) Gloster'
                  'MS00400'='(MS00400) Attala' 'MS00401'='(MS00401) Kosciusko' 'MS00500'='(MS00500) Benton'
                  'MS00600'='(MS00600) Bolivar' 'MS00601'='(MS00601) Cleveland'
                  'MS00602'='(MS00602) Mound Bayou' 'MS00603'='(MS00603) Shelby' 'MS00604'='(MS00604) Shaw'
                  'MS00605'='(MS00605) Rosedale' 'MS00700'='(MS00700) Calhoun' 'MS00701'='(MS00701) Bruce'
                  'MS00702'='(MS00702) Calhoun City' 'MS00800'='(MS00800) Carroll'
                  'MS00801'='(MS00801) Vaiden' 'MS00900'='(MS00900) Chickasaw'
                  'MS00901'='(MS00901) Houston' 'MS00902'='(MS00902) Okolona' 'MS01000'='(MS01000) Choctaw'
                  'MS01001'='(MS01001) Ackerman' 'MS01100'='(MS01100) Claiborne'
                  'MS01101'='(MS01101) Port Gibson' 'MS01200'='(MS01200) Clarke'
                  'MS01201'='(MS01201) Quitman' 'MS01203'='(MS01203) Stonewall' 'MS01300'='(MS01300) Clay'
                  'MS01301'='(MS01301) West Point' 'MS01400'='(MS01400) Coahoma'
                  'MS01401'='(MS01401) Clarksdale' 'MS01403'='(MS01403) Coahoma Community Colleg'
                  'MS01500'='(MS01500) Copiah' 'MS01501'='(MS01501) Crystal Springs'
                  'MS01502'='(MS01502) Hazlehurst' 'MS01600'='(MS01600) Covington'
                  'MS01601'='(MS01601) Collins' 'MS01700'='(MS01700) Desoto'
                  'MS01701'='(MS01701) Southaven' 'MS01702'='(MS01702) Olive Branch'
                  'MS01703'='(MS01703) Hernando' 'MS01704'='(MS01704) Horn Lake'
                  'MS01800'='(MS01800) Forrest' 'MS01801'='(MS01801) Hattiesburg'
                  'MS01802'='(MS01802) Petal' 'MS01900'='(MS01900) Franklin'
                  'MS01902'='(MS01902) Mccall Creek' 'MS01904'='(MS01904) Roxie'
                  'MS02000'='(MS02000) George' 'MS02001'='(MS02001) Lucedale' 'MS02100'='(MS02100) Greene'
                  'MS02101'='(MS02101) Leakesville' 'MS02102'='(MS02102) Mclain'
                  'MS02200'='(MS02200) Grenada' 'MS02201'='(MS02201) Grenada' 'MS02300'='(MS02300) Hancock'
                  'MS02302'='(MS02302) Bay St. Louis' 'MS02303'='(MS02303) Waveland'
                  'MS02400'='(MS02400) Harrison' 'MS02401'='(MS02401) Biloxi'
                  'MS02402'='(MS02402) Gulfport' 'MS02403'='(MS02403) Long Beach'
                  'MS02404'='(MS02404) Pass Christian' 'MS02500'='(MS02500) Hinds'
                  'MS02501'='(MS02501) Jackson' 'MS02502'='(MS02502) Raymond' 'MS02503'='(MS02503) Clinton'
                  'MS02504'='(MS02504) Utica' 'MS02506'='(MS02506) Terry' 'MS02507'='(MS02507) Edwards'
                  'MS02510'='(MS02510) Jackson State University'
                  'MS02511'='(MS02511) Hinds Community College'
                  'MS02516'='(MS02516) Univ Of Ms: Medical Ctr'
                  'MS02519'='(MS02519) State Capitol Police' 'MS02600'='(MS02600) Holmes'
                  'MS02601'='(MS02601) Durant' 'MS02602'='(MS02602) Lexington' 'MS02603'='(MS02603) Tchula'
                  'MS02605'='(MS02605) Pickens' 'MS02606'='(MS02606) Goodman'
                  'MS02700'='(MS02700) Humphreys' 'MS02701'='(MS02701) Belzoni'
                  'MS02800'='(MS02800) Issaquena' 'MS02900'='(MS02900) Itawamba'
                  'MS02901'='(MS02901) Fulton' 'MS02902'='(MS02902) Itawamba Community Colle'
                  'MS03000'='(MS03000) Jackson' 'MS03001'='(MS03001) Moss Point'
                  'MS03002'='(MS03002) Ocean Springs' 'MS03003'='(MS03003) Pascagoula'
                  'MS03100'='(MS03100) Jasper' 'MS03101'='(MS03101) Bay Springs'
                  'MS03102'='(MS03102) Heidelberg' 'MS03200'='(MS03200) Jefferson'
                  'MS03201'='(MS03201) Fayette' 'MS03300'='(MS03300) Jefferson Davis'
                  'MS03400'='(MS03400) Jones' 'MS03401'='(MS03401) Ellisville' 'MS03402'='(MS03402) Laurel'
                  'MS03403'='(MS03403) Sandersville' 'MS03500'='(MS03500) Kemper'
                  'MS03501'='(MS03501) De Kalb' 'MS03502'='(MS03502) East Miss Jr College'
                  'MS03600'='(MS03600) Lafayette' 'MS03601'='(MS03601) Oxford'
                  'MS03602'='(MS03602) Univ Of Ms: Oxford' 'MS03700'='(MS03700) Lamar'
                  'MS03701'='(MS03701) Purvis' 'MS03800'='(MS03800) Lauderdale'
                  'MS03801'='(MS03801) Meridian' 'MS03900'='(MS03900) Lawrence' 'MS04000'='(MS04000) Leake'
                  'MS04001'='(MS04001) Carthage' 'MS04100'='(MS04100) Lee' 'MS04101'='(MS04101) Tupelo'
                  'MS04105'='(MS04105) Verona' 'MS04200'='(MS04200) Leflore'
                  'MS04201'='(MS04201) Greenwood' 'MS04202'='(MS04202) Itta Bena'
                  'MS04300'='(MS04300) Lincoln' 'MS04301'='(MS04301) Brookhaven'
                  'MS04400'='(MS04400) Lowndes' 'MS04401'='(MS04401) Columbus'
                  'MS04500'='(MS04500) Madison' 'MS04501'='(MS04501) Canton'
                  'MS04502'='(MS04502) Ridgeland' 'MS04504'='(MS04504) Madison'
                  'MS04600'='(MS04600) Marion' 'MS04601'='(MS04601) Columbia'
                  'MS04700'='(MS04700) Marshall' 'MS04701'='(MS04701) Holly Springs'
                  'MS04702'='(MS04702) Byhalia' 'MS04800'='(MS04800) Monroe' 'MS04801'='(MS04801) Aberdeen'
                  'MS04802'='(MS04802) Amory' 'MS04900'='(MS04900) Montgomery' 'MS04901'='(MS04901) Winona'
                  'MS05000'='(MS05000) Neshoba' 'MS05001'='(MS05001) Philadelphia'
                  'MS05100'='(MS05100) Newton' 'MS05101'='(MS05101) Decatur' 'MS05102'='(MS05102) Newton'
                  'MS05200'='(MS05200) Noxubee' 'MS05201'='(MS05201) Macon' 'MS05300'='(MS05300) Oktibbeha'
                  'MS05301'='(MS05301) Starkville' 'MS05303'='(MS05303) Mississippi State Univ'
                  'MS05400'='(MS05400) Panola' 'MS05401'='(MS05401) Batesville'
                  'MS05403'='(MS05403) Crenshaw' 'MS05404'='(MS05404) Como'
                  'MS05500'='(MS05500) Pearl River' 'MS05501'='(MS05501) Picayune'
                  'MS05502'='(MS05502) Poplarville' 'MS05600'='(MS05600) Perry' 'MS05700'='(MS05700) Pike'
                  'MS05701'='(MS05701) Magnolia' 'MS05702'='(MS05702) Mccomb' 'MS05703'='(MS05703) Summit'
                  'MS05800'='(MS05800) Pontotoc' 'MS05900'='(MS05900) Prentiss'
                  'MS05901'='(MS05901) Booneville' 'MS05902'='(MS05902) Baldwyn'
                  'MS06000'='(MS06000) Quitman' 'MS06001'='(MS06001) Marks' 'MS06100'='(MS06100) Rankin'
                  'MS06101'='(MS06101) Brandon' 'MS06102'='(MS06102) Pearl'
                  'MS06103'='(MS06103) Pelahatchie' 'MS06104'='(MS06104) Flowood'
                  'MS06105'='(MS06105) Richland' 'MS06106'='(MS06106) Florence' 'MS06200'='(MS06200) Scott'
                  'MS06201'='(MS06201) Forest' 'MS06202'='(MS06202) Morton' 'MS06300'='(MS06300) Sharkey'
                  'MS06301'='(MS06301) Rolling Fork' 'MS06400'='(MS06400) Simpson'
                  'MS06401'='(MS06401) Magee' 'MS06402'='(MS06402) Mendenhall' 'MS06500'='(MS06500) Smith'
                  'MS06600'='(MS06600) Stone' 'MS06601'='(MS06601) Wiggins' 'MS06700'='(MS06700) Sunflower'
                  'MS06701'='(MS06701) Indianola' 'MS06702'='(MS06702) Drew'
                  'MS06703'='(MS06703) Ruleville' 'MS06704'='(MS06704) Moorhead'
                  'MS06705'='(MS06705) Inverness' 'MS06706'='(MS06706) Sunflower'
                  'MS06800'='(MS06800) Tallahatchie' 'MS06801'='(MS06801) Charleston'
                  'MS06900'='(MS06900) Tate' 'MS06901'='(MS06901) Senatobia'
                  'MS06903'='(MS06903) Coldwater' 'MS07000'='(MS07000) Tippah' 'MS07001'='(MS07001) Ripley'
                  'MS07100'='(MS07100) Tishomingo' 'MS07101'='(MS07101) Iuka' 'MS07200'='(MS07200) Tunica'
                  'MS07300'='(MS07300) Union' 'MS07301'='(MS07301) New Albany'
                  'MS07400'='(MS07400) Walthall' 'MS07401'='(MS07401) Tylertown'
                  'MS07500'='(MS07500) Warren' 'MS07501'='(MS07501) Vicksburg'
                  'MS07600'='(MS07600) Washington' 'MS07601'='(MS07601) Greenville'
                  'MS07602'='(MS07602) Leland' 'MS07603'='(MS07603) Hollandale' 'MS07700'='(MS07700) Wayne'
                  'MS07701'='(MS07701) Waynesboro' 'MS07800'='(MS07800) Webster'
                  'MS07801'='(MS07801) Eupora' 'MS07900'='(MS07900) Wilkinson'
                  'MS08000'='(MS08000) Winston' 'MS08001'='(MS08001) Louisville'
                  'MS08100'='(MS08100) Yalobusha' 'MS08101'='(MS08101) Water Valley'
                  'MS08200'='(MS08200) Yazoo' 'MS08201'='(MS08201) Yazoo City'
                  'MSMHP00'='(MSMHP00) Ms Highway Safety Patrol' 'MT00100'='(MT00100) Beaverhead'
                  'MT00101'='(MT00101) Dillon' 'MT00200'='(MT00200) Big Horn' 'MT00201'='(MT00201) Hardin'
                  'MT00300'='(MT00300) Blaine' 'MT00301'='(MT00301) Chinook' 'MT00302'='(MT00302) Harlem'
                  'MT00400'='(MT00400) Broadwater' 'MT00500'='(MT00500) Carbon'
                  'MT00501'='(MT00501) Red Lodge' 'MT00502'='(MT00502) Bridger'
                  'MT00504'='(MT00504) Joliet' 'MT00600'='(MT00600) Carter' 'MT00601'='(MT00601) Ekalaka'
                  'MT00700'='(MT00700) Cascade' 'MT00701'='(MT00701) Great Falls'
                  'MT00702'='(MT00702) Belt' 'MT00800'='(MT00800) Chouteau'
                  'MT00801'='(MT00801) Fort Benton' 'MT00900'='(MT00900) Custer'
                  'MT00901'='(MT00901) Miles City' 'MT01000'='(MT01000) Daniels'
                  'MT01001'='(MT01001) Scobey' 'MT01100'='(MT01100) Dawson' 'MT01101'='(MT01101) Glendive'
                  'MT01200'='(MT01200) Deer Lodge' 'MT01201'='(MT01201) Anaconda'
                  'MT01300'='(MT01300) Fallon' 'MT01301'='(MT01301) Baker' 'MT01400'='(MT01400) Fergus'
                  'MT01401'='(MT01401) Lewistown' 'MT01500'='(MT01500) Flathead'
                  'MT01501'='(MT01501) Columbia Falls' 'MT01502'='(MT01502) Whitefish'
                  'MT01503'='(MT01503) Kalispell' 'MT01600'='(MT01600) Gallatin'
                  'MT01601'='(MT01601) Bozeman' 'MT01602'='(MT01602) Belgrade'
                  'MT01603'='(MT01603) Three Forks' 'MT01604'='(MT01604) West Yellowstone'
                  'MT01605'='(MT01605) Manhattan' 'MT01606'='(MT01606) Montana State University'
                  'MT01700'='(MT01700) Garfield' 'MT01800'='(MT01800) Glacier'
                  'MT01802'='(MT01802) Cut Bank' 'MT01900'='(MT01900) Golden Valley'
                  'MT02000'='(MT02000) Granite' 'MT02100'='(MT02100) Hill' 'MT02101'='(MT02101) Havre'
                  'MT02200'='(MT02200) Jefferson' 'MT02201'='(MT02201) Boulder'
                  'MT02202'='(MT02202) Whitehall' 'MT02300'='(MT02300) Judith Basin'
                  'MT02400'='(MT02400) Lake' 'MT02401'='(MT02401) Polson' 'MT02402'='(MT02402) Ronan City'
                  'MT02403'='(MT02403) St. Ignatius' 'MT02405'='(MT02405) Flathead Tribal'
                  'MT02500'='(MT02500) Lewis And Clark' 'MT02501'='(MT02501) Helena'
                  'MT02502'='(MT02502) East Helena'
                  'MT02505'='(MT02505) Gambling Invstgtns Burea' 'MT02600'='(MT02600) Liberty'
                  'MT02700'='(MT02700) Lincoln' 'MT02701'='(MT02701) Libby' 'MT02702'='(MT02702) Eureka'
                  'MT02703'='(MT02703) Troy' 'MT02800'='(MT02800) Mccone' 'MT02900'='(MT02900) Madison'
                  'MT02901'='(MT02901) Ennis' 'MT03000'='(MT03000) Meagher' 'MT03100'='(MT03100) Mineral'
                  'MT03200'='(MT03200) Missoula' 'MT03201'='(MT03201) Missoula'
                  'MT03203'='(MT03203) University Of Montana' 'MT03300'='(MT03300) Musselshell'
                  'MT03301'='(MT03301) Roundup' 'MT03400'='(MT03400) Park' 'MT03401'='(MT03401) Livingston'
                  'MT03500'='(MT03500) Petroleum' 'MT03600'='(MT03600) Phillips'
                  'MT03601'='(MT03601) Malta' 'MT03700'='(MT03700) Pondera' 'MT03701'='(MT03701) Conrad'
                  'MT03702'='(MT03702) Valier' 'MT03800'='(MT03800) Powder River'
                  'MT03900'='(MT03900) Powell' 'MT03901'='(MT03901) Deer Lodge'
                  'MT04000'='(MT04000) Prairie' 'MT04100'='(MT04100) Ravalli'
                  'MT04101'='(MT04101) Hamilton' 'MT04102'='(MT04102) Stevensville'
                  'MT04104'='(MT04104) Pinesdale' 'MT04200'='(MT04200) Richland'
                  'MT04201'='(MT04201) Sidney' 'MT04300'='(MT04300) Roosevelt' 'MT04301'='(MT04301) Poplar'
                  'MT04302'='(MT04302) Wolf Point' 'MT04303'='(MT04303) Culbertson'
                  'MT04305'='(MT04305) Brockton' 'MT04400'='(MT04400) Rosebud'
                  'MT04403'='(MT04403) Colstrip' 'MT04500'='(MT04500) Sanders'
                  'MT04502'='(MT04502) Hot Springs' 'MT04503'='(MT04503) Thompson Falls'
                  'MT04504'='(MT04504) Plains' 'MT04600'='(MT04600) Sheridan'
                  'MT04601'='(MT04601) Plentywood' 'MT04700'='(MT04700) Silver Bow'
                  'MT04701'='(MT04701) Butte-Silver Bow' 'MT04800'='(MT04800) Stillwater'
                  'MT04801'='(MT04801) Columbus' 'MT04900'='(MT04900) Sweet Grass'
                  'MT05000'='(MT05000) Teton' 'MT05001'='(MT05001) Choteau' 'MT05100'='(MT05100) Toole'
                  'MT05101'='(MT05101) Shelby' 'MT05200'='(MT05200) Treasure' 'MT05300'='(MT05300) Valley'
                  'MT05301'='(MT05301) Glasgow' 'MT05302'='(MT05302) Fort Peck'
                  'MT05400'='(MT05400) Wheatland' 'MT05500'='(MT05500) Wibaux' 'MT05501'='(MT05501) Wibaux'
                  'MT05600'='(MT05600) Yellowstone' 'MT05601'='(MT05601) Billings'
                  'MT05602'='(MT05602) Laurel' 'MTMHP00'='(MTMHP00) Montana Highway Patrol'
                  'NB00100'='(NB00100) Adams' 'NB00101'='(NB00101) Hastings' 'NB00200'='(NB00200) Antelope'
                  'NB00201'='(NB00201) Neligh' 'NB00202'='(NB00202) Elgin' 'NB00300'='(NB00300) Arthur'
                  'NB00400'='(NB00400) Banner' 'NB00500'='(NB00500) Blaine' 'NB00600'='(NB00600) Boone'
                  'NB00601'='(NB00601) Albion' 'NB00602'='(NB00602) St. Edward'
                  'NB00603'='(NB00603) Petersburg' 'NB00604'='(NB00604) Cedar Rapids'
                  'NB00700'='(NB00700) Box Butte' 'NB00701'='(NB00701) Alliance' 'NB00800'='(NB00800) Boyd'
                  'NB00801'='(NB00801) Spencer' 'NB00900'='(NB00900) Brown' 'NB00901'='(NB00901) Ainsworth'
                  'NB01000'='(NB01000) Buffalo' 'NB01001'='(NB01001) Kearney' 'NB01002'='(NB01002) Gibbon'
                  'NB01003'='(NB01003) Ravenna' 'NB01004'='(NB01004) Shelton'
                  'NB01005'='(NB01005) Univ Of Nebraska:Kearney' 'NB01100'='(NB01100) Burt'
                  'NB01101'='(NB01101) Lyons' 'NB01102'='(NB01102) Oakland' 'NB01103'='(NB01103) Tekamah'
                  'NB01200'='(NB01200) Butler' 'NB01201'='(NB01201) David City' 'NB01300'='(NB01300) Cass'
                  'NB01301'='(NB01301) Plattsmouth' 'NB01302'='(NB01302) Weeping Water'
                  'NB01303'='(NB01303) Louisville' 'NB01400'='(NB01400) Cedar'
                  'NB01401'='(NB01401) Hartington' 'NB01402'='(NB01402) Randolph'
                  'NB01403'='(NB01403) Laurel' 'NB01404'='(NB01404) Coleridge' 'NB01500'='(NB01500) Chase'
                  'NB01501'='(NB01501) Imperial' 'NB01502'='(NB01502) Wauneta' 'NB01600'='(NB01600) Cherry'
                  'NB01601'='(NB01601) Valentine' 'NB01700'='(NB01700) Cheyenne'
                  'NB01701'='(NB01701) Sidney' 'NB01800'='(NB01800) Clay' 'NB01801'='(NB01801) Harvard'
                  'NB01802'='(NB01802) Sutton' 'NB01900'='(NB01900) Colfax' 'NB01901'='(NB01901) Schuyler'
                  'NB02000'='(NB02000) Cuming' 'NB02001'='(NB02001) West Point'
                  'NB02002'='(NB02002) Wisner' 'NB02003'='(NB02003) Beemer' 'NB02100'='(NB02100) Custer'
                  'NB02101'='(NB02101) Broken Bow' 'NB02200'='(NB02200) Dakota'
                  'NB02201'='(NB02201) South Sioux City' 'NB02202'='(NB02202) Dakota City'
                  'NB02203'='(NB02203) Emerson' 'NB02300'='(NB02300) Dawes' 'NB02301'='(NB02301) Chadron'
                  'NB02302'='(NB02302) Crawford' 'NB02400'='(NB02400) Dawson' 'NB02401'='(NB02401) Cozad'
                  'NB02402'='(NB02402) Gothenburg' 'NB02403'='(NB02403) Lexington'
                  'NB02500'='(NB02500) Deuel' 'NB02501'='(NB02501) Chappell' 'NB02600'='(NB02600) Dixon'
                  'NB02700'='(NB02700) Dodge' 'NB02701'='(NB02701) Fremont' 'NB02703'='(NB02703) Scribner'
                  'NB02800'='(NB02800) Douglas' 'NB02801'='(NB02801) Millard' 'NB02802'='(NB02802) Omaha'
                  'NB02803'='(NB02803) Elkhorn' 'NB02804'='(NB02804) Ralston' 'NB02805'='(NB02805) Valley'
                  'NB02806'='(NB02806) Boys Town' 'NB02807'='(NB02807) Bennington'
                  'NB02808'='(NB02808) Waterloo' 'NB02900'='(NB02900) Dundy'
                  'NB02901'='(NB02901) Benkelman' 'NB03000'='(NB03000) Fillmore'
                  'NB03001'='(NB03001) Geneva' 'NB03100'='(NB03100) Franklin'
                  'NB03200'='(NB03200) Frontier' 'NB03201'='(NB03201) Curtis' 'NB03300'='(NB03300) Furnas'
                  'NB03301'='(NB03301) Arapahoe' 'NB03302'='(NB03302) Cambridge'
                  'NB03303'='(NB03303) Oxford' 'NB03400'='(NB03400) Gage' 'NB03401'='(NB03401) Beatrice'
                  'NB03402'='(NB03402) Wymore' 'NB03500'='(NB03500) Garden' 'NB03501'='(NB03501) Oshkosh'
                  'NB03600'='(NB03600) Garfield' 'NB03601'='(NB03601) Burwell' 'NB03700'='(NB03700) Gosper'
                  'NB03800'='(NB03800) Grant' 'NB03900'='(NB03900) Greeley' 'NB04000'='(NB04000) Hall'
                  'NB04001'='(NB04001) Grand Island' 'NB04003'='(NB04003) Wood River'
                  'NB04100'='(NB04100) Hamilton' 'NB04101'='(NB04101) Aurora' 'NB04200'='(NB04200) Harlan'
                  'NB04201'='(NB04201) Alma' 'NB04300'='(NB04300) Hayes' 'NB04400'='(NB04400) Hitchcock'
                  'NB04500'='(NB04500) Holt' 'NB04501'='(NB04501) Oneill' 'NB04502'='(NB04502) Atkinson'
                  'NB04600'='(NB04600) Hooker' 'NB04700'='(NB04700) Howard' 'NB04701'='(NB04701) St. Paul'
                  'NB04800'='(NB04800) Jefferson' 'NB04801'='(NB04801) Fairbury'
                  'NB04900'='(NB04900) Johnson' 'NB04901'='(NB04901) Tecumseh'
                  'NB05000'='(NB05000) Kearney' 'NB05001'='(NB05001) Minden' 'NB05100'='(NB05100) Keith'
                  'NB05101'='(NB05101) Ogallala' 'NB05200'='(NB05200) Keya Paha'
                  'NB05300'='(NB05300) Kimball' 'NB05301'='(NB05301) Kimball' 'NB05400'='(NB05400) Knox'
                  'NB05401'='(NB05401) Creighton' 'NB05402'='(NB05402) Bloomfield'
                  'NB05403'='(NB05403) Wausa' 'NB05404'='(NB05404) Verdigre'
                  'NB05500'='(NB05500) Lancaster' 'NB05501'='(NB05501) Lincoln'
                  'NB05504'='(NB05504) Univ Of Nebraska:Lincoln'
                  'NB05505'='(NB05505) Univ Of Nebraska:Lincoln' 'NB05600'='(NB05600) Lincoln'
                  'NB05601'='(NB05601) North Platte' 'NB05700'='(NB05700) Logan' 'NB05800'='(NB05800) Loup'
                  'NB05900'='(NB05900) Mcpherson' 'NB06000'='(NB06000) Madison'
                  'NB06001'='(NB06001) Norfolk' 'NB06002'='(NB06002) Battle Creek'
                  'NB06003'='(NB06003) Madison' 'NB06004'='(NB06004) Tilden'
                  'NB06005'='(NB06005) Newman Grove' 'NB06100'='(NB06100) Merrick'
                  'NB06101'='(NB06101) Central City' 'NB06200'='(NB06200) Morrill'
                  'NB06201'='(NB06201) Bayard' 'NB06202'='(NB06202) Bridgeport' 'NB06300'='(NB06300) Nance'
                  'NB06301'='(NB06301) Fullerton' 'NB06302'='(NB06302) Genoa' 'NB06400'='(NB06400) Nemaha'
                  'NB06401'='(NB06401) Auburn' 'NB06500'='(NB06500) Nuckolls'
                  'NB06501'='(NB06501) Superior' 'NB06600'='(NB06600) Otoe'
                  'NB06601'='(NB06601) Nebraska City' 'NB06602'='(NB06602) Syracuse'
                  'NB06700'='(NB06700) Pawnee' 'NB06800'='(NB06800) Perkins' 'NB06801'='(NB06801) Grant'
                  'NB06900'='(NB06900) Phelps' 'NB06901'='(NB06901) Holdrege'
                  'NB06902'='(NB06902) Bertrand' 'NB07000'='(NB07000) Pierce' 'NB07001'='(NB07001) Pierce'
                  'NB07002'='(NB07002) Plainview' 'NB07003'='(NB07003) Osmond' 'NB07100'='(NB07100) Platte'
                  'NB07101'='(NB07101) Columbus' 'NB07102'='(NB07102) Humphrey' 'NB07200'='(NB07200) Polk'
                  'NB07202'='(NB07202) Osceola' 'NB07300'='(NB07300) Red Willow'
                  'NB07301'='(NB07301) Mccook' 'NB07400'='(NB07400) Richardson'
                  'NB07401'='(NB07401) Falls City' 'NB07402'='(NB07402) Humboldt'
                  'NB07500'='(NB07500) Rock' 'NB07501'='(NB07501) Bassett' 'NB07600'='(NB07600) Saline'
                  'NB07601'='(NB07601) Wilber' 'NB07602'='(NB07602) Crete' 'NB07603'='(NB07603) Friend'
                  'NB07700'='(NB07700) Sarpy' 'NB07701'='(NB07701) Bellevue'
                  'NB07702'='(NB07702) Papillion' 'NB07703'='(NB07703) Gretna'
                  'NB07704'='(NB07704) La Vista' 'NB07800'='(NB07800) Saunders' 'NB07801'='(NB07801) Wahoo'
                  'NB07802'='(NB07802) Ashland' 'NB07900'='(NB07900) Scotts Bluff'
                  'NB07901'='(NB07901) Scottsbluff' 'NB07902'='(NB07902) Gering'
                  'NB07903'='(NB07903) Mitchell' 'NB07904'='(NB07904) Lyman' 'NB07906'='(NB07906) Minatare'
                  'NB08000'='(NB08000) Seward' 'NB08001'='(NB08001) Seward' 'NB08002'='(NB08002) Milford'
                  'NB08100'='(NB08100) Sheridan' 'NB08101'='(NB08101) Gordon'
                  'NB08102'='(NB08102) Rushville' 'NB08200'='(NB08200) Sherman'
                  'NB08201'='(NB08201) Loup City' 'NB08300'='(NB08300) Sioux' 'NB08400'='(NB08400) Stanton'
                  'NB08401'='(NB08401) Stanton' 'NB08500'='(NB08500) Thayer' 'NB08600'='(NB08600) Thomas'
                  'NB08700'='(NB08700) Thurston' 'NB08702'='(NB08702) Omaha Tribal'
                  'NB08800'='(NB08800) Valley' 'NB08801'='(NB08801) Ord' 'NB08900'='(NB08900) Washington'
                  'NB08901'='(NB08901) Blair' 'NB09000'='(NB09000) Wayne' 'NB09001'='(NB09001) Wayne'
                  'NB09100'='(NB09100) Webster' 'NB09101'='(NB09101) Red Cloud'
                  'NB09200'='(NB09200) Wheeler' 'NB09300'='(NB09300) York' 'NB09301'='(NB09301) York'
                  'NBNSP00'='(NBNSP00) Nebraska State Patrol'
                  'NBNSP01'='(NBNSP01) St Ptrl: Adams County'
                  'NBNSP02'='(NBNSP02) St Ptrl: Antelope County'
                  'NBNSP03'='(NBNSP03) St Ptrl: Arthur County'
                  'NBNSP04'='(NBNSP04) St Ptrl: Banner County'
                  'NBNSP05'='(NBNSP05) St Ptrl: Blaine County'
                  'NBNSP06'='(NBNSP06) St Ptrl: Boone County'
                  'NBNSP07'='(NBNSP07) St Ptrl: Box Butte Cnty'
                  'NBNSP08'='(NBNSP08) St Ptrl: Boyd County'
                  'NBNSP09'='(NBNSP09) St Ptrl: Brown County'
                  'NBNSP10'='(NBNSP10) St Ptrl: Buffalo County'
                  'NBNSP11'='(NBNSP11) St Ptrl: Burt County'
                  'NBNSP12'='(NBNSP12) St Ptrl: Butler County'
                  'NBNSP13'='(NBNSP13) St Ptrl: Cass County'
                  'NBNSP14'='(NBNSP14) St Ptrl: Cedar County'
                  'NBNSP15'='(NBNSP15) St Ptrl: Chase County'
                  'NBNSP16'='(NBNSP16) St Ptrl: Cherry County'
                  'NBNSP17'='(NBNSP17) St Ptrl: Cheyenne County'
                  'NBNSP18'='(NBNSP18) St Ptrl: Clay County'
                  'NBNSP19'='(NBNSP19) St Ptrl: Colfax County'
                  'NBNSP20'='(NBNSP20) St Ptrl: Cuming County'
                  'NBNSP21'='(NBNSP21) St Ptrl: Custer County'
                  'NBNSP22'='(NBNSP22) St Ptrl: Dakota County'
                  'NBNSP23'='(NBNSP23) St Ptrl: Dawes County'
                  'NBNSP24'='(NBNSP24) St Ptrl: Dawson County'
                  'NBNSP25'='(NBNSP25) St Ptrl: Deuel County'
                  'NBNSP26'='(NBNSP26) St Ptrl: Dixon County'
                  'NBNSP27'='(NBNSP27) St Ptrl: Dodge County'
                  'NBNSP28'='(NBNSP28) St Ptrl: Douglas County'
                  'NBNSP29'='(NBNSP29) St Ptrl: Dundy County'
                  'NBNSP30'='(NBNSP30) St Ptrl: Fillmore County'
                  'NBNSP31'='(NBNSP31) St Ptrl: Franklin County'
                  'NBNSP32'='(NBNSP32) St Ptrl: Frontier County'
                  'NBNSP33'='(NBNSP33) St Ptrl: Furnas County'
                  'NBNSP34'='(NBNSP34) St Ptrl: Gage County'
                  'NBNSP35'='(NBNSP35) St Ptrl: Garden County'
                  'NBNSP36'='(NBNSP36) St Ptrl: Garfield County'
                  'NBNSP37'='(NBNSP37) St Ptrl: Gosper County'
                  'NBNSP38'='(NBNSP38) St Ptrl: Grant County'
                  'NBNSP39'='(NBNSP39) St Ptrl: Greeley County'
                  'NBNSP40'='(NBNSP40) St Ptrl: Hall County'
                  'NBNSP41'='(NBNSP41) St Ptrl: Hamilton County'
                  'NBNSP42'='(NBNSP42) St Ptrl: Harlan County'
                  'NBNSP43'='(NBNSP43) St Ptrl: Hayes County'
                  'NBNSP44'='(NBNSP44) St Ptrl: Hitchcock Cnty'
                  'NBNSP45'='(NBNSP45) St Ptrl: Holt County'
                  'NBNSP46'='(NBNSP46) St Ptrl: Hooker County'
                  'NBNSP47'='(NBNSP47) St Ptrl: Howard County'
                  'NBNSP48'='(NBNSP48) St Ptrl: Jefferson Cnty'
                  'NBNSP49'='(NBNSP49) St Ptrl: Johnson County'
                  'NBNSP50'='(NBNSP50) St Ptrl: Kearney County'
                  'NBNSP51'='(NBNSP51) St Ptrl: Keith County'
                  'NBNSP52'='(NBNSP52) St Ptrl: Keya Paha Cnty'
                  'NBNSP53'='(NBNSP53) St Ptrl: Kimball County'
                  'NBNSP54'='(NBNSP54) St Ptrl: Knox County'
                  'NBNSP55'='(NBNSP55) St Ptrl: Lancaster Cnty'
                  'NBNSP56'='(NBNSP56) St Ptrl: Lincoln County'
                  'NBNSP57'='(NBNSP57) St Ptrl: Logan County'
                  'NBNSP58'='(NBNSP58) St Ptrl: Loup County'
                  'NBNSP59'='(NBNSP59) St Ptrl: Mcpherson Cnty'
                  'NBNSP60'='(NBNSP60) St Ptrl: Madison County'
                  'NBNSP61'='(NBNSP61) St Ptrl: Merrick County'
                  'NBNSP62'='(NBNSP62) St Ptrl: Morrill County'
                  'NBNSP63'='(NBNSP63) St Ptrl: Nance County'
                  'NBNSP64'='(NBNSP64) St Ptrl: Nemaha County'
                  'NBNSP65'='(NBNSP65) St Ptrl: Nuckolls County'
                  'NBNSP66'='(NBNSP66) St Ptrl: Otoe County'
                  'NBNSP67'='(NBNSP67) St Ptrl: Pawnee County'
                  'NBNSP68'='(NBNSP68) St Ptrl: Perkins County'
                  'NBNSP69'='(NBNSP69) St Ptrl: Phelps County'
                  'NBNSP70'='(NBNSP70) St Ptrl: Pierce County'
                  'NBNSP71'='(NBNSP71) St Ptrl: Platte County'
                  'NBNSP72'='(NBNSP72) St Ptrl: Polk County'
                  'NBNSP73'='(NBNSP73) St Ptrl: Red Willow Cnty'
                  'NBNSP74'='(NBNSP74) St Ptrl: Richardson Cnty'
                  'NBNSP75'='(NBNSP75) St Ptrl: Rock County'
                  'NBNSP76'='(NBNSP76) St Ptrl: Saline County'
                  'NBNSP77'='(NBNSP77) St Ptrl: Sarpy County'
                  'NBNSP78'='(NBNSP78) St Ptrl: Saunders County'
                  'NBNSP79'='(NBNSP79) St Ptrl:Scotts Bluff Cty'
                  'NBNSP80'='(NBNSP80) St Ptrl: Seward County'
                  'NBNSP81'='(NBNSP81) St Ptrl: Sheridan County'
                  'NBNSP82'='(NBNSP82) St Ptrl: Sherman County'
                  'NBNSP83'='(NBNSP83) St Ptrl: Sioux County'
                  'NBNSP84'='(NBNSP84) St Ptrl: Stanton County'
                  'NBNSP85'='(NBNSP85) St Ptrl: Thayer County'
                  'NBNSP86'='(NBNSP86) St Ptrl: Thomas County'
                  'NBNSP87'='(NBNSP87) St Ptrl: Thurston County'
                  'NBNSP88'='(NBNSP88) St Ptrl: Valley County'
                  'NBNSP89'='(NBNSP89) St Ptrl: Washington Cnty'
                  'NBNSP90'='(NBNSP90) St Ptrl: Wayne County'
                  'NBNSP91'='(NBNSP91) St Ptrl: Webster County'
                  'NBNSP92'='(NBNSP92) St Ptrl: Wheeler County'
                  'NBNSP93'='(NBNSP93) St Ptrl: York County' 'NC00100'='(NC00100) Alamance'
                  'NC00101'='(NC00101) Burlington' 'NC00102'='(NC00102) Elon' 'NC00103'='(NC00103) Graham'
                  'NC00104'='(NC00104) Mebane' 'NC00105'='(NC00105) Haw River'
                  'NC00106'='(NC00106) Elon University' 'NC001BI'='(NC001BI) Alamance Bi'
                  'NC001SP'='(NC001SP) Alamance State Police' 'NC00200'='(NC00200) Alexander'
                  'NC00201'='(NC00201) Taylorsville' 'NC002BI'='(NC002BI) Alexander Bi'
                  'NC002SP'='(NC002SP) Alexander State Police' 'NC00300'='(NC00300) Alleghany'
                  'NC00301'='(NC00301) Sparta' 'NC00302'='(NC00302) Spr: Stone Mountain'
                  'NC003BI'='(NC003BI) Alleghany Bi' 'NC003SP'='(NC003SP) Alleghany State Police'
                  'NC00400'='(NC00400) Anson' 'NC00401'='(NC00401) Wadesboro'
                  'NC00402'='(NC00402) Lilesville' 'NC00403'='(NC00403) Morven'
                  'NC00404'='(NC00404) Polkton' 'NC00405'='(NC00405) Ansonville'
                  'NC004BI'='(NC004BI) Anson Bi' 'NC004SP'='(NC004SP) Anson State Police'
                  'NC00500'='(NC00500) Ashe' 'NC00501'='(NC00501) West Jefferson'
                  'NC00502'='(NC00502) Jefferson' 'NC00503'='(NC00503) Spr: New River-Mt Jeffer'
                  'NC005BI'='(NC005BI) Ashe Bi' 'NC005SP'='(NC005SP) Ashe State Police'
                  'NC00600'='(NC00600) Avery' 'NC00601'='(NC00601) Newland'
                  'NC00602'='(NC00602) Banner Elk' 'NC00603'='(NC00603) Crossnore'
                  'NC00604'='(NC00604) Elk Park' 'NC00605'='(NC00605) Beech Mountain'
                  'NC00606'='(NC00606) Sugar Mountain' 'NC006BI'='(NC006BI) Avery Bi'
                  'NC006SP'='(NC006SP) Avery State Police' 'NC00700'='(NC00700) Beaufort'
                  'NC00701'='(NC00701) Washington' 'NC00702'='(NC00702) Aurora'
                  'NC00703'='(NC00703) Belhaven' 'NC00704'='(NC00704) Chocowinity'
                  'NC00705'='(NC00705) Spr: Goose Creek'
                  'NC00706'='(NC00706) Beaufort Co Comm College'
                  'NC007BI'='(NC007BI) Beaufort Bi' 'NC007SP'='(NC007SP) Beaufort State Police'
                  'NC00800'='(NC00800) Bertie' 'NC00801'='(NC00801) Aulander' 'NC00802'='(NC00802) Windsor'
                  'NC00803'='(NC00803) Lewiston' 'NC00806'='(NC00806) Colerain'
                  'NC008BI'='(NC008BI) Bertie Bi' 'NC008SP'='(NC008SP) Bertie State Police'
                  'NC00900'='(NC00900) Bladen' 'NC00901'='(NC00901) Bladenboro'
                  'NC00902'='(NC00902) Clarkton' 'NC00903'='(NC00903) Elizabethtown'
                  'NC00904'='(NC00904) White Lake' 'NC00905'='(NC00905) Dublin'
                  'NC00907'='(NC00907) Spr: Jones Lake'
                  'NC00908'='(NC00908) Spr: Singletary Lake G c' 'NC009BI'='(NC009BI) Bladen Bi'
                  'NC009SP'='(NC009SP) Bladen State Police' 'NC01000'='(NC01000) Brunswick'
                  'NC01001'='(NC01001) Oak Island' 'NC01002'='(NC01002) Shallotte'
                  'NC01003'='(NC01003) Southport' 'NC01004'='(NC01004) Holden Beach'
                  'NC01005'='(NC01005) Boiling Spring Lakes' 'NC01006'='(NC01006) Yaupon Beach'
                  'NC01007'='(NC01007) Sunset Beach' 'NC01008'='(NC01008) Ocean Isle Beach'
                  'NC01010'='(NC01010) Caswell Beach' 'NC01011'='(NC01011) Bald Head Island'
                  'NC01013'='(NC01013) Leland' 'NC01014'='(NC01014) Navassa'
                  'NC01016'='(NC01016) Northwest' 'NC010BI'='(NC010BI) Brunswick Bi'
                  'NC010SP'='(NC010SP) Brunswick State Police' 'NC01100'='(NC01100) Buncombe'
                  'NC01101'='(NC01101) Asheville' 'NC01102'='(NC01102) Black Mountain'
                  'NC01103'='(NC01103) Biltmore Forest' 'NC01104'='(NC01104) Weaverville'
                  'NC01105'='(NC01105) Montreat' 'NC01106'='(NC01106) Woodfin'
                  'NC01107'='(NC01107) Univ Of Nc: Asheville'
                  'NC01108'='(NC01108) Asheville Regional Airpo'
                  'NC01109'='(NC01109) Dept. Of Human Resources'
                  'NC01113'='(NC01113) North Carolina Arboretum'
                  'NC011BI'='(NC011BI) Buncombe Bi' 'NC011SP'='(NC011SP) Buncombe State Police'
                  'NC01200'='(NC01200) Burke' 'NC01201'='(NC01201) Morganton' 'NC01202'='(NC01202) Valdese'
                  'NC01203'='(NC01203) Drexel' 'NC01204'='(NC01204) Glen Alpine'
                  'NC01207'='(NC01207) Spr: South Mountains' 'NC012BI'='(NC012BI) Burke Bi'
                  'NC012SP'='(NC012SP) Burke State Police' 'NC01300'='(NC01300) Cabarrus'
                  'NC01301'='(NC01301) Concord' 'NC01302'='(NC01302) Kannapolis'
                  'NC013BI'='(NC013BI) Cabarrus Bi' 'NC013SP'='(NC013SP) Cabarrus State Police'
                  'NC01400'='(NC01400) Caldwell' 'NC01401'='(NC01401) Granite Falls'
                  'NC01402'='(NC01402) Lenoir' 'NC01403'='(NC01403) Rhodhiss' 'NC01404'='(NC01404) Hudson'
                  'NC014BI'='(NC014BI) Caldwell Bi' 'NC014SP'='(NC014SP) Caldwell State Police'
                  'NC01500'='(NC01500) Camden' 'NC01510'='(NC01510) Spr: Dismal Swamp'
                  'NC015BI'='(NC015BI) Camden Bi' 'NC015SP'='(NC015SP) Camden State Police'
                  'NC01600'='(NC01600) Carteret' 'NC01601'='(NC01601) Beaufort'
                  'NC01602'='(NC01602) Morehead City' 'NC01603'='(NC01603) Atlantic Beach'
                  'NC01604'='(NC01604) Newport' 'NC01605'='(NC01605) Cape Carteret'
                  'NC01606'='(NC01606) Emerald Isle' 'NC01607'='(NC01607) Pine Knoll Shores'
                  'NC01609'='(NC01609) Indian Beach' 'NC01611'='(NC01611) Spr: Fort Macon'
                  'NC016BI'='(NC016BI) Carteret Bi' 'NC016SP'='(NC016SP) Carteret State Police'
                  'NC01700'='(NC01700) Caswell' 'NC01703'='(NC01703) Yanceyville'
                  'NC017BI'='(NC017BI) Caswell Bi' 'NC017SP'='(NC017SP) Caswell State Police'
                  'NC01800'='(NC01800) Catawba' 'NC01801'='(NC01801) Conover' 'NC01802'='(NC01802) Hickory'
                  'NC01803'='(NC01803) Maiden' 'NC01804'='(NC01804) Newton' 'NC01805'='(NC01805) Brookford'
                  'NC01806'='(NC01806) Claremont' 'NC01807'='(NC01807) Longview'
                  'NC01808'='(NC01808) Catawba' 'NC018BI'='(NC018BI) Catawba Bi'
                  'NC018SP'='(NC018SP) Catawba State Police' 'NC01900'='(NC01900) Chatham'
                  'NC01901'='(NC01901) Siler City' 'NC01902'='(NC01902) Pittsboro'
                  'NC019BI'='(NC019BI) Chatham Bi' 'NC019SP'='(NC019SP) Chatham State Police'
                  'NC02000'='(NC02000) Cherokee' 'NC02001'='(NC02001) Andrews' 'NC02002'='(NC02002) Murphy'
                  'NC020BI'='(NC020BI) Cherokee Bi' 'NC020SP'='(NC020SP) Cherokee State Police'
                  'NC02100'='(NC02100) Chowan' 'NC02101'='(NC02101) Edenton'
                  'NC021BI'='(NC021BI) Chowan Bi' 'NC021SP'='(NC021SP) Chowan State Police'
                  'NC02200'='(NC02200) Clay' 'NC022BI'='(NC022BI) Clay Bi'
                  'NC022SP'='(NC022SP) Clay State Police' 'NC02300'='(NC02300) Cleveland'
                  'NC02301'='(NC02301) Kings Mountain' 'NC02302'='(NC02302) Shelby'
                  'NC02303'='(NC02303) Boiling Springs' 'NC02304'='(NC02304) Lawndale'
                  'NC02306'='(NC02306) Grover' 'NC02307'='(NC02307) Polkville'
                  'NC02308'='(NC02308) Spr: Crowders Mountain' 'NC02309'='(NC02309) Kingstown'
                  'NC02355'='(NC02355) Shelby Abc Enf Office' 'NC023BI'='(NC023BI) Cleveland Bi'
                  'NC023SP'='(NC023SP) Cleveland State Police' 'NC02400'='(NC02400) Columbus'
                  'NC02402'='(NC02402) Chadbourn' 'NC02403'='(NC02403) Fair Bluff'
                  'NC02404'='(NC02404) Tabor City' 'NC02405'='(NC02405) Whiteville'
                  'NC02406'='(NC02406) Lake Waccamaw' 'NC02407'='(NC02407) Bolton'
                  'NC02408'='(NC02408) Columbus County Rural Pd' 'NC02409'='(NC02409) Brunswick'
                  'NC02412'='(NC02412) Spr: Lake Waccamaw' 'NC024BI'='(NC024BI) Columbus Bi'
                  'NC024SP'='(NC024SP) Columbus State Police' 'NC02500'='(NC02500) Craven'
                  'NC02501'='(NC02501) Havelock' 'NC02502'='(NC02502) New Bern'
                  'NC02503'='(NC02503) Vanceboro' 'NC02504'='(NC02504) Trent Woods'
                  'NC02505'='(NC02505) Dover' 'NC02506'='(NC02506) Bridgeton'
                  'NC02507'='(NC02507) River Bend' 'NC025BI'='(NC025BI) Craven Bi'
                  'NC025SP'='(NC025SP) Craven State Police' 'NC02600'='(NC02600) Cumberland'
                  'NC02601'='(NC02601) Fayetteville' 'NC02602'='(NC02602) Hope Mills'
                  'NC02603'='(NC02603) Spring Lake' 'NC02604'='(NC02604) Fayetteville State Univ'
                  'NC02608'='(NC02608) Methodist College' 'NC026BI'='(NC026BI) Cumberland Bi'
                  'NC026SP'='(NC026SP) Cumberland State Police' 'NC02700'='(NC02700) Currituck'
                  'NC027BI'='(NC027BI) Currituck Bi' 'NC027SP'='(NC027SP) Currituck State Police'
                  'NC02800'='(NC02800) Dare' 'NC02801'='(NC02801) Kill Devil Hills'
                  'NC02802'='(NC02802) Manteo' 'NC02803'='(NC02803) Nags Head'
                  'NC02804'='(NC02804) Southern Shores' 'NC02805'='(NC02805) Kitty Hawk'
                  'NC02806'='(NC02806) Spr: Jockeys Ridge' 'NC028BI'='(NC028BI) Dare Bi'
                  'NC028SP'='(NC028SP) Dare State Police' 'NC02900'='(NC02900) Davidson'
                  'NC02901'='(NC02901) Lexington' 'NC02902'='(NC02902) Thomasville'
                  'NC02903'='(NC02903) Denton' 'NC029BI'='(NC029BI) Davidson Bi'
                  'NC029SP'='(NC029SP) Davidson State Police' 'NC03000'='(NC03000) Davie'
                  'NC03001'='(NC03001) Mocksville' 'NC03002'='(NC03002) Cooleemee'
                  'NC030BI'='(NC030BI) Davie Bi' 'NC030SP'='(NC030SP) Davie State Police'
                  'NC03100'='(NC03100) Duplin' 'NC03101'='(NC03101) Wallace'
                  'NC03102'='(NC03102) Beulaville' 'NC03103'='(NC03103) Faison'
                  'NC03104'='(NC03104) Kenansville' 'NC03105'='(NC03105) Rose Hill'
                  'NC03106'='(NC03106) Warsaw' 'NC03107'='(NC03107) Magnolia' 'NC03108'='(NC03108) Calypso'
                  'NC031BI'='(NC031BI) Duplin Bi' 'NC031SP'='(NC031SP) Duplin State Police'
                  'NC03200'='(NC03200) Durham' 'NC03201'='(NC03201) Durham'
                  'NC03202'='(NC03202) Nc Central University'
                  'NC03203'='(NC03203) Duke University' 'NC03204'='(NC03204) Spr: Eno River'
                  'NC03250'='(NC03250) Durham Co Abc Enf Off' 'NC032BI'='(NC032BI) Durham Bi'
                  'NC032SP'='(NC032SP) Durham State Police' 'NC03300'='(NC03300) Edgecombe'
                  'NC03301'='(NC03301) Rocky Mount' 'NC03302'='(NC03302) Tarboro'
                  'NC03303'='(NC03303) Macclesfield' 'NC03304'='(NC03304) Pinetops'
                  'NC03305'='(NC03305) Princeville'
                  'NC03350'='(NC03350) Edgecombe Co Abc Enf Off'
                  'NC033BI'='(NC033BI) Edgecombe Bi' 'NC033SP'='(NC033SP) Edgecombe State Police'
                  'NC03400'='(NC03400) Forsyth' 'NC03401'='(NC03401) Kernersville'
                  'NC03402'='(NC03402) Winston-Salem'
                  'NC03403'='(NC03403) Winston-Salem State Univ'
                  'NC03404'='(NC03404) Wake Forest University'
                  'NC03406'='(NC03406) Nc School Of The Arts'
                  'NC03455'='(NC03455) Triad Abc Law Enforcemen' 'NC034BI'='(NC034BI) Forsyth Bi'
                  'NC034SP'='(NC034SP) Forsyth State Police' 'NC03500'='(NC03500) Franklin'
                  'NC03501'='(NC03501) Louisburg' 'NC03502'='(NC03502) Franklinton'
                  'NC03503'='(NC03503) Youngsville' 'NC03504'='(NC03504) Bunn'
                  'NC03505'='(NC03505) Centerville' 'NC03506'='(NC03506) Lake Royale'
                  'NC035BI'='(NC035BI) Franklin Bi' 'NC035SP'='(NC035SP) Franklin State Police'
                  'NC03600'='(NC03600) Gaston' 'NC03601'='(NC03601) Belmont'
                  'NC03602'='(NC03602) Bessemer City' 'NC03603'='(NC03603) Cherryville'
                  'NC03604'='(NC03604) Dallas' 'NC03605'='(NC03605) Gaston County Police Dep'
                  'NC03606'='(NC03606) Gastonia' 'NC03607'='(NC03607) Stanley' 'NC03608'='(NC03608) Lowell'
                  'NC03609'='(NC03609) Mount Holly' 'NC03610'='(NC03610) Mcadenville'
                  'NC03611'='(NC03611) Cramerton' 'NC03612'='(NC03612) Ranlo'
                  'NC03613'='(NC03613) High Shoals' 'NC03614'='(NC03614) Belmont Abbey College'
                  'NC03655'='(NC03655) Gastonia Abc Enf Office' 'NC036BI'='(NC036BI) Gaston Bi'
                  'NC036SP'='(NC036SP) Gaston State Police' 'NC03700'='(NC03700) Gates'
                  'NC03701'='(NC03701) Gatesville' 'NC03702'='(NC03702) Spr: Merchants Millpond'
                  'NC037BI'='(NC037BI) Gates Bi' 'NC037SP'='(NC037SP) Gates State Police'
                  'NC03800'='(NC03800) Graham' 'NC03801'='(NC03801) Robbinsville'
                  'NC038BI'='(NC038BI) Graham Bi' 'NC038SP'='(NC038SP) Graham State Police'
                  'NC03900'='(NC03900) Granville' 'NC03901'='(NC03901) Oxford' 'NC03902'='(NC03902) Butner'
                  'NC03903'='(NC03903) Creedmoor' 'NC03950'='(NC03950) Granville Co Abc Enf Off'
                  'NC039BI'='(NC039BI) Granville Bi' 'NC039SP'='(NC039SP) Granville State Police'
                  'NC04000'='(NC04000) Greene' 'NC04001'='(NC04001) Hookerton'
                  'NC04002'='(NC04002) Snow Hill' 'NC040BI'='(NC040BI) Greene Bi'
                  'NC040SP'='(NC040SP) Greene State Police' 'NC04100'='(NC04100) Guilford'
                  'NC04101'='(NC04101) Gibsonville' 'NC04102'='(NC04102) Greensboro'
                  'NC04103'='(NC04103) High Point' 'NC04104'='(NC04104) North Carolina A&t St Un'
                  'NC04105'='(NC04105) Univ Of Nc: Greensboro'
                  'NC04106'='(NC04106) Piedmont Triad Intnl Air'
                  'NC04157'='(NC04157) High Point Abc Enf Off' 'NC041BI'='(NC041BI) Guilford Bi'
                  'NC041SP'='(NC041SP) Guilford State Police' 'NC04200'='(NC04200) Halifax'
                  'NC04201'='(NC04201) Enfield' 'NC04202'='(NC04202) Roanoke Rapids'
                  'NC04203'='(NC04203) Scotland Neck' 'NC04204'='(NC04204) Halifax'
                  'NC04205'='(NC04205) Hobgood' 'NC04206'='(NC04206) Littleton'
                  'NC04207'='(NC04207) Weldon' 'NC04208'='(NC04208) Spr: Medoc Mountain'
                  'NC042BI'='(NC042BI) Halifax Bi' 'NC042SP'='(NC042SP) Halifax State Police'
                  'NC04300'='(NC04300) Harnett' 'NC04301'='(NC04301) Dunn' 'NC04302'='(NC04302) Angier'
                  'NC04303'='(NC04303) Coats' 'NC04304'='(NC04304) Lillington' 'NC04305'='(NC04305) Erwin'
                  'NC04306'='(NC04306) Spr: Raven Rock' 'NC04307'='(NC04307) Campbell University'
                  'NC043BI'='(NC043BI) Harnett Bi' 'NC043SP'='(NC043SP) Harnett State Police'
                  'NC04400'='(NC04400) Haywood' 'NC04401'='(NC04401) Canton'
                  'NC04402'='(NC04402) Waynesville' 'NC04403'='(NC04403) Clyde'
                  'NC04404'='(NC04404) Hazelwood' 'NC04405'='(NC04405) Maggie Valley'
                  'NC044BI'='(NC044BI) Haywood Bi' 'NC044SP'='(NC044SP) Haywood State Police'
                  'NC04500'='(NC04500) Henderson' 'NC04501'='(NC04501) Hendersonville'
                  'NC04502'='(NC04502) Laurel Park' 'NC04503'='(NC04503) Fletcher'
                  'NC045BI'='(NC045BI) Henderson Bi' 'NC045SP'='(NC045SP) Henderson State Police'
                  'NC04600'='(NC04600) Hertford' 'NC04601'='(NC04601) Ahoskie'
                  'NC04602'='(NC04602) Murfreesboro' 'NC04603'='(NC04603) Winton'
                  'NC046BI'='(NC046BI) Hertford Bi' 'NC046SP'='(NC046SP) Hertford State Police'
                  'NC04700'='(NC04700) Hoke' 'NC04701'='(NC04701) Raeford' 'NC047BI'='(NC047BI) Hoke Bi'
                  'NC047SP'='(NC047SP) Hoke State Police' 'NC04800'='(NC04800) Hyde'
                  'NC048BI'='(NC048BI) Hyde Bi' 'NC048SP'='(NC048SP) Hyde State Police'
                  'NC04900'='(NC04900) Iredell' 'NC04901'='(NC04901) Mooresville'
                  'NC04902'='(NC04902) Statesville' 'NC04903'='(NC04903) Harmony'
                  'NC04904'='(NC04904) Troutman' 'NC04905'='(NC04905) Love Valley'
                  'NC04907'='(NC04907) Spr: Lake Norman' 'NC049BI'='(NC049BI) Iredell Bi'
                  'NC049SP'='(NC049SP) Iredell State Police' 'NC05000'='(NC05000) Jackson'
                  'NC05001'='(NC05001) Sylva' 'NC05002'='(NC05002) Western Carolina Univ'
                  'NC050BI'='(NC050BI) Jackson Bi' 'NC050SP'='(NC050SP) Jackson State Police'
                  'NC05100'='(NC05100) Johnston' 'NC05101'='(NC05101) Smithfield'
                  'NC05102'='(NC05102) Benson' 'NC05103'='(NC05103) Clayton'
                  'NC05104'='(NC05104) Four Oaks' 'NC05105'='(NC05105) Kenly'
                  'NC05106'='(NC05106) Pine Level' 'NC05107'='(NC05107) Princeton'
                  'NC05108'='(NC05108) Selma' 'NC05109'='(NC05109) Micro' 'NC051BI'='(NC051BI) Johnston Bi'
                  'NC051SP'='(NC051SP) Johnston State Police' 'NC05200'='(NC05200) Jones'
                  'NC05202'='(NC05202) Maysville' 'NC052BI'='(NC052BI) Jones Bi'
                  'NC052SP'='(NC052SP) Jones State Police' 'NC05300'='(NC05300) Lee'
                  'NC05301'='(NC05301) Sanford' 'NC05302'='(NC05302) Broadway' 'NC053BI'='(NC053BI) Lee Bi'
                  'NC053SP'='(NC053SP) Lee State Police' 'NC05400'='(NC05400) Lenoir'
                  'NC05401'='(NC05401) Kinston' 'NC05402'='(NC05402) La Grange'
                  'NC05403'='(NC05403) Pink Hill' 'NC05404'='(NC05404) Caswell Center Hospital'
                  'NC054BI'='(NC054BI) Lenoir Bi' 'NC054SP'='(NC054SP) Lenoir State Police'
                  'NC05500'='(NC05500) Lincoln' 'NC05501'='(NC05501) Lincolnton'
                  'NC05555'='(NC05555) Lincolnton Abc Enfor Of' 'NC055BI'='(NC055BI) Lincoln Bi'
                  'NC055SP'='(NC055SP) Lincoln State Police' 'NC05600'='(NC05600) Mcdowell'
                  'NC05601'='(NC05601) Marion' 'NC05602'='(NC05602) Old Fort'
                  'NC05603'='(NC05603) Spr: Lake James' 'NC056BI'='(NC056BI) Mcdowell Bi'
                  'NC056SP'='(NC056SP) Mcdowell State Police' 'NC05700'='(NC05700) Macon'
                  'NC05701'='(NC05701) Franklin' 'NC05702'='(NC05702) Highlands'
                  'NC057BI'='(NC057BI) Macon Bi' 'NC057SP'='(NC057SP) Macon State Police'
                  'NC05800'='(NC05800) Madison' 'NC05801'='(NC05801) Marshall'
                  'NC05802'='(NC05802) Hot Springs' 'NC05803'='(NC05803) Mars Hill'
                  'NC05804'='(NC05804) Mars Hill College' 'NC058BI'='(NC058BI) Madison Bi'
                  'NC058SP'='(NC058SP) Madison State Police' 'NC05900'='(NC05900) Martin'
                  'NC05901'='(NC05901) Williamston' 'NC05903'='(NC05903) Hassell'
                  'NC05904'='(NC05904) Jamesville' 'NC05905'='(NC05905) Oak City'
                  'NC05906'='(NC05906) Robersonville' 'NC05907'='(NC05907) Everetts'
                  'NC059BI'='(NC059BI) Martin Bi' 'NC059SP'='(NC059SP) Martin State Police'
                  'NC06000'='(NC06000) Mecklenburg' 'NC06001'='(NC06001) Charlotte-Mecklenburg'
                  'NC06002'='(NC06002) Mecklenburg' 'NC06003'='(NC06003) Pineville'
                  'NC06004'='(NC06004) Cornelius' 'NC06005'='(NC06005) Davidson'
                  'NC06006'='(NC06006) Huntersville' 'NC06007'='(NC06007) Matthews'
                  'NC06008'='(NC06008) Univ Of Nc: Charlotte'
                  'NC06013'='(NC06013) Davidson College' 'NC06014'='(NC06014) Queens University'
                  'NC06018'='(NC06018) Davidson College' 'NC06029'='(NC06029) Mint Hill'
                  'NC060BI'='(NC060BI) Mecklenburg Bi'
                  'NC060SP'='(NC060SP) Mecklenburg State Police' 'NC06100'='(NC06100) Mitchell'
                  'NC06101'='(NC06101) Spruce Pine' 'NC06102'='(NC06102) Bakersville'
                  'NC061BI'='(NC061BI) Mitchell Bi' 'NC061SP'='(NC061SP) Mitchell State Police'
                  'NC06200'='(NC06200) Montgomery' 'NC06201'='(NC06201) Troy' 'NC06202'='(NC06202) Biscoe'
                  'NC06203'='(NC06203) Candor' 'NC06204'='(NC06204) Mount Gilead'
                  'NC06205'='(NC06205) Star' 'NC062BI'='(NC062BI) Montgomery Bi'
                  'NC062SP'='(NC062SP) Montgomery State Police' 'NC06300'='(NC06300) Moore'
                  'NC06301'='(NC06301) Aberdeen' 'NC06302'='(NC06302) Pinehurst'
                  'NC06303'='(NC06303) Robbins' 'NC06304'='(NC06304) Southern Pines'
                  'NC06305'='(NC06305) Carthage' 'NC06306'='(NC06306) Pinebluff' 'NC06307'='(NC06307) Vass'
                  'NC06308'='(NC06308) Whispering Pines' 'NC06309'='(NC06309) Foxfire Village'
                  'NC06310'='(NC06310) Spr: Weymouth Woods Sand' 'NC06311'='(NC06311) Taylortown'
                  'NC06312'='(NC06312) Cameron' 'NC0631C'='(NC0631C) Weymouth Woods Nat Res'
                  'NC06350'='(NC06350) Moore Co Abc Enf Office' 'NC063BI'='(NC063BI) Moore Bi'
                  'NC063SP'='(NC063SP) Moore State Police' 'NC06400'='(NC06400) Nash'
                  'NC06401'='(NC06401) Nashville' 'NC06402'='(NC06402) Spring Hope'
                  'NC06403'='(NC06403) Bailey' 'NC06404'='(NC06404) Battleboro'
                  'NC06405'='(NC06405) Middlesex' 'NC06406'='(NC06406) Sharpsburg'
                  'NC06407'='(NC06407) Whitakers' 'NC06450'='(NC06450) Nash Co. Abc Enforcement'
                  'NC064BI'='(NC064BI) Nash Bi' 'NC064SP'='(NC064SP) Nash State Police'
                  'NC06500'='(NC06500) New Hanover' 'NC06501'='(NC06501) Carolina Beach'
                  'NC06502'='(NC06502) Wilmington' 'NC06503'='(NC06503) Wrightsville Beach'
                  'NC06504'='(NC06504) Kure Beach' 'NC06505'='(NC06505) Univ Of Nc: Wilmington'
                  'NC06507'='(NC06507) Wilmington Intl Airport'
                  'NC06508'='(NC06508) Spr: Carolina Beach'
                  'NC06510'='(NC06510) Spr: Fort Fisher'
                  'NC06550'='(NC06550) New Hanover Co Abc Enf'
                  'NC065BI'='(NC065BI) New Hanover Bi'
                  'NC065SP'='(NC065SP) New Hanover State Police'
                  'NC06600'='(NC06600) Northampton' 'NC06601'='(NC06601) Rich Square'
                  'NC06602'='(NC06602) Conway' 'NC06603'='(NC06603) Gaston' 'NC06604'='(NC06604) Jackson'
                  'NC06605'='(NC06605) Seaboard' 'NC06606'='(NC06606) Woodland'
                  'NC06608'='(NC06608) Garysburg' 'NC066BI'='(NC066BI) Northampton Bi'
                  'NC066SP'='(NC066SP) Northampton State Police' 'NC06700'='(NC06700) Onslow'
                  'NC06701'='(NC06701) Jacksonville' 'NC06702'='(NC06702) Holly Ridge'
                  'NC06703'='(NC06703) Richlands' 'NC06704'='(NC06704) Swansboro'
                  'NC06707'='(NC06707) Spr: Hammocks Beach'
                  'NC06708'='(NC06708) North Topsail Beach' 'NC067BI'='(NC067BI) Onslow Bi'
                  'NC067SP'='(NC067SP) Onslow State Police' 'NC06800'='(NC06800) Orange'
                  'NC06801'='(NC06801) Chapel Hill' 'NC06802'='(NC06802) Hillsborough'
                  'NC06803'='(NC06803) Carrboro' 'NC06804'='(NC06804) Univ Of Nc: Chapel Hill'
                  'NC06805'='(NC06805) Nc Memorial Hospital' 'NC068BI'='(NC068BI) Orange Bi'
                  'NC068SP'='(NC068SP) Orange State Police' 'NC06900'='(NC06900) Pamlico'
                  'NC06902'='(NC06902) Oriental' 'NC069BI'='(NC069BI) Pamlico Bi'
                  'NC069SP'='(NC069SP) Pamlico State Police' 'NC07000'='(NC07000) Pasquotank'
                  'NC07001'='(NC07001) Elizabeth City'
                  'NC07002'='(NC07002) Elizabeth City State Un'
                  'NC070BI'='(NC070BI) Pasquotank Bi'
                  'NC070SP'='(NC070SP) Pasquotank State Police' 'NC07100'='(NC07100) Pender'
                  'NC07101'='(NC07101) Burgaw' 'NC07102'='(NC07102) Topsail Beach'
                  'NC07103'='(NC07103) Surf City' 'NC071BI'='(NC071BI) Pender Bi'
                  'NC071SP'='(NC071SP) Pender State Police' 'NC07200'='(NC07200) Perquimans'
                  'NC07201'='(NC07201) Hertford' 'NC07202'='(NC07202) Winfall'
                  'NC072BI'='(NC072BI) Perquimans Bi'
                  'NC072SP'='(NC072SP) Perquimans State Police' 'NC07300'='(NC07300) Person'
                  'NC07301'='(NC07301) Roxboro' 'NC073BI'='(NC073BI) Person Bi'
                  'NC073SP'='(NC073SP) Person State Police' 'NC07400'='(NC07400) Pitt'
                  'NC07401'='(NC07401) Ayden' 'NC07402'='(NC07402) Farmville'
                  'NC07403'='(NC07403) Greenville' 'NC07404'='(NC07404) Bethel'
                  'NC07405'='(NC07405) Fountain' 'NC07406'='(NC07406) Grifton'
                  'NC07407'='(NC07407) Grimesland' 'NC07408'='(NC07408) Winterville'
                  'NC07409'='(NC07409) East Carolina University' 'NC074BI'='(NC074BI) Pitt Bi'
                  'NC074SP'='(NC074SP) Pitt State Police' 'NC07500'='(NC07500) Polk'
                  'NC07501'='(NC07501) Tryon' 'NC07502'='(NC07502) Saluda' 'NC07503'='(NC07503) Columbus'
                  'NC075BI'='(NC075BI) Polk Bi' 'NC075SP'='(NC075SP) Polk State Police'
                  'NC07600'='(NC07600) Randolph' 'NC07601'='(NC07601) Asheboro'
                  'NC07602'='(NC07602) Franklinville' 'NC07603'='(NC07603) Liberty'
                  'NC07604'='(NC07604) Ramseur' 'NC07605'='(NC07605) Randleman'
                  'NC07606'='(NC07606) Archdale' 'NC07607'='(NC07607) Seagrove'
                  'NC076BI'='(NC076BI) Randolph Bi' 'NC076SP'='(NC076SP) Randolph State Police'
                  'NC07700'='(NC07700) Richmond' 'NC07701'='(NC07701) Ellerbe' 'NC07702'='(NC07702) Hamlet'
                  'NC07703'='(NC07703) Rockingham' 'NC077BI'='(NC077BI) Richmond Bi'
                  'NC077SP'='(NC077SP) Richmond State Police' 'NC07800'='(NC07800) Robeson'
                  'NC07801'='(NC07801) Lumberton' 'NC07802'='(NC07802) Maxton'
                  'NC07803'='(NC07803) Red Springs' 'NC07804'='(NC07804) St. Pauls'
                  'NC07805'='(NC07805) Fairmont' 'NC07806'='(NC07806) Parkton'
                  'NC07807'='(NC07807) Pembroke' 'NC07808'='(NC07808) Rowland'
                  'NC07809'='(NC07809) Univ Of Nc: Pembroke'
                  'NC07810'='(NC07810) Spr: Lumber River' 'NC078BI'='(NC078BI) Robeson Bi'
                  'NC078SP'='(NC078SP) Robeson State Police' 'NC07900'='(NC07900) Rockingham'
                  'NC07901'='(NC07901) Eden' 'NC07903'='(NC07903) Madison' 'NC07904'='(NC07904) Mayodan'
                  'NC07905'='(NC07905) Reidsville' 'NC07907'='(NC07907) Stoneville'
                  'NC07955'='(NC07955) Reidsville Abc Enf Off'
                  'NC079BI'='(NC079BI) Rockingham Bi'
                  'NC079SP'='(NC079SP) Rockingham State Police' 'NC08000'='(NC08000) Rowan'
                  'NC08001'='(NC08001) China Grove' 'NC08002'='(NC08002) East Spencer'
                  'NC08003'='(NC08003) Landis' 'NC08004'='(NC08004) North Kannapolis'
                  'NC08005'='(NC08005) Salisbury' 'NC08006'='(NC08006) Rockwell'
                  'NC08007'='(NC08007) Spencer' 'NC08008'='(NC08008) Granite Quarry'
                  'NC08009'='(NC08009) Cleveland' 'NC080BI'='(NC080BI) Rowan Bi'
                  'NC080SP'='(NC080SP) Rowan State Police' 'NC08100'='(NC08100) Rutherford'
                  'NC08101'='(NC08101) Forest City' 'NC08102'='(NC08102) Rutherfordton'
                  'NC08103'='(NC08103) Spindale' 'NC08104'='(NC08104) Lake Lure'
                  'NC08105'='(NC08105) Alexander Mills' 'NC081BI'='(NC081BI) Rutherford Bi'
                  'NC081SP'='(NC081SP) Rutherford State Police' 'NC08200'='(NC08200) Sampson'
                  'NC08201'='(NC08201) Clinton' 'NC08202'='(NC08202) Garland'
                  'NC08203'='(NC08203) Newton Grove' 'NC08204'='(NC08204) Roseboro'
                  'NC08205'='(NC08205) Salemburg' 'NC082BI'='(NC082BI) Sampson Bi'
                  'NC082SP'='(NC082SP) Sampson State Police' 'NC08300'='(NC08300) Scotland'
                  'NC08301'='(NC08301) Laurinburg' 'NC08302'='(NC08302) Gibson'
                  'NC08303'='(NC08303) Wagram' 'NC083BI'='(NC083BI) Scotland Bi'
                  'NC083SP'='(NC083SP) Scotland State Police' 'NC08400'='(NC08400) Stanly'
                  'NC08401'='(NC08401) Albemarle' 'NC08402'='(NC08402) Norwood'
                  'NC08403'='(NC08403) Oakboro' 'NC08404'='(NC08404) Stanfield'
                  'NC08405'='(NC08405) Locust' 'NC08406'='(NC08406) Spr: Morrow Mountain'
                  'NC08407'='(NC08407) Badin' 'NC08408'='(NC08408) Pfeiffer University'
                  'NC084BI'='(NC084BI) Stanly Bi' 'NC084SP'='(NC084SP) Stanly State Police'
                  'NC08500'='(NC08500) Stokes' 'NC08501'='(NC08501) Walnut Cove' 'NC08503'='(NC08503) King'
                  'NC08504'='(NC08504) Spr: Hanging Rock'
                  'NC08505'='(NC08505) Spr: Pilot Mountain' 'NC085BI'='(NC085BI) Stokes Bi'
                  'NC085SP'='(NC085SP) Stokes State Police' 'NC08600'='(NC08600) Surry'
                  'NC08601'='(NC08601) Elkin' 'NC08602'='(NC08602) Mount Airy'
                  'NC08603'='(NC08603) Pilot Mountain' 'NC08604'='(NC08604) Dobson'
                  'NC086BI'='(NC086BI) Surry Bi' 'NC086SP'='(NC086SP) Surry State Police'
                  'NC08700'='(NC08700) Swain' 'NC08701'='(NC08701) Bryson City'
                  'NC08702'='(NC08702) Cherokee Tribal' 'NC087BI'='(NC087BI) Swain Bi'
                  'NC087SP'='(NC087SP) Swain State Police' 'NC08800'='(NC08800) Transylvania'
                  'NC08801'='(NC08801) Brevard' 'NC08802'='(NC08802) Spr: Gorges'
                  'NC088BI'='(NC088BI) Transylvania Bi'
                  'NC088SP'='(NC088SP) Transylvania State Polic' 'NC08900'='(NC08900) Tyrrell'
                  'NC08901'='(NC08901) Columbia' 'NC089BI'='(NC089BI) Tyrrell Bi'
                  'NC089SP'='(NC089SP) Tyrrell State Police' 'NC09000'='(NC09000) Union'
                  'NC09001'='(NC09001) Marshville' 'NC09002'='(NC09002) Monroe'
                  'NC09003'='(NC09003) Waxhaw' 'NC09004'='(NC09004) Wingate'
                  'NC09005'='(NC09005) Stallings' 'NC090BI'='(NC090BI) Union Bi'
                  'NC090SP'='(NC090SP) Union State Police' 'NC09100'='(NC09100) Vance'
                  'NC09101'='(NC09101) Henderson' 'NC09105'='(NC09105) Spr: Kerr Lake'
                  'NC091BI'='(NC091BI) Vance Bi' 'NC091SP'='(NC091SP) Vance State Police'
                  'NC09200'='(NC09200) Wake' 'NC09201'='(NC09201) Raleigh' 'NC09202'='(NC09202) Apex'
                  'NC09203'='(NC09203) Cary' 'NC09204'='(NC09204) Fuquay-Varina'
                  'NC09205'='(NC09205) Garner' 'NC09206'='(NC09206) Knightdale'
                  'NC09207'='(NC09207) Wake Forest' 'NC09208'='(NC09208) Wendell'
                  'NC09209'='(NC09209) Zebulon' 'NC09210'='(NC09210) Fuquay Springs'
                  'NC09211'='(NC09211) Rolesville' 'NC09212'='(NC09212) State Capitol Police'
                  'NC09213'='(NC09213) Morrisville'
                  'NC09215'='(NC09215) Raleigh-Durham Int Airpo'
                  'NC09216'='(NC09216) Nc State Univ: Raleigh'
                  'NC09217'='(NC09217) Holly Springs' 'NC09221'='(NC09221) State Fairgrounds'
                  'NC09226'='(NC09226) Spr: Falls Lake Rec Area'
                  'NC09227'='(NC09227) Spr: Jordan Lake Rec Ar'
                  'NC09228'='(NC09228) Spr: William B. umstead'
                  'NC09233'='(NC09233) Saint Augustines Colleg'
                  'NC09290'='(NC09290) Div Of Alcohol Law Enfor' 'NC092BI'='(NC092BI) Wake Bi'
                  'NC092SP'='(NC092SP) Wake State Police' 'NC09300'='(NC09300) Warren'
                  'NC09301'='(NC09301) Norlina' 'NC09302'='(NC09302) Warrenton'
                  'NC093BI'='(NC093BI) Warren Bi' 'NC093SP'='(NC093SP) Warren State Police'
                  'NC09400'='(NC09400) Washington' 'NC09401'='(NC09401) Plymouth'
                  'NC09402'='(NC09402) Roper' 'NC09404'='(NC09404) Spr: Pettigrew'
                  'NC094BI'='(NC094BI) Washington Bi'
                  'NC094SP'='(NC094SP) Washington State Police' 'NC09500'='(NC09500) Watauga'
                  'NC09501'='(NC09501) Boone' 'NC09502'='(NC09502) Blowing Rock'
                  'NC09503'='(NC09503) Appalachian State Univer'
                  'NC09504'='(NC09504) Seven Devils' 'NC09510'='(NC09510) Spr: Elk Knob'
                  'NC095BI'='(NC095BI) Watauga Bi' 'NC095SP'='(NC095SP) Watauga State Police'
                  'NC09600'='(NC09600) Wayne' 'NC09601'='(NC09601) Goldsboro' 'NC09602'='(NC09602) Eureka'
                  'NC09603'='(NC09603) Fremont' 'NC09604'='(NC09604) Mount Olive'
                  'NC09605'='(NC09605) Pikeville' 'NC09607'='(NC09607) Cherry-O berry Hospital'
                  'NC09608'='(NC09608) Walnut Creek'
                  'NC09609'='(NC09609) Spr: Cliffs Of The Neuse' 'NC096BI'='(NC096BI) Wayne Bi'
                  'NC096SP'='(NC096SP) Wayne State Police' 'NC09700'='(NC09700) Wilkes'
                  'NC09701'='(NC09701) North Wilkesboro' 'NC09702'='(NC09702) Wilkesboro'
                  'NC09703'='(NC09703) Ronda' 'NC097BI'='(NC097BI) Wilkes Bi'
                  'NC097SP'='(NC097SP) Wilkes State Police' 'NC09800'='(NC09800) Wilson'
                  'NC09801'='(NC09801) Wilson' 'NC09802'='(NC09802) Black Creek'
                  'NC09803'='(NC09803) Elm City' 'NC09804'='(NC09804) Lucama'
                  'NC09805'='(NC09805) Saratoga' 'NC09806'='(NC09806) Stantonsburg'
                  'NC09807'='(NC09807) Sims' 'NC09808'='(NC09808) Barton College'
                  'NC098BI'='(NC098BI) Wilson Bi' 'NC098SP'='(NC098SP) Wilson State Police'
                  'NC09900'='(NC09900) Yadkin' 'NC09901'='(NC09901) Jonesville'
                  'NC09902'='(NC09902) Yadkinville' 'NC09903'='(NC09903) Boonville'
                  'NC09904'='(NC09904) East Bend' 'NC09905'='(NC09905) Arlington'
                  'NC099BI'='(NC099BI) Yadkin Bi' 'NC099SP'='(NC099SP) Yadkin State Police'
                  'NC10000'='(NC10000) Yancey' 'NC10001'='(NC10001) Burnsville'
                  'NC10002'='(NC10002) Spr: Mt. Mitchell' 'NC100BI'='(NC100BI) Yancey Bi'
                  'NC100SP'='(NC100SP) Yancey State Police'
                  'NCBCI00'='(NCBCI00) Nc State Bureau Of Inves'
                  'NCNHP00'='(NCNHP00) Nc Highway Patrol' 'NCWLF00'='(NCWLF00) Dept Of Wildlife'
                  'ND00100'='(ND00100) Adams' 'ND00200'='(ND00200) Barnes'
                  'ND00201'='(ND00201) Valley City' 'ND00300'='(ND00300) Benson'
                  'ND00400'='(ND00400) Billings' 'ND00500'='(ND00500) Bottineau'
                  'ND00501'='(ND00501) Bottineau' 'ND00502'='(ND00502) Willow City'
                  'ND00600'='(ND00600) Bowman' 'ND00601'='(ND00601) Bowman' 'ND00700'='(ND00700) Burke'
                  'ND00705'='(ND00705) Powers Lake' 'ND00800'='(ND00800) Burleigh'
                  'ND00801'='(ND00801) Bismarck' 'ND00803'='(ND00803) Lincoln' 'ND00900'='(ND00900) Cass'
                  'ND00901'='(ND00901) Casselton' 'ND00902'='(ND00902) Fargo'
                  'ND00903'='(ND00903) West Fargo' 'ND00906'='(ND00906) North Dakota State Univ'
                  'ND01000'='(ND01000) Cavalier' 'ND01001'='(ND01001) Langdon' 'ND01100'='(ND01100) Dickey'
                  'ND01101'='(ND01101) Ellendale' 'ND01102'='(ND01102) Oakes' 'ND01200'='(ND01200) Divide'
                  'ND01201'='(ND01201) Crosby' 'ND01300'='(ND01300) Dunn' 'ND01400'='(ND01400) Eddy'
                  'ND01401'='(ND01401) New Rockford' 'ND01500'='(ND01500) Emmons'
                  'ND01501'='(ND01501) Linton' 'ND01600'='(ND01600) Foster'
                  'ND01601'='(ND01601) Carrington' 'ND01700'='(ND01700) Golden Valley'
                  'ND01800'='(ND01800) Grand Forks' 'ND01801'='(ND01801) Grand Forks'
                  'ND01802'='(ND01802) Larimore' 'ND01803'='(ND01803) Northwood'
                  'ND01804'='(ND01804) Emerado' 'ND01806'='(ND01806) Thompson'
                  'ND01808'='(ND01808) Univ Of North Dakota' 'ND01900'='(ND01900) Grant'
                  'ND01901'='(ND01901) Carson' 'ND01902'='(ND01902) Elgin' 'ND02000'='(ND02000) Griggs'
                  'ND02001'='(ND02001) Cooperstown' 'ND02100'='(ND02100) Hettinger'
                  'ND02200'='(ND02200) Kidder' 'ND02203'='(ND02203) Steele' 'ND02300'='(ND02300) Lamoure'
                  'ND02301'='(ND02301) Edgeley' 'ND02303'='(ND02303) Lamoure' 'ND02400'='(ND02400) Logan'
                  'ND02402'='(ND02402) Lehr' 'ND02403'='(ND02403) Napoleon' 'ND02500'='(ND02500) Mchenry'
                  'ND02502'='(ND02502) Velva' 'ND02600'='(ND02600) Mcintosh' 'ND02602'='(ND02602) Wishek'
                  'ND02700'='(ND02700) Mckenzie' 'ND02701'='(ND02701) Watford City'
                  'ND02800'='(ND02800) Mclean' 'ND02900'='(ND02900) Mercer' 'ND02901'='(ND02901) Beulah'
                  'ND02902'='(ND02902) Hazen' 'ND02903'='(ND02903) Stanton' 'ND03000'='(ND03000) Morton'
                  'ND03002'='(ND03002) Mandan' 'ND03005'='(ND03005) New Salem'
                  'ND03100'='(ND03100) Mountrail' 'ND03101'='(ND03101) New Town'
                  'ND03102'='(ND03102) Parshall' 'ND03200'='(ND03200) Nelson' 'ND03300'='(ND03300) Oliver'
                  'ND03400'='(ND03400) Pembina' 'ND03401'='(ND03401) Cavalier' 'ND03500'='(ND03500) Pierce'
                  'ND03501'='(ND03501) Rugby' 'ND03600'='(ND03600) Ramsey'
                  'ND03601'='(ND03601) Devils Lake' 'ND03700'='(ND03700) Ransom'
                  'ND03701'='(ND03701) Enderlin' 'ND03702'='(ND03702) Lisbon'
                  'ND03800'='(ND03800) Renville' 'ND03900'='(ND03900) Richland'
                  'ND03903'='(ND03903) Wahpeton' 'ND03906'='(ND03906) Nd St College Of Science'
                  'ND04000'='(ND04000) Rolette' 'ND04001'='(ND04001) Dunseith' 'ND04002'='(ND04002) Rolla'
                  'ND04100'='(ND04100) Sargent' 'ND04102'='(ND04102) Gwinner'
                  'ND04200'='(ND04200) Sheridan' 'ND04300'='(ND04300) Sioux' 'ND04400'='(ND04400) Slope'
                  'ND04500'='(ND04500) Stark' 'ND04501'='(ND04501) Dickinson'
                  'ND04504'='(ND04504) South Heart' 'ND04600'='(ND04600) Steele'
                  'ND04700'='(ND04700) Stutsman' 'ND04701'='(ND04701) Jamestown'
                  'ND04800'='(ND04800) Towner' 'ND04801'='(ND04801) Cando' 'ND04900'='(ND04900) Traill'
                  'ND04901'='(ND04901) Hillsboro' 'ND04902'='(ND04902) Mayville'
                  'ND04905'='(ND04905) Hatton' 'ND04906'='(ND04906) Portland' 'ND05000'='(ND05000) Walsh'
                  'ND05001'='(ND05001) Grafton' 'ND05100'='(ND05100) Ward' 'ND05102'='(ND05102) Minot'
                  'ND05200'='(ND05200) Wells' 'ND05201'='(ND05201) Harvey' 'ND05203'='(ND05203) Fessenden'
                  'ND05300'='(ND05300) Williams' 'ND05302'='(ND05302) Williston'
                  'NDNHP00'='(NDNHP00) Nd Highway Patrol' 'NH00100'='(NH00100) Belknap'
                  'NH00101'='(NH00101) Sp: Belknap County' 'NH00102'='(NH00102) Alton'
                  'NH00104'='(NH00104) Barnstead' 'NH00106'='(NH00106) Belmont'
                  'NH00108'='(NH00108) Center Harbor' 'NH00110'='(NH00110) Gilford'
                  'NH00112'='(NH00112) Gilmanton' 'NH00114'='(NH00114) Laconia'
                  'NH00116'='(NH00116) Meredith' 'NH00118'='(NH00118) New Hampton'
                  'NH00120'='(NH00120) Sanbornton' 'NH00122'='(NH00122) Tilton'
                  'NH001RU'='(NH001RU) Belknap Rural District' 'NH00200'='(NH00200) Carroll'
                  'NH00201'='(NH00201) Sp: Carroll County' 'NH00204'='(NH00204) Bartlett'
                  'NH00206'='(NH00206) Brookfield' 'NH00210'='(NH00210) Conway'
                  'NH00214'='(NH00214) Effingham' 'NH00216'='(NH00216) Freedom'
                  'NH00220'='(NH00220) Jackson' 'NH00222'='(NH00222) Madison'
                  'NH00224'='(NH00224) Moultonborough' 'NH00226'='(NH00226) Ossipee'
                  'NH00228'='(NH00228) Sandwich' 'NH00230'='(NH00230) Tamworth'
                  'NH00232'='(NH00232) Tuftonboro' 'NH00234'='(NH00234) Wakefield'
                  'NH00236'='(NH00236) Wolfeboro' 'NH002RU'='(NH002RU) Carroll Rural District'
                  'NH00300'='(NH00300) Cheshire' 'NH00301'='(NH00301) Sp: Cheshire County'
                  'NH00302'='(NH00302) Alstead' 'NH00304'='(NH00304) Chesterfield'
                  'NH00306'='(NH00306) Dublin' 'NH00308'='(NH00308) Fitzwilliam'
                  'NH00310'='(NH00310) Gilsum' 'NH00312'='(NH00312) Harrisville'
                  'NH00314'='(NH00314) Hinsdale' 'NH00316'='(NH00316) Jaffrey' 'NH00318'='(NH00318) Keene'
                  'NH00320'='(NH00320) Marlborough' 'NH00322'='(NH00322) Marlow'
                  'NH00324'='(NH00324) Nelson' 'NH00326'='(NH00326) Richmond' 'NH00328'='(NH00328) Rindge'
                  'NH00330'='(NH00330) Roxbury' 'NH00332'='(NH00332) Stoddard'
                  'NH00334'='(NH00334) Sullivan' 'NH00336'='(NH00336) Surry' 'NH00338'='(NH00338) Swanzey'
                  'NH00340'='(NH00340) Troy' 'NH00342'='(NH00342) Walpole'
                  'NH00344'='(NH00344) Westmoreland' 'NH00346'='(NH00346) Winchester'
                  'NH003RU'='(NH003RU) Cheshire Rural District' 'NH00400'='(NH00400) Coos'
                  'NH00401'='(NH00401) Sp: Coos County' 'NH00406'='(NH00406) Berlin'
                  'NH00410'='(NH00410) Carroll' 'NH00416'='(NH00416) Colebrook'
                  'NH00422'='(NH00422) Dalton' 'NH00428'='(NH00428) Errol' 'NH00430'='(NH00430) Gorham'
                  'NH00438'='(NH00438) Lancaster' 'NH00444'='(NH00444) Milan'
                  'NH00448'='(NH00448) Northumberland' 'NH00454'='(NH00454) Randolph'
                  'NH00464'='(NH00464) Stratford' 'NH00470'='(NH00470) Whitefield'
                  'NH004RU'='(NH004RU) Coos Rural District' 'NH00500'='(NH00500) Grafton'
                  'NH00501'='(NH00501) Sp: Grafton County' 'NH00502'='(NH00502) Alexandria'
                  'NH00504'='(NH00504) Ashland' 'NH00508'='(NH00508) Benton'
                  'NH00510'='(NH00510) Bethlehem' 'NH00512'='(NH00512) Bridgewater'
                  'NH00514'='(NH00514) Bristol' 'NH00516'='(NH00516) Campton' 'NH00518'='(NH00518) Canaan'
                  'NH00520'='(NH00520) Dorchester' 'NH00526'='(NH00526) Enfield'
                  'NH00528'='(NH00528) Franconia' 'NH00530'='(NH00530) Grafton'
                  'NH00534'='(NH00534) Hanover' 'NH00536'='(NH00536) Haverhill'
                  'NH00538'='(NH00538) Holderness' 'NH00540'='(NH00540) Hebron'
                  'NH00544'='(NH00544) Lebanon' 'NH00546'='(NH00546) Lincoln' 'NH00548'='(NH00548) Lisbon'
                  'NH00550'='(NH00550) Littleton' 'NH00556'='(NH00556) Lyme' 'NH00560'='(NH00560) Orange'
                  'NH00562'='(NH00562) Orford' 'NH00566'='(NH00566) Plymouth'
                  'NH00570'='(NH00570) Sugar Hill' 'NH00572'='(NH00572) Thornton'
                  'NH00574'='(NH00574) Warren' 'NH00576'='(NH00576) Waterville Valley'
                  'NH00580'='(NH00580) Woodstock' 'NH005RU'='(NH005RU) Grafton Rural District'
                  'NH00600'='(NH00600) Hillsborough'
                  'NH00601'='(NH00601) Sp: Hillsborough County' 'NH00602'='(NH00602) Amherst'
                  'NH00604'='(NH00604) Antrim' 'NH00606'='(NH00606) Bedford'
                  'NH00608'='(NH00608) Bennington' 'NH00610'='(NH00610) Brookline'
                  'NH00612'='(NH00612) Deering' 'NH00614'='(NH00614) Francestown'
                  'NH00616'='(NH00616) Goffstown' 'NH00618'='(NH00618) Greenfield'
                  'NH00620'='(NH00620) Greenville' 'NH00622'='(NH00622) Hancock'
                  'NH00624'='(NH00624) Hillsborough' 'NH00626'='(NH00626) Hollis'
                  'NH00628'='(NH00628) Hudson' 'NH00630'='(NH00630) Litchfield'
                  'NH00632'='(NH00632) Lyndeborough' 'NH00634'='(NH00634) Manchester'
                  'NH00638'='(NH00638) Mason' 'NH00640'='(NH00640) Merrimack' 'NH00642'='(NH00642) Milford'
                  'NH00644'='(NH00644) Mont Vernon' 'NH00646'='(NH00646) Nashua'
                  'NH00648'='(NH00648) New Boston' 'NH00650'='(NH00650) New Ipswich'
                  'NH00652'='(NH00652) Pelham' 'NH00654'='(NH00654) Peterborough'
                  'NH00656'='(NH00656) Sharon' 'NH00658'='(NH00658) Temple' 'NH00660'='(NH00660) Weare'
                  'NH00662'='(NH00662) Wilton' 'NH00664'='(NH00664) Windsor'
                  'NH006RU'='(NH006RU) Hillsborough Rural Dist' 'NH00700'='(NH00700) Merrimack'
                  'NH00701'='(NH00701) Sp: Merrimack County' 'NH00702'='(NH00702) Allenstown'
                  'NH00704'='(NH00704) Andover' 'NH00706'='(NH00706) Boscawen' 'NH00708'='(NH00708) Bow'
                  'NH00710'='(NH00710) Bradford' 'NH00712'='(NH00712) Canterbury'
                  'NH00714'='(NH00714) Chichester' 'NH00716'='(NH00716) Concord'
                  'NH00718'='(NH00718) Danbury' 'NH00720'='(NH00720) Dunbarton' 'NH00722'='(NH00722) Epsom'
                  'NH00724'='(NH00724) Franklin' 'NH00726'='(NH00726) Henniker' 'NH00728'='(NH00728) Hill'
                  'NH00730'='(NH00730) Hooksett' 'NH00732'='(NH00732) Hopkinton'
                  'NH00734'='(NH00734) Loudon' 'NH00736'='(NH00736) Newbury'
                  'NH00738'='(NH00738) New London' 'NH00740'='(NH00740) Northfield'
                  'NH00742'='(NH00742) Pembroke' 'NH00744'='(NH00744) Pittsfield'
                  'NH00746'='(NH00746) Salisbury' 'NH00748'='(NH00748) Sutton' 'NH00750'='(NH00750) Warner'
                  'NH00752'='(NH00752) Webster' 'NH00758'='(NH00758) Liquor Commission'
                  'NH007RU'='(NH007RU) Merrimack Rural District' 'NH00800'='(NH00800) Rockingham'
                  'NH00801'='(NH00801) Sp: Rockingham County' 'NH00802'='(NH00802) Atkinson'
                  'NH00804'='(NH00804) Auburn' 'NH00806'='(NH00806) Brentwood' 'NH00808'='(NH00808) Candia'
                  'NH00810'='(NH00810) Chester' 'NH00812'='(NH00812) Danville'
                  'NH00814'='(NH00814) Deerfield' 'NH00816'='(NH00816) Derry'
                  'NH00818'='(NH00818) East Kingston' 'NH00820'='(NH00820) Epping'
                  'NH00822'='(NH00822) Exeter' 'NH00824'='(NH00824) Fremont'
                  'NH00826'='(NH00826) Greenland' 'NH00828'='(NH00828) Hampstead'
                  'NH00830'='(NH00830) Hampton' 'NH00832'='(NH00832) Hampton Falls'
                  'NH00834'='(NH00834) Kensington' 'NH00836'='(NH00836) Kingston'
                  'NH00838'='(NH00838) Londonderry' 'NH00840'='(NH00840) New Castle'
                  'NH00842'='(NH00842) Newfields' 'NH00844'='(NH00844) Newington'
                  'NH00846'='(NH00846) Newmarket' 'NH00848'='(NH00848) Newton'
                  'NH00850'='(NH00850) North Hampton' 'NH00852'='(NH00852) Northwood'
                  'NH00854'='(NH00854) Nottingham' 'NH00856'='(NH00856) Plaistow'
                  'NH00858'='(NH00858) Portsmouth' 'NH00860'='(NH00860) Raymond' 'NH00862'='(NH00862) Rye'
                  'NH00864'='(NH00864) Salem' 'NH00866'='(NH00866) Sandown' 'NH00868'='(NH00868) Seabrook'
                  'NH00870'='(NH00870) South Hampton' 'NH00872'='(NH00872) Stratham'
                  'NH00874'='(NH00874) Windham' 'NH008RU'='(NH008RU) Rockingham Rural Distric'
                  'NH00900'='(NH00900) Strafford' 'NH00901'='(NH00901) Sp: Strafford County'
                  'NH00902'='(NH00902) Barrington' 'NH00904'='(NH00904) Dover' 'NH00906'='(NH00906) Durham'
                  'NH00908'='(NH00908) Farmington' 'NH00910'='(NH00910) Lee' 'NH00912'='(NH00912) Madbury'
                  'NH00914'='(NH00914) Middleton' 'NH00916'='(NH00916) Milton'
                  'NH00918'='(NH00918) New Durham' 'NH00920'='(NH00920) Rochester'
                  'NH00922'='(NH00922) Rollinsford' 'NH00924'='(NH00924) Somersworth'
                  'NH00926'='(NH00926) Strafford' 'NH00930'='(NH00930) Univ Of New Hampshire'
                  'NH009RU'='(NH009RU) Strafford Rural District' 'NH01000'='(NH01000) Sullivan'
                  'NH01001'='(NH01001) Sp: Sullivan County' 'NH01002'='(NH01002) Acworth'
                  'NH01004'='(NH01004) Charlestown' 'NH01006'='(NH01006) Claremont'
                  'NH01008'='(NH01008) Croydon' 'NH01010'='(NH01010) Goshen' 'NH01012'='(NH01012) Grantham'
                  'NH01014'='(NH01014) Langdon' 'NH01016'='(NH01016) Lempster'
                  'NH01018'='(NH01018) Newport' 'NH01020'='(NH01020) Plainfield'
                  'NH01022'='(NH01022) Springfield' 'NH01024'='(NH01024) Sunapee'
                  'NH01026'='(NH01026) Unity' 'NH01028'='(NH01028) Washington'
                  'NH01030'='(NH01030) Cornish' 'NH010RU'='(NH010RU) Sullivan Rural District'
                  'NH301SP'='(NH301SP) Belknap State Police'
                  'NH302SP'='(NH302SP) Carroll State Police'
                  'NH303SP'='(NH303SP) Cheshire State Police'
                  'NH304SP'='(NH304SP) Sp: Coos County'
                  'NH305SP'='(NH305SP) Grafton State Police'
                  'NH306SP'='(NH306SP) Hillsborough County Sp'
                  'NH307SP'='(NH307SP) Merrimack State Police'
                  'NH308SP'='(NH308SP) Rockingham State Police'
                  'NH309SP'='(NH309SP) Strafford State Police'
                  'NH310SP'='(NH310SP) Sullivan State Police' 'NHNSP00'='(NHNSP00) State Police'
                  'NJ00100'='(NJ00100) Atlantic' 'NJ00101'='(NJ00101) Absecon'
                  'NJ00102'='(NJ00102) Atlantic City' 'NJ00103'='(NJ00103) Brigantine'
                  'NJ00104'='(NJ00104) Buena' 'NJ00107'='(NJ00107) Egg Harbor City'
                  'NJ00108'='(NJ00108) Egg Harbor Township'
                  'NJ00111'='(NJ00111) Galloway Township' 'NJ00112'='(NJ00112) Hamilton Township'
                  'NJ00113'='(NJ00113) Hammonton' 'NJ00114'='(NJ00114) Linwood'
                  'NJ00115'='(NJ00115) Longport' 'NJ00116'='(NJ00116) Margate City'
                  'NJ00117'='(NJ00117) Mullica Township' 'NJ00118'='(NJ00118) Northfield'
                  'NJ00119'='(NJ00119) Pleasantville' 'NJ00121'='(NJ00121) Somers Point'
                  'NJ00122'='(NJ00122) Ventnor City'
                  'NJ00189'='(NJ00189) Prosecutor: Atlantic Cty'
                  'NJ001PT'='(NJ001PT) Spt Atlantic Co' 'NJ001SP'='(NJ001SP) Sp: Atlantic County'
                  'NJ00200'='(NJ00200) Bergen' 'NJ00201'='(NJ00201) Allendale' 'NJ00202'='(NJ00202) Alpine'
                  'NJ00203'='(NJ00203) Bergenfield' 'NJ00204'='(NJ00204) Bogota'
                  'NJ00205'='(NJ00205) Carlstadt' 'NJ00206'='(NJ00206) Cliffside Park'
                  'NJ00207'='(NJ00207) Closter' 'NJ00208'='(NJ00208) Cresskill'
                  'NJ00209'='(NJ00209) Demarest' 'NJ00210'='(NJ00210) Dumont'
                  'NJ00211'='(NJ00211) Elmwood Park' 'NJ00212'='(NJ00212) East Rutherford'
                  'NJ00213'='(NJ00213) Edgewater' 'NJ00214'='(NJ00214) Emerson'
                  'NJ00215'='(NJ00215) Englewood' 'NJ00216'='(NJ00216) Englewood Cliffs'
                  'NJ00217'='(NJ00217) Fair Lawn' 'NJ00218'='(NJ00218) Fairview'
                  'NJ00219'='(NJ00219) Fort Lee' 'NJ00220'='(NJ00220) Franklin Lakes'
                  'NJ00221'='(NJ00221) Garfield' 'NJ00222'='(NJ00222) Glen Rock'
                  'NJ00223'='(NJ00223) Hackensack' 'NJ00224'='(NJ00224) Harrington Park'
                  'NJ00225'='(NJ00225) Hasbrouck Heights' 'NJ00226'='(NJ00226) Haworth'
                  'NJ00227'='(NJ00227) Hillsdale' 'NJ00228'='(NJ00228) Ho-Ho-Kus'
                  'NJ00229'='(NJ00229) Leonia' 'NJ00230'='(NJ00230) Little Ferry'
                  'NJ00231'='(NJ00231) Lodi' 'NJ00232'='(NJ00232) Lyndhurst Township'
                  'NJ00233'='(NJ00233) Mahwah Township' 'NJ00234'='(NJ00234) Maywood'
                  'NJ00235'='(NJ00235) Midland Park' 'NJ00236'='(NJ00236) Montvale'
                  'NJ00237'='(NJ00237) Moonachie' 'NJ00238'='(NJ00238) New Milford'
                  'NJ00239'='(NJ00239) North Arlington' 'NJ00240'='(NJ00240) Northvale'
                  'NJ00241'='(NJ00241) Norwood' 'NJ00242'='(NJ00242) Oakland'
                  'NJ00243'='(NJ00243) Old Tappan' 'NJ00244'='(NJ00244) Oradell'
                  'NJ00245'='(NJ00245) Palisades Park' 'NJ00246'='(NJ00246) Paramus'
                  'NJ00247'='(NJ00247) Park Ridge' 'NJ00248'='(NJ00248) Ramsey'
                  'NJ00249'='(NJ00249) Ridgefield' 'NJ00250'='(NJ00250) Ridgefield Park'
                  'NJ00251'='(NJ00251) Ridgewood' 'NJ00252'='(NJ00252) River Edge'
                  'NJ00253'='(NJ00253) River Vale Township'
                  'NJ00254'='(NJ00254) Rochelle Park Township' 'NJ00255'='(NJ00255) Rockleigh'
                  'NJ00256'='(NJ00256) Rutherford' 'NJ00257'='(NJ00257) Saddle Brook Township'
                  'NJ00258'='(NJ00258) Saddle River'
                  'NJ00259'='(NJ00259) South Hackensack Townshi'
                  'NJ00260'='(NJ00260) Teaneck Township' 'NJ00261'='(NJ00261) Tenafly'
                  'NJ00262'='(NJ00262) Teterboro' 'NJ00263'='(NJ00263) Upper Saddle River'
                  'NJ00264'='(NJ00264) Waldwick' 'NJ00265'='(NJ00265) Wallington'
                  'NJ00266'='(NJ00266) Washington Township' 'NJ00267'='(NJ00267) Westwood'
                  'NJ00268'='(NJ00268) Woodcliff Lake' 'NJ00269'='(NJ00269) Wood-Ridge'
                  'NJ00270'='(NJ00270) Wyckoff Township'
                  'NJ00271'='(NJ00271) Bergen County Pol Dept'
                  'NJ00289'='(NJ00289) Prosecutor: Bergen Cnty'
                  'NJ002PT'='(NJ002PT) Spt Bergen Co' 'NJ002SP'='(NJ002SP) Sp: Bergen County'
                  'NJ00300'='(NJ00300) Burlington' 'NJ00302'='(NJ00302) Beverly'
                  'NJ00303'='(NJ00303) Bordentown' 'NJ00304'='(NJ00304) Bordentown Township'
                  'NJ00305'='(NJ00305) Burlington' 'NJ00306'='(NJ00306) Burlington Township'
                  'NJ00307'='(NJ00307) Chesterfield Township'
                  'NJ00308'='(NJ00308) Cinnaminson Township'
                  'NJ00309'='(NJ00309) Delanco Township' 'NJ00310'='(NJ00310) Delran Township'
                  'NJ00311'='(NJ00311) Eastampton Township'
                  'NJ00312'='(NJ00312) Edgewater Park Township'
                  'NJ00313'='(NJ00313) Evesham Township' 'NJ00315'='(NJ00315) Florence Township'
                  'NJ00316'='(NJ00316) Hainesport Township'
                  'NJ00317'='(NJ00317) Willingboro Township'
                  'NJ00318'='(NJ00318) Lumberton Township'
                  'NJ00319'='(NJ00319) Mansfield Township'
                  'NJ00320'='(NJ00320) Maple Shade Township'
                  'NJ00321'='(NJ00321) Medford Township' 'NJ00322'='(NJ00322) Medford Lakes'
                  'NJ00323'='(NJ00323) Moorestown Township'
                  'NJ00324'='(NJ00324) Mount Holly Township'
                  'NJ00325'='(NJ00325) Mount Laurel Township'
                  'NJ00326'='(NJ00326) New Hanover Township'
                  'NJ00327'='(NJ00327) North Hanover Township' 'NJ00328'='(NJ00328) Palmyra'
                  'NJ00329'='(NJ00329) Pemberton' 'NJ00330'='(NJ00330) Pemberton Township'
                  'NJ00331'='(NJ00331) Riverside Township' 'NJ00332'='(NJ00332) Riverton'
                  'NJ00335'='(NJ00335) Springfield Township'
                  'NJ00338'='(NJ00338) Westampton Township'
                  'NJ00339'='(NJ00339) Hum Srvcs, Woodland Twp' 'NJ00340'='(NJ00340) Wrightstown'
                  'NJ00389'='(NJ00389) Prosecutor:Burlington C'
                  'NJ003PT'='(NJ003PT) Spt Burlington Co'
                  'NJ003SP'='(NJ003SP) Sp: Burlington County' 'NJ00400'='(NJ00400) Camden'
                  'NJ00401'='(NJ00401) Audubon' 'NJ00402'='(NJ00402) Audubon Park'
                  'NJ00403'='(NJ00403) Barrington' 'NJ00404'='(NJ00404) Bellmawr'
                  'NJ00405'='(NJ00405) Berlin' 'NJ00406'='(NJ00406) Berlin Township'
                  'NJ00407'='(NJ00407) Brooklawn' 'NJ00408'='(NJ00408) Camden'
                  'NJ00409'='(NJ00409) Chesilhurst' 'NJ00410'='(NJ00410) Clementon'
                  'NJ00411'='(NJ00411) Collingswood' 'NJ00412'='(NJ00412) Cherry Hill Township'
                  'NJ00413'='(NJ00413) Gibbsboro' 'NJ00414'='(NJ00414) Gloucester City'
                  'NJ00415'='(NJ00415) Gloucester Township' 'NJ00416'='(NJ00416) Haddon Township'
                  'NJ00417'='(NJ00417) Haddonfield' 'NJ00418'='(NJ00418) Haddon Heights'
                  'NJ00419'='(NJ00419) Hi-Nella' 'NJ00420'='(NJ00420) Laurel Springs'
                  'NJ00421'='(NJ00421) Lawnside' 'NJ00422'='(NJ00422) Lindenwold'
                  'NJ00423'='(NJ00423) Magnolia' 'NJ00424'='(NJ00424) Merchantville'
                  'NJ00425'='(NJ00425) Mount Ephraim' 'NJ00426'='(NJ00426) Oaklyn'
                  'NJ00427'='(NJ00427) Pennsauken Township' 'NJ00428'='(NJ00428) Pine Hill'
                  'NJ00429'='(NJ00429) Pine Valley' 'NJ00430'='(NJ00430) Runnemede'
                  'NJ00431'='(NJ00431) Somerdale' 'NJ00432'='(NJ00432) Stratford'
                  'NJ00433'='(NJ00433) Tavistock' 'NJ00434'='(NJ00434) Voorhees Township'
                  'NJ00435'='(NJ00435) Waterford Township' 'NJ00436'='(NJ00436) Winslow Township'
                  'NJ00437'='(NJ00437) Woodlynne' 'NJ00489'='(NJ00489) Prosecutor: Camden Cnty'
                  'NJ00491'='(NJ00491) Park Police: Camden Cnty'
                  'NJ004PT'='(NJ004PT) spt Camden Co' 'NJ004SP'='(NJ004SP) Sp: Camden County'
                  'NJ00500'='(NJ00500) Cape May' 'NJ00501'='(NJ00501) Avalon'
                  'NJ00502'='(NJ00502) Cape May' 'NJ00503'='(NJ00503) Cape May Point'
                  'NJ00505'='(NJ00505) Lower Township' 'NJ00506'='(NJ00506) Middle Township'
                  'NJ00507'='(NJ00507) North Wildwood' 'NJ00508'='(NJ00508) Ocean City'
                  'NJ00509'='(NJ00509) Sea Isle City' 'NJ00510'='(NJ00510) Stone Harbor'
                  'NJ00512'='(NJ00512) West Cape May' 'NJ00513'='(NJ00513) West Wildwood'
                  'NJ00514'='(NJ00514) Wildwood' 'NJ00515'='(NJ00515) Wildwood Crest'
                  'NJ00516'='(NJ00516) Woodbine' 'NJ00589'='(NJ00589) Prosecutor: Cape May Cty'
                  'NJ005PT'='(NJ005PT) Spt Cape May Co' 'NJ005SP'='(NJ005SP) Sp: Cape May County'
                  'NJ00600'='(NJ00600) Cumberland' 'NJ00601'='(NJ00601) Bridgeton'
                  'NJ00603'='(NJ00603) Deerfield Township'
                  'NJ00605'='(NJ00605) Fairfield Township'
                  'NJ00608'='(NJ00608) Lawrence Township' 'NJ00610'='(NJ00610) Millville'
                  'NJ00613'='(NJ00613) Upper Deerfield Township' 'NJ00614'='(NJ00614) Vineland'
                  'NJ00689'='(NJ00689) Prosecutor: Cumberland C'
                  'NJ006PT'='(NJ006PT) Spt Cumberland Co'
                  'NJ006SP'='(NJ006SP) Sp: Cumberland County' 'NJ00700'='(NJ00700) Essex'
                  'NJ00701'='(NJ00701) Belleville' 'NJ00702'='(NJ00702) Bloomfield'
                  'NJ00703'='(NJ00703) Caldwell' 'NJ00704'='(NJ00704) Fairfield Township'
                  'NJ00705'='(NJ00705) Cedar Grove Township' 'NJ00706'='(NJ00706) East Orange'
                  'NJ00707'='(NJ00707) Essex Fells' 'NJ00708'='(NJ00708) Glen Ridge'
                  'NJ00709'='(NJ00709) Irvington' 'NJ00710'='(NJ00710) Livingston Township'
                  'NJ00711'='(NJ00711) Maplewood Township'
                  'NJ00712'='(NJ00712) Millburn Township' 'NJ00713'='(NJ00713) Montclair'
                  'NJ00715'='(NJ00715) North Caldwell' 'NJ00716'='(NJ00716) Nutley Township'
                  'NJ00717'='(NJ00717) Orange' 'NJ00718'='(NJ00718) Roseland'
                  'NJ00719'='(NJ00719) South Orange' 'NJ00720'='(NJ00720) Verona'
                  'NJ00721'='(NJ00721) West Caldwell Township' 'NJ00722'='(NJ00722) West Orange'
                  'NJ00723'='(NJ00723) Essex County Police Dept'
                  'NJ00724'='(NJ00724) Nj Div Alcohol Bev Cont'
                  'NJ00728'='(NJ00728) Montclair State Universi'
                  'NJ00730'='(NJ00730) Univ Of Med & Dent:Newar'
                  'NJ00732'='(NJ00732) Nj Transit Police'
                  'NJ00789'='(NJ00789) Prosecutor: Essex County'
                  'NJ007PT'='(NJ007PT) spt Essex Co' 'NJ007SP'='(NJ007SP) Sp: Essex County'
                  'NJ00800'='(NJ00800) Gloucester' 'NJ00801'='(NJ00801) Clayton'
                  'NJ00802'='(NJ00802) Deptford Township'
                  'NJ00803'='(NJ00803) East Greenwich Township'
                  'NJ00804'='(NJ00804) Elk Township' 'NJ00805'='(NJ00805) Franklin Township'
                  'NJ00806'='(NJ00806) Glassboro' 'NJ00807'='(NJ00807) Greenwich Township'
                  'NJ00808'='(NJ00808) Harrison Township' 'NJ00809'='(NJ00809) Logan Township'
                  'NJ00810'='(NJ00810) Mantua Township' 'NJ00811'='(NJ00811) Monroe Township'
                  'NJ00812'='(NJ00812) National Park' 'NJ00813'='(NJ00813) Newfield'
                  'NJ00814'='(NJ00814) Paulsboro' 'NJ00815'='(NJ00815) Pitman'
                  'NJ00816'='(NJ00816) South Harrison Township' 'NJ00817'='(NJ00817) Swedesboro'
                  'NJ00818'='(NJ00818) Washington Township' 'NJ00819'='(NJ00819) Wenonah'
                  'NJ00820'='(NJ00820) West Deptford Township' 'NJ00821'='(NJ00821) Westville'
                  'NJ00822'='(NJ00822) Woodbury' 'NJ00823'='(NJ00823) Woodbury Heights'
                  'NJ00824'='(NJ00824) Woolwich Township' 'NJ00825'='(NJ00825) Williamstown'
                  'NJ00889'='(NJ00889) Prosecutor:Gloucester C'
                  'NJ008PT'='(NJ008PT) Spt Gloucester Co'
                  'NJ008SP'='(NJ008SP) Sp: Gloucester County' 'NJ00900'='(NJ00900) Hudson'
                  'NJ00901'='(NJ00901) Bayonne' 'NJ00902'='(NJ00902) East Newark'
                  'NJ00903'='(NJ00903) Guttenberg' 'NJ00904'='(NJ00904) Harrison'
                  'NJ00905'='(NJ00905) Hoboken' 'NJ00906'='(NJ00906) Jersey City'
                  'NJ00907'='(NJ00907) Kearny' 'NJ00908'='(NJ00908) North Bergen Township'
                  'NJ00909'='(NJ00909) Secaucus' 'NJ00910'='(NJ00910) Union City'
                  'NJ00911'='(NJ00911) Weehawken Township' 'NJ00912'='(NJ00912) West New York'
                  'NJ00913'='(NJ00913) Hudson County Police Dep'
                  'NJ00989'='(NJ00989) Prosecutor: Hudson Cnty'
                  'NJ009PT'='(NJ009PT) spt Hudson Co' 'NJ009SP'='(NJ009SP) Sp: Hudson County'
                  'NJ01000'='(NJ01000) Hunterdon' 'NJ01001'='(NJ01001) Alexandria Township'
                  'NJ01003'='(NJ01003) Bloomsbury' 'NJ01004'='(NJ01004) Califon'
                  'NJ01005'='(NJ01005) Clinton' 'NJ01006'='(NJ01006) Clinton Township'
                  'NJ01007'='(NJ01007) Delaware Township' 'NJ01009'='(NJ01009) Flemington'
                  'NJ01010'='(NJ01010) Franklin Township' 'NJ01011'='(NJ01011) Frenchtown'
                  'NJ01012'='(NJ01012) Glen Gardner' 'NJ01013'='(NJ01013) Hampton'
                  'NJ01014'='(NJ01014) High Bridge' 'NJ01015'='(NJ01015) Holland Township'
                  'NJ01017'='(NJ01017) Lambertville' 'NJ01018'='(NJ01018) Lebanon'
                  'NJ01019'='(NJ01019) Lebanon Township' 'NJ01020'='(NJ01020) Milford'
                  'NJ01021'='(NJ01021) Raritan Township'
                  'NJ01022'='(NJ01022) Readington Township'
                  'NJ01024'='(NJ01024) Tewksbury Township'
                  'NJ01025'='(NJ01025) Hunterdon Dev Center'
                  'NJ01026'='(NJ01026) West Amwell Township'
                  'NJ01089'='(NJ01089) Prosecutor: Hunterdon C'
                  'NJ010PT'='(NJ010PT) Spt Hunterdon Co'
                  'NJ010SP'='(NJ010SP) Sp: Hunterdon County' 'NJ01100'='(NJ01100) Mercer'
                  'NJ01101'='(NJ01101) East Windsor Township'
                  'NJ01102'='(NJ01102) Ewing Township' 'NJ01103'='(NJ01103) Hamilton Township'
                  'NJ01104'='(NJ01104) Hightstown' 'NJ01105'='(NJ01105) Hopewell'
                  'NJ01106'='(NJ01106) Hopewell Township' 'NJ01107'='(NJ01107) Lawrence Township'
                  'NJ01108'='(NJ01108) Pennington' 'NJ01109'='(NJ01109) Princeton'
                  'NJ01110'='(NJ01110) Princeton Township' 'NJ01111'='(NJ01111) Trenton'
                  'NJ01112'='(NJ01112) Washington Township'
                  'NJ01113'='(NJ01113) West Windsor Township'
                  'NJ01114'='(NJ01114) St Enforce Bur Inv Sect'
                  'NJ01115'='(NJ01115) Div Of Motor Vehicles'
                  'NJ01117'='(NJ01117) N j Div Of Fish & Game'
                  'NJ01119'='(NJ01119) Dept Of Human Services'
                  'NJ01189'='(NJ01189) Prosecutor: Mercer Cnty'
                  'NJ011PT'='(NJ011PT) spt Mercer Co' 'NJ011SP'='(NJ011SP) Sp: Mercer County'
                  'NJ01200'='(NJ01200) Middlesex' 'NJ01201'='(NJ01201) Carteret'
                  'NJ01202'='(NJ01202) Cranbury Township' 'NJ01203'='(NJ01203) Dunellen'
                  'NJ01204'='(NJ01204) East Brunswick Township'
                  'NJ01205'='(NJ01205) Edison Township' 'NJ01206'='(NJ01206) Helmetta'
                  'NJ01207'='(NJ01207) Highland Park' 'NJ01208'='(NJ01208) Jamesburg'
                  'NJ01209'='(NJ01209) Old Bridge Township' 'NJ01210'='(NJ01210) Metuchen'
                  'NJ01211'='(NJ01211) Middlesex' 'NJ01212'='(NJ01212) Milltown'
                  'NJ01213'='(NJ01213) Monroe Township' 'NJ01214'='(NJ01214) New Brunswick'
                  'NJ01215'='(NJ01215) North Brunswick Township'
                  'NJ01216'='(NJ01216) Perth Amboy' 'NJ01217'='(NJ01217) Piscataway Township'
                  'NJ01218'='(NJ01218) Plainsboro Township' 'NJ01219'='(NJ01219) Sayreville'
                  'NJ01220'='(NJ01220) South Amboy'
                  'NJ01221'='(NJ01221) South Brunswick Township'
                  'NJ01222'='(NJ01222) South Plainfield' 'NJ01223'='(NJ01223) South River'
                  'NJ01224'='(NJ01224) Spotswood' 'NJ01225'='(NJ01225) Woodbridge Township'
                  'NJ01289'='(NJ01289) Prosecutor: Middlesex C'
                  'NJ01291'='(NJ01291) middlesex Park Police'
                  'NJ012PT'='(NJ012PT) Spt Middlesex Co'
                  'NJ012SP'='(NJ012SP) Sp: Middlesex County' 'NJ01300'='(NJ01300) Monmouth'
                  'NJ01301'='(NJ01301) Allenhurst' 'NJ01302'='(NJ01302) Allentown'
                  'NJ01303'='(NJ01303) Asbury Park' 'NJ01304'='(NJ01304) Colts Neck Township'
                  'NJ01305'='(NJ01305) Atlantic Highlands' 'NJ01306'='(NJ01306) Avon-By-The-Sea'
                  'NJ01307'='(NJ01307) Belmar' 'NJ01308'='(NJ01308) Bradley Beach'
                  'NJ01309'='(NJ01309) Brielle' 'NJ01310'='(NJ01310) Deal' 'NJ01311'='(NJ01311) Eatontown'
                  'NJ01312'='(NJ01312) Englishtown' 'NJ01313'='(NJ01313) Fair Haven'
                  'NJ01314'='(NJ01314) Farmingdale' 'NJ01315'='(NJ01315) Freehold'
                  'NJ01316'='(NJ01316) Freehold Township' 'NJ01317'='(NJ01317) Highlands'
                  'NJ01318'='(NJ01318) Holmdel Township' 'NJ01319'='(NJ01319) Howell Township'
                  'NJ01320'='(NJ01320) Interlaken' 'NJ01321'='(NJ01321) Keansburg'
                  'NJ01322'='(NJ01322) Keyport' 'NJ01323'='(NJ01323) Little Silver'
                  'NJ01324'='(NJ01324) Loch Arbour' 'NJ01325'='(NJ01325) Long Branch'
                  'NJ01326'='(NJ01326) Manalapan Township' 'NJ01327'='(NJ01327) Manasquan'
                  'NJ01328'='(NJ01328) Marlboro Township' 'NJ01329'='(NJ01329) Matawan'
                  'NJ01330'='(NJ01330) Aberdeen Township'
                  'NJ01331'='(NJ01331) Middletown Township' 'NJ01333'='(NJ01333) Monmouth Beach'
                  'NJ01334'='(NJ01334) Neptune Township' 'NJ01335'='(NJ01335) Neptune City'
                  'NJ01336'='(NJ01336) Tinton Falls' 'NJ01337'='(NJ01337) Ocean Township'
                  'NJ01338'='(NJ01338) Oceanport' 'NJ01339'='(NJ01339) Hazlet Township'
                  'NJ01340'='(NJ01340) Red Bank' 'NJ01342'='(NJ01342) Rumson'
                  'NJ01343'='(NJ01343) Sea Bright' 'NJ01344'='(NJ01344) Sea Girt'
                  'NJ01345'='(NJ01345) Shrewsbury' 'NJ01347'='(NJ01347) Lake Como'
                  'NJ01348'='(NJ01348) Spring Lake' 'NJ01349'='(NJ01349) Spring Lake Heights'
                  'NJ01350'='(NJ01350) Union Beach' 'NJ01352'='(NJ01352) Wall Township'
                  'NJ01353'='(NJ01353) West Long Branch' 'NJ01354'='(NJ01354) Ocean Grove'
                  'NJ01356'='(NJ01356) Brookdale Community Coll'
                  'NJ01389'='(NJ01389) Prosecutor: Monmouth Cty'
                  'NJ013PT'='(NJ013PT) Spt Monmouth Co' 'NJ013SP'='(NJ013SP) Sp: Monmouth County'
                  'NJ01400'='(NJ01400) Morris' 'NJ01401'='(NJ01401) Boonton'
                  'NJ01402'='(NJ01402) Boonton Township' 'NJ01403'='(NJ01403) Butler'
                  'NJ01404'='(NJ01404) Chatham' 'NJ01405'='(NJ01405) Chatham Township'
                  'NJ01406'='(NJ01406) Chester' 'NJ01407'='(NJ01407) Chester Township'
                  'NJ01408'='(NJ01408) Denville Township' 'NJ01409'='(NJ01409) Dover'
                  'NJ01410'='(NJ01410) East Hanover Township' 'NJ01411'='(NJ01411) Florham Park'
                  'NJ01412'='(NJ01412) Hanover Township' 'NJ01413'='(NJ01413) Harding Township'
                  'NJ01414'='(NJ01414) Jefferson Township' 'NJ01415'='(NJ01415) Kinnelon'
                  'NJ01416'='(NJ01416) Lincoln Park' 'NJ01417'='(NJ01417) Madison'
                  'NJ01418'='(NJ01418) Mendham' 'NJ01419'='(NJ01419) Mendham Township'
                  'NJ01420'='(NJ01420) Mine Hill Township'
                  'NJ01421'='(NJ01421) Montville Township' 'NJ01422'='(NJ01422) Morris Township'
                  'NJ01423'='(NJ01423) Morris Plains' 'NJ01424'='(NJ01424) Morristown'
                  'NJ01425'='(NJ01425) Mountain Lakes' 'NJ01426'='(NJ01426) Mount Arlington'
                  'NJ01427'='(NJ01427) Mount Olive Township' 'NJ01428'='(NJ01428) Netcong'
                  'NJ01429'='(NJ01429) Parsippany-Troy Hills Tw'
                  'NJ01430'='(NJ01430) Long Hill Township'
                  'NJ01431'='(NJ01431) Pequannock Township'
                  'NJ01432'='(NJ01432) Randolph Township' 'NJ01433'='(NJ01433) Riverdale'
                  'NJ01434'='(NJ01434) Rockaway' 'NJ01435'='(NJ01435) Rockaway Township'
                  'NJ01436'='(NJ01436) Roxbury Township' 'NJ01437'='(NJ01437) Victory Gardens'
                  'NJ01438'='(NJ01438) Washington Township' 'NJ01439'='(NJ01439) Wharton'
                  'NJ01489'='(NJ01489) Prosecutor: Morris Cnty'
                  'NJ01491'='(NJ01491) Park Police: Morris Cnty'
                  'NJ014PT'='(NJ014PT) Spt Morris Co' 'NJ014SP'='(NJ014SP) Sp: Morris County'
                  'NJ01500'='(NJ01500) Ocean' 'NJ01501'='(NJ01501) Barnegat Light'
                  'NJ01502'='(NJ01502) Bay Head' 'NJ01503'='(NJ01503) Beach Haven'
                  'NJ01504'='(NJ01504) Beachwood' 'NJ01505'='(NJ01505) Berkeley Township'
                  'NJ01506'='(NJ01506) Brick Township' 'NJ01507'='(NJ01507) Toms River Township'
                  'NJ01509'='(NJ01509) Harvey Cedars' 'NJ01510'='(NJ01510) Island Heights'
                  'NJ01511'='(NJ01511) Jackson Township' 'NJ01512'='(NJ01512) Lacey Township'
                  'NJ01513'='(NJ01513) Lakehurst' 'NJ01514'='(NJ01514) Lakewood Township'
                  'NJ01515'='(NJ01515) Lavallette' 'NJ01516'='(NJ01516) Little Egg Harbor Townsh'
                  'NJ01517'='(NJ01517) Long Beach Township'
                  'NJ01518'='(NJ01518) Manchester Township' 'NJ01519'='(NJ01519) Mantoloking'
                  'NJ01520'='(NJ01520) Ocean Township' 'NJ01521'='(NJ01521) Ocean Gate'
                  'NJ01522'='(NJ01522) Pine Beach' 'NJ01523'='(NJ01523) Plumsted Township'
                  'NJ01524'='(NJ01524) Point Pleasant' 'NJ01525'='(NJ01525) Point Pleasant Beach'
                  'NJ01526'='(NJ01526) Seaside Heights' 'NJ01527'='(NJ01527) Seaside Park'
                  'NJ01528'='(NJ01528) Ship Bottom' 'NJ01529'='(NJ01529) South Toms River'
                  'NJ01530'='(NJ01530) Stafford Township' 'NJ01531'='(NJ01531) Surf City'
                  'NJ01532'='(NJ01532) Tuckerton' 'NJ01533'='(NJ01533) Barnegat Township'
                  'NJ01589'='(NJ01589) Prosecutor: Ocean County'
                  'NJ01591'='(NJ01591) Park Police: Ocean Cnty'
                  'NJ015PT'='(NJ015PT) Spt Ocean Co' 'NJ015SP'='(NJ015SP) Sp: Ocean County'
                  'NJ01600'='(NJ01600) Passaic' 'NJ01601'='(NJ01601) Bloomingdale'
                  'NJ01602'='(NJ01602) Clifton' 'NJ01603'='(NJ01603) Haledon'
                  'NJ01604'='(NJ01604) Hawthorne' 'NJ01605'='(NJ01605) Little Falls Township'
                  'NJ01606'='(NJ01606) North Haledon' 'NJ01607'='(NJ01607) Passaic'
                  'NJ01608'='(NJ01608) Paterson' 'NJ01609'='(NJ01609) Pompton Lakes'
                  'NJ01610'='(NJ01610) Prospect Park' 'NJ01611'='(NJ01611) Ringwood'
                  'NJ01612'='(NJ01612) Totowa' 'NJ01613'='(NJ01613) Wanaque'
                  'NJ01614'='(NJ01614) Wayne Township'
                  'NJ01615'='(NJ01615) West Milford Township' 'NJ01616'='(NJ01616) West Paterson'
                  'NJ01689'='(NJ01689) Prosecutor: Passaic Cnty'
                  'NJ01691'='(NJ01691) Park Police: Passaic Cty'
                  'NJ016PT'='(NJ016PT) Spt Passaic Co' 'NJ016SP'='(NJ016SP) Sp: Passaic County'
                  'NJ01700'='(NJ01700) Salem' 'NJ01702'='(NJ01702) Elmer'
                  'NJ01703'='(NJ01703) Elsinboro Township'
                  'NJ01704'='(NJ01704) Lower Alloways Creek Tow'
                  'NJ01705'='(NJ01705) Pennsville Township' 'NJ01708'='(NJ01708) Penns Grove'
                  'NJ01712'='(NJ01712) Salem' 'NJ01713'='(NJ01713) Carneys Point Township'
                  'NJ01715'='(NJ01715) Woodstown' 'NJ01789'='(NJ01789) Prosecutor: Salem County'
                  'NJ017PT'='(NJ017PT) Spt Salem Co' 'NJ017SP'='(NJ017SP) Sp: Salem County'
                  'NJ01800'='(NJ01800) Somerset' 'NJ01801'='(NJ01801) Bedminster Township'
                  'NJ01802'='(NJ01802) Bernards Township' 'NJ01803'='(NJ01803) Bernardsville'
                  'NJ01804'='(NJ01804) Bound Brook' 'NJ01805'='(NJ01805) Branchburg Township'
                  'NJ01806'='(NJ01806) Bridgewater Township' 'NJ01807'='(NJ01807) Far Hills'
                  'NJ01808'='(NJ01808) Franklin Twnshp(Somer C)'
                  'NJ01809'='(NJ01809) green Brook Township'
                  'NJ01810'='(NJ01810) Hillsborough Township' 'NJ01811'='(NJ01811) Manville'
                  'NJ01813'='(NJ01813) Montgomery Township'
                  'NJ01814'='(NJ01814) North Plainfield'
                  'NJ01815'='(NJ01815) Peapack And Gladstone' 'NJ01816'='(NJ01816) Raritan'
                  'NJ01818'='(NJ01818) Somerville' 'NJ01819'='(NJ01819) South Bound Brook'
                  'NJ01820'='(NJ01820) Warren Township' 'NJ01821'='(NJ01821) Watchung'
                  'NJ01889'='(NJ01889) Prosecutor: Somerset Cty'
                  'NJ01891'='(NJ01891) Park Police:Somerset Cty'
                  'NJ018PT'='(NJ018PT) Spt Somerset Co' 'NJ018SP'='(NJ018SP) Sp: Somerset County'
                  'NJ01900'='(NJ01900) Sussex' 'NJ01902'='(NJ01902) Andover Township'
                  'NJ01904'='(NJ01904) Byram Township' 'NJ01906'='(NJ01906) Franklin'
                  'NJ01909'='(NJ01909) Hamburg' 'NJ01911'='(NJ01911) Hardyston Township'
                  'NJ01912'='(NJ01912) Hopatcong' 'NJ01915'='(NJ01915) Newton'
                  'NJ01916'='(NJ01916) Ogdensburg' 'NJ01918'='(NJ01918) Sparta Township'
                  'NJ01919'='(NJ01919) Stanhope' 'NJ01920'='(NJ01920) Stillwater Township'
                  'NJ01921'='(NJ01921) Sussex' 'NJ01922'='(NJ01922) Vernon Township'
                  'NJ01989'='(NJ01989) Prosecutor: Sussex Cnty'
                  'NJ019PT'='(NJ019PT) Spt Sussex Co' 'NJ019SP'='(NJ019SP) Sp: Sussex County'
                  'NJ02000'='(NJ02000) Union' 'NJ02001'='(NJ02001) Berkeley Heights Townshi'
                  'NJ02002'='(NJ02002) Clark Township' 'NJ02003'='(NJ02003) Cranford Township'
                  'NJ02004'='(NJ02004) Elizabeth' 'NJ02005'='(NJ02005) Fanwood'
                  'NJ02006'='(NJ02006) Garwood' 'NJ02007'='(NJ02007) Hillside Township'
                  'NJ02008'='(NJ02008) Kenilworth' 'NJ02009'='(NJ02009) Linden'
                  'NJ02010'='(NJ02010) Mountainside' 'NJ02011'='(NJ02011) New Providence'
                  'NJ02012'='(NJ02012) Plainfield' 'NJ02013'='(NJ02013) Rahway'
                  'NJ02014'='(NJ02014) Roselle' 'NJ02015'='(NJ02015) Roselle Park'
                  'NJ02016'='(NJ02016) Scotch Plains Township' 'NJ02017'='(NJ02017) Springfield'
                  'NJ02018'='(NJ02018) Summit' 'NJ02019'='(NJ02019) Union Township'
                  'NJ02020'='(NJ02020) Westfield' 'NJ02021'='(NJ02021) Winfield Township'
                  'NJ02089'='(NJ02089) Prosecutor: Union County'
                  'NJ02091'='(NJ02091) Park Police: Union Cnty'
                  'NJ02092'='(NJ02092) N j Div Of Alcoholic Bev'
                  'NJ020PT'='(NJ020PT) Spt Union Co' 'NJ020SP'='(NJ020SP) Sp: Union County'
                  'NJ02100'='(NJ02100) Warren' 'NJ02102'='(NJ02102) Alpha' 'NJ02103'='(NJ02103) Belvidere'
                  'NJ02104'='(NJ02104) Blairstown Township'
                  'NJ02107'='(NJ02107) Greenwich Township' 'NJ02108'='(NJ02108) Hackettstown'
                  'NJ02112'='(NJ02112) Independence Township'
                  'NJ02113'='(NJ02113) Knowlton Township'
                  'NJ02115'='(NJ02115) Lopatcong Township'
                  'NJ02116'='(NJ02116) Mansfield Township' 'NJ02117'='(NJ02117) Oxford Township'
                  'NJ02119'='(NJ02119) Phillipsburg' 'NJ02120'='(NJ02120) Pohatcong Township'
                  'NJ02121'='(NJ02121) Washington' 'NJ02122'='(NJ02122) Washington Township'
                  'NJ02189'='(NJ02189) Prosecutor: Warren Cnty'
                  'NJ021PT'='(NJ021PT) Spt Warren Co' 'NJ021SP'='(NJ021SP) Sp: Warren County'
                  'NJ02250'='(NJ02250) New Jersey Marine Police'
                  'NJ02251'='(NJ02251) Dept Of I&a Bur Programs'
                  'NJ02254'='(NJ02254) Bureau Of Park Police'
                  'NJDI002'='(NJDI002) Palisades Interstate Pwy' 'NJNPD00'='(NJNPD00) Newark'
                  'NJNSP00'='(NJNSP00) New Jersey State Pol, Hq'
                  'NJNYPOA'='(NJNYPOA) Port Authority Of Ny&Nj' 'NM00100'='(NM00100) Bernalillo'
                  'NM00101'='(NM00101) Albuquerque'
                  'NM00102'='(NM00102) University Of New Mexico' 'NM00200'='(NM00200) Catron'
                  'NM00300'='(NM00300) Chaves' 'NM00301'='(NM00301) Roswell' 'NM00302'='(NM00302) Dexter'
                  'NM00400'='(NM00400) Colfax' 'NM00401'='(NM00401) Raton' 'NM00402'='(NM00402) Cimarron'
                  'NM00403'='(NM00403) Springer' 'NM00405'='(NM00405) Angel Fire'
                  'NM00500'='(NM00500) Curry' 'NM00501'='(NM00501) Clovis' 'NM00502'='(NM00502) Melrose'
                  'NM00503'='(NM00503) Texico' 'NM00600'='(NM00600) De Baca' 'NM00700'='(NM00700) Dona Ana'
                  'NM00701'='(NM00701) Las Cruces' 'NM00703'='(NM00703) Hatch'
                  'NM00704'='(NM00704) New Mexico State Univers' 'NM00705'='(NM00705) Mesilla'
                  'NM00706'='(NM00706) Sunland Park' 'NM00800'='(NM00800) Eddy'
                  'NM00801'='(NM00801) Artesia' 'NM00802'='(NM00802) Carlsbad' 'NM00900'='(NM00900) Grant'
                  'NM00901'='(NM00901) Silver City' 'NM00902'='(NM00902) Bayard'
                  'NM00903'='(NM00903) Santa Clara' 'NM00904'='(NM00904) Hurley'
                  'NM00905'='(NM00905) Western New Mexico Univ' 'NM01000'='(NM01000) Guadalupe'
                  'NM01001'='(NM01001) Santa Rosa' 'NM01002'='(NM01002) Vaughn'
                  'NM01100'='(NM01100) Harding' 'NM01101'='(NM01101) Mosquero'
                  'NM01200'='(NM01200) Hidalgo' 'NM01201'='(NM01201) Lordsburg' 'NM01300'='(NM01300) Lea'
                  'NM01301'='(NM01301) Eunice' 'NM01302'='(NM01302) Hobbs' 'NM01303'='(NM01303) Jal'
                  'NM01304'='(NM01304) Lovington' 'NM01305'='(NM01305) Tatum' 'NM01400'='(NM01400) Lincoln'
                  'NM01401'='(NM01401) Ruidoso' 'NM01402'='(NM01402) Carrizozo'
                  'NM01403'='(NM01403) Ruidoso Downs' 'NM01404'='(NM01404) Capitan'
                  'NM01500'='(NM01500) Los Alamos' 'NM01501'='(NM01501) Los Alamos'
                  'NM01600'='(NM01600) Luna' 'NM01601'='(NM01601) Deming' 'NM01700'='(NM01700) Mckinley'
                  'NM01701'='(NM01701) Gallup' 'NM01703'='(NM01703) Zuni Tribal' 'NM01800'='(NM01800) Mora'
                  'NM01801'='(NM01801) Wagon Mound' 'NM01900'='(NM01900) Otero'
                  'NM01901'='(NM01901) Alamogordo' 'NM01902'='(NM01902) Tularosa'
                  'NM01903'='(NM01903) Cloudcroft' 'NM01904'='(NM01904) Mescalero Apache Tribal'
                  'NM02000'='(NM02000) Quay' 'NM02001'='(NM02001) Tucumcari'
                  'NM02100'='(NM02100) Rio Arriba' 'NM02101'='(NM02101) Espanola'
                  'NM02102'='(NM02102) Chama' 'NM02103'='(NM02103) Jicarilla Tribal'
                  'NM02104'='(NM02104) San Juan Tribal' 'NM02105'='(NM02105) Santa Clara Tribal'
                  'NM02200'='(NM02200) Roosevelt' 'NM02201'='(NM02201) Portales'
                  'NM02202'='(NM02202) Eastern New Mexico Univ' 'NM02300'='(NM02300) Sandoval'
                  'NM02301'='(NM02301) Bernalillo' 'NM02302'='(NM02302) Cuba'
                  'NM02303'='(NM02303) Corrales' 'NM02304'='(NM02304) Jemez Springs'
                  'NM02305'='(NM02305) Cochiti Lake' 'NM02306'='(NM02306) Rio Rancho'
                  'NM02400'='(NM02400) San Juan' 'NM02401'='(NM02401) Aztec'
                  'NM02402'='(NM02402) Farmington' 'NM02403'='(NM02403) Bloomfield'
                  'NM02500'='(NM02500) San Miguel' 'NM02501'='(NM02501) Las Vegas'
                  'NM02502'='(NM02502) Pecos' 'NM02503'='(NM02503) New Mexico Highlands Un'
                  'NM02600'='(NM02600) Santa Fe' 'NM02601'='(NM02601) Santa Fe'
                  'NM02602'='(NM02602) San Ildefonso Pueblo' 'NM02603'='(NM02603) Pojoaque'
                  'NM02700'='(NM02700) Sierra' 'NM02701'='(NM02701) Truth Or Consequences'
                  'NM02800'='(NM02800) Socorro' 'NM02801'='(NM02801) Socorro' 'NM02900'='(NM02900) Taos'
                  'NM02901'='(NM02901) Taos' 'NM02902'='(NM02902) Questa' 'NM02903'='(NM02903) Red River'
                  'NM02904'='(NM02904) Taos Pueblo Tribal' 'NM02905'='(NM02905) Taos Ski Valley'
                  'NM03000'='(NM03000) Torrance' 'NM03001'='(NM03001) Encino'
                  'NM03002'='(NM03002) Estancia' 'NM03003'='(NM03003) Moriarty'
                  'NM03004'='(NM03004) Mountainair' 'NM03100'='(NM03100) Union'
                  'NM03101'='(NM03101) Clayton' 'NM03200'='(NM03200) Valencia' 'NM03201'='(NM03201) Belen'
                  'NM03202'='(NM03202) Grants' 'NM03203'='(NM03203) Los Lunas' 'NM03204'='(NM03204) Milan'
                  'NM03205'='(NM03205) Laguna Tribal' 'NM03206'='(NM03206) Acoma Tribal'
                  'NM03207'='(NM03207) Bosque Farms' 'NM03300'='(NM03300) Cibola'
                  'NMNSP00'='(NMNSP00) New Mexico State Police' 'NV00100'='(NV00100) Churchill'
                  'NV00101'='(NV00101) Fallon' 'NV00200'='(NV00200) Clark'
                  'NV00201'='(NV00201) Las Vegas Metro Pd' 'NV00202'='(NV00202) North Las Vegas'
                  'NV00203'='(NV00203) Henderson' 'NV00204'='(NV00204) Boulder City'
                  'NV00207'='(NV00207) Taxicab Authority' 'NV00209'='(NV00209) Mesquite'
                  'NV00210'='(NV00210) Univ Of Nevada:Las Vegas'
                  'NV00216'='(NV00216) Clark County School Dist' 'NV00300'='(NV00300) Douglas'
                  'NV00400'='(NV00400) Elko' 'NV00401'='(NV00401) Elko' 'NV00402'='(NV00402) Carlin'
                  'NV00403'='(NV00403) Wells' 'NV00405'='(NV00405) West Wendover'
                  'NV00500'='(NV00500) Esmeralda' 'NV00600'='(NV00600) Eureka'
                  'NV00700'='(NV00700) Humboldt' 'NV00701'='(NV00701) Winnemucca'
                  'NV00800'='(NV00800) Lander' 'NV00900'='(NV00900) Lincoln' 'NV00901'='(NV00901) Caliente'
                  'NV01000'='(NV01000) Lyon' 'NV01001'='(NV01001) Yerington' 'NV01100'='(NV01100) Mineral'
                  'NV01200'='(NV01200) Nye' 'NV01300'='(NV01300) Carson City'
                  'NV01399'='(NV01399) Nevada Highway Patrol' 'NV01400'='(NV01400) Pershing'
                  'NV01401'='(NV01401) Lovelock' 'NV01500'='(NV01500) Storey' 'NV01600'='(NV01600) Washoe'
                  'NV01601'='(NV01601) Reno' 'NV01602'='(NV01602) Sparks'
                  'NV01603'='(NV01603) Univ Of Nevada: Reno'
                  'NV01610'='(NV01610) Washoe County Sch Distri'
                  'NV01615'='(NV01615) Truckee Meadows Comm Col' 'NV01700'='(NV01700) White Pine'
                  'NV01701'='(NV01701) Ely' 'NY00100'='(NY00100) Albany' 'NY00101'='(NY00101) Albany'
                  'NY00102'='(NY00102) Cohoes' 'NY00103'='(NY00103) Watervliet'
                  'NY00120'='(NY00120) Green Island Village'
                  'NY00121'='(NY00121) Altamont Village' 'NY00123'='(NY00123) Ravena Village'
                  'NY00125'='(NY00125) Menands Village' 'NY00151'='(NY00151) Bethlehem Town'
                  'NY00152'='(NY00152) Guilderland Town' 'NY00153'='(NY00153) Colonie Town'
                  'NY00154'='(NY00154) Capitol Police' 'NY00158'='(NY00158) Coeymans Town'
                  'NY00200'='(NY00200) Allegany' 'NY00220'='(NY00220) Alfred Village'
                  'NY00222'='(NY00222) Andover Village' 'NY00223'='(NY00223) Angelica Village'
                  'NY00224'='(NY00224) Bolivar Village' 'NY00225'='(NY00225) Canaseraga Village'
                  'NY00226'='(NY00226) Cuba Town' 'NY00227'='(NY00227) Friendship'
                  'NY00228'='(NY00228) Wellsville Village' 'NY00229'='(NY00229) Richburg Village'
                  'NY00230'='(NY00230) Almond Town And Village' 'NY00231'='(NY00231) Burns Town'
                  'NY00250'='(NY00250) Friendship Town'
                  'NY00254'='(NY00254) Amity Town & Belmont Vil' 'NY00255'='(NY00255) Wirt Town'
                  'NY00270'='(NY00270) Independence Town' 'NY00272'='(NY00272) Rushford Town'
                  'NY00300'='(NY00300) Broome' 'NY00301'='(NY00301) Binghamton'
                  'NY00302'='(NY00302) Endicott Village'
                  'NY00303'='(NY00303) Johnson City Village'
                  'NY00306'='(NY00306) Broome Cnty Spcl Inv Tf'
                  'NY00320'='(NY00320) Port Dickinson Village'
                  'NY00322'='(NY00322) Deposit Village' 'NY00327'='(NY00327) Windsor Town'
                  'NY00364'='(NY00364) Vestal Town' 'NY00365'='(NY00365) Whitney Point Village'
                  'NY00400'='(NY00400) Cattaraugus' 'NY00401'='(NY00401) Olean'
                  'NY00420'='(NY00420) Allegany Village' 'NY00423'='(NY00423) Ellicottville'
                  'NY00424'='(NY00424) Franklinville Village'
                  'NY00425'='(NY00425) Little Valley Village'
                  'NY00426'='(NY00426) Cattaraugus Village'
                  'NY00428'='(NY00428) Portville Village' 'NY00429'='(NY00429) Randolph Town'
                  'NY00430'='(NY00430) South Dayton Village' 'NY00433'='(NY00433) Salamanca'
                  'NY00463'='(NY00463) Perrysburg Town' 'NY00464'='(NY00464) Little Valley Town'
                  'NY00500'='(NY00500) Cayuga' 'NY00501'='(NY00501) Auburn'
                  'NY00520'='(NY00520) Cayuga Village' 'NY00521'='(NY00521) Weedsport Village'
                  'NY00522'='(NY00522) Port Byron Village' 'NY00526'='(NY00526) Moravia Village'
                  'NY00527'='(NY00527) Fair Haven Village' 'NY00600'='(NY00600) Chautauqua'
                  'NY00601'='(NY00601) Dunkirk' 'NY00602'='(NY00602) Jamestown'
                  'NY00620'='(NY00620) Lakewood-Busti'
                  'NY00621'='(NY00621) Sinclairville Village'
                  'NY00622'='(NY00622) Mayville Village' 'NY00623'='(NY00623) Cherry Creek Town'
                  'NY00624'='(NY00624) Celoron Village' 'NY00625'='(NY00625) Falconer Village'
                  'NY00627'='(NY00627) Silver Creek Village'
                  'NY00629'='(NY00629) Fredonia Village' 'NY00630'='(NY00630) Brocton Village'
                  'NY00631'='(NY00631) Sherman Village' 'NY00632'='(NY00632) Westfield Village'
                  'NY00633'='(NY00633) Bemus Point Village'
                  'NY00635'='(NY00635) Cassadaga Village' 'NY00651'='(NY00651) Busti Town'
                  'NY00652'='(NY00652) Carroll Town' 'NY00659'='(NY00659) Ellicott Town'
                  'NY00663'='(NY00663) Hanover Town' 'NY00671'='(NY00671) Sheridan Town'
                  'NY00672'='(NY00672) Sherman Town' 'NY00700'='(NY00700) Chemung'
                  'NY00701'='(NY00701) Elmira' 'NY00721'='(NY00721) Elmira Heights Village'
                  'NY00722'='(NY00722) Horseheads Village' 'NY00725'='(NY00725) West Elmira'
                  'NY00755'='(NY00755) Elmira Town' 'NY00758'='(NY00758) Southport Town'
                  'NY00800'='(NY00800) Chenango' 'NY00820'='(NY00820) Afton Village'
                  'NY00821'='(NY00821) Bainbridge Village' 'NY00822'='(NY00822) Greene Village'
                  'NY00823'='(NY00823) New Berlin Village' 'NY00824'='(NY00824) Norwich'
                  'NY00825'='(NY00825) Oxford Village' 'NY00827'='(NY00827) Sherburne Village'
                  'NY00828'='(NY00828) New Berlin Town'
                  'NY00863'='(NY00863) Oxford Town And Village' 'NY00900'='(NY00900) Clinton'
                  'NY00901'='(NY00901) Plattsburgh City' 'NY00920'='(NY00920) Keeseville Village'
                  'NY00921'='(NY00921) Champlain Village'
                  'NY00922'='(NY00922) Rouses Point Village' 'NY00923'='(NY00923) Dannemora'
                  'NY01000'='(NY01000) Columbia' 'NY01001'='(NY01001) Hudson'
                  'NY01002'='(NY01002) Philmont Village' 'NY01003'='(NY01003) Greenport Town'
                  'NY01004'='(NY01004) Germantown Town' 'NY01005'='(NY01005) Stockport Town'
                  'NY01006'='(NY01006) Columbia Co Conrail Ra'
                  'NY01020'='(NY01020) Chatham Village' 'NY01024'='(NY01024) Stuyvesant'
                  'NY01025'='(NY01025) Stockport Town' 'NY01050'='(NY01050) Copake Town'
                  'NY01051'='(NY01051) Livingston' 'NY01100'='(NY01100) Cortland'
                  'NY01101'='(NY01101) Cortland' 'NY01120'='(NY01120) Homer Village'
                  'NY01121'='(NY01121) Mcgraw Village'
                  'NY01122'='(NY01122) Marathon Town And Villag' 'NY01200'='(NY01200) Delaware'
                  'NY01221'='(NY01221) Delhi Village' 'NY01224'='(NY01224) Hancock Village'
                  'NY01227'='(NY01227) Sidney Village' 'NY01229'='(NY01229) Walton Village'
                  'NY01242'='(NY01242) Colchester Town' 'NY01300'='(NY01300) Dutchess'
                  'NY01301'='(NY01301) Beacon' 'NY01302'='(NY01302) Poughkeepsie'
                  'NY01303'='(NY01303) Arlington' 'NY01304'='(NY01304) Dutchess Co Conrail Ra'
                  'NY01320'='(NY01320) Fishkill Village' 'NY01322'='(NY01322) Pawling Village'
                  'NY01324'='(NY01324) Wappingers Falls Village'
                  'NY01325'='(NY01325) Red Hook Village' 'NY01326'='(NY01326) Tivoli Village'
                  'NY01327'='(NY01327) Rhinebeck Village' 'NY01328'='(NY01328) Millbrook Village'
                  'NY01350'='(NY01350) Pine Plains Town'
                  'NY01359'='(NY01359) Northeast T& millerton V'
                  'NY01363'='(NY01363) poughkeepsie Town' 'NY01364'='(NY01364) Fishkill Town'
                  'NY01365'='(NY01365) Hyde Park Town' 'NY01366'='(NY01366) East Fishkill Town'
                  'NY01375'='(NY01375) Nycmta: Dutchess County'
                  'NY01390'='(NY01390) State Park: Taconic Reg' 'NY01400'='(NY01400) Erie'
                  'NY01401'='(NY01401) Buffalo' 'NY01402'='(NY01402) Lackawanna'
                  'NY01403'='(NY01403) Tonawanda' 'NY01404'='(NY01404) Kenmore Village'
                  'NY01420'='(NY01420) Alden' 'NY01422'='(NY01422) East Aurora-Aurora Town'
                  'NY01424'='(NY01424) Depew Village' 'NY01425'='(NY01425) Sloan'
                  'NY01426'='(NY01426) Gowanda Village' 'NY01427'='(NY01427) Springville'
                  'NY01428'='(NY01428) Angola Village' 'NY01429'='(NY01429) Blasdell Village'
                  'NY01430'='(NY01430) Hamburg Village' 'NY01431'='(NY01431) Lancaster Village'
                  'NY01432'='(NY01432) Akron Village' 'NY01451'='(NY01451) Amherst Town'
                  'NY01452'='(NY01452) Aurora Town-East Aurora' 'NY01453'='(NY01453) Boston Town'
                  'NY01454'='(NY01454) Brant Town' 'NY01455'='(NY01455) Cheektowaga Town'
                  'NY01460'='(NY01460) Orchard Park Town' 'NY01461'='(NY01461) Eden Town'
                  'NY01463'='(NY01463) Evans Town' 'NY01464'='(NY01464) Grand Island'
                  'NY01465'='(NY01465) Hamburg Town' 'NY01466'='(NY01466) Holland'
                  'NY01467'='(NY01467) Lancaster Town' 'NY01470'='(NY01470) North Collins'
                  'NY01472'='(NY01472) Tonawanda Town' 'NY01474'='(NY01474) West Seneca Town'
                  'NY01475'='(NY01475) Williamsville' 'NY01500'='(NY01500) Essex'
                  'NY01522'='(NY01522) Port Henry Village'
                  'NY01523'='(NY01523) Lake Placid Village'
                  'NY01527'='(NY01527) Ticonderoga Town' 'NY01551'='(NY01551) Moriah Town'
                  'NY01566'='(NY01566) Willsboro' 'NY01567'='(NY01567) Crown Point'
                  'NY01600'='(NY01600) Franklin' 'NY01620'='(NY01620) Tupper Lake Village'
                  'NY01623'='(NY01623) Saranac Lake Village' 'NY01624'='(NY01624) Malone Village'
                  'NY01625'='(NY01625) Akwesasne' 'NY01700'='(NY01700) Fulton'
                  'NY01701'='(NY01701) Gloversville' 'NY01702'='(NY01702) Johnstown'
                  'NY01721'='(NY01721) Northville Village' 'NY01724'='(NY01724) Mayfield Village'
                  'NY01800'='(NY01800) Genesee' 'NY01801'='(NY01801) Batavia'
                  'NY01823'='(NY01823) Le Roy Village' 'NY01825'='(NY01825) Corfu Village'
                  'NY01900'='(NY01900) Greene' 'NY01920'='(NY01920) Athens Village'
                  'NY01921'='(NY01921) Catskill Village' 'NY01922'='(NY01922) Coxsackie Village'
                  'NY01924'='(NY01924) Greenville Town' 'NY01925'='(NY01925) Windham Town'
                  'NY01930'='(NY01930) New Baltimore Town' 'NY01950'='(NY01950) Hunter Town'
                  'NY01951'='(NY01951) Durham Town' 'NY01952'='(NY01952) Cairo Town'
                  'NY02000'='(NY02000) Hamilton' 'NY02050'='(NY02050) Inlet Town'
                  'NY02100'='(NY02100) Herkimer' 'NY02121'='(NY02121) Frankfort Village'
                  'NY02122'='(NY02122) Ilion Village' 'NY02123'='(NY02123) Mohawk Village'
                  'NY02124'='(NY02124) Herkimer Village' 'NY02125'='(NY02125) Dolgeville Village'
                  'NY02129'='(NY02129) Little Falls' 'NY02130'='(NY02130) West Winfield'
                  'NY02167'='(NY02167) Webb Town' 'NY02168'='(NY02168) Frankfort Town'
                  'NY02200'='(NY02200) Jefferson' 'NY02201'='(NY02201) Watertown'
                  'NY02220'='(NY02220) Adams Village'
                  'NY02221'='(NY02221) Alexandria Bay Village'
                  'NY02223'='(NY02223) Brownville Village' 'NY02224'='(NY02224) Dexter Village'
                  'NY02225'='(NY02225) Glen Park Village'
                  'NY02226'='(NY02226) Cape Vincent Village'
                  'NY02227'='(NY02227) West Carthage Village'
                  'NY02228'='(NY02228) Clayton Village'
                  'NY02233'='(NY02233) Sackets Harbor Village'
                  'NY02237'='(NY02237) Theresa Village' 'NY02238'='(NY02238) Carthage Village'
                  'NY02240'='(NY02240) Deferiet Village' 'NY02243'='(NY02243) Antwerp Village'
                  'NY02250'='(NY02250) Henderson' 'NY02300'='(NY02300) Kings'
                  'NY02340'='(NY02340) New York City Trans Auth'
                  'NY02370'='(NY02370) Port Auth: Kings County'
                  'NY02375'='(NY02375) Nycmta: Kings County' 'NY02400'='(NY02400) Lewis'
                  'NY02420'='(NY02420) Croghan Village' 'NY02422'='(NY02422) Harrisville'
                  'NY02424'='(NY02424) Lowville Village'
                  'NY02425'='(NY02425) Lyons Falls Village' 'NY02450'='(NY02450) Port Leyden'
                  'NY02500'='(NY02500) Livingston' 'NY02520'='(NY02520) Avon Village'
                  'NY02521'='(NY02521) Caledonia Village' 'NY02522'='(NY02522) Geneseo Village'
                  'NY02526'='(NY02526) Mount Morris Village'
                  'NY02527'='(NY02527) Dansville Village' 'NY02528'='(NY02528) Nunda'
                  'NY02560'='(NY02560) Nunda Town And Village' 'NY02600'='(NY02600) Madison'
                  'NY02601'='(NY02601) Oneida' 'NY02621'='(NY02621) Cazenovia Village'
                  'NY02625'='(NY02625) Hamilton Village' 'NY02626'='(NY02626) Canastota Village'
                  'NY02629'='(NY02629) Chittenango Village'
                  'NY02630'='(NY02630) Earlville Village' 'NY02700'='(NY02700) Monroe'
                  'NY02701'='(NY02701) Rochester' 'NY02702'='(NY02702) Irondequoit Town'
                  'NY02703'='(NY02703) Wheatland Town'
                  'NY02724'='(NY02724) East Rochester Village'
                  'NY02725'='(NY02725) Fairport Village' 'NY02728'='(NY02728) Brockport Village'
                  'NY02750'='(NY02750) Brighton Town' 'NY02753'='(NY02753) Gates Town'
                  'NY02754'='(NY02754) Greece Town' 'NY02759'='(NY02759) Ogden Town'
                  'NY02767'='(NY02767) Webster Town & Village'
                  'NY02768'='(NY02768) Webster Village' 'NY02800'='(NY02800) Montgomery'
                  'NY02801'='(NY02801) Amsterdam' 'NY02822'='(NY02822) Canajoharie Village'
                  'NY02824'='(NY02824) Fort Plain Village'
                  'NY02828'='(NY02828) St. Johnsville Village' 'NY02900'='(NY02900) Nassau'
                  'NY02901'='(NY02901) Glen Cove' 'NY02902'='(NY02902) Long Beach'
                  'NY02903'='(NY02903) Floral Park Village'
                  'NY02904'='(NY02904) Freeport Village'
                  'NY02905'='(NY02905) Garden City Village'
                  'NY02906'='(NY02906) Hempstead Village' 'NY02907'='(NY02907) Lynbrook Village'
                  'NY02908'='(NY02908) Bayville' 'NY02909'='(NY02909) Rockville Centre Village'
                  'NY02910'='(NY02910) Cedarhurst' 'NY02911'='(NY02911) East Hills'
                  'NY02912'='(NY02912) East Rockaway' 'NY02913'='(NY02913) East Williston'
                  'NY02914'='(NY02914) Farmingdale' 'NY02915'='(NY02915) Flower Hill'
                  'NY02916'='(NY02916) Great Neck Village' 'NY02917'='(NY02917) Great Neck Plaza'
                  'NY02918'='(NY02918) Island Park' 'NY02919'='(NY02919) Lawrence'
                  'NY02920'='(NY02920) Manorhaven' 'NY02921'='(NY02921) Massapequa Park'
                  'NY02922'='(NY02922) Mineola' 'NY02923'='(NY02923) Munsey Park'
                  'NY02924'='(NY02924) New Hyde Park' 'NY02925'='(NY02925) Roslyn'
                  'NY02926'='(NY02926) Sea Cliff' 'NY02927'='(NY02927) Thomaston'
                  'NY02928'='(NY02928) Valley Stream' 'NY02929'='(NY02929) Westbury'
                  'NY02930'='(NY02930) Williston Park' 'NY02931'='(NY02931) Mill Neck Village'
                  'NY02932'='(NY02932) Plandome Village'
                  'NY02933'='(NY02933) Great Neck Estates Villa'
                  'NY02935'='(NY02935) Sands Point Village'
                  'NY02939'='(NY02939) Malverne Village' 'NY02941'='(NY02941) Kensington Village'
                  'NY02942'='(NY02942) Bellerose' 'NY02943'='(NY02943) Old Westbury Village'
                  'NY02944'='(NY02944) Kings Point Village'
                  'NY02947'='(NY02947) Centre Island Village'
                  'NY02949'='(NY02949) Laurel Hollow Village'
                  'NY02955'='(NY02955) Port Washington' 'NY02962'='(NY02962) Cove Neck Village'
                  'NY02963'='(NY02963) Lake Success Village'
                  'NY02972'='(NY02972) Old Brookville Village'
                  'NY02975'='(NY02975) Nycmta: Nassau County'
                  'NY02988'='(NY02988) Oyster Bay Cove Village'
                  'NY02993'='(NY02993) Us Merchant Marine Acade' 'NY03000'='(NY03000) New York'
                  'NY03001'='(NY03001) New York Co Conrail Ra' 'NY03030'='(NY03030) New York'
                  'NY03070'='(NY03070) Port Auth: New York Cnty'
                  'NY03075'='(NY03075) Nycmta: New York County' 'NY03100'='(NY03100) Niagara'
                  'NY03101'='(NY03101) Lockport' 'NY03102'='(NY03102) Niagara Falls'
                  'NY03103'='(NY03103) North Tonawanda' 'NY03120'='(NY03120) Middleport Village'
                  'NY03121'='(NY03121) Lewiston Town & Village'
                  'NY03123'='(NY03123) Youngstown Village'
                  'NY03154'='(NY03154) Lewiston Town & Village'
                  'NY03155'='(NY03155) Niagara Town' 'NY03200'='(NY03200) Oneida'
                  'NY03201'='(NY03201) Rome' 'NY03202'='(NY03202) Utica'
                  'NY03221'='(NY03221) Boonville Village' 'NY03223'='(NY03223) Camden Village'
                  'NY03224'='(NY03224) Sherrill' 'NY03225'='(NY03225) Clinton Village'
                  'NY03226'='(NY03226) Waterville Village'
                  'NY03227'='(NY03227) New Hartford Village' 'NY03231'='(NY03231) Vernon Village'
                  'NY03237'='(NY03237) Whitesboro Village'
                  'NY03238'='(NY03238) Yorkville Village' 'NY03239'='(NY03239) Oriskany Village'
                  'NY03240'='(NY03240) New York Mills Village'
                  'NY03241'='(NY03241) New Hartford Town & Vill'
                  'NY03250'='(NY03250) Whitestown Town' 'NY03251'='(NY03251) Kirkland Town'
                  'NY03300'='(NY03300) Onondaga' 'NY03301'='(NY03301) Syracuse'
                  'NY03321'='(NY03321) East Syracuse Village'
                  'NY03324'='(NY03324) Jordan Village' 'NY03326'='(NY03326) Solvay Village'
                  'NY03327'='(NY03327) Baldwinsville Village' 'NY03328'='(NY03328) Fayetteville'
                  'NY03329'='(NY03329) Manlius Town' 'NY03330'='(NY03330) Marcellus Village'
                  'NY03331'='(NY03331) Liverpool Village'
                  'NY03332'='(NY03332) Skaneateles Village' 'NY03334'='(NY03334) Minoa'
                  'NY03335'='(NY03335) North Syracuse Village'
                  'NY03350'='(NY03350) Camillus Town And Villag'
                  'NY03351'='(NY03351) Cicero Town' 'NY03352'='(NY03352) Clay Town'
                  'NY03353'='(NY03353) Dewitt Town' 'NY03356'='(NY03356) Geddes Town'
                  'NY03370'='(NY03370) Onondaga Co Park Rangers' 'NY03400'='(NY03400) Ontario'
                  'NY03402'='(NY03402) Geneva' 'NY03421'='(NY03421) Clifton Springs Village'
                  'NY03422'='(NY03422) Manchester Village'
                  'NY03423'='(NY03423) Shortsville Village'
                  'NY03424'='(NY03424) Naples Town And Village'
                  'NY03425'='(NY03425) Phelps Village' 'NY03429'='(NY03429) Canandaigua'
                  'NY03500'='(NY03500) Orange' 'NY03501'='(NY03501) Middletown'
                  'NY03502'='(NY03502) Newburgh' 'NY03520'='(NY03520) Washingtonville Village'
                  'NY03521'='(NY03521) Chester Village'
                  'NY03522'='(NY03522) Cornwall-On-Hudson Villa'
                  'NY03523'='(NY03523) Goshen Village'
                  'NY03524'='(NY03524) Highland Falls Village'
                  'NY03526'='(NY03526) Monroe Village' 'NY03527'='(NY03527) Montgomery Village'
                  'NY03528'='(NY03528) Walden Village' 'NY03529'='(NY03529) Warwick Village'
                  'NY03532'='(NY03532) Maybrook Village'
                  'NY03533'='(NY03533) Greenwood Lake Village'
                  'NY03534'='(NY03534) Florida Village' 'NY03535'='(NY03535) Port Jervis'
                  'NY03536'='(NY03536) Tuxedo Park Village'
                  'NY03537'='(NY03537) Harriman Village' 'NY03550'='(NY03550) Mount Hope Town'
                  'NY03552'='(NY03552) Cornwall Town' 'NY03558'='(NY03558) Highlands Town'
                  'NY03563'='(NY03563) Newburgh Town' 'NY03565'='(NY03565) Tuxedo Town'
                  'NY03567'='(NY03567) New Windsor Town' 'NY03569'='(NY03569) Woodbury Town'
                  'NY03570'='(NY03570) Warwick Town' 'NY03571'='(NY03571) Deerpark Town'
                  'NY03573'='(NY03573) Blooming Grove Town' 'NY03574'='(NY03574) Montgomery Town'
                  'NY03575'='(NY03575) Nycmta: Orange County' 'NY03576'='(NY03576) Crawford Town'
                  'NY03577'='(NY03577) Chester Town' 'NY03578'='(NY03578) Wallkill Town'
                  'NY03581'='(NY03581) Goshen Town' 'NY03600'='(NY03600) Orleans'
                  'NY03620'='(NY03620) Albion Village' 'NY03621'='(NY03621) Holley Village'
                  'NY03622'='(NY03622) Medina Village' 'NY03623'='(NY03623) Lyndonville Village'
                  'NY03659'='(NY03659) Yates Town' 'NY03700'='(NY03700) Oswego'
                  'NY03701'='(NY03701) Fulton City' 'NY03702'='(NY03702) Oswego City'
                  'NY03721'='(NY03721) Cleveland Village'
                  'NY03723'='(NY03723) Central Square Village' 'NY03724'='(NY03724) Mexico Town'
                  'NY03726'='(NY03726) Pulaski Village' 'NY03729'='(NY03729) Phoenix Village'
                  'NY03753'='(NY03753) Constantia Town' 'NY03762'='(NY03762) Parish Town'
                  'NY03800'='(NY03800) Otsego' 'NY03801'='(NY03801) Oneonta City'
                  'NY03821'='(NY03821) Cherry Valley Village'
                  'NY03824'='(NY03824) Cooperstown Village'
                  'NY03828'='(NY03828) Richfield Springs Villag' 'NY03850'='(NY03850) Roseboom'
                  'NY03890'='(NY03890) Unadilla Village' 'NY03900'='(NY03900) Putnam'
                  'NY03901'='(NY03901) Putnam Co Conrail Ra'
                  'NY03920'='(NY03920) Cold Spring Village'
                  'NY03921'='(NY03921) Nelsonville Village' 'NY03922'='(NY03922) Brewster'
                  'NY03950'='(NY03950) Carmel Town' 'NY03951'='(NY03951) Kent Town'
                  'NY03954'='(NY03954) Putnam Valley Town'
                  'NY03975'='(NY03975) Nycmta: Putnam County' 'NY04000'='(NY04000) Queens'
                  'NY04070'='(NY04070) Port Auth: Queens County'
                  'NY04075'='(NY04075) Nycmta: Queens County' 'NY04100'='(NY04100) Rensselaer'
                  'NY04101'='(NY04101) Rensselaer City' 'NY04102'='(NY04102) Troy'
                  'NY04103'='(NY04103) Rensselaer Co Conrail Ra'
                  'NY04120'='(NY04120) Hoosick Falls Village'
                  'NY04121'='(NY04121) Nassau Village'
                  'NY04124'='(NY04124) Castleton On Hudson Vill'
                  'NY04152'='(NY04152) East Greenbush Town'
                  'NY04153'='(NY04153) North Greenbush Town' 'NY04154'='(NY04154) Schodack Town'
                  'NY04156'='(NY04156) Poestenkill Town' 'NY04190'='(NY04190) Sand Lake Town'
                  'NY04200'='(NY04200) Richmond' 'NY04260'='(NY04260) Staten Island Rapid Tran'
                  'NY04270'='(NY04270) Port Auth: Richmond Cnty'
                  'NY04275'='(NY04275) Nycmta: Richmond County' 'NY04300'='(NY04300) Rockland'
                  'NY04301'='(NY04301) Upper Nyack Village'
                  'NY04302'='(NY04302) West Haverstraw Village'
                  'NY04321'='(NY04321) Haverstraw Village'
                  'NY04323'='(NY04323) Grand View-On-Hudson Vil'
                  'NY04324'='(NY04324) Nyack Village' 'NY04325'='(NY04325) Piermont Village'
                  'NY04326'='(NY04326) South Nyack Village'
                  'NY04328'='(NY04328) Spring Valley Village'
                  'NY04329'='(NY04329) Suffern Village' 'NY04330'='(NY04330) Sloatsburg Village'
                  'NY04350'='(NY04350) Clarkstown Town' 'NY04351'='(NY04351) Haverstraw Town'
                  'NY04352'='(NY04352) Orangetown Town' 'NY04353'='(NY04353) Ramapo Town'
                  'NY04354'='(NY04354) Stony Point Town'
                  'NY04375'='(NY04375) Nycmta: Rockland County'
                  'NY04390'='(NY04390) Palisades Int. Park' 'NY04400'='(NY04400) St. Lawrence'
                  'NY04401'='(NY04401) Ogdensburg' 'NY04402'='(NY04402) Massena Village'
                  'NY04420'='(NY04420) Canton Village' 'NY04423'='(NY04423) Gouverneur Village'
                  'NY04428'='(NY04428) Norwood Village' 'NY04429'='(NY04429) Potsdam Village'
                  'NY04430'='(NY04430) Waddington' 'NY04451'='(NY04451) Norfolk Town'
                  'NY04500'='(NY04500) Saratoga' 'NY04501'='(NY04501) Saratoga Springs'
                  'NY04520'='(NY04520) Ballston Spa Village'
                  'NY04521'='(NY04521) Corinth Village' 'NY04523'='(NY04523) Mechanicville'
                  'NY04524'='(NY04524) South Glens Falls Villag'
                  'NY04525'='(NY04525) Schuylerville Village'
                  'NY04530'='(NY04530) Stillwater Village' 'NY04551'='(NY04551) Charlton Town'
                  'NY04568'='(NY04568) Waterford Town & Village'
                  'NY04570'='(NY04570) Stillwater Town' 'NY04571'='(NY04571) Galway Town'
                  'NY04600'='(NY04600) Schenectady' 'NY04601'='(NY04601) Schenectady'
                  'NY04620'='(NY04620) Scotia Village' 'NY04651'='(NY04651) Glenville Town'
                  'NY04652'='(NY04652) Niskayuna Town' 'NY04654'='(NY04654) Rotterdam Town'
                  'NY04700'='(NY04700) Schoharie' 'NY04720'='(NY04720) Cobleskill Village'
                  'NY04722'='(NY04722) Middleburgh Village'
                  'NY04723'='(NY04723) Richmondville Village'
                  'NY04724'='(NY04724) Schoharie Village'
                  'NY04725'='(NY04725) Sharon Springs Village' 'NY04800'='(NY04800) Schuyler'
                  'NY04821'='(NY04821) Watkins Glen Village' 'NY04900'='(NY04900) Seneca'
                  'NY04920'='(NY04920) Interlaken Village' 'NY04921'='(NY04921) Waterloo Village'
                  'NY04923'='(NY04923) Seneca Falls Village' 'NY04924'='(NY04924) Ovid Village'
                  'NY05000'='(NY05000) Steuben' 'NY05001'='(NY05001) Corning' 'NY05002'='(NY05002) Hornell'
                  'NY05020'='(NY05020) Addison Town And Village'
                  'NY05021'='(NY05021) Avoca Village' 'NY05022'='(NY05022) Bath Village'
                  'NY05024'='(NY05024) Canisteo Village' 'NY05025'='(NY05025) Cohocton Town'
                  'NY05026'='(NY05026) Painted Post Village'
                  'NY05028'='(NY05028) Hammondsport Village'
                  'NY05029'='(NY05029) Wayland Village' 'NY05030'='(NY05030) Woodhull Village'
                  'NY05031'='(NY05031) Arkport Village'
                  'NY05034'='(NY05034) North Hornell Village' 'NY05050'='(NY05050) Erwin Town'
                  'NY05051'='(NY05051) Avoca Town And Village'
                  'NY05077'='(NY05077) Hornellsville Town' 'NY05100'='(NY05100) Suffolk'
                  'NY05101'='(NY05101) Suffolk County Pd' 'NY05102'='(NY05102) Babylon Town'
                  'NY05103'='(NY05103) Babylon Village' 'NY05104'='(NY05104) Bellport Village'
                  'NY05105'='(NY05105) Brightwaters Village' 'NY05106'='(NY05106) Brookhaven'
                  'NY05107'='(NY05107) Huntington' 'NY05108'='(NY05108) Islip'
                  'NY05109'='(NY05109) Lindenhurst Village' 'NY05110'='(NY05110) Patchogue'
                  'NY05111'='(NY05111) Port Jefferson' 'NY05120'='(NY05120) Amityville Village'
                  'NY05124'='(NY05124) Sag Harbor Village'
                  'NY05125'='(NY05125) Northport Village'
                  'NY05126'='(NY05126) Southampton Village'
                  'NY05127'='(NY05127) Greenport Village' 'NY05130'='(NY05130) Saltaire Village'
                  'NY05132'='(NY05132) East Hampton Village'
                  'NY05133'='(NY05133) Ocean Beach Village'
                  'NY05136'='(NY05136) Huntington Bay Village'
                  'NY05137'='(NY05137) Lloyd Harbor Village' 'NY05139'='(NY05139) Quogue Village'
                  'NY05140'='(NY05140) Westhampton Beach Villag'
                  'NY05141'='(NY05141) Nissequogue Village'
                  'NY05144'='(NY05144) Asharoken Village'
                  'NY05146'='(NY05146) Head Of The Harbor Villa'
                  'NY05152'='(NY05152) East Hampton Town' 'NY05155'='(NY05155) Riverhead Town'
                  'NY05156'='(NY05156) Shelter Island Town'
                  'NY05158'='(NY05158) Southampton Town' 'NY05159'='(NY05159) Southold Town'
                  'NY05160'='(NY05160) Suffolk Co Park Rangers'
                  'NY05175'='(NY05175) Nycmta: Suffolk County' 'NY05200'='(NY05200) Sullivan'
                  'NY05220'='(NY05220) Liberty Village' 'NY05222'='(NY05222) Monticello Village'
                  'NY05223'='(NY05223) Woodridge Village' 'NY05224'='(NY05224) Wurtsboro'
                  'NY05254'='(NY05254) Fallsburg Town' 'NY05260'='(NY05260) Mamakating Town'
                  'NY05263'='(NY05263) Rockland Town' 'NY05300'='(NY05300) Tioga'
                  'NY05320'='(NY05320) Waverly Village' 'NY05321'='(NY05321) Candor Village'
                  'NY05322'='(NY05322) Newark Valley' 'NY05323'='(NY05323) Nichols Village'
                  'NY05324'='(NY05324) Owego Village' 'NY05325'='(NY05325) Spencer'
                  'NY05400'='(NY05400) Tompkins' 'NY05401'='(NY05401) Ithaca'
                  'NY05420'='(NY05420) Dryden Village' 'NY05421'='(NY05421) Freeville Village'
                  'NY05422'='(NY05422) Groton Village' 'NY05424'='(NY05424) Trumansburg Village'
                  'NY05425'='(NY05425) Cayuga Heights Village' 'NY05500'='(NY05500) Ulster'
                  'NY05501'='(NY05501) Kingston' 'NY05502'='(NY05502) Highland'
                  'NY05522'='(NY05522) New Paltz' 'NY05524'='(NY05524) Saugerties Village'
                  'NY05526'='(NY05526) Ellenville Village'
                  'NY05527'='(NY05527) New Paltz Town & Village' 'NY05556'='(NY05556) Lloyd Town'
                  'NY05558'='(NY05558) Marlborough Town' 'NY05559'='(NY05559) Kingston Town'
                  'NY05561'='(NY05561) Plattekill Town' 'NY05566'='(NY05566) Woodstock Town'
                  'NY05580'='(NY05580) Saugerties Town' 'NY05581'='(NY05581) Shandaken Town'
                  'NY05591'='(NY05591) Rosendale Town' 'NY05595'='(NY05595) Ulster Town'
                  'NY05596'='(NY05596) Hurley Town' 'NY05597'='(NY05597) Olive Town'
                  'NY05598'='(NY05598) Olive Town' 'NY05599'='(NY05599) Shawangunk Town'
                  'NY05600'='(NY05600) Warren' 'NY05601'='(NY05601) Glens Falls'
                  'NY05620'='(NY05620) Lake George Village' 'NY05650'='(NY05650) Bolton Town'
                  'NY05653'='(NY05653) Hague Town' 'NY05656'='(NY05656) Lake Luzerne Town'
                  'NY05657'='(NY05657) Queensbury Town' 'NY05700'='(NY05700) Washington'
                  'NY05721'='(NY05721) Cambridge Village' 'NY05722'='(NY05722) Greenwich Village'
                  'NY05724'='(NY05724) Fort Edward Village'
                  'NY05725'='(NY05725) Granville Village'
                  'NY05726'='(NY05726) Hudson Falls Village' 'NY05727'='(NY05727) Salem Village'
                  'NY05728'='(NY05728) Whitehall Village' 'NY05800'='(NY05800) Wayne'
                  'NY05820'='(NY05820) Newark Village' 'NY05821'='(NY05821) Wolcott Village'
                  'NY05822'='(NY05822) Clyde Village' 'NY05823'='(NY05823) Lyons Village'
                  'NY05825'='(NY05825) Palmyra Village' 'NY05828'='(NY05828) Sodus Village'
                  'NY05829'='(NY05829) Sodus Point Village'
                  'NY05830'='(NY05830) Macedon Town And Village'
                  'NY05850'='(NY05850) Savannah Town'
                  'NY05855'='(NY05855) Macedon Town And Village'
                  'NY05862'='(NY05862) Marion Town'
                  'NY05900'='(NY05900) Westchester Public Safet' 'NY05901'='(NY05901) Peekskill'
                  'NY05902'='(NY05902) White Plains' 'NY05903'='(NY05903) Mount Vernon'
                  'NY05904'='(NY05904) New Rochelle' 'NY05905'='(NY05905) Ossining Village'
                  'NY05906'='(NY05906) Port Chester Village' 'NY05907'='(NY05907) Yonkers'
                  'NY05908'='(NY05908) Rye' 'NY05909'='(NY05909) Mamaroneck Village'
                  'NY05910'='(NY05910) Scarsdale Village'
                  'NY05911'='(NY05911) Westchester Co Conrail'
                  'NY05920'='(NY05920) Mount Kisco Village'
                  'NY05921'='(NY05921) Croton-On-Hudson Village'
                  'NY05922'='(NY05922) Bronxville Village' 'NY05923'='(NY05923) Tuckahoe Village'
                  'NY05924'='(NY05924) Ardsley Village' 'NY05925'='(NY05925) Dobbs Ferry Village'
                  'NY05926'='(NY05926) Hastings-On-Hudson Villa'
                  'NY05927'='(NY05927) Irvington Village' 'NY05928'='(NY05928) Tarrytown Village'
                  'NY05929'='(NY05929) Larchmont Village'
                  'NY05931'='(NY05931) Briarcliff Manor Village'
                  'NY05932'='(NY05932) Sleepy Hollow Village'
                  'NY05933'='(NY05933) Pleasantville Village'
                  'NY05935'='(NY05935) Pelham Village' 'NY05936'='(NY05936) Pelham'
                  'NY05937'='(NY05937) Pelham Manor Village'
                  'NY05939'='(NY05939) Elmsford Village' 'NY05941'='(NY05941) Buchanan Village'
                  'NY05950'='(NY05950) Bedford Town' 'NY05952'='(NY05952) Eastchester Town'
                  'NY05953'='(NY05953) Greenburgh Town' 'NY05954'='(NY05954) Harrison Town'
                  'NY05955'='(NY05955) Lewisboro Town' 'NY05956'='(NY05956) Mamaroneck Town'
                  'NY05957'='(NY05957) Mount Pleasant Town' 'NY05958'='(NY05958) New Castle Town'
                  'NY05959'='(NY05959) North Castle Town' 'NY05963'='(NY05963) Pound Ridge Town'
                  'NY05968'='(NY05968) Yorktown Town' 'NY05972'='(NY05972) Rye Brook Village'
                  'NY05973'='(NY05973) Ossining Town' 'NY05974'='(NY05974) Cortlandt Town'
                  'NY05975'='(NY05975) Nycmta: Westchester Cnty'
                  'NY05990'='(NY05990) Westchester Parkway Poli' 'NY06000'='(NY06000) Wyoming'
                  'NY06020'='(NY06020) Arcade Village' 'NY06021'='(NY06021) Attica Village'
                  'NY06023'='(NY06023) Perry Village' 'NY06027'='(NY06027) Warsaw Village'
                  'NY06100'='(NY06100) Yates' 'NY06120'='(NY06120) Penn Yan Village'
                  'NY06122'='(NY06122) Dundee Village' 'NY06200'='(NY06200) Bronx'
                  'NY06207'='(NY06207) Bronx Co Conrail Ra'
                  'NY06275'='(NY06275) Nycmta: Bronx County'
                  'NY112WN'='(NY112WN) Bd Of Water: Delaware Co'
                  'NY11304'='(NY11304) Nassau Sp Troop L'
                  'NY15103'='(NY15103) suffolk Sp Troop L'
                  'NY152WN'='(NY152WN) bd Of Water: Sullivan Co'
                  'NY155WN'='(NY155WN) Board Of Water:Ulster Co'
                  'NY159WN'='(NY159WN) Bd Of Water:Westchester'
                  'NY201UN'='(NY201UN) Suny: Albany' 'NY201UP'='(NY201UP) Suny: Albany (Plaza)'
                  'NY202UN'='(NY202UN) Suny A&t College: Alfred'
                  'NY203UN'='(NY203UN) Suny: Binghamton'
                  'NY206UN'='(NY206UN) Suny College: Fredonia'
                  'NY209UN'='(NY209UN) Suny College:Plattsburgh'
                  'NY211UC'='(NY211UC) Suny College: Cortland'
                  'NY212UN'='(NY212UN) Suny College: Technology'
                  'NY214UA'='(NY214UA) Suny: Amherst' 'NY214UB'='(NY214UB) Suny: Buffalo'
                  'NY214UC'='(NY214UC) Suny College: Buffalo'
                  'NY223UN'='(NY223UN) Suny: Downstate Med Ctr'
                  'NY225UN'='(NY225UN) Suny College: Geneseo'
                  'NY226UN'='(NY226UN) Suny A&t Col:Morrisville'
                  'NY227UN'='(NY227UN) Suny College: Brockport'
                  'NY229UN'='(NY229UN) Suny Coll: Old Westbury'
                  'NY230UN'='(NY230UN) Suny College: Optometry'
                  'NY232UN'='(NY232UN) Suny College: Utica-Rome'
                  'NY233UE'='(NY233UE) Suny Coll:Envir Sci&Frty'
                  'NY233UM'='(NY233UM) Suny: Upstate Med Center'
                  'NY233US'='(NY233US) Syracuse University'
                  'NY237UN'='(NY237UN) Suny College: Oswego'
                  'NY238UN'='(NY238UN) Suny College: Oneonta'
                  'NY241UR'='(NY241UR) Rensselaer Polytechnic I'
                  'NY244UK'='(NY244UK) suny A&t College: Canton'
                  'NY244UP'='(NY244UP) Suny College: Potsdam'
                  'NY247UN'='(NY247UN) Suny A&t Coll:Cobleskill'
                  'NY251UF'='(NY251UF) Suny A&t Col:Farmingdale'
                  'NY251US'='(NY251US) Suny: Stony Brook'
                  'NY254UC'='(NY254UC) Cornell University' 'NY254UI'='(NY254UI) Ithaca College'
                  'NY255UN'='(NY255UN) Suny College: New Paltz'
                  'NY259UN'='(NY259UN) Suny College: Purchase'
                  'NY262UN'='(NY262UN) Suny: Maritime College'
                  'NY301SG'='(NY301SG) Sp: Albany County (G)'
                  'NY301SP'='(NY301SP) albany State Police'
                  'NY301ST'='(NY301ST) Sp: Albany County (T)'
                  'NY302SA'='(NY302SA) sp: Allegany County (A)'
                  'NY302SP'='(NY302SP) allegany State Police'
                  'NY303SC'='(NY303SC) Sp: Broome County (C)'
                  'NY303SP'='(NY303SP) bronx State Police'
                  'NY304SA'='(NY304SA) Sp: Cattaraugus Cnty (A)'
                  'NY304SP'='(NY304SP) broome State Police'
                  'NY305SE'='(NY305SE) Sp: Cayuga County (E)'
                  'NY305SP'='(NY305SP) cattaraugus State Police'
                  'NY305ST'='(NY305ST) Sp: Cayuga County (T)'
                  'NY306SA'='(NY306SA) sp: Chautauqua Cnty (A)'
                  'NY306SP'='(NY306SP) cayuga State Police'
                  'NY306ST'='(NY306ST) Sp: Chautauqua Cnty (T)'
                  'NY307SE'='(NY307SE) sp: Chemung County (E)'
                  'NY307SP'='(NY307SP) chautauqua County Sp'
                  'NY308SC'='(NY308SC) Sp: Chenango County (C)'
                  'NY308SP'='(NY308SP) chemung State Police'
                  'NY309SB'='(NY309SB) Sp: Clinton County (B)'
                  'NY309SP'='(NY309SP) chenango State Police'
                  'NY310SK'='(NY310SK) Sp: Columbia County (K)'
                  'NY310SP'='(NY310SP) clinton State Police'
                  'NY310ST'='(NY310ST) Sp: Columbia County (T)'
                  'NY311SC'='(NY311SC) sp: Cortland County (C)'
                  'NY311SP'='(NY311SP) columbia State Police'
                  'NY312SC'='(NY312SC) Sp: Delaware County (C)'
                  'NY312SP'='(NY312SP) cortland State Police'
                  'NY313SK'='(NY313SK) Sp: Dutchess County (K)'
                  'NY313SP'='(NY313SP) delaware State Police'
                  'NY313ST'='(NY313ST) Sp: Dutchess County (T)'
                  'NY314SA'='(NY314SA) sp: Erie County (A)'
                  'NY314SP'='(NY314SP) dutchess State Police'
                  'NY314ST'='(NY314ST) Sp: Erie County (T)'
                  'NY315SB'='(NY315SB) sp: Essex County (B)'
                  'NY315SP'='(NY315SP) erie State Police'
                  'NY316SB'='(NY316SB) Sp: Franklin County (B)'
                  'NY316SP'='(NY316SP) essex State Police'
                  'NY317SG'='(NY317SG) Sp: Fulton County (G)'
                  'NY317SP'='(NY317SP) franklin State Police'
                  'NY318SA'='(NY318SA) Sp: Genesee County (A)'
                  'NY318SP'='(NY318SP) fulton State Police'
                  'NY318ST'='(NY318ST) Sp: Genesee County (T)'
                  'NY319SF'='(NY319SF) sp: Greene County (F)'
                  'NY319SP'='(NY319SP) genesee County'
                  'NY319ST'='(NY319ST) Sp: Greene County (T)'
                  'NY320SB'='(NY320SB) sp: Hamilton County (B)'
                  'NY320SG'='(NY320SG) sp: Hamilton County (G)'
                  'NY320SP'='(NY320SP) greene State Police'
                  'NY321SD'='(NY321SD) Sp: Herkimer County (D)'
                  'NY321SP'='(NY321SP) hamilton State Police'
                  'NY321ST'='(NY321ST) Sp: Herkimer County (T)'
                  'NY322SD'='(NY322SD) sp: Jefferson County (D)'
                  'NY322SP'='(NY322SP) herkimer State Police'
                  'NY323SP'='(NY323SP) Jefferson State Police'
                  'NY324SD'='(NY324SD) Sp: Lewis County (D)'
                  'NY324SP'='(NY324SP) kings State Police'
                  'NY325SE'='(NY325SE) Sp: Livingston Cnty (E)'
                  'NY325SP'='(NY325SP) lewis State Police'
                  'NY326SD'='(NY326SD) Sp: Madison County (D)'
                  'NY326SP'='(NY326SP) livingston State Police'
                  'NY326ST'='(NY326ST) Sp: Madison County (T)'
                  'NY327SE'='(NY327SE) sp: Monroe County (E)'
                  'NY327SP'='(NY327SP) madison State Police'
                  'NY327ST'='(NY327ST) Sp: Monroe County (T)'
                  'NY328SG'='(NY328SG) sp: Montgomery Cnty (G)'
                  'NY328SP'='(NY328SP) monroe State Police'
                  'NY328ST'='(NY328ST) Sp: Montgomery Cnty (T)'
                  'NY329SL'='(NY329SL) sp: Nassau County (L)'
                  'NY329SP'='(NY329SP) montgomery State Police'
                  'NY329SS'='(NY329SS) Nassau Sp Troop S'
                  'NY330SP'='(NY330SP) nassau State Police'
                  'NY330SS'='(NY330SS) Sp: New York County (S)'
                  'NY331SA'='(NY331SA) sp: Niagara County (A)'
                  'NY331SP'='(NY331SP) new York County (Sp)'
                  'NY331ST'='(NY331ST) Sp: Niagara County (T)'
                  'NY332SD'='(NY332SD) sp: Oneida County (D)'
                  'NY332SP'='(NY332SP) niagara State Police'
                  'NY332ST'='(NY332ST) Sp: Oneida County (T)'
                  'NY333SD'='(NY333SD) sp: Onondaga County (D)'
                  'NY333SP'='(NY333SP) oneida State Police'
                  'NY333ST'='(NY333ST) Sp: Onondaga County (T)'
                  'NY334SE'='(NY334SE) sp: Ontario County (E)'
                  'NY334SP'='(NY334SP) onondaga State Police'
                  'NY334ST'='(NY334ST) Sp: Ontario County (T)'
                  'NY335SF'='(NY335SF) sp: Orange County (F)'
                  'NY335SP'='(NY335SP) ontario State Police'
                  'NY335ST'='(NY335ST) Sp: Orange County (T)'
                  'NY336SA'='(NY336SA) sp: Orleans County (A)'
                  'NY336SP'='(NY336SP) orange State Police'
                  'NY336ST'='(NY336ST) Sp: Orleans County (T)'
                  'NY337SD'='(NY337SD) sp: Oswego County (D)'
                  'NY337SP'='(NY337SP) orleans State Police'
                  'NY337ST'='(NY337ST) Sp: Oswego County (T)'
                  'NY338SC'='(NY338SC) sp: Otsego County (C)'
                  'NY338SP'='(NY338SP) oswego State Police'
                  'NY339SK'='(NY339SK) Sp: Putnam County (K)'
                  'NY339SP'='(NY339SP) otsego State Police'
                  'NY339ST'='(NY339ST) Sp: Putnam County (T)'
                  'NY340SP'='(NY340SP) putnam State Police'
                  'NY341SG'='(NY341SG) Sp: Rensselaer Cnty (G)'
                  'NY341SP'='(NY341SP) queens State Police'
                  'NY341ST'='(NY341ST) Sp: Rensselaer Cnty (T)'
                  'NY342SP'='(NY342SP) rensselaer State Police'
                  'NY343SF'='(NY343SF) Sp: Rockland County (F)'
                  'NY343SP'='(NY343SP) richmond State Police'
                  'NY343ST'='(NY343ST) Sp: Rockland County (T)'
                  'NY344SB'='(NY344SB) sp: St Lawrence Cnty (B)'
                  'NY344SP'='(NY344SP) rockland State Police'
                  'NY345SG'='(NY345SG) Sp: Saratoga County (G)'
                  'NY345SP'='(NY345SP) st. Lawrence State Polic'
                  'NY345ST'='(NY345ST) Sp: Saratoga County (T)'
                  'NY346SG'='(NY346SG) sp: Schenectady Cnty (G)'
                  'NY346SP'='(NY346SP) saratoga State Police'
                  'NY346ST'='(NY346ST) Sp: Schenectady Cnty (T)'
                  'NY347SG'='(NY347SG) sp: Schoharie County (G)'
                  'NY347SP'='(NY347SP) schenectady State Police'
                  'NY348SE'='(NY348SE) Sp: Schuyler County (E)'
                  'NY348SP'='(NY348SP) schoharie State Police'
                  'NY349SE'='(NY349SE) Sp: Seneca County (E)'
                  'NY349SP'='(NY349SP) schuyler State Police'
                  'NY349ST'='(NY349ST) Sp: Seneca County (T)'
                  'NY350SE'='(NY350SE) sp: Steuben County (E)'
                  'NY350SP'='(NY350SP) seneca State Police'
                  'NY351SK'='(NY351SK) Sp: Suffolk County (K)'
                  'NY351SL'='(NY351SL) sp: Suffolk County (L)'
                  'NY351SP'='(NY351SP) steuben State Police'
                  'NY352SF'='(NY352SF) Sp: Sullivan County (F)'
                  'NY352SP'='(NY352SP) suffolk State Police'
                  'NY353SC'='(NY353SC) Sp: Tioga County (C)'
                  'NY353SP'='(NY353SP) sullivan State Police'
                  'NY354SC'='(NY354SC) Sp: Tompkins County (C)'
                  'NY354SP'='(NY354SP) tioga State Police'
                  'NY355SF'='(NY355SF) Sp: Ulster County (F)'
                  'NY355SP'='(NY355SP) tompkins State Police'
                  'NY355ST'='(NY355ST) Sp: Ulster County (T)'
                  'NY356SG'='(NY356SG) sp: Warren County (G)'
                  'NY356SP'='(NY356SP) ulster State Police'
                  'NY357SG'='(NY357SG) Sp: Washington Cnty (G)'
                  'NY357SP'='(NY357SP) warren State Police'
                  'NY357ST'='(NY357ST) Sp: Washington Cnty (T)'
                  'NY358SE'='(NY358SE) sp: Wayne County (E)'
                  'NY358SP'='(NY358SP) washington State Police'
                  'NY358ST'='(NY358ST) Sp: Wayne County (T)'
                  'NY359SK'='(NY359SK) sp: Westchester Cnty (K)'
                  'NY359SP'='(NY359SP) wayne State Police'
                  'NY359ST'='(NY359ST) Sp: Westchester Cnty (T)'
                  'NY360SA'='(NY360SA) sp: Wyoming County (A)'
                  'NY360SP'='(NY360SP) westchester State Police'
                  'NY361SE'='(NY361SE) Sp: Yates County (E)'
                  'NY361SP'='(NY361SP) wyoming State Police'
                  'NY362SP'='(NY362SP) Yates State Police'
                  'NY401PS'='(NY401PS) State Park: Albany Cnty'
                  'NY402PA'='(NY402PA) State Park: Allegany Cty'
                  'NY403PC'='(NY403PC) State Park: Broome Cnty'
                  'NY404PA'='(NY404PA) State Park: Cattaraugus'
                  'NY405PF'='(NY405PF) State Park: Cayuga Cnty'
                  'NY406PA'='(NY406PA) State Park: Chautauqua C'
                  'NY407PF'='(NY407PF) state Park: Chemung Cnty'
                  'NY408PC'='(NY408PC) State Park: Chenango Cty'
                  'NY409PI'='(NY409PI) State Park: Clinton Cnty'
                  'NY410PT'='(NY410PT) State Park: Columbia Cty'
                  'NY411PC'='(NY411PC) State Park: Cortland Cty'
                  'NY412PC'='(NY412PC) State Park: Delaware Cty'
                  'NY413PT'='(NY413PT) State Park: Dutchess Cty'
                  'NY414PN'='(NY414PN) State Park: Erie County'
                  'NY416PI'='(NY416PI) State Park: Franklin Cty'
                  'NY417PS'='(NY417PS) State Park: Fulton Cnty'
                  'NY418PG'='(NY418PG) State Park: Genesee Cnty'
                  'NY419PS'='(NY419PS) State Park: Greene Cnty'
                  'NY421PC'='(NY421PC) State Park: Herkimer Cty'
                  'NY422PI'='(NY422PI) State Park: Jefferson C'
                  'NY423PB'='(NY423PB) state Park: Kings County'
                  'NY424PI'='(NY424PI) State Park: Lewis County'
                  'NY425PG'='(NY425PG) State Park: Livingston C'
                  'NY426PC'='(NY426PC) state Park: Madison Cnty'
                  'NY427PG'='(NY427PG) State Park: Monroe Cnty'
                  'NY428PS'='(NY428PS) State Park: Montgomery C'
                  'NY429PL'='(NY429PL) state Park: Nassau Cnty'
                  'NY430PB'='(NY430PB) State Park: New York Cty'
                  'NY431PN'='(NY431PN) State Park: Niagara Cnty'
                  'NY432PC'='(NY432PC) State Park: Oneida Count'
                  'NY433PC'='(NY433PC) State Park: Onondaga Cty'
                  'NY433PR'='(NY433PR) Onondaga County Parks'
                  'NY434PF'='(NY434PF) State Park: Ontario Cnty'
                  'NY435PP'='(NY435PP) State Park: Orange Cnty'
                  'NY436PG'='(NY436PG) State Park: Orleans Cnty'
                  'NY437PC'='(NY437PC) State Park: Oswego Cnty'
                  'NY438PC'='(NY438PC) State Park: Otsego Cnty'
                  'NY439PT'='(NY439PT) State Park: Putnam Cnty'
                  'NY440PB'='(NY440PB) State Park: Queens Cnty'
                  'NY441PS'='(NY441PS) State Park: Rennselaer C'
                  'NY442PB'='(NY442PB) state Park: Richmond Cty'
                  'NY443PP'='(NY443PP) State Park: Rockland Cty'
                  'NY444PI'='(NY444PI) State Park: St Lawrence'
                  'NY445PS'='(NY445PS) State Park: Saratoga Cty'
                  'NY446PS'='(NY446PS) State Park: Schenectady'
                  'NY447PS'='(NY447PS) State Park: Schoharie C'
                  'NY448PF'='(NY448PF) state Park: Schuyler Cty'
                  'NY449PF'='(NY449PF) State Park: Seneca Count'
                  'NY450PF'='(NY450PF) State Park: Steuben Cnty'
                  'NY451PL'='(NY451PL) State Park: Suffolk Cnty'
                  'NY451PR'='(NY451PR) Suffolk County Parks'
                  'NY452PP'='(NY452PP) State Park: Sullivan Cty'
                  'NY453PF'='(NY453PF) State Park: Tioga County'
                  'NY454PF'='(NY454PF) State Park: Tompkins Cty'
                  'NY455PP'='(NY455PP) State Park: Ulster Cnty'
                  'NY457PS'='(NY457PS) State Park: Washington C'
                  'NY458PF'='(NY458PF) state Park: Wayne County'
                  'NY459PT'='(NY459PT) State Park: Westchester'
                  'NY460PG'='(NY460PG) State Park: Wyoming Cnty'
                  'NY461PF'='(NY461PF) State Park: Yates County'
                  'NY462PB'='(NY462PB) State Park: Bronx County'
                  'NY501RB'='(NY501RB) Albany County Conrail Rb'
                  'NY501RC'='(NY501RC) Albany Co: Csx'
                  'NY501RD'='(NY501RD) D&h Rr: Albany County' 'NY501RM'='(NY501RM) Amtrak Albany'
                  'NY501RX'='(NY501RX) Csx Trans: Albany County'
                  'NY502RC'='(NY502RC) Allegany Co: N&s'
                  'NY502RD'='(NY502RD) D&h Rr: Allegany County'
                  'NY503RC'='(NY503RC) Broome Co: N&s'
                  'NY503RD'='(NY503RD) D&h Rr: Broome County'
                  'NY504RC'='(NY504RC) Cattaraugus Co: Csx'
                  'NY504RX'='(NY504RX) Csx Trans: Cattaraugus C'
                  'NY505RC'='(NY505RC) cayuga Co: Csx' 'NY505RM'='(NY505RM) Cayuga Co:Amtrak'
                  'NY505RX'='(NY505RX) Csx Trans: Cayuga County'
                  'NY506RC'='(NY506RC) Chautauqua Co: Csx'
                  'NY506RM'='(NY506RM) Chautauqua Co: Amtrak'
                  'NY506RN'='(NY506RN) Norfolk Sthrn Rw Chatauq'
                  'NY506RX'='(NY506RX) Csx Trans:Chautauqua Co'
                  'NY507RC'='(NY507RC) Chemung Co: N&s'
                  'NY507RD'='(NY507RD) D&h Rr: Chemung County'
                  'NY507RP'='(NY507RP) Chemung Co. Conrail Rp'
                  'NY508RC'='(NY508RC) Chenango Co Conrail Rc'
                  'NY508RD'='(NY508RD) D&h Rr: Chenango County'
                  'NY509RD'='(NY509RD) D&h Rr: Clinton County'
                  'NY510RC'='(NY510RC) Columbia Co: Csx' 'NY510RM'='(NY510RM) Amtrak Columbia'
                  'NY510RX'='(NY510RX) Csx Trans: Columbia Cnty'
                  'NY511RC'='(NY511RC) Cortland Co Conrail Rc'
                  'NY512RC'='(NY512RC) Delaware Co:Conrail'
                  'NY512RD'='(NY512RD) D&h Rr: Delaware County'
                  'NY513RC'='(NY513RC) Dutchess Co: Csx' 'NY513RM'='(NY513RM) Dutchess Co:Amtrak'
                  'NY513RX'='(NY513RX) Csx Trans: Dutchess Cnty'
                  'NY514RC'='(NY514RC) Erie Co: Csx' 'NY514RD'='(NY514RD) D&h Rr: Erie County'
                  'NY514RM'='(NY514RM) Erie Co:Amtrak'
                  'NY514RN'='(NY514RN) Norfolk Sthrn Rwy, Erie'
                  'NY514RP'='(NY514RP) Ny Conrail Erie Co'
                  'NY514RX'='(NY514RX) Csx Trans: Erie County'
                  'NY515RD'='(NY515RD) D&h Rr: Essex County'
                  'NY515RM'='(NY515RM) Essex Co:Amtrak' 'NY516RC'='(NY516RC) Franklin Co:Conrail'
                  'NY518RC'='(NY518RC) Genesee Co: Csx'
                  'NY518RD'='(NY518RD) D&h Rr: Genesee County'
                  'NY518RX'='(NY518RX) Csx Trans:Genesee County'
                  'NY519RC'='(NY519RC) Greene Co: Csx'
                  'NY519RX'='(NY519RX) Csx Trans: Greene County'
                  'NY520RD'='(NY520RD) Delaware And Hudson Rd'
                  'NY521RC'='(NY521RC) Herkimer Co: Csx' 'NY521RM'='(NY521RM) Herkimer Co:Amtrak'
                  'NY521RX'='(NY521RX) Csx Trans: Herkimer Cnty'
                  'NY522RC'='(NY522RC) Jefferson Co: Csx'
                  'NY522RX'='(NY522RX) Csx Trans: Jefferson Cty'
                  'NY523RC'='(NY523RC) Kings County:Conrail'
                  'NY523RL'='(NY523RL) Kings Long Island Rr'
                  'NY524RC'='(NY524RC) Lewis County:Conrail'
                  'NY525RC'='(NY525RC) Livingston Co: N&s'
                  'NY525RD'='(NY525RD) D&h Rr: Livingston Cnty'
                  'NY526RC'='(NY526RC) Madison Co:Csx'
                  'NY526RM'='(NY526RM) Madison County:Amtrak'
                  'NY526RX'='(NY526RX) Csx Trans: Madison Cnty'
                  'NY527RC'='(NY527RC) Monroe Co: Csx' 'NY527RM'='(NY527RM) Monroe County:Amtrak'
                  'NY527RX'='(NY527RX) Csx Trans: Monroe County'
                  'NY528RC'='(NY528RC) Montgomery Co: Csx'
                  'NY528RM'='(NY528RM) Amtrak Montgomery'
                  'NY528RX'='(NY528RX) Csx Trans: Montgomery Co'
                  'NY529RL'='(NY529RL) Long Island Rl-Nassau Co'
                  'NY530RC'='(NY530RC) New York Co:Conrail'
                  'NY530RL'='(NY530RL) Long Island Rl-Ny County'
                  'NY531RC'='(NY531RC) Niagara Co: Csx'
                  'NY531RD'='(NY531RD) D&h Rr: Niagara County'
                  'NY531RM'='(NY531RM) Niagara Co:Amtrak'
                  'NY531RX'='(NY531RX) Csx Trans: Niagara Cnty'
                  'NY532RC'='(NY532RC) Oneida Co: Csx' 'NY532RM'='(NY532RM) Oneida Co:Amtrak'
                  'NY532RX'='(NY532RX) Csx Trans: Oneida County'
                  'NY533RC'='(NY533RC) Onondaga Co: Csx' 'NY533RM'='(NY533RM) Onondaga Co:Amtrak'
                  'NY533RX'='(NY533RX) Csx Trans: Onondaga Cnty'
                  'NY534RC'='(NY534RC) Ontario Co: Csx'
                  'NY534RP'='(NY534RP) Ny Conrail Ontario Co'
                  'NY534RX'='(NY534RX) Csx Trans: Ontario Cnty'
                  'NY535RA'='(NY535RA) Orange Co. Conrail Ra'
                  'NY535RB'='(NY535RB) Orange Co: Csx' 'NY535RC'='(NY535RC) Orange Co: Csx'
                  'NY535RX'='(NY535RX) Csx Trans: Orange County'
                  'NY536RC'='(NY536RC) Orleans Co: Csx' 'NY536RM'='(NY536RM) Orleans Co:Amtrak'
                  'NY536RX'='(NY536RX) Csx Trans: Orleans Cnty'
                  'NY537RC'='(NY537RC) Oswego Co: Csx'
                  'NY537RX'='(NY537RX) Csx Trans: Oswego Cnty'
                  'NY538RD'='(NY538RD) D&h Rr: Otsego County'
                  'NY539RC'='(NY539RC) Putnam Co Conrail Rc'
                  'NY539RM'='(NY539RM) Putnam Co:Amtrak' 'NY540RC'='(NY540RC) Queens Co: Csx'
                  'NY540RL'='(NY540RL) Queens Long Island Rr'
                  'NY540RX'='(NY540RX) Csx Trans: Queens Cnty'
                  'NY541RC'='(NY541RC) Rensselaer Co: Csx'
                  'NY541RM'='(NY541RM) Amtrak Rensselaer'
                  'NY541RX'='(NY541RX) Csx Trans: Rensselaer Co'
                  'NY543RA'='(NY543RA) Rockland Co. Conrail Ra'
                  'NY543RB'='(NY543RB) Rockland Co: Csx' 'NY543RC'='(NY543RC) Rockland Co: Csx'
                  'NY543RX'='(NY543RX) Csx Trans: Rockland Cnty'
                  'NY544RC'='(NY544RC) St. Lawrence Co: Csx'
                  'NY544RX'='(NY544RX) Csx Trans:St. Lawrence C'
                  'NY545RD'='(NY545RD) d&H rr: Saratoga County'
                  'NY545RM'='(NY545RM) Saratoga Co:Amtrak'
                  'NY546RC'='(NY546RC) Schenectady Co: Csx'
                  'NY546RD'='(NY546RD) D&h Rr: Schenectady Cnty'
                  'NY546RM'='(NY546RM) Amtrak Schenectady'
                  'NY546RX'='(NY546RX) Csx Trans:Schenectady C'
                  'NY547RD'='(NY547RD) d&H rr: Schoharie County'
                  'NY548RC'='(NY548RC) Schuyler Co: N&s'
                  'NY548RP'='(NY548RP) Ny Conrail Schuyler' 'NY549RC'='(NY549RC) Seneca Co: Csx'
                  'NY549RX'='(NY549RX) Csx Trans: Seneca County'
                  'NY550RC'='(NY550RC) Steuben Co: N&s'
                  'NY550RD'='(NY550RD) D&h Rr: Steuben County'
                  'NY550RP'='(NY550RP) Ny Conrail Steuben'
                  'NY551RL'='(NY551RL) Long Island Rl-Suffolk C'
                  'NY552RC'='(NY552RC) sullivan Co: N&s' 'NY553RC'='(NY553RC) Tioga Co: N&s'
                  'NY553RD'='(NY553RD) D&h Rr: Tioga County'
                  'NY554RC'='(NY554RC) Tompkins Co: N&s' 'NY555RB'='(NY555RB) Ulster Co: Csx'
                  'NY555RC'='(NY555RC) Ulster Co: Csx'
                  'NY555RX'='(NY555RX) Csx Trans: Ulster County'
                  'NY556RD'='(NY556RD) D&h Rr: Warren County'
                  'NY556RM'='(NY556RM) Warren Co:Amtrak'
                  'NY557RD'='(NY557RD) D&h Rr: Washington Cnty'
                  'NY557RM'='(NY557RM) Washington Co:Amtrak' 'NY558RC'='(NY558RC) Wayne Co: Csx'
                  'NY558RM'='(NY558RM) Wayne Co:Amtrak'
                  'NY558RX'='(NY558RX) Csx Trans: Wayne County'
                  'NY559RC'='(NY559RC) Westchester Co: Csx'
                  'NY559RM'='(NY559RM) Westchester Co:Amtrak'
                  'NY559RX'='(NY559RX) Csx Trans: Westchester C'
                  'NY560RC'='(NY560RC) wyoming Co: N&s'
                  'NY560RD'='(NY560RD) D&h Rr: Wyoming County' 'NY561RC'='(NY561RC) Yates Co: Ns'
                  'NY562RC'='(NY562RC) Bronx Co: Csx'
                  'NY562RX'='(NY562RX) Csx Trans: Bronx County' 'OH00100'='(OH00100) Adams'
                  'OH00101'='(OH00101) Manchester' 'OH00102'='(OH00102) Peebles'
                  'OH00103'='(OH00103) West Union' 'OH00106'='(OH00106) Seaman'
                  'OH00107'='(OH00107) Winchester' 'OH00200'='(OH00200) Allen'
                  'OH00201'='(OH00201) Bluffton' 'OH00202'='(OH00202) Delphos'
                  'OH00203'='(OH00203) Fort Shawnee' 'OH00204'='(OH00204) Lima'
                  'OH00205'='(OH00205) Spencerville' 'OH00207'='(OH00207) Elida'
                  'OH00211'='(OH00211) Shawnee Township' 'OH00212'='(OH00212) Bath Township'
                  'OH00216'='(OH00216) Marion Township'
                  'OH00217'='(OH00217) Johnny Applsd Metro Pk D' 'OH00300'='(OH00300) ashland'
                  'OH00301'='(OH00301) Ashland' 'OH00302'='(OH00302) Loudonville'
                  'OH00303'='(OH00303) Perrysville' 'OH00400'='(OH00400) Ashtabula'
                  'OH00401'='(OH00401) Ashtabula' 'OH00402'='(OH00402) Conneaut'
                  'OH00403'='(OH00403) Geneva' 'OH00405'='(OH00405) Geneva-On-The-Lake'
                  'OH00406'='(OH00406) Jefferson' 'OH00407'='(OH00407) North Kingsville'
                  'OH00408'='(OH00408) Orwell' 'OH00410'='(OH00410) Roaming Shores Village'
                  'OH00500'='(OH00500) Athens' 'OH00501'='(OH00501) Athens' 'OH00502'='(OH00502) Glouster'
                  'OH00503'='(OH00503) Nelsonville' 'OH00504'='(OH00504) Albany'
                  'OH00507'='(OH00507) Chauncey' 'OH00510'='(OH00510) Ohio University'
                  'OH00511'='(OH00511) Hocking College' 'OH00600'='(OH00600) Auglaize'
                  'OH00601'='(OH00601) St. Marys' 'OH00602'='(OH00602) Wapakoneta'
                  'OH00603'='(OH00603) Buckland' 'OH00604'='(OH00604) Cridersville'
                  'OH00605'='(OH00605) Minster' 'OH00606'='(OH00606) New Bremen'
                  'OH00700'='(OH00700) Belmont' 'OH00701'='(OH00701) Barnesville'
                  'OH00702'='(OH00702) Bellaire' 'OH00703'='(OH00703) Bridgeport'
                  'OH00704'='(OH00704) Martins Ferry' 'OH00705'='(OH00705) Powhatan Point'
                  'OH00706'='(OH00706) Shadyside' 'OH00707'='(OH00707) St. Clairsville'
                  'OH00711'='(OH00711) Flushing' 'OH00713'='(OH00713) Morristown'
                  'OH00716'='(OH00716) Bethesda' 'OH00718'='(OH00718) Richland Township'
                  'OH00800'='(OH00800) Brown' 'OH00801'='(OH00801) Aberdeen'
                  'OH00802'='(OH00802) Georgetown' 'OH00806'='(OH00806) Higginsport'
                  'OH00807'='(OH00807) Mount Orab' 'OH00808'='(OH00808) Russellville'
                  'OH00809'='(OH00809) Sardinia' 'OH00900'='(OH00900) Butler'
                  'OH00901'='(OH00901) Fairfield' 'OH00902'='(OH00902) Hamilton'
                  'OH00903'='(OH00903) Middletown' 'OH00905'='(OH00905) Monroe'
                  'OH00907'='(OH00907) Oxford' 'OH00909'='(OH00909) Trenton'
                  'OH00912'='(OH00912) Lemon Township' 'OH00913'='(OH00913) Oxford Township'
                  'OH00915'='(OH00915) West Chester Township' 'OH00916'='(OH00916) Ross Township'
                  'OH00917'='(OH00917) Miami University' 'OH00918'='(OH00918) Fairfield Township'
                  'OH00919'='(OH00919) Butler County Metroparks' 'OH01000'='(OH01000) Carroll'
                  'OH01001'='(OH01001) Carrollton' 'OH01002'='(OH01002) Magnolia'
                  'OH01003'='(OH01003) Malvern' 'OH01100'='(OH01100) Champaign'
                  'OH01101'='(OH01101) Mechanicsburg' 'OH01102'='(OH01102) Urbana'
                  'OH01106'='(OH01106) St. Paris' 'OH01200'='(OH01200) Clark'
                  'OH01201'='(OH01201) New Carlisle' 'OH01202'='(OH01202) Springfield'
                  'OH01205'='(OH01205) Donnelsville' 'OH01209'='(OH01209) South Charleston'
                  'OH01210'='(OH01210) Tremont City' 'OH01211'='(OH01211) South Vienna'
                  'OH01213'='(OH01213) German Township' 'OH01300'='(OH01300) Clermont'
                  'OH01301'='(OH01301) Batavia' 'OH01302'='(OH01302) Bethel' 'OH01303'='(OH01303) Milford'
                  'OH01304'='(OH01304) Amelia' 'OH01310'='(OH01310) New Richmond'
                  'OH01312'='(OH01312) Owensville' 'OH01313'='(OH01313) Williamsburg'
                  'OH01314'='(OH01314) Goshen Township' 'OH01315'='(OH01315) Miami Township'
                  'OH01316'='(OH01316) Union Township' 'OH01317'='(OH01317) Pierce Township'
                  'OH01400'='(OH01400) Clinton' 'OH01401'='(OH01401) Blanchester'
                  'OH01402'='(OH01402) New Vienna' 'OH01404'='(OH01404) Wilmington'
                  'OH01500'='(OH01500) Columbiana' 'OH01501'='(OH01501) Columbiana'
                  'OH01502'='(OH01502) East Liverpool' 'OH01503'='(OH01503) East Palestine'
                  'OH01504'='(OH01504) Leetonia' 'OH01505'='(OH01505) Lisbon' 'OH01506'='(OH01506) Salem'
                  'OH01507'='(OH01507) Salineville' 'OH01508'='(OH01508) Wellsville'
                  'OH01513'='(OH01513) Washingtonville' 'OH01514'='(OH01514) Liverpool Township'
                  'OH01516'='(OH01516) Salem Township' 'OH01600'='(OH01600) Coshocton'
                  'OH01601'='(OH01601) Coshocton' 'OH01606'='(OH01606) West Lafayette'
                  'OH01700'='(OH01700) Crawford' 'OH01701'='(OH01701) Bucyrus'
                  'OH01702'='(OH01702) Crestline' 'OH01703'='(OH01703) Galion'
                  'OH01800'='(OH01800) Cuyahoga' 'OH01801'='(OH01801) Bay Village'
                  'OH01802'='(OH01802) Beachwood' 'OH01803'='(OH01803) Bedford'
                  'OH01804'='(OH01804) Bedford Heights'
                  'OH01805'='(OH01805) Bentleyville Village' 'OH01806'='(OH01806) Berea'
                  'OH01807'='(OH01807) Bratenahl' 'OH01808'='(OH01808) Brecksville'
                  'OH01809'='(OH01809) Broadview Heights' 'OH01810'='(OH01810) Brooklyn'
                  'OH01811'='(OH01811) Brooklyn Heights' 'OH01812'='(OH01812) Brook Park'
                  'OH01813'='(OH01813) Chagrin Falls' 'OH01815'='(OH01815) Cleveland Heights'
                  'OH01817'='(OH01817) East Cleveland' 'OH01818'='(OH01818) Euclid'
                  'OH01819'='(OH01819) Fairview Park' 'OH01820'='(OH01820) Garfield Heights'
                  'OH01821'='(OH01821) Gates Mills' 'OH01823'='(OH01823) Highland Heights'
                  'OH01824'='(OH01824) Hunting Valley' 'OH01825'='(OH01825) Independence'
                  'OH01826'='(OH01826) Lakewood' 'OH01827'='(OH01827) Lyndhurst'
                  'OH01828'='(OH01828) Maple Heights' 'OH01829'='(OH01829) Mayfield Heights'
                  'OH01830'='(OH01830) Mayfield Village' 'OH01831'='(OH01831) Middleburg Heights'
                  'OH01832'='(OH01832) Moreland Hills' 'OH01833'='(OH01833) Newburgh Heights'
                  'OH01834'='(OH01834) North Olmsted' 'OH01835'='(OH01835) North Randall'
                  'OH01836'='(OH01836) North Royalton' 'OH01837'='(OH01837) Oakwood Village'
                  'OH01838'='(OH01838) Olmsted Township' 'OH01839'='(OH01839) Olmsted Falls'
                  'OH01842'='(OH01842) Parma' 'OH01843'='(OH01843) Parma Heights'
                  'OH01844'='(OH01844) Pepper Pike' 'OH01845'='(OH01845) Richmond Heights'
                  'OH01846'='(OH01846) Rocky River' 'OH01847'='(OH01847) Seven Hills'
                  'OH01848'='(OH01848) Shaker Heights' 'OH01849'='(OH01849) Solon'
                  'OH01850'='(OH01850) South Euclid' 'OH01851'='(OH01851) Strongsville'
                  'OH01852'='(OH01852) University Heights' 'OH01853'='(OH01853) Valley View'
                  'OH01854'='(OH01854) Walton Hills' 'OH01855'='(OH01855) Warrensville Heights'
                  'OH01856'='(OH01856) Highland Hills' 'OH01857'='(OH01857) Westlake'
                  'OH01861'='(OH01861) Cleveland State Univ'
                  'OH01863'='(OH01863) Cleveland Metro Park Dis'
                  'OH01864'='(OH01864) Cuyahoga Community Colle'
                  'OH01865'='(OH01865) Greater Cleveland Reg Ta'
                  'OH01867'='(OH01867) Clvlnd Lakefront S parks'
                  'OH01899'='(OH01899) Baldwin-Wallace College' 'OH01900'='(OH01900) Darke'
                  'OH01901'='(OH01901) Greenville' 'OH01902'='(OH01902) Ansonia'
                  'OH01903'='(OH01903) Arcanum' 'OH01911'='(OH01911) New Madison'
                  'OH01918'='(OH01918) Union City' 'OH02000'='(OH02000) Defiance'
                  'OH02001'='(OH02001) Defiance' 'OH02002'='(OH02002) Hicksville'
                  'OH02100'='(OH02100) Delaware' 'OH02101'='(OH02101) Delaware'
                  'OH02105'='(OH02105) Powell' 'OH02106'='(OH02106) Shawnee Hills'
                  'OH02107'='(OH02107) Sunbury' 'OH02108'='(OH02108) Genoa Township'
                  'OH02200'='(OH02200) Erie' 'OH02202'='(OH02202) Huron' 'OH02203'='(OH02203) Sandusky'
                  'OH02204'='(OH02204) Vermilion' 'OH02205'='(OH02205) Bay View'
                  'OH02207'='(OH02207) Kelleys Island' 'OH02210'='(OH02210) Perkins Township'
                  'OH02300'='(OH02300) Fairfield' 'OH02301'='(OH02301) Lancaster'
                  'OH02302'='(OH02302) Amanda' 'OH02303'='(OH02303) Baltimore'
                  'OH02306'='(OH02306) Carroll' 'OH02307'='(OH02307) Lithopolis'
                  'OH02309'='(OH02309) Pickerington' 'OH02400'='(OH02400) Fayette'
                  'OH02401'='(OH02401) Washington Court House' 'OH02500'='(OH02500) Franklin'
                  'OH02501'='(OH02501) Bexley' 'OH02503'='(OH02503) Dublin' 'OH02504'='(OH02504) Gahanna'
                  'OH02505'='(OH02505) Grandview Heights' 'OH02506'='(OH02506) Grove City'
                  'OH02507'='(OH02507) Hilliard' 'OH02508'='(OH02508) Reynoldsburg'
                  'OH02509'='(OH02509) Upper Arlington' 'OH02510'='(OH02510) Westerville'
                  'OH02511'='(OH02511) Whitehall' 'OH02512'='(OH02512) Worthington'
                  'OH02515'='(OH02515) Darbydale' 'OH02516'='(OH02516) Groveport'
                  'OH02520'='(OH02520) Minerva Park' 'OH02521'='(OH02521) New Albany'
                  'OH02526'='(OH02526) Valleyview' 'OH02527'='(OH02527) Ohio State University'
                  'OH02530'='(OH02530) Blendon Township' 'OH02531'='(OH02531) Clinton Township'
                  'OH02534'='(OH02534) Perry Township' 'OH02536'='(OH02536) Hamilton Township'
                  'OH02537'='(OH02537) Washington Township'
                  'OH02538'='(OH02538) Ohio Dept Of Natural Res'
                  'OH02540'='(OH02540) Sharon Township'
                  'OH02544'='(OH02544) Columbus State Comm Coll'
                  'OH02554'='(OH02554) Port Columbus Intnl Airp' 'OH02600'='(OH02600) Fulton'
                  'OH02601'='(OH02601) Archbold' 'OH02602'='(OH02602) Delta' 'OH02603'='(OH02603) Fayette'
                  'OH02604'='(OH02604) Swanton' 'OH02605'='(OH02605) Wauseon'
                  'OH02607'='(OH02607) Metamora' 'OH02700'='(OH02700) Gallia'
                  'OH02701'='(OH02701) Gallipolis' 'OH02708'='(OH02708) Addison Township'
                  'OH02800'='(OH02800) Geauga' 'OH02801'='(OH02801) Chardon' 'OH02802'='(OH02802) Aquilla'
                  'OH02803'='(OH02803) Burton' 'OH02805'='(OH02805) Middlefield'
                  'OH02806'='(OH02806) South Russell' 'OH02808'='(OH02808) Russell Township'
                  'OH02810'='(OH02810) Chester Township'
                  'OH02812'='(OH02812) Bainbridge Township'
                  'OH02813'='(OH02813) Parkman Township' 'OH02900'='(OH02900) Greene'
                  'OH02901'='(OH02901) Fairborn' 'OH02903'='(OH02903) Xenia'
                  'OH02904'='(OH02904) Yellow Springs' 'OH02905'='(OH02905) Bellbrook'
                  'OH02907'='(OH02907) Cedarville' 'OH02911'='(OH02911) Beavercreek'
                  'OH02912'='(OH02912) Wright State University'
                  'OH02913'='(OH02913) Sugarcreek Township'
                  'OH02914'='(OH02914) Central State University'
                  'OH02915'='(OH02915) Wilberforce University' 'OH03000'='(OH03000) Guernsey'
                  'OH03001'='(OH03001) Cambridge' 'OH03002'='(OH03002) Byesville'
                  'OH03010'='(OH03010) Senecaville' 'OH03100'='(OH03100) Hamilton'
                  'OH03101'='(OH03101) Addyston' 'OH03102'='(OH03102) Amberley Village'
                  'OH03103'='(OH03103) Arlington Heights' 'OH03104'='(OH03104) Blue Ash'
                  'OH03105'='(OH03105) Cheviot' 'OH03106'='(OH03106) Cleves'
                  'OH03107'='(OH03107) Deer Park' 'OH03108'='(OH03108) Delhi Township'
                  'OH03109'='(OH03109) Elmwood Place' 'OH03110'='(OH03110) Evendale'
                  'OH03111'='(OH03111) Fairfax' 'OH03112'='(OH03112) Forest Park'
                  'OH03113'='(OH03113) Glendale' 'OH03114'='(OH03114) Golf Manor'
                  'OH03115'='(OH03115) Greenhills' 'OH03116'='(OH03116) Harrison'
                  'OH03117'='(OH03117) Indian Hill' 'OH03118'='(OH03118) Lincoln Heights'
                  'OH03119'='(OH03119) Lockland' 'OH03120'='(OH03120) Loveland'
                  'OH03121'='(OH03121) Madeira' 'OH03122'='(OH03122) Mariemont'
                  'OH03123'='(OH03123) Montgomery' 'OH03124'='(OH03124) Mount Healthy'
                  'OH03125'='(OH03125) Newtown' 'OH03126'='(OH03126) North Bend'
                  'OH03127'='(OH03127) North College Hill' 'OH03128'='(OH03128) Norwood'
                  'OH03129'='(OH03129) Reading' 'OH03130'='(OH03130) St. Bernard'
                  'OH03131'='(OH03131) Sharonville' 'OH03132'='(OH03132) Silverton'
                  'OH03133'='(OH03133) Springdale' 'OH03134'='(OH03134) Springfield Township'
                  'OH03135'='(OH03135) Woodlawn' 'OH03136'='(OH03136) Wyoming'
                  'OH03137'='(OH03137) University Of Cincinnati'
                  'OH03141'='(OH03141) Terrace Park' 'OH03142'='(OH03142) Colerain Township'
                  'OH03146'='(OH03146) Hamilton County Park Dis'
                  'OH03158'='(OH03158) Collg Of Mount St Joseph' 'OH03200'='(OH03200) Hancock'
                  'OH03201'='(OH03201) Findlay' 'OH03207'='(OH03207) Mccomb' 'OH03300'='(OH03300) Hardin'
                  'OH03301'='(OH03301) Ada' 'OH03302'='(OH03302) Kenton' 'OH03303'='(OH03303) Alger'
                  'OH03305'='(OH03305) Forest' 'OH03400'='(OH03400) Harrison' 'OH03401'='(OH03401) Cadiz'
                  'OH03407'='(OH03407) Jewett' 'OH03500'='(OH03500) Henry' 'OH03501'='(OH03501) Napoleon'
                  'OH03502'='(OH03502) Deshler' 'OH03504'='(OH03504) Hamler-Marion Township'
                  'OH03505'='(OH03505) Holgate' 'OH03508'='(OH03508) Mcclure'
                  'OH03600'='(OH03600) Highland' 'OH03601'='(OH03601) Greenfield'
                  'OH03602'='(OH03602) Hillsboro' 'OH03603'='(OH03603) Village Of Leesburg'
                  'OH03604'='(OH03604) Lynchburg' 'OH03700'='(OH03700) Hocking' 'OH03701'='(OH03701) Logan'
                  'OH03800'='(OH03800) Holmes' 'OH03801'='(OH03801) Millersburg'
                  'OH03900'='(OH03900) Huron' 'OH03901'='(OH03901) New London'
                  'OH03902'='(OH03902) Norwalk' 'OH03903'='(OH03903) Willard'
                  'OH03904'='(OH03904) Bellevue' 'OH03905'='(OH03905) Greenwich'
                  'OH03907'='(OH03907) Monroeville' 'OH04000'='(OH04000) Jackson'
                  'OH04001'='(OH04001) Jackson' 'OH04002'='(OH04002) Wellston'
                  'OH04100'='(OH04100) Jefferson' 'OH04102'='(OH04102) Mingo Junction'
                  'OH04103'='(OH04103) Steubenville' 'OH04104'='(OH04104) Toronto'
                  'OH04105'='(OH04105) Wintersville' 'OH04107'='(OH04107) Adena'
                  'OH04108'='(OH04108) Amsterdam' 'OH04114'='(OH04114) Mount Pleasant'
                  'OH04121'='(OH04121) Cross Creek Township'
                  'OH04122'='(OH04122) Saline Township' 'OH04124'='(OH04124) Wells Township'
                  'OH04200'='(OH04200) Knox' 'OH04201'='(OH04201) Mount Vernon'
                  'OH04203'='(OH04203) Danville' 'OH04204'='(OH04204) Fredericktown'
                  'OH04300'='(OH04300) Lake' 'OH04301'='(OH04301) Eastlake'
                  'OH04302'='(OH04302) Fairport Harbor' 'OH04304'='(OH04304) Kirtland Hills'
                  'OH04305'='(OH04305) Madison' 'OH04306'='(OH04306) Mentor'
                  'OH04307'='(OH04307) Mentor-On-The-Lake' 'OH04308'='(OH04308) Painesville'
                  'OH04309'='(OH04309) Perry' 'OH04310'='(OH04310) Waite Hill'
                  'OH04311'='(OH04311) Wickliffe' 'OH04312'='(OH04312) Willoughby'
                  'OH04313'='(OH04313) Willoughby Hills' 'OH04314'='(OH04314) Willowick'
                  'OH04316'='(OH04316) North Perry' 'OH04317'='(OH04317) Timberlake'
                  'OH04318'='(OH04318) Madison Township'
                  'OH04321'='(OH04321) Lakeland Community Colle' 'OH04322'='(OH04322) Kirtland'
                  'OH04324'='(OH04324) Lake Metroparks' 'OH04400'='(OH04400) Lawrence'
                  'OH04401'='(OH04401) Coal Grove' 'OH04402'='(OH04402) Ironton'
                  'OH04404'='(OH04404) Chesapeake' 'OH04405'='(OH04405) Hanging Rock'
                  'OH04500'='(OH04500) Licking' 'OH04501'='(OH04501) Newark'
                  'OH04503'='(OH04503) Granville' 'OH04507'='(OH04507) Heath' 'OH04508'='(OH04508) Hebron'
                  'OH04509'='(OH04509) Johnstown' 'OH04511'='(OH04511) Pataskala'
                  'OH04513'='(OH04513) Utica' 'OH04515'='(OH04515) Union Township'
                  'OH04517'='(OH04517) Buckeye Lake' 'OH04600'='(OH04600) Logan'
                  'OH04601'='(OH04601) Bellefontaine' 'OH04610'='(OH04610) West Liberty'
                  'OH04700'='(OH04700) Lorain' 'OH04701'='(OH04701) Amherst' 'OH04702'='(OH04702) Avon'
                  'OH04703'='(OH04703) Avon Lake' 'OH04704'='(OH04704) Elyria' 'OH04705'='(OH04705) Lorain'
                  'OH04706'='(OH04706) Oberlin' 'OH04707'='(OH04707) North Ridgeville'
                  'OH04708'='(OH04708) Sheffield Lake' 'OH04709'='(OH04709) Wellington'
                  'OH04712'='(OH04712) Lagrange' 'OH04800'='(OH04800) Lucas' 'OH04801'='(OH04801) Maumee'
                  'OH04802'='(OH04802) Oregon' 'OH04803'='(OH04803) Ottawa Hills'
                  'OH04805'='(OH04805) Sylvania' 'OH04806'='(OH04806) Sylvania Township'
                  'OH04807'='(OH04807) Toledo' 'OH04808'='(OH04808) Berkey' 'OH04810'='(OH04810) Holland'
                  'OH04811'='(OH04811) Waterville' 'OH04813'='(OH04813) University Of Toledo'
                  'OH04815'='(OH04815) Washington Township'
                  'OH04818'='(OH04818) Waterville Township'
                  'OH04823'='(OH04823) Toledo-Lucas Cnty Port A' 'OH04900'='(OH04900) madison'
                  'OH04901'='(OH04901) London' 'OH04902'='(OH04902) West Jefferson'
                  'OH04905'='(OH04905) Mount Sterling' 'OH04906'='(OH04906) Plain City'
                  'OH04907'='(OH04907) South Solon' 'OH05000'='(OH05000) Mahoning'
                  'OH05001'='(OH05001) Austintown' 'OH05002'='(OH05002) Boardman'
                  'OH05003'='(OH05003) Campbell' 'OH05004'='(OH05004) Canfield'
                  'OH05005'='(OH05005) Lowellville' 'OH05006'='(OH05006) Poland Village'
                  'OH05007'='(OH05007) Sebring' 'OH05008'='(OH05008) Struthers'
                  'OH05009'='(OH05009) Youngstown' 'OH05011'='(OH05011) Craig Beach'
                  'OH05012'='(OH05012) New Middletown' 'OH05013'='(OH05013) Beaver Township'
                  'OH05014'='(OH05014) Youngstown State Univers'
                  'OH05015'='(OH05015) Smith Township' 'OH05016'='(OH05016) Springfield Township'
                  'OH05018'='(OH05018) Goshen Township' 'OH05020'='(OH05020) Milton Township'
                  'OH05021'='(OH05021) Jackson Township' 'OH05022'='(OH05022) Poland Township'
                  'OH05023'='(OH05023) Coitsville Township' 'OH05100'='(OH05100) Marion'
                  'OH05101'='(OH05101) Marion' 'OH05102'='(OH05102) Caledonia'
                  'OH05107'='(OH05107) Prospect' 'OH05200'='(OH05200) Medina'
                  'OH05201'='(OH05201) Brunswick' 'OH05202'='(OH05202) Medina'
                  'OH05203'='(OH05203) Wadsworth' 'OH05204'='(OH05204) Village Of Chippewa Lake'
                  'OH05207'='(OH05207) Westfield Center' 'OH05208'='(OH05208) Lodi'
                  'OH05209'='(OH05209) Seville' 'OH05210'='(OH05210) Spencer'
                  'OH05211'='(OH05211) Lafayette Township'
                  'OH05212'='(OH05212) Hinckley Township'
                  'OH05213'='(OH05213) Montville Township' 'OH05214'='(OH05214) Medina Township'
                  'OH05300'='(OH05300) Meigs' 'OH05301'='(OH05301) Middleport'
                  'OH05302'='(OH05302) Pomeroy' 'OH05303'='(OH05303) Racine' 'OH05305'='(OH05305) Syracuse'
                  'OH05400'='(OH05400) Mercer' 'OH05401'='(OH05401) Celina' 'OH05404'='(OH05404) Coldwater'
                  'OH05405'='(OH05405) Fort Recovery' 'OH05408'='(OH05408) Rockford'
                  'OH05409'='(OH05409) St. Henry' 'OH05500'='(OH05500) Miami'
                  'OH05501'='(OH05501) Bradford' 'OH05502'='(OH05502) Piqua'
                  'OH05503'='(OH05503) Tipp City' 'OH05504'='(OH05504) Troy'
                  'OH05506'='(OH05506) Covington' 'OH05512'='(OH05512) West Milton'
                  'OH05600'='(OH05600) Monroe' 'OH05601'='(OH05601) Woodsfield'
                  'OH05604'='(OH05604) Clarington' 'OH05700'='(OH05700) Montgomery'
                  'OH05701'='(OH05701) Centerville' 'OH05702'='(OH05702) Dayton'
                  'OH05703'='(OH05703) Germantown' 'OH05704'='(OH05704) Jefferson Township'
                  'OH05705'='(OH05705) Kettering' 'OH05706'='(OH05706) Madison Township'
                  'OH05708'='(OH05708) Miamisburg' 'OH05709'='(OH05709) Moraine'
                  'OH05710'='(OH05710) Oakwood' 'OH05711'='(OH05711) Clayton'
                  'OH05712'='(OH05712) Trotwood' 'OH05713'='(OH05713) Vandalia'
                  'OH05714'='(OH05714) Huber Heights' 'OH05715'='(OH05715) West Carrollton'
                  'OH05716'='(OH05716) Brookville' 'OH05718'='(OH05718) Englewood'
                  'OH05720'='(OH05720) New Lebanon' 'OH05722'='(OH05722) Riverside'
                  'OH05723'='(OH05723) Union' 'OH05724'='(OH05724) Butler Township'
                  'OH05725'='(OH05725) German Township' 'OH05727'='(OH05727) Jackson Township'
                  'OH05728'='(OH05728) Perry Township' 'OH05729'='(OH05729) Clay Township'
                  'OH05733'='(OH05733) Sinclair Community Colle' 'OH05800'='(OH05800) Morgan'
                  'OH05801'='(OH05801) Mcconnelsville' 'OH05803'='(OH05803) Malta'
                  'OH05900'='(OH05900) Morrow' 'OH05901'='(OH05901) Mount Gilead'
                  'OH05902'='(OH05902) Cardington' 'OH05904'='(OH05904) Edison'
                  'OH05905'='(OH05905) Fulton' 'OH06000'='(OH06000) Muskingum'
                  'OH06001'='(OH06001) Zanesville' 'OH06003'='(OH06003) Dresden'
                  'OH06004'='(OH06004) Frazeysburg' 'OH06006'='(OH06006) New Concord'
                  'OH06009'='(OH06009) Roseville' 'OH06010'='(OH06010) South Zanesville'
                  'OH06013'='(OH06013) Muskingum College' 'OH06100'='(OH06100) Noble'
                  'OH06101'='(OH06101) Caldwell' 'OH06200'='(OH06200) Ottawa'
                  'OH06201'='(OH06201) Oak Harbor' 'OH06202'='(OH06202) Port Clinton'
                  'OH06205'='(OH06205) Genoa' 'OH06208'='(OH06208) Rocky Ridge'
                  'OH06212'='(OH06212) Salem Township' 'OH06300'='(OH06300) Paulding'
                  'OH06301'='(OH06301) Paulding' 'OH06309'='(OH06309) Oakwood' 'OH06310'='(OH06310) Payne'
                  'OH06400'='(OH06400) Perry' 'OH06401'='(OH06401) Crooksville'
                  'OH06402'='(OH06402) New Lexington' 'OH06404'='(OH06404) Corning'
                  'OH06407'='(OH06407) Junction City' 'OH06411'='(OH06411) Somerset'
                  'OH06412'='(OH06412) Thornville' 'OH06500'='(OH06500) Pickaway'
                  'OH06501'='(OH06501) Circleville' 'OH06502'='(OH06502) Ashville'
                  'OH06506'='(OH06506) New Holland' 'OH06508'='(OH06508) South Bloomfield'
                  'OH06600'='(OH06600) Pike' 'OH06601'='(OH06601) Waverly' 'OH06602'='(OH06602) Beaver'
                  'OH06700'='(OH06700) Portage' 'OH06701'='(OH06701) Aurora' 'OH06703'='(OH06703) Kent'
                  'OH06705'='(OH06705) Ravenna' 'OH06706'='(OH06706) Windham'
                  'OH06707'='(OH06707) Brady Lake' 'OH06711'='(OH06711) Kent State University'
                  'OH06712'='(OH06712) Streetsboro' 'OH06713'='(OH06713) Brimfield Township'
                  'OH06714'='(OH06714) Robinson Memorial Hosp' 'OH06800'='(OH06800) Preble'
                  'OH06801'='(OH06801) Eaton' 'OH06803'='(OH06803) College Corner'
                  'OH06805'='(OH06805) Gratis' 'OH06807'='(OH06807) New Paris' 'OH06900'='(OH06900) Putnam'
                  'OH06901'='(OH06901) Ottawa' 'OH06910'='(OH06910) Kalida' 'OH06911'='(OH06911) Leipsic'
                  'OH07000'='(OH07000) Richland' 'OH07001'='(OH07001) Mansfield'
                  'OH07002'='(OH07002) Ontario' 'OH07003'='(OH07003) Plymouth' 'OH07004'='(OH07004) Shelby'
                  'OH07005'='(OH07005) Bellville' 'OH07006'='(OH07006) Butler'
                  'OH07007'='(OH07007) Lexington' 'OH07010'='(OH07010) Lincoln Heights'
                  'OH07100'='(OH07100) Ross' 'OH07101'='(OH07101) Chillicothe'
                  'OH07103'='(OH07103) Bainbridge' 'OH07200'='(OH07200) Sandusky'
                  'OH07202'='(OH07202) Clyde' 'OH07203'='(OH07203) Fremont' 'OH07204'='(OH07204) Woodville'
                  'OH07206'='(OH07206) Gibsonburg' 'OH07300'='(OH07300) Scioto'
                  'OH07301'='(OH07301) New Boston' 'OH07302'='(OH07302) Portsmouth'
                  'OH07400'='(OH07400) Seneca' 'OH07401'='(OH07401) Fostoria' 'OH07402'='(OH07402) Tiffin'
                  'OH07403'='(OH07403) Attica' 'OH07404'='(OH07404) Bettsville'
                  'OH07500'='(OH07500) Shelby' 'OH07501'='(OH07501) Sidney'
                  'OH07504'='(OH07504) Fort Loramie' 'OH07505'='(OH07505) Jackson Center'
                  'OH07600'='(OH07600) Stark' 'OH07601'='(OH07601) Alliance' 'OH07602'='(OH07602) Brewster'
                  'OH07603'='(OH07603) Canal Fulton' 'OH07604'='(OH07604) Canton'
                  'OH07605'='(OH07605) East Canton' 'OH07606'='(OH07606) Hartville'
                  'OH07607'='(OH07607) Louisville' 'OH07608'='(OH07608) Massillon'
                  'OH07609'='(OH07609) Minerva' 'OH07610'='(OH07610) Navarre'
                  'OH07611'='(OH07611) North Canton' 'OH07612'='(OH07612) Beach City'
                  'OH07618'='(OH07618) Waynesburg' 'OH07621'='(OH07621) Marlboro Township'
                  'OH07622'='(OH07622) Lawrence Township' 'OH07623'='(OH07623) Perry Township'
                  'OH07624'='(OH07624) Jackson Township' 'OH07625'='(OH07625) Uniontown'
                  'OH07630'='(OH07630) Magnolia' 'OH07700'='(OH07700) Summit' 'OH07701'='(OH07701) Akron'
                  'OH07702'='(OH07702) Barberton' 'OH07703'='(OH07703) Cuyahoga Falls'
                  'OH07704'='(OH07704) Fairlawn' 'OH07705'='(OH07705) Hudson'
                  'OH07706'='(OH07706) Lakemore' 'OH07707'='(OH07707) Macedonia'
                  'OH07708'='(OH07708) Mogadore' 'OH07709'='(OH07709) Northfield'
                  'OH07710'='(OH07710) Norton' 'OH07711'='(OH07711) Silver Lake' 'OH07712'='(OH07712) Stow'
                  'OH07713'='(OH07713) Tallmadge' 'OH07714'='(OH07714) Twinsburg'
                  'OH07716'='(OH07716) Clinton' 'OH07717'='(OH07717) Munroe Falls'
                  'OH07718'='(OH07718) Peninsula' 'OH07719'='(OH07719) Reminderville'
                  'OH07720'='(OH07720) Bath Township' 'OH07721'='(OH07721) Copley'
                  'OH07723'='(OH07723) Northampton Township'
                  'OH07725'='(OH07725) Springfield Township' 'OH07726'='(OH07726) Richfield'
                  'OH07727'='(OH07727) Copley Township' 'OH07728'='(OH07728) University Of Akron'
                  'OH07729'='(OH07729) New Franklin' 'OH07730'='(OH07730) Sagamore Hills'
                  'OH07731'='(OH07731) Richfield Township' 'OH07800'='(OH07800) Trumbull'
                  'OH07801'='(OH07801) Girard' 'OH07802'='(OH07802) Hubbard'
                  'OH07803'='(OH07803) Liberty Township' 'OH07804'='(OH07804) Mcdonald'
                  'OH07805'='(OH07805) Newton Falls' 'OH07806'='(OH07806) Niles'
                  'OH07807'='(OH07807) Warren' 'OH07808'='(OH07808) Cortland'
                  'OH07812'='(OH07812) Howland Township'
                  'OH07813'='(OH07813) Brookfield Township' 'OH07814'='(OH07814) Lordstown'
                  'OH07815'='(OH07815) Bazetta Township' 'OH07816'='(OH07816) Hubbard Township'
                  'OH07817'='(OH07817) Champion Township' 'OH07818'='(OH07818) Newton Township'
                  'OH07821'='(OH07821) Warren Township' 'OH07828'='(OH07828) Vienna Township'
                  'OH07900'='(OH07900) Tuscarawas' 'OH07901'='(OH07901) Dennison'
                  'OH07902'='(OH07902) Dover' 'OH07903'='(OH07903) Newcomerstown'
                  'OH07904'='(OH07904) New Philadelphia' 'OH07905'='(OH07905) Sugarcreek'
                  'OH07906'='(OH07906) Uhrichsville' 'OH07907'='(OH07907) Baltic'
                  'OH07909'='(OH07909) Bolivar' 'OH07910'='(OH07910) Gnadenhutten'
                  'OH07918'='(OH07918) Strasburg' 'OH08000'='(OH08000) Union'
                  'OH08001'='(OH08001) Marysville' 'OH08002'='(OH08002) Richwood'
                  'OH08100'='(OH08100) Van Wert' 'OH08101'='(OH08101) Van Wert'
                  'OH08200'='(OH08200) Vinton' 'OH08300'='(OH08300) Warren' 'OH08301'='(OH08301) Franklin'
                  'OH08302'='(OH08302) Harveysburg' 'OH08303'='(OH08303) Lebanon'
                  'OH08304'='(OH08304) Mason' 'OH08306'='(OH08306) South Lebanon'
                  'OH08308'='(OH08308) Carlisle' 'OH08314'='(OH08314) Springboro'
                  'OH08315'='(OH08315) Waynesville' 'OH08316'='(OH08316) Clearcreek Township'
                  'OH08400'='(OH08400) Washington' 'OH08401'='(OH08401) Belpre'
                  'OH08402'='(OH08402) Marietta' 'OH08403'='(OH08403) New Matamoras'
                  'OH08404'='(OH08404) Beverly' 'OH08405'='(OH08405) Lowell Marshals Dept.'
                  'OH08408'='(OH08408) Marietta College' 'OH08500'='(OH08500) Wayne'
                  'OH08501'='(OH08501) Orrville' 'OH08502'='(OH08502) Rittman'
                  'OH08503'='(OH08503) Wooster' 'OH08507'='(OH08507) Creston' 'OH08508'='(OH08508) Dalton'
                  'OH08509'='(OH08509) Doylestown' 'OH08511'='(OH08511) Marshallville'
                  'OH08513'='(OH08513) Shreve' 'OH08514'='(OH08514) Smithville'
                  'OH08515'='(OH08515) West Salem' 'OH08600'='(OH08600) Williams'
                  'OH08601'='(OH08601) Bryan' 'OH08602'='(OH08602) Montpelier'
                  'OH08605'='(OH08605) Edgerton' 'OH08609'='(OH08609) West Unity'
                  'OH08700'='(OH08700) Wood' 'OH08701'='(OH08701) Bowling Green'
                  'OH08702'='(OH08702) North Baltimore' 'OH08703'='(OH08703) Perrysburg'
                  'OH08704'='(OH08704) Rossford' 'OH08711'='(OH08711) Grand Rapids'
                  'OH08715'='(OH08715) Luckey' 'OH08718'='(OH08718) Northwood'
                  'OH08723'='(OH08723) Walbridge' 'OH08726'='(OH08726) Weston'
                  'OH08727'='(OH08727) Bowling Green State Univ'
                  'OH08728'='(OH08728) Perrysburg Township' 'OH08730'='(OH08730) Lake Township'
                  'OH08734'='(OH08734) Wood County Park Distric' 'OH08800'='(OH08800) Wyandot'
                  'OH08801'='(OH08801) Carey' 'OH08802'='(OH08802) Upper Sandusky'
                  'OH08807'='(OH08807) Sycamore' 'OHCIP00'='(OHCIP00) Cincinnati'
                  'OHCLP00'='(OHCLP00) Cleveland' 'OHCOP00'='(OHCOP00) Columbus'
                  'OHOHP00'='(OHOHP00) Ohio State Hghway Patrol' 'OK00100'='(OK00100) Adair'
                  'OK00101'='(OK00101) Stilwell' 'OK00102'='(OK00102) Westville'
                  'OK00110'='(OK00110) Watts' 'OK00200'='(OK00200) Alfalfa' 'OK00201'='(OK00201) Cherokee'
                  'OK00209'='(OK00209) Helena' 'OK00300'='(OK00300) Atoka' 'OK00301'='(OK00301) Atoka'
                  'OK00308'='(OK00308) Stringtown' 'OK00309'='(OK00309) Tushka'
                  'OK00400'='(OK00400) Beaver' 'OK00402'='(OK00402) Beaver' 'OK00500'='(OK00500) Beckham'
                  'OK00501'='(OK00501) Elk City' 'OK00502'='(OK00502) Erick' 'OK00503'='(OK00503) Sayre'
                  'OK00600'='(OK00600) Blaine' 'OK00601'='(OK00601) Watonga' 'OK00602'='(OK00602) Canton'
                  'OK00605'='(OK00605) Geary' 'OK00609'='(OK00609) Longdale' 'OK00610'='(OK00610) Okeene'
                  'OK00700'='(OK00700) Bryan' 'OK00701'='(OK00701) Durant' 'OK00702'='(OK00702) Achille'
                  'OK00709'='(OK00709) Caddo' 'OK00710'='(OK00710) Calera' 'OK00713'='(OK00713) Colbert'
                  'OK00717'='(OK00717) Kenefic' 'OK00726'='(OK00726) Southeastern Ok St Univ'
                  'OK00800'='(OK00800) Caddo' 'OK00801'='(OK00801) Anadarko' 'OK00804'='(OK00804) Apache'
                  'OK00808'='(OK00808) Carnegie' 'OK00813'='(OK00813) Fort Cobb'
                  'OK00815'='(OK00815) Hinton' 'OK00816'='(OK00816) Hydro' 'OK00900'='(OK00900) Canadian'
                  'OK00901'='(OK00901) El Reno' 'OK00902'='(OK00902) Yukon' 'OK00905'='(OK00905) Mustang'
                  'OK00906'='(OK00906) Piedmont' 'OK00908'='(OK00908) Union City'
                  'OK01000'='(OK01000) Carter' 'OK01001'='(OK01001) Ardmore' 'OK01010'='(OK01010) Healdton'
                  'OK01011'='(OK01011) Lone Grove' 'OK01017'='(OK01017) Wilson'
                  'OK01100'='(OK01100) Cherokee' 'OK01101'='(OK01101) Tahlequah'
                  'OK01105'='(OK01105) Hulbert' 'OK01110'='(OK01110) Northeastern State Univ'
                  'OK01200'='(OK01200) Choctaw' 'OK01201'='(OK01201) Hugo'
                  'OK01205'='(OK01205) Fort Towson' 'OK01300'='(OK01300) Cimarron'
                  'OK01301'='(OK01301) Boise City' 'OK01305'='(OK01305) Keyes'
                  'OK01400'='(OK01400) Cleveland' 'OK01401'='(OK01401) Moore' 'OK01402'='(OK01402) Norman'
                  'OK01403'='(OK01403) Lexington' 'OK01404'='(OK01404) Noble'
                  'OK01405'='(OK01405) Univ Of Ok: Norman' 'OK01407'='(OK01407) Hall Park'
                  'OK01408'='(OK01408) Norman Public Schools' 'OK01500'='(OK01500) Coal'
                  'OK01501'='(OK01501) Coalgate' 'OK01600'='(OK01600) Comanche'
                  'OK01601'='(OK01601) Lawton' 'OK01606'='(OK01606) Fletcher'
                  'OK01615'='(OK01615) Cameron University' 'OK01700'='(OK01700) Cotton'
                  'OK01701'='(OK01701) Walters' 'OK01707'='(OK01707) Temple' 'OK01800'='(OK01800) Craig'
                  'OK01801'='(OK01801) Vinita' 'OK01806'='(OK01806) Ketchum' 'OK01900'='(OK01900) Creek'
                  'OK01901'='(OK01901) Bristow' 'OK01902'='(OK01902) Drumright'
                  'OK01903'='(OK01903) Sapulpa' 'OK01906'='(OK01906) Kellyville'
                  'OK01908'='(OK01908) Mannford' 'OK01910'='(OK01910) Mounds' 'OK01911'='(OK01911) Oilton'
                  'OK02000'='(OK02000) Custer' 'OK02001'='(OK02001) Clinton'
                  'OK02002'='(OK02002) Weatherford'
                  'OK02009'='(OK02009) Southwestern Ok State Un' 'OK02100'='(OK02100) Delaware'
                  'OK02104'='(OK02104) Colcord' 'OK02107'='(OK02107) Grove' 'OK02108'='(OK02108) Jay'
                  'OK02114'='(OK02114) Sandusky' 'OK02200'='(OK02200) Dewey' 'OK02211'='(OK02211) Seiling'
                  'OK02214'='(OK02214) Vici' 'OK02300'='(OK02300) Ellis' 'OK02307'='(OK02307) Shattuck'
                  'OK02400'='(OK02400) Garfield' 'OK02401'='(OK02401) Enid' 'OK02417'='(OK02417) Waukomis'
                  'OK02500'='(OK02500) Garvin' 'OK02501'='(OK02501) Lindsay'
                  'OK02502'='(OK02502) Pauls Valley' 'OK02503'='(OK02503) Wynnewood'
                  'OK02505'='(OK02505) Elmore City' 'OK02509'='(OK02509) Maysville'
                  'OK02510'='(OK02510) Paoli' 'OK02513'='(OK02513) Stratford' 'OK02600'='(OK02600) Grady'
                  'OK02601'='(OK02601) Chickasha' 'OK02609'='(OK02609) Minco'
                  'OK02610'='(OK02610) Ninnekah' 'OK02613'='(OK02613) Rush Springs'
                  'OK02615'='(OK02615) Tuttle' 'OK02700'='(OK02700) Grant' 'OK02704'='(OK02704) Lamont'
                  'OK02800'='(OK02800) Greer' 'OK02801'='(OK02801) Mangum' 'OK02803'='(OK02803) Granite'
                  'OK02900'='(OK02900) Harmon' 'OK02901'='(OK02901) Hollis' 'OK03000'='(OK03000) Harper'
                  'OK03001'='(OK03001) Buffalo' 'OK03002'='(OK03002) Laverne' 'OK03100'='(OK03100) Haskell'
                  'OK03101'='(OK03101) Stigler' 'OK03104'='(OK03104) Keota' 'OK03108'='(OK03108) Mccurtain'
                  'OK03200'='(OK03200) Hughes' 'OK03201'='(OK03201) Holdenville'
                  'OK03202'='(OK03202) Wetumka' 'OK03300'='(OK03300) Jackson' 'OK03301'='(OK03301) Altus'
                  'OK03400'='(OK03400) Jefferson' 'OK03408'='(OK03408) Ringling'
                  'OK03412'='(OK03412) Waurika' 'OK03500'='(OK03500) Johnston'
                  'OK03501'='(OK03501) Tishomingo' 'OK03518'='(OK03518) Murray State College'
                  'OK03600'='(OK03600) Kay' 'OK03601'='(OK03601) Blackwell' 'OK03602'='(OK03602) Newkirk'
                  'OK03603'='(OK03603) Ponca City' 'OK03604'='(OK03604) Tonkawa'
                  'OK03612'='(OK03612) Kaw City' 'OK03700'='(OK03700) Kingfisher'
                  'OK03701'='(OK03701) Hennessey' 'OK03702'='(OK03702) Kingfisher'
                  'OK03707'='(OK03707) Okarche' 'OK03800'='(OK03800) Kiowa' 'OK03801'='(OK03801) Hobart'
                  'OK03811'='(OK03811) Snyder' 'OK03814'='(OK03814) Mountain View'
                  'OK03900'='(OK03900) Latimer' 'OK03901'='(OK03901) Wilburton'
                  'OK04000'='(OK04000) Le Flore' 'OK04001'='(OK04001) Poteau'
                  'OK04002'='(OK04002) Talihina' 'OK04003'='(OK04003) Arkoma' 'OK04005'='(OK04005) Bokoshe'
                  'OK04011'='(OK04011) Heavener' 'OK04014'='(OK04014) Howe' 'OK04022'='(OK04022) Panama'
                  'OK04023'='(OK04023) Pocola' 'OK04027'='(OK04027) Spiro' 'OK04031'='(OK04031) Wister'
                  'OK04100'='(OK04100) Lincoln' 'OK04101'='(OK04101) Chandler' 'OK04102'='(OK04102) Prague'
                  'OK04103'='(OK04103) Stroud' 'OK04104'='(OK04104) Agra' 'OK04106'='(OK04106) Carney'
                  'OK04107'='(OK04107) Davenport' 'OK04111'='(OK04111) Meeker'
                  'OK04117'='(OK04117) Wellston' 'OK04200'='(OK04200) Logan' 'OK04201'='(OK04201) Guthrie'
                  'OK04202'='(OK04202) Coyle' 'OK04203'='(OK04203) Crescent' 'OK04204'='(OK04204) Langston'
                  'OK04300'='(OK04300) Love' 'OK04301'='(OK04301) Marietta' 'OK04400'='(OK04400) Mcclain'
                  'OK04401'='(OK04401) Blanchard' 'OK04402'='(OK04402) Purcell'
                  'OK04406'='(OK04406) Dibble' 'OK04408'='(OK04408) Newcastle'
                  'OK04500'='(OK04500) Mccurtain' 'OK04501'='(OK04501) Broken Bow'
                  'OK04502'='(OK04502) Idabel' 'OK04516'='(OK04516) Valliant'
                  'OK04518'='(OK04518) Wright City' 'OK04600'='(OK04600) Mcintosh'
                  'OK04601'='(OK04601) Checotah' 'OK04602'='(OK04602) Eufaula' 'OK04700'='(OK04700) Major'
                  'OK04701'='(OK04701) Fairview' 'OK04706'='(OK04706) Cleo Springs'
                  'OK04800'='(OK04800) Marshall' 'OK04801'='(OK04801) Madill'
                  'OK04803'='(OK04803) Kingston' 'OK04811'='(OK04811) Madill Public Schools'
                  'OK04900'='(OK04900) Mayes' 'OK04901'='(OK04901) Chouteau' 'OK04902'='(OK04902) Pryor'
                  'OK04907'='(OK04907) Langley' 'OK04908'='(OK04908) Locust Grove'
                  'OK04915'='(OK04915) Salina' 'OK04917'='(OK04917) Spavinaw' 'OK05000'='(OK05000) Murray'
                  'OK05001'='(OK05001) Sulphur' 'OK05002'='(OK05002) Davis' 'OK05100'='(OK05100) Muskogee'
                  'OK05101'='(OK05101) Muskogee' 'OK05107'='(OK05107) Fort Gibson'
                  'OK05108'='(OK05108) Haskell' 'OK05112'='(OK05112) Porum' 'OK05116'='(OK05116) Warner'
                  'OK05200'='(OK05200) Noble' 'OK05201'='(OK05201) Perry' 'OK05207'='(OK05207) Morrison'
                  'OK05300'='(OK05300) Nowata' 'OK05301'='(OK05301) Nowata'
                  'OK05308'='(OK05308) South Coffeyville' 'OK05400'='(OK05400) Okfuskee'
                  'OK05401'='(OK05401) Okemah' 'OK05402'='(OK05402) Weleetka' 'OK05404'='(OK05404) Boley'
                  'OK05408'='(OK05408) Paden' 'OK05500'='(OK05500) Oklahoma' 'OK05501'='(OK05501) Bethany'
                  'OK05502'='(OK05502) Del City' 'OK05503'='(OK05503) Edmond'
                  'OK05504'='(OK05504) Midwest City' 'OK05505'='(OK05505) Nichols Hills'
                  'OK05506'='(OK05506) Oklahoma City' 'OK05507'='(OK05507) The Village'
                  'OK05508'='(OK05508) Warr Acres' 'OK05510'='(OK05510) Choctaw'
                  'OK05511'='(OK05511) Harrah' 'OK05512'='(OK05512) Jones' 'OK05513'='(OK05513) Luther'
                  'OK05514'='(OK05514) Nicoma Park' 'OK05515'='(OK05515) Spencer'
                  'OK05516'='(OK05516) Forest Park'
                  'OK05517'='(OK05517) Univ Of Central Oklahoma'
                  'OK05518'='(OK05518) Univ Of Ok:Health Sc Ctr'
                  'OK05519'='(OK05519) Will Rogers World Air' 'OK05521'='(OK05521) Valley Brook'
                  'OK05522'='(OK05522) Putnam City Campus'
                  'OK05524'='(OK05524) University Hospitals Pd' 'OK05600'='(OK05600) Okmulgee'
                  'OK05601'='(OK05601) Henryetta' 'OK05602'='(OK05602) Okmulgee'
                  'OK05604'='(OK05604) Beggs' 'OK05606'='(OK05606) Dewar' 'OK05611'='(OK05611) Morris'
                  'OK05616'='(OK05616) Ok State Univ: Okmulgee' 'OK05700'='(OK05700) Osage'
                  'OK05701'='(OK05701) Barnsdall' 'OK05702'='(OK05702) Fairfax'
                  'OK05703'='(OK05703) Hominy' 'OK05704'='(OK05704) Pawhuska' 'OK05719'='(OK05719) Shidler'
                  'OK05723'='(OK05723) Wynona' 'OK05800'='(OK05800) Ottawa' 'OK05801'='(OK05801) Commerce'
                  'OK05802'='(OK05802) Miami' 'OK05803'='(OK05803) Picher' 'OK05804'='(OK05804) Afton'
                  'OK05815'='(OK05815) Ne Oklahoma A&m College' 'OK05900'='(OK05900) Pawnee'
                  'OK05901'='(OK05901) Cleveland' 'OK05902'='(OK05902) Pawnee'
                  'OK05908'='(OK05908) Ralston' 'OK06000'='(OK06000) Payne' 'OK06001'='(OK06001) Cushing'
                  'OK06002'='(OK06002) Stillwater' 'OK06003'='(OK06003) Yale' 'OK06004'='(OK06004) Glencoe'
                  'OK06006'='(OK06006) Perkins' 'OK06010'='(OK06010) Ok State Univ: Main Camp'
                  'OK06100'='(OK06100) Pittsburg' 'OK06101'='(OK06101) Hartshorne'
                  'OK06102'='(OK06102) Mcalester' 'OK06114'='(OK06114) Haileyville'
                  'OK06118'='(OK06118) Krebs' 'OK06120'='(OK06120) Quinton'
                  'OK06123'='(OK06123) Mcalester Public Schools' 'OK06200'='(OK06200) Pontotoc'
                  'OK06201'='(OK06201) Ada' 'OK06203'='(OK06203) Allen' 'OK06214'='(OK06214) Stonewall'
                  'OK06216'='(OK06216) East Central University'
                  'OK06300'='(OK06300) Pottawatomie' 'OK06301'='(OK06301) Shawnee'
                  'OK06302'='(OK06302) Tecumseh' 'OK06313'='(OK06313) Maud' 'OK06314'='(OK06314) Mcloud'
                  'OK06400'='(OK06400) Pushmataha' 'OK06401'='(OK06401) Antlers'
                  'OK06403'='(OK06403) Clayton' 'OK06500'='(OK06500) Roger Mills'
                  'OK06502'='(OK06502) Cheyenne' 'OK06505'='(OK06505) Hammon' 'OK06600'='(OK06600) Rogers'
                  'OK06601'='(OK06601) Claremore' 'OK06603'='(OK06603) Catoosa'
                  'OK06604'='(OK06604) Chelsea' 'OK06606'='(OK06606) Inola' 'OK06607'='(OK06607) Oologah'
                  'OK06613'='(OK06613) Rogers State University' 'OK06700'='(OK06700) Seminole'
                  'OK06701'='(OK06701) Konawa' 'OK06702'='(OK06702) Seminole' 'OK06703'='(OK06703) Wewoka'
                  'OK06710'='(OK06710) Sasakwa' 'OK06713'='(OK06713) Seminole State College'
                  'OK06800'='(OK06800) Sequoyah' 'OK06801'='(OK06801) Sallisaw' 'OK06807'='(OK06807) Gore'
                  'OK06812'='(OK06812) Muldrow' 'OK06814'='(OK06814) Roland' 'OK06816'='(OK06816) Vian'
                  'OK06900'='(OK06900) Stephens' 'OK06901'='(OK06901) Comanche'
                  'OK06902'='(OK06902) Duncan' 'OK06903'='(OK06903) Marlow' 'OK07000'='(OK07000) Texas'
                  'OK07001'='(OK07001) Guymon' 'OK07002'='(OK07002) Hooker' 'OK07006'='(OK07006) Goodwell'
                  'OK07010'='(OK07010) Texhoma' 'OK07100'='(OK07100) Tillman'
                  'OK07101'='(OK07101) Frederick' 'OK07200'='(OK07200) Tulsa'
                  'OK07201'='(OK07201) Broken Arrow' 'OK07202'='(OK07202) Collinsville'
                  'OK07203'='(OK07203) Sand Springs' 'OK07204'='(OK07204) Skiatook'
                  'OK07205'='(OK07205) Tulsa' 'OK07206'='(OK07206) Bixby' 'OK07207'='(OK07207) Glenpool'
                  'OK07208'='(OK07208) Jenks' 'OK07210'='(OK07210) Owasso' 'OK07211'='(OK07211) Sperry'
                  'OK07212'='(OK07212) Tulsa Community College'
                  'OK07213'='(OK07213) Jenks Public Schools'
                  'OK07214'='(OK07214) Ok State Univ: Tulsa' 'OK07300'='(OK07300) Wagoner'
                  'OK07301'='(OK07301) Wagoner' 'OK07303'='(OK07303) Coweta' 'OK07307'='(OK07307) Porter'
                  'OK07400'='(OK07400) Washington' 'OK07401'='(OK07401) Bartlesville'
                  'OK07402'='(OK07402) Dewey' 'OK07403'='(OK07403) Copan' 'OK07500'='(OK07500) Washita'
                  'OK07501'='(OK07501) Cordell' 'OK07503'='(OK07503) Burns Flat'
                  'OK07504'='(OK07504) Canute' 'OK07515'='(OK07515) Sentinel' 'OK07600'='(OK07600) Woods'
                  'OK07601'='(OK07601) Alva' 'OK07602'='(OK07602) Waynoka' 'OK07700'='(OK07700) Woodward'
                  'OK07701'='(OK07701) Woodward' 'OK07705'='(OK07705) Mooreland'
                  'OKOHP00'='(OKOHP00) Oklahoma Highway Patrol'
                  'OKOHP17'='(OKOHP17) Capitol Park Police' 'OR00100'='(OR00100) Baker'
                  'OR00101'='(OR00101) Baker City' 'OR00107'='(OR00107) Liquor Comm: Baker Cnty'
                  'OR001SP'='(OR001SP) Sp: Baker County' 'OR00200'='(OR00200) Benton'
                  'OR00201'='(OR00201) Corvallis' 'OR00202'='(OR00202) Philomath'
                  'OR00203'='(OR00203) Monroe' 'OR00204'='(OR00204) Oregon State University'
                  'OR00205'='(OR00205) Liquor Comm: Benton Cnty'
                  'OR002SP'='(OR002SP) Sp: Benton County' 'OR00300'='(OR00300) Clackamas'
                  'OR00301'='(OR00301) Canby' 'OR00302'='(OR00302) Estacada'
                  'OR00303'='(OR00303) Gladstone' 'OR00304'='(OR00304) Lake Oswego'
                  'OR00305'='(OR00305) Milwaukie' 'OR00306'='(OR00306) Molalla'
                  'OR00307'='(OR00307) Oregon City' 'OR00308'='(OR00308) Sandy'
                  'OR00309'='(OR00309) West Linn' 'OR00312'='(OR00312) Wilsonville'
                  'OR003SP'='(OR003SP) Sp: Clackamas County' 'OR00400'='(OR00400) Clatsop'
                  'OR00401'='(OR00401) Astoria' 'OR00402'='(OR00402) Gearhart'
                  'OR00403'='(OR00403) Seaside' 'OR00404'='(OR00404) Warrenton'
                  'OR00405'='(OR00405) Cannon Beach' 'OR00406'='(OR00406) Hammond'
                  'OR00407'='(OR00407) Liquor Comm:Clatsop Cnty'
                  'OR004SP'='(OR004SP) Sp: Clatsop County' 'OR00500'='(OR00500) Columbia'
                  'OR00501'='(OR00501) Clatskanie' 'OR00502'='(OR00502) Rainier'
                  'OR00503'='(OR00503) St. Helens' 'OR00504'='(OR00504) Scappoose'
                  'OR00505'='(OR00505) Vernonia' 'OR00506'='(OR00506) Columbia City'
                  'OR00507'='(OR00507) Liquor Comm:Columbia Cty'
                  'OR005SP'='(OR005SP) Sp: Columbia County' 'OR00600'='(OR00600) Coos'
                  'OR00601'='(OR00601) Bandon' 'OR00602'='(OR00602) Coos Bay'
                  'OR00603'='(OR00603) Coquille' 'OR00604'='(OR00604) Eastside'
                  'OR00605'='(OR00605) Myrtle Point' 'OR00606'='(OR00606) North Bend'
                  'OR00607'='(OR00607) Powers' 'OR00608'='(OR00608) Lakeside'
                  'OR00609'='(OR00609) Liquor Comm: Coos County'
                  'OR006SP'='(OR006SP) Sp: Coos County' 'OR00700'='(OR00700) Crook'
                  'OR00701'='(OR00701) Prineville' 'OR00702'='(OR00702) Liquor Comm: Crook Cnty'
                  'OR007SP'='(OR007SP) Sp: Crook County' 'OR00800'='(OR00800) Curry'
                  'OR00801'='(OR00801) Brookings' 'OR00802'='(OR00802) Gold Beach'
                  'OR00803'='(OR00803) Port Orford' 'OR00804'='(OR00804) Liquor Comm: Curry Cnty'
                  'OR008SP'='(OR008SP) Sp: Curry County' 'OR00900'='(OR00900) Deschutes'
                  'OR00901'='(OR00901) Bend' 'OR00902'='(OR00902) Redmond' 'OR00903'='(OR00903) Sisters'
                  'OR00904'='(OR00904) Black Butte' 'OR00905'='(OR00905) Sunriver'
                  'OR009SP'='(OR009SP) Sp: Deschutes County' 'OR01000'='(OR01000) Douglas'
                  'OR01001'='(OR01001) Canyonville' 'OR01002'='(OR01002) Myrtle Creek'
                  'OR01003'='(OR01003) Reedsport' 'OR01004'='(OR01004) Riddle'
                  'OR01005'='(OR01005) Roseburg' 'OR01006'='(OR01006) Sutherlin'
                  'OR01007'='(OR01007) Winston' 'OR01008'='(OR01008) Drain' 'OR01009'='(OR01009) Oakland'
                  'OR01011'='(OR01011) Glendale' 'OR01012'='(OR01012) Liquor Comm: Douglas Cty'
                  'OR010SP'='(OR010SP) Sp: Douglas County' 'OR01100'='(OR01100) Gilliam'
                  'OR01101'='(OR01101) Arlington' 'OR01102'='(OR01102) Condon'
                  'OR01103'='(OR01103) Liquor Comm: Gilliam Cty'
                  'OR011SP'='(OR011SP) Sp: Gilliam County' 'OR01200'='(OR01200) Grant'
                  'OR01202'='(OR01202) John Day' 'OR01203'='(OR01203) Prairie City'
                  'OR01206'='(OR01206) Liquor Comm: Grant Cnty'
                  'OR012SP'='(OR012SP) Sp: Grant County' 'OR01300'='(OR01300) Harney'
                  'OR01301'='(OR01301) Burns' 'OR01302'='(OR01302) Hines'
                  'OR01303'='(OR01303) Burns Paiute Tribal'
                  'OR01304'='(OR01304) Liquor Comm: Harney Cnty'
                  'OR013SP'='(OR013SP) Sp: Harney County' 'OR01400'='(OR01400) Hood River'
                  'OR01402'='(OR01402) Hood River' 'OR01403'='(OR01403) Liquor Comm:Hood River C'
                  'OR014SP'='(OR014SP) Sp: Hood River County' 'OR01500'='(OR01500) Jackson'
                  'OR01501'='(OR01501) Ashland' 'OR01502'='(OR01502) Central Point'
                  'OR01503'='(OR01503) Jacksonville' 'OR01504'='(OR01504) Medford'
                  'OR01505'='(OR01505) Phoenix' 'OR01506'='(OR01506) Talent'
                  'OR01507'='(OR01507) Eagle Point' 'OR01508'='(OR01508) Gold Hill'
                  'OR01509'='(OR01509) Rogue River' 'OR01510'='(OR01510) Butte Falls'
                  'OR01511'='(OR01511) Shady Cove' 'OR01512'='(OR01512) Liquor Comm: Jackson Cty'
                  'OR015SP'='(OR015SP) sp: Jackson County' 'OR01600'='(OR01600) Jefferson'
                  'OR01601'='(OR01601) Culver' 'OR01602'='(OR01602) Madras'
                  'OR01606'='(OR01606) Liquor Comm:Jefferson Co'
                  'OR016SP'='(OR016SP) Sp: Jefferson County' 'OR01700'='(OR01700) Josephine'
                  'OR01701'='(OR01701) Grants Pass' 'OR01702'='(OR01702) Cave Junction'
                  'OR01703'='(OR01703) Liquor Comm:Josephine Co'
                  'OR017SP'='(OR017SP) Sp: Josephine County' 'OR01800'='(OR01800) Klamath'
                  'OR01801'='(OR01801) Klamath Falls' 'OR01803'='(OR01803) Merrill'
                  'OR01805'='(OR01805) Malin' 'OR01806'='(OR01806) Liquor Comm: Klamath Cty'
                  'OR018SP'='(OR018SP) Sp: Klamath County' 'OR01900'='(OR01900) Lake'
                  'OR01901'='(OR01901) Lakeview' 'OR01902'='(OR01902) Liquor Comm: Lake County'
                  'OR019SP'='(OR019SP) Sp: Lake County' 'OR02000'='(OR02000) Lane'
                  'OR02001'='(OR02001) Cottage Grove' 'OR02002'='(OR02002) Eugene'
                  'OR02003'='(OR02003) Florence' 'OR02004'='(OR02004) Junction City'
                  'OR02005'='(OR02005) Oakridge' 'OR02006'='(OR02006) Springfield'
                  'OR02007'='(OR02007) Coburg' 'OR02008'='(OR02008) Creswell' 'OR02009'='(OR02009) Veneta'
                  'OR02011'='(OR02011) Liquor Comm: Lane County' 'OR02012'='(OR02012) Lowell'
                  'OR020SP'='(OR020SP) Sp: Lane County' 'OR02100'='(OR02100) Lincoln'
                  'OR02101'='(OR02101) Lincoln City' 'OR02102'='(OR02102) Newport'
                  'OR02103'='(OR02103) Toledo' 'OR02104'='(OR02104) Waldport'
                  'OR02105'='(OR02105) Liquor Comm: Lincoln Cty'
                  'OR021SP'='(OR021SP) Sp: Lincoln County' 'OR02200'='(OR02200) Linn'
                  'OR02201'='(OR02201) Albany' 'OR02203'='(OR02203) Lebanon'
                  'OR02204'='(OR02204) Sweet Home' 'OR02205'='(OR02205) Halsey' 'OR02206'='(OR02206) Lyons'
                  'OR02208'='(OR02208) Liquor Comm: Linn County'
                  'OR022SP'='(OR022SP) Sp: Linn County' 'OR02300'='(OR02300) Malheur'
                  'OR02301'='(OR02301) Nyssa' 'OR02302'='(OR02302) Ontario' 'OR02303'='(OR02303) Vale'
                  'OR02305'='(OR02305) Liquor Comm: Malheur Cty'
                  'OR023SP'='(OR023SP) Sp: Malheur County' 'OR02400'='(OR02400) Marion'
                  'OR02401'='(OR02401) Mill City' 'OR02402'='(OR02402) Salem'
                  'OR02403'='(OR02403) Silverton' 'OR02404'='(OR02404) Stayton'
                  'OR02405'='(OR02405) Woodburn' 'OR02406'='(OR02406) Gervais'
                  'OR02407'='(OR02407) Hubbard' 'OR02408'='(OR02408) Mount Angel'
                  'OR02409'='(OR02409) St. Paul' 'OR02410'='(OR02410) Turner'
                  'OR02411'='(OR02411) Jefferson' 'OR02412'='(OR02412) Aumsville'
                  'OR02413'='(OR02413) Donald' 'OR02414'='(OR02414) Aurora'
                  'OR02416'='(OR02416) Liquor Comm: Marion Cnty' 'OR02417'='(OR02417) Keizer'
                  'OR024SP'='(OR024SP) Sp: Marion County' 'OR02500'='(OR02500) Morrow'
                  'OR02501'='(OR02501) Heppner' 'OR02503'='(OR02503) Irrigon'
                  'OR02504'='(OR02504) Boardman' 'OR02505'='(OR02505) Liquor Comm: Morrow Cnty'
                  'OR025SP'='(OR025SP) Sp: Morrow County' 'OR02600'='(OR02600) Multnomah'
                  'OR02601'='(OR02601) Gresham' 'OR02602'='(OR02602) Portland'
                  'OR02603'='(OR02603) Port Of Portland' 'OR02604'='(OR02604) Fairview'
                  'OR02605'='(OR02605) Troutdale' 'OR02611'='(OR02611) Transit District Police'
                  'OR02614'='(OR02614) Liquor Comm:Multnomah Co'
                  'OR026SP'='(OR026SP) Sp: Multnomah County' 'OR02700'='(OR02700) Polk'
                  'OR02701'='(OR02701) Dallas' 'OR02702'='(OR02702) Independence'
                  'OR02703'='(OR02703) Monmouth' 'OR02704'='(OR02704) Falls City'
                  'OR02705'='(OR02705) Liquor Comm: Polk County'
                  'OR027SP'='(OR027SP) Sp: Polk County' 'OR02800'='(OR02800) Sherman'
                  'OR02804'='(OR02804) Liquor Comm: Sherman Cty'
                  'OR028SP'='(OR028SP) Sp: Sherman County' 'OR02900'='(OR02900) Tillamook'
                  'OR02901'='(OR02901) Garibaldi' 'OR02903'='(OR02903) Rockaway Beach'
                  'OR02904'='(OR02904) Tillamook' 'OR02905'='(OR02905) Manzanita'
                  'OR02907'='(OR02907) Liquor Comm:Tillamook Co'
                  'OR029SP'='(OR029SP) Sp: Tillamook County' 'OR03000'='(OR03000) Umatilla'
                  'OR03001'='(OR03001) Hermiston' 'OR03002'='(OR03002) Milton-Freewater'
                  'OR03003'='(OR03003) Pendleton' 'OR03004'='(OR03004) Umatilla'
                  'OR03005'='(OR03005) Athena' 'OR03006'='(OR03006) Echo' 'OR03007'='(OR03007) Pilot Rock'
                  'OR03008'='(OR03008) Stanfield' 'OR03009'='(OR03009) Weston'
                  'OR03011'='(OR03011) Liquor Comm: Umatilla Co'
                  'OR03012'='(OR03012) Umatilla Tribal' 'OR030SP'='(OR030SP) Sp: Umatilla County'
                  'OR03100'='(OR03100) Union' 'OR03101'='(OR03101) La Grande' 'OR03102'='(OR03102) Elgin'
                  'OR03103'='(OR03103) Union' 'OR03105'='(OR03105) Liquor Comm: Union Cnty'
                  'OR031SP'='(OR031SP) Sp: Union County' 'OR03200'='(OR03200) Wallowa'
                  'OR03201'='(OR03201) Enterprise' 'OR03202'='(OR03202) Joseph'
                  'OR03203'='(OR03203) Wallowa' 'OR03204'='(OR03204) Liquor Comm: Wallowa Cty'
                  'OR032SP'='(OR032SP) Sp: Wallowa County' 'OR03300'='(OR03300) Wasco'
                  'OR03301'='(OR03301) The Dalles' 'OR03305'='(OR03305) Liquor Comm: Wasco Cnty'
                  'OR03306'='(OR03306) Rajneeshpuram' 'OR03307'='(OR03307) Antelope'
                  'OR033SP'='(OR033SP) Sp: Wasco County' 'OR03400'='(OR03400) Washington'
                  'OR03401'='(OR03401) Beaverton' 'OR03402'='(OR03402) Forest Grove'
                  'OR03403'='(OR03403) Hillsboro' 'OR03404'='(OR03404) Tigard' 'OR03405'='(OR03405) Gaston'
                  'OR03406'='(OR03406) Sherwood' 'OR03407'='(OR03407) Cornelius'
                  'OR03408'='(OR03408) North Plains' 'OR03409'='(OR03409) Banks'
                  'OR03411'='(OR03411) King City' 'OR03412'='(OR03412) Tualatin'
                  'OR03413'='(OR03413) Liquor Comm:Washington C'
                  'OR034SP'='(OR034SP) Sp: Washington County' 'OR03500'='(OR03500) Wheeler'
                  'OR03503'='(OR03503) Liquor Comm: Wheeler Cty'
                  'OR035SP'='(OR035SP) sp: Wheeler County' 'OR03600'='(OR03600) Yamhill'
                  'OR03601'='(OR03601) Mcminnville' 'OR03602'='(OR03602) Newberg-Dundee'
                  'OR03603'='(OR03603) Willamina' 'OR03604'='(OR03604) Sheridan'
                  'OR03605'='(OR03605) Carlton' 'OR03606'='(OR03606) Dayton' 'OR03607'='(OR03607) Amity'
                  'OR03608'='(OR03608) Yamhill' 'OR03609'='(OR03609) Lafayette'
                  'OR03610'='(OR03610) Dundee' 'OR03611'='(OR03611) Liquor Comm: Yamhill Cty'
                  'OR036SP'='(OR036SP) Sp: Yamhill County' 'OROSP10'='(OROSP10) State Police'
                  'PA00010'='(PA00010) Ode: Adams County'
                  'PA00019'='(PA00019) Ode: Columbia County'
                  'PA00035'='(PA00035) Ode: Lackawana County'
                  'PA00038'='(PA00038) Lebanon-Bur Narc Invest'
                  'PA00065'='(PA00065) Westmoreland-Bur Narc In' 'PA00100'='(PA00100) Adams'
                  'PA00101'='(PA00101) Gettysburg' 'PA00102'='(PA00102) Littlestown'
                  'PA00103'='(PA00103) Conewago Township' 'PA00104'='(PA00104) Mcsherrystown'
                  'PA00105'='(PA00105) Cumberland Township'
                  'PA00106'='(PA00106) Hamiltonban Township' 'PA00107'='(PA00107) New Oxford'
                  'PA00108'='(PA00108) East Berlin' 'PA00111'='(PA00111) Berwick Township'
                  'PA00112'='(PA00112) Liberty Township' 'PA00115'='(PA00115) Biglerville'
                  'PA00118'='(PA00118) Eastern Adams Regional' 'PA00122'='(PA00122) Fairfield'
                  'PA00123'='(PA00123) Carroll Valley'
                  'PA00124'='(PA00124) Latimore-York Sprngs Reg'
                  'PA001BF'='(PA001BF) Bf: Adams County' 'PA001DE'='(PA001DE) Bn: Adams County'
                  'PA001SP'='(PA001SP) Sp: Adams County' 'PA00200'='(PA00200) Allegheny'
                  'PA00201'='(PA00201) Baldwin Borough' 'PA00202'='(PA00202) Bellevue'
                  'PA00203'='(PA00203) Bethel Park' 'PA00204'='(PA00204) Brentwood'
                  'PA00205'='(PA00205) Carnegie' 'PA00206'='(PA00206) Clairton'
                  'PA00207'='(PA00207) Coraopolis' 'PA00208'='(PA00208) Dormont'
                  'PA00209'='(PA00209) Duquesne' 'PA0020A'='(PA0020A) Baldwin Township'
                  'PA0020B'='(PA0020B) Collier Township' 'PA0020C'='(PA0020C) East Deer Township'
                  'PA0020D'='(PA0020D) Elizabeth Township'
                  'PA0020E'='(PA0020E) Harrison Township' 'PA0020F'='(PA0020F) Kennedy Township'
                  'PA0020G'='(PA0020G) Reserve Township' 'PA0020I'='(PA0020I) Snowden Township'
                  'PA0020J'='(PA0020J) South Fayette Township' 'PA0020K'='(PA0020K) White Oak'
                  'PA0020L'='(PA0020L) Wilkins Township' 'PA0020M'='(PA0020M) Wilmerding'
                  'PA0020N'='(PA0020N) Aleppo Township' 'PA0020P'='(PA0020P) Fawn Township'
                  'PA0020R'='(PA0020R) Findlay Township' 'PA0020S'='(PA0020S) Forward Township'
                  'PA0020T'='(PA0020T) Harmar Township' 'PA0020V'='(PA0020V) Indiana Township'
                  'PA0020W'='(PA0020W) Kilbuck Township' 'PA0020X'='(PA0020X) Neville Township'
                  'PA0020Y'='(PA0020Y) North Fayette Township'
                  'PA0020Z'='(PA0020Z) Ohara Township' 'PA00210'='(PA00210) Forest Hills'
                  'PA00211'='(PA00211) Green Tree' 'PA00212'='(PA00212) Homestead'
                  'PA00213'='(PA00213) Mckeesport' 'PA00214'='(PA00214) Mckees Rocks'
                  'PA00215'='(PA00215) Millvale' 'PA00216'='(PA00216) Monroeville'
                  'PA00217'='(PA00217) Mount Lebanon' 'PA00218'='(PA00218) Oakmont'
                  'PA00219'='(PA00219) Penn Hills' 'PA0021A'='(PA0021A) Ohio Township'
                  'PA0021B'='(PA0021B) Northern Regional' 'PA0021C'='(PA0021C) Richland Township'
                  'PA0021D'='(PA0021D) West Deer Township'
                  'PA0021E'='(PA0021E) South Park Township'
                  'PA0021G'='(PA0021G) Pittsburgh Park Police'
                  'PA0021H'='(PA0021H) Crescent Township' 'PA0021I'='(PA0021I) Leet Township'
                  'PA0021N'='(PA0021N) Univ Of Pitt: Pittsburgh'
                  'PA0021P'='(PA0021P) Pa St Univ: Mckeesport'
                  'PA0021R'='(PA0021R) Marshall Township'
                  'PA0021S'='(PA0021S) Springdale Township'
                  'PA00220'='(PA00220) Allegheny Co Da Cid' 'PA00221'='(PA00221) Pleasant Hills'
                  'PA00222'='(PA00222) Ross Township' 'PA00223'='(PA00223) Sewickley'
                  'PA00224'='(PA00224) Sewickley Heights'
                  'PA00225'='(PA00225) Upper St. Clair Township' 'PA00226'='(PA00226) Whitehall'
                  'PA00227'='(PA00227) Wilkinsburg'
                  'PA00228'='(PA00228) Allegheny County Pol Dep' 'PA00229'='(PA00229) Avalon'
                  'PA0022D'='(PA0022D) Allegheny Cnty Port Auth' 'PA00230'='(PA00230) Braddock'
                  'PA00231'='(PA00231) Edgewood' 'PA00232'='(PA00232) Glassport'
                  'PA00233'='(PA00233) Hampton Township' 'PA00234'='(PA00234) Mccandless'
                  'PA00235'='(PA00235) Moon Township' 'PA00236'='(PA00236) Munhall'
                  'PA00238'='(PA00238) North Braddock'
                  'PA00239'='(PA00239) North Versailles Townshi'
                  'PA00240'='(PA00240) Robinson Township' 'PA00241'='(PA00241) Scott Township'
                  'PA00242'='(PA00242) Shaler Township' 'PA00243'='(PA00243) Stowe Township'
                  'PA00244'='(PA00244) Swissvale' 'PA00245'='(PA00245) Turtle Creek'
                  'PA00246'='(PA00246) West Homestead' 'PA00247'='(PA00247) West Mifflin'
                  'PA00248'='(PA00248) Aspinwall' 'PA00249'='(PA00249) Bell Acres'
                  'PA00250'='(PA00250) Ben Avon' 'PA00252'='(PA00252) Blawnox'
                  'PA00253'='(PA00253) Brackenridge' 'PA00254'='(PA00254) Braddock Hills'
                  'PA00255'='(PA00255) Bradford Woods' 'PA00256'='(PA00256) Bridgeville'
                  'PA00257'='(PA00257) Castle Shannon' 'PA00258'='(PA00258) Chalfant'
                  'PA00259'='(PA00259) Cheswick' 'PA00260'='(PA00260) Churchill'
                  'PA00261'='(PA00261) Crafton' 'PA00262'='(PA00262) Dravosburg'
                  'PA00263'='(PA00263) East Mckeesport' 'PA00264'='(PA00264) East Pittsburgh'
                  'PA00265'='(PA00265) Edgeworth' 'PA00266'='(PA00266) Elizabeth'
                  'PA00267'='(PA00267) Emsworth' 'PA00268'='(PA00268) Etna'
                  'PA00269'='(PA00269) Fox Chapel' 'PA00270'='(PA00270) Franklin Park'
                  'PA00273'='(PA00273) Heidelberg' 'PA00274'='(PA00274) Ingram'
                  'PA00275'='(PA00275) Jefferson Hills Borough' 'PA00276'='(PA00276) Leetsdale'
                  'PA00277'='(PA00277) Liberty' 'PA00278'='(PA00278) Lincoln'
                  'PA00279'='(PA00279) Mount Oliver' 'PA00280'='(PA00280) Oakdale'
                  'PA00282'='(PA00282) Osborne' 'PA00283'='(PA00283) Pitcairn' 'PA00285'='(PA00285) Plum'
                  'PA00286'='(PA00286) Port Vue' 'PA00287'='(PA00287) Rankin'
                  'PA00288'='(PA00288) Rosslyn Farms' 'PA00290'='(PA00290) Sharpsburg'
                  'PA00291'='(PA00291) Springdale' 'PA00292'='(PA00292) Tarentum'
                  'PA00293'='(PA00293) Thornburg' 'PA00294'='(PA00294) Verona'
                  'PA00295'='(PA00295) Versailles' 'PA00296'='(PA00296) Wall Borough'
                  'PA00297'='(PA00297) West Elizabeth' 'PA00298'='(PA00298) West View'
                  'PA00299'='(PA00299) Whitaker Borough'
                  'PA002DE'='(PA002DE) Bn: Allegheny County'
                  'PA002SP'='(PA002SP) Sp: Allegheny County' 'PA00300'='(PA00300) Armstrong'
                  'PA00301'='(PA00301) Apollo' 'PA00302'='(PA00302) Ford City'
                  'PA00303'='(PA00303) Freeport' 'PA00304'='(PA00304) Kittanning'
                  'PA00305'='(PA00305) Leechburg' 'PA00308'='(PA00308) Kiskiminetas Township'
                  'PA00309'='(PA00309) North Apollo' 'PA00310'='(PA00310) Parks Township'
                  'PA00311'='(PA00311) Rural Valley' 'PA00312'='(PA00312) South Buffalo Township'
                  'PA00313'='(PA00313) Gilpin Township' 'PA00314'='(PA00314) Manor Township'
                  'PA00318'='(PA00318) Cowanshannock Township'
                  'PA00320'='(PA00320) West Kittanning'
                  'PA00322'='(PA00322) East Franklin Township' 'PA00323'='(PA00323) Parker'
                  'PA00325'='(PA00325) Worthington' 'PA003BF'='(PA003BF) Bf: Armstrong County'
                  'PA003DE'='(PA003DE) Bn: Armstrong County'
                  'PA003SP'='(PA003SP) Sp: Armstrong County' 'PA00400'='(PA00400) Beaver'
                  'PA00401'='(PA00401) Aliquippa' 'PA00402'='(PA00402) Ambridge'
                  'PA00404'='(PA00404) Beaver' 'PA00405'='(PA00405) Beaver Falls'
                  'PA00406'='(PA00406) Midland' 'PA00407'='(PA00407) Rochester' 'PA00408'='(PA00408) Baden'
                  'PA00409'='(PA00409) Brighton Township' 'PA00411'='(PA00411) Economy'
                  'PA00412'='(PA00412) Freedom' 'PA00413'='(PA00413) Harmony Township'
                  'PA00414'='(PA00414) Hopewell Township' 'PA00415'='(PA00415) Monaca'
                  'PA00416'='(PA00416) New Brighton'
                  'PA00417'='(PA00417) North Sewickley Township'
                  'PA00418'='(PA00418) Center Township' 'PA00419'='(PA00419) Chippewa Township'
                  'PA00420'='(PA00420) Conway' 'PA00421'='(PA00421) Daugherty Township'
                  'PA00423'='(PA00423) Independence Township' 'PA00424'='(PA00424) Industry'
                  'PA00425'='(PA00425) Patterson Area' 'PA00427'='(PA00427) Pulaski Township'
                  'PA00428'='(PA00428) Raccoon Township' 'PA00429'='(PA00429) Rochester Township'
                  'PA00431'='(PA00431) White Township' 'PA00432'='(PA00432) Bridgewater'
                  'PA00433'='(PA00433) Koppel' 'PA00434'='(PA00434) East Rochester'
                  'PA00435'='(PA00435) Vanport Township' 'PA00436'='(PA00436) Franklin Township'
                  'PA00438'='(PA00438) New Sewickley Township'
                  'PA00439'='(PA00439) South Beaver Township'
                  'PA00441'='(PA00441) Potter Township' 'PA00442'='(PA00442) Big Beaver Borough'
                  'PA00444'='(PA00444) Marion Township' 'PA00448'='(PA00448) New Galilee Borough'
                  'PA00449'='(PA00449) South Heights' 'PA00450'='(PA00450) West Mayfield Borough'
                  'PA00451'='(PA00451) Shippingport' 'PA00452'='(PA00452) Ohioville'
                  'PA00453'='(PA00453) Pa St Univ: Beaver'
                  'PA00455'='(PA00455) Comm College Of Beaver C'
                  'PA004BF'='(PA004BF) Bf: Beaver County' 'PA004DE'='(PA004DE) Bn: Beaver County'
                  'PA004SP'='(PA004SP) Sp: Beaver County' 'PA00500'='(PA00500) Bedford'
                  'PA00501'='(PA00501) Bedford' 'PA00502'='(PA00502) Everett' 'PA00503'='(PA00503) Hyndman'
                  'PA00504'='(PA00504) Saxton' 'PA00506'='(PA00506) Liberty Township'
                  'PA00507'='(PA00507) Hopewell' 'PA005BF'='(PA005BF) bf: Bedford County'
                  'PA005DE'='(PA005DE) Bn: Bedford County'
                  'PA005SP'='(PA005SP) Sp: Bedford County' 'PA00600'='(PA00600) Berks'
                  'PA00601'='(PA00601) Birdsboro' 'PA00602'='(PA00602) Boyertown'
                  'PA00603'='(PA00603) Cumru Township' 'PA00604'='(PA00604) Exeter Township'
                  'PA00605'='(PA00605) Fleetwood' 'PA00606'='(PA00606) Hamburg'
                  'PA00607'='(PA00607) Kenhorst' 'PA00608'='(PA00608) Kutztown'
                  'PA00609'='(PA00609) Laureldale' 'PA00610'='(PA00610) Leesport'
                  'PA00611'='(PA00611) Mohnton' 'PA00612'='(PA00612) Mount Penn'
                  'PA00613'='(PA00613) Muhlenberg Township' 'PA00614'='(PA00614) Reading'
                  'PA00615'='(PA00615) Robesonia' 'PA00616'='(PA00616) Shillington'
                  'PA00617'='(PA00617) Sinking Spring' 'PA00618'='(PA00618) Spring Township'
                  'PA00619'='(PA00619) Wernersville' 'PA00620'='(PA00620) West Lawn'
                  'PA00621'='(PA00621) West Reading' 'PA00622'='(PA00622) Wyomissing'
                  'PA00623'='(PA00623) Wyomissing Hills'
                  'PA00624'='(PA00624) Caernarvon Township'
                  'PA00625'='(PA00625) Colebrookdale District' 'PA00626'='(PA00626) Bern'
                  'PA00627'='(PA00627) Maiden Creek Township'
                  'PA00628'='(PA00628) Northern Berks Regional'
                  'PA00629'='(PA00629) Robeson Township' 'PA00630'='(PA00630) Bally'
                  'PA00631'='(PA00631) Bern Township' 'PA00634'='(PA00634) Douglass Township'
                  'PA00635'='(PA00635) Central Berks Regional'
                  'PA00636'='(PA00636) Lower Heidelberg Townshi'
                  'PA00637'='(PA00637) Oley Township' 'PA00638'='(PA00638) St. Lawrence Boro'
                  'PA00639'='(PA00639) Shoemakersville' 'PA00640'='(PA00640) Temple'
                  'PA00641'='(PA00641) Berks-Lehigh Regional'
                  'PA00642'='(PA00642) Bethel Township' 'PA00643'='(PA00643) Brecknock Township'
                  'PA00644'='(PA00644) Heidelberg Township'
                  'PA00647'='(PA00647) South Heidelberg Twp'
                  'PA00649'='(PA00649) County Det: Berks County'
                  'PA00650'='(PA00650) Amity Township' 'PA00652'='(PA00652) Womelsdorf'
                  'PA00654'='(PA00654) Marion Township' 'PA00655'='(PA00655) Jefferson Township'
                  'PA00657'='(PA00657) Kutztown University'
                  'PA00659'='(PA00659) Pa St Univ: Berks' 'PA006BF'='(PA006BF) Bf: Berks County'
                  'PA006DE'='(PA006DE) Bn: Berks County' 'PA006SP'='(PA006SP) Sp: Berks County'
                  'PA00700'='(PA00700) Blair' 'PA00701'='(PA00701) Altoona'
                  'PA00702'='(PA00702) Hollidaysburg' 'PA00703'='(PA00703) Logan Township'
                  'PA00704'='(PA00704) Tyrone' 'PA00705'='(PA00705) Bellwood'
                  'PA00706'='(PA00706) Roaring Spring' 'PA00707'='(PA00707) Allegheny Township'
                  'PA00708'='(PA00708) Duncansville' 'PA00709'='(PA00709) Martinsburg'
                  'PA00710'='(PA00710) Williamsburg' 'PA00711'='(PA00711) Greenfield Township'
                  'PA00714'='(PA00714) Pa St Univ: Altoona' 'PA00715'='(PA00715) Blair Township'
                  'PA00716'='(PA00716) Snyder Township'
                  'PA00720'='(PA00720) Tyrone Area School Dist'
                  'PA00799'='(PA00799) Altoona Hospital' 'PA007BF'='(PA007BF) Bf: Blair County'
                  'PA007DE'='(PA007DE) Bn: Blair County' 'PA007SP'='(PA007SP) Sp: Blair County'
                  'PA00800'='(PA00800) Bradford' 'PA00801'='(PA00801) Athens' 'PA00802'='(PA00802) Canton'
                  'PA00803'='(PA00803) Sayre' 'PA00804'='(PA00804) Towanda' 'PA00805'='(PA00805) Troy'
                  'PA00807'='(PA00807) South Waverly' 'PA00808'='(PA00808) Athens Township'
                  'PA008BF'='(PA008BF) Bf: Bradford County'
                  'PA008DE'='(PA008DE) Bn: Bradford County'
                  'PA008SP'='(PA008SP) Sp: Bradford County' 'PA00900'='(PA00900) Bucks'
                  'PA00901'='(PA00901) Bensalem Township' 'PA00902'='(PA00902) Bristol'
                  'PA00903'='(PA00903) Bristol Township' 'PA00904'='(PA00904) Doylestown'
                  'PA00905'='(PA00905) Falls Township'
                  'PA00907'='(PA00907) Lower Makefield Township'
                  'PA00908'='(PA00908) Lower Southampton Twp'
                  'PA00909'='(PA00909) Middletown Township' 'PA00910'='(PA00910) Morrisville'
                  'PA00911'='(PA00911) New Hope' 'PA00912'='(PA00912) Newtown Township'
                  'PA00913'='(PA00913) Northampton Township' 'PA00914'='(PA00914) Penndel'
                  'PA00915'='(PA00915) Perkasie' 'PA00916'='(PA00916) Quakertown'
                  'PA00917'='(PA00917) Pennridge Regional'
                  'PA00918'='(PA00918) Solebury Township' 'PA00919'='(PA00919) Tullytown'
                  'PA00920'='(PA00920) Upper Southampton Twp'
                  'PA00921'='(PA00921) Warminster Township' 'PA00922'='(PA00922) Yardley'
                  'PA00923'='(PA00923) Upper Makefield Township' 'PA00925'='(PA00925) Hulmeville'
                  'PA00926'='(PA00926) Chalfont' 'PA00927'='(PA00927) Doylestown Township'
                  'PA00928'='(PA00928) East Rockhill Township'
                  'PA00929'='(PA00929) Hilltown Township'
                  'PA00932'='(PA00932) New Britain Township' 'PA00934'='(PA00934) Silverdale'
                  'PA00935'='(PA00935) Springfield Township'
                  'PA00936'='(PA00936) Warwick Township'
                  'PA00937'='(PA00937) Washington Crossing St P'
                  'PA00938'='(PA00938) west Rockhill Township' 'PA00939'='(PA00939) New Britain'
                  'PA00941'='(PA00941) Langhorne Manor' 'PA00942'='(PA00942) Nockamixon Township'
                  'PA00943'='(PA00943) Plumstead Township'
                  'PA00944'='(PA00944) Wrightstown Township'
                  'PA00945'='(PA00945) Warrington Township'
                  'PA00947'='(PA00947) Buckingham Township' 'PA00950'='(PA00950) Riegelsville'
                  'PA00951'='(PA00951) Tinicum Township'
                  'PA00953'='(PA00953) Bedminster Township' 'PA00957'='(PA00957) Dublin Borough'
                  'PA00960'='(PA00960) Newtown' 'PA00962'='(PA00962) Richland Township'
                  'PA009BF'='(PA009BF) Bf: Bucks County' 'PA009DE'='(PA009DE) Bn: Bucks County'
                  'PA009SP'='(PA009SP) Sp: Bucks County' 'PA01000'='(PA01000) Butler'
                  'PA01001'='(PA01001) Butler' 'PA01002'='(PA01002) Butler Township'
                  'PA01003'='(PA01003) Slippery Rock' 'PA01004'='(PA01004) Zelienople'
                  'PA01005'='(PA01005) Lyndora' 'PA01006'='(PA01006) Middlesex Township'
                  'PA01007'='(PA01007) Evans City' 'PA01008'='(PA01008) Mars'
                  'PA01009'='(PA01009) Middlesex Township' 'PA01010'='(PA01010) Penn Township'
                  'PA01011'='(PA01011) Slippery Rock University'
                  'PA01012'='(PA01012) Cranberry Township'
                  'PA01017'='(PA01017) County Det: Butler Cnty'
                  'PA01018'='(PA01018) Buffalo Township' 'PA01019'='(PA01019) Saxonburg'
                  'PA01022'='(PA01022) Jackson Township' 'PA01025'='(PA01025) Lancaster Township'
                  'PA01033'='(PA01033) Adams Township' 'PA010BF'='(PA010BF) Bf: Butler County'
                  'PA010DE'='(PA010DE) Bn: Butler County' 'PA010SP'='(PA010SP) Sp: Butler County'
                  'PA01100'='(PA01100) Cambria' 'PA01101'='(PA01101) Northern Cambria Borough'
                  'PA01102'='(PA01102) Conemaugh Township' 'PA01103'='(PA01103) Ebensburg'
                  'PA01104'='(PA01104) Johnstown' 'PA01105'='(PA01105) Richland Township'
                  'PA01106'='(PA01106) Westmont' 'PA01107'='(PA01107) Cresson' 'PA01108'='(PA01108) Dale'
                  'PA01109'='(PA01109) East Conemaugh' 'PA01110'='(PA01110) Gallitzin'
                  'PA01111'='(PA01111) Geistown' 'PA01112'='(PA01112) Nanty Glo'
                  'PA01113'='(PA01113) Patton' 'PA01114'='(PA01114) Portage'
                  'PA01115'='(PA01115) South Fork' 'PA01116'='(PA01116) Southmont'
                  'PA01117'='(PA01117) Spangler Borough'
                  'PA01118'='(PA01118) Upper Yoder Township'
                  'PA01119'='(PA01119) Blacklick Township' 'PA01120'='(PA01120) Cambria Township'
                  'PA01121'='(PA01121) Carrolltown' 'PA01123'='(PA01123) Cresson Township'
                  'PA01126'='(PA01126) East Taylor Township' 'PA01128'='(PA01128) Elder Township'
                  'PA01129'='(PA01129) Ferndale' 'PA01130'='(PA01130) Franklin Boro'
                  'PA01131'='(PA01131) Hastings' 'PA01132'='(PA01132) Jackson Township'
                  'PA01133'='(PA01133) Lilly' 'PA01135'='(PA01135) Loretto'
                  'PA01136'='(PA01136) Middle Taylor Township' 'PA01137'='(PA01137) Sankertown'
                  'PA01140'='(PA01140) Stonycreek Township'
                  'PA01142'='(PA01142) Summerhill Township'
                  'PA01143'='(PA01143) West Carroll Township'
                  'PA01144'='(PA01144) West Taylor Township'
                  'PA01148'='(PA01148) Lower Yoder Township'
                  'PA01149'='(PA01149) Portage Township'
                  'PA01150'='(PA01150) Susquehanna Township' 'PA01152'='(PA01152) Adams Township'
                  'PA01153'='(PA01153) Croyle Township' 'PA01154'='(PA01154) Allegheny Township'
                  'PA01155'='(PA01155) Ashville' 'PA01156'='(PA01156) Vintondale'
                  'PA01158'='(PA01158) Gallitzin Township'
                  'PA01159'='(PA01159) West Hills Regional' 'PA01160'='(PA01160) Tunnelhill'
                  'PA01161'='(PA01161) Washington Township' 'PA01162'='(PA01162) Dean Township'
                  'PA01163'='(PA01163) East Carroll' 'PA011BF'='(PA011BF) Bf: Cambria County'
                  'PA011DE'='(PA011DE) Bn: Cambria County'
                  'PA011SP'='(PA011SP) Sp: Cambria County' 'PA01200'='(PA01200) Cameron'
                  'PA01201'='(PA01201) Emporium' 'PA012BF'='(PA012BF) Bf: Cameron County'
                  'PA012DE'='(PA012DE) Bn: Cameron County'
                  'PA012SP'='(PA012SP) Sp: Cameron County' 'PA01300'='(PA01300) Carbon'
                  'PA01302'='(PA01302) Jim Thorpe' 'PA01303'='(PA01303) Lansford'
                  'PA01304'='(PA01304) Lehighton' 'PA01305'='(PA01305) Palmerton'
                  'PA01306'='(PA01306) Summit Hill' 'PA01307'='(PA01307) Weatherly'
                  'PA01308'='(PA01308) Franklin Township' 'PA01309'='(PA01309) Kidder Township'
                  'PA01310'='(PA01310) Mahoning Township' 'PA01311'='(PA01311) Nesquehoning'
                  'PA01312'='(PA01312) Beaver Meadows' 'PA01316'='(PA01316) Weissport'
                  'PA013BF'='(PA013BF) Bf: Carbon County' 'PA013DE'='(PA013DE) Bn: Carbon County'
                  'PA013SP'='(PA013SP) Sp: Carbon County' 'PA01400'='(PA01400) Centre'
                  'PA01401'='(PA01401) Bellefonte' 'PA01402'='(PA01402) Philipsburg'
                  'PA01403'='(PA01403) State College' 'PA01404'='(PA01404) Milesburg'
                  'PA01405'='(PA01405) Spring Township' 'PA01406'='(PA01406) College Township'
                  'PA01407'='(PA01407) Ferguson Township' 'PA01408'='(PA01408) Harris Township'
                  'PA01409'='(PA01409) Patton Township'
                  'PA01411'='(PA01411) Pa St Univ: Univ Park' 'PA01412'='(PA01412) Snow Shoe'
                  'PA014BF'='(PA014BF) Bf: Centre County' 'PA014DE'='(PA014DE) Bn: Centre County'
                  'PA014SP'='(PA014SP) Sp: Centre County' 'PA01500'='(PA01500) Chester'
                  'PA01501'='(PA01501) Coatesville' 'PA01502'='(PA01502) Downingtown'
                  'PA01503'='(PA01503) Easttown Township'
                  'PA01504'='(PA01504) East Whiteland Township'
                  'PA01505'='(PA01505) Kennett Square' 'PA01506'='(PA01506) Malvern'
                  'PA01507'='(PA01507) North Coventry Township' 'PA01508'='(PA01508) Oxford'
                  'PA01509'='(PA01509) Parkesburg' 'PA01510'='(PA01510) Phoenixville'
                  'PA01511'='(PA01511) Spring City' 'PA01512'='(PA01512) Tredyffrin Township'
                  'PA01513'='(PA01513) West Chester' 'PA01514'='(PA01514) West Goshen Township'
                  'PA01515'='(PA01515) West Grove Borough'
                  'PA01516'='(PA01516) Willistown Township' 'PA01517'='(PA01517) Caln Township'
                  'PA01518'='(PA01518) Atglen' 'PA01519'='(PA01519) Avondale'
                  'PA01520'='(PA01520) Birmingham Township'
                  'PA01521'='(PA01521) East Fallowfield Townshi'
                  'PA01522'='(PA01522) Schuylkill Township'
                  'PA01523'='(PA01523) South Coatesville'
                  'PA01524'='(PA01524) Thornbury Township'
                  'PA01525'='(PA01525) Upper Uwchlan Township'
                  'PA01527'='(PA01527) Westtown-East Goshen Reg'
                  'PA01528'='(PA01528) Uwchlan Township'
                  'PA01532'='(PA01532) East Pikeland Township'
                  'PA01533'='(PA01533) East Vincent Township'
                  'PA01535'='(PA01535) New Garden Township'
                  'PA01536'='(PA01536) Wallace Township'
                  'PA01537'='(PA01537) West Fallowfield Townshi'
                  'PA01538'='(PA01538) West Sadsbury Township'
                  'PA01540'='(PA01540) West Whiteland Township'
                  'PA01542'='(PA01542) Honey Brook Township'
                  'PA01544'='(PA01544) Valley Township'
                  'PA01545'='(PA01545) County Det: Chester Cnty'
                  'PA01546'='(PA01546) West Chester University'
                  'PA01547'='(PA01547) Lincoln University'
                  'PA01548'='(PA01548) East Coventry Township'
                  'PA01549'='(PA01549) Brandywine Regional'
                  'PA01550'='(PA01550) Sadsbury Township'
                  'PA01553'='(PA01553) West Nottingham Township' 'PA01554'='(PA01554) Elverson'
                  'PA01555'='(PA01555) West Brandywine Township'
                  'PA01557'='(PA01557) West Pikeland Township'
                  'PA015BF'='(PA015BF) Bf: Chester County'
                  'PA015DE'='(PA015DE) Bn: Chester County'
                  'PA015SP'='(PA015SP) Sp: Chester County' 'PA01600'='(PA01600) Clarion'
                  'PA01601'='(PA01601) Clarion' 'PA01602'='(PA01602) New Bethlehem'
                  'PA01603'='(PA01603) East Brady' 'PA01604'='(PA01604) Knox'
                  'PA01605'='(PA01605) Rimersburg' 'PA01607'='(PA01607) Clarion University'
                  'PA016BF'='(PA016BF) Bf: Clarion County'
                  'PA016DE'='(PA016DE) Bn: Clarion County'
                  'PA016SP'='(PA016SP) Sp: Clarion County' 'PA01700'='(PA01700) Clearfield'
                  'PA01701'='(PA01701) Clearfield' 'PA01702'='(PA01702) Du Bois'
                  'PA01703'='(PA01703) Curwensville' 'PA01705'='(PA01705) Chester Hill'
                  'PA01706'='(PA01706) Houtzdale' 'PA01707'='(PA01707) Osceola Mills'
                  'PA01708'='(PA01708) Sandy Township' 'PA01711'='(PA01711) Lawrence Township'
                  'PA01713'='(PA01713) Coalport' 'PA01714'='(PA01714) Decatur Township'
                  'PA01716'='(PA01716) Morris-Cooper Regional' 'PA01717'='(PA01717) Irvona'
                  'PA017BF'='(PA017BF) Bf: Clearfield County'
                  'PA017DE'='(PA017DE) Bn: Clearfield County'
                  'PA017SP'='(PA017SP) Sp: Clearfield County' 'PA01800'='(PA01800) Clinton'
                  'PA01801'='(PA01801) Lock Haven' 'PA01802'='(PA01802) Renovo' 'PA01803'='(PA01803) Avis'
                  'PA01806'='(PA01806) Woodward Township' 'PA01807'='(PA01807) Flemington'
                  'PA01809'='(PA01809) Mill Hall' 'PA01810'='(PA01810) Castanea Township'
                  'PA01812'='(PA01812) Lock Haven University'
                  'PA01816'='(PA01816) Pine Creek Township'
                  'PA018BF'='(PA018BF) Bf: Clinton County'
                  'PA018DE'='(PA018DE) Bn: Clinton County'
                  'PA018SP'='(PA018SP) Sp: Clinton County' 'PA01900'='(PA01900) Columbia'
                  'PA01901'='(PA01901) Benton Area' 'PA01902'='(PA01902) Berwick'
                  'PA01903'='(PA01903) Bloomsburg Town' 'PA01904'='(PA01904) Catawissa'
                  'PA01905'='(PA01905) Briar Creek Township' 'PA01906'='(PA01906) Millville'
                  'PA01908'='(PA01908) Scott Township'
                  'PA01909'='(PA01909) Bloomsburg University'
                  'PA01910'='(PA01910) Mifflin Township' 'PA01911'='(PA01911) Briar Creek'
                  'PA01912'='(PA01912) Montour Township'
                  'PA01913'='(PA01913) North Centre Township'
                  'PA01914'='(PA01914) Hemlock Township' 'PA01915'='(PA01915) Locust Township'
                  'PA01916'='(PA01916) South Centre Township'
                  'PA01917'='(PA01917) Benton Township' 'PA01918'='(PA01918) Catawissa Township'
                  'PA01919'='(PA01919) Conyngham Township' 'PA01920'='(PA01920) Centralia'
                  'PA01922'='(PA01922) Main Township' 'PA01923'='(PA01923) Orange Township'
                  'PA01924'='(PA01924) Orangeville Area' 'PA01925'='(PA01925) Franklin Township'
                  'PA01926'='(PA01926) Madison Township' 'PA01927'='(PA01927) Sugarloaf Township'
                  'PA01928'='(PA01928) Stillwater' 'PA01929'='(PA01929) Greenwood Township'
                  'PA01930'='(PA01930) Roaring Creek Township'
                  'PA019BF'='(PA019BF) Bf: Columbia County'
                  'PA019DE'='(PA019DE) Bn: Columbia County'
                  'PA019SP'='(PA019SP) Sp: Columbia County'
                  'PA01BCI'='(PA01BCI) Sp Bci: Adams County' 'PA02000'='(PA02000) Crawford'
                  'PA02001'='(PA02001) Meadville' 'PA02002'='(PA02002) Titusville'
                  'PA02003'='(PA02003) Cambridge Springs' 'PA02005'='(PA02005) Cochranton'
                  'PA02007'='(PA02007) Conneautville' 'PA02008'='(PA02008) Linesville'
                  'PA02009'='(PA02009) Spp: Pymatuning' 'PA02010'='(PA02010) Saegertown'
                  'PA02011'='(PA02011) Vernon Township' 'PA02014'='(PA02014) West Mead Township'
                  'PA02017'='(PA02017) Fairfield Township'
                  'PA02018'='(PA02018) Conneaut Lake Regional'
                  'PA020DE'='(PA020DE) Bn: Crawford County'
                  'PA020SP'='(PA020SP) Sp: Crawford County' 'PA02100'='(PA02100) Cumberland'
                  'PA02101'='(PA02101) Camp Hill' 'PA02102'='(PA02102) Carlisle'
                  'PA02103'='(PA02103) East Pennsboro Township'
                  'PA02104'='(PA02104) Hampden Township'
                  'PA02105'='(PA02105) West Shore Regional'
                  'PA02106'='(PA02106) Lower Allen Township' 'PA02107'='(PA02107) Mechanicsburg'
                  'PA02108'='(PA02108) New Cumberland' 'PA02109'='(PA02109) Shippensburg'
                  'PA02110'='(PA02110) Shiremanstown' 'PA02111'='(PA02111) West Fairview'
                  'PA02112'='(PA02112) Wormleysburg' 'PA02113'='(PA02113) Middlesex Township'
                  'PA02114'='(PA02114) Mount Holly Springs'
                  'PA02115'='(PA02115) North Middleton Township'
                  'PA02116'='(PA02116) Shippensburg University'
                  'PA02117'='(PA02117) Silver Spring Township'
                  'PA02118'='(PA02118) Upper Allen Township' 'PA02119'='(PA02119) Newville'
                  'PA02121'='(PA02121) County Det: Cumberland'
                  'PA02126'='(PA02126) Dickinson College'
                  'PA021BF'='(PA021BF) Bf: Cumberland County'
                  'PA021DE'='(PA021DE) Bn: Cumberland County'
                  'PA021SP'='(PA021SP) Sp: Cumberland County' 'PA02200'='(PA02200) Dauphin'
                  'PA02201'='(PA02201) Elizabethville' 'PA02202'='(PA02202) Harrisburg'
                  'PA02203'='(PA02203) Hummelstown' 'PA02204'='(PA02204) Lower Paxton Township'
                  'PA02205'='(PA02205) Middletown' 'PA02206'='(PA02206) Paxtang'
                  'PA02207'='(PA02207) Steelton' 'PA02208'='(PA02208) Susquehanna Township'
                  'PA02209'='(PA02209) Swatara Township' 'PA02210'='(PA02210) Highspire'
                  'PA02211'='(PA02211) Lykens' 'PA02212'='(PA02212) Millersburg'
                  'PA02213'='(PA02213) Penbrook' 'PA02214'='(PA02214) Williamstown'
                  'PA02215'='(PA02215) Derry Township' 'PA02216'='(PA02216) Halifax Regional'
                  'PA02217'='(PA02217) Lower Swatara Township'
                  'PA02218'='(PA02218) Wiconisco Township' 'PA02221'='(PA02221) Royalton'
                  'PA02222'='(PA02222) Halifax Township'
                  'PA02223'='(PA02223) State Capitol Police'
                  'PA02225'='(PA02225) Liquor Control Board'
                  'PA02226'='(PA02226) County Det: Dauphin Cnty' 'PA02227'='(PA02227) Dauphin'
                  'PA02228'='(PA02228) Pa St Univ: Harrisburg'
                  'PA02232'='(PA02232) Harrisburg Int Airport'
                  'PA02238'='(PA02238) Dept Of Envr. Resources'
                  'PA022BF'='(PA022BF) Bf: Dauphin County'
                  'PA022DE'='(PA022DE) Bn: Dauphin County'
                  'PA022SP'='(PA022SP) Sp: Elizabethville' 'PA02300'='(PA02300) Delaware'
                  'PA02301'='(PA02301) Aston Township' 'PA02302'='(PA02302) Bethel Township'
                  'PA02303'='(PA02303) Brookhaven' 'PA02304'='(PA02304) Chester'
                  'PA02305'='(PA02305) Clifton Heights' 'PA02306'='(PA02306) Collingdale'
                  'PA02307'='(PA02307) Colwyn' 'PA02308'='(PA02308) Darby'
                  'PA02309'='(PA02309) Darby Township' 'PA02310'='(PA02310) East Lansdowne'
                  'PA02311'='(PA02311) Eddystone' 'PA02312'='(PA02312) Folcroft'
                  'PA02313'='(PA02313) Glenolden' 'PA02314'='(PA02314) Haverford Township'
                  'PA02315'='(PA02315) Lansdowne' 'PA02316'='(PA02316) Lower Chichester Townshi'
                  'PA02317'='(PA02317) Marple Township' 'PA02318'='(PA02318) Media'
                  'PA02319'='(PA02319) Millbourne' 'PA02320'='(PA02320) Marcus Hook'
                  'PA02321'='(PA02321) Morton' 'PA02322'='(PA02322) Nether Providence Townsh'
                  'PA02323'='(PA02323) Newtown Township' 'PA02324'='(PA02324) Norwood'
                  'PA02325'='(PA02325) Prospect Park' 'PA02326'='(PA02326) Radnor Township'
                  'PA02327'='(PA02327) Ridley Park' 'PA02328'='(PA02328) Ridley Township'
                  'PA02330'='(PA02330) Sharon Hill' 'PA02331'='(PA02331) Springfield Township'
                  'PA02332'='(PA02332) Swarthmore' 'PA02333'='(PA02333) Tinicum Township'
                  'PA02334'='(PA02334) Trainer' 'PA02335'='(PA02335) Upland'
                  'PA02336'='(PA02336) Upper Chichester Townshi'
                  'PA02337'='(PA02337) Upper Darby Township'
                  'PA02338'='(PA02338) Upper Providence Townshi' 'PA02339'='(PA02339) Yeadon'
                  'PA02340'='(PA02340) Aldan' 'PA02342'='(PA02342) Chester Township'
                  'PA02344'='(PA02344) Delaware County Park' 'PA02345'='(PA02345) Parkside'
                  'PA02348'='(PA02348) Delaware Cnty Da Cid'
                  'PA02350'='(PA02350) Cheyney University'
                  'PA023BF'='(PA023BF) Bf: Delaware County'
                  'PA023DE'='(PA023DE) Bn: Delaware County'
                  'PA023SP'='(PA023SP) Sp: Delaware County' 'PA02400'='(PA02400) Elk'
                  'PA02401'='(PA02401) Johnsonburg' 'PA02402'='(PA02402) Ridgway'
                  'PA02403'='(PA02403) St. Marys City' 'PA02404'='(PA02404) Benzinger Township'
                  'PA02406'='(PA02406) Jay Township' 'PA02407'='(PA02407) Jones Township'
                  'PA024BF'='(PA024BF) Bf: Elk County' 'PA024DE'='(PA024DE) Bn: Elk County'
                  'PA024SP'='(PA024SP) Sp: Elk County' 'PA02500'='(PA02500) Erie'
                  'PA02501'='(PA02501) Corry' 'PA02502'='(PA02502) Erie'
                  'PA02503'='(PA02503) Millcreek Township' 'PA02504'='(PA02504) North East'
                  'PA02505'='(PA02505) Wesleyville' 'PA02506'='(PA02506) Lawrence Park Township'
                  'PA02507'='(PA02507) Union City' 'PA02508'='(PA02508) Albion'
                  'PA02509'='(PA02509) Edinboro' 'PA02510'='(PA02510) Fairview'
                  'PA02511'='(PA02511) Girard' 'PA02512'='(PA02512) Lake City'
                  'PA02513'='(PA02513) Spp: Presque Isle'
                  'PA02517'='(PA02517) Edinboro University'
                  'PA02519'='(PA02519) Pa St Univ: Behrend'
                  'PA02524'='(PA02524) Erie City School Distric'
                  'PA025DE'='(PA025DE) Bn: Erie County' 'PA025SP'='(PA025SP) Sp: Erie County'
                  'PA02600'='(PA02600) Fayette' 'PA02601'='(PA02601) Brownsville'
                  'PA02602'='(PA02602) Connellsville' 'PA02603'='(PA02603) Uniontown'
                  'PA02604'='(PA02604) Southwest Regional' 'PA02605'='(PA02605) Masontown'
                  'PA02606'='(PA02606) Republic' 'PA02607'='(PA02607) South Connellsville Boro'
                  'PA02608'='(PA02608) Washington Township' 'PA02609'='(PA02609) Dawson'
                  'PA02610'='(PA02610) Dunbar' 'PA02611'='(PA02611) Everson'
                  'PA02612'='(PA02612) Fairchance' 'PA02613'='(PA02613) Fayette City'
                  'PA02614'='(PA02614) German Township' 'PA02615'='(PA02615) Luzerne Township'
                  'PA02616'='(PA02616) Menallen Township' 'PA02617'='(PA02617) Perry Township'
                  'PA02618'='(PA02618) Perryopolis' 'PA02619'='(PA02619) Point Marion'
                  'PA02620'='(PA02620) Redstone Township'
                  'PA02623'='(PA02623) Jefferson Township'
                  'PA02624'='(PA02624) South Union Township' 'PA02625'='(PA02625) Smithfield'
                  'PA02628'='(PA02628) Newell' 'PA026BF'='(PA026BF) Bf: Fayette County'
                  'PA026DE'='(PA026DE) Bn: Fayette County'
                  'PA026SP'='(PA026SP) Sp: Fayette County' 'PA02700'='(PA02700) Forest'
                  'PA027BF'='(PA027BF) Bf: Forest County' 'PA027DE'='(PA027DE) Bn: Forest County'
                  'PA027SP'='(PA027SP) Sp: Tionesta' 'PA02800'='(PA02800) Franklin'
                  'PA02801'='(PA02801) Chambersburg' 'PA02802'='(PA02802) Greencastle'
                  'PA02803'='(PA02803) Waynesboro' 'PA02804'='(PA02804) Mercersburg'
                  'PA02805'='(PA02805) Mont Alto' 'PA02806'='(PA02806) Washington Township'
                  'PA02810'='(PA02810) Pa St Univ: Mont Alto'
                  'PA028BF'='(PA028BF) Bf: Franklin County'
                  'PA028DE'='(PA028DE) Bn: Franklin County'
                  'PA028SP'='(PA028SP) Sp: Franklin County' 'PA02900'='(PA02900) Fulton'
                  'PA02901'='(PA02901) Mcconnellsburg' 'PA029BF'='(PA029BF) Bf: Fulton County'
                  'PA029DE'='(PA029DE) Bn: Fulton County' 'PA029SP'='(PA029SP) Sp: Fulton County'
                  'PA02BCI'='(PA02BCI) Sp Bci: Allegheny County' 'PA03000'='(PA03000) Greene'
                  'PA03001'='(PA03001) Waynesburg' 'PA03002'='(PA03002) Carmichaels'
                  'PA03004'='(PA03004) Cumberland Township' 'PA03005'='(PA03005) Perry Township'
                  'PA03006'='(PA03006) Wayne Township' 'PA030BF'='(PA030BF) Bf: Greene County'
                  'PA030DE'='(PA030DE) Bn: Greene County' 'PA030SP'='(PA030SP) Sp: Greene County'
                  'PA03100'='(PA03100) Huntingdon' 'PA03101'='(PA03101) Huntingdon'
                  'PA03102'='(PA03102) Mount Union' 'PA03104'='(PA03104) Juniata Valley Regional'
                  'PA031BF'='(PA031BF) Bf: Huntingdon County'
                  'PA031DE'='(PA031DE) Bn: Huntingdon County'
                  'PA031SP'='(PA031SP) Sp: Huntingdon County' 'PA03200'='(PA03200) Indiana'
                  'PA03201'='(PA03201) Blairsville' 'PA03202'='(PA03202) Homer City'
                  'PA03203'='(PA03203) Indiana' 'PA03204'='(PA03204) Clymer'
                  'PA03205'='(PA03205) Cherry Tree' 'PA03207'='(PA03207) Saltsburg'
                  'PA03210'='(PA03210) Indiana University' 'PA03215'='(PA03215) Marion Center'
                  'PA032BF'='(PA032BF) Bf: Indiana County'
                  'PA032DE'='(PA032DE) Bn: Indiana County'
                  'PA032SP'='(PA032SP) Sp: Indiana County' 'PA03300'='(PA03300) Jefferson'
                  'PA03301'='(PA03301) Brockway' 'PA03302'='(PA03302) Brookville'
                  'PA03303'='(PA03303) Punxsutawney' 'PA03304'='(PA03304) Reynoldsville'
                  'PA03305'='(PA03305) Big Run' 'PA03306'='(PA03306) Falls Creek'
                  'PA03307'='(PA03307) Sykesville' 'PA03311'='(PA03311) Snyder Township'
                  'PA03312'='(PA03312) Summerville' 'PA033BF'='(PA033BF) Bf: Jefferson County'
                  'PA033DE'='(PA033DE) Bn: Jefferson County'
                  'PA033SP'='(PA033SP) Sp: Jefferson County' 'PA03400'='(PA03400) Juniata'
                  'PA03404'='(PA03404) Mifflin' 'PA03405'='(PA03405) Mifflintown'
                  'PA03407'='(PA03407) Port Royal' 'PA034BF'='(PA034BF) Bf: Juniata County'
                  'PA034DE'='(PA034DE) Bn: Juniata County'
                  'PA034SP'='(PA034SP) Sp: Juniata County' 'PA03500'='(PA03500) Lackawanna'
                  'PA03501'='(PA03501) Carbondale' 'PA03502'='(PA03502) Dunmore'
                  'PA03503'='(PA03503) Old Forge' 'PA03504'='(PA03504) Scranton'
                  'PA03505'='(PA03505) Archbald' 'PA03506'='(PA03506) Blakely'
                  'PA03507'='(PA03507) Clarks Summit' 'PA03508'='(PA03508) Dickson City'
                  'PA03509'='(PA03509) Jermyn' 'PA03511'='(PA03511) Olyphant' 'PA03512'='(PA03512) Taylor'
                  'PA03513'='(PA03513) Throop' 'PA03516'='(PA03516) Jessup' 'PA03517'='(PA03517) Mayfield'
                  'PA03518'='(PA03518) Moscow' 'PA03519'='(PA03519) South Abington Township'
                  'PA03520'='(PA03520) Vandling' 'PA03522'='(PA03522) Dalton' 'PA03523'='(PA03523) Moosic'
                  'PA03525'='(PA03525) Fell Township' 'PA03526'='(PA03526) Newton Township'
                  'PA03527'='(PA03527) Scott Township' 'PA03529'='(PA03529) Clarks Green'
                  'PA03530'='(PA03530) Greenfield Township'
                  'PA03531'='(PA03531) Roaring Brook Township'
                  'PA03533'='(PA03533) Covington Township'
                  'PA035BF'='(PA035BF) Bf: Lackawanna County'
                  'PA035DE'='(PA035DE) Bn: Lackawanna County'
                  'PA035SP'='(PA035SP) Sp: Lackawanna County' 'PA03600'='(PA03600) Lancaster'
                  'PA03601'='(PA03601) Columbia' 'PA03602'='(PA03602) Elizabethtown'
                  'PA03603'='(PA03603) Ephrata' 'PA03604'='(PA03604) Ephrata Township'
                  'PA03605'='(PA03605) Lancaster' 'PA03606'='(PA03606) Lititz'
                  'PA03607'='(PA03607) Manheim' 'PA03608'='(PA03608) Manheim Township'
                  'PA03609'='(PA03609) Marietta' 'PA03610'='(PA03610) Mount Joy'
                  'PA03611'='(PA03611) New Holland' 'PA03612'='(PA03612) Lancaster Township'
                  'PA03613'='(PA03613) Millersville' 'PA03614'='(PA03614) West Lampeter Township'
                  'PA03615'='(PA03615) Adamstown' 'PA03616'='(PA03616) Akron'
                  'PA03617'='(PA03617) Caernarvon Township' 'PA03618'='(PA03618) Christiana'
                  'PA03619'='(PA03619) Colerain-Little Britain' 'PA03620'='(PA03620) Denver'
                  'PA03621'='(PA03621) Earl Township'
                  'PA03623'='(PA03623) East Hempfield Township'
                  'PA03624'='(PA03624) East Petersburg' 'PA03625'='(PA03625) Manor Township'
                  'PA03626'='(PA03626) Nw Lancaster Cnty Rgnl'
                  'PA03627'='(PA03627) Pequea Township' 'PA03628'='(PA03628) Sadsbury Township'
                  'PA03629'='(PA03629) Quarryville' 'PA03630'='(PA03630) Strasburg'
                  'PA03631'='(PA03631) Terre Hill' 'PA03632'='(PA03632) Warwick Township'
                  'PA03633'='(PA03633) Washington' 'PA03634'='(PA03634) West Hempfield Township'
                  'PA03635'='(PA03635) Southern Reg Lancaster C'
                  'PA03636'='(PA03636) conoy Township'
                  'PA03637'='(PA03637) East Cocalico Township'
                  'PA03638'='(PA03638) Susquehanna Regional'
                  'PA03639'='(PA03639) East Earl Township'
                  'PA03640'='(PA03640) East Lampeter Township'
                  'PA03641'='(PA03641) Penn Township'
                  'PA03642'='(PA03642) Upper Leacock Township'
                  'PA03643'='(PA03643) West Cocalico Township'
                  'PA03644'='(PA03644) West Donegal Township'
                  'PA03645'='(PA03645) Lancaster Co Detective'
                  'PA03648'='(PA03648) West Earl Township'
                  'PA03650'='(PA03650) Elizabethtown College'
                  'PA03651'='(PA03651) Millersville University'
                  'PA03652'='(PA03652) Clay Township' 'PA03653'='(PA03653) Brecknock Township'
                  'PA036BF'='(PA036BF) Bf: Lancaster County'
                  'PA036DE'='(PA036DE) Bn: Lancaster County'
                  'PA036SP'='(PA036SP) Sp: Lancaster County' 'PA03700'='(PA03700) Lawrence'
                  'PA03701'='(PA03701) Ellwood City' 'PA03702'='(PA03702) New Castle'
                  'PA03703'='(PA03703) Shenango Township' 'PA03704'='(PA03704) Bessemer'
                  'PA03705'='(PA03705) Neshannock Township' 'PA03706'='(PA03706) New Wilmington'
                  'PA03708'='(PA03708) Union Township' 'PA03709'='(PA03709) Perry Township'
                  'PA03713'='(PA03713) South New Castle'
                  'PA03714'='(PA03714) Nw Lawrence Cnty Regnl' 'PA03717'='(PA03717) Wampum'
                  'PA037BF'='(PA037BF) Bf: Lawrence County'
                  'PA037DE'='(PA037DE) Bn: Lawrence County'
                  'PA037SP'='(PA037SP) Sp: Lawrence County' 'PA03800'='(PA03800) Lebanon'
                  'PA03801'='(PA03801) Annville Township' 'PA03802'='(PA03802) Lebanon'
                  'PA03803'='(PA03803) Palmyra' 'PA03804'='(PA03804) Richland'
                  'PA03805'='(PA03805) Myerstown' 'PA03806'='(PA03806) South Lebanon Township'
                  'PA03807'='(PA03807) Bethel Township' 'PA03808'='(PA03808) Cleona'
                  'PA03809'='(PA03809) Cornwall' 'PA03810'='(PA03810) Heidelberg Township'
                  'PA03811'='(PA03811) Mount Gretna Borough'
                  'PA03812'='(PA03812) North Cornwall Township'
                  'PA03813'='(PA03813) North Lebanon Township' 'PA03814'='(PA03814) Cleona'
                  'PA03816'='(PA03816) North Londonderry Townsh'
                  'PA03817'='(PA03817) South Annville Township'
                  'PA03819'='(PA03819) West Cornwall Township'
                  'PA03821'='(PA03821) County Det: Lebanon Cnty'
                  'PA03822'='(PA03822) South Londonderry Townsh'
                  'PA03823'='(PA03823) West Lebanon Township'
                  'PA038BF'='(PA038BF) Bf: Lebanon County'
                  'PA038DE'='(PA038DE) Bn: Lebanon County'
                  'PA038SP'='(PA038SP) Sp: Lebanon County' 'PA03900'='(PA03900) Lehigh'
                  'PA03901'='(PA03901) Allentown' 'PA03902'='(PA03902) Catasauqua'
                  'PA03903'='(PA03903) Coopersburg' 'PA03904'='(PA03904) Emmaus'
                  'PA03905'='(PA03905) Fountain Hill' 'PA03906'='(PA03906) Salisbury Township'
                  'PA03907'='(PA03907) Slatington' 'PA03908'='(PA03908) Whitehall Township'
                  'PA03909'='(PA03909) Coplay' 'PA03910'='(PA03910) Lower Milford Township'
                  'PA03911'='(PA03911) Upper Saucon Township' 'PA03912'='(PA03912) Macungie'
                  'PA03913'='(PA03913) South Whitehall Township' 'PA03914'='(PA03914) Alburtis'
                  'PA03919'='(PA03919) County Det: Lehigh Cnty'
                  'PA03921'='(PA03921) Lehigh Valley Intl Airp'
                  'PA039BF'='(PA039BF) Bf: Lehigh County' 'PA039DE'='(PA039DE) Bn: Lehigh County'
                  'PA039SP'='(PA039SP) Sp: Lehigh County' 'PA04000'='(PA04000) Luzerne'
                  'PA04001'='(PA04001) Dallas' 'PA04002'='(PA04002) Dupont' 'PA04003'='(PA04003) Duryea'
                  'PA04004'='(PA04004) Edwardsville' 'PA04005'='(PA04005) Freeland'
                  'PA04006'='(PA04006) Hanover Township' 'PA04007'='(PA04007) Hazleton'
                  'PA04008'='(PA04008) Kingston' 'PA04009'='(PA04009) Luzerne'
                  'PA04010'='(PA04010) Nanticoke' 'PA04011'='(PA04011) Pittston'
                  'PA04012'='(PA04012) Plymouth' 'PA04013'='(PA04013) Wilkes-Barre'
                  'PA04014'='(PA04014) Wyoming' 'PA04015'='(PA04015) Ashley' 'PA04016'='(PA04016) Avoca'
                  'PA04017'='(PA04017) Exeter' 'PA04018'='(PA04018) Forty Fort'
                  'PA04019'='(PA04019) Larksville' 'PA04020'='(PA04020) Newport Township'
                  'PA04021'='(PA04021) Plains Township' 'PA04022'='(PA04022) Sugar Notch'
                  'PA04023'='(PA04023) Swoyersville' 'PA04024'='(PA04024) West Hazleton'
                  'PA04025'='(PA04025) West Pittston' 'PA04026'='(PA04026) West Wyoming'
                  'PA04027'='(PA04027) Wilkes-Barre Township' 'PA04029'='(PA04029) Conyngham'
                  'PA04031'='(PA04031) Fairview Township' 'PA04032'='(PA04032) Lake Township'
                  'PA04033'='(PA04033) Lehman Township' 'PA04034'='(PA04034) Nescopeck'
                  'PA04035'='(PA04035) Plymouth Township' 'PA04037'='(PA04037) Shickshinny'
                  'PA04038'='(PA04038) White Haven Borough' 'PA04039'='(PA04039) Wright Township'
                  'PA04040'='(PA04040) Harveys Lake' 'PA04041'='(PA04041) Jackson Township'
                  'PA04043'='(PA04043) Pringle' 'PA04044'='(PA04044) Exeter Township'
                  'PA04045'='(PA04045) Jenkins Township' 'PA04049'='(PA04049) Pittston Township'
                  'PA04050'='(PA04050) Dallas Township' 'PA04051'='(PA04051) Kingston Township'
                  'PA04056'='(PA04056) Butler Township' 'PA04057'='(PA04057) Rice Township'
                  'PA04060'='(PA04060) Sugarloaf Township' 'PA04061'='(PA04061) Courtdale'
                  'PA04062'='(PA04062) Laflin Borough' 'PA04063'='(PA04063) Conyngham Township'
                  'PA04071'='(PA04071) Pa St Univ: Hazelton'
                  'PA040BF'='(PA040BF) Bf: Luzerne County'
                  'PA040DE'='(PA040DE) Bn: Luzerne County'
                  'PA040SP'='(PA040SP) Sp: Luzerne County' 'PA04100'='(PA04100) Lycoming'
                  'PA04101'='(PA04101) Jersey Shore' 'PA04102'='(PA04102) Montoursville'
                  'PA04103'='(PA04103) Muncy' 'PA04104'='(PA04104) South Williamsport'
                  'PA04105'='(PA04105) Williamsport' 'PA04106'='(PA04106) Clinton Township'
                  'PA04108'='(PA04108) Hughesville' 'PA04109'='(PA04109) Montgomery'
                  'PA04110'='(PA04110) Duboistown' 'PA04115'='(PA04115) Old Lycoming Township'
                  'PA041BF'='(PA041BF) Bf: Lycoming County'
                  'PA041DE'='(PA041DE) Bn: Lycoming County'
                  'PA041SP'='(PA041SP) Sp: Lycoming County' 'PA04200'='(PA04200) Mckean'
                  'PA04201'='(PA04201) Bradford' 'PA04202'='(PA04202) Kane'
                  'PA04203'='(PA04203) Port Allegany' 'PA04204'='(PA04204) Bradford Township'
                  'PA04205'='(PA04205) Foster Township' 'PA04206'='(PA04206) Mount Jewett'
                  'PA04207'='(PA04207) Eldred' 'PA04208'='(PA04208) Smethport'
                  'PA04212'='(PA04212) Lewis Run' 'PA04215'='(PA04215) Univ Of Pitt: Bradford'
                  'PA042BF'='(PA042BF) Bf: Mckean County' 'PA042DE'='(PA042DE) Bn: Mckean County'
                  'PA042SP'='(PA042SP) Sp: Mckean County' 'PA04300'='(PA04300) Mercer'
                  'PA04301'='(PA04301) Sw Mercer Cnty Regional' 'PA04302'='(PA04302) Greenville'
                  'PA04303'='(PA04303) Grove City' 'PA04304'='(PA04304) Hermitage'
                  'PA04305'='(PA04305) Mercer' 'PA04306'='(PA04306) Sharon'
                  'PA04307'='(PA04307) Sharpsville' 'PA04308'='(PA04308) Pymatuning Township'
                  'PA04309'='(PA04309) Hempfield Township' 'PA04310'='(PA04310) Sandy Lake'
                  'PA04311'='(PA04311) Shenango Township' 'PA04312'='(PA04312) Wheatland'
                  'PA04313'='(PA04313) West Middlesex Boro' 'PA04314'='(PA04314) Stoneboro'
                  'PA04315'='(PA04315) Jefferson Township' 'PA04318'='(PA04318) Clark Borough'
                  'PA04320'='(PA04320) Greene Township' 'PA04321'='(PA04321) Jamestown'
                  'PA04322'='(PA04322) West Salem Township'
                  'PA04324'='(PA04324) South Pymatuning Townshi'
                  'PA043DE'='(PA043DE) Bn: Mercer County' 'PA043SP'='(PA043SP) Sp: Mercer County'
                  'PA04400'='(PA04400) Mifflin' 'PA04401'='(PA04401) Mifflin County Regional'
                  'PA04402'='(PA04402) Burnham' 'PA04403'='(PA04403) Derry Township'
                  'PA04406'='(PA04406) Armagh Township' 'PA04407'='(PA04407) Granville Township'
                  'PA04409'='(PA04409) Union Township' 'PA044BF'='(PA044BF) Bf: Mifflin County'
                  'PA044DE'='(PA044DE) Bn: Mifflin County'
                  'PA044SP'='(PA044SP) Sp: Mifflin County' 'PA04500'='(PA04500) Monroe'
                  'PA04501'='(PA04501) Delaware Water Gap' 'PA04502'='(PA04502) East Stroudsburg'
                  'PA04503'='(PA04503) Stroudsburg' 'PA04504'='(PA04504) Barrett Township'
                  'PA04505'='(PA04505) Coolbaugh Township'
                  'PA04506'='(PA04506) Mount Pocono Borough'
                  'PA04507'='(PA04507) Pocono Township'
                  'PA04508'='(PA04508) Stroud Area Regional'
                  'PA04509'='(PA04509) Pocono Mountain Regional'
                  'PA04511'='(PA04511) East Stroudsburg Univers'
                  'PA04513'='(PA04513) Tunkhannock Township'
                  'PA045BF'='(PA045BF) Bf: Monroe County' 'PA045DE'='(PA045DE) Bn: Monroe County'
                  'PA045SP'='(PA045SP) Sp: Monroe County' 'PA04600'='(PA04600) Montgomery'
                  'PA04601'='(PA04601) Abington Township' 'PA04602'='(PA04602) Ambler'
                  'PA04603'='(PA04603) Bridgeport' 'PA04604'='(PA04604) Bryn Athyn'
                  'PA04605'='(PA04605) Cheltenham Township' 'PA04606'='(PA04606) Collegeville'
                  'PA04607'='(PA04607) Conshohocken' 'PA04608'='(PA04608) East Norriton Township'
                  'PA04609'='(PA04609) Hatboro' 'PA04610'='(PA04610) Horsham Township'
                  'PA04611'='(PA04611) Jenkintown' 'PA04612'='(PA04612) Lansdale'
                  'PA04613'='(PA04613) Lower Gwynedd Township'
                  'PA04614'='(PA04614) Lower Merion Township'
                  'PA04615'='(PA04615) Lower Moreland Township'
                  'PA04616'='(PA04616) Lower Pottsgrove Townshi'
                  'PA04617'='(PA04617) Lower Providence Townshi'
                  'PA04618'='(PA04618) Montgomery Township' 'PA04619'='(PA04619) Norristown'
                  'PA04620'='(PA04620) North Wales' 'PA04621'='(PA04621) Plymouth Township'
                  'PA04622'='(PA04622) Pottstown' 'PA04623'='(PA04623) Springfield Township'
                  'PA04624'='(PA04624) Rockledge' 'PA04625'='(PA04625) Royersford'
                  'PA04626'='(PA04626) Souderton' 'PA04627'='(PA04627) Upper Dublin Township'
                  'PA04628'='(PA04628) Upper Gwynedd Township'
                  'PA04629'='(PA04629) Upper Merion Township'
                  'PA04630'='(PA04630) Upper Moreland Township'
                  'PA04631'='(PA04631) West Norriton Township'
                  'PA04632'='(PA04632) Whitemarsh Township'
                  'PA04633'='(PA04633) Whitpain Township' 'PA04635'='(PA04635) Narberth'
                  'PA04636'='(PA04636) West Conshohocken' 'PA04637'='(PA04637) Telford'
                  'PA04638'='(PA04638) Upper Providence Townshi' 'PA04640'='(PA04640) Hatfield'
                  'PA04641'='(PA04641) Hatfield Township'
                  'PA04642'='(PA04642) Lower Frederick Township'
                  'PA04643'='(PA04643) Lower Salford Township' 'PA04644'='(PA04644) Red Hill'
                  'PA04646'='(PA04646) Upper Pottsgrove Townshi'
                  'PA04647'='(PA04647) Valley Forge State Park'
                  'PA04648'='(PA04648) West Pottsgrove Township'
                  'PA04649'='(PA04649) Douglass Township' 'PA04650'='(PA04650) Upper Perkiomen'
                  'PA04651'='(PA04651) Franconia Township'
                  'PA04652'='(PA04652) County Det: Montgomery C'
                  'PA04653'='(PA04653) limerick Township'
                  'PA04654'='(PA04654) New Hanover Township'
                  'PA04655'='(PA04655) Perkiomen Township'
                  'PA04657'='(PA04657) Marlborough Township'
                  'PA04658'='(PA04658) Upper Hanover Township'
                  'PA04659'='(PA04659) Towamencin Township'
                  'PA046BF'='(PA046BF) Bf: Montgomery County'
                  'PA046DE'='(PA046DE) Bn: Montgomery County' 'PA046SP'='(PA046SP) Sp: Skippack'
                  'PA04700'='(PA04700) Montour' 'PA04701'='(PA04701) Danville'
                  'PA04702'='(PA04702) Mahoning Township'
                  'PA047BF'='(PA047BF) Bf: Montour County'
                  'PA047DE'='(PA047DE) Bn: Montour County'
                  'PA047SP'='(PA047SP) Sp: Montour County' 'PA04800'='(PA04800) Northampton'
                  'PA04801'='(PA04801) Bangor' 'PA04802'='(PA04802) Colonial Regional'
                  'PA04803'='(PA04803) Bethlehem' 'PA04804'='(PA04804) Easton'
                  'PA04805'='(PA04805) Hellertown' 'PA04806'='(PA04806) Lehigh Township'
                  'PA04807'='(PA04807) Nazareth Area' 'PA04808'='(PA04808) Northampton'
                  'PA04809'='(PA04809) Palmer Township' 'PA04810'='(PA04810) Wilson'
                  'PA04811'='(PA04811) Pen Argyl' 'PA04812'='(PA04812) Bethlehem Township'
                  'PA04813'='(PA04813) Bushkill Township' 'PA04814'='(PA04814) East Bangor'
                  'PA04815'='(PA04815) Forks Township'
                  'PA04816'='(PA04816) Lower Mount Bethel Towns'
                  'PA04817'='(PA04817) Lower Saucon Township'
                  'PA04818'='(PA04818) Moore Township' 'PA04819'='(PA04819) North Catasauqua'
                  'PA04820'='(PA04820) Plainfield Township' 'PA04821'='(PA04821) Portland'
                  'PA04822'='(PA04822) Roseto' 'PA04823'='(PA04823) Tatamy'
                  'PA04824'='(PA04824) Upper Mount Bethel Towns'
                  'PA04825'='(PA04825) Washington Township' 'PA04826'='(PA04826) Wind Gap'
                  'PA04828'='(PA04828) Walnutport' 'PA04831'='(PA04831) Freemansburg'
                  'PA04832'='(PA04832) Upper Nazareth Township' 'PA04834'='(PA04834) Stockertown'
                  'PA04835'='(PA04835) Lehigh University' 'PA04836'='(PA04836) Moravian College'
                  'PA048BF'='(PA048BF) Bf: Northampton County'
                  'PA048DE'='(PA048DE) Bn: Northampton County'
                  'PA048SP'='(PA048SP) Sp: Northampton County'
                  'PA04900'='(PA04900) Northumberland' 'PA04901'='(PA04901) Milton'
                  'PA04902'='(PA04902) Mount Carmel' 'PA04903'='(PA04903) Northumberland'
                  'PA04904'='(PA04904) Shamokin' 'PA04905'='(PA04905) Sunbury'
                  'PA04906'='(PA04906) Coal Township' 'PA04907'='(PA04907) Kulpmont'
                  'PA04909'='(PA04909) Zerbe Township' 'PA04912'='(PA04912) Ralpho Township'
                  'PA04913'='(PA04913) Riverside' 'PA04914'='(PA04914) Watsontown'
                  'PA04916'='(PA04916) Point Township'
                  'PA04918'='(PA04918) Mount Carmel Township'
                  'PA049BF'='(PA049BF) Bf: Northumberland Cnty'
                  'PA049DE'='(PA049DE) Bn: Northumberland Cnty'
                  'PA049SP'='(PA049SP) Sp: Northumberland Cnty'
                  'PA04BCI'='(PA04BCI) Sp Bci: Beaver County' 'PA05000'='(PA05000) Perry'
                  'PA05001'='(PA05001) Marysville' 'PA05002'='(PA05002) Duncannon'
                  'PA05003'='(PA05003) Newport' 'PA05004'='(PA05004) Rye Township'
                  'PA050BF'='(PA050BF) Bf: Perry County' 'PA050DE'='(PA050DE) Bn: Perry County'
                  'PA050SP'='(PA050SP) Sp: Perry County' 'PA05100'='(PA05100) Philadelphia'
                  'PA05101'='(PA05101) Fairmont Park'
                  'PA051DE'='(PA051DE) Bn: Philadelphia County'
                  'PA051SP'='(PA051SP) Sp: Philadelphia County' 'PA05200'='(PA05200) Pike'
                  'PA05201'='(PA05201) Matamoras' 'PA05202'='(PA05202) Milford'
                  'PA05203'='(PA05203) Pike Detective Bureau'
                  'PA05204'='(PA05204) Westfall Township' 'PA05205'='(PA05205) Milford Township'
                  'PA05206'='(PA05206) Shohola Township' 'PA052BF'='(PA052BF) Bf: Pike County'
                  'PA052DE'='(PA052DE) Bn: Pike County' 'PA052SP'='(PA052SP) Sp: Pike County'
                  'PA05300'='(PA05300) Potter' 'PA05301'='(PA05301) Coudersport'
                  'PA05302'='(PA05302) Galeton' 'PA05303'='(PA05303) Roulette Township'
                  'PA05304'='(PA05304) Shinglehouse' 'PA053BF'='(PA053BF) Bf: Potter County'
                  'PA053DE'='(PA053DE) Bn: Potter County' 'PA053SP'='(PA053SP) Sp: Potter County'
                  'PA05400'='(PA05400) Schuylkill' 'PA05401'='(PA05401) Cressona'
                  'PA05402'='(PA05402) Frackville' 'PA05403'='(PA05403) Girardville'
                  'PA05404'='(PA05404) Mcadoo' 'PA05405'='(PA05405) Mahanoy City'
                  'PA05406'='(PA05406) Minersville' 'PA05407'='(PA05407) Pottsville'
                  'PA05408'='(PA05408) St. Clair Boro' 'PA05409'='(PA05409) Schuylkill Haven'
                  'PA05410'='(PA05410) Shenandoah' 'PA05411'='(PA05411) Tamaqua'
                  'PA05412'='(PA05412) Ashland' 'PA05413'='(PA05413) Coaldale'
                  'PA05414'='(PA05414) Gilberton' 'PA05415'='(PA05415) Hegins Township'
                  'PA05416'='(PA05416) New Philadelphia' 'PA05417'='(PA05417) Port Carbon'
                  'PA05419'='(PA05419) Gordon' 'PA05421'='(PA05421) Mechanicsville'
                  'PA05422'='(PA05422) Orwigsburg' 'PA05423'='(PA05423) Palo Alto'
                  'PA05424'='(PA05424) Pine Grove' 'PA05426'='(PA05426) Ringtown'
                  'PA05427'='(PA05427) Schuylkill Township' 'PA05428'='(PA05428) Tower City'
                  'PA05429'='(PA05429) Tremont' 'PA05431'='(PA05431) Butler Township'
                  'PA05432'='(PA05432) Cass Township' 'PA05436'='(PA05436) Rush Township'
                  'PA05437'='(PA05437) West Mahanoy Township'
                  'PA05438'='(PA05438) Kline Township' 'PA05439'='(PA05439) Auburn'
                  'PA05440'='(PA05440) Hubley Township' 'PA05441'='(PA05441) Norwegian Township'
                  'PA05448'='(PA05448) New Castle Township'
                  'PA054BF'='(PA054BF) Bf: Schuylkill County'
                  'PA054DE'='(PA054DE) Bn: Schuylkill County'
                  'PA054SP'='(PA054SP) Sp: Schuylkill County' 'PA05500'='(PA05500) Snyder'
                  'PA05501'='(PA05501) Selinsgrove' 'PA05502'='(PA05502) Middleburg'
                  'PA05503'='(PA05503) Shamokin Dam' 'PA055BF'='(PA055BF) Bf: Snyder County'
                  'PA055DE'='(PA055DE) Bn: Snyder County' 'PA055SP'='(PA055SP) Sp: Snyder County'
                  'PA05600'='(PA05600) Somerset' 'PA05601'='(PA05601) Meyersdale'
                  'PA05602'='(PA05602) Somerset' 'PA05603'='(PA05603) Windber' 'PA05604'='(PA05604) Berlin'
                  'PA05605'='(PA05605) Boswell' 'PA05606'='(PA05606) Central City'
                  'PA05607'='(PA05607) Conemaugh Township' 'PA05608'='(PA05608) Confluence'
                  'PA05609'='(PA05609) Hooversville' 'PA05610'='(PA05610) Jenner Township'
                  'PA05612'='(PA05612) Salisbury' 'PA05613'='(PA05613) Paint'
                  'PA05617'='(PA05617) Indian Lake' 'PA05618'='(PA05618) Rockwood'
                  'PA05619'='(PA05619) Seven Springs' 'PA05620'='(PA05620) Paint Township'
                  'PA05621'='(PA05621) Garrett' 'PA05625'='(PA05625) Elk Lick Township'
                  'PA056BF'='(PA056BF) Bf: Somerset County'
                  'PA056DE'='(PA056DE) Bn: Somerset County'
                  'PA056SP'='(PA056SP) Sp: Somerset County' 'PA05700'='(PA05700) Sullivan'
                  'PA05701'='(PA05701) Dushore' 'PA057BF'='(PA057BF) Bf: Sullivan County'
                  'PA057DE'='(PA057DE) Bn: Sullivan County'
                  'PA057SP'='(PA057SP) Sp: Sullivan County' 'PA05800'='(PA05800) Susquehanna'
                  'PA05801'='(PA05801) Susquehanna Depot' 'PA05802'='(PA05802) Forest City'
                  'PA05804'='(PA05804) Montrose' 'PA05806'='(PA05806) Hallstead'
                  'PA05811'='(PA05811) Little Meadows' 'PA05812'='(PA05812) Apolacon Township'
                  'PA05813'='(PA05813) Silver Lake Township'
                  'PA05815'='(PA05815) Hop Bottom Borough'
                  'PA058BF'='(PA058BF) Bf: Susquehanna County'
                  'PA058DE'='(PA058DE) Bn: Susquehanna County'
                  'PA058SP'='(PA058SP) Sp: Susquehanna County' 'PA05900'='(PA05900) Tioga'
                  'PA05901'='(PA05901) Wellsboro' 'PA05902'='(PA05902) Mansfield'
                  'PA05903'='(PA05903) Blossburg' 'PA05904'='(PA05904) Elkland'
                  'PA05907'='(PA05907) Westfield' 'PA05909'='(PA05909) Mansfield University'
                  'PA05919'='(PA05919) Nelson Township' 'PA059BF'='(PA059BF) Bf: Tioga County'
                  'PA059DE'='(PA059DE) Bn: Tioga County' 'PA059SP'='(PA059SP) Sp: Tioga County'
                  'PA06000'='(PA06000) Union' 'PA06001'='(PA06001) Lewisburg'
                  'PA06002'='(PA06002) East Buffalo Township' 'PA06003'='(PA06003) Mifflinburg'
                  'PA06007'='(PA06007) Union Township' 'PA060BF'='(PA060BF) Bf: Union County'
                  'PA060DE'='(PA060DE) Bn: Union County' 'PA060SP'='(PA060SP) Sp: Union County'
                  'PA06100'='(PA06100) Venango' 'PA06101'='(PA06101) Franklin'
                  'PA06102'='(PA06102) Oil City' 'PA06103'='(PA06103) Polk'
                  'PA06105'='(PA06105) Sugarcreek' 'PA06111'='(PA06111) Emlenton Borough'
                  'PA061BF'='(PA061BF) Bf: Venango County'
                  'PA061DE'='(PA061DE) Bn: Venango County'
                  'PA061SP'='(PA061SP) Sp: Venango County' 'PA06200'='(PA06200) Warren'
                  'PA06201'='(PA06201) Warren' 'PA06202'='(PA06202) Conewango Township'
                  'PA06203'='(PA06203) Sheffield Township' 'PA06205'='(PA06205) Tidioute'
                  'PA06206'='(PA06206) Youngsville' 'PA06208'='(PA06208) Mead Township'
                  'PA06209'='(PA06209) Clarendon' 'PA062BF'='(PA062BF) Bf: Warren County'
                  'PA062DE'='(PA062DE) Bn: Warren County' 'PA062SP'='(PA062SP) Sp: Warren County'
                  'PA06300'='(PA06300) Washington' 'PA06301'='(PA06301) Canonsburg'
                  'PA06302'='(PA06302) Charleroi' 'PA06303'='(PA06303) Monongahela'
                  'PA06304'='(PA06304) Peters Township' 'PA06305'='(PA06305) Washington'
                  'PA06306'='(PA06306) Donora' 'PA06307'='(PA06307) California'
                  'PA06308'='(PA06308) New Eagle' 'PA06309'='(PA06309) Mcdonald Borough'
                  'PA06310'='(PA06310) Bentleyville' 'PA06311'='(PA06311) Speers'
                  'PA06313'='(PA06313) Burgettstown' 'PA06314'='(PA06314) Carroll Township'
                  'PA06315'='(PA06315) Cecil Township' 'PA06316'='(PA06316) Centerville'
                  'PA06317'='(PA06317) Chartiers Township' 'PA06318'='(PA06318) Claysville'
                  'PA06319'='(PA06319) Coal Center' 'PA06320'='(PA06320) Cokeburg'
                  'PA06321'='(PA06321) Donegal Township'
                  'PA06322'='(PA06322) East Bethlehem Township'
                  'PA06323'='(PA06323) East Washington'
                  'PA06324'='(PA06324) Fallowfield Township' 'PA06326'='(PA06326) Houston'
                  'PA06327'='(PA06327) Independence Township' 'PA06328'='(PA06328) Long Branch'
                  'PA06329'='(PA06329) North Charleroi'
                  'PA06330'='(PA06330) North Franklin Township' 'PA06331'='(PA06331) Roscoe'
                  'PA06332'='(PA06332) Smith Township'
                  'PA06333'='(PA06333) South Strabane Township' 'PA06334'='(PA06334) Twilight'
                  'PA06335'='(PA06335) Union Township' 'PA06336'='(PA06336) West Brownsville'
                  'PA06337'='(PA06337) Marianna' 'PA06339'='(PA06339) Hanover Township'
                  'PA06341'='(PA06341) North Strabane Township'
                  'PA06344'='(PA06344) California University'
                  'PA06345'='(PA06345) West Alexander' 'PA06346'='(PA06346) Ell-Co Regional'
                  'PA06347'='(PA06347) Robinson Township' 'PA06350'='(PA06350) West Pike Run'
                  'PA06354'='(PA06354) North Bethlehem Township'
                  'PA06356'='(PA06356) Washington County Alt Ed'
                  'PA06357'='(PA06357) Fort Cherry School Distr'
                  'PA063DE'='(PA063DE) Bn: Washington County'
                  'PA063SP'='(PA063SP) Sp: Washington County' 'PA06400'='(PA06400) Wayne'
                  'PA06401'='(PA06401) Honesdale' 'PA06402'='(PA06402) Hawley'
                  'PA06404'='(PA06404) Lehigh Township' 'PA06406'='(PA06406) Dreher Township'
                  'PA064DE'='(PA064DE) Bn: Wayne County' 'PA064SP'='(PA064SP) Sp: Wayne County'
                  'PA06500'='(PA06500) Westmoreland' 'PA06501'='(PA06501) Murrysville'
                  'PA06502'='(PA06502) Greensburg' 'PA06503'='(PA06503) Irwin'
                  'PA06504'='(PA06504) Jeannette' 'PA06505'='(PA06505) Latrobe'
                  'PA06506'='(PA06506) Lower Burrell' 'PA06507'='(PA06507) Monessen'
                  'PA06508'='(PA06508) Mount Pleasant'
                  'PA06509'='(PA06509) North Huntingdon Townshi'
                  'PA06510'='(PA06510) New Kensington' 'PA06511'='(PA06511) Penn Township'
                  'PA06512'='(PA06512) Scottdale' 'PA06513'='(PA06513) Vandergrift'
                  'PA06514'='(PA06514) Arnold' 'PA06515'='(PA06515) Derry'
                  'PA06517'='(PA06517) Ligonier Township'
                  'PA06518'='(PA06518) Loyalhanna Township'
                  'PA06519'='(PA06519) North Belle Vernon' 'PA06520'='(PA06520) Salem Township'
                  'PA06521'='(PA06521) South Greensburg'
                  'PA06522'='(PA06522) South Huntingdon Townshi'
                  'PA06523'='(PA06523) Southwest Greensburg' 'PA06524'='(PA06524) Trafford'
                  'PA06525'='(PA06525) West Newton' 'PA06526'='(PA06526) Youngwood'
                  'PA06527'='(PA06527) Ligonier' 'PA06528'='(PA06528) Allegheny Township'
                  'PA06529'='(PA06529) Avonmore Boro' 'PA06530'='(PA06530) Bolivar'
                  'PA06533'='(PA06533) New Florence' 'PA06535'='(PA06535) Penn'
                  'PA06536'='(PA06536) Seward' 'PA06538'='(PA06538) Delmont'
                  'PA06539'='(PA06539) East Vandergrift' 'PA06540'='(PA06540) Manor'
                  'PA06543'='(PA06543) Hempfield Township'
                  'PA06544'='(PA06544) County Det: Westmoreland'
                  'PA06545'='(PA06545) Rostraver Township'
                  'PA06547'='(PA06547) Seton Hill University'
                  'PA06549'='(PA06549) Washington Township' 'PA06551'='(PA06551) Hyde Park'
                  'PA06552'='(PA06552) Westmoreland County Park'
                  'PA06553'='(PA06553) St. Clair Township'
                  'PA065BF'='(PA065BF) Bf: Westmoreland County'
                  'PA065DE'='(PA065DE) Bn: Westmoreland County'
                  'PA065SP'='(PA065SP) Sp: Westmoreland County' 'PA06600'='(PA06600) Wyoming'
                  'PA06601'='(PA06601) Factoryville' 'PA06603'='(PA06603) Nicholson'
                  'PA06604'='(PA06604) Tunkhannock'
                  'PA06608'='(PA06608) Falls Township (Wyoming)'
                  'PA06612'='(PA06612) Tunkhannock Township'
                  'PA066BF'='(PA066BF) Bf: Wyoming County'
                  'PA066DE'='(PA066DE) Bn: Wyoming County'
                  'PA066SP'='(PA066SP) Sp: Wyoming County' 'PA06700'='(PA06700) York'
                  'PA06701'='(PA06701) Hanover' 'PA06702'='(PA06702) York'
                  'PA06703'='(PA06703) Spring Garden Township'
                  'PA06704'='(PA06704) Springettsbury Township' 'PA06705'='(PA06705) Dallastown'
                  'PA06706'='(PA06706) Fairview Township' 'PA06708'='(PA06708) Red Lion'
                  'PA06709'='(PA06709) West Manchester Township' 'PA06710'='(PA06710) West York'
                  'PA06712'='(PA06712) Conewago Township' 'PA06714'='(PA06714) Dillsburg'
                  'PA06715'='(PA06715) Northern York Regional'
                  'PA06716'='(PA06716) Northeastern Regional'
                  'PA06717'='(PA06717) Franklin Township' 'PA06719'='(PA06719) Hallam'
                  'PA06720'='(PA06720) Hellam Township' 'PA06721'='(PA06721) Jackson Township'
                  'PA06723'='(PA06723) New Freedom' 'PA06725'='(PA06725) Southwestern Regional'
                  'PA06726'='(PA06726) North York Borough'
                  'PA06727'='(PA06727) West Manheim Township' 'PA06728'='(PA06728) Windsor Boro'
                  'PA06729'='(PA06729) Windsor Township' 'PA06730'='(PA06730) Wrightsville'
                  'PA06731'='(PA06731) Yoe Boro' 'PA06732'='(PA06732) York Area Regional'
                  'PA06735'='(PA06735) Glen Rock' 'PA06736'='(PA06736) Mount Wolf'
                  'PA06740'='(PA06740) Paradise Township' 'PA06741'='(PA06741) Penn Township'
                  'PA06743'='(PA06743) Stewartstown'
                  'PA06745'='(PA06745) County Det: York County'
                  'PA06746'='(PA06746) Carroll Township' 'PA06747'='(PA06747) Newberry Township'
                  'PA06748'='(PA06748) Southern Regional York C'
                  'PA06750'='(PA06750) dover Township' 'PA06753'='(PA06753) Jacobus Boro'
                  'PA06758'='(PA06758) Manchester' 'PA06760'='(PA06760) Lower Windsor Township'
                  'PA06761'='(PA06761) Dover Borough' 'PA06762'='(PA06762) Manchester Township'
                  'PA06763'='(PA06763) Felton Boro' 'PA067BF'='(PA067BF) Bf: York County'
                  'PA067DE'='(PA067DE) Bn: York County' 'PA067SP'='(PA067SP) Sp: York County'
                  'PA09BCI'='(PA09BCI) Sp Bci: Bucks County'
                  'PA10BCI'='(PA10BCI) Sp Bci: Butler County'
                  'PA21BCI'='(PA21BCI) Sp Bci: Cumberland Cnty'
                  'PA22BCI'='(PA22BCI) Sp Bci: Dauphin County'
                  'PA23BCI'='(PA23BCI) Sp Bci: Delaware County'
                  'PA26BCI'='(PA26BCI) Sp Bci: Fayette County'
                  'PA30BCI'='(PA30BCI) Sp Bci: Greene County'
                  'PA32BCI'='(PA32BCI) Sp Bci: Indiana County'
                  'PA36BCI'='(PA36BCI) Sp Bci: Lancaster County'
                  'PA37BCI'='(PA37BCI) Sp Bci: Lawrence County'
                  'PA39BCI'='(PA39BCI) Sp Bci: Lehigh County'
                  'PA46BCI'='(PA46BCI) Sp Bci: Montgomery Cnty'
                  'PA49BCI'='(PA49BCI) Sp Bci: Northumberland C'
                  'PA51BCI'='(PA51BCI) sp Bci: Philadlephia Cty'
                  'PA56BCI'='(PA56BCI) Sp Bci: Somerset County'
                  'PA58BCI'='(PA58BCI) Sp Bci: Susquehanna Cnty'
                  'PA63BCI'='(PA63BCI) Sp Bci: Washington Cnty'
                  'PA65BCI'='(PA65BCI) Sp Bci: Westmoreland Cty'
                  'PAPEP00'='(PAPEP00) Philadelphia' 'PAPPD00'='(PAPPD00) Pittsburgh'
                  'PAPSP00'='(PAPSP00) State Police' 'PRPPR00'='(PRPPR00) Puerto Rico'
                  'RI00100'='(RI00100) Bristol' 'RI00101'='(RI00101) Barrington'
                  'RI00102'='(RI00102) Bristol' 'RI00103'='(RI00103) Warren' 'RI00200'='(RI00200) Kent'
                  'RI00201'='(RI00201) Coventry' 'RI00202'='(RI00202) East Greenwich'
                  'RI00203'='(RI00203) Warwick' 'RI00204'='(RI00204) West Warwick'
                  'RI00205'='(RI00205) West Greenwich' 'RI00300'='(RI00300) Newport'
                  'RI00301'='(RI00301) Jamestown' 'RI00302'='(RI00302) Middletown'
                  'RI00303'='(RI00303) Newport' 'RI00304'='(RI00304) Portsmouth'
                  'RI00305'='(RI00305) Tiverton' 'RI00306'='(RI00306) Little Compton'
                  'RI00400'='(RI00400) Providence' 'RI00401'='(RI00401) Central Falls'
                  'RI00402'='(RI00402) Cranston' 'RI00403'='(RI00403) Cumberland'
                  'RI00404'='(RI00404) East Providence' 'RI00405'='(RI00405) Johnston'
                  'RI00406'='(RI00406) Lincoln' 'RI00407'='(RI00407) North Providence'
                  'RI00408'='(RI00408) Pawtucket' 'RI00409'='(RI00409) Providence'
                  'RI00410'='(RI00410) Scituate' 'RI00411'='(RI00411) Smithfield'
                  'RI00412'='(RI00412) Woonsocket' 'RI00413'='(RI00413) Foster'
                  'RI00414'='(RI00414) Glocester' 'RI00415'='(RI00415) North Smithfield'
                  'RI00416'='(RI00416) Burrillville'
                  'RI00417'='(RI00417) Dept Of Environmental M'
                  'RI00418'='(RI00418) division Of Drug Control'
                  'RI00423'='(RI00423) Brown University' 'RI00500'='(RI00500) Washington'
                  'RI00501'='(RI00501) Narragansett' 'RI00502'='(RI00502) North Kingstown'
                  'RI00503'='(RI00503) South Kingstown' 'RI00504'='(RI00504) Westerly'
                  'RI00505'='(RI00505) Richmond' 'RI00506'='(RI00506) Hopkinton'
                  'RI00507'='(RI00507) Charlestown' 'RI00508'='(RI00508) Exeter'
                  'RI00509'='(RI00509) New Shoreham'
                  'RI00510'='(RI00510) University Of Rhode Isla'
                  'RI301SP'='(RI301SP) Sp: Bristol' 'RI302SP'='(RI302SP) Sp: Hope Valley'
                  'RI303SP'='(RI303SP) Sp: Portsmouth' 'RI304SP'='(RI304SP) Sp: Chepachet'
                  'RI305SP'='(RI305SP) Sp: Wickford' 'RI306SP'='(RI306SP) Sp: Lincoln Woods'
                  'RIDI003'='(RIDI003) Narragansett Tribal'
                  'RIRSP00'='(RIRSP00) Ri State Police Hdqrts'
                  'RIRSP02'='(RIRSP02) Sp: Chepachet' 'RIRSP03'='(RIRSP03) Sp: Hope Valley'
                  'RIRSP05'='(RIRSP05) Sp: Lincoln' 'RIRSP06'='(RIRSP06) Sp: Portsmouth'
                  'RIRSP09'='(RIRSP09) Sp: Wickford' 'SC00100'='(SC00100) Abbeville'
                  'SC00101'='(SC00101) Abbeville' 'SC00102'='(SC00102) Calhoun Falls'
                  'SC00103'='(SC00103) Donalds' 'SC00104'='(SC00104) Due West'
                  'SC00126'='(SC00126) Stp: Abbeville County'
                  'SC0019E'='(SC0019E) Erskine College'
                  'SC001AB'='(SC001AB) Sled Vice:Abbeville Cnty'
                  'SC001FC'='(SC001FC) Fc: Abbeville County'
                  'SC001NR'='(SC001NR) Dnr: Abbeville County'
                  'SC001SP'='(SC001SP) Hp: Abbeville County' 'SC00200'='(SC00200) Aiken'
                  'SC00201'='(SC00201) Aiken' 'SC00202'='(SC00202) Graniteville'
                  'SC00203'='(SC00203) North Augusta' 'SC00204'='(SC00204) Burnettown'
                  'SC00205'='(SC00205) Jackson' 'SC00206'='(SC00206) New Ellenton'
                  'SC00207'='(SC00207) Salley' 'SC00208'='(SC00208) Wagener'
                  'SC00209'='(SC00209) Warrenville'
                  'SC00210'='(SC00210) Us Doe, Savannah River P'
                  'SC00211'='(SC00211) aiken Technical College' 'SC00214'='(SC00214) Perry'
                  'SC00215'='(SC00215) Univ Of Sc: Aiken' 'SC00226'='(SC00226) Stp: Aiken County'
                  'SC002AB'='(SC002AB) Sled Vice: Aiken County'
                  'SC002FC'='(SC002FC) Fc: Aiken County' 'SC002NR'='(SC002NR) Dnr: Aiken County'
                  'SC002SP'='(SC002SP) Hp: Aiken County' 'SC00300'='(SC00300) Allendale'
                  'SC00301'='(SC00301) Allendale' 'SC00302'='(SC00302) Fairfax'
                  'SC00326'='(SC00326) Stp: Allendale County'
                  'SC003AB'='(SC003AB) Sled Vice:Allendale Cnty'
                  'SC003FC'='(SC003FC) Fc: Allendale County'
                  'SC003NR'='(SC003NR) Dnr: Allendale County'
                  'SC003SP'='(SC003SP) Hp: Allendale County' 'SC00400'='(SC00400) Anderson'
                  'SC00401'='(SC00401) Anderson' 'SC00402'='(SC00402) Belton'
                  'SC00403'='(SC00403) Honea Path' 'SC00404'='(SC00404) Pendleton'
                  'SC00405'='(SC00405) Williamston' 'SC00406'='(SC00406) Iva' 'SC00407'='(SC00407) Pelzer'
                  'SC00408'='(SC00408) Piedmont' 'SC00409'='(SC00409) Starr'
                  'SC00410'='(SC00410) West Pelzer' 'SC00426'='(SC00426) Stp: Anderson County'
                  'SC004AB'='(SC004AB) Sled Vice: Anderson Cnty'
                  'SC004FC'='(SC004FC) Fc: Anderson County'
                  'SC004NR'='(SC004NR) Dnr: Anderson County'
                  'SC004SP'='(SC004SP) Hp: Anderson County' 'SC00500'='(SC00500) Bamberg'
                  'SC00501'='(SC00501) Bamberg' 'SC00502'='(SC00502) Denmark'
                  'SC00503'='(SC00503) Ehrhardt' 'SC00504'='(SC00504) Olar'
                  'SC00505'='(SC00505) Denmark Technical Coll'
                  'SC00526'='(SC00526) Stp: Bamberg County'
                  'SC005AB'='(SC005AB) Sled Vice: Bamberg Cnty'
                  'SC005FC'='(SC005FC) Fc: Bamberg County'
                  'SC005NR'='(SC005NR) Dnr: Bamberg County'
                  'SC005SP'='(SC005SP) Hp: Bamberg County' 'SC00600'='(SC00600) Barnwell'
                  'SC00601'='(SC00601) Barnwell' 'SC00602'='(SC00602) Williston'
                  'SC00603'='(SC00603) Blackville' 'SC00626'='(SC00626) Stp: Barnwell County'
                  'SC006AB'='(SC006AB) Sled Vice: Barnwell Cnty'
                  'SC006FC'='(SC006FC) Fc: Barnwell County'
                  'SC006NR'='(SC006NR) Dnr: Barnwell County'
                  'SC006SP'='(SC006SP) Hp: Barnwell County' 'SC00700'='(SC00700) Beaufort'
                  'SC00701'='(SC00701) Beaufort' 'SC00702'='(SC00702) Bluffton'
                  'SC00703'='(SC00703) Port Royal' 'SC00704'='(SC00704) Yemassee'
                  'SC00726'='(SC00726) Stp: Beaufort County'
                  'SC007AB'='(SC007AB) Sled Vice: Beaufort Cnty'
                  'SC007FC'='(SC007FC) Fc: Beaufort County'
                  'SC007NR'='(SC007NR) Dnr: Beaufort County'
                  'SC007SP'='(SC007SP) Hp: Beaufort County' 'SC00800'='(SC00800) Berkeley'
                  'SC00801'='(SC00801) Moncks Corner' 'SC00802'='(SC00802) Bonneau'
                  'SC00803'='(SC00803) Goose Creek' 'SC00804'='(SC00804) Jamestown'
                  'SC00805'='(SC00805) St. Stephen' 'SC00806'='(SC00806) Hanahan'
                  'SC00807'='(SC00807) Berkeley Co Sch Dist Psd'
                  'SC00826'='(SC00826) Stp: Berkeley County'
                  'SC008AB'='(SC008AB) Sled Vice: Berkeley Cnty'
                  'SC008FC'='(SC008FC) Fc: Berkeley County'
                  'SC008NR'='(SC008NR) Dnr: Berkeley County'
                  'SC008SP'='(SC008SP) Hp: Berkeley County' 'SC00900'='(SC00900) Calhoun'
                  'SC00901'='(SC00901) Cameron' 'SC00902'='(SC00902) St. Matthews'
                  'SC00926'='(SC00926) Stp: Calhoun County'
                  'SC009AB'='(SC009AB) Sled Vice: Calhoun Cnty'
                  'SC009FC'='(SC009FC) Fc: Calhoun County'
                  'SC009NR'='(SC009NR) Dnr: Calhoun County'
                  'SC009SP'='(SC009SP) Hp: Calhoun County' 'SC01000'='(SC01000) Charleston'
                  'SC01001'='(SC01001) Charleston' 'SC01002'='(SC01002) Charleston Police Depart'
                  'SC01003'='(SC01003) Mount Pleasant' 'SC01004'='(SC01004) Folly Beach'
                  'SC01005'='(SC01005) Isle Of Palms' 'SC01006'='(SC01006) Lincolnville'
                  'SC01007'='(SC01007) Sullivans Island' 'SC01008'='(SC01008) North Charleston'
                  'SC01009'='(SC01009) Medical U of S carolina' 'SC01010'='(SC01010) Ravenel'
                  'SC01011'='(SC01011) The Citadel'
                  'SC01012'='(SC01012) Trident Technical Colleg'
                  'SC01013'='(SC01013) State Ports Authority'
                  'SC01015'='(SC01015) Charleston Cnty Avia Aut'
                  'SC01017'='(SC01017) College Of Charleston'
                  'SC01026'='(SC01026) Stp: Charleston County'
                  'SC010AB'='(SC010AB) Sled Vice: Charleston Co'
                  'SC010FC'='(SC010FC) Fc: Charleston County'
                  'SC010NR'='(SC010NR) Dnr: Charleston County'
                  'SC010SP'='(SC010SP) Hp: Charleston County' 'SC01100'='(SC01100) Cherokee'
                  'SC01101'='(SC01101) Blacksburg' 'SC01102'='(SC01102) Gaffney'
                  'SC01126'='(SC01126) Stp: Cherokee County'
                  'SC011AB'='(SC011AB) Sled Vice: Cherokee Cnty'
                  'SC011FC'='(SC011FC) Fc: Cherokee County'
                  'SC011NR'='(SC011NR) Dnr: Cherokee County'
                  'SC011SP'='(SC011SP) Hp: Cherokee County' 'SC01200'='(SC01200) Chester'
                  'SC01201'='(SC01201) Chester' 'SC01202'='(SC01202) Great Falls'
                  'SC01203'='(SC01203) Fort Lawn' 'SC01226'='(SC01226) Stp: Chester County'
                  'SC012AB'='(SC012AB) Sled Vice: Chester Cnty'
                  'SC012FC'='(SC012FC) Fc: Chester County'
                  'SC012NR'='(SC012NR) Dnr: Chester County'
                  'SC012SP'='(SC012SP) Hp: Chester County' 'SC01300'='(SC01300) Chesterfield'
                  'SC01301'='(SC01301) Cheraw' 'SC01302'='(SC01302) Chesterfield'
                  'SC01303'='(SC01303) Jefferson' 'SC01304'='(SC01304) Mcbee'
                  'SC01305'='(SC01305) Pageland' 'SC01306'='(SC01306) Patrick'
                  'SC01326'='(SC01326) Stp: Chesterfield County'
                  'SC013AB'='(SC013AB) Sled Vice:Chesterfield C'
                  'SC013FC'='(SC013FC) fc: Chesterfield County'
                  'SC013NR'='(SC013NR) Dnr: Chesterfield County'
                  'SC013SP'='(SC013SP) Hp: Chesterfield County' 'SC01400'='(SC01400) Clarendon'
                  'SC01401'='(SC01401) Manning' 'SC01402'='(SC01402) Summerton'
                  'SC01403'='(SC01403) Turbeville' 'SC01426'='(SC01426) Stp: Clarendon County'
                  'SC014AB'='(SC014AB) Sled Vice: Clarendon Cty'
                  'SC014FC'='(SC014FC) Fc: Clarendon County'
                  'SC014NR'='(SC014NR) Dnr: Clarendon County'
                  'SC014SP'='(SC014SP) Hp: Clarendon County' 'SC01500'='(SC01500) Colleton'
                  'SC01501'='(SC01501) Walterboro' 'SC01502'='(SC01502) Edisto Beach'
                  'SC01503'='(SC01503) Cottageville' 'SC01526'='(SC01526) Stp: Colleton County'
                  'SC015AB'='(SC015AB) Sled Vice: Colleton Cnty'
                  'SC015FC'='(SC015FC) Fc: Colleton County'
                  'SC015NR'='(SC015NR) Dnr: Colleton County'
                  'SC015SP'='(SC015SP) Hp: Colleton County' 'SC01600'='(SC01600) Darlington'
                  'SC01601'='(SC01601) Darlington' 'SC01602'='(SC01602) Hartsville'
                  'SC01603'='(SC01603) Lamar' 'SC01604'='(SC01604) Society Hill'
                  'SC01626'='(SC01626) Stp: Darlington County'
                  'SC016AB'='(SC016AB) Sled Vice:Darlington Cty'
                  'SC016FC'='(SC016FC) Fc: Darlington County'
                  'SC016NR'='(SC016NR) Dnr: Darlington County'
                  'SC016SP'='(SC016SP) Hp: Darlington County' 'SC01700'='(SC01700) Dillon'
                  'SC01701'='(SC01701) Dillon' 'SC01702'='(SC01702) Lake View' 'SC01703'='(SC01703) Latta'
                  'SC01704'='(SC01704) Sellers' 'SC01726'='(SC01726) Stp: Dillon County'
                  'SC017AB'='(SC017AB) Sled Vice: Dillon County'
                  'SC017FC'='(SC017FC) Fc: Dillon County'
                  'SC017NR'='(SC017NR) Dnr: Dillon County'
                  'SC017SP'='(SC017SP) Hp: Dillon County' 'SC01800'='(SC01800) Dorchester'
                  'SC01801'='(SC01801) St. George' 'SC01802'='(SC01802) Summerville'
                  'SC01803'='(SC01803) Harleyville' 'SC01804'='(SC01804) Ridgeville'
                  'SC01826'='(SC01826) Stp: Dorchester County'
                  'SC018AB'='(SC018AB) Sled Vice:Dorchester Cty'
                  'SC018FC'='(SC018FC) Fc: Dorchester County'
                  'SC018NR'='(SC018NR) Dnr: Dorchester County'
                  'SC018SP'='(SC018SP) Hp: Dorchester County' 'SC01900'='(SC01900) Edgefield'
                  'SC01901'='(SC01901) Edgefield' 'SC01902'='(SC01902) Johnston'
                  'SC01903'='(SC01903) Trenton' 'SC01926'='(SC01926) Stp: Edgefield County'
                  'SC019AB'='(SC019AB) Sled Vice:Edgefield Cnty'
                  'SC019FC'='(SC019FC) Fc: Edgefield County'
                  'SC019NR'='(SC019NR) Dnr: Edgefield County'
                  'SC019SP'='(SC019SP) Hp: Edgefield County' 'SC02000'='(SC02000) Fairfield'
                  'SC02001'='(SC02001) Winnsboro' 'SC02002'='(SC02002) Ridgeway'
                  'SC02026'='(SC02026) Stp: Fairfield County'
                  'SC020AB'='(SC020AB) Sled Vice:Fairfield Cnty'
                  'SC020FC'='(SC020FC) Fc: Fairfield County'
                  'SC020NR'='(SC020NR) Dnr: Fairfield County'
                  'SC020SP'='(SC020SP) Hp: Fairfield County' 'SC02100'='(SC02100) Florence'
                  'SC02101'='(SC02101) Florence' 'SC02102'='(SC02102) Lake City'
                  'SC02103'='(SC02103) Coward' 'SC02104'='(SC02104) Johnsonville'
                  'SC02105'='(SC02105) Olanta' 'SC02106'='(SC02106) Pamplico' 'SC02107'='(SC02107) Quinby'
                  'SC02108'='(SC02108) Scranton' 'SC02109'='(SC02109) Timmonsville'
                  'SC02110'='(SC02110) Francis Marion Universit'
                  'SC02126'='(SC02126) Stp: Florence County'
                  'SC021AB'='(SC021AB) Sled Vice: Florence Cnty'
                  'SC021FC'='(SC021FC) Fc: Florence County'
                  'SC021NR'='(SC021NR) Dnr: Florence County'
                  'SC021SP'='(SC021SP) Hp: Florence County' 'SC02200'='(SC02200) Georgetown'
                  'SC02201'='(SC02201) Andrews' 'SC02202'='(SC02202) Georgetown'
                  'SC02203'='(SC02203) Pawleys Island'
                  'SC02226'='(SC02226) Stp: Georgetown County'
                  'SC022AB'='(SC022AB) Sled Vice:Georgetown Cty'
                  'SC022FC'='(SC022FC) Fc: Georgetown County'
                  'SC022NR'='(SC022NR) Dnr: Georgetown County'
                  'SC022SP'='(SC022SP) Hp: Georgetown County' 'SC02300'='(SC02300) Greenville'
                  'SC02301'='(SC02301) Fountain Inn' 'SC02302'='(SC02302) Greenville'
                  'SC02303'='(SC02303) Greer' 'SC02304'='(SC02304) Mauldin'
                  'SC02305'='(SC02305) Simpsonville' 'SC02306'='(SC02306) Travelers Rest'
                  'SC02307'='(SC02307) Greenville Tech College' 'SC02308'='(SC02308) City View'
                  'SC02309'='(SC02309) Grnville-Sprtnbrg Intl A'
                  'SC02319'='(SC02319) bob Jones University'
                  'SC02326'='(SC02326) Stp: Greenville County'
                  'SC023AB'='(SC023AB) Sled Vice:Greenville Cty'
                  'SC023FC'='(SC023FC) Fc: Greenville County'
                  'SC023NR'='(SC023NR) Dnr: Greenville County'
                  'SC023SP'='(SC023SP) Hp: Greenville County' 'SC02400'='(SC02400) Greenwood'
                  'SC02401'='(SC02401) Greenwood' 'SC02402'='(SC02402) Ware Shoals'
                  'SC02403'='(SC02403) Hodges' 'SC02404'='(SC02404) Ninety Six'
                  'SC02405'='(SC02405) Lander University'
                  'SC02426'='(SC02426) Stp: Greenwood County'
                  'SC024AB'='(SC024AB) Sled Vice:Greenwood Cnty'
                  'SC024FC'='(SC024FC) Fc: Greenwood County'
                  'SC024NR'='(SC024NR) Dnr: Greenwood County'
                  'SC024SP'='(SC024SP) Hp: Greenwood County' 'SC02500'='(SC02500) Hampton'
                  'SC02501'='(SC02501) Brunson' 'SC02502'='(SC02502) Estill' 'SC02503'='(SC02503) Hampton'
                  'SC02504'='(SC02504) Varnville' 'SC02505'='(SC02505) Gifford'
                  'SC02506'='(SC02506) Yemassee' 'SC02526'='(SC02526) Stp: Hampton County'
                  'SC025AB'='(SC025AB) Sled Vice: Hampton Cnty'
                  'SC025FC'='(SC025FC) Fc: Hampton County'
                  'SC025NR'='(SC025NR) Dnr: Hampton County'
                  'SC025SP'='(SC025SP) Hp: Hampton County' 'SC02600'='(SC02600) Horry'
                  'SC02601'='(SC02601) Atlantic Beach' 'SC02602'='(SC02602) Conway'
                  'SC02603'='(SC02603) Aynor' 'SC02604'='(SC02604) Horry County Police Dept'
                  'SC02605'='(SC02605) Loris' 'SC02606'='(SC02606) Myrtle Beach'
                  'SC02607'='(SC02607) North Myrtle Beach' 'SC02608'='(SC02608) Surfside Beach'
                  'SC02610'='(SC02610) Coastal Carolina Univers'
                  'SC02611'='(SC02611) Briarcliffe Acres' 'SC02626'='(SC02626) Stp: Horry County'
                  'SC026AB'='(SC026AB) Sled Vice: Horry County'
                  'SC026FC'='(SC026FC) Fc: Horry County' 'SC026NR'='(SC026NR) Dnr: Horry County'
                  'SC026SP'='(SC026SP) Hp: Horry County' 'SC02700'='(SC02700) Jasper'
                  'SC02701'='(SC02701) Hardeeville' 'SC02702'='(SC02702) Ridgeland'
                  'SC02726'='(SC02726) Stp: Jasper County'
                  'SC027AB'='(SC027AB) Sled Vice: Jasper County'
                  'SC027FC'='(SC027FC) Fc: Jasper County'
                  'SC027NR'='(SC027NR) Dnr: Jasper County'
                  'SC027SP'='(SC027SP) Hp: Jasper County' 'SC02800'='(SC02800) Kershaw'
                  'SC02801'='(SC02801) Camden' 'SC02802'='(SC02802) Bethune' 'SC02804'='(SC02804) Elgin'
                  'SC02826'='(SC02826) Stp: Kershaw County'
                  'SC028AB'='(SC028AB) Sled Vice: Kershaw Cnty'
                  'SC028FC'='(SC028FC) Fc: Kershaw County'
                  'SC028NR'='(SC028NR) Dnr: Kershaw County'
                  'SC028SP'='(SC028SP) Hp: Kershaw County' 'SC02900'='(SC02900) Lancaster'
                  'SC02901'='(SC02901) Lancaster' 'SC02902'='(SC02902) Heath Springs'
                  'SC02903'='(SC02903) Kershaw' 'SC02926'='(SC02926) Stp: Lancaster County'
                  'SC029AB'='(SC029AB) Sled Vice: Lancaster Cty'
                  'SC029FC'='(SC029FC) Fc: Lancaster County'
                  'SC029NR'='(SC029NR) Dnr: Lancaster County'
                  'SC029SP'='(SC029SP) Hp: Lancaster County' 'SC03000'='(SC03000) Laurens'
                  'SC03001'='(SC03001) Laurens' 'SC03002'='(SC03002) Clinton'
                  'SC03003'='(SC03003) Cross Hill' 'SC03004'='(SC03004) Gray Court'
                  'SC03005'='(SC03005) Whitten Center' 'SC03026'='(SC03026) Stp: Laurens County'
                  'SC0309E'='(SC0309E) Presbyterian College'
                  'SC030AB'='(SC030AB) Sled Vice: Laurens Cnty'
                  'SC030FC'='(SC030FC) Fc: Laurens County'
                  'SC030NR'='(SC030NR) Dnr: Laurens County'
                  'SC030SP'='(SC030SP) Hp: Laurens County' 'SC03100'='(SC03100) Lee'
                  'SC03101'='(SC03101) Bishopville' 'SC03102'='(SC03102) Lynchburg'
                  'SC03126'='(SC03126) Stp: Lee County'
                  'SC031AB'='(SC031AB) Sled Vice: Lee County'
                  'SC031FC'='(SC031FC) Fc: Lee County' 'SC031NR'='(SC031NR) Dnr: Lee County'
                  'SC031SP'='(SC031SP) Hp: Lee County' 'SC03200'='(SC03200) Lexington'
                  'SC03201'='(SC03201) Batesburg-Leesville' 'SC03202'='(SC03202) Cayce'
                  'SC03203'='(SC03203) Leesville' 'SC03204'='(SC03204) Lexington'
                  'SC03205'='(SC03205) West Columbia' 'SC03206'='(SC03206) Chapin'
                  'SC03207'='(SC03207) Irmo' 'SC03208'='(SC03208) Pelion' 'SC03209'='(SC03209) Pine Ridge'
                  'SC03210'='(SC03210) South Congaree' 'SC03211'='(SC03211) Springdale'
                  'SC03212'='(SC03212) Swansea' 'SC03213'='(SC03213) Columbia Metro Airport'
                  'SC03214'='(SC03214) Gaston' 'SC03215'='(SC03215) Wil Lou Gray Opportu Sch'
                  'SC03216'='(SC03216) Midlands Technical Colle'
                  'SC03226'='(SC03226) Stp: Lexington County'
                  'SC032AB'='(SC032AB) Sled Vice: Lexington Cty'
                  'SC032FC'='(SC032FC) Fc: Lexington County'
                  'SC032NR'='(SC032NR) Dnr: Lexington County'
                  'SC032SP'='(SC032SP) Hp: Lexington County' 'SC03300'='(SC03300) Mccormick'
                  'SC03301'='(SC03301) Mccormick' 'SC03326'='(SC03326) Stp: Mccormick County'
                  'SC033AB'='(SC033AB) Sled Vice: Mccormick Cty'
                  'SC033FC'='(SC033FC) Fc: Mccormick County'
                  'SC033NR'='(SC033NR) Dnr: Mccormick County'
                  'SC033SP'='(SC033SP) Hp: Mccormick County' 'SC03400'='(SC03400) Marion'
                  'SC03401'='(SC03401) Marion' 'SC03402'='(SC03402) Mullins' 'SC03403'='(SC03403) Nichols'
                  'SC03426'='(SC03426) Stp: Marion County'
                  'SC034AB'='(SC034AB) Sled Vice: Marion County'
                  'SC034FC'='(SC034FC) Fc: Marion County'
                  'SC034NR'='(SC034NR) Dnr: Marion County'
                  'SC034SP'='(SC034SP) Hp: Marion County' 'SC03500'='(SC03500) Marlboro'
                  'SC03501'='(SC03501) Bennettsville' 'SC03502'='(SC03502) Mccoll'
                  'SC03503'='(SC03503) Clio' 'SC03526'='(SC03526) Stp: Marlboro County'
                  'SC035AB'='(SC035AB) Sled Vice: Marlboro Cnty'
                  'SC035FC'='(SC035FC) Fc: Marlboro County'
                  'SC035NR'='(SC035NR) Dnr: Marlboro County'
                  'SC035SP'='(SC035SP) Hp: Marlboro County' 'SC03600'='(SC03600) Newberry'
                  'SC03601'='(SC03601) Newberry' 'SC03602'='(SC03602) Whitmire'
                  'SC03603'='(SC03603) Chappells' 'SC03604'='(SC03604) Little Mountain'
                  'SC03605'='(SC03605) Prosperity' 'SC03606'='(SC03606) Silverstreet'
                  'SC03626'='(SC03626) Stp: Newberry County'
                  'SC036AB'='(SC036AB) Sled Vice: Newberry Cnty'
                  'SC036FC'='(SC036FC) Fc: Newberry County'
                  'SC036NR'='(SC036NR) Dnr: Newberry County'
                  'SC036SP'='(SC036SP) Hp: Newberry County' 'SC03700'='(SC03700) Oconee'
                  'SC03701'='(SC03701) Seneca' 'SC03702'='(SC03702) Walhalla'
                  'SC03703'='(SC03703) Westminster' 'SC03704'='(SC03704) West Union'
                  'SC03705'='(SC03705) Salem' 'SC03726'='(SC03726) Stp: Oconee County'
                  'SC037AB'='(SC037AB) Sled Vice: Oconee County'
                  'SC037FC'='(SC037FC) Fc: Oconee County'
                  'SC037NR'='(SC037NR) Dnr: Oconee County'
                  'SC037SP'='(SC037SP) Hp: Oconee County' 'SC03800'='(SC03800) Orangeburg'
                  'SC03801'='(SC03801) Orangeburg' 'SC03802'='(SC03802) Branchville'
                  'SC03803'='(SC03803) Bowman' 'SC03804'='(SC03804) Cordova' 'SC03805'='(SC03805) Elloree'
                  'SC03806'='(SC03806) Eutawville' 'SC03807'='(SC03807) Holly Hill'
                  'SC03808'='(SC03808) North' 'SC03809'='(SC03809) Norway'
                  'SC03810'='(SC03810) Springfield' 'SC03811'='(SC03811) Santee'
                  'SC03812'='(SC03812) South Carolina St Univ' 'SC03813'='(SC03813) Vance'
                  'SC03826'='(SC03826) Stp: Orangeburg County'
                  'SC038AB'='(SC038AB) Sled Vice:Orangeburg Cty'
                  'SC038FC'='(SC038FC) Fc: Orangeburg County'
                  'SC038NR'='(SC038NR) Dnr: Orangeburg County'
                  'SC038SP'='(SC038SP) Hp: Orangeburg County' 'SC03900'='(SC03900) Pickens'
                  'SC03901'='(SC03901) Central' 'SC03902'='(SC03902) Clemson' 'SC03903'='(SC03903) Easley'
                  'SC03904'='(SC03904) Liberty' 'SC03905'='(SC03905) Pickens'
                  'SC03906'='(SC03906) Clemson University' 'SC03907'='(SC03907) Norris'
                  'SC03926'='(SC03926) Stp: Pickens County'
                  'SC039AB'='(SC039AB) Sled Vice: Pickens Cnty'
                  'SC039FC'='(SC039FC) Fc: Pickens County'
                  'SC039NR'='(SC039NR) Dnr: Pickens County'
                  'SC039SP'='(SC039SP) Hp: Pickens County' 'SC04000'='(SC04000) Richland'
                  'SC04001'='(SC04001) Columbia' 'SC04003'='(SC04003) Eastover'
                  'SC04004'='(SC04004) Forest Acres' 'SC04006'='(SC04006) Univ Of Sc: Columbia'
                  'SC04007'='(SC04007) S carolina Alc Bev Ctrl'
                  'SC04012'='(SC04012) dept Of Mental Health' 'SC04014'='(SC04014) State Museum'
                  'SC04015'='(SC04015) Employment Security Com'
                  'SC0401C'='(SC0401C) Richland Co. Detention C'
                  'SC04021'='(SC04021) Dpt Of Dis & Special Nds'
                  'SC04025'='(SC04025) Sc Law Enf Div Vhcl Crms'
                  'SC04026'='(SC04026) Stp: Richland County'
                  'SC0408E'='(SC0408E) Benedict College' 'SC0409E'='(SC0409E) Columbia College'
                  'SC040AB'='(SC040AB) Sled Vice: Richland Cnty'
                  'SC040BP'='(SC040BP) Bureau Of Prot Services'
                  'SC040FC'='(SC040FC) Fc: Richland County'
                  'SC040NR'='(SC040NR) Dnr: Richland County'
                  'SC040SP'='(SC040SP) Hp: Richland County' 'SC04100'='(SC04100) Saluda'
                  'SC04101'='(SC04101) Saluda' 'SC04102'='(SC04102) Ridge Spring'
                  'SC04126'='(SC04126) Stp: Saluda County'
                  'SC041AB'='(SC041AB) Sled Vice: Saluda County'
                  'SC041FC'='(SC041FC) Fc: Saluda County'
                  'SC041NR'='(SC041NR) Dnr: Saluda County'
                  'SC041SP'='(SC041SP) Hp: Saluda County' 'SC04200'='(SC04200) Spartanburg'
                  'SC04201'='(SC04201) Spartanburg' 'SC04202'='(SC04202) Woodruff'
                  'SC04203'='(SC04203) Duncan' 'SC04204'='(SC04204) Arcadia'
                  'SC04205'='(SC04205) Campobello' 'SC04206'='(SC04206) Chesnee'
                  'SC04207'='(SC04207) Cowpens' 'SC04208'='(SC04208) Enoree' 'SC04209'='(SC04209) Inman'
                  'SC04210'='(SC04210) Landrum' 'SC04211'='(SC04211) Lyman' 'SC04212'='(SC04212) Pacolet'
                  'SC04213'='(SC04213) Wellford' 'SC04214'='(SC04214) Univ Of Sc: Upstate'
                  'SC04215'='(SC04215) Pacolet Mills'
                  'SC04216'='(SC04216) Spartanburg Methodist Co'
                  'SC04226'='(SC04226) Stp: Spartanburg County'
                  'SC04228'='(SC04228) Greenville-Sprtnbrg I ap'
                  'SC04230'='(SC04230) Sc School Deaf & Blind'
                  'SC042AB'='(SC042AB) Sled Vice:Spartanburg Co'
                  'SC042FC'='(SC042FC) Fc: Spartanburg County'
                  'SC042NR'='(SC042NR) Dnr: Spartanburg County'
                  'SC042SP'='(SC042SP) Hp: Spartanburg County' 'SC04300'='(SC04300) Sumter'
                  'SC04301'='(SC04301) Sumter' 'SC04302'='(SC04302) Mayesville'
                  'SC04303'='(SC04303) Pinewood' 'SC04326'='(SC04326) Stp: Sumter County'
                  'SC043AB'='(SC043AB) Sled Vice: Sumter County'
                  'SC043FC'='(SC043FC) Fc: Sumter County'
                  'SC043NR'='(SC043NR) Dnr: Sumter County'
                  'SC043SP'='(SC043SP) Hp: Sumter County' 'SC04400'='(SC04400) Union'
                  'SC04401'='(SC04401) Union' 'SC04402'='(SC04402) Carlisle'
                  'SC04403'='(SC04403) Jonesville' 'SC04426'='(SC04426) Stp: Union County'
                  'SC044AB'='(SC044AB) Sled Vice: Union County'
                  'SC044FC'='(SC044FC) Fc: Union County' 'SC044NR'='(SC044NR) Dnr: Union County'
                  'SC044SP'='(SC044SP) Hp: Union County' 'SC04500'='(SC04500) Williamsburg'
                  'SC04501'='(SC04501) Hemingway' 'SC04502'='(SC04502) Kingstree'
                  'SC04503'='(SC04503) Stuckey' 'SC04504'='(SC04504) Greeleyville'
                  'SC04505'='(SC04505) Lane' 'SC04526'='(SC04526) Stp: Williamsburg County'
                  'SC045AB'='(SC045AB) Sled Vice:Williamsburg C'
                  'SC045FC'='(SC045FC) fc: Williamsburg County'
                  'SC045NR'='(SC045NR) Dnr: Williamsburg County'
                  'SC045SP'='(SC045SP) Hp: Williamsburg County' 'SC04600'='(SC04600) York'
                  'SC04601'='(SC04601) Clover' 'SC04602'='(SC04602) Fort Mill'
                  'SC04603'='(SC04603) Rock Hill' 'SC04604'='(SC04604) York' 'SC04605'='(SC04605) Tega Cay'
                  'SC04606'='(SC04606) Winthrop University'
                  'SC04626'='(SC04626) Stp: York County'
                  'SC046AB'='(SC046AB) Sled Vice: York County'
                  'SC046FC'='(SC046FC) Fc: York County' 'SC046NR'='(SC046NR) Dnr: York County'
                  'SC046SP'='(SC046SP) Hp: York County'
                  'SC04726'='(SC04726) State Tran Pol Main Head'
                  'SCSHP00'='(SCSHP00) Sc Highway Patrol' 'SD00100'='(SD00100) Aurora'
                  'SD00200'='(SD00200) Beadle' 'SD00201'='(SD00201) Huron' 'SD00300'='(SD00300) Bennett'
                  'SD00301'='(SD00301) Martin' 'SD00400'='(SD00400) Bon Homme'
                  'SD00401'='(SD00401) Scotland' 'SD00402'='(SD00402) Springfield'
                  'SD00403'='(SD00403) Tyndall' 'SD00404'='(SD00404) Avon' 'SD00500'='(SD00500) Brookings'
                  'SD00501'='(SD00501) Brookings' 'SD00503'='(SD00503) Elkton'
                  'SD005UN'='(SD005UN) South Dakota State Univ' 'SD00600'='(SD00600) Brown'
                  'SD00601'='(SD00601) Aberdeen' 'SD00602'='(SD00602) Groton' 'SD00700'='(SD00700) Brule'
                  'SD00701'='(SD00701) Chamberlain' 'SD00702'='(SD00702) Kimball'
                  'SD00800'='(SD00800) Buffalo' 'SD00900'='(SD00900) Butte'
                  'SD00901'='(SD00901) Belle Fourche' 'SD00902'='(SD00902) Newell'
                  'SD01000'='(SD01000) Campbell' 'SD01100'='(SD01100) Charles Mix'
                  'SD01101'='(SD01101) Lake Andes' 'SD01102'='(SD01102) Platte'
                  'SD01103'='(SD01103) Wagner' 'SD01200'='(SD01200) Clark' 'SD01201'='(SD01201) Clark'
                  'SD01300'='(SD01300) Clay' 'SD01301'='(SD01301) Vermillion' 'SD01302'='(SD01302) Irene'
                  'SD01400'='(SD01400) Codington' 'SD01401'='(SD01401) Watertown'
                  'SD01500'='(SD01500) Corson' 'SD01501'='(SD01501) Mcintosh'
                  'SD01502'='(SD01502) Mclaughlin' 'SD01600'='(SD01600) Custer'
                  'SD01602'='(SD01602) Hermosa' 'SD01700'='(SD01700) Davison'
                  'SD01701'='(SD01701) Mitchell' 'SD01800'='(SD01800) Day' 'SD01801'='(SD01801) Webster'
                  'SD01804'='(SD01804) Waubay' 'SD01900'='(SD01900) Deuel' 'SD02000'='(SD02000) Dewey'
                  'SD02004'='(SD02004) Eagle Butte' 'SD02100'='(SD02100) Douglas'
                  'SD02101'='(SD02101) Armour' 'SD02102'='(SD02102) Corsica' 'SD02103'='(SD02103) Delmont'
                  'SD02200'='(SD02200) Edmunds' 'SD02300'='(SD02300) Fall River'
                  'SD02302'='(SD02302) Hot Springs' 'SD02400'='(SD02400) Faulk' 'SD02500'='(SD02500) Grant'
                  'SD02501'='(SD02501) Milbank' 'SD02600'='(SD02600) Gregory' 'SD02601'='(SD02601) Gregory'
                  'SD02602'='(SD02602) Bonesteel' 'SD02603'='(SD02603) Burke' 'SD02700'='(SD02700) Haakon'
                  'SD02701'='(SD02701) Philip' 'SD02800'='(SD02800) Hamlin' 'SD02801'='(SD02801) Bryant'
                  'SD02802'='(SD02802) Castlewood' 'SD02803'='(SD02803) Estelline'
                  'SD02900'='(SD02900) Hand' 'SD02901'='(SD02901) Miller' 'SD03000'='(SD03000) Hanson'
                  'SD03100'='(SD03100) Harding' 'SD03101'='(SD03101) Buffalo' 'SD03200'='(SD03200) Hughes'
                  'SD03201'='(SD03201) Pierre' 'SD03300'='(SD03300) Hutchinson'
                  'SD03301'='(SD03301) Freeman' 'SD03302'='(SD03302) Parkston' 'SD03303'='(SD03303) Menno'
                  'SD03304'='(SD03304) Tripp' 'SD03400'='(SD03400) Hyde' 'SD03401'='(SD03401) Highmore'
                  'SD03500'='(SD03500) Jackson' 'SD03501'='(SD03501) Kadoka' 'SD03600'='(SD03600) Jerauld'
                  'SD03700'='(SD03700) Jones' 'SD03701'='(SD03701) Murdo' 'SD03800'='(SD03800) Kingsbury'
                  'SD03802'='(SD03802) Arlington' 'SD03900'='(SD03900) Lake' 'SD03901'='(SD03901) Madison'
                  'SD04000'='(SD04000) Lawrence' 'SD04001'='(SD04001) Deadwood' 'SD04002'='(SD04002) Lead'
                  'SD04003'='(SD04003) Spearfish' 'SD04004'='(SD04004) Whitewood'
                  'SD04100'='(SD04100) Lincoln' 'SD04101'='(SD04101) Canton' 'SD04102'='(SD04102) Lennox'
                  'SD04103'='(SD04103) Harrisburg' 'SD04105'='(SD04105) Tea' 'SD04106'='(SD04106) Worthing'
                  'SD04200'='(SD04200) Lyman' 'SD04300'='(SD04300) Mccook' 'SD04301'='(SD04301) Salem'
                  'SD04302'='(SD04302) Bridgewater' 'SD04303'='(SD04303) Canistota'
                  'SD04304'='(SD04304) Montrose' 'SD04400'='(SD04400) Mcpherson'
                  'SD04401'='(SD04401) Eureka' 'SD04402'='(SD04402) Leola' 'SD04500'='(SD04500) Marshall'
                  'SD04600'='(SD04600) Meade' 'SD04601'='(SD04601) Sturgis' 'SD04602'='(SD04602) Faith'
                  'SD04700'='(SD04700) Mellette' 'SD04800'='(SD04800) Miner'
                  'SD04900'='(SD04900) Minnehaha' 'SD04901'='(SD04901) Dell Rapids'
                  'SD04902'='(SD04902) Sioux Falls' 'SD04903'='(SD04903) Brandon'
                  'SD04905'='(SD04905) Garretson' 'SD04906'='(SD04906) Hartford'
                  'SD05000'='(SD05000) Moody' 'SD05001'='(SD05001) Flandreau' 'SD05002'='(SD05002) Colman'
                  'SD05100'='(SD05100) Pennington' 'SD05101'='(SD05101) Rapid City'
                  'SD05103'='(SD05103) Box Elder' 'SD05200'='(SD05200) Perkins'
                  'SD05201'='(SD05201) Lemmon' 'SD05300'='(SD05300) Potter'
                  'SD05301'='(SD05301) Gettysburg' 'SD05302'='(SD05302) Hoven'
                  'SD05400'='(SD05400) Roberts' 'SD05401'='(SD05401) Sisseton'
                  'SD05403'='(SD05403) New Effington' 'SD05404'='(SD05404) Rosholt'
                  'SD05406'='(SD05406) Wilmot' 'SD05500'='(SD05500) Sanborn'
                  'SD05501'='(SD05501) Woonsocket' 'SD05600'='(SD05600) Shannon'
                  'SD05700'='(SD05700) Spink' 'SD05701'='(SD05701) Redfield' 'SD05800'='(SD05800) Stanley'
                  'SD05801'='(SD05801) Fort Pierre' 'SD05900'='(SD05900) Sully' 'SD06000'='(SD06000) Todd'
                  'SD06100'='(SD06100) Tripp' 'SD06101'='(SD06101) Winner' 'SD06200'='(SD06200) Turner'
                  'SD06201'='(SD06201) Parker' 'SD06202'='(SD06202) Centerville'
                  'SD06203'='(SD06203) Chancellor-Marion' 'SD06204'='(SD06204) Hurley'
                  'SD06206'='(SD06206) Viborg' 'SD06300'='(SD06300) Union' 'SD06301'='(SD06301) Beresford'
                  'SD06302'='(SD06302) Elk Point' 'SD06303'='(SD06303) Alcester'
                  'SD06304'='(SD06304) Jefferson' 'SD06305'='(SD06305) North Sioux City'
                  'SD06400'='(SD06400) Walworth' 'SD06401'='(SD06401) Mobridge'
                  'SD06402'='(SD06402) Glenham' 'SD06404'='(SD06404) Selby'
                  'SD06500'='(SD06500) Washabaugh' 'SD06600'='(SD06600) Yankton'
                  'SD06601'='(SD06601) Yankton' 'SD06700'='(SD06700) Ziebach'
                  'SDDCI00'='(SDDCI00) Div Of Criminal Invest'
                  'SDDMP00'='(SDDMP00) Sd Highway Patrol' 'TN00100'='(TN00100) Anderson'
                  'TN00101'='(TN00101) Clinton' 'TN00102'='(TN00102) Lake City'
                  'TN00103'='(TN00103) Oak Ridge' 'TN00104'='(TN00104) Norris'
                  'TN00105'='(TN00105) Spr: Norris Dam'
                  'TN00106'='(TN00106) Dtf:7th Judicial Distric'
                  'TN00108'='(TN00108) Spr: Cumberland Trail' 'TN00200'='(TN00200) Bedford'
                  'TN00201'='(TN00201) Shelbyville' 'TN00202'='(TN00202) Wartrace'
                  'TN0020A'='(TN0020A) Tn Tech Ctr: Shelbyville' 'TN00300'='(TN00300) Benton'
                  'TN00301'='(TN00301) Camden' 'TN00302'='(TN00302) Big Sandy'
                  'TN00303'='(TN00303) Spr: Nathan Bedford Forr' 'TN00400'='(TN00400) Bledsoe'
                  'TN00401'='(TN00401) Pikeville' 'TN00402'='(TN00402) Spr: Fall Creek Falls'
                  'TN00500'='(TN00500) Blount' 'TN00501'='(TN00501) Alcoa' 'TN00502'='(TN00502) Maryville'
                  'TN00503'='(TN00503) Friendsville' 'TN00504'='(TN00504) Rockford'
                  'TN00505'='(TN00505) Townsend' 'TN00506'='(TN00506) Dtf:5th Judicial Distric'
                  'TN00507'='(TN00507) Knoxville Metro Airport'
                  'TN0050A'='(TN0050A) Maryville College' 'TN00600'='(TN00600) Bradley'
                  'TN00601'='(TN00601) Cleveland' 'TN00602'='(TN00602) Charleston'
                  'TN00603'='(TN00603) Dtf:10th Judicial Distri'
                  'TN00604'='(TN00604) Spr: Red Clay St His Pk'
                  'TN00605'='(TN00605) Cleveland State Com Col'
                  'TN0060A'='(TN0060A) Church Of God,Sch Of The'
                  'TN0069P'='(TN0069P) Lee University' 'TN00700'='(TN00700) Campbell'
                  'TN00701'='(TN00701) Jellico' 'TN00702'='(TN00702) La Follette'
                  'TN00703'='(TN00703) Caryville' 'TN00704'='(TN00704) Jacksboro'
                  'TN00705'='(TN00705) Spr: Cove Lake' 'TN00706'='(TN00706) Spr: Indian Mountain'
                  'TN00707'='(TN00707) Dtf:8th Judicial Distric'
                  'TN0070A'='(TN0070A) Tn Tech Ctr: Jacksboro'
                  'TN0070B'='(TN0070B) Jacksboro Dtf-8th Dist' 'TN00800'='(TN00800) Cannon'
                  'TN00801'='(TN00801) Woodbury' 'TN00900'='(TN00900) Carroll'
                  'TN00901'='(TN00901) Huntingdon' 'TN00902'='(TN00902) Bruceton'
                  'TN00903'='(TN00903) Mckenzie' 'TN00904'='(TN00904) Trezevant'
                  'TN00906'='(TN00906) Hollow Rock'
                  'TN00907'='(TN00907) Dtf:24th Judicial Distri' 'TN00908'='(TN00908) Clarksburg'
                  'TN0090A'='(TN0090A) Bethel College'
                  'TN0090B'='(TN0090B) Tn Tech Ctr: Mc Kenzie' 'TN01000'='(TN01000) Carter'
                  'TN01001'='(TN01001) Elizabethton' 'TN01002'='(TN01002) Watauga'
                  'TN01003'='(TN01003) Spr: Roan Mountain'
                  'TN01004'='(TN01004) Spr:Sycamore Shoals S hp'
                  'TN0100A'='(TN0100A) Milligan College'
                  'TN0100B'='(TN0100B) Tn Tech Ctr:Elizabethton' 'TN01100'='(TN01100) Cheatham'
                  'TN01101'='(TN01101) Ashland City' 'TN01102'='(TN01102) Kingston Springs'
                  'TN01103'='(TN01103) Pleasant View' 'TN01200'='(TN01200) Chester'
                  'TN01201'='(TN01201) Henderson' 'TN01202'='(TN01202) Spr: Chickasaw'
                  'TN0120A'='(TN0120A) Freed-Hardeman Univ' 'TN01300'='(TN01300) Claiborne'
                  'TN01301'='(TN01301) New Tazewell' 'TN01302'='(TN01302) Tazewell'
                  'TN01303'='(TN01303) Cumberland Gap'
                  'TN0130A'='(TN0130A) Lincoln Memorial Univers' 'TN01400'='(TN01400) Clay'
                  'TN01401'='(TN01401) Celina' 'TN01500'='(TN01500) Cocke' 'TN01501'='(TN01501) Newport'
                  'TN01600'='(TN01600) Coffee' 'TN01601'='(TN01601) Manchester'
                  'TN01602'='(TN01602) Tullahoma' 'TN01603'='(TN01603) Spr:Old Stone Fort S a A'
                  'TN01605'='(TN01605) dtf:14th Judicial Distri'
                  'TN0160A'='(TN0160A) Univ Of Tn:Space Institu'
                  'TN0160C'='(TN0160C) Manchester Dtf'
                  'TN0169E'='(TN0169E) Motlow State Comm Coll' 'TN01700'='(TN01700) Crockett'
                  'TN01701'='(TN01701) Alamo' 'TN01702'='(TN01702) Bells' 'TN01703'='(TN01703) Friendship'
                  'TN01704'='(TN01704) Maury City' 'TN01705'='(TN01705) Gadsden'
                  'TN01800'='(TN01800) Cumberland' 'TN01801'='(TN01801) Crossville'
                  'TN01802'='(TN01802) Spr: Cumberland Mountain'
                  'TN01803'='(TN01803) Wildlife Ra: Region 3'
                  'TN0180A'='(TN0180A) Tn Tech Ctr: Crossville' 'TN01901'='(TN01901) Nashville'
                  'TN01902'='(TN01902) Berry Hill' 'TN01903'='(TN01903) Belle Meade'
                  'TN01904'='(TN01904) Goodlettsville' 'TN01905'='(TN01905) Oak Hill'
                  'TN01906'='(TN01906) Metropolitan Brd Of P&r'
                  'TN01907'='(TN01907) State Fire Marshal'
                  'TN01908'='(TN01908) Nashville Int Airport'
                  'TN0190B'='(TN0190B) aquinas College' 'TN0190C'='(TN0190C) Belmont University'
                  'TN0190D'='(TN0190D) Lipscomb Universit'
                  'TN0190E'='(TN0190E) Draughons Coll-Nashville'
                  'TN0190F'='(TN0190F) Fisk University'
                  'TN0190G'='(TN0190G) Free Will Bapt College'
                  'TN0190H'='(TN0190H) John Gupton College'
                  'TN0190I'='(TN0190I) Meharry Medical College'
                  'TN0190J'='(TN0190J) Mid Tenn Sch Of Anest'
                  'TN0190K'='(TN0190K) Nashville Auto Diesel Co'
                  'TN0190L'='(TN0190L) Tn Tech Ctr: Nashville'
                  'TN0190M'='(TN0190M) Trevecca Nazarene Univer'
                  'TN0190N'='(TN0190N) American Baptist College'
                  'TN0190P'='(TN0190P) Dtf:20th Judicial Distri'
                  'TN01910'='(TN01910) Wildlife Ra: Region 2' 'TN01914'='(TN01914) lakewood'
                  'TN01917'='(TN01917) Tennessee State Universi'
                  'TN01918'='(TN01918) Alcoholic Beverage Commi'
                  'TN01919'='(TN01919) Spr:Radnor Lake Nat Area'
                  'TN01920'='(TN01920) Spr: Long Hunter'
                  'TN01921'='(TN01921) Tn Dept Of Revenue, Siu'
                  'TN01923'='(TN01923) Nashville St Tech Comm C'
                  'TN01926'='(TN01926) spr:Bicentennial Cap Mal'
                  'TN01941'='(TN01941) Dept Of Correction Int A'
                  'TN01998'='(TN01998) Tenncare Off Inspct Gnrl'
                  'TN0199E'='(TN0199E) vanderbilt University' 'TN02000'='(TN02000) Decatur'
                  'TN02001'='(TN02001) Parsons' 'TN02002'='(TN02002) Decaturville'
                  'TN02100'='(TN02100) Dekalb' 'TN02101'='(TN02101) Smithville'
                  'TN02102'='(TN02102) Alexandria' 'TN02103'='(TN02103) Spr: Edgar Evins'
                  'TN02200'='(TN02200) Dickson' 'TN02201'='(TN02201) Dickson' 'TN02202'='(TN02202) Burns'
                  'TN02203'='(TN02203) White Bluff'
                  'TN02204'='(TN02204) Dtf:23rd Judicial Distri'
                  'TN02205'='(TN02205) Spr: Montgomery Bell'
                  'TN02206'='(TN02206) Dickson Parks And Rec'
                  'TN0220A'='(TN0220A) Tn Tech Ctr: Dickson'
                  'TN02299'='(TN02299) Spr: Harpeth Scnc Rivers' 'TN02300'='(TN02300) Dyer'
                  'TN02301'='(TN02301) Dyersburg' 'TN02302'='(TN02302) Newbern'
                  'TN02303'='(TN02303) Trimble' 'TN02304'='(TN02304) Dyersburg State Comm Col'
                  'TN0230A'='(TN0230A) Tn Tech Ctr: Newbern' 'TN02400'='(TN02400) Fayette'
                  'TN02401'='(TN02401) Somerville' 'TN02402'='(TN02402) Gallaway'
                  'TN02403'='(TN02403) Rossville' 'TN02404'='(TN02404) Moscow'
                  'TN02405'='(TN02405) Oakland' 'TN02406'='(TN02406) La Grange'
                  'TN02407'='(TN02407) Dtf:25th Judicial Distri' 'TN02408'='(TN02408) Piperton'
                  'TN02500'='(TN02500) Fentress' 'TN02501'='(TN02501) Jamestown'
                  'TN02502'='(TN02502) Spr: Sgt. Alvin C. york' 'TN02600'='(TN02600) Franklin'
                  'TN02601'='(TN02601) Sewanee' 'TN02602'='(TN02602) Winchester'
                  'TN02603'='(TN02603) Cowan' 'TN02604'='(TN02604) Decherd'
                  'TN02605'='(TN02605) Estill Springs' 'TN02606'='(TN02606) Huntland'
                  'TN02607'='(TN02607) Spr: Tims Ford'
                  'TN02608'='(TN02608) Spr: S cumberland Rec Ar' 'TN02700'='(TN02700) Gibson'
                  'TN02701'='(TN02701) Humboldt' 'TN02702'='(TN02702) Milan' 'TN02703'='(TN02703) Trenton'
                  'TN02704'='(TN02704) Dyer' 'TN02705'='(TN02705) Bradford' 'TN02706'='(TN02706) Gibson'
                  'TN02708'='(TN02708) Rutherford' 'TN02709'='(TN02709) Medina' 'TN02800'='(TN02800) Giles'
                  'TN02801'='(TN02801) Pulaski' 'TN02802'='(TN02802) Minor Hill'
                  'TN02803'='(TN02803) Ardmore' 'TN02804'='(TN02804) Lynnville'
                  'TN02805'='(TN02805) Elkton' 'TN0280A'='(TN0280A) Martin Methodist College'
                  'TN0280B'='(TN0280B) Tn Tech Ctr: Pulaski' 'TN02900'='(TN02900) Grainger'
                  'TN02901'='(TN02901) Rutledge' 'TN02902'='(TN02902) Blaine'
                  'TN02903'='(TN02903) Bean Station' 'TN03000'='(TN03000) Greene'
                  'TN03001'='(TN03001) Greeneville' 'TN03002'='(TN03002) Baileyton'
                  'TN03003'='(TN03003) Dtf:3rd Judicial Distric' 'TN03004'='(TN03004) Tusculum'
                  'TN03005'='(TN03005) Spr: David Crockett Bp'
                  'TN0300A'='(TN0300A) Tusculum College' 'TN03100'='(TN03100) Grundy'
                  'TN03101'='(TN03101) Tracy City' 'TN03102'='(TN03102) Gruetli-Laager'
                  'TN03103'='(TN03103) Palmer' 'TN03104'='(TN03104) Monteagle'
                  'TN03200'='(TN03200) Hamblen' 'TN03201'='(TN03201) Morristown'
                  'TN03202'='(TN03202) Walters State Comm Colle'
                  'TN03203'='(TN03203) Spr: Panther Creek'
                  'TN03204'='(TN03204) Wildlife Ra: Region 4'
                  'TN0320A'='(TN0320A) Tn Tech Ctr: Morristown' 'TN03300'='(TN03300) Hamilton'
                  'TN03301'='(TN03301) Chattanooga' 'TN03302'='(TN03302) East Ridge'
                  'TN03303'='(TN03303) Lookout Mountain' 'TN03305'='(TN03305) Signal Mountain'
                  'TN03306'='(TN03306) Soddy-Daisy' 'TN03307'='(TN03307) Collegedale'
                  'TN03308'='(TN03308) Red Bank' 'TN03309'='(TN03309) Univ Of Tn: Chattanooga'
                  'TN0330B'='(TN0330B) southern Adventist Unive'
                  'TN0330C'='(TN0330C) Tenn Temple University' 'TN03310'='(TN03310) Walden'
                  'TN03313'='(TN03313) Chattanooga Metro Airpor'
                  'TN03315'='(TN03315) Spr: Booker T. washingto'
                  'TN03316'='(TN03316) Spr: Harrison Bay'
                  'TN03317'='(TN03317) Chattanooga St Tech Cc'
                  'TN0331A'='(TN0331A) Elect Comp Program Coll' 'TN03400'='(TN03400) Hancock'
                  'TN03401'='(TN03401) Sneedville' 'TN03500'='(TN03500) Hardeman'
                  'TN03501'='(TN03501) Bolivar' 'TN03502'='(TN03502) Whiteville'
                  'TN03503'='(TN03503) Middleton' 'TN03505'='(TN03505) Grand Junction'
                  'TN03507'='(TN03507) Toone' 'TN0350A'='(TN0350A) Tn Tech Ctr: Whiteville'
                  'TN03600'='(TN03600) Hardin' 'TN03601'='(TN03601) Savannah'
                  'TN03602'='(TN03602) Spr: Pickwick Landing' 'TN03604'='(TN03604) Crump'
                  'TN0360A'='(TN0360A) Tn Tech Ctr: Crump' 'TN03700'='(TN03700) Hawkins'
                  'TN03701'='(TN03701) Rogersville' 'TN03702'='(TN03702) Surgoinsville'
                  'TN03703'='(TN03703) Mount Carmel' 'TN03704'='(TN03704) Church Hill'
                  'TN03705'='(TN03705) Bulls Gap' 'TN03800'='(TN03800) Haywood'
                  'TN03801'='(TN03801) Brownsville' 'TN03900'='(TN03900) Henderson'
                  'TN03901'='(TN03901) Lexington' 'TN03902'='(TN03902) Scotts Hill'
                  'TN03905'='(TN03905) Spr: Natchez Trace' 'TN04000'='(TN04000) Henry'
                  'TN04001'='(TN04001) Paris' 'TN04002'='(TN04002) Puryear'
                  'TN04003'='(TN04003) Spr: Paris Landing' 'TN04004'='(TN04004) Henry'
                  'TN0400A'='(TN0400A) Tn Tech Ctr: Paris' 'TN04100'='(TN04100) Hickman'
                  'TN04101'='(TN04101) Centerville' 'TN04200'='(TN04200) Houston'
                  'TN04201'='(TN04201) Erin' 'TN04300'='(TN04300) Humphreys' 'TN04301'='(TN04301) Waverly'
                  'TN04302'='(TN04302) New Johnsonville' 'TN04303'='(TN04303) Mcewen'
                  'TN04304'='(TN04304) Spr:Johnsonville S his P' 'TN04400'='(TN04400) jackson'
                  'TN04401'='(TN04401) Gainesboro' 'TN04500'='(TN04500) Jefferson'
                  'TN04501'='(TN04501) Jefferson City' 'TN04502'='(TN04502) White Pine'
                  'TN04503'='(TN04503) Dandridge' 'TN04504'='(TN04504) New Market'
                  'TN0450A'='(TN0450A) Carson Newman College' 'TN04600'='(TN04600) Johnson'
                  'TN04601'='(TN04601) Mountain City' 'TN04700'='(TN04700) Knox'
                  'TN04701'='(TN04701) Knoxville' 'TN04705'='(TN04705) Univ Of Tn: Knoxville'
                  'TN0470A'='(TN0470A) Johnson Bible College' 'TN0470B'='(TN0470B) South College'
                  'TN0470C'='(TN0470C) Knoxville College'
                  'TN0470D'='(TN0470D) Pellissippi St Tech Cc'
                  'TN0470E'='(TN0470E) Fountainhead Col Of Tech'
                  'TN0470F'='(TN0470F) Tn Tech Ctr: Knoxville'
                  'TN0470G'='(TN0470G) Knoxville Dtf' 'TN04800'='(TN04800) Lake'
                  'TN04801'='(TN04801) Ridgely' 'TN04802'='(TN04802) Tiptonville'
                  'TN04803'='(TN04803) Spr: Reelfoot Lake' 'TN04900'='(TN04900) Lauderdale'
                  'TN04901'='(TN04901) Ripley' 'TN04902'='(TN04902) Halls' 'TN04903'='(TN04903) Henning'
                  'TN04904'='(TN04904) Gates' 'TN04905'='(TN04905) Spr:Fort Pillow St Hst P'
                  'TN0490A'='(TN0490A) Tn Tech Ctr: Ripley' 'TN05000'='(TN05000) lawrence'
                  'TN05001'='(TN05001) Lawrenceburg' 'TN05002'='(TN05002) Loretto'
                  'TN05003'='(TN05003) St. Joseph' 'TN05004'='(TN05004) Iron City'
                  'TN05006'='(TN05006) Spr: David Crockett' 'TN05007'='(TN05007) Ethridge'
                  'TN05008'='(TN05008) Dtf:22nd Judicial Distri' 'TN05100'='(TN05100) Lewis'
                  'TN05101'='(TN05101) Hohenwald' 'TN0510A'='(TN0510A) Tn Tech Ctr: Hohenwald'
                  'TN05200'='(TN05200) Lincoln' 'TN05201'='(TN05201) Fayetteville'
                  'TN05300'='(TN05300) Loudon' 'TN05301'='(TN05301) Lenoir City'
                  'TN05302'='(TN05302) Loudon' 'TN05400'='(TN05400) Mcminn' 'TN05401'='(TN05401) Athens'
                  'TN05402'='(TN05402) Englewood' 'TN05403'='(TN05403) Etowah'
                  'TN05404'='(TN05404) Calhoun' 'TN05405'='(TN05405) Niota'
                  'TN0540A'='(TN0540A) Tn Tech Ctr: Athens'
                  'TN0540B'='(TN0540B) Tenn Wesleyan College' 'TN05500'='(TN05500) Mcnairy'
                  'TN05501'='(TN05501) Selmer' 'TN05502'='(TN05502) Adamsville'
                  'TN05503'='(TN05503) Bethel Springs' 'TN05504'='(TN05504) Spr: Big Hill Pond'
                  'TN05600'='(TN05600) Macon' 'TN05601'='(TN05601) Lafayette'
                  'TN05602'='(TN05602) Red Boiling Springs' 'TN05700'='(TN05700) Madison'
                  'TN05701'='(TN05701) Jackson' 'TN05702'='(TN05702) Bemis'
                  'TN05705'='(TN05705) Spr: Pinson Mounds S a P'
                  'TN05707'='(TN05707) wildlife Ra: Region 1'
                  'TN05708'='(TN05708) jackson State Comm Coll'
                  'TN0570A'='(TN0570A) Lambuth University' 'TN0570B'='(TN0570B) Lane College'
                  'TN0570C'='(TN0570C) Tn Tech Ctr: Jackson'
                  'TN0570D'='(TN0570D) Union University'
                  'TN0570E'='(TN0570E) Jackson Metro Narc Unit' 'TN05800'='(TN05800) Marion'
                  'TN05801'='(TN05801) South Pittsburg' 'TN05802'='(TN05802) Whitwell'
                  'TN05803'='(TN05803) Jasper' 'TN05805'='(TN05805) Kimball' 'TN05806'='(TN05806) New Hope'
                  'TN05807'='(TN05807) Dtf:12th Judicial Distri'
                  'TN05808'='(TN05808) Powells Crossroads' 'TN05900'='(TN05900) Marshall'
                  'TN05901'='(TN05901) Lewisburg' 'TN05902'='(TN05902) Chapel Hill'
                  'TN05903'='(TN05903) Cornersville' 'TN05904'='(TN05904) Petersburg'
                  'TN05905'='(TN05905) Dtf:17th Judicial Distri'
                  'TN05906'='(TN05906) Spr: Henry Horton' 'TN06000'='(TN06000) Maury'
                  'TN06001'='(TN06001) Columbia' 'TN06002'='(TN06002) Mount Pleasant'
                  'TN06003'='(TN06003) Spring Hill'
                  'TN06004'='(TN06004) Columbia State Comm Coll'
                  'TN06006'='(TN06006) Dtf: Maury County' 'TN06100'='(TN06100) Meigs'
                  'TN06101'='(TN06101) Decatur' 'TN06200'='(TN06200) Monroe'
                  'TN06201'='(TN06201) Sweetwater' 'TN06202'='(TN06202) Madisonville'
                  'TN06203'='(TN06203) Tellico Plains'
                  'TN06204'='(TN06204) Spr:Fort Loudon St Hst P' 'TN06205'='(TN06205) vonore'
                  'TN0620A'='(TN0620A) Hiwassee College' 'TN06300'='(TN06300) Montgomery'
                  'TN06301'='(TN06301) Clarksville' 'TN06302'='(TN06302) Austin Peay State Univ'
                  'TN06303'='(TN06303) Spr: Dunbar Cave Nat Are'
                  'TN06305'='(TN06305) Dtf:19th Judicial Distri'
                  'TN0630A'='(TN0630A) Miller-Motte Business Co'
                  'TN0630B'='(TN0630B) Draughons Coll-Clarksvil' 'TN06400'='(TN06400) Moore'
                  'TN06500'='(TN06500) Morgan' 'TN06501'='(TN06501) Wartburg'
                  'TN06502'='(TN06502) Spr: Frozen Head Nat Are' 'TN06600'='(TN06600) Obion'
                  'TN06601'='(TN06601) Union City' 'TN06602'='(TN06602) South Fulton'
                  'TN06603'='(TN06603) Kenton' 'TN06604'='(TN06604) Troy' 'TN06605'='(TN06605) Obion'
                  'TN06606'='(TN06606) Dtf:27th Judicial Distri' 'TN06607'='(TN06607) Hornbeak'
                  'TN06608'='(TN06608) Samburg' 'TN06700'='(TN06700) Overton'
                  'TN06701'='(TN06701) Livingston' 'TN06702'='(TN06702) Spr: Standing Stone'
                  'TN0670A'='(TN0670A) Tn Tech Ctr: Livingston' 'TN06800'='(TN06800) Perry'
                  'TN06803'='(TN06803) Spr: Mousetail Landing' 'TN06900'='(TN06900) Pickett'
                  'TN06902'='(TN06902) Spr: Pickett' 'TN07000'='(TN07000) Polk'
                  'TN07001'='(TN07001) Copperhill' 'TN07002'='(TN07002) Benton'
                  'TN07004'='(TN07004) Spr:Hiwassee/Ocoee S s R' 'TN07100'='(TN07100) putnam'
                  'TN07101'='(TN07101) Cookeville' 'TN07102'='(TN07102) Algood'
                  'TN07103'='(TN07103) Monterey' 'TN07104'='(TN07104) Baxter'
                  'TN07105'='(TN07105) Tenn Technological Univ'
                  'TN07107'='(TN07107) Spr: Burgess Falls Nat A'
                  'TN07108'='(TN07108) dtf:13th Judicial Distri' 'TN07200'='(TN07200) Rhea'
                  'TN07201'='(TN07201) Dayton' 'TN07202'='(TN07202) Spring City'
                  'TN07203'='(TN07203) Graysville' 'TN0720A'='(TN0720A) Bryan College'
                  'TN07300'='(TN07300) Roane' 'TN07301'='(TN07301) Harriman' 'TN07302'='(TN07302) Kingston'
                  'TN07303'='(TN07303) Oliver Springs' 'TN07304'='(TN07304) Rockwood'
                  'TN07305'='(TN07305) Dtf:9th Judicial Distric'
                  'TN07306'='(TN07306) Roane State Comm College'
                  'TN0730A'='(TN0730A) Tn Tech Ctr: Harriman' 'TN07400'='(TN07400) Robertson'
                  'TN07401'='(TN07401) Springfield' 'TN07402'='(TN07402) Greenbrier'
                  'TN07403'='(TN07403) Ridgetop' 'TN07404'='(TN07404) Cross Plains'
                  'TN07406'='(TN07406) Coopertown' 'TN07500'='(TN07500) Rutherford'
                  'TN07501'='(TN07501) Murfreesboro' 'TN07502'='(TN07502) Smyrna'
                  'TN07503'='(TN07503) La Vergne' 'TN07504'='(TN07504) Middle Tennessee State U'
                  'TN07505'='(TN07505) eagleville' 'TN07507'='(TN07507) Smyrna/Rutherford Co Aa'
                  'TN0750A'='(TN0750A) Tn Tech Ctr:Murfreesboro' 'TN07600'='(TN07600) Scott'
                  'TN07601'='(TN07601) Oneida' 'TN07602'='(TN07602) Winfield'
                  'TN0760A'='(TN0760A) Tn Tech Ctr: Oneida' 'TN07700'='(TN07700) Sequatchie'
                  'TN07701'='(TN07701) Dunlap' 'TN07800'='(TN07800) Sevier'
                  'TN07801'='(TN07801) Gatlinburg' 'TN07802'='(TN07802) Sevierville'
                  'TN07803'='(TN07803) Pigeon Forge' 'TN07804'='(TN07804) Pittman Center'
                  'TN07805'='(TN07805) Dtf:4th Judicial Distric' 'TN07900'='(TN07900) Shelby'
                  'TN07901'='(TN07901) Collierville' 'TN07902'='(TN07902) Germantown'
                  'TN07904'='(TN07904) Millington' 'TN07905'='(TN07905) Univ Of Tn: Memphis'
                  'TN07906'='(TN07906) Bartlett' 'TN07909'='(TN07909) University Of Memphis'
                  'TN0790A'='(TN0790A) Christian Brothers Univ'
                  'TN0790B'='(TN0790B) Crichton College'
                  'TN0790C'='(TN0790C) Harding Un Grad Sch Rel'
                  'TN0790D'='(TN0790D) Le Moyne-Owen College'
                  'TN0790E'='(TN0790E) Memphis College Of Art'
                  'TN0790F'='(TN0790F) Memphis Theol Seminary'
                  'TN0790G'='(TN0790G) Mid-Amer Bapt Theol Sem'
                  'TN0790H'='(TN0790H) Rhodes College'
                  'TN0790N'='(TN0790N) Memphis Drug Task Force'
                  'TN07910'='(TN07910) Memphis Int Airport'
                  'TN07911'='(TN07911) State Technical Institut'
                  'TN07914'='(TN07914) Spr: Meeman-Shelby Fores'
                  'TN07915'='(TN07915) Spr: T.o. Fuller'
                  'TN07916'='(TN07916) Shelby State Comm Coll'
                  'TN07918'='(TN07918) Shelby County Police Dep'
                  'TN0791I'='(TN0791I) Shelby St Cc: Mendenhall'
                  'TN0791J'='(TN0791J) Shelby St Cc:Mount. Terr'
                  'TN0791K'='(TN0791K) Shelby St Cc:Union Avenu'
                  'TN0791L'='(TN0791L) Southern Coll Of Optom'
                  'TN0791M'='(TN0791M) Tn Tech Ctr: Memphis'
                  'TN07920'='(TN07920) West Tn Violent Crime Tf'
                  'TN07924'='(TN07924) Southwest Tn Comm Colleg'
                  'TN07927'='(TN07927) Christian Brothers Univ' 'TN08000'='(TN08000) Smith'
                  'TN08001'='(TN08001) Carthage' 'TN08002'='(TN08002) South Carthage'
                  'TN08003'='(TN08003) Gordonsville' 'TN08100'='(TN08100) Stewart'
                  'TN08102'='(TN08102) Cumberland City' 'TN08103'='(TN08103) Dover'
                  'TN08200'='(TN08200) Sullivan' 'TN08201'='(TN08201) Bristol'
                  'TN08202'='(TN08202) Kingsport' 'TN08203'='(TN08203) Bluff City'
                  'TN08205'='(TN08205) Spr: Warriors Path'
                  'TN08206'='(TN08206) Dtf:2nd Judicial Distric'
                  'TN08207'='(TN08207) Tri-Cities Reg Airport'
                  'TN08208'='(TN08208) Ne State Technical Com C'
                  'TN0820A'='(TN0820A) King College' 'TN0820B'='(TN0820B) Northeast St Tech Cc'
                  'TN08300'='(TN08300) sumner' 'TN08301'='(TN08301) Gallatin'
                  'TN08302'='(TN08302) Portland' 'TN08303'='(TN08303) White House'
                  'TN08304'='(TN08304) Hendersonville' 'TN08305'='(TN08305) Westmoreland'
                  'TN08306'='(TN08306) Millersville'
                  'TN08307'='(TN08307) Dtf:18th Judicial Distri'
                  'TN08308'='(TN08308) Spr: Bledsoe Creek'
                  'TN08309'='(TN08309) Volunteer State Comm Col' 'TN08400'='(TN08400) Tipton'
                  'TN08401'='(TN08401) Covington' 'TN08402'='(TN08402) Munford' 'TN08403'='(TN08403) Mason'
                  'TN08404'='(TN08404) Brighton' 'TN08405'='(TN08405) Atoka'
                  'TN0840A'='(TN0840A) Tn Tech Ctr: Covington'
                  'TN08500'='(TN08500) Hartsville-Trousdale' 'TN08501'='(TN08501) Hartsville'
                  'TN08502'='(TN08502) Dtf:15th Judicial Distri'
                  'TN0850A'='(TN0850A) Tn Tech Ctr: Hartsville' 'TN08600'='(TN08600) Unicoi'
                  'TN08601'='(TN08601) Erwin' 'TN08700'='(TN08700) Union'
                  'TN08701'='(TN08701) Maynardville' 'TN08702'='(TN08702) Spr: Big Ridge'
                  'TN08800'='(TN08800) Van Buren' 'TN08801'='(TN08801) Spencer'
                  'TN08900'='(TN08900) Warren' 'TN08901'='(TN08901) Mcminnville'
                  'TN08902'='(TN08902) Spr: Rock Island'
                  'TN08903'='(TN08903) Dtf:31st Judicial Distri'
                  'TN0890A'='(TN0890A) Tn Tech Ctr:Mc Minnville' 'TN09000'='(TN09000) Washington'
                  'TN09001'='(TN09001) Johnson City' 'TN09002'='(TN09002) Jonesborough'
                  'TN09003'='(TN09003) East Tennessee State Uni'
                  'TN09004'='(TN09004) Dtf:1st Judicial Distric'
                  'TN0900A'='(TN0900A) Emmanuel Sch Of Religion' 'TN09100'='(TN09100) Wayne'
                  'TN09101'='(TN09101) Waynesboro' 'TN09102'='(TN09102) Clifton'
                  'TN09103'='(TN09103) Collinwood' 'TN09200'='(TN09200) Weakley'
                  'TN09201'='(TN09201) Dresden' 'TN09202'='(TN09202) Martin' 'TN09203'='(TN09203) Gleason'
                  'TN09204'='(TN09204) Greenfield' 'TN09205'='(TN09205) Sharon'
                  'TN09206'='(TN09206) Univ Of Tn: Martin' 'TN09300'='(TN09300) White'
                  'TN09301'='(TN09301) Sparta' 'TN09400'='(TN09400) Williamson'
                  'TN09401'='(TN09401) Franklin' 'TN09402'='(TN09402) Fairview'
                  'TN09403'='(TN09403) Brentwood' 'TN09404'='(TN09404) Dtf:21st Judicial Distri'
                  'TN09405'='(TN09405) Nolensville' 'TN0940A'='(TN0940A) Omore College Of Design'
                  'TN09500'='(TN09500) Wilson' 'TN09501'='(TN09501) Lebanon'
                  'TN09502'='(TN09502) Watertown' 'TN09503'='(TN09503) Mount Juliet'
                  'TN09505'='(TN09505) Spr: Cedars Of Lebanon'
                  'TN0950A'='(TN0950A) Cumberland University' 'TNMPD00'='(TNMPD00) Memphis'
                  'TNTBI00'='(TNTBI00) Tenn Bureau Of Investiga'
                  'TNTHP00'='(TNTHP00) Tennessee Dept Of Safety'
                  'TNTHP01'='(TNTHP01) Department Of Safety'
                  'TX00000'='(TX00000) Dept Of Public Safety' 'TX00100'='(TX00100) Anderson'
                  'TX00101'='(TX00101) Palestine' 'TX00103'='(TX00103) Frankston'
                  'TX00106'='(TX00106) Elkhart' 'TX00200'='(TX00200) Andrews' 'TX00201'='(TX00201) Andrews'
                  'TX00300'='(TX00300) Angelina' 'TX00301'='(TX00301) Diboll'
                  'TX00302'='(TX00302) Huntington' 'TX00304'='(TX00304) Lufkin'
                  'TX00311'='(TX00311) Zavalla' 'TX00313'='(TX00313) Hudson' 'TX00400'='(TX00400) Aransas'
                  'TX00401'='(TX00401) Aransas Pass' 'TX00402'='(TX00402) Rockport'
                  'TX00500'='(TX00500) Archer' 'TX00502'='(TX00502) Holliday'
                  'TX00600'='(TX00600) Armstrong' 'TX00700'='(TX00700) Atascosa'
                  'TX00701'='(TX00701) Lytle' 'TX00702'='(TX00702) Pleasanton' 'TX00703'='(TX00703) Poteet'
                  'TX00704'='(TX00704) Jourdanton' 'TX00800'='(TX00800) Austin'
                  'TX00801'='(TX00801) Bellville' 'TX00802'='(TX00802) Sealy' 'TX00807'='(TX00807) Wallis'
                  'TX00900'='(TX00900) Bailey' 'TX00901'='(TX00901) Muleshoe' 'TX01000'='(TX01000) Bandera'
                  'TX01100'='(TX01100) Bastrop' 'TX01101'='(TX01101) Bastrop' 'TX01102'='(TX01102) Elgin'
                  'TX01103'='(TX01103) Smithville' 'TX01200'='(TX01200) Baylor'
                  'TX01201'='(TX01201) Seymour' 'TX01300'='(TX01300) Bee' 'TX01301'='(TX01301) Beeville'
                  'TX01400'='(TX01400) Bell' 'TX01401'='(TX01401) Bartlett' 'TX01402'='(TX01402) Belton'
                  'TX01403'='(TX01403) Harker Heights' 'TX01404'='(TX01404) Killeen'
                  'TX01405'='(TX01405) Nolanville' 'TX01407'='(TX01407) Temple'
                  'TX01409'='(TX01409) Central Texas College'
                  'TX01410'='(TX01410) Morgans Point Resort' 'TX01411'='(TX01411) Holland'
                  'TX01415'='(TX01415) Isd: Killeen' 'TX01418'='(TX01418) Salado'
                  'TX01419'='(TX01419) Univ Of Mary Hardin-Bayl' 'TX01500'='(TX01500) Bexar'
                  'TX01501'='(TX01501) Alamo Heights' 'TX01502'='(TX01502) Balcones Heights'
                  'TX01503'='(TX01503) Castle Hills' 'TX01505'='(TX01505) Converse'
                  'TX01507'='(TX01507) Hill Country Village' 'TX01508'='(TX01508) Hollywood Park'
                  'TX01509'='(TX01509) Kirby' 'TX01510'='(TX01510) Leon Valley'
                  'TX01511'='(TX01511) Olmos Park' 'TX01512'='(TX01512) Shavano Park'
                  'TX01513'='(TX01513) Terrell Hills' 'TX01514'='(TX01514) Universal City'
                  'TX01515'='(TX01515) Windcrest' 'TX01516'='(TX01516) Live Oak'
                  'TX01517'='(TX01517) U of Tx:Hea Sci Ct,San A'
                  'TX01519'='(TX01519) univ Of Tx: San Antonio' 'TX01520'='(TX01520) Isd: Judson'
                  'TX01521'='(TX01521) Alamo Comm Coll District' 'TX01522'='(TX01522) Selma'
                  'TX01523'='(TX01523) Somerset' 'TX01530'='(TX01530) Helotes'
                  'TX01531'='(TX01531) Trinity University'
                  'TX01534'='(TX01534) St. Marys University'
                  'TX01535'='(TX01535) Isd: East Central' 'TX01538'='(TX01538) Isd: North East'
                  'TX01539'='(TX01539) Fair Oaks Ranch' 'TX01600'='(TX01600) Blanco'
                  'TX01601'='(TX01601) Blanco' 'TX01602'='(TX01602) Johnson City'
                  'TX01700'='(TX01700) Borden' 'TX01800'='(TX01800) Bosque' 'TX01801'='(TX01801) Clifton'
                  'TX01802'='(TX01802) Valley Mills' 'TX01808'='(TX01808) Meridian'
                  'TX01809'='(TX01809) Walnut Springs' 'TX01900'='(TX01900) Bowie'
                  'TX01901'='(TX01901) De Kalb' 'TX01903'='(TX01903) Nash' 'TX01904'='(TX01904) New Boston'
                  'TX01905'='(TX01905) Texarkana' 'TX01906'='(TX01906) Wake Village'
                  'TX01908'='(TX01908) Hooks' 'TX02000'='(TX02000) Brazoria' 'TX02001'='(TX02001) Alvin'
                  'TX02002'='(TX02002) Angleton' 'TX02003'='(TX02003) Clute' 'TX02004'='(TX02004) Danbury'
                  'TX02005'='(TX02005) Freeport' 'TX02008'='(TX02008) Lake Jackson'
                  'TX02009'='(TX02009) Manvel' 'TX02010'='(TX02010) Pearland'
                  'TX02011'='(TX02011) Richwood' 'TX02012'='(TX02012) Sweeny'
                  'TX02014'='(TX02014) West Columbia'
                  'TX02017'='(TX02017) Alvin Community College' 'TX02018'='(TX02018) Brazoria'
                  'TX02019'='(TX02019) Brookside Village' 'TX02027'='(TX02027) Jones Creek'
                  'TX02028'='(TX02028) Surfside Beach' 'TX02029'='(TX02029) Oyster Creek'
                  'TX02030'='(TX02030) Iowa Colony' 'TX02032'='(TX02032) Isd: Alvin'
                  'TX02033'='(TX02033) Isd: Angleton' 'TX02100'='(TX02100) Brazos'
                  'TX02101'='(TX02101) Bryan' 'TX02102'='(TX02102) College Station'
                  'TX02104'='(TX02104) Tx A&m Un:College Statio' 'TX02200'='(TX02200) Brewster'
                  'TX02201'='(TX02201) Alpine' 'TX02202'='(TX02202) Sul Ross State Universit'
                  'TX02300'='(TX02300) Briscoe' 'TX02400'='(TX02400) Brooks'
                  'TX02401'='(TX02401) Falfurrias' 'TX02500'='(TX02500) Brown' 'TX02501'='(TX02501) Bangs'
                  'TX02502'='(TX02502) Brownwood' 'TX02503'='(TX02503) Early'
                  'TX02600'='(TX02600) Burleson' 'TX02601'='(TX02601) Caldwell'
                  'TX02602'='(TX02602) Somerville' 'TX02700'='(TX02700) Burnet'
                  'TX02701'='(TX02701) Burnet' 'TX02702'='(TX02702) Marble Falls'
                  'TX02706'='(TX02706) Bertram' 'TX02707'='(TX02707) Granite Shoals'
                  'TX02711'='(TX02711) Horseshoe Bay' 'TX02712'='(TX02712) Cottonwood Shores'
                  'TX02800'='(TX02800) Caldwell' 'TX02801'='(TX02801) Lockhart'
                  'TX02802'='(TX02802) Luling' 'TX02809'='(TX02809) Martindale'
                  'TX02900'='(TX02900) Calhoun' 'TX02901'='(TX02901) Point Comfort'
                  'TX02902'='(TX02902) Port Lavaca' 'TX02903'='(TX02903) Seadrift'
                  'TX03000'='(TX03000) Callahan' 'TX03001'='(TX03001) Baird' 'TX03003'='(TX03003) Clyde'
                  'TX03100'='(TX03100) Cameron' 'TX03101'='(TX03101) Brownsville'
                  'TX03102'='(TX03102) Combes' 'TX03103'='(TX03103) Harlingen'
                  'TX03104'='(TX03104) La Feria' 'TX03105'='(TX03105) Los Fresnos'
                  'TX03106'='(TX03106) Port Isabel' 'TX03107'='(TX03107) Primera'
                  'TX03109'='(TX03109) San Benito' 'TX03110'='(TX03110) Santa Rosa'
                  'TX03112'='(TX03112) Univ Of Tx: Brownsville'
                  'TX03113'='(TX03113) South Padre Island'
                  'TX03114'='(TX03114) Tx St Tech Col:Harlingen'
                  'TX03122'='(TX03122) Cameron Co Park Rangers'
                  'TX03124'='(TX03124) Isd: Brownsville' 'TX03129'='(TX03129) Laguna Vista'
                  'TX03200'='(TX03200) Camp' 'TX03201'='(TX03201) Pittsburg' 'TX03300'='(TX03300) Carson'
                  'TX03301'='(TX03301) Panhandle' 'TX03400'='(TX03400) Cass' 'TX03401'='(TX03401) Atlanta'
                  'TX03403'='(TX03403) Linden' 'TX03404'='(TX03404) Queen City'
                  'TX03414'='(TX03414) Bloomburg' 'TX03500'='(TX03500) Castro'
                  'TX03501'='(TX03501) Dimmitt' 'TX03502'='(TX03502) Hart' 'TX03600'='(TX03600) Chambers'
                  'TX03607'='(TX03607) Mont Belvieu' 'TX03700'='(TX03700) Cherokee'
                  'TX03701'='(TX03701) Jacksonville' 'TX03703'='(TX03703) Rusk' 'TX03710'='(TX03710) Alto'
                  'TX03711'='(TX03711) Wells' 'TX03712'='(TX03712) Cuney' 'TX03800'='(TX03800) Childress'
                  'TX03801'='(TX03801) Childress' 'TX03900'='(TX03900) Clay'
                  'TX03901'='(TX03901) Henrietta' 'TX04000'='(TX04000) Cochran'
                  'TX04001'='(TX04001) Morton' 'TX04100'='(TX04100) Coke' 'TX04200'='(TX04200) Coleman'
                  'TX04201'='(TX04201) Coleman' 'TX04202'='(TX04202) Santa Anna'
                  'TX04300'='(TX04300) Collin' 'TX04301'='(TX04301) Allen' 'TX04302'='(TX04302) Celina'
                  'TX04303'='(TX04303) Farmersville' 'TX04304'='(TX04304) Frisco'
                  'TX04305'='(TX04305) Mckinney' 'TX04306'='(TX04306) Plano' 'TX04307'='(TX04307) Prosper'
                  'TX04308'='(TX04308) Wylie' 'TX04309'='(TX04309) Princeton' 'TX04317'='(TX04317) Melissa'
                  'TX04318'='(TX04318) Murphy' 'TX04319'='(TX04319) Parker' 'TX04320'='(TX04320) Lavon'
                  'TX04326'='(TX04326) Anna' 'TX04400'='(TX04400) Collingsworth'
                  'TX04401'='(TX04401) Wellington' 'TX04500'='(TX04500) Colorado'
                  'TX04501'='(TX04501) Columbus' 'TX04502'='(TX04502) Eagle Lake'
                  'TX04503'='(TX04503) Weimar' 'TX04600'='(TX04600) Comal'
                  'TX04601'='(TX04601) New Braunfels' 'TX04608'='(TX04608) Bulverde'
                  'TX04700'='(TX04700) Comanche' 'TX04701'='(TX04701) Comanche'
                  'TX04702'='(TX04702) De Leon' 'TX04800'='(TX04800) Concho' 'TX04801'='(TX04801) Eden'
                  'TX04900'='(TX04900) Cooke' 'TX04901'='(TX04901) Gainesville'
                  'TX04907'='(TX04907) Valley View' 'TX04908'='(TX04908) Oak Ridge'
                  'TX05000'='(TX05000) Coryell' 'TX05001'='(TX05001) Copperas Cove'
                  'TX05002'='(TX05002) Gatesville' 'TX05004'='(TX05004) Fort Gates'
                  'TX05100'='(TX05100) Cottle' 'TX05101'='(TX05101) Paducah' 'TX05200'='(TX05200) Crane'
                  'TX05201'='(TX05201) Crane' 'TX05300'='(TX05300) Crockett' 'TX05400'='(TX05400) Crosby'
                  'TX05401'='(TX05401) Crosbyton' 'TX05402'='(TX05402) Lorenzo' 'TX05403'='(TX05403) Ralls'
                  'TX05500'='(TX05500) Culberson' 'TX05501'='(TX05501) Van Horn'
                  'TX05600'='(TX05600) Dallam' 'TX05601'='(TX05601) Dalhart' 'TX05700'='(TX05700) Dallas'
                  'TX05701'='(TX05701) Addison' 'TX05702'='(TX05702) Balch Springs'
                  'TX05704'='(TX05704) Carrollton' 'TX05705'='(TX05705) Cedar Hill'
                  'TX05706'='(TX05706) Cockrell Hill' 'TX05707'='(TX05707) Coppell'
                  'TX05708'='(TX05708) Desoto' 'TX05709'='(TX05709) Duncanville'
                  'TX05710'='(TX05710) Farmers Branch' 'TX05711'='(TX05711) Garland'
                  'TX05712'='(TX05712) Grand Prairie' 'TX05713'='(TX05713) Highland Park'
                  'TX05714'='(TX05714) Hutchins' 'TX05715'='(TX05715) Irving' 'TX05716'='(TX05716) Kleburg'
                  'TX05717'='(TX05717) Lancaster' 'TX05718'='(TX05718) Mesquite'
                  'TX05720'='(TX05720) Richardson' 'TX05721'='(TX05721) Sachse'
                  'TX05722'='(TX05722) Seagoville' 'TX05724'='(TX05724) University Park'
                  'TX05725'='(TX05725) Wilmer' 'TX05726'='(TX05726) Univ Of Tx:Sw Medical Sc'
                  'TX05728'='(TX05728) Univ Of Tx: Dallas'
                  'TX05729'='(TX05729) Eastfield College' 'TX05733'='(TX05733) Rowlett'
                  'TX05734'='(TX05734) Richland College' 'TX05735'='(TX05735) North Lake College'
                  'TX05744'='(TX05744) Mountain View College' 'TX05747'='(TX05747) Glenn Heights'
                  'TX05750'='(TX05750) Hos Dist: Dallas County'
                  'TX05751'='(TX05751) Baylor Health Care Syste'
                  'TX05752'='(TX05752) Southern Methodist Univ' 'TX05755'='(TX05755) Ovilla'
                  'TX05759'='(TX05759) St. Paul Medical Center'
                  'TX05768'='(TX05768) Isd: Cedar Hill' 'TX05800'='(TX05800) Dawson'
                  'TX05801'='(TX05801) Lamesa' 'TX05900'='(TX05900) Deaf Smith'
                  'TX05901'='(TX05901) Hereford' 'TX06000'='(TX06000) Delta' 'TX06001'='(TX06001) Cooper'
                  'TX06100'='(TX06100) Denton' 'TX06101'='(TX06101) Argyle' 'TX06102'='(TX06102) Denton'
                  'TX06105'='(TX06105) Lake Dallas' 'TX06106'='(TX06106) Lewisville'
                  'TX06107'='(TX06107) Pilot Point' 'TX06108'='(TX06108) Sanger'
                  'TX06110'='(TX06110) Texas Womans University'
                  'TX06111'='(TX06111) Univ Of N tx: Denton' 'TX06112'='(TX06112) Flower Mound'
                  'TX06113'='(TX06113) Little Elm' 'TX06115'='(TX06115) The Colony'
                  'TX06120'='(TX06120) Highland Village' 'TX06123'='(TX06123) Corinth'
                  'TX06125'='(TX06125) Double Oak' 'TX06128'='(TX06128) Hickory Creek'
                  'TX06129'='(TX06129) Roanoke' 'TX06130'='(TX06130) Marshall Creek'
                  'TX06131'='(TX06131) Trophy Club' 'TX06132'='(TX06132) Ponder'
                  'TX06139'='(TX06139) Northlake' 'TX06200'='(TX06200) Dewitt' 'TX06201'='(TX06201) Cuero'
                  'TX06203'='(TX06203) Yorktown' 'TX06300'='(TX06300) Dickens' 'TX06301'='(TX06301) Spur'
                  'TX06400'='(TX06400) Dimmit' 'TX06401'='(TX06401) Carrizo Springs'
                  'TX06500'='(TX06500) Donley' 'TX06501'='(TX06501) Clarendon' 'TX06600'='(TX06600) Duval'
                  'TX06601'='(TX06601) Benavides' 'TX06602'='(TX06602) San Diego'
                  'TX06603'='(TX06603) Freer' 'TX06700'='(TX06700) Eastland' 'TX06701'='(TX06701) Cisco'
                  'TX06702'='(TX06702) Eastland' 'TX06703'='(TX06703) Gorman' 'TX06704'='(TX06704) Ranger'
                  'TX06705'='(TX06705) Rising Star' 'TX06800'='(TX06800) Ector'
                  'TX06802'='(TX06802) Odessa' 'TX06804'='(TX06804) Univ Of Tx:Permian Basin'
                  'TX06808'='(TX06808) Isd: Ector County' 'TX06900'='(TX06900) Edwards'
                  'TX07000'='(TX07000) Ellis' 'TX07001'='(TX07001) Ennis' 'TX07002'='(TX07002) Ferris'
                  'TX07004'='(TX07004) Italy' 'TX07005'='(TX07005) Midlothian'
                  'TX07006'='(TX07006) Milford' 'TX07007'='(TX07007) Palmer' 'TX07008'='(TX07008) Red Oak'
                  'TX07010'='(TX07010) Waxahachie' 'TX07100'='(TX07100) El Paso'
                  'TX07101'='(TX07101) Anthony' 'TX07102'='(TX07102) El Paso'
                  'TX07104'='(TX07104) Univ Of Tx: El Paso'
                  'TX07111'='(TX07111) El Paso Community Colleg' 'TX07112'='(TX07112) Clint'
                  'TX07113'='(TX07113) Isd: El Paso' 'TX07114'='(TX07114) Horizon City'
                  'TX07116'='(TX07116) Socorro' 'TX07118'='(TX07118) El Paso Community Colleg'
                  'TX07122'='(TX07122) Isd: Socorro' 'TX07200'='(TX07200) Erath'
                  'TX07201'='(TX07201) Dublin' 'TX07202'='(TX07202) Stephenville'
                  'TX07204'='(TX07204) Tarleton State Universit' 'TX07300'='(TX07300) Falls'
                  'TX07302'='(TX07302) Marlin' 'TX07303'='(TX07303) Rosebud' 'TX07400'='(TX07400) Fannin'
                  'TX07401'='(TX07401) Bonham' 'TX07500'='(TX07500) Fayette'
                  'TX07501'='(TX07501) La Grange' 'TX07508'='(TX07508) Flatonia'
                  'TX07509'='(TX07509) Carmine' 'TX07600'='(TX07600) Fisher' 'TX07601'='(TX07601) Rotan'
                  'TX07700'='(TX07700) Floyd' 'TX07701'='(TX07701) Floydada' 'TX07702'='(TX07702) Lockney'
                  'TX07800'='(TX07800) Foard' 'TX07801'='(TX07801) Crowell' 'TX07900'='(TX07900) Fort Bend'
                  'TX07901'='(TX07901) Missouri City' 'TX07902'='(TX07902) Richmond'
                  'TX07903'='(TX07903) Rosenberg' 'TX07904'='(TX07904) Stafford'
                  'TX07905'='(TX07905) Sugar Land' 'TX07907'='(TX07907) Needville'
                  'TX07911'='(TX07911) Kendleton' 'TX07912'='(TX07912) Arcola'
                  'TX07913'='(TX07913) Meadows Place' 'TX07916'='(TX07916) Isd: Fort Bend'
                  'TX08000'='(TX08000) Franklin' 'TX08100'='(TX08100) Freestone'
                  'TX08101'='(TX08101) Fairfield' 'TX08102'='(TX08102) Teague'
                  'TX08103'='(TX08103) Wortham' 'TX08200'='(TX08200) Frio' 'TX08201'='(TX08201) Pearsall'
                  'TX08203'='(TX08203) Dilley' 'TX08300'='(TX08300) Gaines' 'TX08301'='(TX08301) Seagraves'
                  'TX08302'='(TX08302) Seminole' 'TX08400'='(TX08400) Galveston'
                  'TX08402'='(TX08402) Dickinson' 'TX08403'='(TX08403) Friendswood'
                  'TX08404'='(TX08404) Galveston' 'TX08405'='(TX08405) Hitchcock'
                  'TX08406'='(TX08406) Kemah' 'TX08407'='(TX08407) La Marque'
                  'TX08408'='(TX08408) League City' 'TX08409'='(TX08409) Texas City'
                  'TX08410'='(TX08410) Univ Of Tx:Medical Branc'
                  'TX08412'='(TX08412) Tx A&m Un: Galveston' 'TX08419'='(TX08419) Jamaica Beach'
                  'TX08420'='(TX08420) Crystal Beach' 'TX08421'='(TX08421) Santa Fe'
                  'TX08422'='(TX08422) Bayou Vista' 'TX08423'='(TX08423) College Of The Mainland'
                  'TX08500'='(TX08500) Garza' 'TX08501'='(TX08501) Post' 'TX08600'='(TX08600) Gillespie'
                  'TX08601'='(TX08601) Fredericksburg' 'TX08700'='(TX08700) Glasscock'
                  'TX08800'='(TX08800) Goliad' 'TX08805'='(TX08805) Goliad' 'TX08900'='(TX08900) Gonzales'
                  'TX08901'='(TX08901) Gonzales' 'TX08904'='(TX08904) Waelder' 'TX09000'='(TX09000) Gray'
                  'TX09002'='(TX09002) Pampa' 'TX09100'='(TX09100) Grayson'
                  'TX09101'='(TX09101) Collinsville' 'TX09102'='(TX09102) Denison'
                  'TX09103'='(TX09103) Pottsboro' 'TX09104'='(TX09104) Sherman'
                  'TX09105'='(TX09105) Van Alstyne' 'TX09106'='(TX09106) Whitesboro'
                  'TX09110'='(TX09110) Howe' 'TX09118'='(TX09118) Grayson County College'
                  'TX09119'='(TX09119) Austin College' 'TX09121'='(TX09121) Tioga'
                  'TX09200'='(TX09200) Gregg' 'TX09202'='(TX09202) Gladewater'
                  'TX09204'='(TX09204) Kilgore' 'TX09205'='(TX09205) Longview'
                  'TX09206'='(TX09206) White Oak' 'TX09300'='(TX09300) Grimes'
                  'TX09301'='(TX09301) Navasota' 'TX09400'='(TX09400) Guadalupe'
                  'TX09401'='(TX09401) Marion' 'TX09402'='(TX09402) Schertz' 'TX09403'='(TX09403) Seguin'
                  'TX09406'='(TX09406) Cibolo' 'TX09500'='(TX09500) Hale' 'TX09501'='(TX09501) Abernathy'
                  'TX09502'='(TX09502) Hale Center' 'TX09504'='(TX09504) Plainview'
                  'TX09600'='(TX09600) Hall' 'TX09601'='(TX09601) Memphis' 'TX09700'='(TX09700) Hamilton'
                  'TX09701'='(TX09701) Hamilton' 'TX09702'='(TX09702) Hico' 'TX09800'='(TX09800) Hansford'
                  'TX09801'='(TX09801) Gruver' 'TX09802'='(TX09802) Spearman'
                  'TX09900'='(TX09900) Hardeman' 'TX09901'='(TX09901) Chillicothe'
                  'TX09902'='(TX09902) Quanah' 'TX10000'='(TX10000) Hardin' 'TX10001'='(TX10001) Kountze'
                  'TX10002'='(TX10002) Silsbee' 'TX10003'='(TX10003) Sour Lake'
                  'TX10009'='(TX10009) Lumberton' 'TX10100'='(TX10100) Harris'
                  'TX10101'='(TX10101) Baytown' 'TX10102'='(TX10102) Bellaire'
                  'TX10104'='(TX10104) Deer Park' 'TX10105'='(TX10105) El Lago'
                  'TX10106'='(TX10106) Galena Park' 'TX10109'='(TX10109) Humble'
                  'TX10111'='(TX10111) Jacinto City' 'TX10112'='(TX10112) Jersey Village'
                  'TX10113'='(TX10113) La Porte' 'TX10115'='(TX10115) Pasadena'
                  'TX10117'='(TX10117) Seabrook' 'TX10119'='(TX10119) South Houston'
                  'TX10120'='(TX10120) Southside Place' 'TX10121'='(TX10121) Spring Valley'
                  'TX10122'='(TX10122) Taylor Lake Village' 'TX10123'='(TX10123) Tomball'
                  'TX10124'='(TX10124) Memorial Villages' 'TX10125'='(TX10125) Webster'
                  'TX10126'='(TX10126) West University Place' 'TX10127'='(TX10127) Katy'
                  'TX10128'='(TX10128) Nassau Bay' 'TX10129'='(TX10129) Univ Of Tx: Houston'
                  'TX10132'='(TX10132) Un Of Houston:Central Ca'
                  'TX10133'='(TX10133) Texas Southern Universit'
                  'TX10138'='(TX10138) Rice University'
                  'TX10139'='(TX10139) Un Of Houston: Clearlake'
                  'TX10141'='(TX10141) Hedwig Village'
                  'TX10142'='(TX10142) Un Of Houston:Downtown C'
                  'TX10154'='(TX10154) houston Comm College'
                  'TX10157'='(TX10157) Houston Metro Transit A'
                  'TX10158'='(TX10158) texas Medical Center'
                  'TX10159'='(TX10159) N harris/Montg Comm Coll' 'TX10160'='(TX10160) Isd: Klein'
                  'TX10161'='(TX10161) Houston Baptist Univ' 'TX10166'='(TX10166) Lakeview'
                  'TX10167'='(TX10167) Isd: Katy' 'TX10170'='(TX10170) Isd: Spring Branch'
                  'TX10171'='(TX10171) Isd: Spring' 'TX10172'='(TX10172) Isd: Pasadena'
                  'TX10173'='(TX10173) Isd: Aldine' 'TX10176'='(TX10176) St. Thomas University'
                  'TX10178'='(TX10178) Isd: Humble' 'TX10200'='(TX10200) Harrison'
                  'TX10201'='(TX10201) Hallsville' 'TX10202'='(TX10202) Marshall'
                  'TX10212'='(TX10212) Tx St Tech Coll:Marshall' 'TX10300'='(TX10300) Hartley'
                  'TX10400'='(TX10400) Haskell' 'TX10401'='(TX10401) Haskell' 'TX10402'='(TX10402) Rule'
                  'TX10500'='(TX10500) Hays' 'TX10501'='(TX10501) San Marcos'
                  'TX10503'='(TX10503) Tx St Univ, San Marcos' 'TX10507'='(TX10507) Kyle'
                  'TX10600'='(TX10600) Hemphill' 'TX10601'='(TX10601) Canadian'
                  'TX10700'='(TX10700) Henderson' 'TX10701'='(TX10701) Athens'
                  'TX10702'='(TX10702) Malakoff' 'TX10705'='(TX10705) Seven Points'
                  'TX10707'='(TX10707) Gun Barrel City' 'TX10708'='(TX10708) Berryville'
                  'TX10709'='(TX10709) Caney City' 'TX10710'='(TX10710) Tool'
                  'TX10719'='(TX10719) Coffee City' 'TX10723'='(TX10723) Isd: Athens'
                  'TX10800'='(TX10800) Hidalgo' 'TX10801'='(TX10801) Alamo' 'TX10802'='(TX10802) Donna'
                  'TX10803'='(TX10803) Edcouch' 'TX10804'='(TX10804) Edinburg' 'TX10805'='(TX10805) Elsa'
                  'TX10806'='(TX10806) Hidalgo' 'TX10807'='(TX10807) La Villa'
                  'TX10808'='(TX10808) Mcallen' 'TX10809'='(TX10809) Mercedes'
                  'TX10810'='(TX10810) Mission' 'TX10811'='(TX10811) Pharr' 'TX10813'='(TX10813) San Juan'
                  'TX10814'='(TX10814) Weslaco' 'TX10815'='(TX10815) La Joya'
                  'TX10817'='(TX10817) Univ Of Tx: Pan American' 'TX10823'='(TX10823) Alton'
                  'TX10824'='(TX10824) Progreso' 'TX10829'='(TX10829) Isd: Weslaco'
                  'TX10830'='(TX10830) Penitas' 'TX10832'='(TX10832) Sullivan City'
                  'TX10900'='(TX10900) Hill' 'TX10901'='(TX10901) Hillsboro' 'TX10902'='(TX10902) Hubbard'
                  'TX10903'='(TX10903) Itasca' 'TX10906'='(TX10906) Whitney'
                  'TX10909'='(TX10909) Covington' 'TX11000'='(TX11000) Hockley'
                  'TX11001'='(TX11001) Levelland' 'TX11002'='(TX11002) Ropesville'
                  'TX11004'='(TX11004) South Plains College' 'TX11005'='(TX11005) Anton'
                  'TX11006'='(TX11006) Sundown' 'TX11100'='(TX11100) Hood' 'TX11101'='(TX11101) Granbury'
                  'TX11103'='(TX11103) Tolar' 'TX11200'='(TX11200) Hopkins'
                  'TX11202'='(TX11202) Sulphur Springs' 'TX11300'='(TX11300) Houston'
                  'TX11301'='(TX11301) Crockett' 'TX11305'='(TX11305) Grapeland'
                  'TX11400'='(TX11400) Howard' 'TX11401'='(TX11401) Big Spring'
                  'TX11500'='(TX11500) Hudspeth' 'TX11600'='(TX11600) Hunt' 'TX11601'='(TX11601) Celeste'
                  'TX11602'='(TX11602) Commerce' 'TX11603'='(TX11603) Greenville'
                  'TX11606'='(TX11606) Texas A&m Univ: Commerce'
                  'TX11607'='(TX11607) Caddo Mills' 'TX11612'='(TX11612) Lone Oak'
                  'TX11613'='(TX11613) West Tawakoni' 'TX11614'='(TX11614) Quinlan'
                  'TX11616'='(TX11616) Hawk Cove' 'TX11700'='(TX11700) Hutchinson'
                  'TX11701'='(TX11701) Borger' 'TX11705'='(TX11705) Stinnett' 'TX11800'='(TX11800) Irion'
                  'TX11900'='(TX11900) Jack' 'TX11901'='(TX11901) Jacksboro' 'TX12000'='(TX12000) Jackson'
                  'TX12001'='(TX12001) Edna' 'TX12002'='(TX12002) Ganado' 'TX12100'='(TX12100) Jasper'
                  'TX12101'='(TX12101) Jasper' 'TX12102'='(TX12102) Kirbyville'
                  'TX12200'='(TX12200) Jeff Davis' 'TX12300'='(TX12300) Jefferson'
                  'TX12301'='(TX12301) Beaumont' 'TX12303'='(TX12303) Groves'
                  'TX12304'='(TX12304) Lakeview' 'TX12305'='(TX12305) Nederland'
                  'TX12306'='(TX12306) Pear Ridge' 'TX12307'='(TX12307) Port Arthur'
                  'TX12308'='(TX12308) Port Neches' 'TX12310'='(TX12310) Lamar Univ, Beaumont'
                  'TX12400'='(TX12400) Jim Hogg' 'TX12500'='(TX12500) Jim Wells'
                  'TX12501'='(TX12501) Alice' 'TX12502'='(TX12502) Premont'
                  'TX12508'='(TX12508) Orange Grove' 'TX12600'='(TX12600) Johnson'
                  'TX12601'='(TX12601) Alvarado' 'TX12602'='(TX12602) Burleson'
                  'TX12603'='(TX12603) Cleburne' 'TX12605'='(TX12605) Joshua' 'TX12606'='(TX12606) Keene'
                  'TX12613'='(TX12613) Godley' 'TX12700'='(TX12700) Jones' 'TX12701'='(TX12701) Anson'
                  'TX12702'='(TX12702) Hamlin' 'TX12704'='(TX12704) Stamford' 'TX12705'='(TX12705) Hawley'
                  'TX12800'='(TX12800) Karnes' 'TX12801'='(TX12801) Karnes City'
                  'TX12802'='(TX12802) Kenedy' 'TX12900'='(TX12900) Kaufman' 'TX12901'='(TX12901) Forney'
                  'TX12902'='(TX12902) Kaufman' 'TX12903'='(TX12903) Kemp' 'TX12905'='(TX12905) Terrell'
                  'TX12915'='(TX12915) Isd: Kaufman' 'TX13000'='(TX13000) Kendall'
                  'TX13001'='(TX13001) Boerne' 'TX13100'='(TX13100) Kenedy' 'TX13200'='(TX13200) Kent'
                  'TX13300'='(TX13300) Kerr' 'TX13301'='(TX13301) Kerrville' 'TX13305'='(TX13305) Ingram'
                  'TX13400'='(TX13400) Kimble' 'TX13401'='(TX13401) Junction' 'TX13500'='(TX13500) King'
                  'TX13600'='(TX13600) Kinney' 'TX13700'='(TX13700) Kleberg'
                  'TX13701'='(TX13701) Kingsville' 'TX13703'='(TX13703) Tx A&m Un: Kingsville'
                  'TX13800'='(TX13800) Knox' 'TX13802'='(TX13802) Knox City' 'TX13803'='(TX13803) Munday'
                  'TX13900'='(TX13900) Lamar' 'TX13902'='(TX13902) Paris'
                  'TX13904'='(TX13904) Paris Junior College' 'TX13910'='(TX13910) Reno'
                  'TX14000'='(TX14000) Lamb' 'TX14002'='(TX14002) Earth' 'TX14003'='(TX14003) Littlefield'
                  'TX14004'='(TX14004) Olton' 'TX14100'='(TX14100) Lampasas' 'TX14101'='(TX14101) Lampasas'
                  'TX14108'='(TX14108) Kempner' 'TX14200'='(TX14200) La Salle'
                  'TX14201'='(TX14201) Cotulla' 'TX14300'='(TX14300) Lavaca'
                  'TX14301'='(TX14301) Hallettsville' 'TX14303'='(TX14303) Yoakum'
                  'TX14400'='(TX14400) Lee' 'TX14401'='(TX14401) Giddings' 'TX14402'='(TX14402) Lexington'
                  'TX14500'='(TX14500) Leon' 'TX14600'='(TX14600) Liberty' 'TX14601'='(TX14601) Cleveland'
                  'TX14603'='(TX14603) Dayton' 'TX14604'='(TX14604) Liberty' 'TX14607'='(TX14607) Ames'
                  'TX14700'='(TX14700) Limestone' 'TX14702'='(TX14702) Groesbeck'
                  'TX14703'='(TX14703) Mexia' 'TX14711'='(TX14711) Isd: Mexia'
                  'TX14800'='(TX14800) Lipscomb' 'TX14900'='(TX14900) Live Oak'
                  'TX14901'='(TX14901) Three Rivers' 'TX15000'='(TX15000) Llano'
                  'TX15001'='(TX15001) Llano' 'TX15005'='(TX15005) Sunrise Beach Village'
                  'TX15100'='(TX15100) Loving' 'TX15200'='(TX15200) Lubbock' 'TX15201'='(TX15201) Idalou'
                  'TX15202'='(TX15202) Lubbock' 'TX15203'='(TX15203) Shallowater'
                  'TX15204'='(TX15204) Slaton' 'TX15206'='(TX15206) Tx Tech Un: Lubbock'
                  'TX15208'='(TX15208) Wolfforth' 'TX15211'='(TX15211) Ransom Canyon'
                  'TX15212'='(TX15212) Tx Tech Un:Health Sci Ct'
                  'TX15213'='(TX15213) Buffalo Springs Lake' 'TX15215'='(TX15215) New Deal'
                  'TX15300'='(TX15300) Lynn' 'TX15302'='(TX15302) Tahoka' 'TX15305'='(TX15305) Odonnell'
                  'TX15400'='(TX15400) Mcculloch' 'TX15401'='(TX15401) Brady'
                  'TX15500'='(TX15500) Mclennan' 'TX15501'='(TX15501) Bellmead'
                  'TX15502'='(TX15502) Beverly Hills' 'TX15504'='(TX15504) Hewitt'
                  'TX15505'='(TX15505) Lacy-Lakeview' 'TX15506'='(TX15506) Lorena'
                  'TX15507'='(TX15507) Mcgregor' 'TX15508'='(TX15508) Mart'
                  'TX15510'='(TX15510) Northcrest' 'TX15511'='(TX15511) Robinson'
                  'TX15512'='(TX15512) Waco' 'TX15513'='(TX15513) West' 'TX15514'='(TX15514) Woodway'
                  'TX15516'='(TX15516) Mclennan Community Colle' 'TX15517'='(TX15517) Riesel'
                  'TX15518'='(TX15518) Tx St Tech Coll: Waco'
                  'TX15525'='(TX15525) Baylor University: Waco'
                  'TX15526'='(TX15526) Bruceville-Eddy' 'TX15600'='(TX15600) Mcmullen'
                  'TX15700'='(TX15700) Madison' 'TX15701'='(TX15701) Madisonville'
                  'TX15800'='(TX15800) Marion' 'TX15801'='(TX15801) Jefferson' 'TX15900'='(TX15900) Martin'
                  'TX15901'='(TX15901) Stanton' 'TX16000'='(TX16000) Mason' 'TX16100'='(TX16100) Matagorda'
                  'TX16101'='(TX16101) Bay City' 'TX16102'='(TX16102) Palacios'
                  'TX16109'='(TX16109) Isd: Bay City' 'TX16200'='(TX16200) Maverick'
                  'TX16201'='(TX16201) Eagle Pass' 'TX16300'='(TX16300) Medina'
                  'TX16301'='(TX16301) Castroville' 'TX16302'='(TX16302) Devine'
                  'TX16303'='(TX16303) Hondo' 'TX16400'='(TX16400) Menard' 'TX16500'='(TX16500) Midland'
                  'TX16501'='(TX16501) Midland' 'TX16503'='(TX16503) Isd: Midland'
                  'TX16600'='(TX16600) Milam' 'TX16601'='(TX16601) Cameron' 'TX16602'='(TX16602) Rockdale'
                  'TX16603'='(TX16603) Thorndale' 'TX16700'='(TX16700) Mills'
                  'TX16800'='(TX16800) Mitchell' 'TX16801'='(TX16801) Colorado City'
                  'TX16900'='(TX16900) Montague' 'TX16901'='(TX16901) Bowie' 'TX16902'='(TX16902) Nocona'
                  'TX16903'='(TX16903) St. Jo' 'TX17000'='(TX17000) Montgomery'
                  'TX17001'='(TX17001) Conroe' 'TX17007'='(TX17007) Roman Forest'
                  'TX17008'='(TX17008) Patton Village' 'TX17010'='(TX17010) Magnolia'
                  'TX17012'='(TX17012) Shenandoah' 'TX17014'='(TX17014) Willis'
                  'TX17016'='(TX17016) Oak Ridge North' 'TX17017'='(TX17017) Montgomery'
                  'TX17020'='(TX17020) Isd: Conroe' 'TX17100'='(TX17100) Moore' 'TX17101'='(TX17101) Dumas'
                  'TX17200'='(TX17200) Morris' 'TX17201'='(TX17201) Daingerfield'
                  'TX17202'='(TX17202) Lone Star' 'TX17204'='(TX17204) Constable'
                  'TX17205'='(TX17205) Naples' 'TX17300'='(TX17300) Motley'
                  'TX17400'='(TX17400) Nacogdoches' 'TX17402'='(TX17402) Nacogdoches'
                  'TX17404'='(TX17404) Stephen F. austin St Uni' 'TX17500'='(TX17500) Navarro'
                  'TX17501'='(TX17501) Corsicana' 'TX17600'='(TX17600) Newton' 'TX17700'='(TX17700) Nolan'
                  'TX17702'='(TX17702) Roscoe' 'TX17703'='(TX17703) Sweetwater'
                  'TX17800'='(TX17800) Nueces' 'TX17801'='(TX17801) Bishop'
                  'TX17802'='(TX17802) Corpus Christi' 'TX17803'='(TX17803) Robstown'
                  'TX17805'='(TX17805) Port Aransas'
                  'TX17815'='(TX17815) Tx A&m Un:Corpus Christi'
                  'TX17816'='(TX17816) Isd: Corpus Christi' 'TX17817'='(TX17817) Driscoll'
                  'TX17900'='(TX17900) Ochiltree' 'TX17901'='(TX17901) Perryton'
                  'TX18000'='(TX18000) Oldham' 'TX18100'='(TX18100) Orange'
                  'TX18101'='(TX18101) Bridge City' 'TX18102'='(TX18102) Orange'
                  'TX18103'='(TX18103) Pinehurst' 'TX18104'='(TX18104) Vidor'
                  'TX18105'='(TX18105) West Orange' 'TX18108'='(TX18108) Rose City'
                  'TX18200'='(TX18200) Palo Pinto' 'TX18202'='(TX18202) Mineral Wells'
                  'TX18300'='(TX18300) Panola' 'TX18301'='(TX18301) Carthage' 'TX18400'='(TX18400) Parker'
                  'TX18401'='(TX18401) Weatherford' 'TX18403'='(TX18403) Springtown'
                  'TX18404'='(TX18404) Hudson Oaks' 'TX18405'='(TX18405) Willow Park'
                  'TX18500'='(TX18500) Parmer' 'TX18501'='(TX18501) Bovina' 'TX18502'='(TX18502) Friona'
                  'TX18503'='(TX18503) Farwell' 'TX18600'='(TX18600) Pecos'
                  'TX18601'='(TX18601) Fort Stockton' 'TX18700'='(TX18700) Polk'
                  'TX18702'='(TX18702) Livingston' 'TX18704'='(TX18704) Corrigan'
                  'TX18708'='(TX18708) Onalaska' 'TX18800'='(TX18800) Potter'
                  'TX18801'='(TX18801) Amarillo' 'TX18802'='(TX18802) Amarillo College'
                  'TX18804'='(TX18804) Tx St Tech Coll:Amarillo'
                  'TX18806'='(TX18806) Amarillo Inter Airport' 'TX18900'='(TX18900) Presidio'
                  'TX18901'='(TX18901) Marfa' 'TX18906'='(TX18906) Presidio' 'TX19000'='(TX19000) Rains'
                  'TX19100'='(TX19100) Randall' 'TX19101'='(TX19101) Canyon'
                  'TX19103'='(TX19103) West Tx A&m University' 'TX19200'='(TX19200) Reagan'
                  'TX19201'='(TX19201) Big Lake' 'TX19300'='(TX19300) Real' 'TX19400'='(TX19400) Red River'
                  'TX19401'='(TX19401) Clarksville' 'TX19403'='(TX19403) Bogata'
                  'TX19500'='(TX19500) Reeves' 'TX19502'='(TX19502) Pecos' 'TX19600'='(TX19600) Refugio'
                  'TX19601'='(TX19601) Refugio' 'TX19700'='(TX19700) Roberts'
                  'TX19800'='(TX19800) Robertson' 'TX19801'='(TX19801) Bremond'
                  'TX19802'='(TX19802) Calvert' 'TX19803'='(TX19803) Hearne' 'TX19900'='(TX19900) Rockwall'
                  'TX19901'='(TX19901) Rockwall' 'TX19902'='(TX19902) Royse City'
                  'TX19903'='(TX19903) Heath' 'TX20000'='(TX20000) Runnels' 'TX20001'='(TX20001) Ballinger'
                  'TX20003'='(TX20003) Winters' 'TX20100'='(TX20100) Rusk' 'TX20101'='(TX20101) Henderson'
                  'TX20103'='(TX20103) Overton' 'TX20111'='(TX20111) Tatum' 'TX20200'='(TX20200) Sabine'
                  'TX20201'='(TX20201) Hemphill' 'TX20202'='(TX20202) Pineland'
                  'TX20300'='(TX20300) San Augustine' 'TX20301'='(TX20301) San Augustine'
                  'TX20400'='(TX20400) San Jacinto' 'TX20500'='(TX20500) San Patricio'
                  'TX20501'='(TX20501) Ingleside' 'TX20502'='(TX20502) Mathis'
                  'TX20503'='(TX20503) Portland' 'TX20504'='(TX20504) Sinton' 'TX20505'='(TX20505) Taft'
                  'TX20508'='(TX20508) Gregory' 'TX20516'='(TX20516) Isd: Taft'
                  'TX20600'='(TX20600) San Saba' 'TX20601'='(TX20601) San Saba'
                  'TX20700'='(TX20700) Schleicher' 'TX20800'='(TX20800) Scurry'
                  'TX20801'='(TX20801) Snyder' 'TX20806'='(TX20806) Western Texas College'
                  'TX20900'='(TX20900) Shackelford' 'TX20901'='(TX20901) Albany'
                  'TX21000'='(TX21000) Shelby' 'TX21001'='(TX21001) Center' 'TX21100'='(TX21100) Sherman'
                  'TX21101'='(TX21101) Stratford' 'TX21200'='(TX21200) Smith' 'TX21201'='(TX21201) Arp'
                  'TX21202'='(TX21202) Lindale' 'TX21203'='(TX21203) Troup' 'TX21204'='(TX21204) Tyler'
                  'TX21205'='(TX21205) Whitehouse' 'TX21208'='(TX21208) Tyler Junior College'
                  'TX21209'='(TX21209) Univ Of Tx: Tyler'
                  'TX21210'='(TX21210) U of Tx:Hea Center,Tyler' 'TX21215'='(TX21215) Bullard'
                  'TX21219'='(TX21219) Isd: Tyler' 'TX21300'='(TX21300) Somervell'
                  'TX21400'='(TX21400) Starr' 'TX21402'='(TX21402) Rio Grande City'
                  'TX21403'='(TX21403) Roma' 'TX21500'='(TX21500) Stephens'
                  'TX21501'='(TX21501) Breckenridge' 'TX21600'='(TX21600) Sterling'
                  'TX21700'='(TX21700) Stonewall' 'TX21800'='(TX21800) Sutton' 'TX21801'='(TX21801) Sonora'
                  'TX21900'='(TX21900) Swisher' 'TX21902'='(TX21902) Kress' 'TX21903'='(TX21903) Tulia'
                  'TX22000'='(TX22000) Tarrant' 'TX22001'='(TX22001) Arlington' 'TX22002'='(TX22002) Azle'
                  'TX22003'='(TX22003) Bedford' 'TX22004'='(TX22004) Benbrook'
                  'TX22005'='(TX22005) Blue Mound' 'TX22006'='(TX22006) Crowley'
                  'TX22007'='(TX22007) Dalworthington Gardens' 'TX22009'='(TX22009) Euless'
                  'TX22010'='(TX22010) Everman' 'TX22011'='(TX22011) Forest Hill'
                  'TX22012'='(TX22012) Fort Worth' 'TX22013'='(TX22013) Grapevine'
                  'TX22014'='(TX22014) Haltom City' 'TX22016'='(TX22016) Hurst'
                  'TX22017'='(TX22017) Kennedale' 'TX22018'='(TX22018) Lakeside'
                  'TX22019'='(TX22019) Lake Worth' 'TX22020'='(TX22020) Mansfield'
                  'TX22021'='(TX22021) North Richland Hills' 'TX22022'='(TX22022) Richland Hills'
                  'TX22023'='(TX22023) River Oaks' 'TX22024'='(TX22024) Saginaw'
                  'TX22025'='(TX22025) Sansom Park Village' 'TX22026'='(TX22026) Watauga'
                  'TX22027'='(TX22027) Westover Hills' 'TX22028'='(TX22028) Westworth'
                  'TX22029'='(TX22029) White Settlement' 'TX22030'='(TX22030) Keller'
                  'TX22031'='(TX22031) Pantego' 'TX22032'='(TX22032) Southlake'
                  'TX22033'='(TX22033) Univ Of Tx: Arlington' 'TX22034'='(TX22034) Westworth'
                  'TX22036'='(TX22036) Dallas-Fort Worth Int Ap'
                  'TX22037'='(TX22037) Texas Christian Universi'
                  'TX22040'='(TX22040) Colleyville' 'TX22048'='(TX22048) Pelican Bay'
                  'TX22049'='(TX22049) Univ Of N tx:Health Sc C'
                  'TX22050'='(TX22050) hos Dist: Tarrant County' 'TX22100'='(TX22100) Taylor'
                  'TX22101'='(TX22101) Abilene' 'TX22103'='(TX22103) Merkel' 'TX22108'='(TX22108) Tye'
                  'TX22110'='(TX22110) Hardin-Simmons Universit'
                  'TX22111'='(TX22111) Abilene Christian Univ' 'TX22200'='(TX22200) Terrell'
                  'TX22300'='(TX22300) Terry' 'TX22301'='(TX22301) Brownfield'
                  'TX22400'='(TX22400) Throckmorton' 'TX22500'='(TX22500) Titus'
                  'TX22501'='(TX22501) Mount Pleasant' 'TX22600'='(TX22600) Tom Green'
                  'TX22601'='(TX22601) San Angelo' 'TX22603'='(TX22603) Angelo State University'
                  'TX22607'='(TX22607) San Angelo Park' 'TX22700'='(TX22700) Travis'
                  'TX22701'='(TX22701) Austin' 'TX22702'='(TX22702) Manor'
                  'TX22703'='(TX22703) Rollingwood' 'TX22704'='(TX22704) West Lake Hills'
                  'TX22705'='(TX22705) Univ Of Tx: Austin' 'TX22709'='(TX22709) Pflugerville'
                  'TX22711'='(TX22711) Lakeway' 'TX22719'='(TX22719) Sunset Valley'
                  'TX22721'='(TX22721) Lago Vista' 'TX22722'='(TX22722) Jonestown'
                  'TX22723'='(TX22723) Mustang Ridge' 'TX22724'='(TX22724) Isd: Austin'
                  'TX22800'='(TX22800) Trinity' 'TX22801'='(TX22801) Trinity' 'TX22900'='(TX22900) Tyler'
                  'TX22901'='(TX22901) Woodville' 'TX23000'='(TX23000) Upshur'
                  'TX23001'='(TX23001) Big Sandy' 'TX23002'='(TX23002) Gilmer'
                  'TX23003'='(TX23003) Ore City' 'TX23009'='(TX23009) East Mountain'
                  'TX23100'='(TX23100) Upton' 'TX23101'='(TX23101) Mccamey' 'TX23200'='(TX23200) Uvalde'
                  'TX23201'='(TX23201) Uvalde' 'TX23202'='(TX23202) Sabinal'
                  'TX23300'='(TX23300) Val Verde' 'TX23301'='(TX23301) Del Rio'
                  'TX23400'='(TX23400) Van Zandt' 'TX23401'='(TX23401) Canton'
                  'TX23402'='(TX23402) Edgewood' 'TX23403'='(TX23403) Grand Saline'
                  'TX23404'='(TX23404) Van' 'TX23405'='(TX23405) Wills Point'
                  'TX23500'='(TX23500) Victoria' 'TX23501'='(TX23501) Victoria'
                  'TX23600'='(TX23600) Walker' 'TX23601'='(TX23601) Huntsville'
                  'TX23700'='(TX23700) Waller' 'TX23701'='(TX23701) Brookshire'
                  'TX23702'='(TX23702) Waller' 'TX23707'='(TX23707) Hempstead'
                  'TX23709'='(TX23709) Prairie View A&m Univ'
                  'TX23710'='(TX23710) Isd: Hempstead' 'TX23800'='(TX23800) Ward'
                  'TX23801'='(TX23801) Monahans' 'TX23900'='(TX23900) Washington'
                  'TX23901'='(TX23901) Brenham' 'TX24000'='(TX24000) Webb' 'TX24001'='(TX24001) Laredo'
                  'TX24005'='(TX24005) Laredo Community College'
                  'TX24006'='(TX24006) Tx A&m International Un' 'TX24007'='(TX24007) Isd: United'
                  'TX24011'='(TX24011) Isd: Laredo' 'TX24100'='(TX24100) Wharton'
                  'TX24101'='(TX24101) El Campo' 'TX24102'='(TX24102) Wharton'
                  'TX24200'='(TX24200) Wheeler' 'TX24201'='(TX24201) Shamrock'
                  'TX24300'='(TX24300) Wichita' 'TX24301'='(TX24301) Burkburnett'
                  'TX24302'='(TX24302) Electra' 'TX24304'='(TX24304) Iowa Park'
                  'TX24305'='(TX24305) Wichita Falls'
                  'TX24307'='(TX24307) Midwestern State Univers' 'TX24400'='(TX24400) Wilbarger'
                  'TX24401'='(TX24401) Vernon' 'TX24500'='(TX24500) Willacy' 'TX24501'='(TX24501) Lyford'
                  'TX24502'='(TX24502) Raymondville' 'TX24509'='(TX24509) Isd: Raymondville'
                  'TX24600'='(TX24600) Williamson' 'TX24601'='(TX24601) Florence'
                  'TX24602'='(TX24602) Georgetown' 'TX24603'='(TX24603) Granger'
                  'TX24604'='(TX24604) Hutto' 'TX24605'='(TX24605) Round Rock' 'TX24606'='(TX24606) Taylor'
                  'TX24608'='(TX24608) Southwestern University' 'TX24609'='(TX24609) Cedar Park'
                  'TX24617'='(TX24617) Leander' 'TX24618'='(TX24618) Thrall' 'TX24700'='(TX24700) Wilson'
                  'TX24701'='(TX24701) Floresville' 'TX24702'='(TX24702) Poth'
                  'TX24707'='(TX24707) La Vernia' 'TX24800'='(TX24800) Winkler'
                  'TX24801'='(TX24801) Kermit' 'TX24802'='(TX24802) Wink' 'TX24900'='(TX24900) Wise'
                  'TX24901'='(TX24901) Bridgeport' 'TX24902'='(TX24902) Decatur'
                  'TX24908'='(TX24908) Runaway Bay' 'TX25000'='(TX25000) Wood'
                  'TX25002'='(TX25002) Hawkins' 'TX25003'='(TX25003) Mineola' 'TX25004'='(TX25004) Quitman'
                  'TX25005'='(TX25005) Winnsboro' 'TX25100'='(TX25100) Yoakum'
                  'TX25101'='(TX25101) Denver City' 'TX25200'='(TX25200) Young'
                  'TX25201'='(TX25201) Graham' 'TX25202'='(TX25202) Olney' 'TX25300'='(TX25300) Zapata'
                  'TX25400'='(TX25400) Zavala' 'TX25401'='(TX25401) Crystal City'
                  'TXDPD00'='(TXDPD00) Dallas' 'TXHPD00'='(TXHPD00) Houston'
                  'TXSPD00'='(TXSPD00) San Antonio' 'UT00100'='(UT00100) Beaver'
                  'UT00101'='(UT00101) Beaver' 'UT00102'='(UT00102) Milford'
                  'UT00103'='(UT00103) Minersville' 'UT00200'='(UT00200) Box Elder'
                  'UT00201'='(UT00201) Brigham City' 'UT00202'='(UT00202) Tremonton'
                  'UT00205'='(UT00205) Garland' 'UT00207'='(UT00207) Mantua' 'UT00208'='(UT00208) Willard'
                  'UT00212'='(UT00212) Perry' 'UT00300'='(UT00300) Cache' 'UT00301'='(UT00301) Logan'
                  'UT00303'='(UT00303) Hyde Park' 'UT00304'='(UT00304) Hyrum'
                  'UT00310'='(UT00310) North Park' 'UT00314'='(UT00314) Smithfield'
                  'UT00315'='(UT00315) Wellsville' 'UT00316'='(UT00316) Utah State University'
                  'UT00320'='(UT00320) Cache-Rich Drug Task For' 'UT00400'='(UT00400) Carbon'
                  'UT00401'='(UT00401) Price' 'UT00403'='(UT00403) Helper' 'UT00407'='(UT00407) Wellington'
                  'UT00409'='(UT00409) East Carbon' 'UT00413'='(UT00413) College Of Eastern Utah'
                  'UT00500'='(UT00500) Daggett' 'UT00600'='(UT00600) Davis' 'UT00601'='(UT00601) Bountiful'
                  'UT00602'='(UT00602) Clearfield' 'UT00603'='(UT00603) Layton'
                  'UT00604'='(UT00604) Centerville' 'UT00605'='(UT00605) Farmington'
                  'UT00606'='(UT00606) Kaysville' 'UT00607'='(UT00607) North Salt Lake'
                  'UT00608'='(UT00608) Sunset' 'UT00609'='(UT00609) West Bountiful'
                  'UT00610'='(UT00610) Woods Cross' 'UT00611'='(UT00611) Clinton'
                  'UT00612'='(UT00612) Syracuse' 'UT00613'='(UT00613) East Layton'
                  'UT00614'='(UT00614) Davis Metro Narcotics Sf' 'UT00700'='(UT00700) Duchesne'
                  'UT00701'='(UT00701) Duchesne' 'UT00702'='(UT00702) Roosevelt'
                  'UT00800'='(UT00800) Emery' 'UT00900'='(UT00900) Garfield'
                  'UT00903'='(UT00903) Panguitch' 'UT01000'='(UT01000) Grand' 'UT01001'='(UT01001) Moab'
                  'UT01100'='(UT01100) Iron' 'UT01101'='(UT01101) Cedar City' 'UT01103'='(UT01103) Parowan'
                  'UT01104'='(UT01104) Southern Utah University' 'UT01106'='(UT01106) Brian Head'
                  'UT01200'='(UT01200) Juab' 'UT01201'='(UT01201) Nephi' 'UT01202'='(UT01202) Eureka'
                  'UT01300'='(UT01300) Kane' 'UT01302'='(UT01302) Kanab' 'UT01305'='(UT01305) Big Water'
                  'UT01400'='(UT01400) Millard' 'UT01401'='(UT01401) Delta' 'UT01402'='(UT01402) Fillmore'
                  'UT01500'='(UT01500) Morgan' 'UT01501'='(UT01501) Morgan' 'UT01600'='(UT01600) Piute'
                  'UT01700'='(UT01700) Rich' 'UT01800'='(UT01800) Salt Lake' 'UT01801'='(UT01801) Midvale'
                  'UT01802'='(UT01802) Murray' 'UT01803'='(UT01803) Salt Lake City'
                  'UT01804'='(UT01804) South Salt Lake' 'UT01805'='(UT01805) Sandy'
                  'UT01806'='(UT01806) West Jordan' 'UT01807'='(UT01807) University Of Utah'
                  'UT01812'='(UT01812) Draper' 'UT01817'='(UT01817) Riverton'
                  'UT01818'='(UT01818) South Jordan' 'UT01819'='(UT01819) Bluffdale'
                  'UT01821'='(UT01821) Alta' 'UT01823'='(UT01823) Salt Lake Community Coll'
                  'UT01824'='(UT01824) Dignitary Protection' 'UT01825'='(UT01825) West Valley'
                  'UT01828'='(UT01828) Granite School District'
                  'UT01839'='(UT01839) Taylorsville City' 'UT01900'='(UT01900) San Juan'
                  'UT01901'='(UT01901) Blanding' 'UT01902'='(UT01902) Monticello'
                  'UT02000'='(UT02000) Sanpete' 'UT02002'='(UT02002) Ephraim'
                  'UT02003'='(UT02003) Fairview' 'UT02005'='(UT02005) Gunnison' 'UT02006'='(UT02006) Manti'
                  'UT02008'='(UT02008) Moroni' 'UT02009'='(UT02009) Mount Pleasant'
                  'UT02100'='(UT02100) Sevier' 'UT02101'='(UT02101) Richfield' 'UT02107'='(UT02107) Salina'
                  'UT02200'='(UT02200) Summit' 'UT02201'='(UT02201) Coalville' 'UT02203'='(UT02203) Kamas'
                  'UT02205'='(UT02205) Park City' 'UT02300'='(UT02300) Tooele' 'UT02301'='(UT02301) Tooele'
                  'UT02302'='(UT02302) Grantsville' 'UT02303'='(UT02303) Wendover'
                  'UT02305'='(UT02305) Stockton' 'UT02400'='(UT02400) Uintah' 'UT02401'='(UT02401) Vernal'
                  'UT02403'='(UT02403) Naples' 'UT02500'='(UT02500) Utah'
                  'UT02501'='(UT02501) American Fork' 'UT02502'='(UT02502) Lehi' 'UT02503'='(UT02503) Orem'
                  'UT02504'='(UT02504) Payson' 'UT02505'='(UT02505) Pleasant Grove/Lindon'
                  'UT02506'='(UT02506) Provo' 'UT02507'='(UT02507) Spanish Fork'
                  'UT02508'='(UT02508) Springville' 'UT02509'='(UT02509) Alpine/Highland'
                  'UT02510'='(UT02510) Salem' 'UT02511'='(UT02511) Santaquin/Genola'
                  'UT02512'='(UT02512) Brigham Young University' 'UT02513'='(UT02513) Lindon'
                  'UT02514'='(UT02514) Mapleton' 'UT02516'='(UT02516) Genola'
                  'UT02519'='(UT02519) Utah Valley State Colleg'
                  'UT02520'='(UT02520) Ut Co Major Crime Task F'
                  'UT02521'='(UT02521) ut Cnty Attrny Invst Div'
                  'UT025UN'='(UT025UN) Brigham Young University' 'UT02600'='(UT02600) Wasatch'
                  'UT02601'='(UT02601) Heber' 'UT02602'='(UT02602) Midway'
                  'UT02603'='(UT02603) Soldier Summit' 'UT02700'='(UT02700) Washington'
                  'UT02701'='(UT02701) St. George' 'UT02703'='(UT02703) Hurricane'
                  'UT02707'='(UT02707) La Verkin' 'UT02708'='(UT02708) Leeds'
                  'UT02710'='(UT02710) Washington' 'UT02712'='(UT02712) Hildale'
                  'UT02715'='(UT02715) Ivins' 'UT02800'='(UT02800) Wayne' 'UT02900'='(UT02900) Weber'
                  'UT02901'='(UT02901) Ogden' 'UT02902'='(UT02902) Roy' 'UT02903'='(UT02903) South Ogden'
                  'UT02904'='(UT02904) Washington Terrace' 'UT02905'='(UT02905) North Ogden'
                  'UT02906'='(UT02906) Riverdale' 'UT02907'='(UT02907) Weber State University'
                  'UT02908'='(UT02908) Harrisville' 'UT02909'='(UT02909) Huntsville'
                  'UT02910'='(UT02910) Plain City' 'UT02911'='(UT02911) Pleasant View'
                  'UT02914'='(UT02914) Uintah' 'UTBCI00'='(UTBCI00) Ut Bureau Of Crim Ident'
                  'UTLED01'='(UTLED01) Wildlife Resources'
                  'UTLED02'='(UTLED02) Parks And Recreation'
                  'UTUHP00'='(UTUHP00) Utah Highway Patrol' 'VA00100'='(VA00100) Accomack'
                  'VA00101'='(VA00101) Chincoteague' 'VA00102'='(VA00102) Onancock'
                  'VA00103'='(VA00103) Parksley' 'VA00105'='(VA00105) Onley'
                  'VA001SP'='(VA001SP) Sp: Accomack County' 'VA00200'='(VA00200) Albemarle'
                  'VA00201'='(VA00201) University Of Virginia'
                  'VA00203'='(VA00203) Albemarle County Pol Dep'
                  'VA002SP'='(VA002SP) Sp: Albemarle County' 'VA00300'='(VA00300) Alleghany'
                  'VA00301'='(VA00301) Iron Gate' 'VA003SP'='(VA003SP) Sp: Alleghany County'
                  'VA00400'='(VA00400) Amelia' 'VA004SP'='(VA004SP) Sp: Amelia County'
                  'VA00500'='(VA00500) Amherst' 'VA00501'='(VA00501) Amherst'
                  'VA00502'='(VA00502) Central Va Training Cent'
                  'VA005SP'='(VA005SP) Sp: Amherst County' 'VA00600'='(VA00600) Appomattox'
                  'VA00601'='(VA00601) Appomattox' 'VA006SP'='(VA006SP) Sp: Appomattox County'
                  'VA00701'='(VA00701) Arlington County Pd'
                  'VA00799'='(VA00799) Pentagon Bombing 9/11/01'
                  'VA007SP'='(VA007SP) Sp: Arlington County' 'VA00800'='(VA00800) Augusta'
                  'VA008SP'='(VA008SP) Sp: Augusta County' 'VA00900'='(VA00900) Bath'
                  'VA00902'='(VA00902) Special Police' 'VA009SP'='(VA009SP) Sp: Bath County'
                  'VA01000'='(VA01000) Bedford' 'VA01001'='(VA01001) Bedford'
                  'VA010S1'='(VA010S1) Sp: Bedford' 'VA010SP'='(VA010SP) Sp: Bedford County'
                  'VA01100'='(VA01100) Bland' 'VA011SP'='(VA011SP) Sp: Bland County'
                  'VA01200'='(VA01200) Botetourt' 'VA01201'='(VA01201) Buchanan'
                  'VA012SP'='(VA012SP) Sp: Botetourt County' 'VA01300'='(VA01300) Brunswick'
                  'VA01301'='(VA01301) Lawrenceville' 'VA013SP'='(VA013SP) Sp: Brunswick County'
                  'VA01400'='(VA01400) Buchanan' 'VA01401'='(VA01401) Grundy'
                  'VA014SP'='(VA014SP) Sp: Buchanan County' 'VA01500'='(VA01500) Buckingham'
                  'VA015SP'='(VA015SP) Sp: Buckingham County' 'VA01600'='(VA01600) Campbell'
                  'VA01601'='(VA01601) Altavista' 'VA01602'='(VA01602) Brookneal'
                  'VA016SP'='(VA016SP) Sp: Campbell County' 'VA01700'='(VA01700) Caroline'
                  'VA01701'='(VA01701) Bowling Green' 'VA017SP'='(VA017SP) Sp: Caroline County'
                  'VA01800'='(VA01800) Carroll' 'VA01801'='(VA01801) Hillsville'
                  'VA018SP'='(VA018SP) Sp: Carroll County' 'VA01900'='(VA01900) Charles City'
                  'VA019SP'='(VA019SP) Sp: Charles City County' 'VA02000'='(VA02000) Charlotte'
                  'VA020SP'='(VA020SP) Sp: Charlotte County' 'VA02100'='(VA02100) Chesterfield'
                  'VA02101'='(VA02101) Chesterfield County Pd'
                  'VA021SP'='(VA021SP) Sp: Chesterfield County' 'VA02200'='(VA02200) Clarke'
                  'VA02201'='(VA02201) Berryville' 'VA022SP'='(VA022SP) Sp: Clarke County'
                  'VA02300'='(VA02300) Craig' 'VA023SP'='(VA023SP) Sp: Craig County'
                  'VA02400'='(VA02400) Culpeper' 'VA02401'='(VA02401) Culpeper'
                  'VA024SP'='(VA024SP) Sp: Culpeper County' 'VA02500'='(VA02500) Cumberland'
                  'VA025SP'='(VA025SP) Sp: Cumberland County' 'VA02600'='(VA02600) Dickenson'
                  'VA02601'='(VA02601) Clintwood' 'VA02602'='(VA02602) Haysi'
                  'VA02603'='(VA02603) Clinchco' 'VA026SP'='(VA026SP) Sp: Dickenson County'
                  'VA02700'='(VA02700) Dinwiddie' 'VA02702'='(VA02702) Mckenney'
                  'VA027SP'='(VA027SP) Sp: Dinwiddie County' 'VA02800'='(VA02800) Essex'
                  'VA02802'='(VA02802) Tappahannock' 'VA028SP'='(VA028SP) Sp: Essex County'
                  'VA02900'='(VA02900) Fairfax' 'VA02901'='(VA02901) Fairfax County Pd'
                  'VA02902'='(VA02902) Herndon' 'VA02903'='(VA02903) Vienna'
                  'VA02904'='(VA02904) George Mason University'
                  'VA02905'='(VA02905) Northern Va Comm College'
                  'VA029SP'='(VA029SP) Sp: Fairfax County' 'VA03000'='(VA03000) Fauquier'
                  'VA03002'='(VA03002) Warrenton' 'VA030SP'='(VA030SP) Sp: Fauquier County'
                  'VA03100'='(VA03100) Floyd' 'VA03101'='(VA03101) Floyd'
                  'VA031SP'='(VA031SP) Sp: Floyd County' 'VA03200'='(VA03200) Fluvanna'
                  'VA032SP'='(VA032SP) Sp: Fluvanna County' 'VA03300'='(VA03300) Franklin'
                  'VA03301'='(VA03301) Rocky Mount' 'VA03303'='(VA03303) Ferrum College'
                  'VA033SP'='(VA033SP) Sp: Franklin County' 'VA03400'='(VA03400) Frederick'
                  'VA03401'='(VA03401) Middletown' 'VA03402'='(VA03402) Stephens City'
                  'VA034SP'='(VA034SP) Sp: Frederick County' 'VA03500'='(VA03500) Giles'
                  'VA03501'='(VA03501) Glen Lyn' 'VA03502'='(VA03502) Pearisburg'
                  'VA03503'='(VA03503) Pembroke' 'VA03504'='(VA03504) Rich Creek'
                  'VA03505'='(VA03505) Narrows' 'VA035SP'='(VA035SP) Sp: Giles County'
                  'VA03600'='(VA03600) Gloucester' 'VA036SP'='(VA036SP) Sp: Gloucester County'
                  'VA03700'='(VA03700) Goochland' 'VA037SP'='(VA037SP) Sp: Goochland County'
                  'VA03800'='(VA03800) Grayson' 'VA03801'='(VA03801) Fries'
                  'VA03802'='(VA03802) Independence' 'VA038SP'='(VA038SP) Sp: Grayson County'
                  'VA03900'='(VA03900) Greene' 'VA039SP'='(VA039SP) Sp: Greene County'
                  'VA04000'='(VA04000) Greensville' 'VA04001'='(VA04001) Emporia'
                  'VA040S1'='(VA040S1) Sp: Emporia' 'VA040SP'='(VA040SP) Sp: Greensville County'
                  'VA04100'='(VA04100) Halifax' 'VA04101'='(VA04101) Halifax'
                  'VA041SP'='(VA041SP) Sp: Halifax County' 'VA04200'='(VA04200) Hanover'
                  'VA04201'='(VA04201) Ashland' 'VA042SP'='(VA042SP) Sp: Hanover County'
                  'VA04300'='(VA04300) Henrico' 'VA04301'='(VA04301) Henrico County Police D'
                  'VA04303'='(VA04303) alcoholic Bev Control Co'
                  'VA04307'='(VA04307) J. sargeant Reynolds Cc'
                  'VA043SP'='(VA043SP) Sp: Henrico County' 'VA04400'='(VA04400) Henry'
                  'VA044SP'='(VA044SP) Sp: Henry County' 'VA04500'='(VA04500) Highland'
                  'VA045SP'='(VA045SP) Sp: Highland County' 'VA04600'='(VA04600) Isle Of Wight'
                  'VA04601'='(VA04601) Smithfield' 'VA046SP'='(VA046SP) Sp: Isle Of Wight County'
                  'VA04700'='(VA04700) James City' 'VA04701'='(VA04701) James City County Pd'
                  'VA047SP'='(VA047SP) Sp: James City County'
                  'VA04800'='(VA04800) King And Queen'
                  'VA048SP'='(VA048SP) Sp: King And Queen Cnty' 'VA04900'='(VA04900) King George'
                  'VA049SP'='(VA049SP) Sp: King George County' 'VA05000'='(VA05000) King William'
                  'VA05002'='(VA05002) West Point' 'VA050SP'='(VA050SP) Sp: King William County'
                  'VA05100'='(VA05100) Lancaster' 'VA05101'='(VA05101) Kilmarnock'
                  'VA051SP'='(VA051SP) Sp: Lancaster County' 'VA05200'='(VA05200) Lee'
                  'VA05201'='(VA05201) Jonesville' 'VA05202'='(VA05202) Pennington Gap'
                  'VA052SP'='(VA052SP) Sp: Lee County' 'VA05300'='(VA05300) Loudoun'
                  'VA05301'='(VA05301) Leesburg' 'VA05302'='(VA05302) Middleburg'
                  'VA05303'='(VA05303) Purcellville' 'VA053SP'='(VA053SP) Sp: Loudoun County'
                  'VA05400'='(VA05400) Louisa' 'VA05401'='(VA05401) Louisa' 'VA05402'='(VA05402) Mineral'
                  'VA054SP'='(VA054SP) Sp: Louisa County' 'VA05500'='(VA05500) Lunenburg'
                  'VA05501'='(VA05501) Kenbridge' 'VA05503'='(VA05503) Victoria'
                  'VA055SP'='(VA055SP) Sp: Lunenburg County' 'VA05600'='(VA05600) Madison'
                  'VA056SP'='(VA056SP) Sp: Madison County' 'VA05700'='(VA05700) Mathews'
                  'VA057SP'='(VA057SP) Sp: Mathews County' 'VA05800'='(VA05800) Mecklenburg'
                  'VA05802'='(VA05802) Chase City' 'VA05803'='(VA05803) Clarksville'
                  'VA05804'='(VA05804) La Crosse' 'VA05805'='(VA05805) South Hill'
                  'VA058SP'='(VA058SP) Sp: Mecklenburg County' 'VA05900'='(VA05900) Middlesex'
                  'VA05903'='(VA05903) Urbanna' 'VA059SP'='(VA059SP) Sp: Middlesex County'
                  'VA06000'='(VA06000) Montgomery' 'VA06001'='(VA06001) Blacksburg'
                  'VA06003'='(VA06003) Christiansburg'
                  'VA06004'='(VA06004) Va Polytech Inst & St Un'
                  'VA060SP'='(VA060SP) Sp: Montgomery County' 'VA06100'='(VA06100) Nansemond'
                  'VA06101'='(VA06101) Nansemond Police Departm'
                  'VA061SP'='(VA061SP) Nansemond State Police' 'VA06200'='(VA06200) Nelson'
                  'VA062SP'='(VA062SP) Sp: Nelson County' 'VA06300'='(VA06300) New Kent'
                  'VA063SP'='(VA063SP) Sp: New Kent County' 'VA06500'='(VA06500) Northampton'
                  'VA06501'='(VA06501) Cape Charles' 'VA06502'='(VA06502) Exmore'
                  'VA065SP'='(VA065SP) Sp: Northampton County'
                  'VA06600'='(VA06600) Northumberland'
                  'VA066SP'='(VA066SP) Sp: Northumberland Cnty' 'VA06700'='(VA06700) Nottoway'
                  'VA06701'='(VA06701) Blackstone' 'VA06702'='(VA06702) Crewe'
                  'VA06703'='(VA06703) Burkeville' 'VA067SP'='(VA067SP) Sp: Nottoway County'
                  'VA06800'='(VA06800) Orange' 'VA06801'='(VA06801) Orange'
                  'VA06802'='(VA06802) Gordonsville' 'VA068SP'='(VA068SP) Sp: Orange County'
                  'VA06900'='(VA06900) Page' 'VA06901'='(VA06901) Luray' 'VA06902'='(VA06902) Shenandoah'
                  'VA06903'='(VA06903) Stanley' 'VA069SP'='(VA069SP) Sp: Page County'
                  'VA07000'='(VA07000) Patrick' 'VA070SP'='(VA070SP) Sp: Patrick County'
                  'VA07100'='(VA07100) Pittsylvania' 'VA07101'='(VA07101) Chatham'
                  'VA07102'='(VA07102) Gretna' 'VA07103'='(VA07103) Hurt'
                  'VA071SP'='(VA071SP) Sp: Pittsylvania County' 'VA07200'='(VA07200) Powhatan'
                  'VA072SP'='(VA072SP) Sp: Powhatan County' 'VA07300'='(VA07300) Prince Edward'
                  'VA07301'='(VA07301) Farmville' 'VA07302'='(VA07302) Longwood College'
                  'VA073SP'='(VA073SP) Sp: Prince Edward County'
                  'VA07400'='(VA07400) Prince George'
                  'VA07401'='(VA07401) Prince George County Pd'
                  'VA074SP'='(VA074SP) Sp: Prince George County'
                  'VA07500'='(VA07500) Prince William' 'VA07501'='(VA07501) Manassas'
                  'VA07502'='(VA07502) Manassas Park'
                  'VA07503'='(VA07503) Prince William County Pd' 'VA07504'='(VA07504) Quantico'
                  'VA07505'='(VA07505) Haymarket' 'VA07506'='(VA07506) Dumfries'
                  'VA07507'='(VA07507) Occoquan' 'VA075S1'='(VA075S1) Sp: Manassas'
                  'VA075S2'='(VA075S2) Sp: Manassas Park'
                  'VA075SP'='(VA075SP) Sp: Prince William Cnty' 'VA07700'='(VA07700) Pulaski'
                  'VA07701'='(VA07701) Pulaski' 'VA07702'='(VA07702) Dublin'
                  'VA077SP'='(VA077SP) Sp: Pulaski County' 'VA07800'='(VA07800) Rappahannock'
                  'VA078SP'='(VA078SP) Sp: Rappahannock County' 'VA07900'='(VA07900) Richmond'
                  'VA07901'='(VA07901) Warsaw' 'VA079SP'='(VA079SP) Sp: Richmond County'
                  'VA08000'='(VA08000) Roanoke' 'VA08001'='(VA08001) Salem' 'VA08002'='(VA08002) Vinton'
                  'VA08003'='(VA08003) Roanoke County Pd' 'VA080S1'='(VA080S1) Sp: Salem'
                  'VA080SP'='(VA080SP) Sp: Roanoke County' 'VA08100'='(VA08100) Rockbridge'
                  'VA08101'='(VA08101) Glasgow' 'VA08102'='(VA08102) Lexington'
                  'VA08103'='(VA08103) Va Military Institute' 'VA081S2'='(VA081S2) Sp: Lexington'
                  'VA081SP'='(VA081SP) Sp: Rockbridge County' 'VA08200'='(VA08200) Rockingham'
                  'VA08201'='(VA08201) Bridgewater' 'VA08202'='(VA08202) Broadway'
                  'VA08203'='(VA08203) Dayton' 'VA08204'='(VA08204) Elkton' 'VA08205'='(VA08205) Grottoes'
                  'VA08206'='(VA08206) James Madison University'
                  'VA08207'='(VA08207) Timberville' 'VA082SP'='(VA082SP) Sp: Rockingham County'
                  'VA08300'='(VA08300) Russell' 'VA08301'='(VA08301) Lebanon' 'VA08302'='(VA08302) Honaker'
                  'VA08304'='(VA08304) Castlewood' 'VA083SP'='(VA083SP) Sp: Russell County'
                  'VA08400'='(VA08400) Scott' 'VA08401'='(VA08401) Gate City'
                  'VA08402'='(VA08402) Weber City' 'VA084SP'='(VA084SP) Sp: Scott County'
                  'VA08500'='(VA08500) Shenandoah' 'VA08501'='(VA08501) Edinburg'
                  'VA08502'='(VA08502) Mount Jackson' 'VA08503'='(VA08503) Woodstock'
                  'VA08504'='(VA08504) Strasburg' 'VA08505'='(VA08505) New Market'
                  'VA085SP'='(VA085SP) Sp: Shenandoah County' 'VA08600'='(VA08600) Smyth'
                  'VA08601'='(VA08601) Marion' 'VA08602'='(VA08602) Saltville'
                  'VA08603'='(VA08603) Chilhowie' 'VA086SP'='(VA086SP) Sp: Smyth County'
                  'VA08700'='(VA08700) Southampton' 'VA08701'='(VA08701) Franklin'
                  'VA08702'='(VA08702) Courtland' 'VA08703'='(VA08703) Boykins'
                  'VA087S1'='(VA087S1) Franklin State Police'
                  'VA087SP'='(VA087SP) Sp: Southampton County' 'VA08800'='(VA08800) Spotsylvania'
                  'VA088SP'='(VA088SP) Sp: Spotsylvania County' 'VA08900'='(VA08900) Stafford'
                  'VA089SP'='(VA089SP) Sp: Stafford County' 'VA09000'='(VA09000) Surry'
                  'VA090SP'='(VA090SP) Sp: Surry County' 'VA09100'='(VA09100) Sussex'
                  'VA09104'='(VA09104) Waverly' 'VA091SP'='(VA091SP) Sp: Sussex County'
                  'VA09200'='(VA09200) Tazewell' 'VA09201'='(VA09201) Bluefield'
                  'VA09202'='(VA09202) Pocahontas' 'VA09203'='(VA09203) Richlands'
                  'VA09204'='(VA09204) Tazewell' 'VA09205'='(VA09205) Cedar Bluff'
                  'VA092SP'='(VA092SP) Sp: Tazewell County' 'VA09300'='(VA09300) Warren'
                  'VA09301'='(VA09301) Front Royal' 'VA093SP'='(VA093SP) Sp: Warren County'
                  'VA09400'='(VA09400) Washington' 'VA09401'='(VA09401) Abingdon'
                  'VA09402'='(VA09402) Damascus' 'VA09403'='(VA09403) Glade Spring'
                  'VA09404'='(VA09404) Emory And Henry College'
                  'VA094SP'='(VA094SP) Sp: Washington County' 'VA09500'='(VA09500) Westmoreland'
                  'VA09501'='(VA09501) Colonial Beach'
                  'VA095SP'='(VA095SP) Sp: Westmoreland County' 'VA09600'='(VA09600) Wise'
                  'VA09601'='(VA09601) Appalachia' 'VA09602'='(VA09602) Big Stone Gap'
                  'VA09603'='(VA09603) Coeburn' 'VA09604'='(VA09604) Pound' 'VA09605'='(VA09605) St. Paul'
                  'VA09606'='(VA09606) Wise' 'VA09607'='(VA09607) Univ Of Va, Col At Wise'
                  'VA096SP'='(VA096SP) Sp: Wise County' 'VA09700'='(VA09700) Wythe'
                  'VA09701'='(VA09701) Wytheville' 'VA09702'='(VA09702) Wythe Police Department'
                  'VA09703'='(VA09703) Rural Retreat' 'VA097SP'='(VA097SP) Sp: Wythe County'
                  'VA09800'='(VA09800) York' 'VA09801'='(VA09801) Poquoson'
                  'VA098S1'='(VA098S1) Sp: Poquoson' 'VA098SP'='(VA098SP) Sp: York County'
                  'VA09900'='(VA09900) Alexandria' 'VA099SP'='(VA099SP) Sp: Alexandria'
                  'VA10000'='(VA10000) Bristol' 'VA100SP'='(VA100SP) Sp: Bristol'
                  'VA10100'='(VA10100) Buena Vista' 'VA101SP'='(VA101SP) Sp: Buena Vista'
                  'VA10200'='(VA10200) Charlottesville' 'VA102SP'='(VA102SP) Sp: Charlottesville'
                  'VA10300'='(VA10300) Chesapeake' 'VA103SP'='(VA103SP) Sp: Chesapeake'
                  'VA10400'='(VA10400) Clifton Forge' 'VA104SP'='(VA104SP) Sp: Clifton Forge'
                  'VA10500'='(VA10500) Colonial Heights'
                  'VA105SP'='(VA105SP) Sp: Colonial Heights' 'VA10600'='(VA10600) Covington'
                  'VA106SP'='(VA106SP) Sp: Covington' 'VA10700'='(VA10700) Danville'
                  'VA10750'='(VA10750) Fairfax City' 'VA1075S'='(VA1075S) Sp: Fairfax City'
                  'VA107SP'='(VA107SP) Sp: Danville' 'VA10800'='(VA10800) Falls Church'
                  'VA10850'='(VA10850) Franklin' 'VA1085S'='(VA1085S) Sp: Franklin'
                  'VA108SP'='(VA108SP) Sp: Falls Church' 'VA10900'='(VA10900) Fredericksburg'
                  'VA10901'='(VA10901) Mary Washington College'
                  'VA109SP'='(VA109SP) Sp: Fredericksburg' 'VA11000'='(VA11000) Galax'
                  'VA110SP'='(VA110SP) Sp: Galax' 'VA11100'='(VA11100) Hampton'
                  'VA11103'='(VA11103) Thomas Nelson Comm Coll'
                  'VA11104'='(VA11104) Hampton University' 'VA111SP'='(VA111SP) Sp: Hampton'
                  'VA11200'='(VA11200) Harrisonburg' 'VA112SP'='(VA112SP) Sp: Harrisonburg'
                  'VA11300'='(VA11300) Hopewell' 'VA113SP'='(VA113SP) Sp: Hopewell'
                  'VA11400'='(VA11400) Lynchburg' 'VA114SP'='(VA114SP) Sp: Lynchburg'
                  'VA11500'='(VA11500) Martinsville' 'VA115SP'='(VA115SP) Sp: Martinsville'
                  'VA11600'='(VA11600) Newport News'
                  'VA11603'='(VA11603) Va Prt Auth-Newport News'
                  'VA11604'='(VA11604) Christopher Newport Univ'
                  'VA116SP'='(VA116SP) Sp: Newport News' 'VA11700'='(VA11700) Norfolk'
                  'VA11701'='(VA11701) Elizabeth River Tun Comm'
                  'VA11702'='(VA11702) Chesapeake Bay Brid-Tunn'
                  'VA11704'='(VA11704) Norfolk State University'
                  'VA117SP'='(VA117SP) Sp: Norfolk' 'VA11800'='(VA11800) Norton'
                  'VA118SP'='(VA118SP) Sp: Norton' 'VA11900'='(VA11900) Petersburg'
                  'VA11902'='(VA11902) Virginia State Universit'
                  'VA11903'='(VA11903) Southside Va Training Ct'
                  'VA119SP'='(VA119SP) Sp: Petersburg' 'VA12000'='(VA12000) Portsmouth'
                  'VA120SP'='(VA120SP) Sp: Portsmouth' 'VA12100'='(VA12100) Radford'
                  'VA121SP'='(VA121SP) Sp: Radford' 'VA12200'='(VA12200) Richmond'
                  'VA12203'='(VA12203) Virginia State Capitol'
                  'VA12204'='(VA12204) Richmond Internl Airpor'
                  'VA12210'='(VA12210) Dept Of Conservtn & Rec'
                  'VA122SP'='(VA122SP) Sp: Richmond' 'VA12300'='(VA12300) Roanoke'
                  'VA12302'='(VA12302) Va Western Comm College' 'VA123SP'='(VA123SP) Sp: Roanoke'
                  'VA12400'='(VA12400) South Boston' 'VA124SP'='(VA124SP) Sp: South Boston'
                  'VA12600'='(VA12600) Staunton' 'VA126SP'='(VA126SP) Sp: Staunton'
                  'VA12700'='(VA12700) Suffolk' 'VA127SP'='(VA127SP) Sp: Suffolk'
                  'VA12800'='(VA12800) Virginia Beach' 'VA128SP'='(VA128SP) Sp: Virginia Beach'
                  'VA12900'='(VA12900) Waynesboro' 'VA129SP'='(VA129SP) Sp: Waynesboro'
                  'VA13000'='(VA13000) Williamsburg'
                  'VA13001'='(VA13001) College Of William &Mary'
                  'VA13002'='(VA13002) Radford University'
                  'VA13003'='(VA13003) Va Commonwealth Universi'
                  'VA13004'='(VA13004) University Of Richmond'
                  'VA13005'='(VA13005) Port Auth, Norfolk'
                  'VA13006'='(VA13006) Va Port Auth-Portsmouth'
                  'VA13007'='(VA13007) Old Dominion University'
                  'VA13009'='(VA13009) Norfolk Airport Authorit'
                  'VA130SP'='(VA130SP) Sp: Williamsburg' 'VA13100'='(VA13100) Winchester'
                  'VA131SP'='(VA131SP) Sp: Winchester'
                  'VA13600'='(VA13600) Va Military Institute'
                  'VAMWA00'='(VAMWA00) Reagan National Airport'
                  'VAPPD00'='(VAPPD00) U s Park Police' 'VAVSP00'='(VAVSP00) State Police'
                  'VT00100'='(VT00100) Addison' 'VT00101'='(VT00101) Bristol'
                  'VT00102'='(VT00102) Middlebury' 'VT00103'='(VT00103) Vergennes'
                  'VT00200'='(VT00200) Bennington' 'VT00201'='(VT00201) Bennington'
                  'VT00202'='(VT00202) Old Bennington' 'VT00204'='(VT00204) Manchester'
                  'VT00205'='(VT00205) Manchester Village' 'VT00208'='(VT00208) Winhall'
                  'VT00300'='(VT00300) Caledonia' 'VT00301'='(VT00301) Hardwick'
                  'VT00302'='(VT00302) Lyndonville' 'VT00303'='(VT00303) St. Johnsbury'
                  'VT00400'='(VT00400) Chittenden' 'VT00401'='(VT00401) Burlington'
                  'VT00402'='(VT00402) Essex' 'VT00403'='(VT00403) South Burlington'
                  'VT00404'='(VT00404) Winooski' 'VT00405'='(VT00405) Colchester'
                  'VT00406'='(VT00406) Milton' 'VT00407'='(VT00407) Shelburne'
                  'VT00408'='(VT00408) Richmond' 'VT00410'='(VT00410) Williston'
                  'VT00411'='(VT00411) University Of Vermont' 'VT00412'='(VT00412) Hinesburg'
                  'VT00500'='(VT00500) Essex' 'VT00600'='(VT00600) Franklin'
                  'VT00601'='(VT00601) St. Albans' 'VT00602'='(VT00602) Richford'
                  'VT00603'='(VT00603) Swanton' 'VT00604'='(VT00604) Montgomery'
                  'VT00700'='(VT00700) Grand Isle' 'VT00800'='(VT00800) Lamoille'
                  'VT00801'='(VT00801) Morristown' 'VT00802'='(VT00802) Stowe' 'VT00900'='(VT00900) Orange'
                  'VT00901'='(VT00901) Randolph' 'VT00902'='(VT00902) Bradford'
                  'VT00904'='(VT00904) Thetford' 'VT01000'='(VT01000) Orleans'
                  'VT01001'='(VT01001) Newport' 'VT01100'='(VT01100) Rutland' 'VT01101'='(VT01101) Brandon'
                  'VT01102'='(VT01102) Rutland' 'VT01103'='(VT01103) Castleton'
                  'VT01104'='(VT01104) Fair Haven' 'VT01105'='(VT01105) Poultney'
                  'VT01106'='(VT01106) Proctor' 'VT01200'='(VT01200) Washington'
                  'VT01201'='(VT01201) Barre' 'VT01202'='(VT01202) Montpelier'
                  'VT01203'='(VT01203) Northfield' 'VT01204'='(VT01204) Waterbury'
                  'VT01205'='(VT01205) Barre Town' 'VT01206'='(VT01206) Berlin'
                  'VT01216'='(VT01216) Attorney General' 'VT01300'='(VT01300) Windham'
                  'VT01301'='(VT01301) Bellows Falls' 'VT01302'='(VT01302) Brattleboro'
                  'VT01303'='(VT01303) Wilmington' 'VT01305'='(VT01305) Dover' 'VT01306'='(VT01306) Vernon'
                  'VT01400'='(VT01400) Windsor' 'VT01401'='(VT01401) Ludlow'
                  'VT01402'='(VT01402) Springfield' 'VT01403'='(VT01403) Hartford'
                  'VT01404'='(VT01404) Windsor' 'VT01405'='(VT01405) Woodstock'
                  'VT01406'='(VT01406) Chester' 'VT01408'='(VT01408) Weathersfield'
                  'VT01410'='(VT01410) Norwich' 'VTDFW00'='(VTDFW00) Fish & Wildlife Dpt, Led'
                  'VTDLC00'='(VTDLC00) Dept Liquor Contol De&L'
                  'VTDMV00'='(VTDMV00) dept Of Motor Vehicles'
                  'VTVSP00'='(VTVSP00) Vermont State Police' 'VTVSP01'='(VTVSP01) Sp: Williston'
                  'VTVSP02'='(VTVSP02) Sp: St. Johnsbury' 'VTVSP03'='(VTVSP03) Sp: Rutland'
                  'VTVSP04'='(VTVSP04) Sp: Rockingham'
                  'VTVSP05'='(VTVSP05) Vt. State Police Hdq-Bci'
                  'VTVSP06'='(VTVSP06) Sp: Middlebury' 'VTVSP07'='(VTVSP07) Sp: St. Albans'
                  'VTVSP08'='(VTVSP08) Sp: Derby' 'VTVSP09'='(VTVSP09) Sp: Shaftsbury'
                  'VTVSP10'='(VTVSP10) Sp: Brattleboro' 'VTVSP11'='(VTVSP11) Sp: Bethel'
                  'VTVSP12'='(VTVSP12) Sp: Middlesex' 'VTVSP13'='(VTVSP13) Sp: Bradford'
                  'VTVSP14'='(VTVSP14) Vt State Police, Fld F d' 'WA00100'='(WA00100) Adams'
                  'WA00101'='(WA00101) Othello' 'WA00102'='(WA00102) Ritzville'
                  'WA00200'='(WA00200) Asotin' 'WA00201'='(WA00201) Clarkston' 'WA00202'='(WA00202) Asotin'
                  'WA00300'='(WA00300) Benton' 'WA00301'='(WA00301) Kennewick'
                  'WA00302'='(WA00302) Richland' 'WA00303'='(WA00303) Prosser'
                  'WA00304'='(WA00304) Benton City' 'WA00305'='(WA00305) West Richland'
                  'WA00400'='(WA00400) Chelan' 'WA00402'='(WA00402) Chelan' 'WA00404'='(WA00404) Wenatchee'
                  'WA00500'='(WA00500) Clallam' 'WA00501'='(WA00501) Port Angeles'
                  'WA00502'='(WA00502) Forks' 'WA00503'='(WA00503) Sequim' 'WA00600'='(WA00600) Clark'
                  'WA00601'='(WA00601) Battle Ground' 'WA00602'='(WA00602) Camas'
                  'WA00603'='(WA00603) Vancouver' 'WA00604'='(WA00604) Washougal'
                  'WA00605'='(WA00605) Ridgefield' 'WA00606'='(WA00606) La Center'
                  'WA00610'='(WA00610) Wa State Univ: Vancouver' 'WA00700'='(WA00700) Columbia'
                  'WA00701'='(WA00701) Dayton' 'WA00800'='(WA00800) Cowlitz' 'WA00801'='(WA00801) Kelso'
                  'WA00802'='(WA00802) Longview' 'WA00803'='(WA00803) Castle Rock'
                  'WA00804'='(WA00804) Kalama' 'WA00805'='(WA00805) Woodland' 'WA00900'='(WA00900) Douglas'
                  'WA00902'='(WA00902) East Wenatchee' 'WA00903'='(WA00903) Mansfield'
                  'WA01000'='(WA01000) Ferry' 'WA01001'='(WA01001) Republic' 'WA01100'='(WA01100) Franklin'
                  'WA01101'='(WA01101) Connell' 'WA01102'='(WA01102) Pasco' 'WA01200'='(WA01200) Garfield'
                  'WA01201'='(WA01201) Pomeroy' 'WA01300'='(WA01300) Grant' 'WA01301'='(WA01301) Ephrata'
                  'WA01302'='(WA01302) Moses Lake' 'WA01303'='(WA01303) Quincy'
                  'WA01304'='(WA01304) Soap Lake' 'WA01305'='(WA01305) Coulee City'
                  'WA01307'='(WA01307) Grand Coulee' 'WA01309'='(WA01309) Mattawa'
                  'WA01310'='(WA01310) Royal City' 'WA01311'='(WA01311) Warden'
                  'WA01400'='(WA01400) Grays Harbor' 'WA01401'='(WA01401) Aberdeen'
                  'WA01402'='(WA01402) Elma' 'WA01403'='(WA01403) Hoquiam' 'WA01404'='(WA01404) Mccleary'
                  'WA01405'='(WA01405) Montesano' 'WA01406'='(WA01406) Cosmopolis'
                  'WA01407'='(WA01407) Oakville' 'WA01408'='(WA01408) Ocean Shores'
                  'WA01409'='(WA01409) Westport' 'WA01500'='(WA01500) Island'
                  'WA01501'='(WA01501) Oak Harbor' 'WA01502'='(WA01502) Coupeville'
                  'WA01503'='(WA01503) Langley' 'WA01600'='(WA01600) Jefferson'
                  'WA01601'='(WA01601) Port Townsend' 'WA01700'='(WA01700) King'
                  'WA01701'='(WA01701) Auburn' 'WA01702'='(WA01702) Bellevue' 'WA01703'='(WA01703) Bothell'
                  'WA01704'='(WA01704) Enumclaw' 'WA01706'='(WA01706) Issaquah' 'WA01707'='(WA01707) Kent'
                  'WA01708'='(WA01708) Kirkland' 'WA01709'='(WA01709) Mercer Island'
                  'WA01710'='(WA01710) Normandy Park' 'WA01711'='(WA01711) North Bend'
                  'WA01712'='(WA01712) Redmond' 'WA01713'='(WA01713) Renton' 'WA01714'='(WA01714) Algona'
                  'WA01715'='(WA01715) Black Diamond' 'WA01716'='(WA01716) Carnation'
                  'WA01717'='(WA01717) Des Moines' 'WA01718'='(WA01718) Duvall'
                  'WA01720'='(WA01720) Medina' 'WA01721'='(WA01721) Pacific'
                  'WA01722'='(WA01722) Snoqualmie' 'WA01723'='(WA01723) Tukwila'
                  'WA01724'='(WA01724) University Of Washington' 'WA01725'='(WA01725) Clyde Hill'
                  'WA01726'='(WA01726) Lake Forest Park' 'WA01727'='(WA01727) Skykomish'
                  'WA01728'='(WA01728) Town Of Mercer Island' 'WA01731'='(WA01731) Yarrow Point'
                  'WA01732'='(WA01732) Port Of Seattle' 'WA01736'='(WA01736) Federal Way'
                  'WA01737'='(WA01737) Seatac' 'WA01740'='(WA01740) Woodinville'
                  'WA01741'='(WA01741) Burien' 'WA01742'='(WA01742) Newcastle'
                  'WA01743'='(WA01743) Shoreline' 'WA01747'='(WA01747) Maple Valley'
                  'WA01748'='(WA01748) Covington' 'WA01749'='(WA01749) Kenmore'
                  'WA01750'='(WA01750) Sammamish' 'WA01800'='(WA01800) Kitsap'
                  'WA01801'='(WA01801) Bremerton' 'WA01803'='(WA01803) Navy Yard Bremerton'
                  'WA01804'='(WA01804) Port Orchard' 'WA01805'='(WA01805) Poulsbo'
                  'WA01807'='(WA01807) Bainbridge Island' 'WA01900'='(WA01900) Kittitas'
                  'WA01901'='(WA01901) Ellensburg' 'WA01902'='(WA01902) Cle Elum'
                  'WA01904'='(WA01904) Roslyn' 'WA01906'='(WA01906) Kittitas'
                  'WA01908'='(WA01908) Central Washington Univ' 'WA02000'='(WA02000) Klickitat'
                  'WA02001'='(WA02001) Goldendale' 'WA02002'='(WA02002) Bingen'
                  'WA02006'='(WA02006) White Salmon' 'WA02100'='(WA02100) Lewis'
                  'WA02101'='(WA02101) Centralia' 'WA02102'='(WA02102) Chehalis'
                  'WA02103'='(WA02103) Morton' 'WA02104'='(WA02104) Mossyrock'
                  'WA02107'='(WA02107) Napavine' 'WA02109'='(WA02109) Pe Ell' 'WA02110'='(WA02110) Toledo'
                  'WA02111'='(WA02111) Vader' 'WA02112'='(WA02112) Winlock' 'WA02200'='(WA02200) Lincoln'
                  'WA02201'='(WA02201) Davenport' 'WA02202'='(WA02202) Wilbur'
                  'WA02204'='(WA02204) Creston' 'WA02205'='(WA02205) Harrington'
                  'WA02206'='(WA02206) Odessa' 'WA02207'='(WA02207) Reardan' 'WA02208'='(WA02208) Sprague'
                  'WA02300'='(WA02300) Mason' 'WA02304'='(WA02304) Shelton' 'WA02400'='(WA02400) Okanogan'
                  'WA02401'='(WA02401) Brewster' 'WA02402'='(WA02402) Okanogan' 'WA02403'='(WA02403) Omak'
                  'WA02404'='(WA02404) Oroville' 'WA02405'='(WA02405) Pateros'
                  'WA02406'='(WA02406) Tonasket' 'WA02407'='(WA02407) Coulee Dam'
                  'WA02408'='(WA02408) Elmer City' 'WA02409'='(WA02409) Twisp'
                  'WA02410'='(WA02410) Winthrop' 'WA02412'='(WA02412) Conconully'
                  'WA02414'='(WA02414) Colville Tribal' 'WA02500'='(WA02500) Pacific'
                  'WA02501'='(WA02501) Raymond' 'WA02502'='(WA02502) South Bend'
                  'WA02503'='(WA02503) Ilwaco' 'WA02504'='(WA02504) Long Beach'
                  'WA02600'='(WA02600) Pend Oreille' 'WA02602'='(WA02602) Newport'
                  'WA02603'='(WA02603) Ione' 'WA02605'='(WA02605) Cusick' 'WA02700'='(WA02700) Pierce'
                  'WA02701'='(WA02701) Puyallup' 'WA02702'='(WA02702) Sumner' 'WA02703'='(WA02703) Tacoma'
                  'WA02704'='(WA02704) Buckley' 'WA02705'='(WA02705) Eatonville' 'WA02707'='(WA02707) Fife'
                  'WA02709'='(WA02709) Milton' 'WA02710'='(WA02710) Roy' 'WA02711'='(WA02711) Steilacoom'
                  'WA02713'='(WA02713) Orting' 'WA02714'='(WA02714) Bonney Lake'
                  'WA02716'='(WA02716) Dupont' 'WA02717'='(WA02717) Fircrest'
                  'WA02718'='(WA02718) Gig Harbor' 'WA02719'='(WA02719) Ruston'
                  'WA02720'='(WA02720) Wilkeson' 'WA02723'='(WA02723) Lakewood'
                  'WA02724'='(WA02724) University Place' 'WA02725'='(WA02725) Edgewood'
                  'WA02800'='(WA02800) San Juan' 'WA02900'='(WA02900) Skagit'
                  'WA02901'='(WA02901) Anacortes' 'WA02902'='(WA02902) Mount Vernon'
                  'WA02903'='(WA02903) Sedro Woolley' 'WA02904'='(WA02904) Burlington'
                  'WA02906'='(WA02906) La Conner' 'WA03000'='(WA03000) Skamania'
                  'WA03001'='(WA03001) North Bonneville' 'WA03002'='(WA03002) Stevenson'
                  'WA03100'='(WA03100) Snohomish' 'WA03101'='(WA03101) Arlington'
                  'WA03102'='(WA03102) Edmonds' 'WA03103'='(WA03103) Everett'
                  'WA03104'='(WA03104) Lynnwood' 'WA03105'='(WA03105) Marysville'
                  'WA03106'='(WA03106) Mountlake Terrace' 'WA03107'='(WA03107) Snohomish'
                  'WA03108'='(WA03108) Brier' 'WA03109'='(WA03109) Darrington'
                  'WA03111'='(WA03111) Granite Falls' 'WA03112'='(WA03112) Monroe'
                  'WA03113'='(WA03113) Mukilteo' 'WA03114'='(WA03114) Stanwood'
                  'WA03115'='(WA03115) Sultan' 'WA03116'='(WA03116) Woodway'
                  'WA03119'='(WA03119) Lake Stevens' 'WA03121'='(WA03121) Mill Creek'
                  'WA03200'='(WA03200) Spokane' 'WA03201'='(WA03201) Cheney'
                  'WA03202'='(WA03202) Deer Park' 'WA03203'='(WA03203) Medical Lake'
                  'WA03204'='(WA03204) Spokane' 'WA03206'='(WA03206) Airway Heights'
                  'WA03209'='(WA03209) Eastern Washington Univ'
                  'WA03213'='(WA03213) Liberty Lake' 'WA03215'='(WA03215) Spokane Valley'
                  'WA03300'='(WA03300) Stevens' 'WA03301'='(WA03301) Chewelah'
                  'WA03302'='(WA03302) Colville' 'WA03303'='(WA03303) Kettle Falls'
                  'WA03305'='(WA03305) Northport' 'WA03306'='(WA03306) Springdale'
                  'WA03400'='(WA03400) Thurston' 'WA03401'='(WA03401) Olympia'
                  'WA03402'='(WA03402) Tumwater' 'WA03404'='(WA03404) Lacey' 'WA03406'='(WA03406) Rainier'
                  'WA03408'='(WA03408) Tenino' 'WA03409'='(WA03409) Yelm'
                  'WA03412'='(WA03412) Washington State Lottery'
                  'WA03419'='(WA03419) Evergreen State College' 'WA03500'='(WA03500) Wahkiakum'
                  'WA03600'='(WA03600) Walla Walla' 'WA03601'='(WA03601) Walla Walla'
                  'WA03602'='(WA03602) College Place' 'WA03603'='(WA03603) Waitsburg'
                  'WA03700'='(WA03700) Whatcom' 'WA03701'='(WA03701) Bellingham'
                  'WA03702'='(WA03702) Blaine' 'WA03703'='(WA03703) Everson' 'WA03704'='(WA03704) Ferndale'
                  'WA03705'='(WA03705) Lynden' 'WA03707'='(WA03707) Sumas'
                  'WA03708'='(WA03708) Western Washington Univ'
                  'WA03710'='(WA03710) Lummi Tribal' 'WA03800'='(WA03800) Whitman'
                  'WA03801'='(WA03801) Colfax' 'WA03802'='(WA03802) Albion' 'WA03803'='(WA03803) Pullman'
                  'WA03804'='(WA03804) Rosalia' 'WA03805'='(WA03805) Wa State Univ: Pullman'
                  'WA03806'='(WA03806) Colton' 'WA03807'='(WA03807) Garfield'
                  'WA03808'='(WA03808) Lacrosse' 'WA03809'='(WA03809) Palouse' 'WA03813'='(WA03813) Malden'
                  'WA03814'='(WA03814) Oakesdale' 'WA03815'='(WA03815) Tekoa'
                  'WA03816'='(WA03816) Uniontown' 'WA03900'='(WA03900) Yakima'
                  'WA03901'='(WA03901) Grandview' 'WA03902'='(WA03902) Sunnyside'
                  'WA03903'='(WA03903) Toppenish' 'WA03904'='(WA03904) Union Gap'
                  'WA03905'='(WA03905) Yakima' 'WA03906'='(WA03906) Zillah' 'WA03907'='(WA03907) Granger'
                  'WA03908'='(WA03908) Harrah' 'WA03909'='(WA03909) Mabton' 'WA03911'='(WA03911) Selah'
                  'WA03912'='(WA03912) Tieton' 'WA03913'='(WA03913) Wapato' 'WA03914'='(WA03914) Moxee'
                  'WADI008'='(WADI008) Nisqually Tribal' 'WADI011'='(WADI011) Skokomish Tribal'
                  'WADI014'='(WADI014) Nooksack Tribal' 'WADI064'='(WADI064) Swinomish Tribal'
                  'WASPD00'='(WASPD00) Seattle' 'WAWSP00'='(WAWSP00) Washington State Patrol'
                  'WI00100'='(WI00100) Adams' 'WI00101'='(WI00101) Adams' 'WI00102'='(WI00102) Rome Town'
                  'WI00200'='(WI00200) Ashland' 'WI00201'='(WI00201) Ashland' 'WI00300'='(WI00300) Barron'
                  'WI00301'='(WI00301) Rice Lake' 'WI00302'='(WI00302) Barron' 'WI00303'='(WI00303) Chetek'
                  'WI00304'='(WI00304) Cumberland' 'WI00400'='(WI00400) Bayfield'
                  'WI00401'='(WI00401) Washburn' 'WI00402'='(WI00402) Bayfield' 'WI00500'='(WI00500) Brown'
                  'WI00501'='(WI00501) De Pere' 'WI00502'='(WI00502) Green Bay'
                  'WI00503'='(WI00503) Pulaski' 'WI00504'='(WI00504) Howard' 'WI00505'='(WI00505) Denmark'
                  'WI00507'='(WI00507) Univ Of Wi: Green Bay' 'WI00508'='(WI00508) Ashwaubenon'
                  'WI00509'='(WI00509) Hobart-Lawrence' 'WI00600'='(WI00600) Buffalo'
                  'WI00603'='(WI00603) Mondovi' 'WI00700'='(WI00700) Burnett'
                  'WI00701'='(WI00701) Grantsburg' 'WI00702'='(WI00702) Siren'
                  'WI00800'='(WI00800) Calumet' 'WI00801'='(WI00801) Chilton'
                  'WI00802'='(WI00802) New Holstein' 'WI00803'='(WI00803) Brillion'
                  'WI00900'='(WI00900) Chippewa' 'WI00901'='(WI00901) Chippewa Falls'
                  'WI00902'='(WI00902) Bloomer' 'WI00903'='(WI00903) Cornell' 'WI00904'='(WI00904) Stanley'
                  'WI00905'='(WI00905) Lake Hallie' 'WI01000'='(WI01000) Clark'
                  'WI01003'='(WI01003) Neillsville' 'WI01004'='(WI01004) Colby-Abbotsford'
                  'WI01100'='(WI01100) Columbia' 'WI01101'='(WI01101) Portage'
                  'WI01102'='(WI01102) Wisconsin Dells' 'WI01103'='(WI01103) Columbus'
                  'WI01107'='(WI01107) Poynette' 'WI01110'='(WI01110) Lodi'
                  'WI01111'='(WI01111) Pardeeville' 'WI01200'='(WI01200) Crawford'
                  'WI01201'='(WI01201) Prairie Du Chien' 'WI01300'='(WI01300) Dane'
                  'WI01301'='(WI01301) Madison' 'WI01302'='(WI01302) Middleton'
                  'WI01303'='(WI01303) Monona' 'WI01304'='(WI01304) Mount Horeb'
                  'WI01305'='(WI01305) Stoughton' 'WI01306'='(WI01306) Sun Prairie'
                  'WI01308'='(WI01308) Univ Of Wi: Madison' 'WI01310'='(WI01310) Town Of Madison'
                  'WI01312'='(WI01312) Black Earth' 'WI01313'='(WI01313) Cross Plains'
                  'WI01314'='(WI01314) Dane' 'WI01315'='(WI01315) Deerfield'
                  'WI01316'='(WI01316) Marshall Village' 'WI01319'='(WI01319) Cottage Grove'
                  'WI01367'='(WI01367) Deforest' 'WI01368'='(WI01368) Belleville'
                  'WI01370'='(WI01370) Fitchburg' 'WI01371'='(WI01371) Maple Bluff'
                  'WI01372'='(WI01372) Mazomanie' 'WI01373'='(WI01373) Mcfarland'
                  'WI01374'='(WI01374) Oregon' 'WI01375'='(WI01375) Shorewood Hills'
                  'WI01376'='(WI01376) Verona' 'WI01377'='(WI01377) Waunakee'
                  'WI01378'='(WI01378) Capitol Police' 'WI01400'='(WI01400) Dodge'
                  'WI01401'='(WI01401) Beaver Dam' 'WI01402'='(WI01402) Fox Lake'
                  'WI01403'='(WI01403) Horicon' 'WI01404'='(WI01404) Juneau' 'WI01405'='(WI01405) Mayville'
                  'WI01409'='(WI01409) Waupun' 'WI01414'='(WI01414) Iron Ridge'
                  'WI01419'='(WI01419) Theresa' 'WI01500'='(WI01500) Door'
                  'WI01501'='(WI01501) Sturgeon Bay' 'WI01502'='(WI01502) Washington Island'
                  'WI01505'='(WI01505) Potawatomi State Park' 'WI01600'='(WI01600) Douglas'
                  'WI01601'='(WI01601) Superior' 'WI01605'='(WI01605) Univ Of Wi: Superior'
                  'WI01700'='(WI01700) Dunn' 'WI01701'='(WI01701) Menomonie'
                  'WI01705'='(WI01705) Elk Mound' 'WI01706'='(WI01706) Univ Of Wi: Stout'
                  'WI01800'='(WI01800) Eau Claire' 'WI01801'='(WI01801) Eau Claire'
                  'WI01802'='(WI01802) Altoona' 'WI01803'='(WI01803) Augusta'
                  'WI01804'='(WI01804) Fall Creek' 'WI01805'='(WI01805) Univ Of Wi: Eau Claire'
                  'WI01900'='(WI01900) Florence' 'WI02000'='(WI02000) Fond Du Lac'
                  'WI02001'='(WI02001) Fond Du Lac' 'WI02002'='(WI02002) Ripon'
                  'WI02003'='(WI02003) Campbellsport' 'WI02004'='(WI02004) North Fond Du Lac'
                  'WI02100'='(WI02100) Forest' 'WI02101'='(WI02101) Crandon' 'WI02200'='(WI02200) Grant'
                  'WI02201'='(WI02201) Boscobel' 'WI02203'='(WI02203) Fennimore'
                  'WI02204'='(WI02204) Lancaster' 'WI02205'='(WI02205) Platteville'
                  'WI02208'='(WI02208) Cuba City' 'WI02211'='(WI02211) Hazel Green'
                  'WI02214'='(WI02214) Univ Of Wi: Platteville' 'WI02300'='(WI02300) Green'
                  'WI02301'='(WI02301) Monroe' 'WI02302'='(WI02302) Brodhead' 'WI02303'='(WI02303) Albany'
                  'WI02306'='(WI02306) New Glarus' 'WI02400'='(WI02400) Green Lake'
                  'WI02401'='(WI02401) Berlin' 'WI02403'='(WI02403) Markesan'
                  'WI02404'='(WI02404) Princeton' 'WI02405'='(WI02405) Green Lake'
                  'WI02500'='(WI02500) Iowa' 'WI02501'='(WI02501) Dodgeville'
                  'WI02502'='(WI02502) Mineral Point' 'WI02600'='(WI02600) Iron'
                  'WI02601'='(WI02601) Hurley' 'WI02700'='(WI02700) Jackson'
                  'WI02701'='(WI02701) Black River Falls' 'WI02702'='(WI02702) Brockway Township'
                  'WI02800'='(WI02800) Jefferson' 'WI02801'='(WI02801) Fort Atkinson'
                  'WI02802'='(WI02802) Jefferson' 'WI02803'='(WI02803) Watertown'
                  'WI02804'='(WI02804) Lake Mills' 'WI02806'='(WI02806) Palmyra'
                  'WI02807'='(WI02807) Waterloo' 'WI02900'='(WI02900) Juneau' 'WI02901'='(WI02901) Elroy'
                  'WI02902'='(WI02902) Mauston' 'WI02903'='(WI02903) New Lisbon'
                  'WI02905'='(WI02905) Wonewoc' 'WI03000'='(WI03000) Kenosha' 'WI03001'='(WI03001) Kenosha'
                  'WI03002'='(WI03002) Twin Lakes' 'WI03003'='(WI03003) Univ Of Wi: Parkside'
                  'WI03004'='(WI03004) Silver Lake' 'WI03008'='(WI03008) Pleasant Prairie'
                  'WI03100'='(WI03100) Kewaunee' 'WI03101'='(WI03101) Algoma'
                  'WI03102'='(WI03102) Kewaunee' 'WI03104'='(WI03104) Luxemburg'
                  'WI03200'='(WI03200) La Crosse' 'WI03201'='(WI03201) La Crosse'
                  'WI03202'='(WI03202) Onalaska' 'WI03203'='(WI03203) West Salem'
                  'WI03205'='(WI03205) Bangor' 'WI03206'='(WI03206) Campbell Township'
                  'WI03207'='(WI03207) Holmen' 'WI03208'='(WI03208) Univ Of Wi: La Crosse'
                  'WI03300'='(WI03300) Lafayette' 'WI03302'='(WI03302) Blanchardville'
                  'WI03303'='(WI03303) Darlington' 'WI03306'='(WI03306) Benton'
                  'WI03307'='(WI03307) South Wayne' 'WI03400'='(WI03400) Langlade'
                  'WI03401'='(WI03401) Antigo' 'WI03500'='(WI03500) Lincoln' 'WI03501'='(WI03501) Merrill'
                  'WI03502'='(WI03502) Tomahawk' 'WI03600'='(WI03600) Manitowoc'
                  'WI03601'='(WI03601) Manitowoc' 'WI03602'='(WI03602) Two Rivers'
                  'WI03604'='(WI03604) Valders' 'WI03605'='(WI03605) Kiel' 'WI03606'='(WI03606) Cleveland'
                  'WI03608'='(WI03608) Mishicot' 'WI03700'='(WI03700) Marathon'
                  'WI03701'='(WI03701) Rothschild' 'WI03702'='(WI03702) Schofield'
                  'WI03703'='(WI03703) Wausau' 'WI03705'='(WI03705) Edgar'
                  'WI03706'='(WI03706) Marathon City' 'WI03707'='(WI03707) Spencer'
                  'WI03709'='(WI03709) Weston Village' 'WI03710'='(WI03710) Mosinee'
                  'WI03713'='(WI03713) Everest' 'WI03800'='(WI03800) Marinette'
                  'WI03801'='(WI03801) Marinette' 'WI03802'='(WI03802) Niagara'
                  'WI03803'='(WI03803) Peshtigo' 'WI03900'='(WI03900) Marquette'
                  'WI03901'='(WI03901) Montello' 'WI04000'='(WI04000) Menominee'
                  'WI04001'='(WI04001) Menominee Tribal' 'WI04100'='(WI04100) Milwaukee'
                  'WI04101'='(WI04101) Bayside' 'WI04102'='(WI04102) Brown Deer'
                  'WI04103'='(WI04103) Cudahy' 'WI04104'='(WI04104) Fox Point'
                  'WI04105'='(WI04105) Franklin' 'WI04106'='(WI04106) Glendale'
                  'WI04107'='(WI04107) Greendale' 'WI04108'='(WI04108) Greenfield'
                  'WI04109'='(WI04109) Hales Corners' 'WI04110'='(WI04110) Oak Creek'
                  'WI04111'='(WI04111) River Hills' 'WI04112'='(WI04112) St. Francis'
                  'WI04113'='(WI04113) Shorewood' 'WI04114'='(WI04114) South Milwaukee'
                  'WI04115'='(WI04115) Wauwatosa' 'WI04116'='(WI04116) West Allis'
                  'WI04117'='(WI04117) West Milwaukee' 'WI04118'='(WI04118) Whitefish Bay'
                  'WI04119'='(WI04119) Univ Of Wi: Milwaukee'
                  'WI04120'='(WI04120) State Fair Park Police' 'WI04200'='(WI04200) Monroe'
                  'WI04202'='(WI04202) Sparta' 'WI04203'='(WI04203) Tomah' 'WI04300'='(WI04300) Oconto'
                  'WI04302'='(WI04302) Oconto' 'WI04303'='(WI04303) Oconto Falls'
                  'WI04400'='(WI04400) Oneida' 'WI04401'='(WI04401) Minocqua'
                  'WI04402'='(WI04402) Rhinelander' 'WI04403'='(WI04403) Woodruff'
                  'WI04404'='(WI04404) Three Lakes' 'WI04500'='(WI04500) Outagamie'
                  'WI04501'='(WI04501) Appleton' 'WI04502'='(WI04502) Kaukauna'
                  'WI04503'='(WI04503) Kimberly' 'WI04504'='(WI04504) Little Chute'
                  'WI04507'='(WI04507) Combined Locks' 'WI04508'='(WI04508) Hortonville'
                  'WI04509'='(WI04509) Grand Chute' 'WI04512'='(WI04512) Oneida Tribal'
                  'WI04513'='(WI04513) Fox Valley' 'WI04600'='(WI04600) Ozaukee'
                  'WI04601'='(WI04601) Mequon' 'WI04602'='(WI04602) Port Washington'
                  'WI04603'='(WI04603) Cedarburg' 'WI04604'='(WI04604) Grafton'
                  'WI04605'='(WI04605) Thiensville' 'WI04606'='(WI04606) Saukville'
                  'WI04700'='(WI04700) Pepin' 'WI04701'='(WI04701) Durand' 'WI04702'='(WI04702) Pepin'
                  'WI04800'='(WI04800) Pierce' 'WI04801'='(WI04801) River Falls'
                  'WI04802'='(WI04802) Ellsworth' 'WI04803'='(WI04803) Prescott'
                  'WI04806'='(WI04806) Univ Of Wi: River Falls' 'WI04900'='(WI04900) Polk'
                  'WI04901'='(WI04901) Amery' 'WI04902'='(WI04902) St. Croix Falls'
                  'WI04905'='(WI04905) Frederic' 'WI04907'='(WI04907) Osceola'
                  'WI04909'='(WI04909) Clear Lake' 'WI05000'='(WI05000) Portage'
                  'WI05001'='(WI05001) Stevens Point' 'WI05002'='(WI05002) Plover'
                  'WI05006'='(WI05006) Univ Of Wi: Stevens Poin' 'WI05100'='(WI05100) Price'
                  'WI05101'='(WI05101) Park Falls' 'WI05102'='(WI05102) Phillips'
                  'WI05200'='(WI05200) Racine' 'WI05201'='(WI05201) Burlington'
                  'WI05202'='(WI05202) Racine' 'WI05203'='(WI05203) Caledonia'
                  'WI05204'='(WI05204) Waterford' 'WI05205'='(WI05205) Union Grove'
                  'WI05206'='(WI05206) Burlington Town' 'WI05207'='(WI05207) Mount Pleasant'
                  'WI05208'='(WI05208) Sturtevant' 'WI05300'='(WI05300) Richland'
                  'WI05301'='(WI05301) Richland Center' 'WI05400'='(WI05400) Rock'
                  'WI05401'='(WI05401) Beloit' 'WI05402'='(WI05402) Janesville'
                  'WI05403'='(WI05403) Edgerton' 'WI05404'='(WI05404) Evansville'
                  'WI05405'='(WI05405) Clinton' 'WI05406'='(WI05406) Milton'
                  'WI05407'='(WI05407) Orfordville' 'WI05408'='(WI05408) Beloit Town'
                  'WI05409'='(WI05409) Turtle Township' 'WI05500'='(WI05500) Rusk'
                  'WI05503'='(WI05503) Ladysmith' 'WI05600'='(WI05600) St. Croix'
                  'WI05601'='(WI05601) Hudson' 'WI05602'='(WI05602) New Richmond'
                  'WI05607'='(WI05607) North Hudson' 'WI05608'='(WI05608) Somerset'
                  'WI05700'='(WI05700) Sauk' 'WI05701'='(WI05701) Reedsburg' 'WI05702'='(WI05702) Baraboo'
                  'WI05703'='(WI05703) Sauk Prairie' 'WI05704'='(WI05704) Spring Green'
                  'WI05705'='(WI05705) Lake Delton' 'WI05780'='(WI05780) Devils Lake Park Police'
                  'WI05800'='(WI05800) Sawyer' 'WI05801'='(WI05801) Hayward' 'WI05900'='(WI05900) Shawano'
                  'WI05901'='(WI05901) Shawano' 'WI06000'='(WI06000) Sheboygan'
                  'WI06001'='(WI06001) Plymouth' 'WI06002'='(WI06002) Sheboygan'
                  'WI06003'='(WI06003) Sheboygan Falls' 'WI06004'='(WI06004) Elkhart Lake'
                  'WI06006'='(WI06006) Kohler' 'WI06100'='(WI06100) Taylor' 'WI06101'='(WI06101) Medford'
                  'WI06200'='(WI06200) Trempealeau' 'WI06201'='(WI06201) Whitehall'
                  'WI06202'='(WI06202) Arcadia' 'WI06203'='(WI06203) Blair'
                  'WI06206'='(WI06206) Independence' 'WI06207'='(WI06207) Osseo'
                  'WI06208'='(WI06208) Strum' 'WI06209'='(WI06209) Eleva' 'WI06210'='(WI06210) Trempealeau'
                  'WI06300'='(WI06300) Vernon' 'WI06302'='(WI06302) Viroqua'
                  'WI06303'='(WI06303) Hillsboro' 'WI06304'='(WI06304) Westby'
                  'WI06308'='(WI06308) Readstown' 'WI06309'='(WI06309) Stoddard'
                  'WI06400'='(WI06400) Vilas' 'WI06401'='(WI06401) Lac Du Flambeau Tribal'
                  'WI06403'='(WI06403) Eagle River' 'WI06500'='(WI06500) Walworth'
                  'WI06501'='(WI06501) Delavan' 'WI06502'='(WI06502) Elkhorn'
                  'WI06503'='(WI06503) Lake Geneva' 'WI06504'='(WI06504) Walworth'
                  'WI06505'='(WI06505) Whitewater' 'WI06507'='(WI06507) Bloomfield'
                  'WI06508'='(WI06508) Darien' 'WI06509'='(WI06509) Town Of East Troy'
                  'WI06510'='(WI06510) East Troy' 'WI06511'='(WI06511) Fontana'
                  'WI06512'='(WI06512) Geneva Town' 'WI06513'='(WI06513) Genoa City'
                  'WI06516'='(WI06516) Williams Bay' 'WI06517'='(WI06517) Delavan Town'
                  'WI06523'='(WI06523) Univ Of Wi: Whitewater' 'WI06600'='(WI06600) Washburn'
                  'WI06601'='(WI06601) Spooner' 'WI06700'='(WI06700) Washington'
                  'WI06701'='(WI06701) Germantown' 'WI06702'='(WI06702) Hartford'
                  'WI06703'='(WI06703) Kewaskum' 'WI06704'='(WI06704) West Bend'
                  'WI06705'='(WI06705) Slinger' 'WI06707'='(WI06707) Jackson'
                  'WI06800'='(WI06800) Waukesha' 'WI06801'='(WI06801) Brookfield'
                  'WI06802'='(WI06802) Elm Grove' 'WI06803'='(WI06803) Menomonee Falls'
                  'WI06804'='(WI06804) New Berlin' 'WI06805'='(WI06805) Waukesha'
                  'WI06806'='(WI06806) Muskego' 'WI06807'='(WI06807) Delafield'
                  'WI06808'='(WI06808) Oconomowoc' 'WI06809'='(WI06809) Butler'
                  'WI06810'='(WI06810) Chenequa' 'WI06811'='(WI06811) Hartland'
                  'WI06812'='(WI06812) Mukwonago' 'WI06814'='(WI06814) Pewaukee Village'
                  'WI06815'='(WI06815) Pewaukee' 'WI06816'='(WI06816) Summit'
                  'WI06818'='(WI06818) Brookfield Township' 'WI06820'='(WI06820) Oconomowoc Town'
                  'WI06825'='(WI06825) Eagle Village' 'WI06900'='(WI06900) Waupaca'
                  'WI06901'='(WI06901) Clintonville' 'WI06902'='(WI06902) New London'
                  'WI06903'='(WI06903) Waupaca' 'WI06906'='(WI06906) Marion' 'WI07000'='(WI07000) Waushara'
                  'WI07005'='(WI07005) Wautoma' 'WI07100'='(WI07100) Winnebago'
                  'WI07101'='(WI07101) Menasha' 'WI07102'='(WI07102) Neenah' 'WI07103'='(WI07103) Oshkosh'
                  'WI07104'='(WI07104) Winneconne' 'WI07105'='(WI07105) Town Of Menasha'
                  'WI07106'='(WI07106) Omro' 'WI07107'='(WI07107) Univ Of Wi: Oshkosh'
                  'WI07200'='(WI07200) Wood' 'WI07201'='(WI07201) Marshfield' 'WI07202'='(WI07202) Nekoosa'
                  'WI07203'='(WI07203) Wisconsin Rapids' 'WI07205'='(WI07205) Grand Rapids'
                  'WILEB01'='(WILEB01) Dept Of Natural Resource' 'WIMPD00'='(WIMPD00) Milwaukee'
                  'WIWSP00'='(WIWSP00) Wisconsin State Patrol' 'WV00100'='(WV00100) Barbour'
                  'WV00101'='(WV00101) Belington' 'WV00102'='(WV00102) Philippi'
                  'WV00103'='(WV00103) Dnr: Barbour County'
                  'WV00106'='(WV00106) Sfm: Barbour County'
                  'WV001SP'='(WV001SP) Barbour State Police' 'WV00200'='(WV00200) Berkeley'
                  'WV00201'='(WV00201) Martinsburg' 'WV00202'='(WV00202) Dnr: Berkeley County'
                  'WV00203'='(WV00203) Sfm: Berkeley County'
                  'WV00206'='(WV00206) Eastern Panhandle D&vctf'
                  'WV002SP'='(WV002SP) Berkeley State Police' 'WV00300'='(WV00300) Boone'
                  'WV00301'='(WV00301) Madison' 'WV00302'='(WV00302) Whitesville'
                  'WV00303'='(WV00303) Dnr: Boone County' 'WV00305'='(WV00305) Danville'
                  'WV00306'='(WV00306) Sylvester' 'WV00307'='(WV00307) Sfm: Boone County'
                  'WV003SP'='(WV003SP) Boone State Police' 'WV00400'='(WV00400) Braxton'
                  'WV00401'='(WV00401) Gassaway' 'WV00402'='(WV00402) Sutton'
                  'WV00403'='(WV00403) Burnsville' 'WV00404'='(WV00404) Dnr: Braxton County'
                  'WV00407'='(WV00407) Sfm: Braxton County'
                  'WV004SP'='(WV004SP) Braxton State Police' 'WV00500'='(WV00500) Brooke'
                  'WV00501'='(WV00501) Follansbee' 'WV00502'='(WV00502) Wellsburg'
                  'WV00503'='(WV00503) Dnr: Brooke County' 'WV00505'='(WV00505) Bethany'
                  'WV00507'='(WV00507) Sfm: Brooke County'
                  'WV005SP'='(WV005SP) Brooke State Police' 'WV00600'='(WV00600) Cabell'
                  'WV00601'='(WV00601) Barboursville' 'WV00602'='(WV00602) Huntington'
                  'WV00603'='(WV00603) Milton' 'WV00604'='(WV00604) Marshall University'
                  'WV00605'='(WV00605) Dnr: Cabell County'
                  'WV00608'='(WV00608) Sfm: Cabell County'
                  'WV00610'='(WV00610) Huntington Drug & Vctf'
                  'WV006SP'='(WV006SP) Cabell State Police' 'WV00700'='(WV00700) Calhoun'
                  'WV00701'='(WV00701) Grantsville' 'WV00702'='(WV00702) Dnr: Calhoun County'
                  'WV00703'='(WV00703) Sfm: Calhoun County'
                  'WV007SP'='(WV007SP) Calhoun State Police' 'WV00800'='(WV00800) Clay'
                  'WV00801'='(WV00801) Clay' 'WV00802'='(WV00802) Dnr: Clay County'
                  'WV00803'='(WV00803) Sfm: Clay County' 'WV008SP'='(WV008SP) Clay State Police'
                  'WV00900'='(WV00900) Doddridge' 'WV00901'='(WV00901) West Union'
                  'WV00902'='(WV00902) Dnr: Doddridge County'
                  'WV00903'='(WV00903) Sfm: Doddridge County'
                  'WV009SP'='(WV009SP) Doddridge State Police' 'WV01000'='(WV01000) Fayette'
                  'WV01001'='(WV01001) Ansted' 'WV01002'='(WV01002) Fayetteville'
                  'WV01003'='(WV01003) Montgomery' 'WV01004'='(WV01004) Mount Hope'
                  'WV01005'='(WV01005) Oak Hill' 'WV01006'='(WV01006) Meadow Bridge'
                  'WV01007'='(WV01007) Smithers' 'WV01008'='(WV01008) Pax'
                  'WV01009'='(WV01009) West Virginia Tech'
                  'WV01010'='(WV01010) Dnr: Fayette County' 'WV01011'='(WV01011) Gauley Bridge'
                  'WV01015'='(WV01015) Sfm: Fayette County'
                  'WV010SP'='(WV010SP) Fayette State Police' 'WV01100'='(WV01100) Gilmer'
                  'WV01101'='(WV01101) Glenville' 'WV01102'='(WV01102) Glenville State College'
                  'WV01103'='(WV01103) Dnr: Gilmer County'
                  'WV01106'='(WV01106) Sfm: Gilmer County'
                  'WV011SP'='(WV011SP) Gilmer State Police' 'WV01200'='(WV01200) Grant'
                  'WV01201'='(WV01201) Petersburg' 'WV01202'='(WV01202) Dnr: Grant County'
                  'WV01203'='(WV01203) Bayard' 'WV01204'='(WV01204) Sfm: Grant County'
                  'WV012SP'='(WV012SP) Grant State Police' 'WV01300'='(WV01300) Greenbrier'
                  'WV01301'='(WV01301) Lewisburg' 'WV01302'='(WV01302) Rainelle'
                  'WV01303'='(WV01303) Ronceverte' 'WV01304'='(WV01304) White Sulphur Springs'
                  'WV01305'='(WV01305) Quinwood' 'WV01306'='(WV01306) Dnr: Greenbrier County'
                  'WV01307'='(WV01307) Rupert' 'WV01310'='(WV01310) Sfm: Greenbrier County'
                  'WV01311'='(WV01311) Greenbrier Cnty D&vctf'
                  'WV013SP'='(WV013SP) Greenbrier State Police' 'WV01400'='(WV01400) Hampshire'
                  'WV01401'='(WV01401) Romney' 'WV01402'='(WV01402) Dnr: Hampshire County'
                  'WV01405'='(WV01405) Capon Bridge' 'WV01406'='(WV01406) Sfm: Hampshire County'
                  'WV014SP'='(WV014SP) Hampshire State Police' 'WV01500'='(WV01500) Hancock'
                  'WV01501'='(WV01501) Chester' 'WV01502'='(WV01502) Weirton'
                  'WV01503'='(WV01503) New Cumberland' 'WV01504'='(WV01504) Dnr: Hancock County'
                  'WV01505'='(WV01505) Sfm: Hancock County'
                  'WV01507'='(WV01507) Hancock/Brooke/Wrtn Dtf'
                  'WV015SP'='(WV015SP) Hancock State Police' 'WV01600'='(WV01600) Hardy'
                  'WV01601'='(WV01601) Moorefield' 'WV01602'='(WV01602) Wardensville'
                  'WV01603'='(WV01603) Dnr: Hardy County' 'WV01606'='(WV01606) Sfm: Hardy County'
                  'WV016SP'='(WV016SP) Hardy State Police' 'WV01700'='(WV01700) Harrison'
                  'WV01701'='(WV01701) Bridgeport' 'WV01702'='(WV01702) Clarksburg'
                  'WV01703'='(WV01703) Salem' 'WV01704'='(WV01704) Shinnston'
                  'WV01705'='(WV01705) Stonewood' 'WV01706'='(WV01706) Anmoore'
                  'WV01707'='(WV01707) Nutter Fort' 'WV01708'='(WV01708) Lumberport'
                  'WV01709'='(WV01709) Lost Creek' 'WV01710'='(WV01710) West Milford'
                  'WV01711'='(WV01711) Dnr: Harrison County'
                  'WV01712'='(WV01712) Sfm: Harrison County'
                  'WV01714'='(WV01714) Harrison Co Drug & Vctf'
                  'WV017SP'='(WV017SP) Harrison State Police' 'WV01800'='(WV01800) Jackson'
                  'WV01801'='(WV01801) Ravenswood' 'WV01802'='(WV01802) Ripley'
                  'WV01803'='(WV01803) Dnr: Jackson County'
                  'WV01805'='(WV01805) Sfm: Jackson County'
                  'WV018SP'='(WV018SP) Jackson State Police' 'WV01900'='(WV01900) Jefferson'
                  'WV01901'='(WV01901) Charles Town' 'WV01902'='(WV01902) Shepherdstown'
                  'WV01903'='(WV01903) Ranson' 'WV01904'='(WV01904) Harpers Ferry/Bolivar'
                  'WV01905'='(WV01905) Dnr: Jefferson County'
                  'WV01907'='(WV01907) Shepherd University'
                  'WV01908'='(WV01908) Sfm: Jefferson County'
                  'WV019SP'='(WV019SP) Jefferson State Police' 'WV02000'='(WV02000) Kanawha'
                  'WV02001'='(WV02001) Belle' 'WV02002'='(WV02002) Charleston' 'WV02003'='(WV02003) Dunbar'
                  'WV02004'='(WV02004) Nitro' 'WV02005'='(WV02005) St. Albans'
                  'WV02006'='(WV02006) South Charleston' 'WV02007'='(WV02007) Chesapeake'
                  'WV02008'='(WV02008) Marmet' 'WV02011'='(WV02011) East Bank'
                  'WV02013'='(WV02013) Glasgow' 'WV02014'='(WV02014) Clendenin'
                  'WV02016'='(WV02016) Cedar Grove' 'WV02017'='(WV02017) Pratt'
                  'WV02018'='(WV02018) Handley' 'WV02020'='(WV02020) West Va State University'
                  'WV02021'='(WV02021) Dnr: Kanawha County'
                  'WV02022'='(WV02022) Sfm: Kanawha County'
                  'WV02027'='(WV02027) Kanawha Cnty Parks & Rec'
                  'WV02034'='(WV02034) Capitol Protective Srvcs'
                  'WV02036'='(WV02036) Metro Drug Enforce Net T'
                  'WV020SP'='(WV020SP) Kanawha State Police' 'WV02100'='(WV02100) Lewis'
                  'WV02101'='(WV02101) Weston' 'WV02102'='(WV02102) Dnr: Lewis County'
                  'WV02103'='(WV02103) Sfm: Lewis County'
                  'WV021SP'='(WV021SP) lewis State Police' 'WV02200'='(WV02200) Lincoln'
                  'WV02201'='(WV02201) Hamlin' 'WV02202'='(WV02202) Dnr: Lincoln County'
                  'WV02205'='(WV02205) Sfm: Lincoln County'
                  'WV022SP'='(WV022SP) Lincoln State Police' 'WV02300'='(WV02300) Logan'
                  'WV02301'='(WV02301) Logan' 'WV02302'='(WV02302) Man' 'WV02303'='(WV02303) Chapmanville'
                  'WV02304'='(WV02304) Dnr: Logan County' 'WV02305'='(WV02305) West Logan'
                  'WV02306'='(WV02306) Mitchell Heights' 'WV02308'='(WV02308) Sfm: Logan County'
                  'WV02309'='(WV02309) Logan Cnty Drug & V c Tf'
                  'WV023SP'='(WV023SP) Logan State Police' 'WV02400'='(WV02400) Mcdowell'
                  'WV02401'='(WV02401) Keystone' 'WV02402'='(WV02402) War' 'WV02403'='(WV02403) Welch'
                  'WV02404'='(WV02404) Anawalt' 'WV02405'='(WV02405) Gary' 'WV02406'='(WV02406) Northfork'
                  'WV02407'='(WV02407) Davy' 'WV02408'='(WV02408) Kimball' 'WV02409'='(WV02409) Iaeger'
                  'WV02410'='(WV02410) Dnr: Mcdowell County'
                  'WV02411'='(WV02411) Sfm: Mcdowell County' 'WV02412'='(WV02412) Bradshaw'
                  'WV024SP'='(WV024SP) Mcdowell State Police' 'WV02500'='(WV02500) Marion'
                  'WV02501'='(WV02501) Fairmont' 'WV02502'='(WV02502) Mannington'
                  'WV02503'='(WV02503) Rivesville' 'WV02504'='(WV02504) Monongah'
                  'WV02505'='(WV02505) Fairview' 'WV02506'='(WV02506) Farmington'
                  'WV02507'='(WV02507) Grant Town' 'WV02508'='(WV02508) Worthington'
                  'WV02509'='(WV02509) Dnr: Marion County' 'WV02511'='(WV02511) Barrackville'
                  'WV02514'='(WV02514) Fairmont State Universit'
                  'WV02515'='(WV02515) Sfm: Marion County'
                  'WV02516'='(WV02516) Three Rivers Drug & Vctf'
                  'WV025SP'='(WV025SP) Marion State Police' 'WV02600'='(WV02600) Marshall'
                  'WV02601'='(WV02601) Benwood' 'WV02602'='(WV02602) Cameron'
                  'WV02603'='(WV02603) Glen Dale' 'WV02604'='(WV02604) Mcmechen'
                  'WV02605'='(WV02605) Moundsville' 'WV02606'='(WV02606) Dnr: Marshall County'
                  'WV02610'='(WV02610) Grave Creek Mound S park'
                  'WV026SP'='(WV026SP) Marshall State Police' 'WV02700'='(WV02700) Mason'
                  'WV02701'='(WV02701) Point Pleasant' 'WV02702'='(WV02702) New Haven'
                  'WV02703'='(WV02703) Mason' 'WV02704'='(WV02704) Henderson'
                  'WV02705'='(WV02705) Hartford City' 'WV02706'='(WV02706) Leon'
                  'WV02707'='(WV02707) Dnr: Mason County' 'WV02713'='(WV02713) Sfm: Mason County'
                  'WV027SP'='(WV027SP) Mason State Police' 'WV02800'='(WV02800) Mercer'
                  'WV02801'='(WV02801) Athens' 'WV02802'='(WV02802) Bluefield'
                  'WV02803'='(WV02803) Princeton' 'WV02804'='(WV02804) Matoaka'
                  'WV02805'='(WV02805) Bramwell' 'WV02806'='(WV02806) Concord University'
                  'WV02807'='(WV02807) Bluefield State College'
                  'WV02808'='(WV02808) Dnr: Mercer County'
                  'WV02812'='(WV02812) Sfm: Mercer County'
                  'WV02813'='(WV02813) Southern Reg Drug & Vctf'
                  'WV028SP'='(WV028SP) Mercer State Police' 'WV02900'='(WV02900) Mineral'
                  'WV02901'='(WV02901) Keyser' 'WV02902'='(WV02902) Piedmont'
                  'WV02903'='(WV02903) Ridgeley' 'WV02904'='(WV02904) Elk Garden'
                  'WV02905'='(WV02905) Potomac State College'
                  'WV02906'='(WV02906) Dnr: Mineral County'
                  'WV02907'='(WV02907) Sfm: Mineral County'
                  'WV029SP'='(WV029SP) Mineral State Police' 'WV03000'='(WV03000) Mingo'
                  'WV03001'='(WV03001) Gilbert' 'WV03002'='(WV03002) Williamson'
                  'WV03003'='(WV03003) Kermit' 'WV03004'='(WV03004) Delbarton'
                  'WV03005'='(WV03005) Matewan' 'WV03006'='(WV03006) Dnr: Mingo County'
                  'WV03009'='(WV03009) Sfm: Mingo County'
                  'WV030SP'='(WV030SP) Mingo State Police' 'WV03100'='(WV03100) Monongalia'
                  'WV03101'='(WV03101) Morgantown' 'WV03103'='(WV03103) Star City'
                  'WV03104'='(WV03104) Westover' 'WV03105'='(WV03105) Osage'
                  'WV03106'='(WV03106) West Virginia University'
                  'WV03107'='(WV03107) Dnr: Monongalia County' 'WV03109'='(WV03109) Granville'
                  'WV03113'='(WV03113) Sfm: Monongalia County'
                  'WV03114'='(WV03114) Mon Valley Drug Task For'
                  'WV031SP'='(WV031SP) Monongalia State Police' 'WV03200'='(WV03200) Monroe'
                  'WV03201'='(WV03201) Alderson' 'WV03202'='(WV03202) Union'
                  'WV03203'='(WV03203) Peterstown' 'WV03204'='(WV03204) Dnr: Monroe County'
                  'WV03208'='(WV03208) Sfm: Monroe County'
                  'WV032SP'='(WV032SP) Monroe State Police' 'WV03300'='(WV03300) Morgan'
                  'WV03301'='(WV03301) Berkeley Springs' 'WV03302'='(WV03302) Paw Paw'
                  'WV03303'='(WV03303) Dnr: Morgan County'
                  'WV033SP'='(WV033SP) Morgan State Police' 'WV03400'='(WV03400) Nicholas'
                  'WV03401'='(WV03401) Richwood' 'WV03402'='(WV03402) Summersville'
                  'WV03403'='(WV03403) Dnr: Nicholas County'
                  'WV03404'='(WV03404) Sfm: Nicholas County'
                  'WV03408'='(WV03408) Central Wv Drug Task For'
                  'WV034SP'='(WV034SP) Nicholas State Police' 'WV03500'='(WV03500) Ohio'
                  'WV03501'='(WV03501) Wheeling' 'WV03502'='(WV03502) Triadelphia'
                  'WV03503'='(WV03503) Bethlehem' 'WV03504'='(WV03504) West Liberty'
                  'WV03505'='(WV03505) Valley Grove'
                  'WV03506'='(WV03506) West Liberty State Colle'
                  'WV03507'='(WV03507) Dnr: Ohio County' 'WV03508'='(WV03508) Clearview'
                  'WV03509'='(WV03509) Sfm: Ohio County'
                  'WV03510'='(WV03510) Ohio Valley Drug & Vctf'
                  'WV035SP'='(WV035SP) Ohio State Police' 'WV03600'='(WV03600) Pendleton'
                  'WV03601'='(WV03601) Franklin' 'WV03602'='(WV03602) Dnr: Pendleton County'
                  'WV03604'='(WV03604) Sfm: Pendleton County'
                  'WV036SP'='(WV036SP) Pendleton State Police' 'WV03700'='(WV03700) Pleasants'
                  'WV03701'='(WV03701) St. Marys' 'WV03702'='(WV03702) Dnr: Pleasants County'
                  'WV03705'='(WV03705) Sfm: Pleasants County'
                  'WV037SP'='(WV037SP) Pleasants State Police' 'WV03800'='(WV03800) Pocahontas'
                  'WV03801'='(WV03801) Marlinton' 'WV03802'='(WV03802) Dnr: Pocahontas County'
                  'WV03808'='(WV03808) Durbin' 'WV03809'='(WV03809) Sfm: Pocahontas County'
                  'WV038SP'='(WV038SP) Pocahontas State Police' 'WV03900'='(WV03900) Preston'
                  'WV03901'='(WV03901) Kingwood' 'WV03902'='(WV03902) Terra Alta'
                  'WV03903'='(WV03903) Rowlesburg' 'WV03904'='(WV03904) Masontown'
                  'WV03905'='(WV03905) Newburg' 'WV03906'='(WV03906) Tunnelton'
                  'WV03907'='(WV03907) Reedsville' 'WV03908'='(WV03908) Dnr: Preston County'
                  'WV03909'='(WV03909) Sfm: Preston County' 'WV03911'='(WV03911) Albright'
                  'WV039SP'='(WV039SP) Preston State Police' 'WV04000'='(WV04000) Putnam'
                  'WV04001'='(WV04001) Hurricane' 'WV04002'='(WV04002) Winfield'
                  'WV04003'='(WV04003) Eleanor' 'WV04004'='(WV04004) Poca' 'WV04005'='(WV04005) Bancroft'
                  'WV04006'='(WV04006) Dnr: Putnam County'
                  'WV04008'='(WV04008) Sfm: Putnam County'
                  'WV040SP'='(WV040SP) Putnam State Police' 'WV04100'='(WV04100) Raleigh'
                  'WV04101'='(WV04101) Beckley' 'WV04102'='(WV04102) Lester' 'WV04103'='(WV04103) Mabscott'
                  'WV04104'='(WV04104) Sophia' 'WV04105'='(WV04105) Rhodell'
                  'WV04106'='(WV04106) Dnr: Raleigh County'
                  'WV04109'='(WV04109) Sfm: Raleigh County'
                  'WV04112'='(WV04112) Tri-Lateral Drug Enf Nt'
                  'WV041SP'='(WV041SP) Raleigh State Police' 'WV04200'='(WV04200) Randolph'
                  'WV04201'='(WV04201) Elkins' 'WV04202'='(WV04202) Mill Creek'
                  'WV04203'='(WV04203) Dnr: Randolph County'
                  'WV04210'='(WV04210) Sfm: Randolph County'
                  'WV042SP'='(WV042SP) Randolph State Police' 'WV04300'='(WV04300) Ritchie'
                  'WV04301'='(WV04301) Harrisville' 'WV04302'='(WV04302) Pennsboro'
                  'WV04303'='(WV04303) Cairo' 'WV04304'='(WV04304) Dnr: Ritchie County'
                  'WV04307'='(WV04307) Sfm: Ritchie County'
                  'WV043SP'='(WV043SP) Ritchie State Police' 'WV04400'='(WV04400) Roane'
                  'WV04401'='(WV04401) Spencer' 'WV04402'='(WV04402) Dnr: Roane County'
                  'WV04403'='(WV04403) Sfm: Roane County'
                  'WV044SP'='(WV044SP) Roane State Police' 'WV04500'='(WV04500) Summers'
                  'WV04501'='(WV04501) Hinton' 'WV04502'='(WV04502) Dnr: Summers County'
                  'WV04507'='(WV04507) Sfm: Summers County'
                  'WV045SP'='(WV045SP) Summers State Police' 'WV04600'='(WV04600) Taylor'
                  'WV04601'='(WV04601) Grafton' 'WV04602'='(WV04602) Flemington'
                  'WV04603'='(WV04603) Dnr: Taylor County'
                  'WV04607'='(WV04607) Sfm: Taylor County'
                  'WV046SP'='(WV046SP) Taylor State Police' 'WV04700'='(WV04700) Tucker'
                  'WV04701'='(WV04701) Parsons' 'WV04702'='(WV04702) Thomas'
                  'WV04703'='(WV04703) Dnr: Tucker County' 'WV04704'='(WV04704) Davis'
                  'WV04705'='(WV04705) Hambleton' 'WV04709'='(WV04709) Sfm: Tucker County'
                  'WV047SP'='(WV047SP) Tucker State Police' 'WV04800'='(WV04800) Tyler'
                  'WV04801'='(WV04801) Paden City' 'WV04802'='(WV04802) Sistersville'
                  'WV04803'='(WV04803) Middlebourne' 'WV04804'='(WV04804) Friendly'
                  'WV04805'='(WV04805) Dnr: Tyler County' 'WV04806'='(WV04806) Sfm: Tyler County'
                  'WV048SP'='(WV048SP) Tyler State Police' 'WV04900'='(WV04900) Upshur'
                  'WV04901'='(WV04901) Buckhannon' 'WV04902'='(WV04902) Dnr: Upshur County'
                  'WV04904'='(WV04904) Sfm: Upshur County'
                  'WV049SP'='(WV049SP) Upshur State Police' 'WV05000'='(WV05000) Wayne'
                  'WV05001'='(WV05001) Ceredo' 'WV05002'='(WV05002) Kenova' 'WV05003'='(WV05003) Wayne'
                  'WV05004'='(WV05004) Fort Gay' 'WV05005'='(WV05005) Dnr: Wayne County'
                  'WV05009'='(WV05009) Sfm: Wayne County'
                  'WV050SP'='(WV050SP) Wayne State Police' 'WV05100'='(WV05100) Webster'
                  'WV05101'='(WV05101) Webster Springs' 'WV05102'='(WV05102) Cowen'
                  'WV05103'='(WV05103) Camden-On-Gauley'
                  'WV05104'='(WV05104) Dnr: Webster County'
                  'WV05108'='(WV05108) Sfm: Webster County'
                  'WV051SP'='(WV051SP) Webster State Police' 'WV05200'='(WV05200) Wetzel'
                  'WV05201'='(WV05201) Hundred' 'WV05202'='(WV05202) New Martinsville'
                  'WV05204'='(WV05204) Pine Grove' 'WV05205'='(WV05205) Littleton'
                  'WV05206'='(WV05206) Smithfield' 'WV05207'='(WV05207) Dnr: Wetzel County'
                  'WV05208'='(WV05208) Sfm: Wetzel County'
                  'WV052SP'='(WV052SP) Wetzel State Police' 'WV05300'='(WV05300) Wirt'
                  'WV05301'='(WV05301) Elizabeth' 'WV05302'='(WV05302) Dnr: Wirt County'
                  'WV05303'='(WV05303) Sfm: Wirt County' 'WV053SP'='(WV053SP) Wirt State Police'
                  'WV05400'='(WV05400) Wood' 'WV05401'='(WV05401) Parkersburg' 'WV05402'='(WV05402) Vienna'
                  'WV05403'='(WV05403) Williamstown' 'WV05404'='(WV05404) Dnr: Wood County'
                  'WV05405'='(WV05405) Sfm: Wood County'
                  'WV05408'='(WV05408) Parkersburg Nar & Vctf'
                  'WV054SP'='(WV054SP) Wood State Police' 'WV05500'='(WV05500) Wyoming'
                  'WV05501'='(WV05501) Mullens' 'WV05502'='(WV05502) Pineville'
                  'WV05503'='(WV05503) Oceana' 'WV05504'='(WV05504) Dnr: Wyoming County'
                  'WV05505'='(WV05505) Sfm: Wyoming County'
                  'WV055SP'='(WV055SP) Wyoming State Police' 'WVWSP00'='(WVWSP00) State Police'
                  'WVWSP01'='(WVWSP01) Sp: Beckley' 'WVWSP02'='(WVWSP02) Sp: Berkeley Springs'
                  'WVWSP04'='(WVWSP04) Sp: Buckhannon' 'WVWSP05'='(WVWSP05) Sp: Kearneysville'
                  'WVWSP06'='(WVWSP06) Sp: Quincy' 'WVWSP07'='(WVWSP07) Sp: Bridgeport'
                  'WVWSP08'='(WVWSP08) Sp: Clay' 'WVWSP09'='(WVWSP09) Sp: Elizabeth'
                  'WVWSP10'='(WVWSP10) Sp: Elkins' 'WVWSP11'='(WVWSP11) Sp: Fairmont'
                  'WVWSP12'='(WVWSP12) Sp: Franklin' 'WVWSP13'='(WVWSP13) Sp: Glenville'
                  'WVWSP14'='(WVWSP14) Sp: Grafton' 'WVWSP15'='(WVWSP15) Sp: Grantsville'
                  'WVWSP16'='(WVWSP16) Sp: Hamlin' 'WVWSP17'='(WVWSP17) Sp: Harrisville'
                  'WVWSP18'='(WVWSP18) Sp: Hinton' 'WVWSP19'='(WVWSP19) Sp: Huntington'
                  'WVWSP20'='(WVWSP20) Sp: Keyser' 'WVWSP21'='(WVWSP21) Sp: Kingwood'
                  'WVWSP22'='(WVWSP22) Sp: Lewisburg' 'WVWSP23'='(WVWSP23) Sp: Logan'
                  'WVWSP24'='(WVWSP24) Sp: Danville' 'WVWSP25'='(WVWSP25) Sp: Buckeye'
                  'WVWSP26'='(WVWSP26) Sp: Martinsburg' 'WVWSP27'='(WVWSP27) Sp: Gauley Bridge'
                  'WVWSP28'='(WVWSP28) Sp: Moorefield' 'WVWSP29'='(WVWSP29) Sp: Morgantown'
                  'WVWSP30'='(WVWSP30) Sp: Moundsville' 'WVWSP31'='(WVWSP31) Sp: Oak Hill'
                  'WVWSP32'='(WVWSP32) Sp: Paden City' 'WVWSP33'='(WVWSP33) Sp: Parkersburg'
                  'WVWSP34'='(WVWSP34) Sp: Parsons' 'WVWSP35'='(WVWSP35) Sp: Petersburg'
                  'WVWSP36'='(WVWSP36) Sp: Philippi' 'WVWSP37'='(WVWSP37) Sp: Jesse'
                  'WVWSP38'='(WVWSP38) Sp: Point Pleasant' 'WVWSP39'='(WVWSP39) Sp: Princeton'
                  'WVWSP40'='(WVWSP40) Sp: Rainelle' 'WVWSP41'='(WVWSP41) Sp: Richwood'
                  'WVWSP42'='(WVWSP42) Sp: Ripley' 'WVWSP43'='(WVWSP43) Sp: Romney'
                  'WVWSP44'='(WVWSP44) Sp: St. Marys' 'WVWSP46'='(WVWSP46) Sp: South Charleston'
                  'WVWSP47'='(WVWSP47) Sp: Spencer' 'WVWSP48'='(WVWSP48) Sp: Summersville'
                  'WVWSP49'='(WVWSP49) Sp: Sutton' 'WVWSP50'='(WVWSP50) Sp: Wheeling'
                  'WVWSP51'='(WVWSP51) Sp: Union' 'WVWSP52'='(WVWSP52) Sp: Wayne'
                  'WVWSP53'='(WVWSP53) Sp: Upperglade' 'WVWSP55'='(WVWSP55) Sp: Welch'
                  'WVWSP56'='(WVWSP56) Sp: Wellsburg' 'WVWSP57'='(WVWSP57) Sp: Weston'
                  'WVWSP58'='(WVWSP58) Sp: West Union' 'WVWSP59'='(WVWSP59) Sp: Whitesville'
                  'WVWSP60'='(WVWSP60) Sp: Williamson' 'WVWSP61'='(WVWSP61) Sp: Winfield'
                  'WVWSP62'='(WVWSP62) Sp, Pkwy Auth:Kanawha Co'
                  'WVWSP65'='(WVWSP65) Sp: Hundred' 'WVWSP66'='(WVWSP66) Sp: New Cumberland'
                  'WVWSP67'='(WVWSP67) Sp, Pkwy Auth: Mercer Co'
                  'WVWSP68'='(WVWSP68) Sp, Pkwy Auth:Fayette Co'
                  'WVWSP69'='(WVWSP69) Sp, Pkwy Auth:Raleigh Co'
                  'WVWSP70'='(WVWSP70) Sp: Gilbert' 'WVWSP80'='(WVWSP80) Sp: Teays Valley'
                  'WVWSP85'='(WVWSP85) Sp Bci: Charleston' 'WVWSP86'='(WVWSP86) Sp Bci: Fairmont'
                  'WVWSP88'='(WVWSP88) Sp Bci: Beckley' 'WVWSP90'='(WVWSP90) Sp Bci: Buckhannon'
                  'WY00100'='(WY00100) Albany' 'WY00101'='(WY00101) Laramie'
                  'WY00102'='(WY00102) University Of Wyoming' 'WY00200'='(WY00200) Big Horn'
                  'WY00201'='(WY00201) Basin' 'WY00202'='(WY00202) Lovell' 'WY00203'='(WY00203) Greybull'
                  'WY00300'='(WY00300) Campbell' 'WY00301'='(WY00301) Gillette'
                  'WY00400'='(WY00400) Carbon' 'WY00401'='(WY00401) Rawlins' 'WY00402'='(WY00402) Saratoga'
                  'WY00403'='(WY00403) Medicine Bow' 'WY00405'='(WY00405) Hanna'
                  'WY00406'='(WY00406) Baggs' 'WY00408'='(WY00408) Encampment'
                  'WY00500'='(WY00500) Converse' 'WY00501'='(WY00501) Douglas'
                  'WY00502'='(WY00502) Glenrock' 'WY00600'='(WY00600) Crook' 'WY00601'='(WY00601) Sundance'
                  'WY00602'='(WY00602) Hulett' 'WY00603'='(WY00603) Moorcroft'
                  'WY00700'='(WY00700) Fremont' 'WY00701'='(WY00701) Lander' 'WY00702'='(WY00702) Riverton'
                  'WY00704'='(WY00704) Shoshoni' 'WY00705'='(WY00705) Dubois' 'WY00800'='(WY00800) Goshen'
                  'WY00801'='(WY00801) Torrington' 'WY00900'='(WY00900) Hot Springs'
                  'WY00901'='(WY00901) Thermopolis' 'WY00903'='(WY00903) Hot Springs State Park'
                  'WY01000'='(WY01000) Johnson' 'WY01001'='(WY01001) Buffalo' 'WY01100'='(WY01100) Laramie'
                  'WY01101'='(WY01101) Cheyenne' 'WY01102'='(WY01102) Pine Bluffs'
                  'WY01200'='(WY01200) Lincoln' 'WY01201'='(WY01201) Afton' 'WY01202'='(WY01202) Kemmerer'
                  'WY01203'='(WY01203) Diamondville' 'WY01204'='(WY01204) La Barge'
                  'WY01205'='(WY01205) Thayne' 'WY01206'='(WY01206) Cokeville'
                  'WY01300'='(WY01300) Natrona' 'WY01301'='(WY01301) Casper' 'WY01302'='(WY01302) Mills'
                  'WY01304'='(WY01304) Evansville' 'WY01400'='(WY01400) Niobrara'
                  'WY01401'='(WY01401) Lusk' 'WY01500'='(WY01500) Park' 'WY01501'='(WY01501) Cody'
                  'WY01502'='(WY01502) Powell' 'WY01600'='(WY01600) Platte' 'WY01601'='(WY01601) Wheatland'
                  'WY01602'='(WY01602) Guernsey' 'WY01700'='(WY01700) Sheridan'
                  'WY01701'='(WY01701) Sheridan' 'WY01704'='(WY01704) Sheridan College'
                  'WY01800'='(WY01800) Sublette' 'WY01801'='(WY01801) Pinedale'
                  'WY01802'='(WY01802) Big Piney' 'WY01803'='(WY01803) Marbleton'
                  'WY01900'='(WY01900) Sweetwater' 'WY01901'='(WY01901) Green River'
                  'WY01902'='(WY01902) Rock Springs' 'WY01905'='(WY01905) Wamsutter'
                  'WY02000'='(WY02000) Teton' 'WY02001'='(WY02001) Jackson' 'WY02100'='(WY02100) Uinta'
                  'WY02101'='(WY02101) Evanston' 'WY02103'='(WY02103) Lyman' 'WY02200'='(WY02200) Washakie'
                  'WY02201'='(WY02201) Worland' 'WY02300'='(WY02300) Weston'
                  'WY02301'='(WY02301) Newcastle' 'WY02302'='(WY02302) Upton'
                  'WYWHP00'='(WYWHP00) Wyoming Highway Patrol' ;
  VALUE $v4fffff  '0'='(0) Possessions' '1'='(1) ALL cit 250,000 +'
                  '2'='(2) Cit 100,000-249,999' '3'='(3) Cit 50,000-99,999'
                  '4'='(4) Cit 25,000-49,999' '5'='(5) Cit 10,000-24,999'
                  '6'='(6) Cit 2,500-9,999' '7'='(7) Cit < 2,500' '8'='(8) Non-MSA co.'
                  '9'='(9) MSA counties' '1A'='(1A) Cit 1,000,000 +'
                  '1B'='(1B) Cit 500,000-999,999' '1C'='(1C) Cit 250,000-499,999'
                  '8A'='(8A) Non-MSA co. 100,000 +'
                  '8B'='(8B) Non-MSA co. 25,000-99,999'
                  '8C'='(8C) Non-MSA co. 10,000-24,999'
                  '8D'='(8D) Non-MSA co. < 10,000' '8E'='(8E) Non-MSA St Police'
                  '9A'='(9A) MSA co. 100,000 +' '9B'='(9B) MSA co. 25,000-99,999'
                  '9C'='(9C) MSA co. 10,000-24,999' '9D'='(9D) MSA co. < 10,000'
                  '9E'='(9E) MSA St Police' ;
  VALUE v5ffffff  0='(0) Possessions' 1='(1) New Eng1and States'
                  2='(2) Middle Atlantic States' 3='(3) East North Central States'
                  4='(4) West North Central States' 5='(5) South Atlantic States'
                  6='(6) East South Central States' 7='(7) West South Central States'
                  8='(8) Mountain States' 9='(9) Pacific States' ;
  VALUE $v8fffff  'N'='(N) No, not core city of MSA' 'Y'='(Y) Yes, core city of MSA' ;
  VALUE v12fffff  0='(0) No months reported' 1='(1) Jan last reported'
                  2='(2) Feb last reported' 3='(3) March last reported'
                  4='(4) April last reported' 5='(5) May last reported'
                  6='(6) June last reported' 7='(7) July last reported'
                  8='(8) August last reported' 9='(9) Sep last reported'
                  10='(10) Oct last reported' 11='(11) Nov last reported'
                  12='(12) Dec last reported' ;
  VALUE v13fffff  0='(0) US Park & State Police' 1='(1) All other agencies' ;
  VALUE $v23ffff  'N'='(N) No, do not send a follow-up'
                  'Y'='(Y) Yes, send a follow-up' ;
  VALUE v24fffff  0='(0) Not special mail group agency'
                  1='(1) Return sent to another agency'
                  2='(2) Small city sent a large city form'
                  7='(7) Agency-non-contributor, not sent form'
                  9='(9) Agency-contributor, not on mail list' ;
  VALUE $v25ffff  'N'='(N) Not a special mailing address'
                  'Y'='(Y) Special mailing address' ;
  VALUE v33fffff  0='(0) Jan not w oth month' 1='(1) Reported with Jan'
                  2='(2) Reported with Feb' 3='(3) Reported with Mar'
                  4='(4) Reported with Apr' 5='(5) Reported with May'
                  6='(6) Reported with Jun' 7='(7) Reported with Jul'
                  8='(8) Reported with Aug' 9='(9) Reported with Sep'
                  10='(10) Reported with Oct' 11='(11) Reported with Nov'
                  12='(12) Reported with Dec' ;
  VALUE v34fffff  0='(0) Not updated' ;
  VALUE v35fffff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE v36fffff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE v37fffff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE v38fffff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE v39fffff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE $v40ffff  '0'='(0) Missing' ''''='No return received'
                  'P'='(P) Breakdown offenses' 'T'='(T) Totals only' ;
  VALUE $v41ffff  '0'='(0) Missing' ''''='No return received'
                  'P'='(P) Breakdown offenses' 'T'='(T) Totals only' ;
  VALUE $v42ffff  '0'='(0) Missing' ''''='No return received'
                  'P'='(P) Breakdown offenses' 'T'='(T) Totals only' ;
  VALUE $v43ffff  '0'='(0) Missing' ''''='No return received'
                  'P'='(P) Breakdown offenses' 'T'='(T) Totals only' ;
  VALUE v151ffff  0='(0) Feb not w oth month' 1='(1) Reported with Jan'
                  2='(2) Reported with Feb' 3='(3) Reported with Mar'
                  4='(4) Reported with Apr' 5='(5) Reported with May'
                  6='(6) Reported with Jun' 7='(7) Reported with Jul'
                  8='(8) Reported with Aug' 9='(9) Reported with Sep'
                  10='(10) Reported with Oct' 11='(11) Reported with Nov'
                  12='(12) Reported with Dec' ;
  VALUE v152ffff  0='(0) Not updated' ;
  VALUE v153ffff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE v154ffff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE v155ffff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE v156ffff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE v157ffff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE $v158fff  '0'='(0) Missing' ''''='No return received'
                  'P'='(P) Breakdown offenses' 'T'='(T) Totals only' ;
  VALUE $v159fff  '0'='(0) Missing' ''''='No return received'
                  'P'='(P) Breakdown offenses' 'T'='(T) Totals only' ;
  VALUE $v160fff  '0'='(0) Missing' ''''='No return received'
                  'P'='(P) Breakdown offenses' 'T'='(T) Totals only' ;
  VALUE $v161fff  '0'='(0) Missing' ''''='No return received'
                  'P'='(P) Breakdown offenses' 'T'='(T) Totals only' ;
  VALUE v269ffff  0='(0) Mar not w oth month' 1='(1) Reported with Jan'
                  2='(2) Reported with Feb' 3='(3) Reported with Mar'
                  4='(4) Reported with Apr' 5='(5) Reported with May'
                  6='(6) Reported with Jun' 7='(7) Reported with Jul'
                  8='(8) Reported with Aug' 9='(9) Reported with Sep'
                  10='(10) Reported with Oct' 11='(11) Reported with Nov'
                  12='(12) Reported with Dec' ;
  VALUE v270ffff  0='(0) Not updated' ;
  VALUE v271ffff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE v272ffff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE v273ffff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE v274ffff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE v275ffff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE $v276fff  '0'='(0) Missing' ''''='No return received'
                  'P'='(P) Breakdown offenses' 'T'='(T) Totals only' ;
  VALUE $v277fff  '0'='(0) Missing' ''''='No return received'
                  'P'='(P) Breakdown offenses' 'T'='(T) Totals only' ;
  VALUE $v278fff  '0'='(0) Missing' ''''='No return received'
                  'P'='(P) Breakdown offenses' 'T'='(T) Totals only' ;
  VALUE $v279fff  '0'='(0) Missing' ''''='No return received'
                  'P'='(P) Breakdown offenses' 'T'='(T) Totals only' ;
  VALUE v387ffff  0='(0) Apr not w oth month' 1='(1) Reported with Jan'
                  2='(2) Reported with Feb' 3='(3) Reported with Mar'
                  4='(4) Reported with Apr' 5='(5) Reported with May'
                  6='(6) Reported with Jun' 7='(7) Reported with Jul'
                  8='(8) Reported with Aug' 9='(9) Reported with Sep'
                  10='(10) Reported with Oct' 11='(11) Reported with Nov'
                  12='(12) Reported with Dec' ;
  VALUE v388ffff  0='(0) Not updated' ;
  VALUE v389ffff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE v390ffff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE v391ffff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE v392ffff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE v393ffff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE $v394fff  '0'='(0) Missing' ''''='No return received'
                  'P'='(P) Breakdown offenses' 'T'='(T) Totals only' ;
  VALUE $v395fff  '0'='(0) Missing' ''''='No return received'
                  'P'='(P) Breakdown offenses' 'T'='(T) Totals only' ;
  VALUE $v396fff  '0'='(0) Missing' ''''='No return received'
                  'P'='(P) Breakdown offenses' 'T'='(T) Totals only' ;
  VALUE $v397fff  '0'='(0) Missing' ''''='No return received'
                  'P'='(P) Breakdown offenses' 'T'='(T) Totals only' ;
  VALUE v505ffff  0='(0) May not w oth month' 1='(1) Reported with Jan'
                  2='(2) Reported with Feb' 3='(3) Reported with Mar'
                  4='(4) Reported with Apr' 5='(5) Reported with May'
                  6='(6) Reported with Jun' 7='(7) Reported with Jul'
                  8='(8) Reported with Aug' 9='(9) Reported with Sep'
                  10='(10) Reported with Oct' 11='(11) Reported with Nov'
                  12='(12) Reported with Dec' ;
  VALUE v506ffff  0='(0) Not updated' ;
  VALUE v507ffff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE v508ffff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE v509ffff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE v510ffff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE v511ffff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE $v512fff  '0'='(0) Missing' ''''='No return received'
                  'P'='(P) Breakdown offenses' 'T'='(T) Totals only' ;
  VALUE $v513fff  '0'='(0) Missing' ''''='No return received'
                  'P'='(P) Breakdown offenses' 'T'='(T) Totals only' ;
  VALUE $v514fff  '0'='(0) Missing' ''''='No return received'
                  'P'='(P) Breakdown offenses' 'T'='(T) Totals only' ;
  VALUE $v515fff  '0'='(0) Missing' ''''='No return received'
                  'P'='(P) Breakdown offenses' 'T'='(T) Totals only' ;
  VALUE v623ffff  0='(0) June not w oth month' 1='(1) Reported with Jan'
                  2='(2) Reported with Feb' 3='(3) Reported with Mar'
                  4='(4) Reported with Apr' 5='(5) Reported with May'
                  6='(6) Reported with Jun' 7='(7) Reported with Jul'
                  8='(8) Reported with Aug' 9='(9) Reported with Sep'
                  10='(10) Reported with Oct' 11='(11) Reported with Nov'
                  12='(12) Reported with Dec' ;
  VALUE v624ffff  0='(0) Not updated' ;
  VALUE v625ffff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE v626ffff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE v627ffff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE v628ffff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE v629ffff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE $v630fff  '0'='(0) Missing' ''''='No return received'
                  'P'='(P) Breakdown offenses' 'T'='(T) Totals only' ;
  VALUE $v631fff  '0'='(0) Missing' ''''='No return received'
                  'P'='(P) Breakdown offenses' 'T'='(T) Totals only' ;
  VALUE $v632fff  '0'='(0) Missing' ''''='No return received'
                  'P'='(P) Breakdown offenses' 'T'='(T) Totals only' ;
  VALUE $v633fff  '0'='(0) Missing' ''''='No return received'
                  'P'='(P) Breakdown offenses' 'T'='(T) Totals only' ;
  VALUE v741ffff  0='(0) July not w oth month' 1='(1) Reported with Jan'
                  2='(2) Reported with Feb' 3='(3) Reported with Mar'
                  4='(4) Reported with Apr' 5='(5) Reported with May'
                  6='(6) Reported with Jun' 7='(7) Reported with Jul'
                  8='(8) Reported with Aug' 9='(9) Reported with Sep'
                  10='(10) Reported with Oct' 11='(11) Reported with Nov'
                  12='(12) Reported with Dec' ;
  VALUE v742ffff  0='(0) Not updated' ;
  VALUE v743ffff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE v744ffff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE v745ffff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE v746ffff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE v747ffff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE $v748fff  '0'='(0) Missing' ''''='No return received'
                  'P'='(P) Breakdown offenses' 'T'='(T) Totals only' ;
  VALUE $v749fff  '0'='(0) Missing' ''''='No return received'
                  'P'='(P) Breakdown offenses' 'T'='(T) Totals only' ;
  VALUE $v750fff  '0'='(0) Missing' ''''='No return received'
                  'P'='(P) Breakdown offenses' 'T'='(T) Totals only' ;
  VALUE $v751fff  '0'='(0) Missing' ''''='No return received'
                  'P'='(P) Breakdown offenses' 'T'='(T) Totals only' ;
  VALUE v859ffff  0='(0) Aug not w oth month' 1='(1) Reported with Jan'
                  2='(2) Reported with Feb' 3='(3) Reported with Mar'
                  4='(4) Reported with Apr' 5='(5) Reported with May'
                  6='(6) Reported with Jun' 7='(7) Reported with Jul'
                  8='(8) Reported with Aug' 9='(9) Reported with Sep'
                  10='(10) Reported with Oct' 11='(11) Reported with Nov'
                  12='(12) Reported with Dec' ;
  VALUE v860ffff  0='(0) Not updated' ;
  VALUE v861ffff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE v862ffff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE v863ffff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE v864ffff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE v865ffff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE $v866fff  '0'='(0) Missing' ''''='No return received'
                  'P'='(P) Breakdown offenses' 'T'='(T) Totals only' ;
  VALUE $v867fff  '0'='(0) Missing' ''''='No return received'
                  'P'='(P) Breakdown offenses' 'T'='(T) Totals only' ;
  VALUE $v868fff  '0'='(0) Missing' ''''='No return received'
                  'P'='(P) Breakdown offenses' 'T'='(T) Totals only' ;
  VALUE $v869fff  '0'='(0) Missing' ''''='No return received'
                  'P'='(P) Breakdown offenses' 'T'='(T) Totals only' ;
  VALUE v977ffff  0='(0) Sep not w oth month' 1='(1) Reported with Jan'
                  2='(2) Reported with Feb' 3='(3) Reported with Mar'
                  4='(4) Reported with Apr' 5='(5) Reported with May'
                  6='(6) Reported with Jun' 7='(7) Reported with Jul'
                  8='(8) Reported with Aug' 9='(9) Reported with Sep'
                  10='(10) Reported with Oct' 11='(11) Reported with Nov'
                  12='(12) Reported with Dec' ;
  VALUE v978ffff  0='(0) Not updated' ;
  VALUE v979ffff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE v980ffff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE v981ffff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE v982ffff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE v983ffff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE $v984fff  '0'='(0) Missing' ''''='No return received'
                  'P'='(P) Breakdown offenses' 'T'='(T) Totals only' ;
  VALUE $v985fff  '0'='(0) Missing' ''''='No return received'
                  'P'='(P) Breakdown offenses' 'T'='(T) Totals only' ;
  VALUE $v986fff  '0'='(0) Missing' ''''='No return received'
                  'P'='(P) Breakdown offenses' 'T'='(T) Totals only' ;
  VALUE $v987fff  '0'='(0) Missing' ''''='No return received'
                  'P'='(P) Breakdown offenses' 'T'='(T) Totals only' ;
  VALUE v1095fff  0='(0) Oct not w oth month' 1='(1) Reported with Jan'
                  2='(2) Reported with Feb' 3='(3) Reported with Mar'
                  4='(4) Reported with Apr' 5='(5) Reported with May'
                  6='(6) Reported with Jun' 7='(7) Reported with Jul'
                  8='(8) Reported with Aug' 9='(9) Reported with Sep'
                  10='(10) Reported with Oct' 11='(11) Reported with Nov'
                  12='(12) Reported with Dec' ;
  VALUE v1096fff  0='(0) Not updated' ;
  VALUE v1097fff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE v1098fff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE v1099fff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE v1100fff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE v1101fff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE $v1102ff  '0'='(0) Missing' ''''='No return received'
                  'P'='(P) Breakdown offenses' 'T'='(T) Totals only' ;
  VALUE $v1103ff  '0'='(0) Missing' ''''='No return received'
                  'P'='(P) Breakdown offenses' 'T'='(T) Totals only' ;
  VALUE $v1104ff  '0'='(0) Missing' ''''='No return received'
                  'P'='(P) Breakdown offenses' 'T'='(T) Totals only' ;
  VALUE $v1105ff  '0'='(0) Missing' ''''='No return received'
                  'P'='(P) Breakdown offenses' 'T'='(T) Totals only' ;
  VALUE v1213fff  0='(0) Nov not w oth month' 1='(1) Reported with Jan'
                  2='(2) Reported with Feb' 3='(3) Reported with Mar'
                  4='(4) Reported with Apr' 5='(5) Reported with May'
                  6='(6) Reported with Jun' 7='(7) Reported with Jul'
                  8='(8) Reported with Aug' 9='(9) Reported with Sep'
                  10='(10) Reported with Oct' 11='(11) Reported with Nov'
                  12='(12) Reported with Dec' ;
  VALUE v1214fff  0='(0) Not updated' ;
  VALUE v1215fff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE v1216fff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE v1217fff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE v1218fff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE v1219fff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE $v1220ff  '0'='(0) Missing' ''''='No return received'
                  'P'='(P) Breakdown offenses' 'T'='(T) Totals only' ;
  VALUE $v1221ff  '0'='(0) Missing' ''''='No return received'
                  'P'='(P) Breakdown offenses' 'T'='(T) Totals only' ;
  VALUE $v1222ff  '0'='(0) Missing' ''''='No return received'
                  'P'='(P) Breakdown offenses' 'T'='(T) Totals only' ;
  VALUE $v1223ff  '0'='(0) Missing' ''''='No return received'
                  'P'='(P) Breakdown offenses' 'T'='(T) Totals only' ;
  VALUE v1331fff  0='(0) Dec not w oth month' 1='(1) Reported with Jan'
                  2='(2) Reported with Feb' 3='(3) Reported with Mar'
                  4='(4) Reported with Apr' 5='(5) Reported with May'
                  6='(6) Reported with Jun' 7='(7) Reported with Jul'
                  8='(8) Reported with Aug' 9='(9) Reported with Sep'
                  10='(10) Reported with Oct' 11='(11) Reported with Nov'
                  12='(12) Reported with Dec' ;
  VALUE v1332fff  0='(0) Not updated' ;
  VALUE v1333fff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE v1334fff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE v1335fff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE v1336fff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE v1337fff  0='(0) Not updated' 2='(2) Adjustment' 4='(4) Not available'
                  5='(5) Normal return' ;
  VALUE $v1338ff  '0'='(0) Missing' ''''='No return received'
                  'P'='(P) Breakdown offenses' 'T'='(T) Totals only' ;
  VALUE $v1339ff  '0'='(0) Missing' ''''='No return received'
                  'P'='(P) Breakdown offenses' 'T'='(T) Totals only' ;
  VALUE $v1340ff  '0'='(0) Missing' ''''='No return received'
                  'P'='(P) Breakdown offenses' 'T'='(T) Totals only' ;
  VALUE $v1341ff  '0'='(0) Missing' ''''='No return received'
                  'P'='(P) Breakdown offenses' 'T'='(T) Totals only' ;
*/


* SAS DATA, INFILE, INPUT STATEMENTS;

DATA;
INFILE "data-filename" LRECL=3643;
INPUT
        V1 1                    V2 2-3
        V3 $4-10                V4 $11-12               V5 13
        V6 14-17                V7 18-22                V8 $23
        V9 $24-30               V10 31-38               V11 39-42
        V12 43-44               V13 45                  V14 46-52
        V15 53-55               V16 56-58               V17 59-63
        V18 64-66               V19 67-69               V20 70-74
        V21 75-77               V22 78-80               V23 $81
        V24 82                  V25 $83                 V26 $84-107
        V27 $108-113            V28 $114-143            V29 $144-173
        V30 $174-203            V31 $204-233            V32 234-238
        V33 239-240             V34 241-248             V35 249-250
        V36 251-252             V37 253-254             V38 255-256
        V39 257-258             V40 $259                V41 $260
        V42 $261                V43 $262                V44 263
        V45 264                 V46 265-266             V47 267-268
        V48 269                 V49 270-271             V50 272-273
        V51 274                 V52 275                 V53 276-277
        V54 278-280             V55 281-282             V56 283
        V57 284                 V58 285-286             V59 287-289
        V60 290-292             V61 293-294             V62 295-296
        V63 297-299             V64 300-302             V65 303-305
        V66 306-307             V67 308-309             V68 310-311
        V69 312-314             V70 315-316             V71 317
        V72 318-320             V73 321-323             V74 324-325
        V75 326-329             V76 330-332             V77 333-335
        V78 336-338             V79 339-341             V80 342-345
        V81 346-348             V82 349-351             V83 352-354
        V84 355-357             V85 358-361             V86 362-365
        V87 366-369             V88 370-372             V89 373-375
        V90 376-379             V91 380-383             V92 384-387
        V93 388-390             V94 391-393             V95 394-398
        V96 399-400             V97 401                 V98 402-404
        V99 405-407             V100 408                V101 409-411
        V102 412-414            V103 415-416            V104 417-418
        V105 419-421            V106 422-425            V107 426-428
        V108 429-431            V109 432-434            V110 435-437
        V111 438-441            V112 442-444            V113 445-447
        V114 448-449            V115 450-451            V116 452-454
        V117 455-457            V118 458-460            V119 461-462
        V120 463-464            V121 465-468            V122 469
        V123 470                V124 471-472            V125 473-474
        V126 475                V127 476-477            V128 478-479
        V129 480                V130 481                V131 482-483
        V132 484-486            V133 487-488            V134 489-490
        V135 491-492            V136 493-494            V137 495-497
        V138 498-499            V139 500-501            V140 502-503
        V141 504-505            V142 506-508            V143 509-510
        V144 511-512            V145 513-514            V146 515
        V147 516-518            V148 519                V149 520
        V150 521-523            V151 524-525            V152 526-533
        V153 534-535            V154 536-537            V155 538-539
        V156 540-541            V157 542-543            V158 $544
        V159 $545               V160 $546               V161 $547
        V162 548                V163 549                V164 550-551
        V165 552-553            V166 554                V167 555-556
        V168 557                V169 558                V170 559
        V171 560-561            V172 562-564            V173 565
        V174 566                V175 567-568            V176 569-570
        V177 571-573            V178 574-576            V179 577-578
        V180 579-580            V181 581-583            V182 584-586
        V183 587-589            V184 590-591            V185 592-593
        V186 594-595            V187 596-598            V188 599-600
        V189 601                V190 602-603            V191 604-605
        V192 606-607            V193 608-611            V194 612-614
        V195 615-617            V196 618-620            V197 621-623
        V198 624-627            V199 628-630            V200 631-633
        V201 634-636            V202 637-639            V203 640-643
        V204 644-647            V205 648-651            V206 652-654
        V207 655-657            V208 658-661            V209 662-665
        V210 666-669            V211 670-672            V212 673-675
        V213 676-680            V214 681-682            V215 683
        V216 684-685            V217 686-687            V218 688-689
        V219 690-692            V220 693-695            V221 696-697
        V222 698-699            V223 700-702            V224 703-706
        V225 707-709            V226 710-712            V227 713-715
        V228 716-718            V229 719-722            V230 723-725
        V231 726-728            V232 729-730            V233 731-732
        V234 733-735            V235 736-738            V236 739-741
        V237 742-743            V238 744-745            V239 746-749
        V240 750                V241 751                V242 752-753
        V243 754                V244 755                V245 756-757
        V246 758-759            V247 760                V248 761
        V249 762-763            V250 764-766            V251 767-768
        V252 769-770            V253 771-772            V254 773-774
        V255 775-777            V256 778-779            V257 780-781
        V258 782-783            V259 784                V260 785-787
        V261 788-789            V262 790-791            V263 792-793
        V264 794                V265 795-797            V266 798
        V267 799                V268 800-801            V269 802-803
        V270 804-811            V271 812-813            V272 814-815
        V273 816-817            V274 818-819            V275 820-821
        V276 $822               V277 $823               V278 $824
        V279 $825               V280 826                V281 827
        V282 828-829            V283 830                V284 831
        V285 832-833            V286 834-835            V287 836
        V288 837                V289 838-839            V290 840-842
        V291 843-844            V292 845-846            V293 847-848
        V294 849-850            V295 851-853            V296 854-856
        V297 857-858            V298 859-860            V299 861-863
        V300 864-866            V301 867-869            V302 870-871
        V303 872-873            V304 874-875            V305 876-878
        V306 879-881            V307 882                V308 883-885
        V309 886-887            V310 888-889            V311 890-893
        V312 894-896            V313 897-899            V314 900-902
        V315 903-905            V316 906-909            V317 910-912
        V318 913-915            V319 916-918            V320 919-921
        V321 922-925            V322 926-929            V323 930-933
        V324 934-936            V325 937-939            V326 940-944
        V327 945-948            V328 949-952            V329 953-955
        V330 956-958            V331 959-963            V332 964-965
        V333 966                V334 967-968            V335 969-970
        V336 971-972            V337 973-975            V338 976-977
        V339 978-979            V340 980-981            V341 982-984
        V342 985-988            V343 989-991            V344 992-994
        V345 995-997            V346 998-1000           V347 1001-1004
        V348 1005-1007          V349 1008-1010          V350 1011-1012
        V351 1013-1014          V352 1015-1017          V353 1018-1020
        V354 1021-1023          V355 1024-1025          V356 1026-1027
        V357 1028-1031          V358 1032               V359 1033
        V360 1034               V361 1035               V362 1036
        V363 1037-1038          V364 1039-1040          V365 1041
        V366 1042               V367 1043-1044          V368 1045-1047
        V369 1048-1049          V370 1050-1051          V371 1052-1053
        V372 1054-1055          V373 1056-1058          V374 1059-1060
        V375 1061-1062          V376 1063-1064          V377 1065-1066
        V378 1067-1069          V379 1070-1071          V380 1072-1073
        V381 1074               V382 1075-1076          V383 1077-1079
        V384 1080               V385 1081               V386 1082-1084
        V387 1085-1086          V388 1087-1094          V389 1095-1096
        V390 1097-1098          V391 1099-1100          V392 1101-1102
        V393 1103-1104          V394 $1105              V395 $1106
        V396 $1107              V397 $1108              V398 1109
        V399 1110               V400 1111-1112          V401 1113-1114
        V402 1115               V403 1116-1117          V404 1118-1119
        V405 1120               V406 1121               V407 1122
        V408 1123-1125          V409 1126-1127          V410 1128
        V411 1129-1130          V412 1131-1132          V413 1133-1135
        V414 1136-1138          V415 1139-1140          V416 1141-1142
        V417 1143-1145          V418 1146-1148          V419 1149-1150
        V420 1151-1152          V421 1153-1154          V422 1155
        V423 1156-1158          V424 1159-1160          V425 1161
        V426 1162-1164          V427 1165-1166          V428 1167-1168
        V429 1169-1172          V430 1173-1175          V431 1176-1178
        V432 1179-1180          V433 1181-1183          V434 1184-1187
        V435 1188-1190          V436 1191-1193          V437 1194-1196
        V438 1197-1199          V439 1200-1203          V440 1204-1207
        V441 1208-1211          V442 1212-1214          V443 1215-1217
        V444 1218-1221          V445 1222-1225          V446 1226-1229
        V447 1230-1232          V448 1233-1235          V449 1236-1240
        V450 1241-1242          V451 1243               V452 1244-1245
        V453 1246-1247          V454 1248-1249          V455 1250-1252
        V456 1253-1255          V457 1256-1257          V458 1258-1259
        V459 1260-1262          V460 1263-1266          V461 1267-1269
        V462 1270-1272          V463 1273-1275          V464 1276-1278
        V465 1279-1282          V466 1283-1285          V467 1286-1288
        V468 1289-1290          V469 1291-1292          V470 1293-1295
        V471 1296-1298          V472 1299-1301          V473 1302-1303
        V474 1304-1305          V475 1306-1309          V476 1310
        V477 1311               V478 1312-1313          V479 1314-1315
        V480 1316               V481 1317-1318          V482 1319-1320
        V483 1321               V484 1322               V485 1323-1324
        V486 1325-1327          V487 1328-1329          V488 1330-1331
        V489 1332-1333          V490 1334-1335          V491 1336-1338
        V492 1339-1340          V493 1341-1342          V494 1343-1344
        V495 1345               V496 1346-1348          V497 1349-1350
        V498 1351-1352          V499 1353               V500 1354
        V501 1355-1357          V502 1358               V503 1359
        V504 1360-1362          V505 1363-1364          V506 1365-1372
        V507 1373-1374          V508 1375-1376          V509 1377-1378
        V510 1379-1380          V511 1381-1382          V512 $1383
        V513 $1384              V514 $1385              V515 $1386
        V516 1387               V517 1388               V518 1389-1390
        V519 1391-1392          V520 1393               V521 1394-1395
        V522 1396-1397          V523 1398               V524 1399
        V525 1400               V526 1401-1403          V527 1404-1405
        V528 1406               V529 1407-1408          V530 1409-1410
        V531 1411-1412          V532 1413-1415          V533 1416-1417
        V534 1418-1419          V535 1420-1422          V536 1423-1425
        V537 1426-1428          V538 1429-1430          V539 1431-1432
        V540 1433-1434          V541 1435-1437          V542 1438-1439
        V543 1440               V544 1441-1442          V545 1443-1444
        V546 1445-1446          V547 1447-1450          V548 1451-1453
        V549 1454-1456          V550 1457-1459          V551 1460-1462
        V552 1463-1466          V553 1467-1469          V554 1470-1472
        V555 1473-1475          V556 1476-1478          V557 1479-1482
        V558 1483-1486          V559 1487-1490          V560 1491-1493
        V561 1494-1496          V562 1497-1500          V563 1501-1504
        V564 1505-1508          V565 1509-1511          V566 1512-1514
        V567 1515-1519          V568 1520-1521          V569 1522
        V570 1523-1524          V571 1525-1526          V572 1527
        V573 1528-1530          V574 1531-1532          V575 1533-1534
        V576 1535-1536          V577 1537-1539          V578 1540-1543
        V579 1544-1546          V580 1547-1549          V581 1550-1552
        V582 1553-1555          V583 1556-1559          V584 1560-1562
        V585 1563-1565          V586 1566-1568          V587 1569-1570
        V588 1571-1573          V589 1574-1576          V590 1577-1579
        V591 1580-1581          V592 1582-1583          V593 1584-1587
        V594 1588-1589          V595 1590               V596 1591-1592
        V597 1593-1594          V598 1595               V599 1596-1597
        V600 1598-1599          V601 1600               V602 1601
        V603 1602-1603          V604 1604-1606          V605 1607-1608
        V606 1609-1610          V607 1611-1612          V608 1613-1614
        V609 1615-1617          V610 1618-1619          V611 1620-1621
        V612 1622-1623          V613 1624               V614 1625-1627
        V615 1628-1629          V616 1630-1631          V617 1632
        V618 1633               V619 1634-1636          V620 1637
        V621 1638               V622 1639-1641          V623 1642-1643
        V624 1644-1651          V625 1652-1653          V626 1654-1655
        V627 1656-1657          V628 1658-1659          V629 1660-1661
        V630 $1662              V631 $1663              V632 $1664
        V633 $1665              V634 1666               V635 1667
        V636 1668-1669          V637 1670-1671          V638 1672
        V639 1673-1674          V640 1675-1676          V641 1677
        V642 1678               V643 1679-1680          V644 1681-1683
        V645 1684-1685          V646 1686               V647 1687-1688
        V648 1689               V649 1690-1692          V650 1693-1695
        V651 1696-1697          V652 1698-1699          V653 1700-1702
        V654 1703-1705          V655 1706-1707          V656 1708-1709
        V657 1710-1711          V658 1712-1713          V659 1714-1716
        V660 1717-1719          V661 1720               V662 1721-1723
        V663 1724-1726          V664 1727-1728          V665 1729-1732
        V666 1733-1735          V667 1736-1738          V668 1739-1741
        V669 1742-1744          V670 1745-1748          V671 1749-1751
        V672 1752-1754          V673 1755-1758          V674 1759-1761
        V675 1762-1765          V676 1766-1769          V677 1770-1773
        V678 1774-1776          V679 1777-1779          V680 1780-1784
        V681 1785-1788          V682 1789-1792          V683 1793-1796
        V684 1797-1799          V685 1800-1804          V686 1805-1806
        V687 1807               V688 1808-1809          V689 1810-1811
        V690 1812-1813          V691 1814-1816          V692 1817-1818
        V693 1819-1820          V694 1821-1822          V695 1823-1825
        V696 1826-1829          V697 1830-1832          V698 1833-1835
        V699 1836-1838          V700 1839-1841          V701 1842-1845
        V702 1846-1848          V703 1849-1851          V704 1852-1853
        V705 1854-1855          V706 1856-1859          V707 1860-1862
        V708 1863-1865          V709 1866-1867          V710 1868-1869
        V711 1870-1873          V712 1874               V713 1875
        V714 1876-1877          V715 1878-1879          V716 1880
        V717 1881-1882          V718 1883-1884          V719 1885
        V720 1886               V721 1887-1888          V722 1889-1891
        V723 1892-1893          V724 1894-1895          V725 1896-1897
        V726 1898-1899          V727 1900-1902          V728 1903-1905
        V729 1906-1907          V730 1908-1909          V731 1910
        V732 1911-1913          V733 1914-1915          V734 1916-1917
        V735 1918               V736 1919-1920          V737 1921-1924
        V738 1925               V739 1926               V740 1927-1929
        V741 1930-1931          V742 1932-1939          V743 1940-1941
        V744 1942-1943          V745 1944-1945          V746 1946-1947
        V747 1948-1949          V748 $1950              V749 $1951
        V750 $1952              V751 $1953              V752 1954
        V753 1955               V754 1956-1957          V755 1958-1959
        V756 1960               V757 1961-1962          V758 1963-1964
        V759 1965               V760 1966               V761 1967-1968
        V762 1969-1971          V763 1972-1973          V764 1974-1975
        V765 1976-1977          V766 1978-1979          V767 1980-1982
        V768 1983-1985          V769 1986-1987          V770 1988-1990
        V771 1991-1993          V772 1994-1996          V773 1997-1998
        V774 1999-2000          V775 2001-2002          V776 2003-2004
        V777 2005-2007          V778 2008-2009          V779 2010
        V780 2011-2012          V781 2013-2014          V782 2015-2016
        V783 2017-2020          V784 2021-2023          V785 2024-2026
        V786 2027-2029          V787 2030-2032          V788 2033-2036
        V789 2037-2039          V790 2040-2042          V791 2043-2045
        V792 2046-2048          V793 2049-2052          V794 2053-2056
        V795 2057-2060          V796 2061-2063          V797 2064-2066
        V798 2067-2070          V799 2071-2074          V800 2075-2078
        V801 2079-2081          V802 2082-2084          V803 2085-2089
        V804 2090-2091          V805 2092               V806 2093-2094
        V807 2095-2096          V808 2097-2098          V809 2099-2101
        V810 2102-2103          V811 2104-2105          V812 2106-2107
        V813 2108-2110          V814 2111-2114          V815 2115-2117
        V816 2118-2120          V817 2121-2123          V818 2124-2126
        V819 2127-2130          V820 2131-2133          V821 2134-2136
        V822 2137-2138          V823 2139-2140          V824 2141-2143
        V825 2144-2146          V826 2147-2149          V827 2150-2151
        V828 2152-2153          V829 2154-2157          V830 2158
        V831 2159               V832 2160               V833 2161
        V834 2162               V835 2163-2164          V836 2165-2166
        V837 2167               V838 2168               V839 2169-2170
        V840 2171-2173          V841 2174-2175          V842 2176-2177
        V843 2178-2179          V844 2180-2181          V845 2182-2184
        V846 2185-2186          V847 2187-2188          V848 2189-2190
        V849 2191               V850 2192-2194          V851 2195-2196
        V852 2197-2198          V853 2199               V854 2200
        V855 2201-2203          V856 2204               V857 2205
        V858 2206-2208          V859 2209-2210          V860 2211-2218
        V861 2219-2220          V862 2221-2222          V863 2223-2224
        V864 2225-2226          V865 2227-2228          V866 $2229
        V867 $2230              V868 $2231              V869 $2232
        V870 2233               V871 2234               V872 2235-2236
        V873 2237-2238          V874 2239               V875 2240-2241
        V876 2242-2243          V877 2244               V878 2245
        V879 2246-2247          V880 2248-2250          V881 2251-2252
        V882 2253               V883 2254-2255          V884 2256-2257
        V885 2258-2259          V886 2260-2262          V887 2263-2264
        V888 2265-2267          V889 2268-2270          V890 2271-2273
        V891 2274-2276          V892 2277-2278          V893 2279-2280
        V894 2281-2282          V895 2283-2285          V896 2286-2287
        V897 2288               V898 2289-2291          V899 2292-2293
        V900 2294-2295          V901 2296-2299          V902 2300-2302
        V903 2303-2305          V904 2306-2308          V905 2309-2311
        V906 2312-2315          V907 2316-2318          V908 2319-2321
        V909 2322-2324          V910 2325-2327          V911 2328-2331
        V912 2332-2335          V913 2336-2339          V914 2340-2342
        V915 2343-2345          V916 2346-2349          V917 2350-2353
        V918 2354-2357          V919 2358-2360          V920 2361-2363
        V921 2364-2368          V922 2369-2370          V923 2371
        V924 2372-2373          V925 2374-2375          V926 2376
        V927 2377-2379          V928 2380-2382          V929 2383-2384
        V930 2385-2386          V931 2387-2389          V932 2390-2393
        V933 2394-2396          V934 2397-2399          V935 2400-2402
        V936 2403-2405          V937 2406-2409          V938 2410-2412
        V939 2413-2415          V940 2416-2417          V941 2418-2419
        V942 2420-2422          V943 2423-2425          V944 2426-2428
        V945 2429-2430          V946 2431-2432          V947 2433-2436
        V948 2437               V949 2438               V950 2439-2440
        V951 2441-2442          V952 2443               V953 2444-2445
        V954 2446-2447          V955 2448               V956 2449
        V957 2450-2451          V958 2452-2454          V959 2455-2456
        V960 2457-2458          V961 2459-2460          V962 2461-2462
        V963 2463-2465          V964 2466-2467          V965 2468-2469
        V966 2470-2471          V967 2472               V968 2473-2475
        V969 2476-2477          V970 2478-2479          V971 2480-2481
        V972 2482               V973 2483-2485          V974 2486
        V975 2487               V976 2488-2490          V977 2491-2492
        V978 2493-2500          V979 2501-2502          V980 2503-2504
        V981 2505-2506          V982 2507-2508          V983 2509-2510
        V984 $2511              V985 $2512              V986 $2513
        V987 $2514              V988 2515               V989 2516
        V990 2517-2518          V991 2519-2520          V992 2521
        V993 2522-2523          V994 2524-2525          V995 2526
        V996 2527               V997 2528-2529          V998 2530-2532
        V999 2533-2534          V1000 2535              V1001 2536-2537
        V1002 2538-2539         V1003 2540-2542         V1004 2543-2545
        V1005 2546-2547         V1006 2548-2549         V1007 2550-2552
        V1008 2553-2555         V1009 2556-2558         V1010 2559-2560
        V1011 2561-2562         V1012 2563-2564         V1013 2565-2567
        V1014 2568-2570         V1015 2571              V1016 2572-2574
        V1017 2575-2576         V1018 2577-2578         V1019 2579-2582
        V1020 2583-2585         V1021 2586-2588         V1022 2589-2591
        V1023 2592-2594         V1024 2595-2598         V1025 2599-2601
        V1026 2602-2604         V1027 2605-2607         V1028 2608-2610
        V1029 2611-2614         V1030 2615-2618         V1031 2619-2622
        V1032 2623-2625         V1033 2626-2628         V1034 2629-2633
        V1035 2634-2637         V1036 2638-2641         V1037 2642-2644
        V1038 2645-2647         V1039 2648-2652         V1040 2653-2654
        V1041 2655              V1042 2656-2657         V1043 2658-2659
        V1044 2660              V1045 2661-2663         V1046 2664-2665
        V1047 2666-2667         V1048 2668-2669         V1049 2670-2672
        V1050 2673-2676         V1051 2677-2679         V1052 2680-2682
        V1053 2683-2685         V1054 2686-2688         V1055 2689-2692
        V1056 2693-2695         V1057 2696-2698         V1058 2699-2701
        V1059 2702-2703         V1060 2704-2706         V1061 2707-2709
        V1062 2710-2712         V1063 2713-2714         V1064 2715-2716
        V1065 2717-2720         V1066 2721              V1067 2722
        V1068 2723              V1069 2724              V1070 2725
        V1071 2726-2727         V1072 2728-2729         V1073 2730
        V1074 2731              V1075 2732-2733         V1076 2734-2736
        V1077 2737-2738         V1078 2739-2740         V1079 2741-2742
        V1080 2743-2744         V1081 2745-2747         V1082 2748-2749
        V1083 2750-2751         V1084 2752-2753         V1085 2754
        V1086 2755-2757         V1087 2758-2759         V1088 2760-2761
        V1089 2762              V1090 2763              V1091 2764-2766
        V1092 2767              V1093 2768              V1094 2769-2771
        V1095 2772-2773         V1096 2774-2781         V1097 2782-2783
        V1098 2784-2785         V1099 2786-2787         V1100 2788-2789
        V1101 2790-2791         V1102 $2792             V1103 $2793
        V1104 $2794             V1105 $2795             V1106 2796
        V1107 2797              V1108 2798-2799         V1109 2800-2801
        V1110 2802              V1111 2803-2804         V1112 2805-2806
        V1113 2807              V1114 2808              V1115 2809-2810
        V1116 2811-2813         V1117 2814-2815         V1118 2816
        V1119 2817-2818         V1120 2819-2820         V1121 2821-2823
        V1122 2824-2826         V1123 2827-2828         V1124 2829-2830
        V1125 2831-2833         V1126 2834-2836         V1127 2837-2839
        V1128 2840-2841         V1129 2842-2843         V1130 2844-2845
        V1131 2846-2848         V1132 2849-2850         V1133 2851
        V1134 2852-2853         V1135 2854-2855         V1136 2856-2857
        V1137 2858-2861         V1138 2862-2864         V1139 2865-2867
        V1140 2868-2870         V1141 2871-2873         V1142 2874-2877
        V1143 2878-2880         V1144 2881-2883         V1145 2884-2886
        V1146 2887-2889         V1147 2890-2893         V1148 2894-2897
        V1149 2898-2901         V1150 2902-2904         V1151 2905-2907
        V1152 2908-2911         V1153 2912-2915         V1154 2916-2919
        V1155 2920-2922         V1156 2923-2925         V1157 2926-2930
        V1158 2931-2932         V1159 2933              V1160 2934-2935
        V1161 2936-2937         V1162 2938-2939         V1163 2940-2942
        V1164 2943-2945         V1165 2946-2947         V1166 2948-2949
        V1167 2950-2952         V1168 2953-2956         V1169 2957-2959
        V1170 2960-2962         V1171 2963-2965         V1172 2966-2967
        V1173 2968-2971         V1174 2972-2974         V1175 2975-2977
        V1176 2978-2979         V1177 2980-2981         V1178 2982-2984
        V1179 2985-2987         V1180 2988-2990         V1181 2991-2992
        V1182 2993-2994         V1183 2995-2998         V1184 2999
        V1185 3000              V1186 3001-3002         V1187 3003
        V1188 3004              V1189 3005-3006         V1190 3007-3008
        V1191 3009              V1192 3010-3011         V1193 3012-3013
        V1194 3014-3016         V1195 3017-3018         V1196 3019-3020
        V1197 3021-3022         V1198 3023-3024         V1199 3025-3027
        V1200 3028-3029         V1201 3030-3031         V1202 3032-3033
        V1203 3034              V1204 3035-3037         V1205 3038-3039
        V1206 3040-3041         V1207 3042              V1208 3043
        V1209 3044-3046         V1210 3047              V1211 3048
        V1212 3049-3051         V1213 3052-3053         V1214 3054-3061
        V1215 3062-3063         V1216 3064-3065         V1217 3066-3067
        V1218 3068-3069         V1219 3070-3071         V1220 $3072
        V1221 $3073             V1222 $3074             V1223 $3075
        V1224 3076              V1225 3077              V1226 3078-3079
        V1227 3080-3081         V1228 3082              V1229 3083-3084
        V1230 3085              V1231 3086              V1232 3087
        V1233 3088-3089         V1234 3090-3092         V1235 3093-3094
        V1236 3095              V1237 3096-3097         V1238 3098-3099
        V1239 3100-3102         V1240 3103-3105         V1241 3106-3107
        V1242 3108-3109         V1243 3110-3112         V1244 3113-3115
        V1245 3116-3117         V1246 3118-3119         V1247 3120-3121
        V1248 3122-3123         V1249 3124-3126         V1250 3127-3128
        V1251 3129              V1252 3130-3132         V1253 3133-3134
        V1254 3135-3136         V1255 3137-3140         V1256 3141-3143
        V1257 3144-3146         V1258 3147-3149         V1259 3150-3152
        V1260 3153-3156         V1261 3157-3159         V1262 3160-3162
        V1263 3163-3165         V1264 3166-3168         V1265 3169-3172
        V1266 3173-3176         V1267 3177-3180         V1268 3181-3183
        V1269 3184-3186         V1270 3187-3190         V1271 3191-3194
        V1272 3195-3198         V1273 3199-3201         V1274 3202-3204
        V1275 3205-3209         V1276 3210-3211         V1277 3212
        V1278 3213-3214         V1279 3215-3216         V1280 3217
        V1281 3218-3220         V1282 3221-3222         V1283 3223-3224
        V1284 3225-3226         V1285 3227-3229         V1286 3230-3233
        V1287 3234-3236         V1288 3237-3239         V1289 3240-3242
        V1290 3243-3245         V1291 3246-3249         V1292 3250-3252
        V1293 3253-3255         V1294 3256-3257         V1295 3258-3259
        V1296 3260-3262         V1297 3263-3265         V1298 3266-3268
        V1299 3269-3270         V1300 3271-3272         V1301 3273-3276
        V1302 3277              V1303 3278              V1304 3279
        V1305 3280              V1306 3281              V1307 3282-3283
        V1308 3284-3285         V1309 3286              V1310 3287
        V1311 3288-3289         V1312 3290-3292         V1313 3293-3294
        V1314 3295-3296         V1315 3297-3298         V1316 3299-3300
        V1317 3301-3303         V1318 3304-3305         V1319 3306-3307
        V1320 3308-3309         V1321 3310              V1322 3311-3313
        V1323 3314-3315         V1324 3316-3317         V1325 3318
        V1326 3319              V1327 3320-3322         V1328 3323
        V1329 3324              V1330 3325-3327         V1331 3328-3329
        V1332 3330-3337         V1333 3338-3339         V1334 3340-3341
        V1335 3342-3343         V1336 3344-3345         V1337 3346-3347
        V1338 $3348             V1339 $3349             V1340 $3350
        V1341 $3351             V1342 3352              V1343 3353
        V1344 3354-3355         V1345 3356-3357         V1346 3358
        V1347 3359-3360         V1348 3361-3362         V1349 3363
        V1350 3364-3365         V1351 3366-3367         V1352 3368-3370
        V1353 3371-3372         V1354 3373              V1355 3374-3375
        V1356 3376-3377         V1357 3378-3380         V1358 3381-3383
        V1359 3384-3385         V1360 3386-3387         V1361 3388-3390
        V1362 3391-3393         V1363 3394-3396         V1364 3397-3398
        V1365 3399-3400         V1366 3401-3402         V1367 3403-3405
        V1368 3406-3408         V1369 3409-3410         V1370 3411-3413
        V1371 3414-3416         V1372 3417-3418         V1373 3419-3422
        V1374 3423-3426         V1375 3427-3429         V1376 3430-3432
        V1377 3433-3435         V1378 3436-3440         V1379 3441-3443
        V1380 3444-3446         V1381 3447-3450         V1382 3451-3453
        V1383 3454-3458         V1384 3459-3462         V1385 3463-3466
        V1386 3467-3470         V1387 3471-3473         V1388 3474-3478
        V1389 3479-3482         V1390 3483-3486         V1391 3487-3490
        V1392 3491-3493         V1393 3494-3498         V1394 3499-3500
        V1395 3501-3502         V1396 3503-3505         V1397 3506-3508
        V1398 3509-3510         V1399 3511-3513         V1400 3514-3516
        V1401 3517-3518         V1402 3519-3520         V1403 3521-3523
        V1404 3524-3527         V1405 3528-3530         V1406 3531-3533
        V1407 3534-3536         V1408 3537-3539         V1409 3540-3543
        V1410 3544-3547         V1411 3548-3550         V1412 3551-3553
        V1413 3554-3555         V1414 3556-3559         V1415 3560-3563
        V1416 3564-3566         V1417 3567-3569         V1418 3570-3572
        V1419 3573-3577         V1420 3578              V1421 3579-3580
        V1422 3581-3582         V1423 3583-3584         V1424 3585
        V1425 3586-3587         V1426 3588-3589         V1427 3590
        V1428 3591-3592         V1429 3593-3594         V1430 3595-3598
        V1431 3599-3600         V1432 3601-3602         V1433 3603-3604
        V1434 3605-3606         V1435 3607-3610         V1436 3611-3613
        V1437 3614-3616         V1438 3617-3618         V1439 3619-3620
        V1440 3621-3624         V1441 3625-3627         V1442 3628-3630
        V1443 3631-3632         V1444 3633-3634         V1445 3635-3638
        V1446 3639              V1447 3640              V1448 3641-3643
        ;


* SAS LABEL STATEMENT;

LABEL
   V1      = 'ID CODE'
   V2      = 'NUMERIC STATE CODE'
   V3      = 'ORI CODE'
   V4      = 'GROUP NUMBER'
   V5      = 'DIVISION'
   V6      = 'YEAR'
   V7      = 'CITY SEQUENCE NUMBER'
   V8      = 'CORE CITY INDICATION'
   V9      = 'COVERED BY CODE'
   V10     = 'LAST UPDATE'
   V11     = 'FIELD OFFICE'
   V12     = 'NUMBER OF MONTHS REPORTED'
   V13     = 'AGENCY COUNT'
   V14     = 'POPULATION 1'
   V15     = 'COUNTY 1'
   V16     = 'MSA 1'
   V17     = 'POPULATION 2'
   V18     = 'COUNTY 2'
   V19     = 'MSA 2'
   V20     = 'POPULATION 3'
   V21     = 'COUNTY 3'
   V22     = 'MSA 3'
   V23     = 'FOLLOW-UP INDICATION'
   V24     = 'SPECIAL MAILING GROUP'
   V25     = 'SPECIAL MAILING ADDRESS'
   V26     = 'AGENCY NAME'
   V27     = 'AGENCY STATE NAME'
   V28     = 'MAILING ADDRESS-LINE 1'
   V29     = 'MAILING ADDRESS-LINE 2'
   V30     = 'MAILING ADDRESS-LINE 3'
   V31     = 'MAILING ADDRESS-LINE 4'
   V32     = 'ZIP CODE'
   V33     = 'JAN: MONTH INCLUDED IN'
   V34     = 'JAN: LAST UPDATE'
   V35     = 'JAN: CARD 0 TYPE'
   V36     = 'JAN: CARD 1 TYPE'
   V37     = 'JAN: CARD 2 TYPE'
   V38     = 'JAN: CARD 3 TYPE'
   V39     = 'JAN: CARD 4 TYPE'
   V40     = 'JAN: CARD 0 P/T'
   V41     = 'JAN: CARD 1 P/T'
   V42     = 'JAN: CARD 2 P/T'
   V43     = 'JAN: CARD 3 P/T'
   V44     = 'JAN: UNFOUNDED MURDER'
   V45     = 'JAN: UNFOUNDED MANSLGHTR'
   V46     = 'JAN: UNFOUNDED RAPE TOTL'
   V47     = 'JAN: UNFOUNDED FORC RAPE'
   V48     = 'JAN: UNFOUND ATMPTD RAPE'
   V49     = 'JAN: UNFOUND ROBBRY TOTL'
   V50     = 'JAN: UNFOUND GUN ROBBERY'
   V51     = 'JAN: UNFOUNDED KNIFE ROB'
   V52     = 'JAN: UNFND OTHR WEAP ROB'
   V53     = 'JAN: UNFND STRNG-ARM ROB'
   V54     = 'JAN: UNFOUND ASSLT TOTAL'
   V55     = 'JAN: UNFOUND GUN ASSLT'
   V56     = 'JAN: UNFOUND KNIFE ASSLT'
   V57     = 'JAN: UNFND OTH WPN ASLT'
   V58     = 'JAN: UNFND HND/FEET ASLT'
   V59     = 'JAN: UNFND SIMPL ASSAULT'
   V60     = 'JAN: UNFOUND BURG TOTAL'
   V61     = 'JAN: UNFOUND FORCE ENTRY'
   V62     = 'JAN: UNFND ENTRY-NO FORC'
   V63     = 'JAN: UNFND ATT BURGLARY'
   V64     = 'JAN: UNFOUND LARCNY TOTL'
   V65     = 'JAN: UF TOT MTR VHC THFT'
   V66     = 'JAN: UNFOUND AUTO THEFT'
   V67     = 'JAN: UF TRUCK/BUS THEFT'
   V68     = 'JAN: UNFND OTH VHC THEFT'
   V69     = 'JAN: UNFOUND ALL FIELDS'
   V70     = 'JAN: ACT NUM MURDER'
   V71     = 'JAN: ACT NUM MANSLGHTR'
   V72     = 'JAN: ACT NUM RAPE TOTL'
   V73     = 'JAN: ACT NUM FORC RAPE'
   V74     = 'JAN: ACT NUM ATMPTD RAPE'
   V75     = 'JAN: ACT NUM ROBBRY TOTL'
   V76     = 'JAN: ACT NUM GUN ROBBERY'
   V77     = 'JAN: ACT NUM KNIFE ROBRY'
   V78     = 'JAN: ACT NUM OTH WPN ROB'
   V79     = 'JAN: ACT NUM STR ARM ROB'
   V80     = 'JAN: ACT NUM ASSLT TOTAL'
   V81     = 'JAN: ACT NUM GUN ASSAULT'
   V82     = 'JAN: ACT NUM KNIFE ASSLT'
   V83     = 'JAN: ACT # OTH WPN ASSLT'
   V84     = 'JAN: ACT # HND/FEET ASLT'
   V85     = 'JAN: ACT # SIMPLE ASSLT'
   V86     = 'JAN: ACT # BURGLARY TOTL'
   V87     = 'JAN: ACT # FORCE ENTRY'
   V88     = 'JAN: ACT # ENTRY-NO FORC'
   V89     = 'JAN: ACT # ATT BURGLARY'
   V90     = 'JAN: ACT # LARCENY TOTAL'
   V91     = 'JAN: ACT # VHC THEFT TOT'
   V92     = 'JAN: ACT # AUTO THEFT'
   V93     = 'JAN: ACT # TRCK/BUS THFT'
   V94     = 'JAN: ACT # OTH VHC THEFT'
   V95     = 'JAN: ACT # ALL FIELDS'
   V96     = 'JAN: TOT CLR MURDER'
   V97     = 'JAN: TOT CLR MANSLGHTR'
   V98     = 'JAN: TOT CLR RAPE TOTAL'
   V99     = 'JAN: TOT CLR FORC RAPE'
   V100    = 'JAN: TOT CLR ATMPTD RAPE'
   V101    = 'JAN: TOT CLR TOTL ROBERY'
   V102    = 'JAN: TOT CLR GUN ROBBERY'
   V103    = 'JAN: TOT CLR KNIFE ROBRY'
   V104    = 'JAN: TOT CLR OTH WPN ROB'
   V105    = 'JAN: TOT CLR STR ARM ROB'
   V106    = 'JAN: TOT CLR ASSLT TOTAL'
   V107    = 'JAN: TOT CLR GUN ASSAULT'
   V108    = 'JAN: TOT CLR KNIFE ASSLT'
   V109    = 'JAN: TOT CLR OTH WPN ASLT'
   V110    = 'JAN: TOT CLR HND/FT ASLT'
   V111    = 'JAN: TOT CLR SIMPLE ASLT'
   V112    = 'JAN: TOT CLR BRGLRY TOTL'
   V113    = 'JAN: TOT CLR FORC ENTRY'
   V114    = 'JAN: TOT CLR ENTR-NO FRC'
   V115    = 'JAN: TOT CLR ATT BURGLRY'
   V116    = 'JAN: TOT CLR LARCNY TOTL'
   V117    = 'JAN:TOT CLR VHC THFT TOT'
   V118    = 'JAN: TOT CLR AUTO THEFT'
   V119    = 'JAN:TOT CLR TRCK/BS THFT'
   V120    = 'JAN:TOT CLR OTH VHC THFT'
   V121    = 'JAN: TOT CLR ALL FIELDS'
   V122    = 'JAN: CLR<18 MURDER'
   V123    = 'JAN: CLR<18 MANSLGHTR'
   V124    = 'JAN: CLR<18 RAPE TOTAL'
   V125    = 'JAN: CLR<18 FORCE RAPE'
   V126    = 'JAN: CLR<18 ATTMPTD RAPE'
   V127    = 'JAN: CLR<18 ROBBERY TOTL'
   V128    = 'JAN: CLR<18 GUN ROBBERY'
   V129    = 'JAN: CLR<18 KNIFE ROBBRY'
   V130    = 'JAN: CLR<18 OTH WPN RBRY'
   V131    = 'JAN: CLR<18 STR ARM ROB'
   V132    = 'JAN: CLR<18 ASSLT TOTAL'
   V133    = 'JAN: CLR<18 GUN ASSAULT'
   V134    = 'JAN: CLR<18 KNIFE ASSLT'
   V135    = 'JAN: CLR<18 OTH WPN ASLT'
   V136    = 'JAN: CLR<18 HND/FT ASSLT'
   V137    = 'JAN: CLR<18 SIMPLE ASSLT'
   V138    = 'JAN: CLR<18 BURGLRY TOTL'
   V139    = 'JAN: CLR<18 FORC ENTRY'
   V140    = 'JAN: CLR<18 ENTR-NO FORC'
   V141    = 'JAN: CLR<18 ATT BURGLARY'
   V142    = 'JAN: CLR<18 LARCENY TOTL'
   V143    = 'JAN: CLR<18 VHC THFT TOT'
   V144    = 'JAN: CLR<18 AUTO THEFT'
   V145    = 'JAN: CLR<18 TRCK/BS THFT'
   V146    = 'JAN: CLR<18 OTH VHC THFT'
   V147    = 'JAN: CLR<18 ALL FIELDS'
   V148    = 'JAN: OFFICRS KILL BY FEL'
   V149    = 'JAN: OFFICRS KILL BY ACC'
   V150    = 'JAN: OFFICERS ASSAULTED'
   V151    = 'FEB: MONTH INCLUDED IN'
   V152    = 'FEB: LAST UPDATE'
   V153    = 'FEB: CARD 0 TYPE'
   V154    = 'FEB: CARD 1 TYPE'
   V155    = 'FEB: CARD 2 TYPE'
   V156    = 'FEB: CARD 3 TYPE'
   V157    = 'FEB: CARD 4 TYPE'
   V158    = 'FEB: CARD 0 P/T'
   V159    = 'FEB: CARD 1 P/T'
   V160    = 'FEB: CARD 2 P/T'
   V161    = 'FEB: CARD 3 P/T'
   V162    = 'FEB: UNFOUNDED MURDER'
   V163    = 'FEB: UNFOUNDED MANSLGHTR'
   V164    = 'FEB: UNFOUNDED RAPE TOTL'
   V165    = 'FEB: UNFOUNDED FORC RAPE'
   V166    = 'FEB: UNFOUND ATMPTD RAPE'
   V167    = 'FEB: UNFOUND ROBBRY TOTL'
   V168    = 'FEB: UNFOUND GUN ROBBERY'
   V169    = 'FEB: UNFOUNDED KNIFE ROB'
   V170    = 'FEB: UNFND OTHR WEAP ROB'
   V171    = 'FEB: UNFND STRNG-ARM ROB'
   V172    = 'FEB: UNFOUND ASSLT TOTAL'
   V173    = 'FEB: UNFOUND GUN ASSLT'
   V174    = 'FEB: UNFOUND KNIFE ASSLT'
   V175    = 'FEB: UNFND OTH WPN ASLT'
   V176    = 'FEB: UNFND HND/FEET ASLT'
   V177    = 'FEB: UNFND SIMPL ASSAULT'
   V178    = 'FEB: UNFOUND BURG TOTAL'
   V179    = 'FEB: UNFOUND FORCE ENTRY'
   V180    = 'FEB: UNFND ENTRY-NO FORC'
   V181    = 'FEB: UNFND ATT BURGLARY'
   V182    = 'FEB: UNFOUND LARCNY TOTL'
   V183    = 'FEB: UF TOT MTR VHC THFT'
   V184    = 'FEB: UNFOUND AUTO THEFT'
   V185    = 'FEB: UF TRUCK/BUS THEFT'
   V186    = 'FEB: UNFND OTH VHC THEFT'
   V187    = 'FEB: UNFOUND ALL FIELDS'
   V188    = 'FEB: ACT NUM MURDER'
   V189    = 'FEB: ACT NUM MANSLGHTR'
   V190    = 'FEB: ACT NUM RAPE TOTL'
   V191    = 'FEB: ACT NUM FORC RAPE'
   V192    = 'FEB: ACT NUM ATMPTD RAPE'
   V193    = 'FEB: ACT NUM ROBBRY TOTL'
   V194    = 'FEB: ACT NUM GUN ROBBERY'
   V195    = 'FEB: ACT NUM KNIFE ROBRY'
   V196    = 'FEB: ACT NUM OTH WPN ROB'
   V197    = 'FEB: ACT NUM STR ARM ROB'
   V198    = 'FEB: ACT NUM ASSLT TOTAL'
   V199    = 'FEB: ACT NUM GUN ASSAULT'
   V200    = 'FEB: ACT NUM KNIFE ASSLT'
   V201    = 'FEB: ACT # OTH WPN ASSLT'
   V202    = 'FEB: ACT # HND/FEET ASLT'
   V203    = 'FEB: ACT # SIMPLE ASSLT'
   V204    = 'FEB: ACT # BURGLARY TOTL'
   V205    = 'FEB: ACT # FORCE ENTRY'
   V206    = 'FEB: ACT # ENTRY-NO FORC'
   V207    = 'FEB: ACT # ATT BURGLARY'
   V208    = 'FEB: ACT # LARCENY TOTAL'
   V209    = 'FEB: ACT # VHC THEFT TOT'
   V210    = 'FEB: ACT # AUTO THEFT'
   V211    = 'FEB: ACT # TRCK/BUS THFT'
   V212    = 'FEB: ACT # OTH VHC THEFT'
   V213    = 'FEB: ACT # ALL FIELDS'
   V214    = 'FEB: TOT CLR MURDER'
   V215    = 'FEB: TOT CLR MANSLGHTR'
   V216    = 'FEB: TOT CLR RAPE TOTAL'
   V217    = 'FEB: TOT CLR FORC RAPE'
   V218    = 'FEB: TOT CLR ATMPTD RAPE'
   V219    = 'FEB: TOT CLR TOTL ROBERY'
   V220    = 'FEB: TOT CLR GUN ROBBERY'
   V221    = 'FEB: TOT CLR KNIFE ROBRY'
   V222    = 'FEB: TOT CLR OTH WPN ROB'
   V223    = 'FEB: TOT CLR STR ARM ROB'
   V224    = 'FEB: TOT CLR ASSLT TOTAL'
   V225    = 'FEB: TOT CLR GUN ASSAULT'
   V226    = 'FEB: TOT CLR KNIFE ASSLT'
   V227    = 'FEB: TOT CLR OTH WPN ASLT'
   V228    = 'FEB: TOT CLR HND/FT ASLT'
   V229    = 'FEB: TOT CLR SIMPLE ASLT'
   V230    = 'FEB: TOT CLR BRGLRY TOTL'
   V231    = 'FEB: TOT CLR FORC ENTRY'
   V232    = 'FEB: TOT CLR ENTR-NO FRC'
   V233    = 'FEB: TOT CLR ATT BURGLRY'
   V234    = 'FEB: TOT CLR LARCNY TOTL'
   V235    = 'FEB:TOT CLR VHC THFT TOT'
   V236    = 'FEB: TOT CLR AUTO THEFT'
   V237    = 'FEB:TOT CLR TRCK/BS THFT'
   V238    = 'FEB:TOT CLR OTH VHC THFT'
   V239    = 'FEB: TOT CLR ALL FIELDS'
   V240    = 'FEB: CLR<18 MURDER'
   V241    = 'FEB: CLR<18 MANSLGHTR'
   V242    = 'FEB: CLR<18 RAPE TOTAL'
   V243    = 'FEB: CLR<18 FORCE RAPE'
   V244    = 'FEB: CLR<18 ATTMPTD RAPE'
   V245    = 'FEB: CLR<18 ROBBERY TOTL'
   V246    = 'FEB: CLR<18 GUN ROBBERY'
   V247    = 'FEB: CLR<18 KNIFE ROBBRY'
   V248    = 'FEB: CLR<18 OTH WPN RBRY'
   V249    = 'FEB: CLR<18 STR ARM ROB'
   V250    = 'FEB: CLR<18 ASSLT TOTAL'
   V251    = 'FEB: CLR<18 GUN ASSAULT'
   V252    = 'FEB: CLR<18 KNIFE ASSLT'
   V253    = 'FEB: CLR<18 OTH WPN ASLT'
   V254    = 'FEB: CLR<18 HND/FT ASSLT'
   V255    = 'FEB: CLR<18 SIMPLE ASSLT'
   V256    = 'FEB: CLR<18 BURGLRY TOTL'
   V257    = 'FEB: CLR<18 FORC ENTRY'
   V258    = 'FEB: CLR<18 ENTR-NO FORC'
   V259    = 'FEB: CLR<18 ATT BURGLARY'
   V260    = 'FEB: CLR<18 LARCENY TOTL'
   V261    = 'FEB: CLR<18 VHC THFT TOT'
   V262    = 'FEB: CLR<18 AUTO THEFT'
   V263    = 'FEB: CLR<18 TRCK/BS THFT'
   V264    = 'FEB: CLR<18 OTH VHC THFT'
   V265    = 'FEB: CLR<18 ALL FIELDS'
   V266    = 'FEB: OFFICRS KILL BY FEL'
   V267    = 'FEB: OFFICRS KILL BY ACC'
   V268    = 'FEB: OFFICERS ASSAULTED'
   V269    = 'MAR: MONTH INCLUDED IN'
   V270    = 'MAR: LAST UPDATE'
   V271    = 'MAR: CARD 0 TYPE'
   V272    = 'MAR: CARD 1 TYPE'
   V273    = 'MAR: CARD 2 TYPE'
   V274    = 'MAR: CARD 3 TYPE'
   V275    = 'MAR: CARD 4 TYPE'
   V276    = 'MAR: CARD 0 P/T'
   V277    = 'MAR: CARD 1 P/T'
   V278    = 'MAR: CARD 2 P/T'
   V279    = 'MAR: CARD 3 P/T'
   V280    = 'MAR: UNFOUNDED MURDER'
   V281    = 'MAR: UNFOUNDED MANSLGHTR'
   V282    = 'MAR: UNFOUNDED RAPE TOTL'
   V283    = 'MAR: UNFOUNDED FORC RAPE'
   V284    = 'MAR: UNFOUND ATMPTD RAPE'
   V285    = 'MAR: UNFOUND ROBBRY TOTL'
   V286    = 'MAR: UNFOUND GUN ROBBERY'
   V287    = 'MAR: UNFOUNDED KNIFE ROB'
   V288    = 'MAR: UNFND OTHR WEAP ROB'
   V289    = 'MAR: UNFND STRNG-ARM ROB'
   V290    = 'MAR: UNFOUND ASSLT TOTAL'
   V291    = 'MAR: UNFOUND GUN ASSLT'
   V292    = 'MAR: UNFOUND KNIFE ASSLT'
   V293    = 'MAR: UNFND OTH WPN ASLT'
   V294    = 'MAR: UNFND HND/FEET ASLT'
   V295    = 'MAR: UNFND SIMPL ASSAULT'
   V296    = 'MAR: UNFOUND BURG TOTAL'
   V297    