% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retrieve_layers.R
\name{get_raster_layer}
\alias{get_raster_layer}
\title{Pull a raster layer from a map service or image service layer of an ArcGIS
REST API}
\usage{
get_raster_layer(
  url,
  sf_object = NULL,
  bbox = NULL,
  token = "",
  clip_raster = TRUE,
  format = "png",
  transparent = TRUE,
  export_type = "map",
  add_legend = FALSE,
  ...
)
}
\arguments{
\item{url}{A character string of the url for the layer to pull}

\item{sf_object}{An \code{sf} object used for the bounding box}

\item{bbox}{Character string of the bounding box}

\item{token}{A character string of the token (if needed)}

\item{clip_raster}{Logical. Should the raster be clipped to contain only
the pixels that reside in the \code{sf_object}? By default, ArcGIS returns
some overlapping edge pixels. Setting \code{clip_raster} to TRUE (default)
will remove these using \code{\link[raster]{mask}} from the \code{raster}
package}

\item{format}{The raster format desired. Default is "png"}

\item{transparent}{Logical. Retrieve a raster with a transparent background
(TRUE, default) or not (FALSE)}

\item{export_type}{Character. Either "map" or "image" for the respective
service layer desired}

\item{add_legend}{Logical. Pull legend and match to color values
(TRUE, default) or not (FALSE)}

\item{...}{Additional arguments to pass to the ArcGIS REST API}
}
\value{
An object of type \code{RasterLayer} if \code{export_type = "map"} or
an object of type \code{RasterStack} if \code{export_type = "image"}
}
\description{
This is an internal function to pull raster layers from either a map service
or an image service of an ArcGIS REST API. This function is the engine that
drives \code{\link{get_map_layer}} and \code{\link{get_image_layer}}
}
