% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{treeMap}
\alias{treeMap}
\title{Map tree occurrences from TLS data}
\usage{
treeMap(las, method = map.hough(), merge = 0.2, positions_only = FALSE)
}
\arguments{
\item{las}{\code{\link[lidR:LAS]{LAS}} object.}

\item{method}{tree mapping algorithm. Currently available: \code{\link{map.hough}}, \code{\link{map.eigen.knn}}, \code{\link{map.eigen.voxel}} and \code{\link{map.pick}}.}

\item{merge}{\code{numeric} - parameter passed down to \code{\link{treeMap.merge}} (if \code{merge > 0}).}

\item{positions_only}{\code{logical} - if \code{TRUE} returns only a 2D tree map as a \code{data.table}.}
}
\value{
signed \code{LAS} or \code{data.table}.
}
\description{
Estimates tree occurrence regions from a \strong{normalized} point cloud. Tree mapping methods are prefixed by \code{map}.
}
\examples{
file = system.file("extdata", "pine_plot.laz", package="TreeLS")
tls = readTLS(file) \%>\%
  tlsNormalize \%>\%
  tlsSample

x = plot(tls)

map = treeMap(tls, map.hough(h_step = 1, max_h = 4))
add_treeMap(x, map, color='red')

xymap = treeMap.positions(map)
}
