% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Information.R
\name{SplitSharedInformation}
\alias{SplitSharedInformation}
\alias{SplitDifferentInformation}
\alias{TreesConsistentWithTwoSplits}
\alias{LnTreesConsistentWithTwoSplits}
\alias{Log2TreesConsistentWithTwoSplits}
\title{Shared information content of two splits}
\usage{
SplitSharedInformation(n, A1, A2 = A1)

SplitDifferentInformation(n, A1, A2 = A1)

TreesConsistentWithTwoSplits(n, A1, A2 = A1)

LnTreesConsistentWithTwoSplits(n, A1, A2 = A1)

Log2TreesConsistentWithTwoSplits(n, A1, A2 = A1)

Log2TreesConsistentWithTwoSplits(n, A1, A2 = A1)
}
\arguments{
\item{n}{Integer specifying the number of leaves}

\item{A1, A2}{Integers specifying the number of taxa in \emph{A1} and \emph{A2},
once the splits have been arranged such that \emph{A1} fully overlaps with \emph{A2}.}
}
\value{
\code{TreesConsistentWithTwoSplits()} returns the number of unrooted bifurcating
trees consistent with two splits.

\code{SplitSharedInformation()} returns the phylogenetic information that two splits
have in common, in bits.

\code{SplitDifferentInformation()} returns the amount of phylogenetic information
distinct to one of the two splits, in bits.
}
\description{
Calculate the phylogenetic information shared, or not shared, between two
splits.
See the
\href{https://ms609.github.io/TreeDist/articles/information.html}{accompanying vignette}
for definitions.
}
\details{
Split \emph{S1} divides \emph{n} leaves into two splits, \emph{A1} and \emph{B1}.
Split \emph{S2} divides the same leaves into the splits \emph{A2} and \emph{B2}.

Splits must be named such that \emph{A1} fully overlaps with \emph{A2}:
that is to say, all taxa in \emph{A1} are also in \emph{A2}, or \emph{vice versa}.
Thus, all taxa in the smaller of \emph{A1} and \emph{A2} also occur in the larger.
}
\section{Functions}{
\itemize{
\item \code{SplitDifferentInformation}: Different information between two splits.

\item \code{TreesConsistentWithTwoSplits}: Number of trees consistent with two
splits.

\item \code{LnTreesConsistentWithTwoSplits}: Natural logarithm of
\code{TreesConsistentWithTwoSplits()}.

\item \code{Log2TreesConsistentWithTwoSplits}: Base two logarithm of
\code{TreesConsistentWithTwoSplits()}.

\item \code{Log2TreesConsistentWithTwoSplits}: Base 2 logarithm of
\code{TreesConsistentWithTwoSplits()}.
}}

\examples{
  # Eight leaves, labelled A to H.
  # Split 1: ABCD|EFGH
  # Split 2: ABC|DEFGH
  # Let A1 = ABCD (four taxa), and A2 = ABC (three taxa).
  # A1 and A2 overlap (both contain ABC).
  
  TreesConsistentWithTwoSplits(n = 8, A1 = 4, A2 = 3)
  SplitSharedInformation(n = 8, A1 = 4, A2 = 3)
  SplitDifferentInformation(n = 8, A1 = 4, A2 = 3)

  # If splits are identical, then their shared information is the same
  # as the information of either split:
  SplitSharedInformation(n = 8, A1 = 3, A2 = 3)
  TreeTools::SplitInformation(3, 5)
}
\references{
\insertRef{Meila2007}{TreeDist}
}
\seealso{
Other information functions: 
\code{\link{SplitEntropy}()},
\code{\link{TreeInfo}}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{information functions}
