% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordinalbasic.R
\name{realization}
\alias{realization}
\title{An ordinal-valued tensor randomly simulated from the cumulative model.}
\usage{
realization(theta,omega)
}
\arguments{
\item{theta}{A continuous-valued tensor (latent parameters).}

\item{omega}{The cut-off points.}
}
\value{
An ordinal-valued tensor randomly simulated from the cumulative logistic model.
}
\description{
Simulate an ordinal-valued tensor from the cumulative logistic model with the parameter tensor and the cut-off points.
}
\examples{
indices <- c(10,20,30)
arr <- array(runif(prod(indices)),dim = indices)
b <- qnorm((1:3)/4)
r_sample <- realization(arr,b);r_sample
}
\references{
C. Lee and M. Wang. Tensor denoising and completion based on ordinal observations. \emph{International Conference on Machine Learning (ICML)}, 2020.
}
