% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Bolasso.R
\name{Bolasso}
\alias{Bolasso}
\title{Bolasso model.}
\description{
This function performs a Bolasso logistic regression model.
}
\usage{
Bolasso(x, y, BM = 100, kfold = 10)
}
\arguments{
\item{x}{the predictor matrix}

\item{y}{the response variable, a factor object with values of 0 and 1}

\item{BM}{the number of bootstrapping, with the default value 100}

\item{kfold}{the K-fold cross validation, with the default value 10}
}
\value{
\item{var.selected}{ Variables that are selected by the Bolasso model.}
}
\references{
[1] Bach, F.R. (2008). Bolasso: model consistent lasso estimation through the bootstrap. 
Proceedings of the 25th international conference on Machine learning. ACM. pp. 33:40.
}
\examples{
library(datasets)
head(iris)
X <- as.matrix(subset(iris,iris$Species!="setosa")[, -5])
Y <- as.factor(ifelse(subset(iris,iris$Species!="setosa")[, 5]=='versicolor', 0, 1))
# Fit a Bolasso logistic regression model.
# The BM parameter in the following example is set as small value to reduce
# the running time, however the default value is proposed.
Bolasso.fit <- Bolasso(x=X, y=Y, BM=5)
# Variables that are selected by the Bolasso model.
Bolasso.fit$var.selected
}

