% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPE.R
\name{SPEplot}
\alias{SPEplot}
\title{Plot output of \code{\link{SPE}} command.}
\usage{
SPEplot(output, xlim = NULL, ylim = NULL, main = NULL, sub = NULL,
  xlab = "Percentile Index", ylab = "Sorted Effects")
}
\arguments{
\item{output}{Output of \code{\link{SPE}} command.}

\item{xlim}{x-axis limits. Default is range of percentile index.}

\item{ylim}{y-axis limits. Default is NULL.}

\item{main}{Main title of the plot. Defualt is NULL.}

\item{sub}{Sub title of the plot. Default is NULL.}

\item{xlab}{x-axis label. Default is "Percentile Index".}

\item{ylab}{y-axis label. Default is "Sorted Effects".}
}
\description{
Plot output of \code{\link{SPE}} command.
}
\examples{
data("mortgage")
fm <- deny ~ black + p_irat + hse_inc + ccred + mcred + pubrec + ltv_med +
ltv_high + denpmi + selfemp + single + hischl
test <- SPE(fm = fm, data = mortgage, var.T = "black", method = "logit",
us = c(1:9)/10)

SPEplot(output = test, main="APE and SPE of Being Black on the prob of Mortgage Denial",
sub="Logit Model", ylab="Change in Probability")

}
