% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SampleSize.R
\name{derive_arm_names}
\alias{derive_arm_names}
\title{Derive or Assign Arm Names}
\usage{
derive_arm_names(arm_names, mu_list, verbose = FALSE)
}
\arguments{
\item{arm_names}{Optional vector of arm names.}

\item{mu_list}{Named list of means per treatment arm, from which arm names may be derived.}

\item{verbose}{Logical, if \code{TRUE}, displays messages about the derivation process.}
}
\value{
A vector of arm names.
}
\description{
This function checks if \code{arm_names} is provided. If \code{arm_names} is missing, it attempts to derive names
from \code{mu_list}. If \code{mu_list} does not contain names, it assigns default names ("A1", "A2", etc.) to each arm.
Informational messages are displayed if \code{verbose} is set to \code{TRUE}.
}
\author{
Thomas Debray \email{tdebray@fromdatatowisdom.com}
}
\keyword{internal}
