% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plots.R
\name{single.term.marginals.plot}
\alias{single.term.marginals.plot}
\title{Plot marginal distribution of single HPO terms}
\usage{
single.term.marginals.plot(hpo.terms, term.descendancy.matrix, phi.trace,
  use.clinical.names = FALSE, n = 10)
}
\arguments{
\item{hpo.terms}{R-Object representation of HPO}

\item{term.descendancy.matrix}{Logical term descendancy matrix, dimensions symmetrically labelled by terms, and where by a cell value of TRUE indicates that the row is the ancestor of the column term (in the sense of the DAG structure of the HPO}

\item{phi.trace}{Delta trace output from \code{\link{sim.reg}} function, where the rows are the values of phi at each iteration}

\item{use.clinical.names}{Logical indicating whether to use full clinical names for the terms (TRUE) or just the codes (FALSE)}

\item{n}{Maximum number of terms for plot}
}
\value{
ggplot2 plot object
}
\description{
Plots the marginal frequency of single HPO terms' inclusion in the phi parameter over the course of an application of \code{\link{sim.reg}} as bar chart.
}

