% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_functions.R
\name{RAB}
\alias{RAB}
\title{Compute the relative absolute bias of multiple estimators}
\usage{
RAB(x, percent = FALSE, unname = FALSE)
}
\arguments{
\item{x}{a \code{numeric} vector of bias estimates (see \code{\link{bias}}),
where the first element will be used as the reference}

\item{percent}{logical; change returned result to percentage by multiplying by 100?
Default is FALSE}

\item{unname}{logical; apply \code{\link{unname}} to the results to remove any variable
names?}
}
\value{
returns a \code{vector} of absolute bias ratios indicating the relative bias
  effects compared to the first estimator. Values less than 1 indicate better bias estimates
  than the first estimator, while values greater than 1 indicate worse bias than the first estimator
}
\description{
Computes the relative absolute bias given the bias estimates for multiple estimators.
}
\examples{

pop <- 1
samp1 <- rnorm(5000, 1)
bias1 <- bias(samp1, pop)
samp2 <- rnorm(5000, 1)
bias2 <- bias(samp2, pop)

RAB(c(bias1, bias2))
RAB(c(bias1, bias2), percent = TRUE) # as a percentage

}
\references{
Sigal, M. J., & Chalmers, R. P. (2016). Play it again: Teaching statistics with Monte
Carlo simulation. \code{Journal of Statistics Education, 24}(3), 136-156.
\doi{10.1080/10691898.2016.1246953}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
