% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectvarlm.R
\name{selectvarlm}
\alias{selectvarlm}
\title{Selecting variables using linear regression}
\usage{
selectvarlm(y, x, ctr.vif = 10)
}
\arguments{
\item{y}{A vector of a response variable}

\item{x}{A data.frame of explanatory variables}

\item{ctr.vif}{A number of VIF threshold}
}
\value{
A data.frame of selected variables
}
\description{
Function for selecting variables using linear regression
}
\examples{
data("obs")
data("sample_vars_sda")
obs$Cr_ppm <- log(obs$Cr_ppm)
krm <- rmvoutlier(obs$Cr_ppm)
y <- obs$Cr_ppm[-krm]
x <- sample_vars_sda$Elevation[-krm, 1:11]
sx <- selectvarlm(y, x)

}
