% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/res_local_map.R
\name{res_local_map}
\alias{res_local_map}
\title{Local Reserve Map}
\usage{
res_local_map(nerr_site_id, stations, bbox, shp, station_labs = TRUE,
  lab_loc = NULL, scale_pos = "bottomleft")
}
\arguments{
\item{nerr_site_id}{chr string of the reserve to make, first three characters used by NERRS}

\item{stations}{chr string of the reserve stations to include in the map}

\item{bbox}{a bounding box associated with the reserve. Must be in the format of c(X1, Y1, X2, Y2)}

\item{shp}{SpatialPolygons object}

\item{station_labs}{logical, should stations be labeled? Defaults to \code{TRUE}}

\item{lab_loc}{chr vector of 'R' and 'L', one letter for each station. if no \code{lab_loc} is specified then labels will default to the left.}

\item{scale_pos}{scale_pos where should the scale be placed? Options are 'topleft', 'topright', 'bottomleft', or 'bottomright'. Defaults to 'bottomleft'}
}
\value{
returns a leaflet object
}
\description{
Create a stylized reserve-level map for use with the reserve level reporting template
}
\details{
Creates a stylized, reserve-level base map. The user can specify the reserve and stations to plot. The user can also specify a bounding box. For multi-component reserves, the user should specify a bounding box that highlights the component of interest.

This function does not automatically detect conflicts between station labels. The \code{lab_loc} argument allows the user to specify "R" or "L" for each station to prevent labels from conflicting with each other.

This function is intended to be used with \code{mapview::mapshot} to generate a png for the reserve-level report.
}
\examples{
## a compact reserve
### set plotting parameters
stations <-
sampling_stations[(sampling_stations$NERR.Site.ID == 'elk'
& sampling_stations$Status == 'Active'), ]$Station.Code
to_match <- c('wq', 'met')
stns <- stations[grep(paste(to_match, collapse = '|'), stations)]
shp_fl <- elk_spatial
bounding_elk <- c(-121.810978, 36.868218, -121.708667, 36.764050)
lab_dir <- c('L', 'R', 'L', 'L', 'L')
labs <- c('ap', 'cw', 'nm', 'sm', 'vm')
pos <- 'bottomleft'

### plot
res_local_map('elk', stations = stns, bbox = bounding_elk,
lab_loc = lab_dir, scale_pos = pos, shp = shp_fl)

\donttest{
## a multicomponent reserve (show two different bounding boxes)
### set plotting parameters
stations <-
sampling_stations[(sampling_stations$NERR.Site.ID == 'cbm'
& sampling_stations$Status == 'Active'), ]$Station.Code
to_match <- c('wq', 'met')
stns <- stations[grep(paste(to_match, collapse = '|'), stations)]
shp_fl <- cbm_spatial
bounding_cbm_1 <- c(-77.393, 39.741, -75.553, 38.277)
bounding_cbm_2 <- c(-76.862006, 38.811571, -76.596508, 38.642454)
lab_dir <- c('L', 'R', 'L', 'L', 'L')
labs <- c('ap', 'cw', 'nm', 'sm', 'vm')
pos <- 'bottomleft'

### plot
res_local_map('cbm', stations = stns, bbox = bounding_cbm_1,
lab_loc = lab_dir, scale_pos = pos, shp = shp_fl)

res_local_map('cbm', stations = stns, bbox = bounding_cbm_2,
lab_loc = lab_dir, scale_pos = pos, shp = shp_fl)

}

}
\author{
Julie Padilla
}
\concept{analyze}
