% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_MMP.R
\name{do.mmp}
\alias{do.mmp}
\title{Maximum Margin Projection}
\usage{
do.mmp(X, label, ndim = 2, preprocess = c("center", "scale", "cscale",
  "decorrelate", "whiten"), numk = max(ceiling(nrow(X)/10), 2),
  alpha = 0.5, gamma = 50)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations.}

\item{label}{a length-\eqn{n} vector of data class labels.}

\item{ndim}{an integer-valued target dimension.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "center". See also \code{\link{aux.preprocess}} for more details.}

\item{numk}{the number of neighboring points.}

\item{alpha}{balancing parameter in \eqn{[0,1]}.}

\item{gamma}{weight for same-label data points with large magnitude.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
Maximum Margin Projection (MMP) is a supervised linear method that maximizes the margin
between positive and negative examples at each local neighborhood based on
same- and different-class neighborhoods depending on class labels.
}
\examples{
## generate data of 3 types with clear difference
dt1  = aux.gensamples(n=33)-100
dt2  = aux.gensamples(n=33)
dt3  = aux.gensamples(n=33)+100

## merge the data and create a label correspondingly
X      = rbind(dt1,dt2,dt3)
label  = c(rep(1,33), rep(2,33), rep(3,33))

## copy a label and let 20\% of elements be missing
nlabel = length(label)
nmissing = round(nlabel*0.20)
label_missing = label
label_missing[sample(1:nlabel, nmissing)]=NA

## compare with PCA case for full-label case
## for missing label case from MMP computation
out1 = do.pca(X, ndim=2)
out2 = do.mmp(X, label_missing, numk=10)

## visualize
par(mfrow=c(1,2))
plot(out1$Y[,1], out1$Y[,2], main="PCA projection")
plot(out2$Y[,1], out2$Y[,2], main="20\% missing labels")

}
\references{
\insertRef{xiaofei_he_learning_2008}{Rdimtools}
}
\author{
Kisung You
}
