% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonlinear_LLLE.R
\name{do.llle}
\alias{do.llle}
\title{Local Linear Laplacian Eigenmaps}
\usage{
do.llle(X, ndim = 2, preprocess = c("null", "center", "scale",
  "cscale", "decorrelate", "whiten"), K = round(nrow(X)/2),
  P = max(round(nrow(X)/4), 2), bandwidth = 0.2)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{preprocess}{an additional option for preprocessing the data.
Default is \code{"null"}. See also \code{\link{aux.preprocess}} for more details.}

\item{K}{size of near neighborhood for each data point.}

\item{P}{size of artifical neighborhood.}

\item{bandwidth}{scale parameter for Gaussian kernel. It should be in \eqn{(0,1)}.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
}
}
\description{
Local Linear Laplacian Eigenmaps is an unsupervised manifold learning method as an
extension of Local Linear Embedding (\code{\link{do.lle}}). It is claimed to be
more robust to local structure and noises. It involves the concept of
artificial neighborhood in constructing the adjacency graph for reconstruction of
the approximated manifold.
}
\examples{
\dontrun{
## generate 12-dim data embedded in 72-dim.
X = aux.gensamples(n=200, dname="R12in72")

# see the effect bandwidth
out1 = do.llle(X, bandwidth=0.1)
out2 = do.llle(X, bandwidth=0.5)
out3 = do.llle(X, bandwidth=0.9)

# visualize the results
par(mfrow=c(1,3))
plot(out1$Y[,1],out1$Y[,2],main="bandwidth=0.1")
plot(out2$Y[,1],out2$Y[,2],main="bandwidth=0.5")
plot(out3$Y[,1],out3$Y[,2],main="bandwidth=0.9")
}

}
\references{
\insertRef{liu_local_2016}{Rdimtools}
}
\seealso{
\code{\link{do.lle}}
}
\author{
Kisung You
}
