% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xml.R
\name{s_attr_is_descendent}
\alias{s_attr_is_descendent}
\alias{s_attr_is_sibling}
\alias{s_attr_relationship}
\title{Explore XML structure of CWB corpus}
\usage{
s_attr_is_descendent(
  x,
  y,
  corpus,
  registry = Sys.getenv("CORPUS_REGISTRY"),
  sample = NULL
)

s_attr_is_sibling(x, y, corpus, registry = Sys.getenv("CORPUS_REGISTRY"))

s_attr_relationship(x, y, corpus, registry = Sys.getenv("CORPUS_REGISTRY"))
}
\arguments{
\item{x}{A structural attribute, stated as length-one \code{character} vector.}

\item{y}{Another structural attribute, stated as length-one \code{character} vector.}

\item{corpus}{A corpus ID (length-one \code{character} vector).}

\item{registry}{The directory with the registry file for the corpus.}

\item{sample}{An \code{integer} vector with a sample number of strucs to evaluate.
Evaluating only a sample may be an efficient choice for large corpora. If \code{NULL}
(default), all strucs are evaluated.}
}
\description{
The data format of the Corpus Workbench (CWB) allows nested XML as import
data. Auxiliary functions assist detecting whether two structural attributes
are nested or at the same level (i.e. defining the same regions).
}
\details{
\code{s_attr_is_descendent()} will evaluate whether s_attribute \code{x} is
a child of s_attribute \code{y}. The return value is \code{TRUE} (a single \code{logical}
value)  if all regions defined by \code{x} are within the regions defined by \code{y}.
If not, \code{FALSE} is returned. The return values is also \code{FALSE} if all regions
of \code{x} and \code{y} are idential. Attributes will be siblings in this case,
and not in an ancestor-sibling relationship.

\code{s_attr_is_sibling()} will test whether the regions defined for
structural attribute \code{x} and structural attribute \code{y} are identical. If
yes, \code{TRUE} is returned, assuming that both attributes are at the same
level (siblings). If not, \code{FALSE} is returned.

\code{s_attr_relationship()} will return \code{0} if s-attributes \code{x} and \code{y}
are siblings in the sense that they define identical regions. The return
value is \code{0} if \code{x} is an ancestor of \code{y} and \code{1} if \code{x} is a descencdent
of \code{y}.
}
\examples{
s_attr_is_descendent("id", "places", corpus = "REUTERS", registry = get_tmp_registry())
s_attr_is_sibling(x = "id", y = "places", corpus = "REUTERS", registry = get_tmp_registry())
s_attr_is_sibling(x = "id", y = "places", corpus = "REUTERS", registry = get_tmp_registry())
}
