dataonHelp<-function(){
	initializeDialog(title="Sample Size Dataset Help", window=topp)
	topp<-tkframe(topp, borderwidth=20)
	fontHeading <- tkfont.create(family="times",size=12,weight="bold",slant="italic")
	tkgrid(tklabel(topp, text="Primary Sampling Unit Dataset", font=fontHeading), sticky="w")
	tkgrid(tklabel(topp, text="The Primary Sampling Unit (PSU) dataset should contain a list of all the PSUs and their sample sizes and inclusion probabilities. If second stage stratifications (domains) are used, the dataset should have one line for each domain in each PSU.", wraplength=400, justify="left"), sticky="w")
	tkblank(topp)
	tkgrid(tklabel(topp, text="Stratification Dataset", font=fontHeading), sticky="w")
	tkgrid(tklabel(topp, text="The Stratification dataset should contain a summary list of the Strata and their sizes. The dataset should have one line per strata.", wraplength=400, justify="left"), sticky="w")
	tkblank(topp)
	tkgrid(topp)
	tkgrab.set(topp)
        tkfocus(topp)
	}

PSUonHelp<-function(){
	initializeDialog(title="Sample Size PSU Help", window=topp)
	topp<-tkframe(topp, borderwidth=20)
	fontHeading <- tkfont.create(family="times",size=12,weight="bold",slant="italic")
	tkgrid(tklabel(topp, text="Primary Sampling Unit (PSU) Variable", font=fontHeading), sticky="w")
	tkgrid(tklabel(topp, text="The PSU variable should contain a unique identifying number or name for each Primary Sampling Unit.", wraplength=400, justify="left"), sticky="w")
	tkblank(topp)
	tkgrid(tklabel(topp, text="PSU Size Variable", font=fontHeading), sticky="w")
	tkgrid(tklabel(topp, text="The SIZE variable should list the size of each PSU. This may be in terms of the population size or the number of addresses/dwellings in each Primary Sampling Unit.", wraplength=400, justify="left"), sticky="w")
	tkblank(topp)
	tkgrid(tklabel(topp, text="Stage 1 Stratification Variable", font=fontHeading), sticky="w")
	tkgrid(tklabel(topp, text="The Stage 1 Strata variable should contain a unique identifying number or name for each STRATUM.", wraplength=400, justify="left"), sticky="w")
	tkblank(topp)
	tkgrid(tklabel(topp, text="Stage 2 Stratification Variable", font=fontHeading), sticky="w")
	tkgrid(tklabel(topp, text="Stage 2 Stratification is when the Secondary Sampling Units (People/households/addresses) are stratified by for example gender, age, household size etc. The variables selected should contain a break-down of the size of each domain within the PSU. ", wraplength=400, justify="left"), sticky="w")
	tkblank(topp)
	tkgrid(tklabel(topp, text="Stage 2 Stratification Allocation", font=fontHeading), sticky="w")
	tkgrid(tklabel(topp, text="The Stage 2 Stratification sample size can be allocated proportional to the size of the popoulation within the strata or with a fixed, equal sample size for all the strata.", wraplength=400, justify="left"), sticky="w")
	tkblank(topp)
	tkgrid(topp)
	tkgrab.set(topp)
        tkfocus(topp)
	}

strataonHelp<-function(){
	initializeDialog(title="Sample Size Stratification Help", window=topp)
	topp<-tkframe(topp, borderwidth=20)
	fontHeading <- tkfont.create(family="times",size=12,weight="bold",slant="italic")
	tkgrid(tklabel(topp, text="Stage 1 Stratification Variable", font=fontHeading), sticky="w")
	tkgrid(tklabel(topp, text="The Stage 1 Stratification variable should contain a unique identifying number or name for each STRATUM. This should be identical to that given in the PSU datasets.", wraplength=400, justify="left"), sticky="w")
	tkblank(topp)
	tkgrid(tklabel(topp, text="Stage 1 Sample Size Variable", font=fontHeading), sticky="w")
	tkgrid(tklabel(topp, text="The STAGE 1 SAMPLE SIZE variable is a list of the number of PRIMARY SAMPLING UNITS to be sampled in each stratum.", wraplength=400, justify="left"), sticky="w")
	tkblank(topp)
	tkgrid(tklabel(topp, text="Stage 1 Strata Sample Sizes Variable", font=fontHeading), sticky="w")
	tkgrid(tklabel(topp, text="The Stage 1 STRATA SAMPLE SIZES variable is a list of the number of INDIVIDUAL Units (SSUs) to be sampled in each stratum.", wraplength=400, justify="left"), sticky="w")
	tkblank(topp)	
	tkgrid(tklabel(topp, text="Cost Variables", font=fontHeading), sticky="w")
	tkgrid(tklabel(topp, text="In the absence of a Stage 1 sample size variable, optimal sizes are calculatedusing cost and variance variables. Cost variables are used to adjust sample sizes to minimise the overall cost of sampling. The participant cost refers to the cost associated with asking an individual participant to participate in the survey. The PSU cost refers to the cost associated with setting up a Primary Sampling Unit for sampling.", wraplength=400, justify="left"), sticky="w")
	tkblank(topp)
	tkgrid(tklabel(topp, text="Mean and Variance Variables", font=fontHeading), sticky="w")
	tkgrid(tklabel(topp, text="The mean and variance of a key variable are used to adjust sample sizes to minimise the overall variance. Only one variable can be used for the optimisation, however the sample size process may be repeated for other variables", wraplength=400, justify="left"), sticky="w")
	tkblank(topp)
	tkgrid(tklabel(topp, text="Total sample size", font=fontHeading), sticky="w")
	tkgrid(tklabel(topp, text="The total sample size refers to the number of Secondary sample units (people/households/addresses) to select. Depending on the sampling scheme, the actual number may vary slightly according to which PSUs are selected in stage 1.", wraplength=400, justify="left"), sticky="w")
	tkblank(topp)
	tkgrid(tklabel(topp, text="Distribution among strata", font=fontHeading), sticky="w")
	tkgrid(tklabel(topp, text="The sample may be distributed among the stage 1 Strata proportional to the size of the strata, proportional but with a minimum number in each strata, with a fixed, equal size in each strata or using an optimal number to minimise the variance of a particular variable.", wraplength=400, justify="left"), sticky="w")
	tkblank(topp)
	tkgrid(topp)
	tkgrab.set(topp)
        tkfocus(topp)
	}


Stage1onHelp<-function(){
	initializeDialog(title="Stage 1 Sampling Help", window=topp)
	topp<-tkframe(topp, borderwidth=20)
	fontHeading <- tkfont.create(family="times",size=12,weight="bold",slant="italic")
	tkgrid(tklabel(topp, text="Primary Sampling Unit Dataset", font=fontHeading), sticky="w")
	tkgrid(tklabel(topp, text="The Primary Sampling Unit (PSU) dataset should contain a list of all the PSUs and their sample sizes and inclusion probabilities. If second stage stratifications (domains) are used, the dataset should have one line for each domain in each PSU.", wraplength=400, justify="left"), sticky="w")
	tkblank(topp)
	tkgrid(tklabel(topp, text="Primary Sampling Unit Variable", font=fontHeading), sticky="w")
	tkgrid(tklabel(topp, text="The PSU variable should contain a unique identifying number or name for each Primary Sampling Unit.", wraplength=400, justify="left"), sticky="w")
	tkblank(topp)
	tkgrid(tklabel(topp, text="Stratification Variable", font=fontHeading), sticky="w")
	tkgrid(tklabel(topp, text="The STRATA variable should contain a unique identifying number or name for each STRATUM.", wraplength=400, justify="left"), sticky="w")
	tkblank(topp)
	tkgrid(tklabel(topp, text="First Stage Inclusion Probabilbilty Variable", font=fontHeading), sticky="w")
	tkgrid(tklabel(topp, text="The first stage inclusion probability is how likely each PSU is to being selected for sampling in the first stage. This can be calculated with the sample sizes option in the RcmdrPluing.EHES package.", wraplength=400, justify="left"), sticky="w")
	tkblank(topp)
	tkgrid(topp)
	tkgrab.set(topp)
        tkfocus(topp)
	}

Stage2onHelp<-function(){
	initializeDialog(title="Stage 2 Sampling Help", window=topp)
	topp<-tkframe(topp, borderwidth=20)
	fontHeading <- tkfont.create(family="times",size=12,weight="bold",slant="italic")
	tkgrid(tklabel(topp, text="Primary Sampling Unit Variable", font=fontHeading), sticky="w")
	tkgrid(tklabel(topp, text="The PSU variable should contain a unique identifying number or name for each Primary Sampling Unit.", wraplength=400, justify="left"), sticky="w")
	tkblank(topp)
	tkgrid(tklabel(topp, text="Stratification Variable", font=fontHeading), sticky="w")
	tkgrid(tklabel(topp, text="The STRATA variable should contain a unique identifying number or name for each STRATUM. If you are sampling every PSU, this is called a one stage sample and the dataset does not need a strata variable.In the case of a one stage sample, select the one stage sample check box.", wraplength=400, justify="left"), sticky="w")
	tkblank(topp)
	tkgrid(tklabel(topp, text="Stage 2 Stratification Variable", font=fontHeading), sticky="w")
	tkgrid(tklabel(topp, text="The Stage 2 Stratification Variable is for sex-age (domain) groups in sampling individuals.", wraplength=400, justify="left"), sticky="w")
	tkblank(topp)
	tkgrid(tklabel(topp, text="Second Stage Inclusion Probabilbilty Variable", font=fontHeading), sticky="w")
	tkgrid(tklabel(topp, text="The second stage inclusion probability is how likely each individual person or address is to be selected in the sample. This can be calculated with the sample sizes option in the RcmdrPluing.EHES package.", wraplength=400, justify="left"), sticky="w")
	tkblank(topp)
	tkgrid(tklabel(topp, text="Create ID numbers", font=fontHeading), sticky="w")
	tkgrid(tklabel(topp, text="Choose this option to create an ID number for all the selected participants in the survey. The ID number is encoded with a control digit using the dihedral group of order 10 addition and can be checked later using the CHECK ENCODED NUMBERS option.", wraplength=400, justify="left"), sticky="w")
	tkgrid(topp)
	tkgrab.set(topp)
        tkfocus(topp)
	}

