% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EMLeastSquaresClassifier.R
\name{EMLeastSquaresClassifier}
\alias{EMLeastSquaresClassifier}
\title{An Expectation Maximization like approach to Semi-Supervised Least Squares Classification}
\usage{
EMLeastSquaresClassifier(X, y, X_u, x_center = FALSE, scale = FALSE,
  verbose = FALSE, intercept = TRUE, lambda = 0, eps = 1e-09,
  y_scale = FALSE, alpha = 1, beta = 1, init = "supervised",
  method = "block", objective = "label", save_all = FALSE,
  max_iter = 1000)
}
\arguments{
\item{X}{matrix; Design matrix for labeled data}

\item{y}{factor or integer vector; Label vector}

\item{X_u}{matrix; Design matrix for unlabeled data}

\item{x_center}{logical;  Should the features be centered?}

\item{scale}{Should the features be normalized? (default: FALSE)}

\item{verbose}{logical; Controls the verbosity of the output}

\item{intercept}{logical; Whether an intercept should be included}

\item{lambda}{numeric; L2 regularization parameter}

\item{eps}{Stopping criterion for the minimization}

\item{y_scale}{logical; whether the target vector should be centered}

\item{alpha}{numeric; the mixture of the new responsibilities and the old in each iteration of the algorithm (default: 1)}

\item{beta}{numeric; value between 0 and 1 that determines how much to move to the new solution from the old solution at each step of the block gradient descent}

\item{init}{objective character; "random" for random initialization of labels, "supervised" to use supervised solution as initialization or a numeric vector with a coefficient vector to use to calculate the initialization}

\item{method}{character; one of "block", for block gradient descent or "simple" for LBFGS optimization (default="block")}

\item{objective}{character; "responsibility" for hard label self-learning or "label" for soft-label self-learning}

\item{save_all}{logical; saves all classifiers trained during block gradient descent}

\item{max_iter}{integer; maximum number of iterations}

\item{...}{Additional Parameters, Not used}
}
\description{
As studied in Krijthe & Loog (2016), minimizes the total loss of the labeled and unlabeled objects by finding the weight vector and labels that minimize the total loss. The algorithm proceeds similar to EM, by subsequently applying a weight update and a soft labeling of the unlabeled objects. This is repeated until convergence.
}
\details{
By default (method="block") the weights of the classifier are updated, after which the unknown labels are updated. method="simple" uses LBFGS to do this update simultaneously. Objective="responsibility" corresponds to the responsibility based, instead of the label based, objective function in Krijthe & Loog (2016), which is equivalent to hard-label self-learning.
}
\examples{
library(dplyr)
library(ggplot2)

set.seed(1)

df <- generate2ClassGaussian(200,d=2,var=0.2) \%>\% 
 add_missinglabels_mar(Class~.,prob = 0.96)

# Soft-label vs. hard-label self-learning
classifiers <- list(
 "Supervised"=LeastSquaresClassifier(Class~.,df),
 "EM-Soft"=EMLeastSquaresClassifier(Class~.,df,objective="label"),
 "EM-Hard"=EMLeastSquaresClassifier(Class~.,df,objective="responsibility")
)

df \%>\% 
 ggplot(aes(x=X1,y=X2,color=Class)) +
 geom_point() +
 coord_equal() +
 scale_y_continuous(limits=c(-2,2)) +
 stat_classifier(aes(linetype=..classifier..),
                 classifiers=classifiers)
                 
}
\references{
Krijthe, J.H. & Loog, M., 2016. Optimistic Semi-supervised Least Squares Classification. In International Conference on Pattern Recognition (To Appear).
}

