% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\docType{methods}
\name{postgres-tables}
\alias{postgres-tables}
\alias{dbWriteTable,PqConnection,character,data.frame-method}
\alias{sqlData,PqConnection-method}
\alias{dbReadTable,PqConnection,character-method}
\alias{dbListTables,PqConnection-method}
\alias{dbExistsTable,PqConnection,character-method}
\alias{dbRemoveTable,PqConnection,character-method}
\alias{dbListFields,PqConnection,character-method}
\title{Convenience functions for reading/writing DBMS tables}
\usage{
\S4method{dbWriteTable}{PqConnection,character,data.frame}(conn, name, value,
  ..., row.names = FALSE, overwrite = FALSE, append = FALSE,
  field.types = NULL, temporary = FALSE, copy = TRUE)

\S4method{sqlData}{PqConnection}(con, value, row.names = FALSE, copy = TRUE)

\S4method{dbReadTable}{PqConnection,character}(conn, name, ...,
  check.names = TRUE, row.names = FALSE)

\S4method{dbListTables}{PqConnection}(conn, ...)

\S4method{dbExistsTable}{PqConnection,character}(conn, name, ...)

\S4method{dbRemoveTable}{PqConnection,character}(conn, name, ...)

\S4method{dbListFields}{PqConnection,character}(conn, name, ...)
}
\arguments{
\item{conn}{a \linkS4class{PqConnection} object, produced by
\code{\link[DBI:dbConnect]{DBI::dbConnect()}}}

\item{name}{a character string specifying a table name. Names will be
automatically quoted so you can use any sequence of characters, not
just any valid bare table name.}

\item{value}{A data.frame to write to the database.}

\item{...}{Other arguments used by individual methods.}

\item{row.names}{Either \code{TRUE}, \code{FALSE}, \code{NA} or a string.

If \code{TRUE}, always translate row names to a column called "row_names".
If \code{FALSE}, never translate row names. If \code{NA}, translate
rownames only if they're a character vector.

A string is equivalent to \code{TRUE}, but allows you to override the
default name.

For backward compatibility, \code{NULL} is equivalent to \code{FALSE}.}

\item{overwrite}{a logical specifying whether to overwrite an existing table
or not. Its default is \code{FALSE}.}

\item{append}{a logical specifying whether to append to an existing table
in the DBMS. Its default is \code{FALSE}.}

\item{field.types}{character vector of named SQL field types where
the names are the names of new table's columns. If missing, types inferred
with \code{\link[DBI:dbDataType]{DBI::dbDataType()}}).}

\item{temporary}{If \code{TRUE}, will generate a temporary table statement.}

\item{copy}{If \code{TRUE}, serializes the data frame to a single string
and uses \code{COPY name FROM stdin}. This is fast, but not supported by
all postgres servers (e.g. Amazon's redshift). If \code{FALSE}, generates
a single SQL string. This is slower, but always supported.

RPostgres does not use parameterised queries to insert rows because
benchmarks revealed that this was considerably slower than using a single
SQL string.}

\item{con}{A database connection.}

\item{check.names}{If \code{TRUE}, the default, column names will be
converted to valid R identifiers.}
}
\description{
Convenience functions for reading/writing DBMS tables
}
\examples{
# For running the examples on systems without PostgreSQL connection:
run <- postgresHasDefault()

library(DBI)
if (run) con <- dbConnect(RPostgres::Postgres())
if (run) dbListTables(con)
if (run) dbWriteTable(con, "mtcars", mtcars, temporary = TRUE)
if (run) dbReadTable(con, "mtcars")

if (run) dbListTables(con)
if (run) dbExistsTable(con, "mtcars")

# A zero row data frame just creates a table definition.
if (run) dbWriteTable(con, "mtcars2", mtcars[0, ], temporary = TRUE)
if (run) dbReadTable(con, "mtcars2")

if (run) dbDisconnect(con)
}
