% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_cascades.R
\name{simulate_rnd_cascades}
\alias{simulate_rnd_cascades}
\title{Simulate a set of random cascades}
\usage{
simulate_rnd_cascades(n_cascades, n_nodes, id_class = "character")
}
\arguments{
\item{n_cascades}{Number of cascades to generate.}

\item{n_nodes}{Number of nodes in the system.}

\item{id_class}{One of \code{c("character", "factor", "numeric")}. What class
should the cascade_id indicator be.}
}
\value{
A data frame containing (in order of columns) node ids, 
    event time and cascade identifier.
}
\description{
Simulate random cascades, for testing and demonstration purposes. No actual 
diffusion model is underlying these cascades.
}
\examples{

df <- simulate_rnd_cascades(10, n_nodes = 20)
head(df)

}
